/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtMeshMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <avtTypes.h>
#include <avtTypes.h>
#include <PyNameschemeAttributes.h>
#include <avtTypes.h>
#include <avtTypes.h>

// ****************************************************************************
// Module: PyavtMeshMetaData
//
// Purpose: 
//   Contains mesh metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtMeshMetaData.
//
struct avtMeshMetaDataObject
{
    PyObject_HEAD
    avtMeshMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtMeshMetaData(int);

std::string
PyavtMeshMetaData_ToString(const avtMeshMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->name.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginalName = \"%s\"\n", prefix, atts->originalName.c_str());
    str += tmpStr;
    if(atts->validVariable)
        SNPRINTF(tmpStr, 1000, "%svalidVariable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svalidVariable = 0\n", prefix);
    str += tmpStr;
    const char *meshType_names = "AVT_RECTILINEAR_MESH, AVT_CURVILINEAR_MESH, AVT_UNSTRUCTURED_MESH, AVT_POINT_MESH, AVT_SURFACE_MESH, AVT_CSG_MESH, AVT_AMR_MESH, AVT_UNKNOWN_MESH";
    if(atts->meshType == AVT_RECTILINEAR_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_RECTILINEAR_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_CURVILINEAR_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_CURVILINEAR_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_UNSTRUCTURED_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_UNSTRUCTURED_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_POINT_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_POINT_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_SURFACE_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_SURFACE_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_CSG_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_CSG_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else if(atts->meshType == AVT_AMR_MESH)
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_AMR_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%smeshType = %sAVT_UNKNOWN_MESH  # %s\n", prefix, prefix, meshType_names);
        str += tmpStr;
    }

    const char *meshCoordType_names = "AVT_XY, AVT_RZ, AVT_ZR";
    if(atts->meshCoordType == AVT_XY)
    {
        SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sAVT_XY  # %s\n", prefix, prefix, meshCoordType_names);
        str += tmpStr;
    }
    else if(atts->meshCoordType == AVT_RZ)
    {
        SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sAVT_RZ  # %s\n", prefix, prefix, meshCoordType_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%smeshCoordType = %sAVT_ZR  # %s\n", prefix, prefix, meshCoordType_names);
        str += tmpStr;
    }

    SNPRINTF(tmpStr, 1000, "%scellOrigin = %d\n", prefix, atts->cellOrigin);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sspatialDimension = %d\n", prefix, atts->spatialDimension);
    str += tmpStr;
    if(atts->hasLogicalBounds)
        SNPRINTF(tmpStr, 1000, "%shasLogicalBounds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasLogicalBounds = 0\n", prefix);
    str += tmpStr;
    {   const int *logicalBounds = atts->logicalBounds;
        SNPRINTF(tmpStr, 1000, "%slogicalBounds = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", logicalBounds[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->hasNumberCells)
        SNPRINTF(tmpStr, 1000, "%shasNumberCells = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasNumberCells = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumberCells = %d\n", prefix, atts->numberCells);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stopologicalDimension = %d\n", prefix, atts->topologicalDimension);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxUnits = \"%s\"\n", prefix, atts->xUnits.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syUnits = \"%s\"\n", prefix, atts->yUnits.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%szUnits = \"%s\"\n", prefix, atts->zUnits.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxLabel = \"%s\"\n", prefix, atts->xLabel.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syLabel = \"%s\"\n", prefix, atts->yLabel.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%szLabel = \"%s\"\n", prefix, atts->zLabel.c_str());
    str += tmpStr;
    if(atts->hasSpatialExtents)
        SNPRINTF(tmpStr, 1000, "%shasSpatialExtents = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasSpatialExtents = 0\n", prefix);
    str += tmpStr;
    {   const double *minSpatialExtents = atts->minSpatialExtents;
        SNPRINTF(tmpStr, 1000, "%sminSpatialExtents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", minSpatialExtents[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *maxSpatialExtents = atts->maxSpatialExtents;
        SNPRINTF(tmpStr, 1000, "%smaxSpatialExtents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", maxSpatialExtents[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%snumBlocks = %d\n", prefix, atts->numBlocks);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sblockOrigin = %d\n", prefix, atts->blockOrigin);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sblockPieceName = \"%s\"\n", prefix, atts->blockPieceName.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sblockTitle = \"%s\"\n", prefix, atts->blockTitle.c_str());
    str += tmpStr;
    {   const stringVector &blockNames = atts->blockNames;
        SNPRINTF(tmpStr, 1000, "%sblockNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < blockNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", blockNames[i].c_str());
            str += tmpStr;
            if(i < blockNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "blockNameScheme.";
        str += PyNameschemeAttributes_ToString(&atts->blockNameScheme, objPrefix.c_str());
    }
    SNPRINTF(tmpStr, 1000, "%snumGroups = %d\n", prefix, atts->numGroups);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sgroupOrigin = %d\n", prefix, atts->groupOrigin);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sgroupPieceName = \"%s\"\n", prefix, atts->groupPieceName.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sgroupTitle = \"%s\"\n", prefix, atts->groupTitle.c_str());
    str += tmpStr;
    {   const stringVector &groupNames = atts->groupNames;
        SNPRINTF(tmpStr, 1000, "%sgroupNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < groupNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", groupNames[i].c_str());
            str += tmpStr;
            if(i < groupNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &groupIds = atts->groupIds;
        SNPRINTF(tmpStr, 1000, "%sgroupIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < groupIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", groupIds[i]);
            str += tmpStr;
            if(i < groupIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &groupIdsBasedOnRange = atts->groupIdsBasedOnRange;
        SNPRINTF(tmpStr, 1000, "%sgroupIdsBasedOnRange = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < groupIdsBasedOnRange.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", groupIdsBasedOnRange[i]);
            str += tmpStr;
            if(i < groupIdsBasedOnRange.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->disjointElements)
        SNPRINTF(tmpStr, 1000, "%sdisjointElements = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisjointElements = 0\n", prefix);
    str += tmpStr;
    const char *containsGhostZones_names = "AVT_NO_GHOSTS, AVT_HAS_GHOSTS, AVT_CREATED_GHOSTS, AVT_MAYBE_GHOSTS";
    if(atts->containsGhostZones == AVT_NO_GHOSTS)
    {
        SNPRINTF(tmpStr, 1000, "%scontainsGhostZones = %sAVT_NO_GHOSTS  # %s\n", prefix, prefix, containsGhostZones_names);
        str += tmpStr;
    }
    else if(atts->containsGhostZones == AVT_HAS_GHOSTS)
    {
        SNPRINTF(tmpStr, 1000, "%scontainsGhostZones = %sAVT_HAS_GHOSTS  # %s\n", prefix, prefix, containsGhostZones_names);
        str += tmpStr;
    }
    else if(atts->containsGhostZones == AVT_CREATED_GHOSTS)
    {
        SNPRINTF(tmpStr, 1000, "%scontainsGhostZones = %sAVT_CREATED_GHOSTS  # %s\n", prefix, prefix, containsGhostZones_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%scontainsGhostZones = %sAVT_MAYBE_GHOSTS  # %s\n", prefix, prefix, containsGhostZones_names);
        str += tmpStr;
    }

    if(atts->containsOriginalCells)
        SNPRINTF(tmpStr, 1000, "%scontainsOriginalCells = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontainsOriginalCells = 0\n", prefix);
    str += tmpStr;
    if(atts->containsOriginalNodes)
        SNPRINTF(tmpStr, 1000, "%scontainsOriginalNodes = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontainsOriginalNodes = 0\n", prefix);
    str += tmpStr;
    if(atts->containsGlobalNodeIds)
        SNPRINTF(tmpStr, 1000, "%scontainsGlobalNodeIds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontainsGlobalNodeIds = 0\n", prefix);
    str += tmpStr;
    if(atts->containsGlobalZoneIds)
        SNPRINTF(tmpStr, 1000, "%scontainsGlobalZoneIds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontainsGlobalZoneIds = 0\n", prefix);
    str += tmpStr;
    const char *loadBalanceScheme_names = "LOAD_BALANCE_UNKNOWN, LOAD_BALANCE_CONTIGUOUS_BLOCKS_TOGETHER, LOAD_BALANCE_STRIDE_ACROSS_BLOCKS, LOAD_BALANCE_RANDOM_ASSIGNMENT, LOAD_BALANCE_DBPLUGIN_DYNAMIC, LOAD_BALANCE_RESTRICTED, LOAD_BALANCE_ABSOLUTE";
    if(atts->loadBalanceScheme == LOAD_BALANCE_UNKNOWN)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_UNKNOWN  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else if(atts->loadBalanceScheme == LOAD_BALANCE_CONTIGUOUS_BLOCKS_TOGETHER)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_CONTIGUOUS_BLOCKS_TOGETHER  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else if(atts->loadBalanceScheme == LOAD_BALANCE_STRIDE_ACROSS_BLOCKS)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_STRIDE_ACROSS_BLOCKS  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else if(atts->loadBalanceScheme == LOAD_BALANCE_RANDOM_ASSIGNMENT)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_RANDOM_ASSIGNMENT  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else if(atts->loadBalanceScheme == LOAD_BALANCE_DBPLUGIN_DYNAMIC)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_DBPLUGIN_DYNAMIC  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else if(atts->loadBalanceScheme == LOAD_BALANCE_RESTRICTED)
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_RESTRICTED  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%sloadBalanceScheme = %sLOAD_BALANCE_ABSOLUTE  # %s\n", prefix, prefix, loadBalanceScheme_names);
        str += tmpStr;
    }

    if(atts->nodesAreCritical)
        SNPRINTF(tmpStr, 1000, "%snodesAreCritical = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snodesAreCritical = 0\n", prefix);
    str += tmpStr;
    {   const float *unitCellVectors = atts->unitCellVectors;
        SNPRINTF(tmpStr, 1000, "%sunitCellVectors = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 9; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", unitCellVectors[i]);
            str += tmpStr;
            if(i < 8)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *unitCellOrigin = atts->unitCellOrigin;
        SNPRINTF(tmpStr, 1000, "%sunitCellOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", unitCellOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->rectilinearGridHasTransform)
        SNPRINTF(tmpStr, 1000, "%srectilinearGridHasTransform = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%srectilinearGridHasTransform = 0\n", prefix);
    str += tmpStr;
    {   const double *rectilinearGridTransform = atts->rectilinearGridTransform;
        SNPRINTF(tmpStr, 1000, "%srectilinearGridTransform = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 16; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rectilinearGridTransform[i]);
            str += tmpStr;
            if(i < 15)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%snodeOrigin = %d\n", prefix, atts->nodeOrigin);
    str += tmpStr;
    if(atts->containsExteriorBoundaryGhosts)
        SNPRINTF(tmpStr, 1000, "%scontainsExteriorBoundaryGhosts = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontainsExteriorBoundaryGhosts = 0\n", prefix);
    str += tmpStr;
    if(atts->hideFromGUI)
        SNPRINTF(tmpStr, 1000, "%shideFromGUI = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shideFromGUI = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sLODs = %d\n", prefix, atts->LODs);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spresentGhostZoneTypes = %d\n", prefix, atts->presentGhostZoneTypes);
    str += tmpStr;
    if(atts->zonesWereSplit)
        SNPRINTF(tmpStr, 1000, "%szonesWereSplit = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%szonesWereSplit = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
avtMeshMetaData_Notify(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_SetName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->name = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->name.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetOriginalName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the originalName in the object.
    obj->data->originalName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetOriginalName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->originalName.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetValidVariable(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the validVariable in the object.
    obj->data->validVariable = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetValidVariable(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->validVariable?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetMeshType(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->meshType = (avtMeshType)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetMeshType(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->meshType));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetMeshCoordType(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->meshCoordType = (avtMeshCoordType)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetMeshCoordType(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->meshCoordType));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetCellOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellOrigin in the object.
    obj->data->cellOrigin = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetCellOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->cellOrigin));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetSpatialDimension(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the spatialDimension in the object.
    obj->data->spatialDimension = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetSpatialDimension(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->spatialDimension));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetHasLogicalBounds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasLogicalBounds in the object.
    obj->data->hasLogicalBounds = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetHasLogicalBounds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasLogicalBounds?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetLogicalBounds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int *ivals = obj->data->logicalBounds;
    if(!PyArg_ParseTuple(args, "iii", &ivals[0], &ivals[1], &ivals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the logicalBounds in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetLogicalBounds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the logicalBounds.
    PyObject *retval = PyTuple_New(3);
    const int *logicalBounds = obj->data->logicalBounds;
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(logicalBounds[i])));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetHasNumberCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasNumberCells in the object.
    obj->data->hasNumberCells = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetHasNumberCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasNumberCells?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetNumberCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberCells in the object.
    obj->data->numberCells = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetNumberCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->numberCells));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetTopologicalDimension(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the topologicalDimension in the object.
    obj->data->topologicalDimension = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetTopologicalDimension(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->topologicalDimension));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetXUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xUnits in the object.
    obj->data->xUnits = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetXUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->xUnits.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetYUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yUnits in the object.
    obj->data->yUnits = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetYUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->yUnits.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetZUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the zUnits in the object.
    obj->data->zUnits = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetZUnits(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->zUnits.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetXLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xLabel in the object.
    obj->data->xLabel = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetXLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->xLabel.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetYLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yLabel in the object.
    obj->data->yLabel = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetYLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->yLabel.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetZLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the zLabel in the object.
    obj->data->zLabel = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetZLabel(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->zLabel.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetHasSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasSpatialExtents in the object.
    obj->data->hasSpatialExtents = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetHasSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasSpatialExtents?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetMinSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    double *dvals = obj->data->minSpatialExtents;
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the minSpatialExtents in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetMinSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the minSpatialExtents.
    PyObject *retval = PyTuple_New(3);
    const double *minSpatialExtents = obj->data->minSpatialExtents;
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(minSpatialExtents[i]));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetMaxSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    double *dvals = obj->data->maxSpatialExtents;
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the maxSpatialExtents in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetMaxSpatialExtents(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the maxSpatialExtents.
    PyObject *retval = PyTuple_New(3);
    const double *maxSpatialExtents = obj->data->maxSpatialExtents;
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(maxSpatialExtents[i]));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetNumBlocks(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numBlocks in the object.
    obj->data->numBlocks = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetNumBlocks(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->numBlocks));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetBlockOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the blockOrigin in the object.
    obj->data->blockOrigin = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetBlockOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->blockOrigin));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetBlockPieceName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the blockPieceName in the object.
    obj->data->blockPieceName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetBlockPieceName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->blockPieceName.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetBlockTitle(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the blockTitle in the object.
    obj->data->blockTitle = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetBlockTitle(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->blockTitle.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetBlockNames(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    stringVector  &vec = obj->data->blockNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the blockNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetBlockNames(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the blockNames.
    const stringVector &blockNames = obj->data->blockNames;
    PyObject *retval = PyTuple_New(blockNames.size());
    for(size_t i = 0; i < blockNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(blockNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetBlockNameScheme(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyNameschemeAttributes_Check(newValue))
    {
        fprintf(stderr, "The blockNameScheme field can only be set with NameschemeAttributes objects.\n");
        return NULL;
    }

    obj->data->blockNameScheme = *PyNameschemeAttributes_FromPyObject(newValue);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetBlockNameScheme(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyNameschemeAttributes_Wrap(&obj->data->blockNameScheme);
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyNameschemeAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetNumGroups(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numGroups in the object.
    obj->data->numGroups = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetNumGroups(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->numGroups));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the groupOrigin in the object.
    obj->data->groupOrigin = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->groupOrigin));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupPieceName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the groupPieceName in the object.
    obj->data->groupPieceName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupPieceName(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->groupPieceName.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupTitle(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the groupTitle in the object.
    obj->data->groupTitle = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupTitle(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->groupTitle.c_str());
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupNames(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    stringVector  &vec = obj->data->groupNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the groupNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupNames(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the groupNames.
    const stringVector &groupNames = obj->data->groupNames;
    PyObject *retval = PyTuple_New(groupNames.size());
    for(size_t i = 0; i < groupNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(groupNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    intVector  &vec = obj->data->groupIds;
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the groupIds in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the groupIds.
    const intVector &groupIds = obj->data->groupIds;
    PyObject *retval = PyTuple_New(groupIds.size());
    for(size_t i = 0; i < groupIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(groupIds[i])));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetGroupIdsBasedOnRange(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    intVector  &vec = obj->data->groupIdsBasedOnRange;
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the groupIdsBasedOnRange in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetGroupIdsBasedOnRange(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the groupIdsBasedOnRange.
    const intVector &groupIdsBasedOnRange = obj->data->groupIdsBasedOnRange;
    PyObject *retval = PyTuple_New(groupIdsBasedOnRange.size());
    for(size_t i = 0; i < groupIdsBasedOnRange.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(groupIdsBasedOnRange[i])));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetDisjointElements(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the disjointElements in the object.
    obj->data->disjointElements = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetDisjointElements(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->disjointElements?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsGhostZones(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->containsGhostZones = (avtGhostType)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsGhostZones(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->containsGhostZones));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsOriginalCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the containsOriginalCells in the object.
    obj->data->containsOriginalCells = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsOriginalCells(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->containsOriginalCells?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsOriginalNodes(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the containsOriginalNodes in the object.
    obj->data->containsOriginalNodes = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsOriginalNodes(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->containsOriginalNodes?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsGlobalNodeIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the containsGlobalNodeIds in the object.
    obj->data->containsGlobalNodeIds = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsGlobalNodeIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->containsGlobalNodeIds?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsGlobalZoneIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the containsGlobalZoneIds in the object.
    obj->data->containsGlobalZoneIds = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsGlobalZoneIds(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->containsGlobalZoneIds?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetLoadBalanceScheme(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->loadBalanceScheme = (LoadBalanceScheme)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetLoadBalanceScheme(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->loadBalanceScheme));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetNodesAreCritical(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nodesAreCritical in the object.
    obj->data->nodesAreCritical = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetNodesAreCritical(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->nodesAreCritical?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetUnitCellVectors(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    float *fvals = obj->data->unitCellVectors;
    if(!PyArg_ParseTuple(args, "fffffffff", &fvals[0], &fvals[1], &fvals[2], &fvals[3], &fvals[4], &fvals[5], &fvals[6], &fvals[7], &fvals[8]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 9)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the unitCellVectors in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetUnitCellVectors(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the unitCellVectors.
    PyObject *retval = PyTuple_New(9);
    const float *unitCellVectors = obj->data->unitCellVectors;
    for(int i = 0; i < 9; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(unitCellVectors[i])));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetUnitCellOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    float *fvals = obj->data->unitCellOrigin;
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the unitCellOrigin in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetUnitCellOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the unitCellOrigin.
    PyObject *retval = PyTuple_New(3);
    const float *unitCellOrigin = obj->data->unitCellOrigin;
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(unitCellOrigin[i])));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetRectilinearGridHasTransform(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rectilinearGridHasTransform in the object.
    obj->data->rectilinearGridHasTransform = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetRectilinearGridHasTransform(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->rectilinearGridHasTransform?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetRectilinearGridTransform(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    double *dvals = obj->data->rectilinearGridTransform;
    if(!PyArg_ParseTuple(args, "dddddddddddddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5], &dvals[6], &dvals[7], &dvals[8], &dvals[9], &dvals[10], &dvals[11], &dvals[12], &dvals[13], &dvals[14], &dvals[15]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 16)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rectilinearGridTransform in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetRectilinearGridTransform(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the rectilinearGridTransform.
    PyObject *retval = PyTuple_New(16);
    const double *rectilinearGridTransform = obj->data->rectilinearGridTransform;
    for(int i = 0; i < 16; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rectilinearGridTransform[i]));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetNodeOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nodeOrigin in the object.
    obj->data->nodeOrigin = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetNodeOrigin(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->nodeOrigin));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetContainsExteriorBoundaryGhosts(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the containsExteriorBoundaryGhosts in the object.
    obj->data->containsExteriorBoundaryGhosts = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetContainsExteriorBoundaryGhosts(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->containsExteriorBoundaryGhosts?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetHideFromGUI(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hideFromGUI in the object.
    obj->data->hideFromGUI = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetHideFromGUI(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hideFromGUI?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetLODs(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the LODs in the object.
    obj->data->LODs = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetLODs(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->LODs));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetPresentGhostZoneTypes(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the presentGhostZoneTypes in the object.
    obj->data->presentGhostZoneTypes = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetPresentGhostZoneTypes(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->presentGhostZoneTypes));
    return retval;
}

/*static*/ PyObject *
avtMeshMetaData_SetZonesWereSplit(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zonesWereSplit in the object.
    obj->data->zonesWereSplit = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMeshMetaData_GetZonesWereSplit(PyObject *self, PyObject *args)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->zonesWereSplit?1L:0L);
    return retval;
}



PyMethodDef PyavtMeshMetaData_methods[AVTMESHMETADATA_NMETH] = {
    {"Notify", avtMeshMetaData_Notify, METH_VARARGS},
    {"SetName", avtMeshMetaData_SetName, METH_VARARGS},
    {"GetName", avtMeshMetaData_GetName, METH_VARARGS},
    {"SetOriginalName", avtMeshMetaData_SetOriginalName, METH_VARARGS},
    {"GetOriginalName", avtMeshMetaData_GetOriginalName, METH_VARARGS},
    {"SetValidVariable", avtMeshMetaData_SetValidVariable, METH_VARARGS},
    {"GetValidVariable", avtMeshMetaData_GetValidVariable, METH_VARARGS},
    {"SetMeshType", avtMeshMetaData_SetMeshType, METH_VARARGS},
    {"GetMeshType", avtMeshMetaData_GetMeshType, METH_VARARGS},
    {"SetMeshCoordType", avtMeshMetaData_SetMeshCoordType, METH_VARARGS},
    {"GetMeshCoordType", avtMeshMetaData_GetMeshCoordType, METH_VARARGS},
    {"SetCellOrigin", avtMeshMetaData_SetCellOrigin, METH_VARARGS},
    {"GetCellOrigin", avtMeshMetaData_GetCellOrigin, METH_VARARGS},
    {"SetSpatialDimension", avtMeshMetaData_SetSpatialDimension, METH_VARARGS},
    {"GetSpatialDimension", avtMeshMetaData_GetSpatialDimension, METH_VARARGS},
    {"SetHasLogicalBounds", avtMeshMetaData_SetHasLogicalBounds, METH_VARARGS},
    {"GetHasLogicalBounds", avtMeshMetaData_GetHasLogicalBounds, METH_VARARGS},
    {"SetLogicalBounds", avtMeshMetaData_SetLogicalBounds, METH_VARARGS},
    {"GetLogicalBounds", avtMeshMetaData_GetLogicalBounds, METH_VARARGS},
    {"SetHasNumberCells", avtMeshMetaData_SetHasNumberCells, METH_VARARGS},
    {"GetHasNumberCells", avtMeshMetaData_GetHasNumberCells, METH_VARARGS},
    {"SetNumberCells", avtMeshMetaData_SetNumberCells, METH_VARARGS},
    {"GetNumberCells", avtMeshMetaData_GetNumberCells, METH_VARARGS},
    {"SetTopologicalDimension", avtMeshMetaData_SetTopologicalDimension, METH_VARARGS},
    {"GetTopologicalDimension", avtMeshMetaData_GetTopologicalDimension, METH_VARARGS},
    {"SetXUnits", avtMeshMetaData_SetXUnits, METH_VARARGS},
    {"GetXUnits", avtMeshMetaData_GetXUnits, METH_VARARGS},
    {"SetYUnits", avtMeshMetaData_SetYUnits, METH_VARARGS},
    {"GetYUnits", avtMeshMetaData_GetYUnits, METH_VARARGS},
    {"SetZUnits", avtMeshMetaData_SetZUnits, METH_VARARGS},
    {"GetZUnits", avtMeshMetaData_GetZUnits, METH_VARARGS},
    {"SetXLabel", avtMeshMetaData_SetXLabel, METH_VARARGS},
    {"GetXLabel", avtMeshMetaData_GetXLabel, METH_VARARGS},
    {"SetYLabel", avtMeshMetaData_SetYLabel, METH_VARARGS},
    {"GetYLabel", avtMeshMetaData_GetYLabel, METH_VARARGS},
    {"SetZLabel", avtMeshMetaData_SetZLabel, METH_VARARGS},
    {"GetZLabel", avtMeshMetaData_GetZLabel, METH_VARARGS},
    {"SetHasSpatialExtents", avtMeshMetaData_SetHasSpatialExtents, METH_VARARGS},
    {"GetHasSpatialExtents", avtMeshMetaData_GetHasSpatialExtents, METH_VARARGS},
    {"SetMinSpatialExtents", avtMeshMetaData_SetMinSpatialExtents, METH_VARARGS},
    {"GetMinSpatialExtents", avtMeshMetaData_GetMinSpatialExtents, METH_VARARGS},
    {"SetMaxSpatialExtents", avtMeshMetaData_SetMaxSpatialExtents, METH_VARARGS},
    {"GetMaxSpatialExtents", avtMeshMetaData_GetMaxSpatialExtents, METH_VARARGS},
    {"SetNumBlocks", avtMeshMetaData_SetNumBlocks, METH_VARARGS},
    {"GetNumBlocks", avtMeshMetaData_GetNumBlocks, METH_VARARGS},
    {"SetBlockOrigin", avtMeshMetaData_SetBlockOrigin, METH_VARARGS},
    {"GetBlockOrigin", avtMeshMetaData_GetBlockOrigin, METH_VARARGS},
    {"SetBlockPieceName", avtMeshMetaData_SetBlockPieceName, METH_VARARGS},
    {"GetBlockPieceName", avtMeshMetaData_GetBlockPieceName, METH_VARARGS},
    {"SetBlockTitle", avtMeshMetaData_SetBlockTitle, METH_VARARGS},
    {"GetBlockTitle", avtMeshMetaData_GetBlockTitle, METH_VARARGS},
    {"SetBlockNames", avtMeshMetaData_SetBlockNames, METH_VARARGS},
    {"GetBlockNames", avtMeshMetaData_GetBlockNames, METH_VARARGS},
    {"SetBlockNameScheme", avtMeshMetaData_SetBlockNameScheme, METH_VARARGS},
    {"GetBlockNameScheme", avtMeshMetaData_GetBlockNameScheme, METH_VARARGS},
    {"SetNumGroups", avtMeshMetaData_SetNumGroups, METH_VARARGS},
    {"GetNumGroups", avtMeshMetaData_GetNumGroups, METH_VARARGS},
    {"SetGroupOrigin", avtMeshMetaData_SetGroupOrigin, METH_VARARGS},
    {"GetGroupOrigin", avtMeshMetaData_GetGroupOrigin, METH_VARARGS},
    {"SetGroupPieceName", avtMeshMetaData_SetGroupPieceName, METH_VARARGS},
    {"GetGroupPieceName", avtMeshMetaData_GetGroupPieceName, METH_VARARGS},
    {"SetGroupTitle", avtMeshMetaData_SetGroupTitle, METH_VARARGS},
    {"GetGroupTitle", avtMeshMetaData_GetGroupTitle, METH_VARARGS},
    {"SetGroupNames", avtMeshMetaData_SetGroupNames, METH_VARARGS},
    {"GetGroupNames", avtMeshMetaData_GetGroupNames, METH_VARARGS},
    {"SetGroupIds", avtMeshMetaData_SetGroupIds, METH_VARARGS},
    {"GetGroupIds", avtMeshMetaData_GetGroupIds, METH_VARARGS},
    {"SetGroupIdsBasedOnRange", avtMeshMetaData_SetGroupIdsBasedOnRange, METH_VARARGS},
    {"GetGroupIdsBasedOnRange", avtMeshMetaData_GetGroupIdsBasedOnRange, METH_VARARGS},
    {"SetDisjointElements", avtMeshMetaData_SetDisjointElements, METH_VARARGS},
    {"GetDisjointElements", avtMeshMetaData_GetDisjointElements, METH_VARARGS},
    {"SetContainsGhostZones", avtMeshMetaData_SetContainsGhostZones, METH_VARARGS},
    {"GetContainsGhostZones", avtMeshMetaData_GetContainsGhostZones, METH_VARARGS},
    {"SetContainsOriginalCells", avtMeshMetaData_SetContainsOriginalCells, METH_VARARGS},
    {"GetContainsOriginalCells", avtMeshMetaData_GetContainsOriginalCells, METH_VARARGS},
    {"SetContainsOriginalNodes", avtMeshMetaData_SetContainsOriginalNodes, METH_VARARGS},
    {"GetContainsOriginalNodes", avtMeshMetaData_GetContainsOriginalNodes, METH_VARARGS},
    {"SetContainsGlobalNodeIds", avtMeshMetaData_SetContainsGlobalNodeIds, METH_VARARGS},
    {"GetContainsGlobalNodeIds", avtMeshMetaData_GetContainsGlobalNodeIds, METH_VARARGS},
    {"SetContainsGlobalZoneIds", avtMeshMetaData_SetContainsGlobalZoneIds, METH_VARARGS},
    {"GetContainsGlobalZoneIds", avtMeshMetaData_GetContainsGlobalZoneIds, METH_VARARGS},
    {"SetLoadBalanceScheme", avtMeshMetaData_SetLoadBalanceScheme, METH_VARARGS},
    {"GetLoadBalanceScheme", avtMeshMetaData_GetLoadBalanceScheme, METH_VARARGS},
    {"SetNodesAreCritical", avtMeshMetaData_SetNodesAreCritical, METH_VARARGS},
    {"GetNodesAreCritical", avtMeshMetaData_GetNodesAreCritical, METH_VARARGS},
    {"SetUnitCellVectors", avtMeshMetaData_SetUnitCellVectors, METH_VARARGS},
    {"GetUnitCellVectors", avtMeshMetaData_GetUnitCellVectors, METH_VARARGS},
    {"SetUnitCellOrigin", avtMeshMetaData_SetUnitCellOrigin, METH_VARARGS},
    {"GetUnitCellOrigin", avtMeshMetaData_GetUnitCellOrigin, METH_VARARGS},
    {"SetRectilinearGridHasTransform", avtMeshMetaData_SetRectilinearGridHasTransform, METH_VARARGS},
    {"GetRectilinearGridHasTransform", avtMeshMetaData_GetRectilinearGridHasTransform, METH_VARARGS},
    {"SetRectilinearGridTransform", avtMeshMetaData_SetRectilinearGridTransform, METH_VARARGS},
    {"GetRectilinearGridTransform", avtMeshMetaData_GetRectilinearGridTransform, METH_VARARGS},
    {"SetNodeOrigin", avtMeshMetaData_SetNodeOrigin, METH_VARARGS},
    {"GetNodeOrigin", avtMeshMetaData_GetNodeOrigin, METH_VARARGS},
    {"SetContainsExteriorBoundaryGhosts", avtMeshMetaData_SetContainsExteriorBoundaryGhosts, METH_VARARGS},
    {"GetContainsExteriorBoundaryGhosts", avtMeshMetaData_GetContainsExteriorBoundaryGhosts, METH_VARARGS},
    {"SetHideFromGUI", avtMeshMetaData_SetHideFromGUI, METH_VARARGS},
    {"GetHideFromGUI", avtMeshMetaData_GetHideFromGUI, METH_VARARGS},
    {"SetLODs", avtMeshMetaData_SetLODs, METH_VARARGS},
    {"GetLODs", avtMeshMetaData_GetLODs, METH_VARARGS},
    {"SetPresentGhostZoneTypes", avtMeshMetaData_SetPresentGhostZoneTypes, METH_VARARGS},
    {"GetPresentGhostZoneTypes", avtMeshMetaData_GetPresentGhostZoneTypes, METH_VARARGS},
    {"SetZonesWereSplit", avtMeshMetaData_SetZonesWereSplit, METH_VARARGS},
    {"GetZonesWereSplit", avtMeshMetaData_GetZonesWereSplit, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtMeshMetaData_dealloc(PyObject *v)
{
   avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtMeshMetaData_compare(PyObject *v, PyObject *w)
{
    avtMeshMetaData *a = ((avtMeshMetaDataObject *)v)->data;
    avtMeshMetaData *b = ((avtMeshMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtMeshMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return avtMeshMetaData_GetName(self, NULL);
    if(strcmp(name, "originalName") == 0)
        return avtMeshMetaData_GetOriginalName(self, NULL);
    if(strcmp(name, "validVariable") == 0)
        return avtMeshMetaData_GetValidVariable(self, NULL);
    if(strcmp(name, "meshType") == 0)
        return avtMeshMetaData_GetMeshType(self, NULL);
    if(strcmp(name, "AVT_RECTILINEAR_MESH") == 0)
        return PyInt_FromLong(long(AVT_RECTILINEAR_MESH));
    else if(strcmp(name, "AVT_CURVILINEAR_MESH") == 0)
        return PyInt_FromLong(long(AVT_CURVILINEAR_MESH));
    else if(strcmp(name, "AVT_UNSTRUCTURED_MESH") == 0)
        return PyInt_FromLong(long(AVT_UNSTRUCTURED_MESH));
    else if(strcmp(name, "AVT_POINT_MESH") == 0)
        return PyInt_FromLong(long(AVT_POINT_MESH));
    else if(strcmp(name, "AVT_SURFACE_MESH") == 0)
        return PyInt_FromLong(long(AVT_SURFACE_MESH));
    else if(strcmp(name, "AVT_CSG_MESH") == 0)
        return PyInt_FromLong(long(AVT_CSG_MESH));
    else if(strcmp(name, "AVT_AMR_MESH") == 0)
        return PyInt_FromLong(long(AVT_AMR_MESH));
    else if(strcmp(name, "AVT_UNKNOWN_MESH") == 0)
        return PyInt_FromLong(long(AVT_UNKNOWN_MESH));

    if(strcmp(name, "meshCoordType") == 0)
        return avtMeshMetaData_GetMeshCoordType(self, NULL);
    if(strcmp(name, "AVT_XY") == 0)
        return PyInt_FromLong(long(AVT_XY));
    else if(strcmp(name, "AVT_RZ") == 0)
        return PyInt_FromLong(long(AVT_RZ));
    else if(strcmp(name, "AVT_ZR") == 0)
        return PyInt_FromLong(long(AVT_ZR));

    if(strcmp(name, "cellOrigin") == 0)
        return avtMeshMetaData_GetCellOrigin(self, NULL);
    if(strcmp(name, "spatialDimension") == 0)
        return avtMeshMetaData_GetSpatialDimension(self, NULL);
    if(strcmp(name, "hasLogicalBounds") == 0)
        return avtMeshMetaData_GetHasLogicalBounds(self, NULL);
    if(strcmp(name, "logicalBounds") == 0)
        return avtMeshMetaData_GetLogicalBounds(self, NULL);
    if(strcmp(name, "hasNumberCells") == 0)
        return avtMeshMetaData_GetHasNumberCells(self, NULL);
    if(strcmp(name, "numberCells") == 0)
        return avtMeshMetaData_GetNumberCells(self, NULL);
    if(strcmp(name, "topologicalDimension") == 0)
        return avtMeshMetaData_GetTopologicalDimension(self, NULL);
    if(strcmp(name, "xUnits") == 0)
        return avtMeshMetaData_GetXUnits(self, NULL);
    if(strcmp(name, "yUnits") == 0)
        return avtMeshMetaData_GetYUnits(self, NULL);
    if(strcmp(name, "zUnits") == 0)
        return avtMeshMetaData_GetZUnits(self, NULL);
    if(strcmp(name, "xLabel") == 0)
        return avtMeshMetaData_GetXLabel(self, NULL);
    if(strcmp(name, "yLabel") == 0)
        return avtMeshMetaData_GetYLabel(self, NULL);
    if(strcmp(name, "zLabel") == 0)
        return avtMeshMetaData_GetZLabel(self, NULL);
    if(strcmp(name, "hasSpatialExtents") == 0)
        return avtMeshMetaData_GetHasSpatialExtents(self, NULL);
    if(strcmp(name, "minSpatialExtents") == 0)
        return avtMeshMetaData_GetMinSpatialExtents(self, NULL);
    if(strcmp(name, "maxSpatialExtents") == 0)
        return avtMeshMetaData_GetMaxSpatialExtents(self, NULL);
    if(strcmp(name, "numBlocks") == 0)
        return avtMeshMetaData_GetNumBlocks(self, NULL);
    if(strcmp(name, "blockOrigin") == 0)
        return avtMeshMetaData_GetBlockOrigin(self, NULL);
    if(strcmp(name, "blockPieceName") == 0)
        return avtMeshMetaData_GetBlockPieceName(self, NULL);
    if(strcmp(name, "blockTitle") == 0)
        return avtMeshMetaData_GetBlockTitle(self, NULL);
    if(strcmp(name, "blockNames") == 0)
        return avtMeshMetaData_GetBlockNames(self, NULL);
    if(strcmp(name, "blockNameScheme") == 0)
        return avtMeshMetaData_GetBlockNameScheme(self, NULL);
    if(strcmp(name, "numGroups") == 0)
        return avtMeshMetaData_GetNumGroups(self, NULL);
    if(strcmp(name, "groupOrigin") == 0)
        return avtMeshMetaData_GetGroupOrigin(self, NULL);
    if(strcmp(name, "groupPieceName") == 0)
        return avtMeshMetaData_GetGroupPieceName(self, NULL);
    if(strcmp(name, "groupTitle") == 0)
        return avtMeshMetaData_GetGroupTitle(self, NULL);
    if(strcmp(name, "groupNames") == 0)
        return avtMeshMetaData_GetGroupNames(self, NULL);
    if(strcmp(name, "groupIds") == 0)
        return avtMeshMetaData_GetGroupIds(self, NULL);
    if(strcmp(name, "groupIdsBasedOnRange") == 0)
        return avtMeshMetaData_GetGroupIdsBasedOnRange(self, NULL);
    if(strcmp(name, "disjointElements") == 0)
        return avtMeshMetaData_GetDisjointElements(self, NULL);
    if(strcmp(name, "containsGhostZones") == 0)
        return avtMeshMetaData_GetContainsGhostZones(self, NULL);
    if(strcmp(name, "AVT_NO_GHOSTS") == 0)
        return PyInt_FromLong(long(AVT_NO_GHOSTS));
    else if(strcmp(name, "AVT_HAS_GHOSTS") == 0)
        return PyInt_FromLong(long(AVT_HAS_GHOSTS));
    else if(strcmp(name, "AVT_CREATED_GHOSTS") == 0)
        return PyInt_FromLong(long(AVT_CREATED_GHOSTS));
    else if(strcmp(name, "AVT_MAYBE_GHOSTS") == 0)
        return PyInt_FromLong(long(AVT_MAYBE_GHOSTS));

    if(strcmp(name, "containsOriginalCells") == 0)
        return avtMeshMetaData_GetContainsOriginalCells(self, NULL);
    if(strcmp(name, "containsOriginalNodes") == 0)
        return avtMeshMetaData_GetContainsOriginalNodes(self, NULL);
    if(strcmp(name, "containsGlobalNodeIds") == 0)
        return avtMeshMetaData_GetContainsGlobalNodeIds(self, NULL);
    if(strcmp(name, "containsGlobalZoneIds") == 0)
        return avtMeshMetaData_GetContainsGlobalZoneIds(self, NULL);
    if(strcmp(name, "loadBalanceScheme") == 0)
        return avtMeshMetaData_GetLoadBalanceScheme(self, NULL);
    if(strcmp(name, "LOAD_BALANCE_UNKNOWN") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_UNKNOWN));
    else if(strcmp(name, "LOAD_BALANCE_CONTIGUOUS_BLOCKS_TOGETHER") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_CONTIGUOUS_BLOCKS_TOGETHER));
    else if(strcmp(name, "LOAD_BALANCE_STRIDE_ACROSS_BLOCKS") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_STRIDE_ACROSS_BLOCKS));
    else if(strcmp(name, "LOAD_BALANCE_RANDOM_ASSIGNMENT") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_RANDOM_ASSIGNMENT));
    else if(strcmp(name, "LOAD_BALANCE_DBPLUGIN_DYNAMIC") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_DBPLUGIN_DYNAMIC));
    else if(strcmp(name, "LOAD_BALANCE_RESTRICTED") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_RESTRICTED));
    else if(strcmp(name, "LOAD_BALANCE_ABSOLUTE") == 0)
        return PyInt_FromLong(long(LOAD_BALANCE_ABSOLUTE));

    if(strcmp(name, "nodesAreCritical") == 0)
        return avtMeshMetaData_GetNodesAreCritical(self, NULL);
    if(strcmp(name, "unitCellVectors") == 0)
        return avtMeshMetaData_GetUnitCellVectors(self, NULL);
    if(strcmp(name, "unitCellOrigin") == 0)
        return avtMeshMetaData_GetUnitCellOrigin(self, NULL);
    if(strcmp(name, "rectilinearGridHasTransform") == 0)
        return avtMeshMetaData_GetRectilinearGridHasTransform(self, NULL);
    if(strcmp(name, "rectilinearGridTransform") == 0)
        return avtMeshMetaData_GetRectilinearGridTransform(self, NULL);
    if(strcmp(name, "nodeOrigin") == 0)
        return avtMeshMetaData_GetNodeOrigin(self, NULL);
    if(strcmp(name, "containsExteriorBoundaryGhosts") == 0)
        return avtMeshMetaData_GetContainsExteriorBoundaryGhosts(self, NULL);
    if(strcmp(name, "hideFromGUI") == 0)
        return avtMeshMetaData_GetHideFromGUI(self, NULL);
    if(strcmp(name, "LODs") == 0)
        return avtMeshMetaData_GetLODs(self, NULL);
    if(strcmp(name, "presentGhostZoneTypes") == 0)
        return avtMeshMetaData_GetPresentGhostZoneTypes(self, NULL);
    if(strcmp(name, "zonesWereSplit") == 0)
        return avtMeshMetaData_GetZonesWereSplit(self, NULL);

    return Py_FindMethod(PyavtMeshMetaData_methods, self, name);
}

int
PyavtMeshMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = avtMeshMetaData_SetName(self, tuple);
    else if(strcmp(name, "originalName") == 0)
        obj = avtMeshMetaData_SetOriginalName(self, tuple);
    else if(strcmp(name, "validVariable") == 0)
        obj = avtMeshMetaData_SetValidVariable(self, tuple);
    else if(strcmp(name, "meshType") == 0)
        obj = avtMeshMetaData_SetMeshType(self, tuple);
    else if(strcmp(name, "meshCoordType") == 0)
        obj = avtMeshMetaData_SetMeshCoordType(self, tuple);
    else if(strcmp(name, "cellOrigin") == 0)
        obj = avtMeshMetaData_SetCellOrigin(self, tuple);
    else if(strcmp(name, "spatialDimension") == 0)
        obj = avtMeshMetaData_SetSpatialDimension(self, tuple);
    else if(strcmp(name, "hasLogicalBounds") == 0)
        obj = avtMeshMetaData_SetHasLogicalBounds(self, tuple);
    else if(strcmp(name, "logicalBounds") == 0)
        obj = avtMeshMetaData_SetLogicalBounds(self, tuple);
    else if(strcmp(name, "hasNumberCells") == 0)
        obj = avtMeshMetaData_SetHasNumberCells(self, tuple);
    else if(strcmp(name, "numberCells") == 0)
        obj = avtMeshMetaData_SetNumberCells(self, tuple);
    else if(strcmp(name, "topologicalDimension") == 0)
        obj = avtMeshMetaData_SetTopologicalDimension(self, tuple);
    else if(strcmp(name, "xUnits") == 0)
        obj = avtMeshMetaData_SetXUnits(self, tuple);
    else if(strcmp(name, "yUnits") == 0)
        obj = avtMeshMetaData_SetYUnits(self, tuple);
    else if(strcmp(name, "zUnits") == 0)
        obj = avtMeshMetaData_SetZUnits(self, tuple);
    else if(strcmp(name, "xLabel") == 0)
        obj = avtMeshMetaData_SetXLabel(self, tuple);
    else if(strcmp(name, "yLabel") == 0)
        obj = avtMeshMetaData_SetYLabel(self, tuple);
    else if(strcmp(name, "zLabel") == 0)
        obj = avtMeshMetaData_SetZLabel(self, tuple);
    else if(strcmp(name, "hasSpatialExtents") == 0)
        obj = avtMeshMetaData_SetHasSpatialExtents(self, tuple);
    else if(strcmp(name, "minSpatialExtents") == 0)
        obj = avtMeshMetaData_SetMinSpatialExtents(self, tuple);
    else if(strcmp(name, "maxSpatialExtents") == 0)
        obj = avtMeshMetaData_SetMaxSpatialExtents(self, tuple);
    else if(strcmp(name, "numBlocks") == 0)
        obj = avtMeshMetaData_SetNumBlocks(self, tuple);
    else if(strcmp(name, "blockOrigin") == 0)
        obj = avtMeshMetaData_SetBlockOrigin(self, tuple);
    else if(strcmp(name, "blockPieceName") == 0)
        obj = avtMeshMetaData_SetBlockPieceName(self, tuple);
    else if(strcmp(name, "blockTitle") == 0)
        obj = avtMeshMetaData_SetBlockTitle(self, tuple);
    else if(strcmp(name, "blockNames") == 0)
        obj = avtMeshMetaData_SetBlockNames(self, tuple);
    else if(strcmp(name, "blockNameScheme") == 0)
        obj = avtMeshMetaData_SetBlockNameScheme(self, tuple);
    else if(strcmp(name, "numGroups") == 0)
        obj = avtMeshMetaData_SetNumGroups(self, tuple);
    else if(strcmp(name, "groupOrigin") == 0)
        obj = avtMeshMetaData_SetGroupOrigin(self, tuple);
    else if(strcmp(name, "groupPieceName") == 0)
        obj = avtMeshMetaData_SetGroupPieceName(self, tuple);
    else if(strcmp(name, "groupTitle") == 0)
        obj = avtMeshMetaData_SetGroupTitle(self, tuple);
    else if(strcmp(name, "groupNames") == 0)
        obj = avtMeshMetaData_SetGroupNames(self, tuple);
    else if(strcmp(name, "groupIds") == 0)
        obj = avtMeshMetaData_SetGroupIds(self, tuple);
    else if(strcmp(name, "groupIdsBasedOnRange") == 0)
        obj = avtMeshMetaData_SetGroupIdsBasedOnRange(self, tuple);
    else if(strcmp(name, "disjointElements") == 0)
        obj = avtMeshMetaData_SetDisjointElements(self, tuple);
    else if(strcmp(name, "containsGhostZones") == 0)
        obj = avtMeshMetaData_SetContainsGhostZones(self, tuple);
    else if(strcmp(name, "containsOriginalCells") == 0)
        obj = avtMeshMetaData_SetContainsOriginalCells(self, tuple);
    else if(strcmp(name, "containsOriginalNodes") == 0)
        obj = avtMeshMetaData_SetContainsOriginalNodes(self, tuple);
    else if(strcmp(name, "containsGlobalNodeIds") == 0)
        obj = avtMeshMetaData_SetContainsGlobalNodeIds(self, tuple);
    else if(strcmp(name, "containsGlobalZoneIds") == 0)
        obj = avtMeshMetaData_SetContainsGlobalZoneIds(self, tuple);
    else if(strcmp(name, "loadBalanceScheme") == 0)
        obj = avtMeshMetaData_SetLoadBalanceScheme(self, tuple);
    else if(strcmp(name, "nodesAreCritical") == 0)
        obj = avtMeshMetaData_SetNodesAreCritical(self, tuple);
    else if(strcmp(name, "unitCellVectors") == 0)
        obj = avtMeshMetaData_SetUnitCellVectors(self, tuple);
    else if(strcmp(name, "unitCellOrigin") == 0)
        obj = avtMeshMetaData_SetUnitCellOrigin(self, tuple);
    else if(strcmp(name, "rectilinearGridHasTransform") == 0)
        obj = avtMeshMetaData_SetRectilinearGridHasTransform(self, tuple);
    else if(strcmp(name, "rectilinearGridTransform") == 0)
        obj = avtMeshMetaData_SetRectilinearGridTransform(self, tuple);
    else if(strcmp(name, "nodeOrigin") == 0)
        obj = avtMeshMetaData_SetNodeOrigin(self, tuple);
    else if(strcmp(name, "containsExteriorBoundaryGhosts") == 0)
        obj = avtMeshMetaData_SetContainsExteriorBoundaryGhosts(self, tuple);
    else if(strcmp(name, "hideFromGUI") == 0)
        obj = avtMeshMetaData_SetHideFromGUI(self, tuple);
    else if(strcmp(name, "LODs") == 0)
        obj = avtMeshMetaData_SetLODs(self, tuple);
    else if(strcmp(name, "presentGhostZoneTypes") == 0)
        obj = avtMeshMetaData_SetPresentGhostZoneTypes(self, tuple);
    else if(strcmp(name, "zonesWereSplit") == 0)
        obj = avtMeshMetaData_SetZonesWereSplit(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtMeshMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)v;
    fprintf(fp, "%s", PyavtMeshMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtMeshMetaData_str(PyObject *v)
{
    avtMeshMetaDataObject *obj = (avtMeshMetaDataObject *)v;
    return PyString_FromString(PyavtMeshMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtMeshMetaData_Purpose = "Contains mesh metadata attributes";
#else
static char *avtMeshMetaData_Purpose = "Contains mesh metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtMeshMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtMeshMetaData",                    // tp_name
    sizeof(avtMeshMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtMeshMetaData_dealloc,  // tp_dealloc
    (printfunc)avtMeshMetaData_print,     // tp_print
    (getattrfunc)PyavtMeshMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtMeshMetaData_setattr, // tp_setattr
    (cmpfunc)avtMeshMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtMeshMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtMeshMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtMeshMetaData *defaultAtts = 0;
static avtMeshMetaData *currentAtts = 0;

static PyObject *
NewavtMeshMetaData(int useCurrent)
{
    avtMeshMetaDataObject *newObject;
    newObject = PyObject_NEW(avtMeshMetaDataObject, &avtMeshMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtMeshMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtMeshMetaData(*defaultAtts);
    else
        newObject->data = new avtMeshMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtMeshMetaData(const avtMeshMetaData *attr)
{
    avtMeshMetaDataObject *newObject;
    newObject = PyObject_NEW(avtMeshMetaDataObject, &avtMeshMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtMeshMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtMeshMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtMeshMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtMeshMetaDataMethods[] = {
    {"avtMeshMetaData", avtMeshMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtMeshMetaDataObserver = 0;

std::string
PyavtMeshMetaData_GetLogString()
{
    std::string s("avtMeshMetaData = avtMeshMetaData()\n");
    if(currentAtts != 0)
        s += PyavtMeshMetaData_ToString(currentAtts, "avtMeshMetaData.");
    return s;
}

static void
PyavtMeshMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtMeshMetaData = avtMeshMetaData()\n");
        s += PyavtMeshMetaData_ToString(currentAtts, "avtMeshMetaData.");
        cb(s);
    }
}

void
PyavtMeshMetaData_StartUp(avtMeshMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtMeshMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtMeshMetaDataObserver == 0)
    {
        avtMeshMetaDataObserver = new ObserverToCallback(subj,
            PyavtMeshMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtMeshMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtMeshMetaDataObserver;
    avtMeshMetaDataObserver = 0;
}

PyMethodDef *
PyavtMeshMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtMeshMetaDataMethods;
}

bool
PyavtMeshMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtMeshMetaDataType);
}

avtMeshMetaData *
PyavtMeshMetaData_FromPyObject(PyObject *obj)
{
    avtMeshMetaDataObject *obj2 = (avtMeshMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtMeshMetaData_New()
{
    return NewavtMeshMetaData(0);
}

PyObject *
PyavtMeshMetaData_Wrap(const avtMeshMetaData *attr)
{
    return WrapavtMeshMetaData(attr);
}

void
PyavtMeshMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtMeshMetaDataObject *obj2 = (avtMeshMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtMeshMetaData_SetDefaults(const avtMeshMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtMeshMetaData(*atts);
}

