// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Double;
import java.util.Vector;

// ****************************************************************************
// Class: LineSamplerAttributes
//
// Purpose:
//    This class contains attributes for the line sampler operator.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class LineSamplerAttributes extends AttributeSubject implements Plugin
{
    private static int LineSamplerAttributes_numAdditionalAtts = 52;

    // Enum values
    public final static int MESHGEOMETRY_CARTESIAN = 0;
    public final static int MESHGEOMETRY_CYLINDRICAL = 1;
    public final static int MESHGEOMETRY_TOROIDAL = 2;

    public final static int ARRAYCONFIGURATION_GEOMETRY = 0;
    public final static int ARRAYCONFIGURATION_MANUAL = 1;

    public final static int BOUNDARY_DATA = 0;
    public final static int BOUNDARY_WALL = 1;

    public final static int CHANNELPROJECTION_DIVERGENT = 0;
    public final static int CHANNELPROJECTION_PARALLEL = 1;
    public final static int CHANNELPROJECTION_GRID = 2;

    public final static int CHANNELLAYOUTTYPE_CHANNELABSOLUTE = 0;
    public final static int CHANNELLAYOUTTYPE_CHANNELRELATIVE = 1;

    public final static int ARRAYAXIS_R = 0;
    public final static int ARRAYAXIS_Z = 1;

    public final static int VIEWGEOMETRY_POINTS = 0;
    public final static int VIEWGEOMETRY_LINES = 1;
    public final static int VIEWGEOMETRY_SURFACES = 2;

    public final static int DISPLAYTIME_STEP = 0;
    public final static int DISPLAYTIME_TIME = 1;
    public final static int DISPLAYTIME_CYCLE = 2;

    public final static int CHANNELGEOMETRY_POINT = 0;
    public final static int CHANNELGEOMETRY_LINE = 1;
    public final static int CHANNELGEOMETRY_CYLINDER = 2;
    public final static int CHANNELGEOMETRY_CONE = 3;

    public final static int VIEWDIMENSION_ONE = 0;
    public final static int VIEWDIMENSION_TWO = 1;
    public final static int VIEWDIMENSION_THREE = 2;

    public final static int CHANNELPROFILE_TOPHAT = 0;
    public final static int CHANNELPROFILE_GAUSSIAN = 1;

    public final static int CHANNELINTEGRATION_NOCHANNELINTEGRATION = 0;
    public final static int CHANNELINTEGRATION_INTEGRATEALONGCHANNEL = 1;

    public final static int TOROIDALINTEGRATION_NOTOROIDALINTEGRATION = 0;
    public final static int TOROIDALINTEGRATION_TOROIDALTIMESAMPLE = 1;
    public final static int TOROIDALINTEGRATION_INTEGRATETOROIDALLY = 2;

    public final static int TOROIDALANGLESAMPLING_TOROIDALANGLEABSOLUTESAMPLING = 0;
    public final static int TOROIDALANGLESAMPLING_TOROIDALANGLERELATIVESAMPLING = 1;

    public final static int TIMESAMPLING_CURRENTTIMESTEP = 0;
    public final static int TIMESAMPLING_MULTIPLETIMESTEPS = 1;


    public LineSamplerAttributes()
    {
        super(LineSamplerAttributes_numAdditionalAtts);

        meshGeometry = MESHGEOMETRY_TOROIDAL;
        arrayConfiguration = ARRAYCONFIGURATION_GEOMETRY;
        boundary = BOUNDARY_DATA;
        instanceId = 0;
        nArrays = 1;
        toroidalArrayAngle = 5;
        nChannels = 5;
        channelProjection = CHANNELPROJECTION_PARALLEL;
        channelLayoutType = CHANNELLAYOUTTYPE_CHANNELRELATIVE;
        channelOffset = 0.1;
        channelAngle = 5;
        nRows = 1;
        rowOffset = 0.1;
        arrayOrigin = new double[3];
        arrayOrigin[0] = 0;
        arrayOrigin[1] = 0;
        arrayOrigin[2] = 0;
        arrayAxis = ARRAYAXIS_Z;
        poloidalAngleStart = 180;
        poloidalAngleStop = 220;
        poloialAngle = 0;
        poloialRTilt = 0;
        poloialZTilt = 0;
        toroidalAngle = 0;
        flipToroidalAngle = false;
        viewGeometry = VIEWGEOMETRY_SURFACES;
        viewDimension = VIEWDIMENSION_THREE;
        donotApplyToAll = true;
        heightPlotScale = 1;
        channelPlotOffset = 0;
        arrayPlotOffset = 0;
        displayTime = DISPLAYTIME_STEP;
        channelGeometry = CHANNELGEOMETRY_LINE;
        radius = 0.1;
        divergence = 1;
        channelProfile = CHANNELPROFILE_TOPHAT;
        standardDeviation = 1;
        sampleDistance = 0.1;
        sampleVolume = 1;
        sampleArc = 10;
        channelIntegration = CHANNELINTEGRATION_NOCHANNELINTEGRATION;
        toroidalIntegration = TOROIDALINTEGRATION_NOTOROIDALINTEGRATION;
        toroidalAngleSampling = TOROIDALANGLESAMPLING_TOROIDALANGLEABSOLUTESAMPLING;
        toroidalAngleStart = 0;
        toroidalAngleStop = 360;
        toroidalAngleStride = 1;
        timeSampling = TIMESAMPLING_CURRENTTIMESTEP;
        timeStepStart = 0;
        timeStepStop = 0;
        timeStepStride = 1;
        channelList = new Vector();
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(90));
        wallList = new Vector();
        wallList.addElement(new Double(0));
        wallList.addElement(new Double(0));
        nChannelListArrays = 1;
        channelListToroidalArrayAngle = 5;
        channelListToroidalAngle = 0;
    }

    public LineSamplerAttributes(int nMoreFields)
    {
        super(LineSamplerAttributes_numAdditionalAtts + nMoreFields);

        meshGeometry = MESHGEOMETRY_TOROIDAL;
        arrayConfiguration = ARRAYCONFIGURATION_GEOMETRY;
        boundary = BOUNDARY_DATA;
        instanceId = 0;
        nArrays = 1;
        toroidalArrayAngle = 5;
        nChannels = 5;
        channelProjection = CHANNELPROJECTION_PARALLEL;
        channelLayoutType = CHANNELLAYOUTTYPE_CHANNELRELATIVE;
        channelOffset = 0.1;
        channelAngle = 5;
        nRows = 1;
        rowOffset = 0.1;
        arrayOrigin = new double[3];
        arrayOrigin[0] = 0;
        arrayOrigin[1] = 0;
        arrayOrigin[2] = 0;
        arrayAxis = ARRAYAXIS_Z;
        poloidalAngleStart = 180;
        poloidalAngleStop = 220;
        poloialAngle = 0;
        poloialRTilt = 0;
        poloialZTilt = 0;
        toroidalAngle = 0;
        flipToroidalAngle = false;
        viewGeometry = VIEWGEOMETRY_SURFACES;
        viewDimension = VIEWDIMENSION_THREE;
        donotApplyToAll = true;
        heightPlotScale = 1;
        channelPlotOffset = 0;
        arrayPlotOffset = 0;
        displayTime = DISPLAYTIME_STEP;
        channelGeometry = CHANNELGEOMETRY_LINE;
        radius = 0.1;
        divergence = 1;
        channelProfile = CHANNELPROFILE_TOPHAT;
        standardDeviation = 1;
        sampleDistance = 0.1;
        sampleVolume = 1;
        sampleArc = 10;
        channelIntegration = CHANNELINTEGRATION_NOCHANNELINTEGRATION;
        toroidalIntegration = TOROIDALINTEGRATION_NOTOROIDALINTEGRATION;
        toroidalAngleSampling = TOROIDALANGLESAMPLING_TOROIDALANGLEABSOLUTESAMPLING;
        toroidalAngleStart = 0;
        toroidalAngleStop = 360;
        toroidalAngleStride = 1;
        timeSampling = TIMESAMPLING_CURRENTTIMESTEP;
        timeStepStart = 0;
        timeStepStop = 0;
        timeStepStride = 1;
        channelList = new Vector();
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(0));
        channelList.addElement(new Double(90));
        wallList = new Vector();
        wallList.addElement(new Double(0));
        wallList.addElement(new Double(0));
        nChannelListArrays = 1;
        channelListToroidalArrayAngle = 5;
        channelListToroidalAngle = 0;
    }

    public LineSamplerAttributes(LineSamplerAttributes obj)
    {
        super(obj);

        int i;

        meshGeometry = obj.meshGeometry;
        arrayConfiguration = obj.arrayConfiguration;
        boundary = obj.boundary;
        instanceId = obj.instanceId;
        nArrays = obj.nArrays;
        toroidalArrayAngle = obj.toroidalArrayAngle;
        nChannels = obj.nChannels;
        channelProjection = obj.channelProjection;
        channelLayoutType = obj.channelLayoutType;
        channelOffset = obj.channelOffset;
        channelAngle = obj.channelAngle;
        nRows = obj.nRows;
        rowOffset = obj.rowOffset;
        arrayOrigin = new double[3];
        arrayOrigin[0] = obj.arrayOrigin[0];
        arrayOrigin[1] = obj.arrayOrigin[1];
        arrayOrigin[2] = obj.arrayOrigin[2];

        arrayAxis = obj.arrayAxis;
        poloidalAngleStart = obj.poloidalAngleStart;
        poloidalAngleStop = obj.poloidalAngleStop;
        poloialAngle = obj.poloialAngle;
        poloialRTilt = obj.poloialRTilt;
        poloialZTilt = obj.poloialZTilt;
        toroidalAngle = obj.toroidalAngle;
        flipToroidalAngle = obj.flipToroidalAngle;
        viewGeometry = obj.viewGeometry;
        viewDimension = obj.viewDimension;
        donotApplyToAll = obj.donotApplyToAll;
        heightPlotScale = obj.heightPlotScale;
        channelPlotOffset = obj.channelPlotOffset;
        arrayPlotOffset = obj.arrayPlotOffset;
        displayTime = obj.displayTime;
        channelGeometry = obj.channelGeometry;
        radius = obj.radius;
        divergence = obj.divergence;
        channelProfile = obj.channelProfile;
        standardDeviation = obj.standardDeviation;
        sampleDistance = obj.sampleDistance;
        sampleVolume = obj.sampleVolume;
        sampleArc = obj.sampleArc;
        channelIntegration = obj.channelIntegration;
        toroidalIntegration = obj.toroidalIntegration;
        toroidalAngleSampling = obj.toroidalAngleSampling;
        toroidalAngleStart = obj.toroidalAngleStart;
        toroidalAngleStop = obj.toroidalAngleStop;
        toroidalAngleStride = obj.toroidalAngleStride;
        timeSampling = obj.timeSampling;
        timeStepStart = obj.timeStepStart;
        timeStepStop = obj.timeStepStop;
        timeStepStride = obj.timeStepStride;
        channelList = new Vector(obj.channelList.size());
        for(i = 0; i < obj.channelList.size(); ++i)
        {
            Double dv = (Double)obj.channelList.elementAt(i);
            channelList.addElement(new Double(dv.doubleValue()));
        }

        wallList = new Vector(obj.wallList.size());
        for(i = 0; i < obj.wallList.size(); ++i)
        {
            Double dv = (Double)obj.wallList.elementAt(i);
            wallList.addElement(new Double(dv.doubleValue()));
        }

        nChannelListArrays = obj.nChannelListArrays;
        channelListToroidalArrayAngle = obj.channelListToroidalArrayAngle;
        channelListToroidalAngle = obj.channelListToroidalAngle;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return LineSamplerAttributes_numAdditionalAtts;
    }

    public boolean equals(LineSamplerAttributes obj)
    {
        int i;

        // Compare the arrayOrigin arrays.
        boolean arrayOrigin_equal = true;
        for(i = 0; i < 3 && arrayOrigin_equal; ++i)
            arrayOrigin_equal = (arrayOrigin[i] == obj.arrayOrigin[i]);

        // Compare the elements in the channelList vector.
        boolean channelList_equal = (obj.channelList.size() == channelList.size());
        for(i = 0; (i < channelList.size()) && channelList_equal; ++i)
        {
            // Make references to Double from Object.
            Double channelList1 = (Double)channelList.elementAt(i);
            Double channelList2 = (Double)obj.channelList.elementAt(i);
            channelList_equal = channelList1.equals(channelList2);
        }
        // Compare the elements in the wallList vector.
        boolean wallList_equal = (obj.wallList.size() == wallList.size());
        for(i = 0; (i < wallList.size()) && wallList_equal; ++i)
        {
            // Make references to Double from Object.
            Double wallList1 = (Double)wallList.elementAt(i);
            Double wallList2 = (Double)obj.wallList.elementAt(i);
            wallList_equal = wallList1.equals(wallList2);
        }
        // Create the return value
        return ((meshGeometry == obj.meshGeometry) &&
                (arrayConfiguration == obj.arrayConfiguration) &&
                (boundary == obj.boundary) &&
                (instanceId == obj.instanceId) &&
                (nArrays == obj.nArrays) &&
                (toroidalArrayAngle == obj.toroidalArrayAngle) &&
                (nChannels == obj.nChannels) &&
                (channelProjection == obj.channelProjection) &&
                (channelLayoutType == obj.channelLayoutType) &&
                (channelOffset == obj.channelOffset) &&
                (channelAngle == obj.channelAngle) &&
                (nRows == obj.nRows) &&
                (rowOffset == obj.rowOffset) &&
                arrayOrigin_equal &&
                (arrayAxis == obj.arrayAxis) &&
                (poloidalAngleStart == obj.poloidalAngleStart) &&
                (poloidalAngleStop == obj.poloidalAngleStop) &&
                (poloialAngle == obj.poloialAngle) &&
                (poloialRTilt == obj.poloialRTilt) &&
                (poloialZTilt == obj.poloialZTilt) &&
                (toroidalAngle == obj.toroidalAngle) &&
                (flipToroidalAngle == obj.flipToroidalAngle) &&
                (viewGeometry == obj.viewGeometry) &&
                (viewDimension == obj.viewDimension) &&
                (donotApplyToAll == obj.donotApplyToAll) &&
                (heightPlotScale == obj.heightPlotScale) &&
                (channelPlotOffset == obj.channelPlotOffset) &&
                (arrayPlotOffset == obj.arrayPlotOffset) &&
                (displayTime == obj.displayTime) &&
                (channelGeometry == obj.channelGeometry) &&
                (radius == obj.radius) &&
                (divergence == obj.divergence) &&
                (channelProfile == obj.channelProfile) &&
                (standardDeviation == obj.standardDeviation) &&
                (sampleDistance == obj.sampleDistance) &&
                (sampleVolume == obj.sampleVolume) &&
                (sampleArc == obj.sampleArc) &&
                (channelIntegration == obj.channelIntegration) &&
                (toroidalIntegration == obj.toroidalIntegration) &&
                (toroidalAngleSampling == obj.toroidalAngleSampling) &&
                (toroidalAngleStart == obj.toroidalAngleStart) &&
                (toroidalAngleStop == obj.toroidalAngleStop) &&
                (toroidalAngleStride == obj.toroidalAngleStride) &&
                (timeSampling == obj.timeSampling) &&
                (timeStepStart == obj.timeStepStart) &&
                (timeStepStop == obj.timeStepStop) &&
                (timeStepStride == obj.timeStepStride) &&
                channelList_equal &&
                wallList_equal &&
                (nChannelListArrays == obj.nChannelListArrays) &&
                (channelListToroidalArrayAngle == obj.channelListToroidalArrayAngle) &&
                (channelListToroidalAngle == obj.channelListToroidalAngle));
    }

    public String GetName() { return "LineSampler"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetMeshGeometry(int meshGeometry_)
    {
        meshGeometry = meshGeometry_;
        Select(0);
    }

    public void SetArrayConfiguration(int arrayConfiguration_)
    {
        arrayConfiguration = arrayConfiguration_;
        Select(1);
    }

    public void SetBoundary(int boundary_)
    {
        boundary = boundary_;
        Select(2);
    }

    public void SetInstanceId(int instanceId_)
    {
        instanceId = instanceId_;
        Select(3);
    }

    public void SetNArrays(int nArrays_)
    {
        nArrays = nArrays_;
        Select(4);
    }

    public void SetToroidalArrayAngle(double toroidalArrayAngle_)
    {
        toroidalArrayAngle = toroidalArrayAngle_;
        Select(5);
    }

    public void SetNChannels(int nChannels_)
    {
        nChannels = nChannels_;
        Select(6);
    }

    public void SetChannelProjection(int channelProjection_)
    {
        channelProjection = channelProjection_;
        Select(7);
    }

    public void SetChannelLayoutType(int channelLayoutType_)
    {
        channelLayoutType = channelLayoutType_;
        Select(8);
    }

    public void SetChannelOffset(double channelOffset_)
    {
        channelOffset = channelOffset_;
        Select(9);
    }

    public void SetChannelAngle(double channelAngle_)
    {
        channelAngle = channelAngle_;
        Select(10);
    }

    public void SetNRows(int nRows_)
    {
        nRows = nRows_;
        Select(11);
    }

    public void SetRowOffset(double rowOffset_)
    {
        rowOffset = rowOffset_;
        Select(12);
    }

    public void SetArrayOrigin(double[] arrayOrigin_)
    {
        arrayOrigin[0] = arrayOrigin_[0];
        arrayOrigin[1] = arrayOrigin_[1];
        arrayOrigin[2] = arrayOrigin_[2];
        Select(13);
    }

    public void SetArrayOrigin(double e0, double e1, double e2)
    {
        arrayOrigin[0] = e0;
        arrayOrigin[1] = e1;
        arrayOrigin[2] = e2;
        Select(13);
    }

    public void SetArrayAxis(int arrayAxis_)
    {
        arrayAxis = arrayAxis_;
        Select(14);
    }

    public void SetPoloidalAngleStart(double poloidalAngleStart_)
    {
        poloidalAngleStart = poloidalAngleStart_;
        Select(15);
    }

    public void SetPoloidalAngleStop(double poloidalAngleStop_)
    {
        poloidalAngleStop = poloidalAngleStop_;
        Select(16);
    }

    public void SetPoloialAngle(double poloialAngle_)
    {
        poloialAngle = poloialAngle_;
        Select(17);
    }

    public void SetPoloialRTilt(double poloialRTilt_)
    {
        poloialRTilt = poloialRTilt_;
        Select(18);
    }

    public void SetPoloialZTilt(double poloialZTilt_)
    {
        poloialZTilt = poloialZTilt_;
        Select(19);
    }

    public void SetToroidalAngle(double toroidalAngle_)
    {
        toroidalAngle = toroidalAngle_;
        Select(20);
    }

    public void SetFlipToroidalAngle(boolean flipToroidalAngle_)
    {
        flipToroidalAngle = flipToroidalAngle_;
        Select(21);
    }

    public void SetViewGeometry(int viewGeometry_)
    {
        viewGeometry = viewGeometry_;
        Select(22);
    }

    public void SetViewDimension(int viewDimension_)
    {
        viewDimension = viewDimension_;
        Select(23);
    }

    public void SetDonotApplyToAll(boolean donotApplyToAll_)
    {
        donotApplyToAll = donotApplyToAll_;
        Select(24);
    }

    public void SetHeightPlotScale(double heightPlotScale_)
    {
        heightPlotScale = heightPlotScale_;
        Select(25);
    }

    public void SetChannelPlotOffset(double channelPlotOffset_)
    {
        channelPlotOffset = channelPlotOffset_;
        Select(26);
    }

    public void SetArrayPlotOffset(double arrayPlotOffset_)
    {
        arrayPlotOffset = arrayPlotOffset_;
        Select(27);
    }

    public void SetDisplayTime(int displayTime_)
    {
        displayTime = displayTime_;
        Select(28);
    }

    public void SetChannelGeometry(int channelGeometry_)
    {
        channelGeometry = channelGeometry_;
        Select(29);
    }

    public void SetRadius(double radius_)
    {
        radius = radius_;
        Select(30);
    }

    public void SetDivergence(double divergence_)
    {
        divergence = divergence_;
        Select(31);
    }

    public void SetChannelProfile(int channelProfile_)
    {
        channelProfile = channelProfile_;
        Select(32);
    }

    public void SetStandardDeviation(double standardDeviation_)
    {
        standardDeviation = standardDeviation_;
        Select(33);
    }

    public void SetSampleDistance(double sampleDistance_)
    {
        sampleDistance = sampleDistance_;
        Select(34);
    }

    public void SetSampleVolume(double sampleVolume_)
    {
        sampleVolume = sampleVolume_;
        Select(35);
    }

    public void SetSampleArc(double sampleArc_)
    {
        sampleArc = sampleArc_;
        Select(36);
    }

    public void SetChannelIntegration(int channelIntegration_)
    {
        channelIntegration = channelIntegration_;
        Select(37);
    }

    public void SetToroidalIntegration(int toroidalIntegration_)
    {
        toroidalIntegration = toroidalIntegration_;
        Select(38);
    }

    public void SetToroidalAngleSampling(int toroidalAngleSampling_)
    {
        toroidalAngleSampling = toroidalAngleSampling_;
        Select(39);
    }

    public void SetToroidalAngleStart(double toroidalAngleStart_)
    {
        toroidalAngleStart = toroidalAngleStart_;
        Select(40);
    }

    public void SetToroidalAngleStop(double toroidalAngleStop_)
    {
        toroidalAngleStop = toroidalAngleStop_;
        Select(41);
    }

    public void SetToroidalAngleStride(double toroidalAngleStride_)
    {
        toroidalAngleStride = toroidalAngleStride_;
        Select(42);
    }

    public void SetTimeSampling(int timeSampling_)
    {
        timeSampling = timeSampling_;
        Select(43);
    }

    public void SetTimeStepStart(int timeStepStart_)
    {
        timeStepStart = timeStepStart_;
        Select(44);
    }

    public void SetTimeStepStop(int timeStepStop_)
    {
        timeStepStop = timeStepStop_;
        Select(45);
    }

    public void SetTimeStepStride(int timeStepStride_)
    {
        timeStepStride = timeStepStride_;
        Select(46);
    }

    public void SetChannelList(Vector channelList_)
    {
        channelList = channelList_;
        Select(47);
    }

    public void SetWallList(Vector wallList_)
    {
        wallList = wallList_;
        Select(48);
    }

    public void SetNChannelListArrays(int nChannelListArrays_)
    {
        nChannelListArrays = nChannelListArrays_;
        Select(49);
    }

    public void SetChannelListToroidalArrayAngle(double channelListToroidalArrayAngle_)
    {
        channelListToroidalArrayAngle = channelListToroidalArrayAngle_;
        Select(50);
    }

    public void SetChannelListToroidalAngle(double channelListToroidalAngle_)
    {
        channelListToroidalAngle = channelListToroidalAngle_;
        Select(51);
    }

    // Property getting methods
    public int      GetMeshGeometry() { return meshGeometry; }
    public int      GetArrayConfiguration() { return arrayConfiguration; }
    public int      GetBoundary() { return boundary; }
    public int      GetInstanceId() { return instanceId; }
    public int      GetNArrays() { return nArrays; }
    public double   GetToroidalArrayAngle() { return toroidalArrayAngle; }
    public int      GetNChannels() { return nChannels; }
    public int      GetChannelProjection() { return channelProjection; }
    public int      GetChannelLayoutType() { return channelLayoutType; }
    public double   GetChannelOffset() { return channelOffset; }
    public double   GetChannelAngle() { return channelAngle; }
    public int      GetNRows() { return nRows; }
    public double   GetRowOffset() { return rowOffset; }
    public double[] GetArrayOrigin() { return arrayOrigin; }
    public int      GetArrayAxis() { return arrayAxis; }
    public double   GetPoloidalAngleStart() { return poloidalAngleStart; }
    public double   GetPoloidalAngleStop() { return poloidalAngleStop; }
    public double   GetPoloialAngle() { return poloialAngle; }
    public double   GetPoloialRTilt() { return poloialRTilt; }
    public double   GetPoloialZTilt() { return poloialZTilt; }
    public double   GetToroidalAngle() { return toroidalAngle; }
    public boolean  GetFlipToroidalAngle() { return flipToroidalAngle; }
    public int      GetViewGeometry() { return viewGeometry; }
    public int      GetViewDimension() { return viewDimension; }
    public boolean  GetDonotApplyToAll() { return donotApplyToAll; }
    public double   GetHeightPlotScale() { return heightPlotScale; }
    public double   GetChannelPlotOffset() { return channelPlotOffset; }
    public double   GetArrayPlotOffset() { return arrayPlotOffset; }
    public int      GetDisplayTime() { return displayTime; }
    public int      GetChannelGeometry() { return channelGeometry; }
    public double   GetRadius() { return radius; }
    public double   GetDivergence() { return divergence; }
    public int      GetChannelProfile() { return channelProfile; }
    public double   GetStandardDeviation() { return standardDeviation; }
    public double   GetSampleDistance() { return sampleDistance; }
    public double   GetSampleVolume() { return sampleVolume; }
    public double   GetSampleArc() { return sampleArc; }
    public int      GetChannelIntegration() { return channelIntegration; }
    public int      GetToroidalIntegration() { return toroidalIntegration; }
    public int      GetToroidalAngleSampling() { return toroidalAngleSampling; }
    public double   GetToroidalAngleStart() { return toroidalAngleStart; }
    public double   GetToroidalAngleStop() { return toroidalAngleStop; }
    public double   GetToroidalAngleStride() { return toroidalAngleStride; }
    public int      GetTimeSampling() { return timeSampling; }
    public int      GetTimeStepStart() { return timeStepStart; }
    public int      GetTimeStepStop() { return timeStepStop; }
    public int      GetTimeStepStride() { return timeStepStride; }
    public Vector   GetChannelList() { return channelList; }
    public Vector   GetWallList() { return wallList; }
    public int      GetNChannelListArrays() { return nChannelListArrays; }
    public double   GetChannelListToroidalArrayAngle() { return channelListToroidalArrayAngle; }
    public double   GetChannelListToroidalAngle() { return channelListToroidalAngle; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(meshGeometry);
        if(WriteSelect(1, buf))
            buf.WriteInt(arrayConfiguration);
        if(WriteSelect(2, buf))
            buf.WriteInt(boundary);
        if(WriteSelect(3, buf))
            buf.WriteInt(instanceId);
        if(WriteSelect(4, buf))
            buf.WriteInt(nArrays);
        if(WriteSelect(5, buf))
            buf.WriteDouble(toroidalArrayAngle);
        if(WriteSelect(6, buf))
            buf.WriteInt(nChannels);
        if(WriteSelect(7, buf))
            buf.WriteInt(channelProjection);
        if(WriteSelect(8, buf))
            buf.WriteInt(channelLayoutType);
        if(WriteSelect(9, buf))
            buf.WriteDouble(channelOffset);
        if(WriteSelect(10, buf))
            buf.WriteDouble(channelAngle);
        if(WriteSelect(11, buf))
            buf.WriteInt(nRows);
        if(WriteSelect(12, buf))
            buf.WriteDouble(rowOffset);
        if(WriteSelect(13, buf))
            buf.WriteDoubleArray(arrayOrigin);
        if(WriteSelect(14, buf))
            buf.WriteInt(arrayAxis);
        if(WriteSelect(15, buf))
            buf.WriteDouble(poloidalAngleStart);
        if(WriteSelect(16, buf))
            buf.WriteDouble(poloidalAngleStop);
        if(WriteSelect(17, buf))
            buf.WriteDouble(poloialAngle);
        if(WriteSelect(18, buf))
            buf.WriteDouble(poloialRTilt);
        if(WriteSelect(19, buf))
            buf.WriteDouble(poloialZTilt);
        if(WriteSelect(20, buf))
            buf.WriteDouble(toroidalAngle);
        if(WriteSelect(21, buf))
            buf.WriteBool(flipToroidalAngle);
        if(WriteSelect(22, buf))
            buf.WriteInt(viewGeometry);
        if(WriteSelect(23, buf))
            buf.WriteInt(viewDimension);
        if(WriteSelect(24, buf))
            buf.WriteBool(donotApplyToAll);
        if(WriteSelect(25, buf))
            buf.WriteDouble(heightPlotScale);
        if(WriteSelect(26, buf))
            buf.WriteDouble(channelPlotOffset);
        if(WriteSelect(27, buf))
            buf.WriteDouble(arrayPlotOffset);
        if(WriteSelect(28, buf))
            buf.WriteInt(displayTime);
        if(WriteSelect(29, buf))
            buf.WriteInt(channelGeometry);
        if(WriteSelect(30, buf))
            buf.WriteDouble(radius);
        if(WriteSelect(31, buf))
            buf.WriteDouble(divergence);
        if(WriteSelect(32, buf))
            buf.WriteInt(channelProfile);
        if(WriteSelect(33, buf))
            buf.WriteDouble(standardDeviation);
        if(WriteSelect(34, buf))
            buf.WriteDouble(sampleDistance);
        if(WriteSelect(35, buf))
            buf.WriteDouble(sampleVolume);
        if(WriteSelect(36, buf))
            buf.WriteDouble(sampleArc);
        if(WriteSelect(37, buf))
            buf.WriteInt(channelIntegration);
        if(WriteSelect(38, buf))
            buf.WriteInt(toroidalIntegration);
        if(WriteSelect(39, buf))
            buf.WriteInt(toroidalAngleSampling);
        if(WriteSelect(40, buf))
            buf.WriteDouble(toroidalAngleStart);
        if(WriteSelect(41, buf))
            buf.WriteDouble(toroidalAngleStop);
        if(WriteSelect(42, buf))
            buf.WriteDouble(toroidalAngleStride);
        if(WriteSelect(43, buf))
            buf.WriteInt(timeSampling);
        if(WriteSelect(44, buf))
            buf.WriteInt(timeStepStart);
        if(WriteSelect(45, buf))
            buf.WriteInt(timeStepStop);
        if(WriteSelect(46, buf))
            buf.WriteInt(timeStepStride);
        if(WriteSelect(47, buf))
            buf.WriteDoubleVector(channelList);
        if(WriteSelect(48, buf))
            buf.WriteDoubleVector(wallList);
        if(WriteSelect(49, buf))
            buf.WriteInt(nChannelListArrays);
        if(WriteSelect(50, buf))
            buf.WriteDouble(channelListToroidalArrayAngle);
        if(WriteSelect(51, buf))
            buf.WriteDouble(channelListToroidalAngle);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetMeshGeometry(buf.ReadInt());
            break;
        case 1:
            SetArrayConfiguration(buf.ReadInt());
            break;
        case 2:
            SetBoundary(buf.ReadInt());
            break;
        case 3:
            SetInstanceId(buf.ReadInt());
            break;
        case 4:
            SetNArrays(buf.ReadInt());
            break;
        case 5:
            SetToroidalArrayAngle(buf.ReadDouble());
            break;
        case 6:
            SetNChannels(buf.ReadInt());
            break;
        case 7:
            SetChannelProjection(buf.ReadInt());
            break;
        case 8:
            SetChannelLayoutType(buf.ReadInt());
            break;
        case 9:
            SetChannelOffset(buf.ReadDouble());
            break;
        case 10:
            SetChannelAngle(buf.ReadDouble());
            break;
        case 11:
            SetNRows(buf.ReadInt());
            break;
        case 12:
            SetRowOffset(buf.ReadDouble());
            break;
        case 13:
            SetArrayOrigin(buf.ReadDoubleArray());
            break;
        case 14:
            SetArrayAxis(buf.ReadInt());
            break;
        case 15:
            SetPoloidalAngleStart(buf.ReadDouble());
            break;
        case 16:
            SetPoloidalAngleStop(buf.ReadDouble());
            break;
        case 17:
            SetPoloialAngle(buf.ReadDouble());
            break;
        case 18:
            SetPoloialRTilt(buf.ReadDouble());
            break;
        case 19:
            SetPoloialZTilt(buf.ReadDouble());
            break;
        case 20:
            SetToroidalAngle(buf.ReadDouble());
            break;
        case 21:
            SetFlipToroidalAngle(buf.ReadBool());
            break;
        case 22:
            SetViewGeometry(buf.ReadInt());
            break;
        case 23:
            SetViewDimension(buf.ReadInt());
            break;
        case 24:
            SetDonotApplyToAll(buf.ReadBool());
            break;
        case 25:
            SetHeightPlotScale(buf.ReadDouble());
            break;
        case 26:
            SetChannelPlotOffset(buf.ReadDouble());
            break;
        case 27:
            SetArrayPlotOffset(buf.ReadDouble());
            break;
        case 28:
            SetDisplayTime(buf.ReadInt());
            break;
        case 29:
            SetChannelGeometry(buf.ReadInt());
            break;
        case 30:
            SetRadius(buf.ReadDouble());
            break;
        case 31:
            SetDivergence(buf.ReadDouble());
            break;
        case 32:
            SetChannelProfile(buf.ReadInt());
            break;
        case 33:
            SetStandardDeviation(buf.ReadDouble());
            break;
        case 34:
            SetSampleDistance(buf.ReadDouble());
            break;
        case 35:
            SetSampleVolume(buf.ReadDouble());
            break;
        case 36:
            SetSampleArc(buf.ReadDouble());
            break;
        case 37:
            SetChannelIntegration(buf.ReadInt());
            break;
        case 38:
            SetToroidalIntegration(buf.ReadInt());
            break;
        case 39:
            SetToroidalAngleSampling(buf.ReadInt());
            break;
        case 40:
            SetToroidalAngleStart(buf.ReadDouble());
            break;
        case 41:
            SetToroidalAngleStop(buf.ReadDouble());
            break;
        case 42:
            SetToroidalAngleStride(buf.ReadDouble());
            break;
        case 43:
            SetTimeSampling(buf.ReadInt());
            break;
        case 44:
            SetTimeStepStart(buf.ReadInt());
            break;
        case 45:
            SetTimeStepStop(buf.ReadInt());
            break;
        case 46:
            SetTimeStepStride(buf.ReadInt());
            break;
        case 47:
            SetChannelList(buf.ReadDoubleVector());
            break;
        case 48:
            SetWallList(buf.ReadDoubleVector());
            break;
        case 49:
            SetNChannelListArrays(buf.ReadInt());
            break;
        case 50:
            SetChannelListToroidalArrayAngle(buf.ReadDouble());
            break;
        case 51:
            SetChannelListToroidalAngle(buf.ReadDouble());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "meshGeometry = ";
        if(meshGeometry == MESHGEOMETRY_CARTESIAN)
            str = str + "MESHGEOMETRY_CARTESIAN";
        if(meshGeometry == MESHGEOMETRY_CYLINDRICAL)
            str = str + "MESHGEOMETRY_CYLINDRICAL";
        if(meshGeometry == MESHGEOMETRY_TOROIDAL)
            str = str + "MESHGEOMETRY_TOROIDAL";
        str = str + "\n";
        str = str + indent + "arrayConfiguration = ";
        if(arrayConfiguration == ARRAYCONFIGURATION_GEOMETRY)
            str = str + "ARRAYCONFIGURATION_GEOMETRY";
        if(arrayConfiguration == ARRAYCONFIGURATION_MANUAL)
            str = str + "ARRAYCONFIGURATION_MANUAL";
        str = str + "\n";
        str = str + indent + "boundary = ";
        if(boundary == BOUNDARY_DATA)
            str = str + "BOUNDARY_DATA";
        if(boundary == BOUNDARY_WALL)
            str = str + "BOUNDARY_WALL";
        str = str + "\n";
        str = str + intToString("instanceId", instanceId, indent) + "\n";
        str = str + intToString("nArrays", nArrays, indent) + "\n";
        str = str + doubleToString("toroidalArrayAngle", toroidalArrayAngle, indent) + "\n";
        str = str + intToString("nChannels", nChannels, indent) + "\n";
        str = str + indent + "channelProjection = ";
        if(channelProjection == CHANNELPROJECTION_DIVERGENT)
            str = str + "CHANNELPROJECTION_DIVERGENT";
        if(channelProjection == CHANNELPROJECTION_PARALLEL)
            str = str + "CHANNELPROJECTION_PARALLEL";
        if(channelProjection == CHANNELPROJECTION_GRID)
            str = str + "CHANNELPROJECTION_GRID";
        str = str + "\n";
        str = str + indent + "channelLayoutType = ";
        if(channelLayoutType == CHANNELLAYOUTTYPE_CHANNELABSOLUTE)
            str = str + "CHANNELLAYOUTTYPE_CHANNELABSOLUTE";
        if(channelLayoutType == CHANNELLAYOUTTYPE_CHANNELRELATIVE)
            str = str + "CHANNELLAYOUTTYPE_CHANNELRELATIVE";
        str = str + "\n";
        str = str + doubleToString("channelOffset", channelOffset, indent) + "\n";
        str = str + doubleToString("channelAngle", channelAngle, indent) + "\n";
        str = str + intToString("nRows", nRows, indent) + "\n";
        str = str + doubleToString("rowOffset", rowOffset, indent) + "\n";
        str = str + doubleArrayToString("arrayOrigin", arrayOrigin, indent) + "\n";
        str = str + indent + "arrayAxis = ";
        if(arrayAxis == ARRAYAXIS_R)
            str = str + "ARRAYAXIS_R";
        if(arrayAxis == ARRAYAXIS_Z)
            str = str + "ARRAYAXIS_Z";
        str = str + "\n";
        str = str + doubleToString("poloidalAngleStart", poloidalAngleStart, indent) + "\n";
        str = str + doubleToString("poloidalAngleStop", poloidalAngleStop, indent) + "\n";
        str = str + doubleToString("poloialAngle", poloialAngle, indent) + "\n";
        str = str + doubleToString("poloialRTilt", poloialRTilt, indent) + "\n";
        str = str + doubleToString("poloialZTilt", poloialZTilt, indent) + "\n";
        str = str + doubleToString("toroidalAngle", toroidalAngle, indent) + "\n";
        str = str + boolToString("flipToroidalAngle", flipToroidalAngle, indent) + "\n";
        str = str + indent + "viewGeometry = ";
        if(viewGeometry == VIEWGEOMETRY_POINTS)
            str = str + "VIEWGEOMETRY_POINTS";
        if(viewGeometry == VIEWGEOMETRY_LINES)
            str = str + "VIEWGEOMETRY_LINES";
        if(viewGeometry == VIEWGEOMETRY_SURFACES)
            str = str + "VIEWGEOMETRY_SURFACES";
        str = str + "\n";
        str = str + indent + "viewDimension = ";
        if(viewDimension == VIEWDIMENSION_ONE)
            str = str + "VIEWDIMENSION_ONE";
        if(viewDimension == VIEWDIMENSION_TWO)
            str = str + "VIEWDIMENSION_TWO";
        if(viewDimension == VIEWDIMENSION_THREE)
            str = str + "VIEWDIMENSION_THREE";
        str = str + "\n";
        str = str + boolToString("donotApplyToAll", donotApplyToAll, indent) + "\n";
        str = str + doubleToString("heightPlotScale", heightPlotScale, indent) + "\n";
        str = str + doubleToString("channelPlotOffset", channelPlotOffset, indent) + "\n";
        str = str + doubleToString("arrayPlotOffset", arrayPlotOffset, indent) + "\n";
        str = str + indent + "displayTime = ";
        if(displayTime == DISPLAYTIME_STEP)
            str = str + "DISPLAYTIME_STEP";
        if(displayTime == DISPLAYTIME_TIME)
            str = str + "DISPLAYTIME_TIME";
        if(displayTime == DISPLAYTIME_CYCLE)
            str = str + "DISPLAYTIME_CYCLE";
        str = str + "\n";
        str = str + indent + "channelGeometry = ";
        if(channelGeometry == CHANNELGEOMETRY_POINT)
            str = str + "CHANNELGEOMETRY_POINT";
        if(channelGeometry == CHANNELGEOMETRY_LINE)
            str = str + "CHANNELGEOMETRY_LINE";
        if(channelGeometry == CHANNELGEOMETRY_CYLINDER)
            str = str + "CHANNELGEOMETRY_CYLINDER";
        if(channelGeometry == CHANNELGEOMETRY_CONE)
            str = str + "CHANNELGEOMETRY_CONE";
        str = str + "\n";
        str = str + doubleToString("radius", radius, indent) + "\n";
        str = str + doubleToString("divergence", divergence, indent) + "\n";
        str = str + indent + "channelProfile = ";
        if(channelProfile == CHANNELPROFILE_TOPHAT)
            str = str + "CHANNELPROFILE_TOPHAT";
        if(channelProfile == CHANNELPROFILE_GAUSSIAN)
            str = str + "CHANNELPROFILE_GAUSSIAN";
        str = str + "\n";
        str = str + doubleToString("standardDeviation", standardDeviation, indent) + "\n";
        str = str + doubleToString("sampleDistance", sampleDistance, indent) + "\n";
        str = str + doubleToString("sampleVolume", sampleVolume, indent) + "\n";
        str = str + doubleToString("sampleArc", sampleArc, indent) + "\n";
        str = str + indent + "channelIntegration = ";
        if(channelIntegration == CHANNELINTEGRATION_NOCHANNELINTEGRATION)
            str = str + "CHANNELINTEGRATION_NOCHANNELINTEGRATION";
        if(channelIntegration == CHANNELINTEGRATION_INTEGRATEALONGCHANNEL)
            str = str + "CHANNELINTEGRATION_INTEGRATEALONGCHANNEL";
        str = str + "\n";
        str = str + indent + "toroidalIntegration = ";
        if(toroidalIntegration == TOROIDALINTEGRATION_NOTOROIDALINTEGRATION)
            str = str + "TOROIDALINTEGRATION_NOTOROIDALINTEGRATION";
        if(toroidalIntegration == TOROIDALINTEGRATION_TOROIDALTIMESAMPLE)
            str = str + "TOROIDALINTEGRATION_TOROIDALTIMESAMPLE";
        if(toroidalIntegration == TOROIDALINTEGRATION_INTEGRATETOROIDALLY)
            str = str + "TOROIDALINTEGRATION_INTEGRATETOROIDALLY";
        str = str + "\n";
        str = str + indent + "toroidalAngleSampling = ";
        if(toroidalAngleSampling == TOROIDALANGLESAMPLING_TOROIDALANGLEABSOLUTESAMPLING)
            str = str + "TOROIDALANGLESAMPLING_TOROIDALANGLEABSOLUTESAMPLING";
        if(toroidalAngleSampling == TOROIDALANGLESAMPLING_TOROIDALANGLERELATIVESAMPLING)
            str = str + "TOROIDALANGLESAMPLING_TOROIDALANGLERELATIVESAMPLING";
        str = str + "\n";
        str = str + doubleToString("toroidalAngleStart", toroidalAngleStart, indent) + "\n";
        str = str + doubleToString("toroidalAngleStop", toroidalAngleStop, indent) + "\n";
        str = str + doubleToString("toroidalAngleStride", toroidalAngleStride, indent) + "\n";
        str = str + indent + "timeSampling = ";
        if(timeSampling == TIMESAMPLING_CURRENTTIMESTEP)
            str = str + "TIMESAMPLING_CURRENTTIMESTEP";
        if(timeSampling == TIMESAMPLING_MULTIPLETIMESTEPS)
            str = str + "TIMESAMPLING_MULTIPLETIMESTEPS";
        str = str + "\n";
        str = str + intToString("timeStepStart", timeStepStart, indent) + "\n";
        str = str + intToString("timeStepStop", timeStepStop, indent) + "\n";
        str = str + intToString("timeStepStride", timeStepStride, indent) + "\n";
        str = str + doubleVectorToString("channelList", channelList, indent) + "\n";
        str = str + doubleVectorToString("wallList", wallList, indent) + "\n";
        str = str + intToString("nChannelListArrays", nChannelListArrays, indent) + "\n";
        str = str + doubleToString("channelListToroidalArrayAngle", channelListToroidalArrayAngle, indent) + "\n";
        str = str + doubleToString("channelListToroidalAngle", channelListToroidalAngle, indent) + "\n";
        return str;
    }


    // Attributes
    private int      meshGeometry;
    private int      arrayConfiguration;
    private int      boundary;
    private int      instanceId;
    private int      nArrays;
    private double   toroidalArrayAngle;
    private int      nChannels;
    private int      channelProjection;
    private int      channelLayoutType;
    private double   channelOffset;
    private double   channelAngle;
    private int      nRows;
    private double   rowOffset;
    private double[] arrayOrigin;
    private int      arrayAxis;
    private double   poloidalAngleStart;
    private double   poloidalAngleStop;
    private double   poloialAngle;
    private double   poloialRTilt;
    private double   poloialZTilt;
    private double   toroidalAngle;
    private boolean  flipToroidalAngle;
    private int      viewGeometry;
    private int      viewDimension;
    private boolean  donotApplyToAll;
    private double   heightPlotScale;
    private double   channelPlotOffset;
    private double   arrayPlotOffset;
    private int      displayTime;
    private int      channelGeometry;
    private double   radius;
    private double   divergence;
    private int      channelProfile;
    private double   standardDeviation;
    private double   sampleDistance;
    private double   sampleVolume;
    private double   sampleArc;
    private int      channelIntegration;
    private int      toroidalIntegration;
    private int      toroidalAngleSampling;
    private double   toroidalAngleStart;
    private double   toroidalAngleStop;
    private double   toroidalAngleStride;
    private int      timeSampling;
    private int      timeStepStart;
    private int      timeStepStop;
    private int      timeStepStride;
    private Vector   channelList; // vector of Double objects
    private Vector   wallList; // vector of Double objects
    private int      nChannelListArrays;
    private double   channelListToroidalArrayAngle;
    private double   channelListToroidalAngle;
}

