/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.vrml97;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.web3d.parser.vrml97.JavaCharStream;
import org.web3d.parser.vrml97.ParseException;
import org.web3d.parser.vrml97.Token;
import org.web3d.parser.vrml97.VRML97RelaxedParserConstants;
import org.web3d.parser.vrml97.VRML97RelaxedParserTokenManager;
import org.web3d.util.ErrorReporter;
import org.web3d.util.StringArray;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;

public class VRML97RelaxedParser
implements VRML97RelaxedParserConstants {
    private static final String PARSE_MSG = "Parsing error: ";
    private static final int DEFAULT_ARRAY_SIZE = 4096;
    private static final int DEFAULT_ARRAY_INC = 1024;
    private String documentURL;
    private StringContentHandler contentHandler;
    private RouteHandler routeHandler;
    private ScriptHandler scriptHandler;
    private ProtoHandler protoHandler;
    private ErrorReporter errorHandler;
    private Locator locator;
    private StringArray stringArray;
    public VRML97RelaxedParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[31];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public VRML97RelaxedParser(InputStream inputStream, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this(inputStream);
        this.locator = new VRMLRelaxedLocator();
        this.stringArray = new StringArray(4096, 1024);
        this.contentHandler = (StringContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
    }

    public VRML97RelaxedParser(Reader reader, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this(reader);
        this.locator = new VRMLRelaxedLocator();
        this.stringArray = new StringArray(4096, 1024);
        this.contentHandler = (StringContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
    }

    public void initialize() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        this.stringArray = new StringArray(4096, 1024);
    }

    public void setDocumentUrl(String string) {
        this.documentURL = string;
    }

    public Locator getDocumentLocator() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        return this.locator;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = (StringContentHandler)contentHandler;
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.routeHandler = routeHandler;
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.protoHandler = protoHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (errorHandler != null) {
            errorHandler.setDocumentLocator(this.getDocumentLocator());
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter instanceof ErrorHandler) {
            this.setErrorHandler((ErrorHandler)errorReporter);
        } else {
            this.errorHandler = errorReporter;
        }
    }

    private void convertException(VRMLException vRMLException) throws ParseException {
        boolean bl = false;
        if (vRMLException instanceof InvalidFieldException || vRMLException instanceof InvalidFieldValueException) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.warningReport(PARSE_MSG, vRMLException);
                    bl = true;
                }
                catch (VRMLException vRMLException2) {
                    vRMLException = vRMLException2;
                }
            }
        } else if (this.errorHandler != null) {
            try {
                this.errorHandler.errorReport(PARSE_MSG, vRMLException);
                bl = true;
            }
            catch (VRMLException vRMLException3) {
                vRMLException = vRMLException3;
            }
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("There's an error in the file:\n");
            stringBuffer.append(this.documentURL);
            stringBuffer.append('\n');
            String string = vRMLException.getMessage();
            if (string == null) {
                string = vRMLException.getClass().getName();
            }
            stringBuffer.append(string);
            stringBuffer.append('\n');
            throw new ParseException(stringBuffer.toString());
        }
    }

    private String stripString() {
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Scene() throws ParseException {
        try {
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 17: 
                    case 22: 
                    case 23: 
                    case 27: 
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block6;
                    }
                }
                this.Statement();
            }
            this.jj_consume_token(0);
        }
        finally {
            this.documentURL = null;
        }
    }

    public final void Statement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 27: 
            case 30: {
                this.NodeStatement();
                break;
            }
            case 17: 
            case 22: {
                this.ProtoStatement();
                break;
            }
            case 23: {
                this.RouteStatement();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NodeStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 30: {
                this.Node(null);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                String string = this.NodeNameId();
                this.Node(string);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                String string = this.NodeNameId();
                if (this.contentHandler == null) break;
                try {
                    this.contentHandler.useDecl(string);
                }
                catch (VRMLException vRMLException) {
                    if (this.errorHandler != null) {
                        try {
                            this.errorHandler.warningReport(PARSE_MSG, vRMLException);
                        }
                        catch (VRMLException vRMLException2) {
                            this.convertException(vRMLException2);
                        }
                        break;
                    }
                    this.convertException(vRMLException);
                }
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void RootNodeStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 30: {
                this.Node(null);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                String string = this.NodeNameId();
                this.Node(string);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ProtoStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.Proto();
                break;
            }
            case 22: {
                this.ExternProto();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Proto() throws ParseException {
        try {
            this.jj_consume_token(17);
            String string = this.NodeTypeId();
            this.jj_consume_token(12);
            if (this.protoHandler != null) {
                this.protoHandler.startProtoDecl(string);
            }
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block5;
                    }
                }
                this.InterfaceDecl();
            }
            this.jj_consume_token(13);
            if (this.protoHandler != null) {
                this.protoHandler.endProtoDecl();
            }
            this.jj_consume_token(10);
            if (this.protoHandler != null) {
                this.protoHandler.startProtoBody();
            }
            this.ProtoBody();
            this.jj_consume_token(11);
            if (this.protoHandler != null) {
                this.protoHandler.endProtoBody();
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ProtoBody() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            this.ProtoStatement();
        }
        this.RootNodeStatement();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 17: 
                case 22: 
                case 23: 
                case 27: 
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block7;
                }
            }
            this.Statement();
        }
    }

    public final void RestrictedInterfaceDecl() throws ParseException {
        Object object = null;
        boolean bl = false;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    this.jj_consume_token(18);
                    int n = 1;
                    String string = this.FieldId();
                    String string2 = this.FieldNameId();
                    if (this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string2, object);
                    }
                    break;
                }
                case 19: {
                    this.jj_consume_token(19);
                    int n = 4;
                    String string = this.FieldId();
                    String string3 = this.FieldNameId();
                    if (this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string3, object);
                    }
                    break;
                }
                case 20: {
                    this.jj_consume_token(20);
                    int n = 2;
                    String string = this.FieldId();
                    String string4 = this.FieldNameId();
                    if (string.endsWith("FNode")) {
                        bl = true;
                        if (this.protoHandler != null) {
                            this.protoHandler.protoFieldDecl(n, string, string4, null);
                        }
                    }
                    object = this.FieldValue(string4);
                    if (!bl && this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string4, object);
                    }
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void InterfaceDecl() throws ParseException {
        Object object = null;
        boolean bl = false;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: {
                    this.RestrictedInterfaceDecl();
                    break;
                }
                case 21: {
                    this.jj_consume_token(21);
                    int n = 3;
                    String string = this.FieldId();
                    String string2 = this.FieldNameId();
                    if (string.endsWith("FNode")) {
                        bl = true;
                        if (this.protoHandler != null) {
                            this.protoHandler.protoFieldDecl(n, string, string2, null);
                        }
                    }
                    object = this.FieldValue(string2);
                    if (!bl && this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n, string, string2, object);
                    }
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ExternProto() throws ParseException {
        try {
            this.jj_consume_token(22);
            String string = this.NodeTypeId();
            this.jj_consume_token(12);
            if (this.protoHandler != null) {
                this.protoHandler.startExternProtoDecl(string);
            }
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block5;
                    }
                }
                this.ExternInterfaceDecl();
            }
            this.jj_consume_token(13);
            if (this.protoHandler != null) {
                this.protoHandler.endExternProtoDecl();
            }
            String[] stringArray = this.URIList();
            if (this.protoHandler != null) {
                this.protoHandler.externProtoURI(stringArray);
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void ExternInterfaceDecl() throws ParseException {
        int n = this.AccessType();
        String string = this.FieldId();
        String string2 = this.FieldNameId();
        if (this.protoHandler != null) {
            try {
                this.protoHandler.protoFieldDecl(n, string, string2, null);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void RouteStatement() throws ParseException {
        this.jj_consume_token(23);
        String string = this.NodeNameId();
        this.jj_consume_token(26);
        String string2 = this.FieldNameId();
        this.jj_consume_token(24);
        String string3 = this.NodeNameId();
        this.jj_consume_token(26);
        String string4 = this.FieldNameId();
        if (this.routeHandler != null) {
            try {
                this.routeHandler.routeDecl(string, string2, string3, string4);
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final String[] URIList() throws ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(9);
                    arrayList.add(this.stripString());
                }
                this.jj_consume_token(13);
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
            case 9: {
                this.jj_consume_token(9);
                return new String[]{this.stripString()};
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Node(String string) throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    String string2 = this.Id();
                    this.jj_consume_token(10);
                    if (this.contentHandler != null) {
                        this.contentHandler.startNode(string2, string);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: 
                        case 22: 
                        case 23: 
                        case 30: {
                            this.NodeBody();
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(11);
                    if (this.contentHandler != null) {
                        this.contentHandler.endNode();
                    }
                    break;
                }
                case 27: {
                    this.jj_consume_token(27);
                    this.jj_consume_token(10);
                    if (this.contentHandler != null) {
                        this.contentHandler.startNode("Script", string);
                    }
                    if (this.scriptHandler != null) {
                        this.scriptHandler.startScriptDecl();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 22: 
                        case 23: 
                        case 30: {
                            this.ScriptBody();
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(11);
                    if (this.scriptHandler != null) {
                        this.scriptHandler.endScriptDecl();
                    }
                    if (this.contentHandler != null) {
                        this.contentHandler.endNode();
                    }
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
        }
    }

    public final void NodeBody() throws ParseException {
        block3: while (true) {
            this.NodeBodyElement();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 22: 
                case 23: 
                case 30: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
    }

    public final void NodeBodyElement() throws ParseException {
        block20: {
            boolean bl = false;
            try {
                if (this.jj_2_1(2)) {
                    String string = this.FieldNameId();
                    if (this.contentHandler != null) {
                        try {
                            this.contentHandler.startField(string);
                            bl = false;
                        }
                        catch (VRMLException vRMLException) {
                            bl = true;
                            this.convertException(vRMLException);
                        }
                    }
                    Object object = this.FieldValue(null);
                    if (!bl && object != null && this.contentHandler != null) {
                        if (object instanceof String) {
                            this.contentHandler.fieldValue((String)object);
                        } else {
                            this.contentHandler.fieldValue((String[])object);
                        }
                    }
                    break block20;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        String string = this.FieldNameId();
                        if (this.contentHandler != null) {
                            try {
                                this.contentHandler.startField(string);
                                bl = false;
                            }
                            catch (VRMLException vRMLException) {
                                bl = true;
                                this.convertException(vRMLException);
                            }
                        }
                        this.jj_consume_token(25);
                        String string2 = this.FieldNameId();
                        if (this.protoHandler != null && !bl) {
                            try {
                                this.protoHandler.protoIsDecl(string2);
                            }
                            catch (FieldException fieldException) {
                                this.convertException(fieldException);
                            }
                        }
                        break;
                    }
                    case 23: {
                        this.RouteStatement();
                        break;
                    }
                    case 17: 
                    case 22: {
                        this.ProtoStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final void ScriptBody() throws ParseException {
        block3: while (true) {
            this.ScriptBodyElement();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 30: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
    }

    public final void ScriptBodyElement() throws ParseException {
        block27: {
            boolean bl = false;
            try {
                if (this.jj_2_2(3)) {
                    this.NodeBodyElement();
                    break block27;
                }
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        int n = 1;
                        String string = this.FieldId();
                        String string2 = this.FieldNameId();
                        if (this.scriptHandler != null) {
                            this.scriptHandler.scriptFieldDecl(n, string, string2, null);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 25: {
                                this.jj_consume_token(25);
                                String string3 = this.FieldNameId();
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string3);
                                    break;
                                }
                                break block27;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                                break;
                            }
                        }
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        int n = 4;
                        String string = this.FieldId();
                        String string4 = this.FieldNameId();
                        if (this.scriptHandler != null) {
                            this.scriptHandler.scriptFieldDecl(n, string, string4, null);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 25: {
                                this.jj_consume_token(25);
                                String string5 = this.FieldNameId();
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string5);
                                    break;
                                }
                                break block27;
                            }
                            default: {
                                this.jj_la1[20] = this.jj_gen;
                                break;
                            }
                        }
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        int n = 2;
                        String string = this.FieldId();
                        String string6 = this.FieldNameId();
                        if (string.endsWith("FNode")) {
                            bl = true;
                            if (this.scriptHandler != null) {
                                this.scriptHandler.scriptFieldDecl(n, string, string6, null);
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 25: {
                                this.jj_consume_token(25);
                                String string7 = this.FieldNameId();
                                if (this.scriptHandler != null && !bl) {
                                    this.scriptHandler.scriptFieldDecl(n, string, string6, null);
                                }
                                if (this.protoHandler != null) {
                                    this.protoHandler.protoIsDecl(string7);
                                    break block1;
                                }
                                break block27;
                            }
                            case 8: 
                            case 9: 
                            case 12: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: {
                                Object object = this.FieldValue(string6);
                                if (!bl && this.scriptHandler != null) {
                                    this.scriptHandler.scriptFieldDecl(n, string, string6, object);
                                    break block1;
                                }
                                break block27;
                            }
                            default: {
                                this.jj_la1[21] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (VRMLException vRMLException) {
                this.convertException(vRMLException);
            }
        }
    }

    public final String NodeNameId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final String NodeTypeId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final String FieldNameId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final int AccessType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                return 2;
            }
            case 18: {
                this.jj_consume_token(18);
                return 1;
            }
            case 19: {
                this.jj_consume_token(19);
                return 4;
            }
            case 21: {
                this.jj_consume_token(21);
                return 3;
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int RestrictedFieldType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                return 2;
            }
            case 18: {
                this.jj_consume_token(18);
                return 1;
            }
            case 19: {
                this.jj_consume_token(19);
                return 4;
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String FieldId() throws ParseException {
        String string = this.Id();
        return string;
    }

    public final Object FieldValue(String string) throws ParseException {
        Object object = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                object = this.SingleFieldValue();
                break;
            }
            case 12: {
                object = this.MultiFieldValue(string);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return object;
    }

    public final String SingleFieldValue() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 27: 
            case 30: {
                this.NodeStatement();
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                string = this.token.image;
                break;
            }
            case 8: 
            case 9: 
            case 28: 
            case 29: {
                string = this.LiteralValue();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final Object MultiFieldValue(String string) throws ParseException {
        boolean bl = false;
        String[] stringArray = null;
        ArrayList arrayList = new ArrayList();
        try {
            this.jj_consume_token(12);
            if (this.jj_2_3(2)) {
                block8: while (true) {
                    this.NodeStatement();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: 
                        case 15: 
                        case 27: 
                        case 30: {
                            continue block8;
                        }
                    }
                    break;
                }
                this.jj_la1[27] = this.jj_gen;
                bl = true;
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        stringArray = this.NumberArray();
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        stringArray = this.StringArray();
                    }
                }
            }
            this.jj_consume_token(13);
            if (this.contentHandler != null) {
                if (bl) {
                    this.contentHandler.endField();
                } else {
                    return stringArray;
                }
            }
            return null;
        }
        catch (VRMLException vRMLException) {
            this.convertException(vRMLException);
            throw new Error("Missing return statement in function");
        }
    }

    public final String LiteralValue() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                string = this.token.image;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                string = this.token.image;
                break;
            }
            case 8: {
                string = this.FixedNumberArray();
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                string = this.token.image;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String[] StringArray() throws ParseException {
        this.stringArray.clear();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(9);
            this.stringArray.add(this.token.image);
        }
        return this.stringArray.toArray();
    }

    public final String[] NumberArray() throws ParseException {
        this.stringArray.clear();
        do {
            this.jj_consume_token(8);
            this.stringArray.add(this.token.image);
        } while (this.jj_2_4(2));
        return this.stringArray.toArray();
    }

    public final String FixedNumberArray() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            this.jj_consume_token(8);
            stringBuffer.append(' ');
            stringBuffer.append(this.token.image);
        } while (this.jj_2_5(2));
        return stringBuffer.toString();
    }

    public final String Id() throws ParseException {
        this.jj_consume_token(30);
        return this.token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    private final boolean jj_3R_53() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_52() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_53());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_17();
    }

    private final boolean jj_3R_24() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_32()) {
                this.jj_scanpos = token;
                if (this.jj_3R_33()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_46() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_41() {
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_50();
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3R_37() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = token;
            if (this.jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_38() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = token;
            if (this.jj_3R_44()) {
                this.jj_scanpos = token;
                if (this.jj_3R_45()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_46()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_17();
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_14() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_34();
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_34();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                this.jj_scanpos = token;
                if (this.jj_3R_30()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_34() {
        return this.jj_3R_17();
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3_5() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_15() {
        Token token = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = token;
            if (this.jj_3R_20()) {
                this.jj_scanpos = token;
                if (this.jj_3R_21()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_22()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_50() {
        Token token;
        if (this.jj_3_5()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_52();
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_51();
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_23();
    }

    private final boolean jj_3_3() {
        Token token;
        if (this.jj_3R_16()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_16());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_4() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_36() {
        return this.jj_3R_40();
    }

    private final boolean jj_3R_27() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = token;
            if (this.jj_3R_36()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_39();
    }

    private final boolean jj_3R_51() {
        Token token;
        if (this.jj_3_4()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = token;
            if (this.jj_3R_47()) {
                this.jj_scanpos = token;
                if (this.jj_3R_48()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{1220722688, 1220722688, 1208008704, 0x48004000, 0x420000, 0x3C0000, 0x420000, 1220722688, 0x1C0000, 0x3C0000, 0x3C0000, 512, 4608, 1086455808, 1088290816, 0x48000000, 1086455808, 1086455808, 1088290816, 0x2000000, 0x2000000, 2046939904, 0x1C0000, 0x3C0000, 0x1C0000, 2013385472, 2013381376, 1208008704, 256, 0x30000300, 512};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public VRML97RelaxedParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public VRML97RelaxedParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new VRML97RelaxedParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public VRML97RelaxedParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new VRML97RelaxedParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public VRML97RelaxedParser(VRML97RelaxedParserTokenManager vRML97RelaxedParserTokenManager) {
        int n;
        this.token_source = vRML97RelaxedParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(VRML97RelaxedParserTokenManager vRML97RelaxedParserTokenManager) {
        int n;
        this.token_source = vRML97RelaxedParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 31; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[33];
        for (n2 = 0; n2 < 33; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 31; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 33; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 5; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        VRML97RelaxedParser.jj_la1_0();
        VRML97RelaxedParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class VRMLRelaxedLocator
    implements Locator {
        private VRMLRelaxedLocator() {
        }

        public int getColumnNumber() {
            return VRML97RelaxedParser.this.token.beginColumn;
        }

        public int getLineNumber() {
            return VRML97RelaxedParser.this.token.beginLine;
        }
    }
}

