#!/usr/bin/env python

"""
This file tests vtk.vtkMolecule, and verifies that atoms/bonds are added.
"""

import sys
import vtk
from vtk.test import Testing
try:
    import numpy as np
except ImportError:
    import sys
    sys.exit(0)

class TestLagrangeTriangleOrderLimit(Testing.vtkTest):
    def testCreation(self):
        "Testing if molecules can be created/modified."

    for order in range(1, 8):
        tri = vtk.vtkLagrangeTriangle()
        n_points = int((order+2)*(order+1)/2)
        tri.GetPointIds().SetNumberOfIds(n_points)
        tri.GetPoints().SetNumberOfPoints(n_points)
        tri.Initialize()

        point = [0.,0.,0.]
        barycentricIndex = [0, 0, 0, 0]
        z_coords = np.zeros(order+1)
        z_coords[1:-1] = [(-1)**j/(order**2) for j in range(1,order)]
        y_vals = np.array([i/order for i in range(0,order+1)])

        points = []


        for i in range(n_points):
            tri.GetPointIds().SetId(i, i)

            tri.ToBarycentricIndex(i, barycentricIndex)

            for j in range(3):
                point[j] = float(barycentricIndex[j]) / order

            index = np.argwhere(point[1] == y_vals)[0][0]
            points.append([point[0], point[1], z_coords[index]])
            tri.GetPoints().SetPoint(i, point[0], point[1], z_coords[index])

        uGrid =vtk.vtkUnstructuredGrid()
        uGrid.SetPoints(tri.GetPoints())

        uGrid.InsertNextCell(tri.GetCellType(), tri.GetPointIds())
#        self.assertEqual(mol.GetNumberOfBonds(), 1, "Number of atoms incorrect")

if __name__ == "__main__":
    Testing.main([(TestLagrangeTriangleOrderLimit, 'test')])
