#!/usr/bin/env python
import vtk
from vtk.test import Testing

coords = [(0,0,0),(1,0,0),(1,1,0),(0,1,0),
          (0,0,1),(1,0,1),(1,1,1),(0,1,1)]
dataValues = [0,0.10639915272,0.66324346328,0.32734213143,0.22094297872,
              0.90054216121,0.40901033062,1.3410900321]
data = vtk.vtkFloatArray()
points = vtk.vtkPoints()
ptIds = vtk.vtkIdList()
mesh = vtk.vtkUnstructuredGrid()
mesh.SetPoints(points)
mesh.GetPointData().SetScalars(data)

for id in range(0,8):
    x=coords[id][0]
    y=coords[id][1]
    z=coords[id][2]
    ptIds.InsertNextId(id)
    points.InsertNextPoint(x,y,z)
    data.InsertNextValue(dataValues[id])
mesh.InsertNextCell(vtk.VTK_HEXAHEDRON,ptIds)

# ug->polydata
gf = vtk.vtkGeometryFilter()
gf.SetInputData(mesh)

# generate iso-bands from point-scalars
bcf=vtk.vtkBandedPolyDataContourFilter()
bcf.SetInputConnection( gf.GetOutputPort() )
bcf.SetGenerateContourEdges(True)
bcf.SetContinuousContours(True)
bcf.GenerateValues(9,0,1.34109)
bcf.SetScalarModeToValue()
bcf.Update()

mapper = vtk.vtkPolyDataMapper()
mapper.SetInputConnection(bcf.GetOutputPort())
mapper2 = vtk.vtkPolyDataMapper()
mapper2.SetInputData(bcf.GetContourEdgesOutput())

actor = vtk.vtkActor()
actor.SetMapper(mapper)
actor.RotateX(30.0)
actor.RotateY(-45.0)
actor2 = vtk.vtkActor()
actor2.SetMapper(mapper2)
actor2.GetProperty().SetLineWidth(3)
actor2.RotateX(30.0)
actor2.RotateY(-45.0)

ren = vtk.vtkRenderer()
renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
#ren.AddActor(actor)
ren.AddActor(actor2)
ren.SetBackground(0.1, 0.2, 0.4)
renWin.SetSize(200, 200)
iren.Initialize()
ren.ResetCamera()
ren.GetActiveCamera().Zoom(1.5)
renWin.Render()
#iren.Start()
# --- end of script --
