#!/bin/bash

export WORKDIR=/work

cd "$WORKDIR/VTK/build" && \
    $CMAKE \
      -S ${WORKDIR}/VTK/src \
      -B ${WORKDIR}/VTK/build \
      -G Ninja \
      -D CMAKE_BUILD_TYPE:STRING=Release \
      -D BUILD_TESTING:BOOL=OFF \
      -D BUILD_SHARED_LIBS:BOOL=ON \
      -D VTK_ENABLE_KITS:BOOL=OFF \
      -D VTK_OPENGL_HAS_OSMESA:BOOL=ON \
      -D VTK_DATA_EXCLUDE_FROM_ALL:BOOL=ON \
      -D VTK_DEFAULT_RENDER_WINDOW_OFFSCREEN:BOOL=ON \
      -D VTK_USE_X:BOOL=OFF \
      -D VTK_MODULE_ENABLE_VTK_FiltersOpenTURNS:STRING=NO \
      -D VTK_MODULE_ENABLE_VTK_IOADIOS2:STRING=NO \
      -D VTK_MODULE_ENABLE_VTK_CommonArchive:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_RenderingOpenVR:STRING=NO \
      -D VTK_MODULE_ENABLE_VTK_RenderingOpenGL2:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_GeovisCore:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_IOGDAL:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_IOLAS:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_IOParallelExodus:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_RenderingContextOpenGL2:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_RenderingGL2PSOpenGL2:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_RenderingMatplotlib:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_RenderingQt:STRING=NO \
      -D VTK_MODULE_ENABLE_VTK_TestingRendering:STRING=YES \
      -D VTK_MODULE_ENABLE_VTK_ViewsInfovis:STRING=YES \
      -D VTK_WRAP_PYTHON:BOOL=ON \
      -D VTK_GROUP_ENABLE_Web:BOOL=YES \
      -D OSMESA_LIBRARY=/usr/lib/x86_64-linux-gnu/libOSMesa.so \
      -D OSMESA_INCLUDE_DIR=/usr/include/GL/ \
      -D VTK_PYTHON_VERSION:STRING=3

$CMAKE --build "$WORKDIR/VTK/build"
