# CMake learned how to enable C++11 for the Intel compiler in 3.6.
if (superbuild_build_phase AND
    CMAKE_CXX_COMPILER_ID MATCHES "Intel" AND
    CMAKE_VERSION VERSION_LESS "3.6")
  message(FATAL_ERROR "Building C++14 with the Intel compiler requires CMake >= 3.6")
endif ()

superbuild_add_dummy_project(cxx14)

if (cxx14_enabled)
  set(CMAKE_CXX_STANDARD 14)
  set(CMAKE_CXX_STANDARD_REQUIRED TRUE)
endif ()

superbuild_add_extra_cmake_args(
  -DCMAKE_CXX_STANDARD:STRING=14
  -DCMAKE_CXX_STANDARD_REQUIRED:STRING=TRUE)

superbuild_append_flags(cxx_flags "${CMAKE_CXX14_STANDARD_COMPILE_OPTION}")
