//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_simulation_adh_ExportAdHMesh_h
#define pybind_smtk_simulation_adh_ExportAdHMesh_h

#include <pybind11/pybind11.h>

#include "smtk/simulation/adh/ExportAdHMesh.h"

namespace py = pybind11;

py::class_< smtk::simulation::adh::ExportAdHMesh > pybind11_init_smtk_adh_ExportAdHMesh(py::module &m)
{
  py::class_< smtk::simulation::adh::ExportAdHMesh > instance(m, "ExportAdHMesh");
  instance
    .def(py::init<>())
    .def("__call__", (void (smtk::simulation::adh::ExportAdHMesh::*)(const std::string&, const std::string&, smtk::mesh::ResourcePtr&, smtk::model::ResourcePtr&, const std::string&, const std::vector<smtk::attribute::AttributePtr>&)) &smtk::simulation::adh::ExportAdHMesh::operator())
    .def("__call__", (void (smtk::simulation::adh::ExportAdHMesh::*)(const std::string&)) &smtk::simulation::adh::ExportAdHMesh::operator())
    .def("__call__", (void (smtk::simulation::adh::ExportAdHMesh::*)(pybind11::object)) &smtk::simulation::adh::ExportAdHMesh::operator())
    ;
  return instance;
}

#endif
