//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//=============================================================================
#ifndef __smtk_simulation_adh_ExportHotStartFile_h
#define __smtk_simulation_adh_ExportHotStartFile_h

#include "smtk/simulation/adh/Exports.h"

#include "smtk/simulation/ExportSpec.h"

#include "smtk/attribute/Attribute.h"

#include "smtk/mesh/core/CellSet.h"
#include "smtk/mesh/core/DimensionTypes.h"
#include "smtk/mesh/core/MeshSet.h"
#include "smtk/mesh/core/Resource.h"

#include "smtk/model/Resource.h"

#include <string>
#include <vector>

namespace smtk
{
namespace simulation
{
namespace adh
{

class SMTKADHSIMULATION_EXPORT ExportHotStartFile
{
public:
void operator()(const std::string& meshHotStartFileName,
                smtk::mesh::ResourcePtr& meshResource,
                const smtk::attribute::ResourcePtr& exportSpecification,
                double startTime,
                std::size_t startTimeUnits);
};

}
}
}

#endif
