//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//=============================================================================
#ifndef __smtk_simulation_adh_ExportAdHMesh_h
#define __smtk_simulation_adh_ExportAdHMesh_h

#include "smtk/simulation/adh/Exports.h"

#include "smtk/simulation/ExportSpec.h"

#include "smtk/attribute/Attribute.h"

#include "smtk/mesh/core/CellSet.h"
#include "smtk/mesh/core/DimensionTypes.h"
#include "smtk/mesh/core/MeshSet.h"
#include "smtk/mesh/core/Resource.h"

#include "smtk/model/Resource.h"

#include <string>
#include <vector>

#include <pybind11/pybind11.h>

namespace smtk
{
namespace simulation
{
namespace adh
{

class SMTKADHSIMULATION_EXPORT ExportAdHMesh
{
public:
void operator()(const std::string& geometryFileName,
                const std::string& boundaryConditionFileName,
                smtk::mesh::ResourcePtr& meshResource,
                smtk::model::ResourcePtr& modelResource,
                const std::string& modelPropertyName,
                const std::vector<smtk::attribute::AttributePtr>& boundaryConditions);
void operator()(const std::string& boundaryConditionFileName);
void operator()(pybind11::object spec);
};

}
}
}

#endif
