/*
 * Copyright 2012 SciberQuest Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  * Neither name of SciberQuest Inc. nor the names of any contributors may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "pqSQTensorGlyph.h"

#include <QCheckBox>
#include <QLabel>
#include <QWidget>
#include <QtDebug>

//-----------------------------------------------------------------------------
pqSQTensorGlyph::pqSQTensorGlyph(pqProxy* prox, QWidget* par)
  : pqAutoGeneratedObjectPanel(prox, par)
{
  QCheckBox* ColorGlyphsWidget;
  QCheckBox* LimitScalingByEigenvaluesWidget;
  QWidget* ColorModeWidget;
  QLabel* ColorModeLabel;
  QWidget* MaxScaleFactorWidget;
  QLabel* MaxScaleFactorLabel;

  ColorGlyphsWidget = this->findChild<QCheckBox*>("ColorGlyphs");
  if (!ColorGlyphsWidget)
  {
    qWarning() << "Failed to locate ColorGlyphs widget.";
    return;
  }

  // disable "color by" dropdown box if ColorGlyphs is not set
  ColorModeWidget = this->findChild<QWidget*>("ColorMode");
  if (ColorModeWidget)
  {
    QObject::connect(
      ColorGlyphsWidget, SIGNAL(toggled(bool)), ColorModeWidget, SLOT(setEnabled(bool)));
  }

  ColorModeLabel = this->findChild<QLabel*>("_labelForColorMode");
  if (ColorModeLabel)
  {
    QObject::connect(
      ColorGlyphsWidget, SIGNAL(toggled(bool)), ColorModeLabel, SLOT(setEnabled(bool)));
  }

  ColorGlyphsWidget->toggle();
  ColorGlyphsWidget->toggle();

  // disable "MaxScaleFactor" textbox if LimitScaling is not set
  LimitScalingByEigenvaluesWidget = this->findChild<QCheckBox*>("LimitScalingByEigenvalues");

  if (!LimitScalingByEigenvaluesWidget)
  {
    qWarning() << "Failed to locate LimitScalingByEigenvalues widget.";
    return;
  }

  MaxScaleFactorWidget = this->findChild<QWidget*>("MaxScaleFactor");
  if (MaxScaleFactorWidget)
  {
    QObject::connect(LimitScalingByEigenvaluesWidget, SIGNAL(toggled(bool)), MaxScaleFactorWidget,
      SLOT(setEnabled(bool)));
  }

  MaxScaleFactorLabel = this->findChild<QLabel*>("_labelForMaxScaleFactor");
  if (MaxScaleFactorLabel)
  {
    QObject::connect(LimitScalingByEigenvaluesWidget, SIGNAL(toggled(bool)), MaxScaleFactorLabel,
      SLOT(setEnabled(bool)));
  }

  LimitScalingByEigenvaluesWidget->toggle();
  LimitScalingByEigenvaluesWidget->toggle();

  return;
}
