/*=========================================================================

   Program: ParaView
   Module:    pqGlyphPanel.h

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2. 

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef __pqGlyphPanel_h 
#define __pqGlyphPanel_h

#include "pqAutoGeneratedObjectPanel.h"

class QAbstractButton;
class QComboBox;

/// Custom panel for ArbitrarySourceGlyph and Glyph filters. 
/// This panel is only provided to add capabilities to reset the scalar factor
/// for the glyphs when the scale mode, vectors or scalar selections change.
class PQCOMPONENTS_EXPORT pqGlyphPanel : public pqAutoGeneratedObjectPanel
{
  Q_OBJECT
  typedef pqAutoGeneratedObjectPanel Superclass;

public:
  pqGlyphPanel(pqProxy* proxy, QWidget* p);
  virtual ~pqGlyphPanel();

protected slots:
  /// Called when the panel is modified, we update the scale factor if the user
  /// hasn't locked the scale factor.
  void updateScaleFactor();

private:
  pqGlyphPanel(const pqGlyphPanel&); // Not implemented.
  void operator=(const pqGlyphPanel&); // Not implemented.
  QAbstractButton* LockScaleFactor;
  QWidget* ScaleFactorWidget;
  QComboBox* ScaleModeWidget;
};

#endif


