/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright on 2008 SciberQuest Inc.
*/
#include "pqSQFieldTracer.h"

#include <QCheckBox>
#include <QWidget>

#include <iostream>
using std::cerr;
using std::endl;

//-----------------------------------------------------------------------------
pqSQFieldTracer::pqSQFieldTracer(
      pqProxy* pxy,
      QWidget* p)
             :
  pqAutoGeneratedObjectPanel(pxy,p)
{
  #if defined pqSQFieldTracerDEBUG
  cerr << ":::::::::::::::::::::::::::::::pqSQFieldTracer" << endl;
  #endif

  // master and worker block sizes are only relevant if
  // dynamic scheduling is selected. If it is not selected
  // then disable master, and worker block entries.

  QCheckBox *dynSched
    = this->findChild<QCheckBox*>("UseDynamicScheduler");

  QWidget *masterBlock=this->findChild<QWidget*>("MasterBlockSize");
  QWidget *workerBlock=this->findChild<QWidget*>("WorkerBlockSize");

  // initialize based on current state, set by PV SM.
  if (!dynSched->isChecked())
    {
    masterBlock->setEnabled(false);
    workerBlock->setEnabled(false);
    }

  connect(dynSched,SIGNAL(clicked(bool)),masterBlock,SLOT(setEnabled(bool)));
  connect(dynSched,SIGNAL(clicked(bool)),workerBlock,SLOT(setEnabled(bool)));
}

//-----------------------------------------------------------------------------
void pqSQFieldTracer::accept()
{
  #if defined pqSQFieldTracerDEBUG
  cerr << ":::::::::::::::::::::::::::::::accept" << endl;
  #endif

  // dynamic scheduling can only be selected prior to the
  // first apply, because of some technicallity in the way
  // PV pipeline executes. Prevent changes after first
  // apply.

  QCheckBox *dynSched
    = this->findChild<QCheckBox*>("UseDynamicScheduler");

  dynSched->setEnabled(false);


  this->pqAutoGeneratedObjectPanel::accept();
}
