 /*=========================================================================

  Program:   ParaView
  Module:    vtkFeatureEdgesSurfaceRepresentation.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkFeatureEdgesSurfaceRepresentation
 * @brief   representation for feature edges.
 *
 * vtkFeatureEdgesSurfaceRepresentation is merely a vtkGeometryRepresentationWithFaces that forces
 * the geometry filter to produce feature edges as well as the surface.
*/

#ifndef vtkFeatureEdgesSurfaceRepresentation_h
#define vtkFeatureEdgesSurfaceRepresentation_h

#include "vtkGeometryRepresentationWithFaces.h"
#include "vtkRemotingViewsModule.h" //needed for exports

class VTKREMOTINGVIEWS_EXPORT vtkFeatureEdgesSurfaceRepresentation
  : public vtkGeometryRepresentationWithFaces
{
public:
  static vtkFeatureEdgesSurfaceRepresentation* New();
  vtkTypeMacro(vtkFeatureEdgesSurfaceRepresentation, vtkGeometryRepresentationWithFaces);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void SetGenerateFeatureEdges(bool) override;

  void SetRepresentation(const char*) override { this->Superclass::SetRepresentation("Surface"); }
  void SetUseOutline(int) override { this->Superclass::SetUseOutline(0); }
  void SetSuppressLOD(bool) override { this->Superclass::SetSuppressLOD(false); }
  void SetPickable(int) override { this->Superclass::SetPickable(0); }

protected:
  vtkFeatureEdgesSurfaceRepresentation();
  ~vtkFeatureEdgesSurfaceRepresentation() override;

  void SetRepresentation(int) override { this->Superclass::SetRepresentation(SURFACE); }

private:
  vtkFeatureEdgesSurfaceRepresentation(const vtkFeatureEdgesSurfaceRepresentation&) = delete;
  void operator=(const vtkFeatureEdgesSurfaceRepresentation&) = delete;
};

#endif
