/*=========================================================================

  Program:   ParaView
  Module:    vtkFeatureEdgesSurfaceRepresentation.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkFeatureEdgesSurfaceRepresentation.h"

#include "vtkObjectFactory.h"
#include "vtkPVGeometryFilter.h"

vtkStandardNewMacro(vtkFeatureEdgesSurfaceRepresentation);
//----------------------------------------------------------------------------
vtkFeatureEdgesSurfaceRepresentation::vtkFeatureEdgesSurfaceRepresentation()
{
  this->SetUseOutline(0);
  this->SetGenerateFeatureEdges(true);
  this->SetRepresentation(SURFACE);
  this->SetPickable(0);
  this->SetSuppressLOD(false);
}

//----------------------------------------------------------------------------
void vtkFeatureEdgesSurfaceRepresentation::SetGenerateFeatureEdges(bool)
{
  vtkPVGeometryFilter* geomFilter = vtkPVGeometryFilter::SafeDownCast(this->GeometryFilter);
  if (geomFilter)
  {
    geomFilter->SetAppendSurfaceToEdges(true);
  }

  this->Superclass::SetGenerateFeatureEdges(true);
}

//----------------------------------------------------------------------------
vtkFeatureEdgesSurfaceRepresentation::~vtkFeatureEdgesSurfaceRepresentation() = default;

//----------------------------------------------------------------------------
void vtkFeatureEdgesSurfaceRepresentation::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
