# 9.3.0 Release Notes

Changes made since VTK 9.2.0 include the following.

----------------------------------------

[](#changes)
## Changes

[](#changes-build)
### Build

- Compile fixes for C++20 builds with gcc11.
- Apply /utf-8 option for MSVC builds for standardization.
- Headers `vtkBlockSortHelper.h` from `VTK::RenderingVolume` and
  `vtkDIYKdTreeUtilities.h` from `VTK::FiltersParallelDIY2` are now installed.
- The `vtk-config.cmake` CMake package no longer permits unknown components to
  be listed and will report them as not found. This helps ensure the usability
  `VTK::Component` when `VTK_Component_FOUND` is set.
- The `vtk_encode_string` CMake API now supports the `ABI_MANGLE_SYMBOL_BEGIN`,
  `ABI_MANGLE_SYMBOL_END`, and `ABI_MANGLE_HEADER` arguments to specify a
  mangling mechanism. Previously (where mangling was supported), it was
  hard-coded to VTK's own mangling decisions.

[](#changes-charts)
### Charts

- Uniformize the `vtkPlot` API for color setters/getter, in order to fit the
  API of `vtkPen` and `vtkBrush`. Methods using floating point parameters
  (e.g. `vtkPlot::SetColor(double r, double g, double b)`) are now suffixed
  with `F` to avoid confusion with equivalent functions using unsigned chars.
  The former ones are marked as deprecated.
- `vtkChartParallelCoordinates`'s default selection behavior has been
  simplified. Multiple selection is no longer supported in `SELECTION_DEFAULT`.

[](#changes-copyright)
### Copyright

- SPDX information have been added and replace all previous copyright declaration
  in all of VTK. See [more information][spdx-copyright] on the processs used.

[spdx-copyright]: https://gitlab.kitware.com/vtk/vtk/-/commit/987d39ac31203df75281f0ab4be135dfc3c42d89

[](#changes-core)
### Core

- OSPRay has been disabled for older x86\_64 processors which do not support SSE4.1.
- Removed hidden private dependency of `CommonCore` on `CommonDataModel`.
- Nested parallelism has been disabled by default for all backends except TBB,
  which should improve performance. Enabling nested parallelism is still
  possible when sub-task are coarse enough, using the `SetNestedParallelism`
  method or a `LocalScope`.
- Improved `vtkSMPTools` STDThread backend. A common, global, thread pool is
  now shared between all SMP calls, so they no longer create threads.

[](#changes-data)
### Data

- `vtkPolyLine::Clip` improved to generate polylines whenever possible.
- `vtkCompositeDataSet::ShallowCopy` now does an actual shallow copy up to
  array pointers.
- Fixed calculation of `vtkPyramid` centroid.

[](#changes-filters)
### Filters

- VTK's interruption method has been updated to use `CheckAbort`. `CheckAbort`
  will check the current filter's `AbortExecute` flag as well as any upstream
  filter's `AbortExecute` flag. If any are set, the filter will output empty
  data and tell downstream filters to abort as well. Currently,
  `vtkContourGrid`, `vtkClipDataSet`, `vtkShrinkFilter`, and
  `vtkRTAnalyticSource`.
- `vtkmContour`'s `ComputeScalars` parameter has been fixed to behave like `vtkContourFilter`.
- `vtkExtractCells` has been relocated from `Filters/Extraction` to `Filters/Core`.
- `vtkTemporalDataSetCache` now deep copies data by default.

[](#changes-geovis)
### Geovis

- Moved `vtkCompassWidget` and `vtkCompassRepresentation` from `Geovis/Core`
  to `Interaction/Widgets`.

[](#changes-interaction)
### Interaction

- `vtkSelectPolyData` now passes cell data attributes to the selected and
  unselected outputs.
- Output support fixed for `vtkSelectPolyData` when `GenerateSelectionScalars`
  is enabled.

[](#changes-io)
### I/O

- `vtkPLYReader` changed to use new `vtkResourceStream` IO.
  - `vtkPLY::get_ascii_item` signature changed from
    `void(const char*, int, int*, unsigned int*, double*)` to
    `void(vtkResourceParser*, int, int*, unsigned int*, double*)`
  - `vtkPLY::ply_read` signature changed from `PlyFile*(std::istream*, int*, char***)`
    to `PlyFile*(vtkResourceStream*, int*, char***)`
  - `vtkPLY::get_words` signature changed from
    `void(std::istream* is, std::vector<char*>* words, char line_words[], char orig_line[])` to
    `void(vtkResourceParser* is, std::vector<char*>* words, char line_words[], char orig_line[])`
- `vtkPIOReader::GetTimeDataArray` now returns `nullptr` when the index is out-of-range.
- CGNS fixed compilation with HDF5 1.12.
- `vtkSTLReader` fixed to not consume new lines erroneously.

[](#changes-python)
### Python

- OSMesa VTK wheels are now provided. These are available on VTK's official
  channels (the VTK repository's Python index and `vtk.org`), but not PyPI
  because OSMesa conflicts with other OpenGL packages.

[](#changes-rendering)
### Rendering

- Fix wireframe render shading issues for some GPUs.
- VTK previously exported a lot of its shader strings from its libraries. Now only
  those that are available through installed headers are available. These include:
  - `vtkTextureObjectVS` from `VTK::RenderingOpenGL2`
  - `vtkCompositeZPassFS` from `VTK::RenderingParallel`

[](#changes-system)
### System

- `vtkExecutableRunner`'s argument splitting system has been overhauled. There
  are now 2 modes to execute a command using the `ExecuteInSystemShell` flag:
  - When `ExecuteInSystemShell` is `true` (default), the class will execute the
    given command in the system shell, leaving the actual argument split to the shell.
  - When `ExecuteInSystemShell` is `false`, you will have to split the command
    and its arguments yourself using the new `AddArgument` API.

[](#changes-third-party)
### Third Party

- VTK's vendored `zlib` library has been updated to 1.2.13.
- VTK's vendored `fmt` library has been updated to 9.1.0.
- VTK's vendored `ioss` library has been updated to the 2022-10-14 release.
- VTK's vendored `netcdf` library has been updated to 4.9.2.
- VTK's vendored `mpi4py` library has been updated to 3.1.4.
- VTK's vendored `expat` library has been updated to 2.4.8.
- VTK's vendored `libxml2` library has been updated to 2.10.1.
- VTK's vendored `PDAL` library has been updated to 2.1.
- Added fix for `Proj` compatibility with `windows.h` with the VTK `STRICT` definition.

----------------------------------------

[](#new-features)
## New Features

[](#new-features-abi-namespace)
### ABI Namespace

- VTK is now wrapped in a customizable `inline namespace` (`VTK_ABI_NAMESPACE`).
  To wrap code in the ABI namespace use `VTK_ABI_NAMESPACE_BEGIN` and
  `VTK_ABI_NAMESPACE_END`. This change means you can now link different versions
  of VTK into the same runtime without generating conflicts between VTK symbols.
  Note: this does not prevent conflicts with third-part symbol (including VTK-m).
- Where to put namespaces:
  - Around classes, functions, variables, typedefs (optional).
  - Inner most named namespaces, there is no need to use the ABI namespace
    inside of an anonymous namespace.
    - ABI namespace should never be around a named namespace.
  - Forward declarations of classes/functions/variables/typedefs require ABI
    namespace if their implementation/declarion was inside the ABI namespace.
- Where not to put namespace:
  - Do not namespace around non-exported classes/functions/variables/typedefs (usually found in tests).
  - Do not namespace around main functions.
  - Python bindings cannot be namespaced.
  - Most Utilities are not namespaced, including vtksys/vtkmeta/ksys.
  - It doesn't hurt anything, but it is not required to namespace symbols that
    are compiled into a driver (such as Wrapping Tools).
- Some VTK modules have C interfaces that cannot be mangled:
  - VTK::CommonCore (GetVTKVersion)
  - VTK::IOXML (Provides a C API, `vtkXMLWriterC_-`)
  - VTK::WrappingPythonCore (Python Wrapping cannot have mangling)
- Thirdpary Libraries and their VTK module wrappers do not have mangling:
  - VTK::metaio
  - VTK::xdmf2
  - VTK::vpic
  - All C libraries (ie. HDF5, netCDF, etc.)
- VTKm CUDA Accelerators do not get mangled:
  - VTK::AcceleratorsVTKmCore
  - VTK::AcceleratorsVTKmDataModel
  - VTK::AcceleratorsVTKmFilters

[](#new-features-build)
### Build

- `VTK_LOGGING_TIME_PRECISION` can be used to change the precision of loguru
  timing output (when `VTK_ENABLE_LOGGING` is ON).
- `VTK_ZSPACE_USE_COMPAT_SDK` can be used to control runtime search for zSpace
  Core Compatibility libraries. Default is ON, disabling the search.
- `VTK_GENERATE_SPDX` can be used to generate [SPDX][spdx-docs] files for each
  VTK module. Default is OFF. The generation of SPDX files is considered experimental.
- Added `VTK_USE_FUTURE_BOOL` configure-time variable. The codebase contains
  many variables typed as `int` that really should be `bool`. But changing them
  breaks backwards compatibility, and so a `vtkTypeBool` typedef was introduced
  which is defined to either `int` or `bool` depending on the new
  `VTK_USE_FUTURE_BOOL` configure-time variable. This allows for the piecemeal
  changing of many `int` variables to `vtkTypeBool`.


[spdx-docs]: https://docs.vtk.org/en/latest/advanced/spdx_and_sbom.html

[](#new-features-charts)
### Charts

- `vtkChartParallelCoordinates` now has a chart legend which can be toggled
  with the `SetShowLegend` method. This legend can be customized using the
  `vtkChartLegend` API.
- `vtkPlotParallelCoordinates` now has the option to set a preconfigured color
  array using `SetColorModeToDefault`.
- Fixed bug where calling `vtkPlotBar.GetLookupTable` caused a segmentation
  fault when no data had been plotted.
- You can now set an array name for the `vtkPlotHistogram2D`. This allows you
  to set an array that is not scalar, ie. an array with a number of components
  greater than 1.

[](#new-features-core)
### Core

- `vtkMath::GetPointAlongLine` can be used to compute a point along a line
  defined by two points and an offset.
- `vtkValueFromString` is a new low-level function that converts a string to an
  integer, a floating-point value or a boolean. `vtkValueFromString` is faster
  than standard library functions such as the `std::strto*` function family.
- VTK now provides a way to obtain type names at compile time in the
  `Common/Core/vtkTypeName.h` header:

  ```c++
  #include "vtkTypeName.h"

  // ...
  std::string typeName = vtk::TypeName<vtkImageData>();
  std::cout << typeName << std::endl;

  ```

- The `vtkStringToken` class introduces a utility for hashing strings at either
  compile or run-time and using the resulting integers as tokens. Additional
  utilities regarding compile-time hashing have also been added:
  - `vtkStringManager` holds strings hashed at runtime. This makes it possible
    for the string-token class to return the original string to you in some cases.
    Because the manager holds a map from string-hash to string, only a single
    copy of the string is stored no matter how many copies of the token exist.
  - Added new `vtk::literals` namespace for creating hashes and tokens at compile time.
    - `""_hash` - returns a 32-bit integer hash of the given string.
    - `""_token` - returns a `vtkStringToken` instance of the given string.
      Note that because the hash is computed during compilation, you may not
      call the token's `Data()` method to retrieve the string unless it is
      inserted at run time by some other code.
  - Since hashing is performed at build time, the following example is possible:
    ```cpp
    #include "vtkStringToken.h"
    using namespace vtk::literals;
    vtkStringToken t;
    switch (t.GetId())
    {
      case "foo"_hash: foo(); break;
      case "bar"_hash: bar(); break;
      default: vtkErrorMacro("Unknown token " << t.Data()); break;
    }
    ```
- VTK now provides a way to iterate over a class and all its ancestor types (as
  long as they inherit `vtkObjectBase` and use the `vtkTypeMacro()` to define
  `Superclass` type-aliases). The `vtk::ParentClasses<T>::enumerate()` function
  will invoke a functor you pass on `T` and each superclass of `T`. This is
  used by a new `vtk::Inheritance<T>()` function that inserts the name of each
  class inherited by `T` into a container you pass to it. See
  `Common/Core/Testing/Cxx/TestInherits` for example usage.
- `vtkThreadedCallbackQueue` can be used to run functions in the background on
  different threads. Use the `Push` method to add functions to the queue. The
  `Push` method returns a `vtkSmartPointer<vtkThreadedCallbackQueue::vtkSharedFutureBase>`,
  which lets users synchronize tasks.

[](#new-features-data)
### Data

- Added `vtkImplicitArray` template class that implements a read-only
  `vtkGenericDataArray` interface which transforms an implicit function mapping
  integers to values into a practically zero cost `vtkDataArray`. This is
  helpful in cases where one needs to attach data to data sets and memory
  efficiency is paramount.
  - Additional backends have been added in the `vtkImplicitArray` framework:
    - `vtkAffineArray` that gets constructed with a slope and intercept and
      then returns values linearly depending on the queried index.
    - `vtkCompositeArray` that takes an `std::vector<vtkDataArray*>` at
      construction and returns values as if the list has been concatenated into
      one array.
    - `vtkConstantArray` that gets constructed with a given value and then
      returns that same value regardless of the index queried.
    - `vtkStdFunctionArray` which uses a `std::function<ValueType(int)>` backend
      capable of covering almost any function one might want to use.
    - `vtkIndexedArray` that takes an indexing array (either `vtkIdList` or
      `vtkDataArray`) and a base `vtkDataArray` at construction and returns
      values indirected using the indexing array to give access to a shuffled
      array without the memory cost.
  - Read more about `vtkImplicitArrays` [here][add-vtkImplicitArrays].
- `ProcessIds` data array is now accessible directly from `vtkDataSetAttributes`
  just like any other data array (e.g GlobalIds or Normals).
- Added `vtkCellGrid`. It exists to support finite element techniques using
  novel function spaces, which violate vtkDataSet's assumptions -- especially
  discontinuous Galerkin (DG) elements.
- `vtkPolyhedronUtilities` added to support polyhedron decomposition into
  tetrahedra. Improves downstream filter results (e.g. contours) on polyhedrons
  with concave faces.
- Added new `vtkPolyhedron::TriangulateFaces` method.
- Added new `vtkStaticFaceHashLinksTemplate` templated class that can be used to
  group faces of an unstructured grid and eliminates duplicates.
- Added `vtkHyperTreeGridGeometricLocator` which is a geometric locator for
  `vtkHyperTreeGrid` datasets.
- `vtkHyperTreeGrid` has a new type of cursor, called `unlimited` cursors.
  `vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor` and
  `vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor` have been added.
- `vtkDataSet::GetCellNumberOfFaces` can be used to get the number of faces in
  a given cell.
- `vtkBoundingBox::ComputeBounds` added to compute the bounds for a set of points.
  This is used for the `GetCellBounds` method in `vtkUnstructuredGrid`,
  `vtkPolyData`, and `vtkExplicitStructuredGrid`.
- Added `vtkCompositeDataSet::CompositeShallowCopy` which shallow copies up to
  dataset pointers only.
- Add new `vtkNonLinearCell::StableClip` method and `vtkQuadraticTetra::StableClip`
  implementation. The goal of this clip is to only decompose a cell if its
  actually clipped, otherwise keep the non-linear cell in its entirety. Note:
  this clipping approach will lead to topological holes between decomposed cells
  and the remaining non-linear cells.
- `vtkPolyData::BuildCells` has been multithreaded.
- Improved performance of `vtkUnstructuredGrid`'s `IsCellBoundary`/`GetCellNeighbors` methods.
- Improved stability of `vtkCellLocator::FindClosestPointWithinRadius`.

[add-vtkImplicitArrays]: https://gitlab.kitware.com/vtk/vtk/-/blob/722365c58bbe829014a6272cf2f55364d68fb0b6/Documentation/release/dev/add-vtkImplicitArrays.md

[](#new-features-documentation)
### Documentation

- The VTK documentation has undergone a major update and consolidation to
  enhance its usefulness for developers. The `/Documentation/docs` directory
  now contains the contents and configuration for the Sphinx-based website,
  published on the ReadTheDocs platform at https://docs.vtk.org. This
  consolidates all existing documentation for VTK, including the newly added
  list of supported data formats, API of all VTK public CMake modules, the VTK
  formats specification (previously part of vtk-examples), and the general
  information about the VTK project. Software process and conventions
  documentation has also been moved from docs.google.com to the new website.
- In addition to the documentation website, two new resources have been
  introduced: the VTK book, which hosts the markdown version of the VTK book at
  https://book.vtk.org and VTK examples at https://examples.vtk.org, which
  contain many examples with redirects put in place to ensure the previous URL
  remains functional. Many other updates to the documentation have also been
  made, including improved documentation structure, removal of obsolete
  documents, and addition of imported third-party projects to the developer
  guide. VTK documentation now follows a versioning system and is actively
  maintained alongside the code.
- Contributions and feedback are welcome for all three websites to ensure that
  the VTK documentation remains up-to-date.
- **Next steps**
  - The next steps for the VTK documentation project include setting up a
    versioning system for docs, doxygen, and the book. Work is also underway to
    include a description of each `Modules` (as well as a `README.md` file) in
    `docs.vtk.org`. And there are plans to explore the possibility of using
    merge request previews for the documentation so that contributors don't
    have to compile it themselves.
  - For `examples.vtk.org`, the plan is to consolidate examples from VTK and
    `vtk-examples`.
  - Pages on the `mediawiki` site will be marked as deprecated, and a link to
    `docs.vtk.org` will be included.
  - These efforts will help ensure that VTK documentation remains user-friendly
    and accessible to all developers.

[](#new-features-filters)
### Filters

- Added Filters/GeometryPreview module which include filters for creating a
  preview of the geomertry of a dataset. Current GeometryPreview filters are:
  - `vtkPointSetToOctreeImageFilter`, used to convert a `vtkPointSet` into an
    image with a number of points per cell target and an `unsigned char`
    octree cell array.
  - `vtkOctreeImageToPointSetFilter`, used to convert an image with an
    `unsigned char` octree cell array to a `vtkPointSet`.
  - `vtkPointSetStreamer`, used to stream points as buckets.
- `vtkImageReslice` now supports oriented images, and can reslice an image into
  a new orientation via the new `SetOutputDirection()` method.
- `vtkDistancePolyDataFilter` can now output directions in conjunction with the
  (signed/unsigned) distances. This is enabled using `ComputeDirection`
  (default:off).
- `vtkVortexCore` now outputs 2 extra arrays, `vorticity` and `vorticity_magnitude`.
- `vtkQuadricDecimation` has the following changes:
  - Added new `MapPointData` property to which maps input point data to its
    decimated output.
  - Added regularization mode. This is enabled by setting
    `vtkQuadricDecimation::SetRegularize(true)` and
    `vtkQuadricDecimation::SetRegularization(value)` where `value` is the standard
    deviation used in the Gaussian distribution.
- `vtkHyperTreeGridGradient` has added support for vector fields. The resulting
  gradient has 3 times the number of components as the input field.
  Additionally, vorticity, divergence and Q-Criterion can now be computed.
- `vtkHyperTreeGridContour` now has 2 contour strategies in the 3D case: the
  former behavior called `USE_VOXELS`, and the new `USE_DECOMPOSED_POLYHEDRA`
  which can produce better contour results when the generated dual cells used
  for contouring appear to be concave. Note: `USE_DECOMPOSED_POLYHEDRA` is much
  slower than the former strategy.
- `vtkExtractCells` has new flags `PassThroughCellIds` and `OutputPointsPrecision`.
- `vtkProbeFilter` has new flag `SnapToCellWithClosestPoint` which can be used
  with `vtkPointSet` inputs to snap the probe points to the cell with the closest point.
- `vtkPlaneCutter` has new flags `OutputPointsPrecision` and `MergePoints`.
- `vtkPCANormalEstimation` has two new search modes used for the selection
  of neighbor points: KNN and RADIUS.
- Various optimizations for `vtkGeometryFilter`:
  - Significant memory reduction (x5) with the introduction of
    `vtkStaticFaceHashLinksTemplate`.
  - Significant speedup (x100) for `vtkGeometryFilter`'s conversion of
    `vtkUnstructuredGrid` to `vtkPolyData` if the `vtkUnstructuredGrid` has
    only either vertices, or lines, or polys, or strips.
- Improved performance of `vtkResampleToImage`.
- Improved performance of `vtkDistancePolyDataFilter`.
- Improved performance of `vtkFrustumSelector`.
- Improved performance of `vtkExtractSelection`.
- Improved memory performance for `vtkCellDataToPointData`.
- Added more VTK-m accelerated filter overrides. If the
  `VTK::AcceleratorsVTKmFilters` is enabled and the CMake option
  `VTK_ENABLE_VTKM_OVERRIDES` is ON, the following filters will be overridden:
  - `vtkGradientFilter` -> `vtkmGradient`
  - `vtkTableBasedClipDataSet` -> `vtkmClip`
  - `vtkCutter` -> `vtkmSlice`
  - `vtkThreshold` -> `vtkmThreshold`
  - `vtkCellDataToPointData` -> `vtkmAverageToPoints`
  - `vtkPointDataToCellData` -> `vtkmAverageToCells`
- The following filter components have been multithreaded:
  - `vtkRectilinearGrid::GetPoints`
  - `vtkExtractCells`
  - `vtkExtractSelection::ExtractSelectedCells`
  - `vtkExtractSelection::ExtractSelectionPoints`
  - `vtkExtractGeometry`
  - `vtkPolyDataNormals`
  - `vtkProbeFilter::ProbeEmptyPoints`
  - `vtkTableBasedClipDataSet`
  - `vtkThreshold`
- New filter `vtkBandFiltering` can be used to perform octave or third octave
  band filtering from a given `vtkTable` in input.
- New filter `vtkHyperTreeGridPProbeFilter` can be used to probe a
  `vtkHyperTreeGrid` using `vtkDataSet`.
- New filter `vtkFieldDataToDataSetAttribute` provides a way to efficiently pass
  FieldData single-value arrays to other AttributeData. This is useful for
  composite data, where FieldData can be used to store a single scalar, varying
  at block level only. Moving this scalar, for instance, to PointData, allows to
  use it in your pipeline.
- New filter `vtkTensorPrincipalInvariants` computes principal values and vectors from 2D and 3D symmetric tensors.
- The new `vtkYieldCriteria` filter computes different yield criteria from given
  2D or 3D symmetric tensors. Available yield criteria currently include:
  - Tresca criterion
  - Von Mises criterion
- Added support for `vtkHyperTreeGrid` with `vtkValueSelector`,
  `vtkLocationSelector` and `vtkFrustumSelector`. The selections generate can
  also now be extracted with the `vtkExtractSelection` filter.
- Added `HyperTreeGridToUnstructuredGrid` boolean flag to `vtkExtractSelection`
  filter to control whether to output an unstructured grid (when `true`) or a
  hyper try grid (when `false`, the default).
- Fix `vtkHyperTreeGridAxisClip` when `insideout` is `true`.
- The `vtkHyperTreeGridGeometry` filter now provides `PassThroughCellIds`
  (default `false`) to pass through original cell IDs from the input
  `vtkHyperTreeGrid` to the output `vtkPolyData`.
- Added support for `vtkHyperTreeGrid` resampling with `vtkResampleWithDataSet`
  and `vtkPResampleWithDataSet` filters.
- `vtkPolyDataToUnstructuredGrid` is a new multithreaded filter that converts\
  `vtkPolyData` to `vtkUnstructuredGrid`.
- Added `vtkAttributeDataToTableFilter` filter to VTK from ParaView. It serves
  to turn a data object into a table by shallow copying its attributes into row
  data. This replaces `vtkDataObjectToTable`, which has been deprecated.
- `vtkBoundaryMeshQuality` filter added to compute quality metrics for boundary meshes.
- `vtkGenerateProcessIds` filter added to generate process ids for both
  PointData and CellData, and store it via ProcessIds attribute. This filter
  replaces `vtkProcessIdScalars`, which has been deprecated.
- Added `PointDataWeighingStrategy` option to `vtkCleanUnstructuredGrid` for
  choosing how to collapse point data. Previously, when merging duplicate points,
  the point with the lowest index had its data transported to the merged output
  point. With this new option, you can now choose between:
  - `vtkCleanUnstructuredGrid::FIRST_POINT` (for backwards compatibility):
    where the point with the lowest index in the input gets the ownership of
    the merged point.
  - `vtkCleanUnstructuredGrid::AVERAGING`: where the data on the merged output
    point is the number average of the input points.
  - `vtkCleanUnstructuredGrid::SPATIAL_DENSITY`: where the merged point data
    is averaged using a partition of the volumes in the cells attached to each
    point being merged.
- `vtkTableFFT` no longer adds or squeezes certain arrays, like those starting
  with `vtk`, when the input and the output have a different size.
- `vtkTableFFT` now supports complex valued FFTs.

[](#new-features-io)
### I/O

- VTK now supports [URI](https://datatracker.ietf.org/doc/html/rfc3986) parsing,
  resolution and loading through the two new classes `vtkURI` and
  `vtkURILoader`. URI support as been implemented to enable resource stream
  support in readers that need to access multiple resources. For more infomation
  about URI usage and loading, please refer to the `vtkURILoader` documentation.
- `vtkResourceStream` added as customizable replacement for standard istreams.
  Added `vtkFileResourceStream` and `vtkMemoryResourceStream` implementations.
- `vtkResourceParser` added as a high-performance formatted input parser.
  `vtkResourceParser` parses strings, floats, integers and booleans from any
  `vtkResourceStream`. Most `std::istream` common features have equivalent
  methods in `vtkResourceParser`, making migration mostly trivial.
- Added `vtkPLYReader`, `vtkGLTFReader` and `vtkOBJReader` support for reading
  from `vtkResourceStream`.
- `vtkMemoryResourceStream` can now own a streamed buffer, meaning you can free
  the source buffer after setting it. You can now set source buffer as a
  `std::string`, a `std::vector` or a `vtkBuffer*`.
- Added `vtkNek5000Reader` to support NEK5000 data format.
- Added `vtkOpenVDBReader` in the `IOOpenVDB` module read to .vdb files.
- Added `vtkIOSSWriter` writer for the Exodus file format implemented using the
  [IOSS library](https://sandialabs.github.io/seacas-docs). Input can be
  `vtkPartitionedDataSetCollection`, `vtkPartitionedDataSet` or `vtkDataSet`.
  `vtkIOSSWriter` can be executed in parallel.
- Added support for higher-order Lagrange cells with `vtkIOSSReader`.
- `vtkIOSSReader` now supports mixed-order, 12-node wedge elements.
- Added flag `ReadAllFilesToDetermineStructure` to `vtkIOSSReader` which toggles
  reading all files or only reading the first file to determine mesh structure.
- Added `vtkNetCDFUGRIDReader` support for reading 2D meshes from NetCDF UGRID files.
- `VTKHDF`'s major version has been incremented to 2 due to the following additions:
  - Added `VTKHDF` support for both static and transient `vtkPolyData` files.
    The metadata schematic for how transient data is read is shown below (first image).
  - Added `VTKHDF` support for transient `ImageData` and `UnstructuredGrid` data.
    The metadata schematic for how transient data is read is shown below (second image).
  - Specific documentation related to the evolution of the `VTKHDF` format can
    be found [here](https://kitware.github.io/vtk-examples/site/VTKFileFormats/).
- Added ANSYS Fluent CFF Reader (Common Fluid Format) into its own dedicated
  module `VTK::IOFLUENTCFF`, which currently supports the new `vtkFLUENTCFFReader`.
  See further documentation [here][fluent-ccf-docs].
- Added `vtkNumberToString::SetHighExponent` and `vtkNumberToString::SetLowExponent`
  to control the exponent range for scientific or fixed notation.
- Fixed reading fault on vector fields with `vtkXMLHyperTreeGridReader`.
- Added support for mixed cell unstructured grids in `vtkConduitSource`. See
  `ValidateMeshTypeMixed` and `ValidateMeshTypeMixed2D` tests in
  `IO/CatalystConduit/Testing/Cxx/TestConduitSource.cxx` for more details.
- `vtkDataObjectToConduit` now supports polygons, `vtkPolyData` and mixed shapes
  `vtkUnstructuredGrid` topologies.

![poly data hdf schema](imgs/9.3/poly_data_hdf_schema.png)
![schema](imgs/9.3/transient_hdf_schema.png)

- Add `vtkMPICommunicator` support for MPI message lengths > MAX_INT, which can
  now occur in MPI 4.X and later.
- Added `vtkMPICommunicator::NoBlockSend` method that allows for dynamic MPI types.
- Fixed bugs in `vtkMPICommunicator::Test*` and `vtkMPICommunicator::Wait*` that
  prevented them from being called repeatedly.
- `vtkIOSSReader` can now merge entity blocks into a single block for the exodus
  format using the flag `MergeExodusEntityBlocks` which is off by default. This
  is useful e.g. for cases where the entity blocks just represent different cell
  types but they actually describe the same block.
- Incorrect `vtkEnSightWriter` output has been fixed for `VTK_POLYGON`, `VTK_WEDGE`,
  `VTK_QUADRATIC_WEDGE`, `VTK_QUADRATIC_EDGE` or `VTK_CONVEX_POINT_SET` cell types.
  Support for `VTK_POLYHEDRON` has also been added.
- Added flag `WriteNodeIDs` to `vtkEnSightWriter`, which toggles writing node
  and element IDs to the EnSight data. This makes the output geometry file
  significantly smaller.
- Added property `SizeAverageCellToPoint` to `vtkOpenFOAMReader` that allows the
  user to weigh the cell point averagine operation by cell size.

[fluent-ccf-docs]: https://docs.vtk.org/en/latest/modules/vtk-modules/IO/FLUENTCFF/README.html

[](#new-features-interaction)
### Interaction

- Add support for removing intermediate layers with `vtkExpandMarkedElements`.
  Added boolean flags `RemoveSeed` and `RemoveIntermediateLayers`. Using these
  flags will remove their respective layers, keeping only the final expansion
  layer. This functionality has been extended for use in `vtkSelectionSource`
  and `vtkSelector`.
- `vtkAppendSelection` `SetColorArray`, `SetInputColor` and `GetInputColor`
  methods added to associate colors to selections which are used to generate
  a color array.
- `vtkCamera`s can now be oriented with the `vtkCamera3DWidget` and its
  representation `vtkCamera3DRepresentation`. The representation allows you to
  move the camera position, target position, to rotate the view up and to
  update its view angle. See example:

![camera widget example](imgs/9.3/camera_widget.png)

- Added `vtk3DCursorWidget` and `vtk3DCursorRepresentation` to track mouse in a
  scene. The 3D cursor follows the mouse and is placed on the surface of the
  actor's scene. Note: this behavior does not currently support volumes.
- Added `SetForce3DArcPlacement` API to `vtkAngleRepresentation2D` which allows
  users to force correct the 3D placement of arcs that may be misalligned.
- Moved `vtkCompassWidget` and `vtkCompassRepresentation` from `Geovis/Core` to
  `Interaction/Widgets`. Previously these classes were in a non-working state,
  but have been fixed with the following changes:
  - `vtkSliderRepresentation` and subclasses: Fixes were applied to correctly
    calculate the local coordinate for the slider position. They also now honor
    their `Visibility` parameter.
  - In `vtkCompassWidget` you can now adjust the update `TimerDuration`,
    `TiltSpeed` and `DistanceSpeed` when clicking on the slider end caps.
- Added standardized color setters (`SetForegroundColor`, `SetHandleColor` and
  `SetInteractionColor`) to several widgets used by ParaView. These widgets include
  `vtkBoxRepresentation`, `vtkCurveRepresentation`, `vtkLineRepresentation`,
  `vtkSphereRepresentation`, `vtkImplicitCylinderRepresentation`,
  `vtkImplicitPlaneRepresentation`, `vtkDisplaySizedImplicitPlaneRepresentation`
  and `vtkPointHandleRepresentation3D`. Description of added methods:
  The intended use of these colors is as follows:
  | Color       | Description |
  | ----------- | ----------- |
  | `HandleColor`      | Widget handles that are available to interact with via click+drag.                   |
  | `InteractionColor` | Widget handles the user is interacting with (via a click+drag) or hovering over.     |
  | `ForegroundColor`  | Widget elements meant to contrast with the background and which are not interactive. |
- Added `vtkOrientationWidget` and its representation
  `vtkOrientationRepresentation` which are used to rotate any actor. The
  appearance of widget controls are customizable through the representation.
  See examples:

![orientation widget demonstration](imgs/9.3/orientation_widget_demo.gif)
![orientation widget representations](imgs/9.3/orientation_widget_states.gif)


[](#new-features-math)
### Math

- Add `GetOctaveFrequencyRange` computation to `vtkFFT` which gets lower/upper
  frequencies of octaves. Parameters include `octaveSubdivision`, from which
  you can choose one-third, half, or full octave frequency ranges (default is
  full) as well as `baseTwo` which toggles between base 2 and base 10 power
  (default is base 2).

[](#new-features-modules)
### Module System

- Added `vtk_module_wrap_python(HEADERS_DESTINATION)` argument. This argument
  adds a header into the install tree that initializes the builtin module table
  for statically built Python modules. This header had not been installed previously.

[](#new-features-python)
### Python

- Added `ModernizePythonImports.py` script that parse Python scripts and
  replaces "import vtk" with module specific imports for performance.
- `vtkDataObject`'s now support pickling by the Python
  [`pickle` module](https://docs.python.org/3/library/pickle.html).
  - To use this new feature in python, you must first run:
    ```python
    import vtkmodules.util.pickle_support
    ```
  - Once you have imported the module the pickling of data objects is straightforward:
    ```python
    from vtkmodules.vtkFiltersSources import vtkSphereSource
    import vtkmodules.util.pickle_support
    import pickle

    sphereSrc = vtkSphereSource()
    sphereSrc.Update()

    pickled = pickle.dumps(sphereSrc.GetOutput())
    unpickled = pickle.loads(pickled)

    print(unpickled)
    ```

[](#new-features-qt)
### Qt

- Added minimal Qt/VTK example application `MinimalQtVTKApp`.
- QML integration support has been upgraded.
- Added custom cursor methods to `QVTKOpenGLStereoWidget` and
  `QVTKOpenGLNativeWidget` that get/set the cursor shape.

[](#new-features-rendering)
### Rendering

- Added `VTK_USE_WIN32_OPENGL` option to disable Win32 API in
  `VTK::RenderingOpenGL2` on Windows. This enables OSMesa support on Windows.
- Improved performance of `vtkTupleInterpolator`.
- Added new module providing `zSpace` support to VTK, implementing render window,
  interactor style, camera, etc. Supports both the "Core zSpace API" (legacy)
  and the "Core Compatibility zSpace API" (latest).
- `vtkAxisActor2D` labels now use `UseFontSizeFromProperty`, which was formerly
  used exclusively by the title.
- `vtkImageResliceMapper` now fully supports oriented images, in the same manner
  as `vtkImageSliceMapper`. This allows the display of arbitrary oblique slices
  of oriented images, including those where the orientation matrix has a
  negative determinant.
- Improved performance and consistency of
  `vtkRenderWindowInteractor::ProcessEvents` across all platforms.
- `vtkCompositePolyDataMapper` can now color separate blocks with different
  scalar arrays. To use this functionality, turn on `ScalarVisibility` and
  select a `ScalarMode` and/or a `ColorMode`.
- Improved performance of `vtkContext2D` for rendering large numbers of points.
- `vtkCompositePolyDataMapper` can now use separate lookup tables and
  interpolation modes for different blocks in a composite dataset. You can
  override lookup table and other related attributes like scalar interpolation
  and scalar ranges. Refer to `vtkMapper` documentation. Here's a summary:
  - `ScalarVisibility`: True/False
  - `UseLookupTableScalarRange`: When true, the mapper shall import the range
    from the lookup table.
  - `InterpolateScalarsBeforeMapping`: Applies when mesh is colored using point
    scalars. This flag decides whether point colors are sampled using texture
    maps instead of interpolating colors on the GPU after scalars are mapped to
    colors.
  - `ColorMode`: Specifies whether to map scalars to colors or directly use the
    scalars as RGB(A) values.
  - `ScalarRange`: Specifies a range of scalars for color mapping.
  - `LookupTable`: Specifies a lookup table.
- `vtkCompositePolyDataMapper` in VTK::RenderingCore has been improved to
  efficiently render large datsets. It now performs as well as `vtkCompositePolyDataMapper2`
  in the VTK::RenderingOpenGL2 module, which has now been deprecated. This
  refactor has significantly impacted the following VTK modules:
  - `vtkCompositePolyDataMapper` now has an API similar to
    `vtkCompositePolyDataMapper2`.
  - `vtkCompositeSurfaceLICMapper` derives `vtkCompositePolyDataMapper` instead
    of `vtkCompositePolyDataMapper2`.
  - The OSPRay module uses `vtkCompositePolyDataMapper` instead of
    `vtkCompositePolyDataMapper2`.
  - `vtkVtkJSSceneGraphSerializer` uses `vtkCompositePolyDataMapper` instead of
    `vtkCompositePolyDataMapper2`.
- Added new `vtkOpenGLES30PolyDataMapper` supports polydata and composite
  dataset rendering with OpenGL ES 3.0. If VTK was configured with
  `VTK_OPENGL_USE_GLES=ON`, this mapper is an override for `vtkPolyDataMapper`.
- Fixed `vtkSurfaceLICMapper` crash when rendering lines as tubes or points as spheres.
- `vtkTextureObject` can now be used to create texture buffers on all OpenGL
  implementations that support 2D textures.
- Fixed `vtkCamera` CAVE bugs for head tracking and volume rendering.
- Fixed compositing artifacts when volume rendering in parallel with the OSPRay
  raycaster. This fix adds a new `VolumeSamplingRate` parameter to
  `vtkOSPRayRendererNode`.
- `vtkPolarAxesActor` has a number of new features.
  - Radial/polar axes and arc ticks are now customizable.
   `SetRequestedNumberOfRadialAxes`, `SetRequestedDeltaAngleRadialAxes`,
   `SetArcTickMatchesRadialAxes`, `SetRequestedNumberOfPolarAxes`,
   `SetRequestedDeltaAnglePolarAxes`, `SetArcTickMatchesPolarAxes`,
   `SetDeltaAngleMajor`, and `SetDeltaAngleMinor` are all new methods.
  - Tick size is now computed as a ratio of maximum radius by default. You can
    specify a value for this ratio using `SetTickRatioRadiusSize`, default is 0.02.
  - You can now change polar arcs resolution per degree. See
    `SetPolarArcResolutionPerDegree`, default is 0.2.
  - Text offsets are now customizable with `SetPolarTitleOffset`,
    `SetRadialTitleOffset`, `SetPolarLabelOffset` and `SetPolarExponentOffset`.
- Added new gradient background modes. You can select from various gradient
  background modes with `vtkViewport::SetGradientMode`. The following modes are available:
  - `VTK_GRADIENT_VERTICAL`
    Background color is used at the bottom, Background2 color is used at the top.
  - `VTK_GRADIENT_HORIZONTAL`
    Background color on the left, Background2 color on the right.
  - `VTK_GRADIENT_RADIAL_VIEWPORT_FARTHEST_SIDE`
    Background color in the center, Background2 color on and beyond the circle
    ellipse edge. Circle/Ellipse touches all sides of the square/rectangle
    viewport.
  - `VTK_GRADIENT_RADIAL_VIEWPORT_FARTHEST_CORNER`
    Background color in the center, Background2 color on and beyond the circle/
    ellipse edge. Circle/Ellipse touches all corners of the square/rectangle
    viewport.
  See gradient background examples:

![vtkViewport gradient modes example](imgs/9.3/add-radial-gradient-background.png)


[](#new-features-third-party)
### Third Party

- `fast_float` added as a vendored package. It is available using the
  `VTK::fast_float` module.

[](#new-features-vtkm)
### VTK-m

- VTK-m submodule has been updated to the latest release, VTK-m 2.0.0. Being a
  major update, it significantly breaks compatibility with the API provided by
  VTK-m 1.X. Thus, many changes were needed in VTK to make it compatible with
  VTK-m 2.0.0.
  - All VTK-m cmake targets are now prefixed with `vtkm_`. Exceptions have been
    made for `vtkm::cuda` and `vtkm::kokkos_hip`, for compatibility with
    external VTK-m imports.
  - VTK-m VTK module is now called `vtk::vtkvtkm` as opposed to `vtk::vtkm`.
  - `vtkmlib` functions that translate VTK to VTK-m data structures now respect
    coordinates system changes. Coordinates systems are now represented as a
    field inside the VTK-m dataset rather than a special/unique component.
- The Fides library has been updated upstream to ensure compatibility with
  VTK-m 2.0.0. This update in upstream has been brought to VTK to enable using
  VTK-m 2.0.0 and Fides through VTK.

----------------------------------------

[](#deprecations)
## Deprecated and Removed Features

[](#deprecations-legacy)
### Legacy

The following APIs were deprecated in 9.1 or earlier and are now removed:

- Python 2 support has been removed.
- Threading types (use C++ `std` classes instead):
  - `vtkSimpleConditionVariable` (`std::condition_variable`)
  - `vtkConditionVariable` (`std::condition_variable`)
  - `vtkMutexType`
  - `vtkSimpleMutexLock` (`std::mutex`)
  - `vtkMutexLock` (`std::lock_guard`)
  - `vtkCritSecType`
  - `vtkSimpleCriticalSection` (`std::mutex`)
- The `EvaluateLocationProjectedNode` method has been removed on the following
  classes; use `EvaluateLocation` instead:
  - `vtkBezierCurve`
  - `vtkBezierHexahedron`
  - `vtkBezierQuadrilateral`
  - `vtkBezierTetra`
  - `vtkBezierTriangle`
  - `vtkBezierWedge`
- `vtkBezierInterpolation::flattenSimplex` has been renamed to
  `::FlattenSimplex`
- `vtkBezierInterpolation::unflattenSimplex` has been renamed to
  `::UnFlattenSimplex`
- `vtkBezierInterpolation::deCasteljauSimplex` has been renamed to
  `::DeCasteljauSimplex`
- `vtkBezierInterpolation::deCasteljauSimplexDeriv` has been renamed to
  `::DeCasteljauSimplexDeriv`
- `vtkHigherOrderHexahedron::getEdgeCell` has been renamed to `::GetEdgeCell`
- `vtkHigherOrderHexahedron::getFaceCell` has been renamed to `::GetFaceCell`
- `vtkHigherOrderHexahedron::getInterp` has been renamed to `::GetInterpolation`
- `vtkHigherOrderQuadrilateral::getEdgeCell` has been renamed to `::GetEdgeCell`
- `vtkHigherOrderTetra::getEdgeCell` has been renamed to `::GetEdgeCell`
- `vtkHigherOrderTetra::getFaceCell` has been renamed to `::GetFaceCell`
- `vtkHigherOrderTriangle::eta` has been renamed to `::Eta`
- `vtkHigherOrderTriangle::deta` has been renamed to `::Deta`
- `vtkHigherOrderTriangle::getEdgeCell` has been renamed to `::GetEdgeCell`
- `vtkHigherOrderQuadrilateral::getBdyQuad` has been renamed to `::GetBoundaryQuad`
- `vtkHigherOrderQuadrilateral::getBdyTri` has been renamed to `::GetBoundaryTri`
- `vtkHigherOrderQuadrilateral::getEdgeCell` has been renamed to `::GetEdgeCell`
- `vtkHigherOrderQuadrilateral::getInterp` has been renamed to `::GetInterpolation`
- `vtkIncrementalOctreeNode::InsertPoint` without `numberOfNodes` is removed
  for the variant with it
- `vtkLine::Intersection3D` has been replaced by `vtkLine::Intersection`
- `vtkPointData::NullPoint` has been replaced by `vtkFieldData::NullData`
- `vtkSelectionNode::INDEXED_VERTICES` has been removed
- `vtkReaderExecutive` has been removed
- `vtkThreadMessager` has been removed; use C++ `std` threading support instead
- `vtkPassThroughFilter` has been replaced by `vtkPassThrough`
- `vtkXMLPPartitionedDataSetWriter` has been replaced by
  `vtkXMLPartitionedDataSetWriter`
- `vtkBlueObeliskData::GetWriteMutex` has been replaced by `::LockWriteMutex`
  and `::UnlockWriteMutex`
- `vtkThreshold::ThresholdByLower` has been replaced by `::SetLowerThreshold`
  or `::SetThresholdFunction`
- `vtkThreshold::ThresholdByUpper` has been replaced by `::SetUpperThreshold`
  or `::SetThresholdFunction`
- `vtkThreshold::ThresholdBetween` has been replaced by `::SetLowerThreshold`
  and `::SetUpperThreshold` or `::SetThresholdFunction`
- `vtkMultiBlockFromTimeSeriesFilter` has been replaced by
  `vtkGroupTimeStepsFilter`
- `vtkDataSetGhostGenerator` has been replaced by `vtkGhostCellsGenerator`
- `vtkDataSetSurfaceFilter` methods `::GetUseStrips`, `::SetUseStrips`,
  `::UseStripsOn`, and `::UseStripsOff` have been removed
- `vtkStructuredGridGhostDataGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkUniformGridGhostDataGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkUnstructuredGridGhostCellsGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkPDataSetGhostGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkPStructuredGridGhostDataGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkPUniformGridGhostDataGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkPUnstructuredGridGhostCellsGenerator` has been replaced by
  `vtkGhostCellsGenerator`
- `vtkOpenGLRenderer::HaveApplePrimitiveIdBug` has been removed as no supported
  macOS release has the issue anymore
- `vtkOpenGLRenderWindow` has removed the following methods:
  - `::GetBackLeftBuffer`
  - `::GetBackRightBuffer`
  - `::GetFrontLeftBuffer`
  - `::GetFrontRightBuffer`
  - `::GetBackBuffer`
  - `::GetFrontBuffer`
- `vtkOpenGLRenderWindow::GetOffScreenFramebuffer` has been replaced by
  `::GetRenderFramebuffer`
- `vtkDataEncoder::PushAndTakeReference` has been replaced by `::Push`
- `vtkGenericOpenGLRenderWindow::IsDrawable` is removed
- `vtkIOSRenderWindow::IsDrawable` is removed
- `vtkCocoaRenderWindow::IsDrawable` is removed
- `vtkRenderWindow::IsDrawable` is removed
- `vtkDIYUtilities::GetDataSets` is replaced by
  `vtkCompositeDataSet::GetDataSets`
- `vtkCurveRepresentation::*DirectionalLine*` methods have been renamed to
  `::*Directional*`
- `vtkSimpleImageFilterExample` has been removed
- `vtkExodusIIReaderPrivate::PrintData` has been renamed to `::PrintSelf`
- `vtkEnSightReader::ReplaceWildcards` has been replaced by
  `vtkGenericEnSightReader::ReplaceWildcardsHelper`
- `vtkQtSQLDatabase::*Port` has been renamed to `::*DbPort` to avoid Windows
  SDK macro collisions
- The `vtkDataSetSurfaceFilter::GetInterpolatedPointId` overload
  without `weights` has been replaced by the one with it

[](#deprecations-charts)
### Charts

- `vtkPlot` color setter/getter methods with floating point parameters are now
  suffixed with `F`. The former methods without the suffix have been deprecated.
  For example:
  - `vtkPlot::SetColor(double r, double g, double b)` has been moved to
    `vtkPlot::SetColorF(double r, double g, double b)`.

[](#deprecations-core)
### Core

- The `vtkStdString` implicit conversion to `const char*` is deprecated. Instead,
  call `.c_str()` explicitly on the instance.
- `vtkVariant::ToX` and related string parsing no longer supports `[-]infinity`
  as a valid float conversion. Only `[-]inf` is now supported.

[](#deprecations-data)
### Data

- Deprecated `vtkCompositeDataSet::RecursiveShallowCopy`, use
  `vtkCompositeDataSet::ShallowCopy` instead.
- `vtkUnstructuredGrid::GetCellLinks` has been deprecated,
  `vtkUnstructuredGrid::GetLinks` instead.
- `vtkAbstractCellLinks::BuildLinks(vtkDataSet*)` has been deprecated, use
  `vtkAbstractCellLinks::BuildLinks()` instead.

[](#deprecations-filters)
### Filters

- `vtkDataObjectToTable` is deprecated in favor of
  `vtkAttributeDataToTableFilter`, which has the same functionality.
- `vtkProcessIdScalars` is deprecated in favor of `vtkGenerateProcessIds`. The
  following is a migration example:
  - Deprecated `vtkProcessIdScalars` code:
    ```cpp
    vtkNew<vtkProcessIdScalars> processIdsGenerator;
    processIdsGenerator->SetInputConnection(someData->GetOutputPort());
    processIdsGenerator->SetScalarModeToCellData();
    processIdsGenerator->Update();

    vtkDataSet* pidGeneratorOutput = processIdsGenerator->GetOutput();
    vtkIntArray* pidArray = vtkIntArray::SafeDownCast(pidGeneratorOutput->GetCellData()->GetArray("ProcessId"));
    ```
  - New `vtkGenerateProcessIds` code:
    ```cpp
    vtkNew<vtkGenerateProcessIds> processIdsGenerator;
    processIdsGenerator->SetInputConnection(someData->GetOutputPort());
    processIdsGenerator->GeneratePointDataOff();
    processIdsGenerator->GenerateCellDataOn();
    processIdsGenerator->Update();

    vtkDataSet* pidGeneratorOutput = processIdsGenerator->GetOutput();
    vtkIdTypeArray* pidArray = vtkIdTypeArray::SafeDownCast(pidGeneratorOutput->GetCellData()->GetProcessIds());
    ```


[](#deprecations-io)
### I/O

- `vtkOpenFOAMReader` support for polyhedral decomposition,
  `SetDecomposePolyhedra`, has been deprecated.
- `vtkNumberToString::operator()` has been deprecated in favor of
  `vtkNumberToString::Convert`.

[](#deprecations-python)
### Python
- The VTK wheels no longer provide the `VTK::PythonInterpreter` module as it is
  unnecessary in such situations.

[](#deprecations-rendering)
### Rendering

- `vtkXOpenGLRenderWindow::SetSizeNoXResize()` has been deprecated due to
  structural RenderingUI changes in VTK 9.0.
- `vtkOutputWindowCleanup` has been deprecated as it is no longer used.
- `vtkCompositePolyDataMapper2` has been deprecated in favor of
  `vtkCompositePolyDataMapper` following the latter's performance improvements.

----------------------------------------

[](#other-changes)
## Other Changes
