//VTK::System::Dec

//----------------------------------------------------------------------------------------
// Implementation d'un Tileable Curl noise copié collé depuis https://www.shadertoy.com/view/3lXfzH
// Peut etre moyen d'avoir une meilleur implementation, peut etre aussi d'avoir un tileable noise 4D ...
// vec3 HashALU(in vec3 p, in float numCells)
// {
//   // This is tiling part, adjusts with the scale
//   p = mod(p, numCells);

//     p = vec3( dot(p,vec3(127.1,311.7, 74.7)),
//         dot(p,vec3(269.5,183.3,246.1)),
//         dot(p,vec3(113.5,271.9,124.6)));

//   return -1.0 + fract(sin(p)*43758.5453123) * 2.0;
// }

#define SIN_15 0.2588190451
#define COS_15 0.96592582628

// New hash based on hash13() from "Hash without Sine" by Dave_Hoskins (https://www.shadertoy.com/view/4djSRW)
float noise(in vec4 p)
{
  p = fract(p * 0.1031);
  p += dot(p, p.zwyx + 31.32);
  return fract((p.x + p.y) * p.z - p.x * p.w);
}

// #define Hash HashALU
// float TileableNoise(in vec3 p, in float numCells )
// {
//   vec3 f, i;

//   p *= numCells;


//   f = fract(p);		// Separate integer from fractional
//     i = floor(p);

//     vec3 u = f*f*(3.0-2.0*f); // Cosine interpolation approximation

//     return mix( mix( mix( dot( Hash( i + vec3(0.0,0.0,0.0), numCells ), f - vec3(0.0,0.0,0.0) ),
//                           dot( Hash( i + vec3(1.0,0.0,0.0), numCells ), f - vec3(1.0,0.0,0.0) ), u.x),
//                      mix( dot( Hash( i + vec3(0.0,1.0,0.0), numCells ), f - vec3(0.0,1.0,0.0) ),
//                           dot( Hash( i + vec3(1.0,1.0,0.0), numCells ), f - vec3(1.0,1.0,0.0) ), u.x), u.y),
//                 mix( mix( dot( Hash( i + vec3(0.0,0.0,1.0), numCells ), f - vec3(0.0,0.0,1.0) ),
//                           dot( Hash( i + vec3(1.0,0.0,1.0), numCells ), f - vec3(1.0,0.0,1.0) ), u.x),
//                      mix( dot( Hash( i + vec3(0.0,1.0,1.0), numCells ), f - vec3(0.0,1.0,1.0) ),
//                           dot( Hash( i + vec3(1.0,1.0,1.0), numCells ), f - vec3(1.0,1.0,1.0) ), u.x), u.y), u.z );
// }

// Generate noise from hash
float snoise(in vec4 p)
{
  vec4 cell = floor(p);
  vec4 local = fract(p);
  local *= local * (3.0 - 2.0 * local);

  float ldbq = noise(cell);
  float rdbq = noise(cell + vec4(1.0, 0.0, 0.0, 0.0));
  float ldfq = noise(cell + vec4(0.0, 0.0, 1.0, 0.0));
  float rdfq = noise(cell + vec4(1.0, 0.0, 1.0, 0.0));
  float lubq = noise(cell + vec4(0.0, 1.0, 0.0, 0.0));
  float rubq = noise(cell + vec4(1.0, 1.0, 0.0, 0.0));
  float lufq = noise(cell + vec4(0.0, 1.0, 1.0, 0.0));
  float rufq = noise(cell + vec4(1.0, 1.0, 1.0, 0.0));
  float ldbw = noise(cell + vec4(0.0, 0.0, 0.0, 1.0));
  float rdbw = noise(cell + vec4(1.0, 0.0, 0.0, 1.0));
  float ldfw = noise(cell + vec4(0.0, 0.0, 1.0, 1.0));
  float rdfw = noise(cell + vec4(1.0, 0.0, 1.0, 1.0));
  float lubw = noise(cell + vec4(0.0, 1.0, 0.0, 1.0));
  float rubw = noise(cell + vec4(1.0, 1.0, 0.0, 1.0));
  float lufw = noise(cell + vec4(0.0, 1.0, 1.0, 1.0));
  float rufw = noise(cell + 1.0);

  return mix(mix(mix(mix(ldbq, rdbq, local.x),
                      mix(lubq, rubq, local.x),
                      local.y),

                  mix(mix(ldfq, rdfq, local.x),
                      mix(lufq, rufq, local.x),
                      local.y),

                  local.z),

              mix(mix(mix(ldbw, rdbw, local.x),
                      mix(lubw, rubw, local.x),
                      local.y),

                  mix(mix(ldfw, rdfw, local.x),
                      mix(lufw, rufw, local.x),
                      local.y),

                  local.z),

              local.w);
}

// float TileableNoiseFBM(in vec3 p, float numCells, int octaves)
// {
//   float f = 0.0;

//   // Change starting scale to any integer value...
//     p = mod(p, vec3(numCells));
//   float amp = 0.5;
//     float sum = 0.0;

//   for (int i = 0; i < octaves; i++)
//   {
//     f += TileableNoise(p, numCells) * amp;
//         sum += amp;
//     amp *= 0.5;

//     // numCells must be multiplied by an integer value...
//     numCells *= 2.0;
//   }

//   return f / sum;
// }

// Add octaves to noise
float fnoise(in vec4 p, in float scale, in float octaves)
{
  p *= scale;
  float nscale = 1.0;
  float tscale = 0.0;
  float value = 0.0;

  for (float octave=0.0; octave < octaves; octave++)
  {
    value += snoise(p) * nscale;
    tscale += nscale;
    nscale *= 0.5;
    p *= 2.0;
  }

  return value / tscale;
}

// vec3 snoiseVec3( vec3 x, in float numCells, int octaves )
// {

//   float s  = TileableNoiseFBM(vec3( x ), numCells, octaves);
//   float s1 = TileableNoiseFBM(vec3( x.y - 19.1 , x.z + 33.4 , x.x + 47.2 ), numCells, octaves);
//   float s2 = TileableNoiseFBM(vec3( x.z + 74.2 , x.x - 124.5 , x.y + 99.4 ), numCells, octaves);
//   vec3 c = vec3( s , s1 , s2 );
//   return c;

// }
// vec3 TileableCurlNoise(in vec3 p, in float numCells, in int octaves)
// {
//   const float e = .1;
//   vec3 dx = vec3( e   , 0.0 , 0.0 );
//   vec3 dy = vec3( 0.0 , e   , 0.0 );
//   vec3 dz = vec3( 0.0 , 0.0 , e   );

//   vec3 p_x0 = snoiseVec3( p - dx, numCells, octaves );
//   vec3 p_x1 = snoiseVec3( p + dx, numCells, octaves );
//   vec3 p_y0 = snoiseVec3( p - dy, numCells, octaves );
//   vec3 p_y1 = snoiseVec3( p + dy, numCells, octaves );
//   vec3 p_z0 = snoiseVec3( p - dz, numCells, octaves );
//   vec3 p_z1 = snoiseVec3( p + dz, numCells, octaves );

//   float x = p_y1.z - p_y0.z - p_z1.y + p_z0.y;
//   float y = p_z1.x - p_z0.x - p_x1.z + p_x0.z;
//   float z = p_x1.y - p_x0.y - p_y1.x + p_y0.x;

//   const float divisor = 1.0 / ( 2.0 * e );
//   return normalize( vec3( x , y , z ) * divisor );
// }

// Rewrote
vec4 snoiseVec4( vec4 x, in float numCells, int octaves )
{
  float s  = fnoise(vec4( x ), numCells, octaves);
  float s1 = fnoise(vec4( x.y - 19.1 , x.z + 33.4 , x.w + 50 , x.x + 47.2 ), numCells, octaves);
  float s2 = fnoise(vec4( x.z + 74.2 , x.w + 50, x.x - 124.5 , x.y + 99.4 ), numCells, octaves);
  float s3 = fnoise(vec4( x.w + 50, x.z + 74.2 ,  x.x - 124.5 , x.y + 99.4 ), numCells, octaves);
  vec4 c = vec4( s , s1 , s2 , s3 );
  return c;
}

vec4 TileableCurlNoise(in vec4 p, in float numCells, in int octaves)
{
  const float e = .1;
  vec4 dx = vec4( e   , 0.0 , 0.0 , 0.0 );
  vec4 dy = vec4( 0.0 , e   , 0.0 , 0.0 );
  vec4 dz = vec4( 0.0 , 0.0 , e   , 0.0 );
  vec4 dw = vec4( 0.0 , 0.0 , 0.0 , e   );

  vec4 p_x0 = snoiseVec4( p - dx, numCells, octaves );
  vec4 p_x1 = snoiseVec4( p + dx, numCells, octaves );
  vec4 p_y0 = snoiseVec4( p - dy, numCells, octaves );
  vec4 p_y1 = snoiseVec4( p + dy, numCells, octaves );
  vec4 p_z0 = snoiseVec4( p - dz, numCells, octaves );
  vec4 p_z1 = snoiseVec4( p + dz, numCells, octaves );
  vec4 p_w0 = snoiseVec4( p - dw, numCells, octaves );
  vec4 p_w1 = snoiseVec4( p + dw, numCells, octaves );

  // float x = p_y1.z - p_y0.z - p_z1.y + p_z0.y;
  // float y = p_z1.x - p_z0.x - p_x1.z + p_x0.z;
  // float z = p_x1.y - p_x0.y - p_y1.x + p_y0.x;

  float x = p_y1.w - p_y0.w - p_z1.z + p_z0.z + p_w0.y - p_w1.y;
  float y = p_z1.x - p_z0.x - p_w0.w + p_w1.w + p_x1.z - p_x0.z;
  float z = p_w1.y - p_w0.y - p_x1.x + p_x0.x + p_y1.w - p_y1.w;
  float w = p_x1.z - p_x0.z - p_y1.y + p_y0.z + p_z1.x - p_z0.x;

  const float divisor = 1.0 / ( 2.0 * e );
  return normalize( vec4( x , y , z , w) * divisor );
}

/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkPolyDataFS.glsl

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// Template for the polydata mappers fragment shader

uniform int PrimitiveIDOffset;

//VTK::CustomUniforms::Dec

// VC position of this fragment
//VTK::PositionVC::Dec

// Camera prop
//VTK::Camera::Dec

// optional color passed in from the vertex shader, vertexColor
//VTK::Color::Dec

// optional surface normal declaration
//VTK::Normal::Dec

// extra lighting parameters
//VTK::Light::Dec

// Texture maps
//VTK::TMap::Dec

// Texture coordinates
//VTK::TCoord::Dec

// picking support
//VTK::Picking::Dec

// Depth Peeling Support
//VTK::DepthPeeling::Dec

// clipping plane vars
//VTK::Clip::Dec

// the output of this shader
//VTK::Output::Dec

// Apple Bug
//VTK::PrimID::Dec

// handle coincident offsets
//VTK::Coincident::Dec

// Value raster
//VTK::ValuePass::Dec

// La position du point 3D dans le monde, qui nous vient du vertex shader
varying vec4 bivariateVertexPosition;

// Il me semble qu'on a pas besoin de declarer les uniforms si on est sur qu'ils sont declarés coté
// c++ avant la compilation du shader. Pas entierement sur de ca.
uniform float bivariateParameter_k = 1.0;
uniform float bivariateParameter_p = 1.0;
uniform float currentTime = 1.0;

// surface with edges
//VTK::Edges::Dec

void main()
{
  // VC position of this fragment. This should not branch/return/discard.
  //VTK::PositionVC::Impl

  // Place any calls that require uniform flow (e.g. dFdx) here.
  //VTK::UniformFlow::Impl

  // Set gl_FragDepth here (gl_FragCoord.z by default)
  //VTK::Depth::Impl

  // Early depth peeling abort:
  //VTK::DepthPeeling::PreColor

  // Apple Bug
  //VTK::PrimID::Impl

  //VTK::Clip::Impl

  //VTK::ValuePass::Impl

  //VTK::Color::Impl

  //VTK::Edges::Impl

  // Generate the normal if we are not passed in one
  //VTK::Normal::Impl

  //VTK::Light::Impl

  //VTK::TCoord::Impl

  if (gl_FragData[0].a <= 0.0)
  {
    discard;
  }

  //VTK::DepthPeeling::Impl

  //VTK::Picking::Impl

  // handle coincident offsets
  //VTK::Coincident::Impl
}
