/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkMultiDimensionalImplicitBackend.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef vtkMultiDimensionalImplicitBackend_h
#define vtkMultiDimensionalImplicitBackend_h

#include "vtkCommonImplicitArraysModule.h" // For export macro
#include "vtkSmartPointer.h" // For vtkSmartPointer

#include <algorithm> // For std::swap
#include <vector> // For std::vector

/**
 * \struct vtkMultiDimensionalImplicitBackend
 * \brief A utility structure serving as a backend for multi-dimensional implicit arrays
 *
 * TODO
 */

VTK_ABI_NAMESPACE_BEGIN
template <typename ArrayType>
struct vtkMultiDimensionalImplicitBackend final
{
  using ValueType = typename ArrayType::ValueType;

  /**
   * TODO
   */
  vtkMultiDimensionalImplicitBackend(std::vector<vtkSmartPointer<ArrayType>> arrays)
  {
    std::swap(this->Arrays, arrays);
  }

  /**
   * Set the index to fix the "first" dimension of the 3D array.
   */
  void SetIndex(int idx)
  {
    this->Index = idx;
  }

  /**
   * The main call method for the backend
   */
  ValueType operator()(int idx) const
  {
    return this->Arrays[this->Index]->GetValue(idx);
  }

  /**
   * Used to populate GetTypedTuple on this implicit array
   */
  void mapTuple(int tupleidx, ValueType* tuple) const
  {
    return this->Arrays[this->Index]->GetTypedTuple(tupleidx, tuple);
  }

  /**
   * Used to populate GetTypedComponent on this implicit array
   */
  ValueType mapComponent(vtkIdType tupleIdx, int compIdx) const
  {
    return this->Arrays[this->Index]->GetTypedComponent(tupleIdx, compIdx);
  }

  std::vector<vtkSmartPointer<ArrayType>> Arrays;
  vtkIdType Index = 0;
};
VTK_ABI_NAMESPACE_END

#endif // vtkMultiDimensionalImplicitBackend_h
