/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkMultiDimensionalArray.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef vtkMultiDimensionalArray_h
#define vtkMultiDimensionalArray_h

#ifdef VTK_MULTIDIMENSIONAL_ARRAY_INSTANTIATING
#define VTK_IMPLICIT_VALUERANGE_INSTANTIATING
#include "vtkDataArrayPrivate.txx"
#endif

#include "vtkAOSDataArrayTemplate.h"
#include "vtkCommonImplicitArraysModule.h" // For export macro
#include "vtkImplicitArray.h" // For vtkImplicitArray
#include "vtkMultiDimensionalImplicitBackend.h" // For the array backend

#ifdef VTK_MULTIDIMENSIONAL_ARRAY_INSTANTIATING
#undef VTK_IMPLICIT_VALUERANGE_INSTANTIATING
#endif

/**
 * \var vtkMultiDimensionalArray
 * \brief A utility alias for multidimensional implicit arrays
 *
 * In order to be usefully included in the dispatchers, these arrays need to be instantiated at the
 * vtk library compile time.
 *
 * @sa
 * vtkImplicitArray vtkMultiDimensionalImplicitBackend
 */

VTK_ABI_NAMESPACE_BEGIN
template <typename T>
using vtkMultiDimensionalArray =
  vtkImplicitArray<vtkMultiDimensionalImplicitBackend<vtkAOSDataArrayTemplate<T>>>;
VTK_ABI_NAMESPACE_END

#endif // vtkMultiDimensionalArray_h

#ifdef VTK_MULTIDIMENSIONAL_ARRAY_INSTANTIATING

#define VTK_INSTANTIATE_MULTIDIMENSIONAL_ARRAY(ValueType)                                                     \
  VTK_ABI_NAMESPACE_BEGIN                                                                                     \
  template class VTKCOMMONIMPLICITARRAYS_EXPORT                                                               \
    vtkImplicitArray<vtkMultiDimensionalImplicitBackend<vtkAOSDataArrayTemplate<ValueType>>>;                 \
  VTK_ABI_NAMESPACE_END                                                                                       \
  namespace vtkDataArrayPrivate                                                                               \
  {                                                                                                           \
  VTK_ABI_NAMESPACE_BEGIN                                                                                     \
  VTK_INSTANTIATE_VALUERANGE_ARRAYTYPE(                                                                       \
    vtkImplicitArray<vtkMultiDimensionalImplicitBackend<vtkAOSDataArrayTemplate<ValueType>>>, double)         \
  VTK_ABI_NAMESPACE_END                                                                                       \
  }
#endif
