/*=========================================================================

  Program:   ParaView
  Module:    $RCSfile$

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkBivariateNoiseRepresentation
 * @brief Representation to visualize bivariate data with noise
 *
 * The vtkBivariateNoiseRepresentation allows to visualize bivariate data with noise.
 * Please see the vtkBivariateNoiseMapper documentation for more information.
 *
 * @sa vtkBivariateNoise:qpper
 */
#ifndef vtkBivariateNoiseRepresentation_h
#define vtkBivariateNoiseRepresentation_h

#include "vtkBivariateRepresentationsModule.h" // for export macro
#include "vtkGeometryRepresentationWithFaces.h"

class VTKBIVARIATEREPRESENTATIONS_EXPORT vtkBivariateNoiseRepresentation
  : public vtkGeometryRepresentationWithFaces
{
public:
  static vtkBivariateNoiseRepresentation* New();
  vtkTypeMacro(vtkBivariateNoiseRepresentation, vtkGeometryRepresentationWithFaces);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * Set the second array used to generate the curl noise.
   */
  void SetSecondArray(int, int, int, int, const char* name);

  ///@{
  /**
   * Noise parameters.
   * Forwarded to the mapper.
   */
  void SetFrequencyModifier(double fMod);
  void SetAmplitudeModifier(double aMod);
  ///@}

protected:
  vtkBivariateNoiseRepresentation();
  ~vtkBivariateNoiseRepresentation() override;

private:
  vtkBivariateNoiseRepresentation(const vtkBivariateNoiseRepresentation&) = delete;
  void operator=(const vtkBivariateNoiseRepresentation&) = delete;
};

#endif
