/*=========================================================================

  Program:   ParaView
  Module:    $RCSfile$

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkBivariateNoiseRepresentation.h"

#include "vtkBivariateNoiseMapper.h"
#include "vtkObjectFactory.h"

vtkStandardNewMacro(vtkBivariateNoiseRepresentation);
//----------------------------------------------------------------------------
vtkBivariateNoiseRepresentation::vtkBivariateNoiseRepresentation()
{
  // Replace the mappers created by the superclass.
  this->Mapper->Delete();
  this->LODMapper->Delete();

  this->Mapper = vtkBivariateNoiseMapper::New();
  this->LODMapper = vtkBivariateNoiseMapper::New();

  // Since we replaced the mappers, we need to call SetupDefaults() to ensure
  // the pipelines are setup correctly.
  this->SetupDefaults();
}

//----------------------------------------------------------------------------
vtkBivariateNoiseRepresentation::~vtkBivariateNoiseRepresentation() = default;

//----------------------------------------------------------------------------
void vtkBivariateNoiseRepresentation::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

//----------------------------------------------------------------------------
void vtkBivariateNoiseRepresentation::SetSecondArray(
  int idx, int port, int connection, int fieldAssociation, const char* name)
{
  this->Mapper->SetInputArrayToProcess(idx, port, connection, fieldAssociation, name);
  this->LODMapper->SetInputArrayToProcess(idx, port, connection, fieldAssociation, name);
}

//----------------------------------------------------------------------------
void vtkBivariateNoiseRepresentation::SetFrequencyModifier(double fMod)
{
  vtkBivariateNoiseMapper::SafeDownCast(this->Mapper)->SetFrequencyModifier(fMod);
  vtkBivariateNoiseMapper::SafeDownCast(this->LODMapper)->SetFrequencyModifier(fMod);
}

//----------------------------------------------------------------------------
void vtkBivariateNoiseRepresentation::SetAmplitudeModifier(double aMod)
{
  vtkBivariateNoiseMapper::SafeDownCast(this->Mapper)->SetAmplitudeModifier(aMod);
  vtkBivariateNoiseMapper::SafeDownCast(this->LODMapper)->SetAmplitudeModifier(aMod);
}
