/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySurfaceAttributes
//
// Purpose: 
//   Attributes for the surface plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SurfaceAttributes.
//
struct SurfaceAttributesObject
{
    PyObject_HEAD
    SurfaceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSurfaceAttributes(int);

std::string
PySurfaceAttributes_ToString(const SurfaceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSurfaceFlag())
        SNPRINTF(tmpStr, 1000, "%ssurfaceFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssurfaceFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetWireframeFlag())
        SNPRINTF(tmpStr, 1000, "%swireframeFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%swireframeFlag = 0\n", prefix);
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case SurfaceAttributes::OriginalData:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case SurfaceAttributes::CurrentPlot:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetColorByZFlag())
        SNPRINTF(tmpStr, 1000, "%scolorByZFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scolorByZFlag = 0\n", prefix);
    str += tmpStr;
    const char *scaling_names = "Linear, Log, Skew";
    switch (atts->GetScaling())
    {
      case SurfaceAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case SurfaceAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case SurfaceAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sSkew  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *surfaceColor = atts->GetSurfaceColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssurfaceColor = (%d, %d, %d, %d)\n", prefix, int(surfaceColor[0]), int(surfaceColor[1]), int(surfaceColor[2]), int(surfaceColor[3]));
    str += tmpStr;
    const unsigned char *wireframeColor = atts->GetWireframeColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%swireframeColor = (%d, %d, %d, %d)\n", prefix, int(wireframeColor[0]), int(wireframeColor[1]), int(wireframeColor[2]), int(wireframeColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sskewFactor = %g\n", prefix, atts->GetSkewFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetSurfaceFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the surfaceFlag in the object.
    obj->data->SetSurfaceFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetSurfaceFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSurfaceFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetWireframeFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframeFlag in the object.
    obj->data->SetWireframeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetWireframeFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(SurfaceAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetColorByZFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByZFlag in the object.
    obj->data->SetColorByZFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetColorByZFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByZFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetScaling(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(SurfaceAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetScaling(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetSurfaceColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the surfaceColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSurfaceColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetSurfaceColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the surfaceColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *surfaceColor = obj->data->GetSurfaceColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(surfaceColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(surfaceColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(surfaceColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(surfaceColor[3])));
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetWireframeColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the wireframeColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetWireframeColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetWireframeColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wireframeColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *wireframeColor = obj->data->GetWireframeColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(wireframeColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(wireframeColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(wireframeColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(wireframeColor[3])));
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetMin(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetMin(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetMax(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetMax(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
SurfaceAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}



PyMethodDef PySurfaceAttributes_methods[SURFACEATTRIBUTES_NMETH] = {
    {"Notify", SurfaceAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", SurfaceAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", SurfaceAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", SurfaceAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", SurfaceAttributes_GetLightingFlag, METH_VARARGS},
    {"SetSurfaceFlag", SurfaceAttributes_SetSurfaceFlag, METH_VARARGS},
    {"GetSurfaceFlag", SurfaceAttributes_GetSurfaceFlag, METH_VARARGS},
    {"SetWireframeFlag", SurfaceAttributes_SetWireframeFlag, METH_VARARGS},
    {"GetWireframeFlag", SurfaceAttributes_GetWireframeFlag, METH_VARARGS},
    {"SetLimitsMode", SurfaceAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", SurfaceAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMinFlag", SurfaceAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", SurfaceAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", SurfaceAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", SurfaceAttributes_GetMaxFlag, METH_VARARGS},
    {"SetColorByZFlag", SurfaceAttributes_SetColorByZFlag, METH_VARARGS},
    {"GetColorByZFlag", SurfaceAttributes_GetColorByZFlag, METH_VARARGS},
    {"SetScaling", SurfaceAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", SurfaceAttributes_GetScaling, METH_VARARGS},
    {"SetLineWidth", SurfaceAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", SurfaceAttributes_GetLineWidth, METH_VARARGS},
    {"SetSurfaceColor", SurfaceAttributes_SetSurfaceColor, METH_VARARGS},
    {"GetSurfaceColor", SurfaceAttributes_GetSurfaceColor, METH_VARARGS},
    {"SetWireframeColor", SurfaceAttributes_SetWireframeColor, METH_VARARGS},
    {"GetWireframeColor", SurfaceAttributes_GetWireframeColor, METH_VARARGS},
    {"SetSkewFactor", SurfaceAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", SurfaceAttributes_GetSkewFactor, METH_VARARGS},
    {"SetMin", SurfaceAttributes_SetMin, METH_VARARGS},
    {"GetMin", SurfaceAttributes_GetMin, METH_VARARGS},
    {"SetMax", SurfaceAttributes_SetMax, METH_VARARGS},
    {"GetMax", SurfaceAttributes_GetMax, METH_VARARGS},
    {"SetColorTableName", SurfaceAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", SurfaceAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", SurfaceAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", SurfaceAttributes_GetInvertColorTable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SurfaceAttributes_dealloc(PyObject *v)
{
   SurfaceAttributesObject *obj = (SurfaceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    SurfaceAttributes *a = ((SurfaceAttributesObject *)v)->data;
    SurfaceAttributes *b = ((SurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return SurfaceAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return SurfaceAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "surfaceFlag") == 0)
        return SurfaceAttributes_GetSurfaceFlag(self, NULL);
    if(strcmp(name, "wireframeFlag") == 0)
        return SurfaceAttributes_GetWireframeFlag(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return SurfaceAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::CurrentPlot));

    if(strcmp(name, "minFlag") == 0)
        return SurfaceAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return SurfaceAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "colorByZFlag") == 0)
        return SurfaceAttributes_GetColorByZFlag(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return SurfaceAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Skew));

    if(strcmp(name, "lineWidth") == 0)
        return SurfaceAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "surfaceColor") == 0)
        return SurfaceAttributes_GetSurfaceColor(self, NULL);
    if(strcmp(name, "wireframeColor") == 0)
        return SurfaceAttributes_GetWireframeColor(self, NULL);
    if(strcmp(name, "skewFactor") == 0)
        return SurfaceAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "min") == 0)
        return SurfaceAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return SurfaceAttributes_GetMax(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return SurfaceAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return SurfaceAttributes_GetInvertColorTable(self, NULL);

    // Try and handle legacy fields

    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid Surface "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PySurfaceAttributes_methods, self, name);
}

int
PySurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = SurfaceAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = SurfaceAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "surfaceFlag") == 0)
        obj = SurfaceAttributes_SetSurfaceFlag(self, tuple);
    else if(strcmp(name, "wireframeFlag") == 0)
        obj = SurfaceAttributes_SetWireframeFlag(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = SurfaceAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = SurfaceAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = SurfaceAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "colorByZFlag") == 0)
        obj = SurfaceAttributes_SetColorByZFlag(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = SurfaceAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = SurfaceAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "surfaceColor") == 0)
        obj = SurfaceAttributes_SetSurfaceColor(self, tuple);
    else if(strcmp(name, "wireframeColor") == 0)
        obj = SurfaceAttributes_SetWireframeColor(self, tuple);
    else if(strcmp(name, "skewFactor") == 0)
        obj = SurfaceAttributes_SetSkewFactor(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = SurfaceAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = SurfaceAttributes_SetMax(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = SurfaceAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = SurfaceAttributes_SetInvertColorTable(self, tuple);

    // Try and handle legacy fields
    if(obj == NULL)
    {
        if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)v;
    fprintf(fp, "%s", PySurfaceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SurfaceAttributes_str(PyObject *v)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)v;
    return PyString_FromString(PySurfaceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SurfaceAttributes_Purpose = "Attributes for the surface plot";
#else
static char *SurfaceAttributes_Purpose = "Attributes for the surface plot";
#endif

//
// The type description structure
//
static PyTypeObject SurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SurfaceAttributes",                    // tp_name
    sizeof(SurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)SurfaceAttributes_print,     // tp_print
    (getattrfunc)PySurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)PySurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)SurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SurfaceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SurfaceAttributes *defaultAtts = 0;
static SurfaceAttributes *currentAtts = 0;

static PyObject *
NewSurfaceAttributes(int useCurrent)
{
    SurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceAttributesObject, &SurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SurfaceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SurfaceAttributes(*defaultAtts);
    else
        newObject->data = new SurfaceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSurfaceAttributes(const SurfaceAttributes *attr)
{
    SurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceAttributesObject, &SurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SurfaceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SurfaceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSurfaceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SurfaceAttributesMethods[] = {
    {"SurfaceAttributes", SurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SurfaceAttributesObserver = 0;

std::string
PySurfaceAttributes_GetLogString()
{
    std::string s("SurfaceAtts = SurfaceAttributes()\n");
    if(currentAtts != 0)
        s += PySurfaceAttributes_ToString(currentAtts, "SurfaceAtts.");
    return s;
}

static void
PySurfaceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SurfaceAtts = SurfaceAttributes()\n");
        s += PySurfaceAttributes_ToString(currentAtts, "SurfaceAtts.");
        cb(s);
    }
}

void
PySurfaceAttributes_StartUp(SurfaceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SurfaceAttributesObserver == 0)
    {
        SurfaceAttributesObserver = new ObserverToCallback(subj,
            PySurfaceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SurfaceAttributesObserver;
    SurfaceAttributesObserver = 0;
}

PyMethodDef *
PySurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SurfaceAttributesMethods;
}

bool
PySurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SurfaceAttributesType);
}

SurfaceAttributes *
PySurfaceAttributes_FromPyObject(PyObject *obj)
{
    SurfaceAttributesObject *obj2 = (SurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySurfaceAttributes_New()
{
    return NewSurfaceAttributes(0);
}

PyObject *
PySurfaceAttributes_Wrap(const SurfaceAttributes *attr)
{
    return WrapSurfaceAttributes(attr);
}

void
PySurfaceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SurfaceAttributesObject *obj2 = (SurfaceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySurfaceAttributes_SetDefaults(const SurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SurfaceAttributes(*atts);
}

