/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: SpreadsheetViewerPluginInfo.C
// ************************************************************************* //

#include <SpreadsheetPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY_EV(Spreadsheet,Viewer)


// ****************************************************************************
//  Method: SpreadsheetViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Spreadsheet.xpm>
const char **
SpreadsheetViewerPluginInfo::XPMIconData() const
{
    return Spreadsheet_xpm;
}
// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayCreate
//
// Purpose: 
//   Creates an alternate display that will display data for the Spreadsheet
//   plot.
//
// Arguments:
//   plot : Pointer to the ViewerPlot that will own the alternate display.
//
// Returns:    A pointer to the alternate display.
//
// Note:       We refer to the alternate display using void* so it can be
//             whatever type of display that is most appropriate Qt, X, ...
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:53:23 PDT 2007
//
// Modifications:
//   Brad Whitlock, Mon Aug 11 16:24:41 PDT 2008
//   Removed name argument from SpreadsheetViewer constructor.
//
// ****************************************************************************
#include <SpreadsheetViewer.h>
#include <avtCallback.h>
void *
SpreadsheetViewerPluginInfo::AlternateDisplayCreate(ViewerPlot *plot)
{
    void *dpy = 0;

    if(!avtCallback::GetNowinMode())
    {
        // We're not in nowin mode so create the spreadsheet viewer.
        SpreadsheetViewer *win = new SpreadsheetViewer(plot, 0);
        dpy = (void *)win;
    }

    return dpy;
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayDestroy
//
// Purpose: 
//   This method is called when the alternate display must be destroyed.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayDestroy(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        delete v;
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayClear
//
// Purpose: 
//   This method is called when the alternate display must be cleared of data.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayClear(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->clear();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayHide
//
// Purpose: 
//   This method is called when the alternate display must be hidden.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayHide(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->hide();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayShow
//
// Purpose: 
//   This method is called when the alternate display must be shown.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayShow(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        if(v->isMinimized())
            v->showNormal();
        else
            v->show();
        v->raise();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayIconify
//
// Purpose: 
//   This method is called when the alternate display must be iconified.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayIconify(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->showMinimized();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayDeIconify
//
// Purpose: 
//   This method is called when the alternate display must be de-iconified.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void 
SpreadsheetViewerPluginInfo::AlternateDisplayDeIconify(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->showNormal();
    }
}


