/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: SpreadsheetViewerEnginePluginInfo.C
// ************************************************************************* //

#include <SpreadsheetPluginInfo.h>
#include <avtSpreadsheetPlot.h>
#include <SpreadsheetAttributes.h>

//
// Storage for static data elements.
//
SpreadsheetAttributes *SpreadsheetViewerEnginePluginInfo::clientAtts = NULL;
SpreadsheetAttributes *SpreadsheetViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SpreadsheetViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SpreadsheetViewerEnginePluginInfo::InitializeGlobalObjects()
{
    SpreadsheetViewerEnginePluginInfo::clientAtts  = new SpreadsheetAttributes;
    SpreadsheetViewerEnginePluginInfo::defaultAtts = new SpreadsheetAttributes;
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SpreadsheetViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SpreadsheetViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SpreadsheetViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SpreadsheetAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SpreadsheetViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SpreadsheetAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
SpreadsheetViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtSpreadsheetPlot;
}

bool
SpreadsheetViewerEnginePluginInfo::ProvidesLegend() const
{
    return false;
}

bool
SpreadsheetViewerEnginePluginInfo::Permits2DViewScaling() const
{
    return false;
}

// ****************************************************************************
// Method: SpreadsheetViewerEnginePluginInfo::InitializePlotAtts
//
// Purpose: 
//   Initializes the plot attributes.
//
// Arguments:
//   atts    : The plot attributes to check.
//   md      : The plot metadata.
//   varName : The plot variable.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 11:36:13 PDT 2007
//
// Modifications:
//   
// ****************************************************************************
void
SpreadsheetViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    *(SpreadsheetAttributes*)atts = *defaultAtts;

    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
// Method: SpreadsheetViewerEnginePluginInfo::ReInitializePlotAtts
//
// Purpose: 
//   Makes sure that the subset name in the plot attributes is valid.
//
// Arguments:
//   atts    : The plot attributes to check.
//   md      : The plot metadata.
//   varName : The plot variable.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 11:36:13 PDT 2007
//
// Modifications:
//   
// ****************************************************************************
void
SpreadsheetViewerEnginePluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
// Method: SpreadsheetViewerEnginePluginInfo::ResetPlotAtts
//
// Purpose: 
//   Resets the plot attributes.
//
// Arguments:
//   atts    : The plot attributes to reset.
//   md      : The plot metadata.
//   varName : The plot variable.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 11:36:13 PDT 2007
//
// Modifications:
//   
// ****************************************************************************

void
SpreadsheetViewerEnginePluginInfo::ResetPlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)

{
    *(SpreadsheetAttributes*)atts = *defaultAtts;

    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: SpreadsheetViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SpreadsheetViewerEnginePluginInfo::GetMenuName() const
{
    return "Spreadsheet";
}

// ****************************************************************************
// Method: SpreadsheetViewerEnginePluginInfo::PrivateSetPlotAtts
//
// Purpose: 
//   Makes sure that the subset name in the plot attributes is valid.
//
// Arguments:
//   atts    : The plot attributes to check.
//   md      : The plot metadata.
//   varName : The plot variable.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 11:36:13 PDT 2007
//
// Modifications:
//   Hank Childs, Mon Dec 14 16:04:01 PST 2009
//   Add support for new SIL interface.
//
//   Brad Whitlock, Thu Jun  3 14:39:43 PDT 2010
//   I fixed a bug with the SIL changes.
//
// ****************************************************************************
#include <avtSILRestriction.h>
#include <avtPlotMetaData.h>

void
SpreadsheetViewerEnginePluginInfo::PrivateSetPlotAtts(AttributeSubject *atts, 
    const avtPlotMetaData &plot)
{
    // Search for a SIL_DOMAIN category under the current silTopSet and add
    // sets that are used.
    SpreadsheetAttributes *sAtts = (SpreadsheetAttributes *)atts;
    bool validName = false;
    bool firstNameSet = false;
    std::string firstName;
    int nSets = 1;
    avtSILRestriction_p silr = plot.GetSILRestriction();
    avtSILSet_p current = silr->GetSILSet(silr->GetTopSet());
    const std::vector<int> &mapsOut = current->GetMapsOut();
    for(size_t j = 0; j < mapsOut.size() && !validName; ++j)
    {
        int cIndex = mapsOut[j];
        avtSILCollection_p collection = silr->GetSILCollection(cIndex);
        if(*collection != NULL && collection->GetRole() == SIL_DOMAIN) 
        {
            nSets = collection->GetNumberOfSubsets(); 
            for(int si = 0; si < nSets && !validName; ++si)
            {
                if(!firstNameSet)
                {
                    firstName = silr->GetSILSet(collection->GetSubset(si))->GetName();
                    firstNameSet = true;
                }
                validName = (silr->GetSILSet(collection->GetSubset(si))->GetName() == 
                             sAtts->GetSubsetName());
            }
            break;
        }
    }

    // If the subset name is not valid then override it. Set it in the
    // default attributes so the GUI window does not get too confused when
    // the default attributes get sent to the client as when a plot of another
    // type is selected.
    if(!validName)
    {
        if(nSets > 1)
        {
            if(firstNameSet)
            {
                sAtts->SetSubsetName(firstName);
                defaultAtts->SetSubsetName(firstName);
            }
        }
        else
        {
            sAtts->SetSubsetName("Whole");
            defaultAtts->SetSubsetName("Whole");
        }
    }
}

