/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPseudocolorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <GlyphTypes.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPseudocolorAttributes
//
// Purpose: 
//   Attributes for the pseudocolor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PseudocolorAttributes.
//
struct PseudocolorAttributesObject
{
    PyObject_HEAD
    PseudocolorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPseudocolorAttributes(int);

std::string
PyPseudocolorAttributes_ToString(const PseudocolorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *scaling_names = "Linear, Log, Skew";
    switch (atts->GetScaling())
    {
      case PseudocolorAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sSkew  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sskewFactor = %g\n", prefix, atts->GetSkewFactor());
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case PseudocolorAttributes::OriginalData:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::CurrentPlot:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    const char *centering_names = "Natural, Nodal, Zonal";
    switch (atts->GetCentering())
    {
      case PseudocolorAttributes::Natural:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNatural  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Nodal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNodal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Zonal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sZonal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    const char *opacityType_names = "ColorTable, FullyOpaque, Constant, Ramp, VariableRange";
    switch (atts->GetOpacityType())
    {
      case PseudocolorAttributes::ColorTable:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sColorTable  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::FullyOpaque:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sFullyOpaque  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Constant:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sConstant  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Ramp:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sRamp  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::VariableRange:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sVariableRange  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sopacityVariable = \"%s\"\n", prefix, atts->GetOpacityVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMin = %g\n", prefix, atts->GetOpacityVarMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMax = %g\n", prefix, atts->GetOpacityVarMax());
    str += tmpStr;
    if(atts->GetOpacityVarMinFlag())
        SNPRINTF(tmpStr, 1000, "%sopacityVarMinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sopacityVarMinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOpacityVarMaxFlag())
        SNPRINTF(tmpStr, 1000, "%sopacityVarMaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sopacityVarMaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
        "SphereGeometry, Point, Sphere";
    switch (atts->GetPointType())
    {
      case Box:
          SNPRINTF(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Axis:
          SNPRINTF(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Icosahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Octahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sOctahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Tetrahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sTetrahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case SphereGeometry:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphereGeometry  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Point:
          SNPRINTF(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case Sphere:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizeVar = \"%s\"\n", prefix, atts->GetPointSizeVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    const char *lineType_names = "Line, Tube, Ribbon";
    switch (atts->GetLineType())
    {
      case PseudocolorAttributes::Line:
          SNPRINTF(tmpStr, 1000, "%slineType = %sLine  # %s\n", prefix, prefix, lineType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Tube:
          SNPRINTF(tmpStr, 1000, "%slineType = %sTube  # %s\n", prefix, prefix, lineType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Ribbon:
          SNPRINTF(tmpStr, 1000, "%slineType = %sRibbon  # %s\n", prefix, prefix, lineType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeResolution = %d\n", prefix, atts->GetTubeResolution());
    str += tmpStr;
    const char *tubeRadiusSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetTubeRadiusSizeType())
    {
      case PseudocolorAttributes::Absolute:
          SNPRINTF(tmpStr, 1000, "%stubeRadiusSizeType = %sAbsolute  # %s\n", prefix, prefix, tubeRadiusSizeType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::FractionOfBBox:
          SNPRINTF(tmpStr, 1000, "%stubeRadiusSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, tubeRadiusSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%stubeRadiusAbsolute = %g\n", prefix, atts->GetTubeRadiusAbsolute());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeRadiusBBox = %g\n", prefix, atts->GetTubeRadiusBBox());
    str += tmpStr;
    if(atts->GetTubeRadiusVarEnabled())
        SNPRINTF(tmpStr, 1000, "%stubeRadiusVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stubeRadiusVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeRadiusVar = \"%s\"\n", prefix, atts->GetTubeRadiusVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeRadiusVarRatio = %g\n", prefix, atts->GetTubeRadiusVarRatio());
    str += tmpStr;
    const char *tailStyle_names = "None, Spheres, Cones";
    switch (atts->GetTailStyle())
    {
      case PseudocolorAttributes::None:
          SNPRINTF(tmpStr, 1000, "%stailStyle = %sNone  # %s\n", prefix, prefix, tailStyle_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Spheres:
          SNPRINTF(tmpStr, 1000, "%stailStyle = %sSpheres  # %s\n", prefix, prefix, tailStyle_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Cones:
          SNPRINTF(tmpStr, 1000, "%stailStyle = %sCones  # %s\n", prefix, prefix, tailStyle_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *headStyle_names = "None, Spheres, Cones";
    switch (atts->GetHeadStyle())
    {
      case PseudocolorAttributes::None:
          SNPRINTF(tmpStr, 1000, "%sheadStyle = %sNone  # %s\n", prefix, prefix, headStyle_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Spheres:
          SNPRINTF(tmpStr, 1000, "%sheadStyle = %sSpheres  # %s\n", prefix, prefix, headStyle_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Cones:
          SNPRINTF(tmpStr, 1000, "%sheadStyle = %sCones  # %s\n", prefix, prefix, headStyle_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *endPointRadiusSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetEndPointRadiusSizeType())
    {
      case PseudocolorAttributes::Absolute:
          SNPRINTF(tmpStr, 1000, "%sendPointRadiusSizeType = %sAbsolute  # %s\n", prefix, prefix, endPointRadiusSizeType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::FractionOfBBox:
          SNPRINTF(tmpStr, 1000, "%sendPointRadiusSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, endPointRadiusSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sendPointRadiusAbsolute = %g\n", prefix, atts->GetEndPointRadiusAbsolute());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendPointRadiusBBox = %g\n", prefix, atts->GetEndPointRadiusBBox());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendPointResolution = %d\n", prefix, atts->GetEndPointResolution());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendPointRatio = %g\n", prefix, atts->GetEndPointRatio());
    str += tmpStr;
    if(atts->GetEndPointRadiusVarEnabled())
        SNPRINTF(tmpStr, 1000, "%sendPointRadiusVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sendPointRadiusVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendPointRadiusVar = \"%s\"\n", prefix, atts->GetEndPointRadiusVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendPointRadiusVarRatio = %g\n", prefix, atts->GetEndPointRadiusVarRatio());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srenderSurfaces = %d\n", prefix, atts->GetRenderSurfaces());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srenderWireframe = %d\n", prefix, atts->GetRenderWireframe());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srenderPoints = %d\n", prefix, atts->GetRenderPoints());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    const unsigned char *wireframeColor = atts->GetWireframeColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%swireframeColor = (%d, %d, %d, %d)\n", prefix, int(wireframeColor[0]), int(wireframeColor[1]), int(wireframeColor[2]), int(wireframeColor[3]));
    str += tmpStr;
    const unsigned char *pointColor = atts->GetPointColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%spointColor = (%d, %d, %d, %d)\n", prefix, int(pointColor[0]), int(pointColor[1]), int(pointColor[2]), int(pointColor[3]));
    str += tmpStr;
    return str;
}

static PyObject *
PseudocolorAttributes_Notify(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_SetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(PseudocolorAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(PseudocolorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centering in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCentering(PseudocolorAttributes::Centering(ival));
    else
    {
        fprintf(stderr, "An invalid centering value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, Nodal, Zonal.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCentering()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetOpacityType(PseudocolorAttributes::OpacityType(ival));
    else
    {
        fprintf(stderr, "An invalid opacityType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "ColorTable, FullyOpaque, Constant, Ramp, VariableRange"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityVariable(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the opacityVariable in the object.
    obj->data->SetOpacityVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityVariable(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOpacityVariable().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityVarMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacityVarMin in the object.
    obj->data->SetOpacityVarMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityVarMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacityVarMin());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityVarMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacityVarMax in the object.
    obj->data->SetOpacityVarMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityVarMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacityVarMax());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityVarMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityVarMinFlag in the object.
    obj->data->SetOpacityVarMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityVarMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOpacityVarMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityVarMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityVarMaxFlag in the object.
    obj->data->SetOpacityVarMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityVarMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOpacityVarMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if(ival >= 0 && ival < 8)
    {
        obj->data->SetPointType(GlyphType(ival));
    }
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Octahedron, Tetrahedron, "
                        "SphereGeometry, Point, Sphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLineType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetLineType(PseudocolorAttributes::LineType(ival));
    else
    {
        fprintf(stderr, "An invalid lineType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Line, Tube, Ribbon.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLineType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeResolution(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tubeResolution in the object.
    obj->data->SetTubeResolution((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeResolution(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTubeResolution()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusSizeType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tubeRadiusSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTubeRadiusSizeType(PseudocolorAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid tubeRadiusSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusSizeType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTubeRadiusSizeType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusAbsolute(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tubeRadiusAbsolute in the object.
    obj->data->SetTubeRadiusAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusAbsolute(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTubeRadiusAbsolute());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusBBox(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tubeRadiusBBox in the object.
    obj->data->SetTubeRadiusBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusBBox(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTubeRadiusBBox());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tubeRadiusVarEnabled in the object.
    obj->data->SetTubeRadiusVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTubeRadiusVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the tubeRadiusVar in the object.
    obj->data->SetTubeRadiusVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTubeRadiusVar().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTubeRadiusVarRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tubeRadiusVarRatio in the object.
    obj->data->SetTubeRadiusVarRatio(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTubeRadiusVarRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTubeRadiusVarRatio());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetTailStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tailStyle in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTailStyle(PseudocolorAttributes::EndPointStyle(ival));
    else
    {
        fprintf(stderr, "An invalid tailStyle value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Spheres, Cones.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetTailStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTailStyle()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetHeadStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the headStyle in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetHeadStyle(PseudocolorAttributes::EndPointStyle(ival));
    else
    {
        fprintf(stderr, "An invalid headStyle value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Spheres, Cones.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetHeadStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHeadStyle()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusSizeType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endPointRadiusSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetEndPointRadiusSizeType(PseudocolorAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid endPointRadiusSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusSizeType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndPointRadiusSizeType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusAbsolute(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endPointRadiusAbsolute in the object.
    obj->data->SetEndPointRadiusAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusAbsolute(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndPointRadiusAbsolute());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusBBox(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endPointRadiusBBox in the object.
    obj->data->SetEndPointRadiusBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusBBox(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndPointRadiusBBox());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointResolution(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endPointResolution in the object.
    obj->data->SetEndPointResolution((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointResolution(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndPointResolution()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endPointRatio in the object.
    obj->data->SetEndPointRatio(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndPointRatio());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endPointRadiusVarEnabled in the object.
    obj->data->SetEndPointRadiusVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEndPointRadiusVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the endPointRadiusVar in the object.
    obj->data->SetEndPointRadiusVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetEndPointRadiusVar().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetEndPointRadiusVarRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the endPointRadiusVarRatio in the object.
    obj->data->SetEndPointRadiusVarRatio(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetEndPointRadiusVarRatio(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEndPointRadiusVarRatio());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetRenderSurfaces(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the renderSurfaces in the object.
    obj->data->SetRenderSurfaces((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetRenderSurfaces(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRenderSurfaces()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetRenderWireframe(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the renderWireframe in the object.
    obj->data->SetRenderWireframe((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetRenderWireframe(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRenderWireframe()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetRenderPoints(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the renderPoints in the object.
    obj->data->SetRenderPoints((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetRenderPoints(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRenderPoints()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetWireframeColor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the wireframeColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetWireframeColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetWireframeColor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wireframeColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *wireframeColor = obj->data->GetWireframeColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(wireframeColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(wireframeColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(wireframeColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(wireframeColor[3])));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointColor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the pointColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetPointColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointColor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *pointColor = obj->data->GetPointColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(pointColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(pointColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(pointColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(pointColor[3])));
    return retval;
}



PyMethodDef PyPseudocolorAttributes_methods[PSEUDOCOLORATTRIBUTES_NMETH] = {
    {"Notify", PseudocolorAttributes_Notify, METH_VARARGS},
    {"SetScaling", PseudocolorAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", PseudocolorAttributes_GetScaling, METH_VARARGS},
    {"SetSkewFactor", PseudocolorAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", PseudocolorAttributes_GetSkewFactor, METH_VARARGS},
    {"SetLimitsMode", PseudocolorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", PseudocolorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMinFlag", PseudocolorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", PseudocolorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMin", PseudocolorAttributes_SetMin, METH_VARARGS},
    {"GetMin", PseudocolorAttributes_GetMin, METH_VARARGS},
    {"SetMaxFlag", PseudocolorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", PseudocolorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMax", PseudocolorAttributes_SetMax, METH_VARARGS},
    {"GetMax", PseudocolorAttributes_GetMax, METH_VARARGS},
    {"SetCentering", PseudocolorAttributes_SetCentering, METH_VARARGS},
    {"GetCentering", PseudocolorAttributes_GetCentering, METH_VARARGS},
    {"SetColorTableName", PseudocolorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", PseudocolorAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", PseudocolorAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", PseudocolorAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetOpacityType", PseudocolorAttributes_SetOpacityType, METH_VARARGS},
    {"GetOpacityType", PseudocolorAttributes_GetOpacityType, METH_VARARGS},
    {"SetOpacityVariable", PseudocolorAttributes_SetOpacityVariable, METH_VARARGS},
    {"GetOpacityVariable", PseudocolorAttributes_GetOpacityVariable, METH_VARARGS},
    {"SetOpacity", PseudocolorAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", PseudocolorAttributes_GetOpacity, METH_VARARGS},
    {"SetOpacityVarMin", PseudocolorAttributes_SetOpacityVarMin, METH_VARARGS},
    {"GetOpacityVarMin", PseudocolorAttributes_GetOpacityVarMin, METH_VARARGS},
    {"SetOpacityVarMax", PseudocolorAttributes_SetOpacityVarMax, METH_VARARGS},
    {"GetOpacityVarMax", PseudocolorAttributes_GetOpacityVarMax, METH_VARARGS},
    {"SetOpacityVarMinFlag", PseudocolorAttributes_SetOpacityVarMinFlag, METH_VARARGS},
    {"GetOpacityVarMinFlag", PseudocolorAttributes_GetOpacityVarMinFlag, METH_VARARGS},
    {"SetOpacityVarMaxFlag", PseudocolorAttributes_SetOpacityVarMaxFlag, METH_VARARGS},
    {"GetOpacityVarMaxFlag", PseudocolorAttributes_GetOpacityVarMaxFlag, METH_VARARGS},
    {"SetPointSize", PseudocolorAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", PseudocolorAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", PseudocolorAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", PseudocolorAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", PseudocolorAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", PseudocolorAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", PseudocolorAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", PseudocolorAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointSizePixels", PseudocolorAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", PseudocolorAttributes_GetPointSizePixels, METH_VARARGS},
    {"SetLineType", PseudocolorAttributes_SetLineType, METH_VARARGS},
    {"GetLineType", PseudocolorAttributes_GetLineType, METH_VARARGS},
    {"SetLineWidth", PseudocolorAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", PseudocolorAttributes_GetLineWidth, METH_VARARGS},
    {"SetTubeResolution", PseudocolorAttributes_SetTubeResolution, METH_VARARGS},
    {"GetTubeResolution", PseudocolorAttributes_GetTubeResolution, METH_VARARGS},
    {"SetTubeRadiusSizeType", PseudocolorAttributes_SetTubeRadiusSizeType, METH_VARARGS},
    {"GetTubeRadiusSizeType", PseudocolorAttributes_GetTubeRadiusSizeType, METH_VARARGS},
    {"SetTubeRadiusAbsolute", PseudocolorAttributes_SetTubeRadiusAbsolute, METH_VARARGS},
    {"GetTubeRadiusAbsolute", PseudocolorAttributes_GetTubeRadiusAbsolute, METH_VARARGS},
    {"SetTubeRadiusBBox", PseudocolorAttributes_SetTubeRadiusBBox, METH_VARARGS},
    {"GetTubeRadiusBBox", PseudocolorAttributes_GetTubeRadiusBBox, METH_VARARGS},
    {"SetTubeRadiusVarEnabled", PseudocolorAttributes_SetTubeRadiusVarEnabled, METH_VARARGS},
    {"GetTubeRadiusVarEnabled", PseudocolorAttributes_GetTubeRadiusVarEnabled, METH_VARARGS},
    {"SetTubeRadiusVar", PseudocolorAttributes_SetTubeRadiusVar, METH_VARARGS},
    {"GetTubeRadiusVar", PseudocolorAttributes_GetTubeRadiusVar, METH_VARARGS},
    {"SetTubeRadiusVarRatio", PseudocolorAttributes_SetTubeRadiusVarRatio, METH_VARARGS},
    {"GetTubeRadiusVarRatio", PseudocolorAttributes_GetTubeRadiusVarRatio, METH_VARARGS},
    {"SetTailStyle", PseudocolorAttributes_SetTailStyle, METH_VARARGS},
    {"GetTailStyle", PseudocolorAttributes_GetTailStyle, METH_VARARGS},
    {"SetHeadStyle", PseudocolorAttributes_SetHeadStyle, METH_VARARGS},
    {"GetHeadStyle", PseudocolorAttributes_GetHeadStyle, METH_VARARGS},
    {"SetEndPointRadiusSizeType", PseudocolorAttributes_SetEndPointRadiusSizeType, METH_VARARGS},
    {"GetEndPointRadiusSizeType", PseudocolorAttributes_GetEndPointRadiusSizeType, METH_VARARGS},
    {"SetEndPointRadiusAbsolute", PseudocolorAttributes_SetEndPointRadiusAbsolute, METH_VARARGS},
    {"GetEndPointRadiusAbsolute", PseudocolorAttributes_GetEndPointRadiusAbsolute, METH_VARARGS},
    {"SetEndPointRadiusBBox", PseudocolorAttributes_SetEndPointRadiusBBox, METH_VARARGS},
    {"GetEndPointRadiusBBox", PseudocolorAttributes_GetEndPointRadiusBBox, METH_VARARGS},
    {"SetEndPointResolution", PseudocolorAttributes_SetEndPointResolution, METH_VARARGS},
    {"GetEndPointResolution", PseudocolorAttributes_GetEndPointResolution, METH_VARARGS},
    {"SetEndPointRatio", PseudocolorAttributes_SetEndPointRatio, METH_VARARGS},
    {"GetEndPointRatio", PseudocolorAttributes_GetEndPointRatio, METH_VARARGS},
    {"SetEndPointRadiusVarEnabled", PseudocolorAttributes_SetEndPointRadiusVarEnabled, METH_VARARGS},
    {"GetEndPointRadiusVarEnabled", PseudocolorAttributes_GetEndPointRadiusVarEnabled, METH_VARARGS},
    {"SetEndPointRadiusVar", PseudocolorAttributes_SetEndPointRadiusVar, METH_VARARGS},
    {"GetEndPointRadiusVar", PseudocolorAttributes_GetEndPointRadiusVar, METH_VARARGS},
    {"SetEndPointRadiusVarRatio", PseudocolorAttributes_SetEndPointRadiusVarRatio, METH_VARARGS},
    {"GetEndPointRadiusVarRatio", PseudocolorAttributes_GetEndPointRadiusVarRatio, METH_VARARGS},
    {"SetRenderSurfaces", PseudocolorAttributes_SetRenderSurfaces, METH_VARARGS},
    {"GetRenderSurfaces", PseudocolorAttributes_GetRenderSurfaces, METH_VARARGS},
    {"SetRenderWireframe", PseudocolorAttributes_SetRenderWireframe, METH_VARARGS},
    {"GetRenderWireframe", PseudocolorAttributes_GetRenderWireframe, METH_VARARGS},
    {"SetRenderPoints", PseudocolorAttributes_SetRenderPoints, METH_VARARGS},
    {"GetRenderPoints", PseudocolorAttributes_GetRenderPoints, METH_VARARGS},
    {"SetSmoothingLevel", PseudocolorAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", PseudocolorAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetLegendFlag", PseudocolorAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", PseudocolorAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", PseudocolorAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", PseudocolorAttributes_GetLightingFlag, METH_VARARGS},
    {"SetWireframeColor", PseudocolorAttributes_SetWireframeColor, METH_VARARGS},
    {"GetWireframeColor", PseudocolorAttributes_GetWireframeColor, METH_VARARGS},
    {"SetPointColor", PseudocolorAttributes_SetPointColor, METH_VARARGS},
    {"GetPointColor", PseudocolorAttributes_GetPointColor, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PseudocolorAttributes_dealloc(PyObject *v)
{
   PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PseudocolorAttributes_compare(PyObject *v, PyObject *w)
{
    PseudocolorAttributes *a = ((PseudocolorAttributesObject *)v)->data;
    PseudocolorAttributes *b = ((PseudocolorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPseudocolorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "scaling") == 0)
        return PseudocolorAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Skew));

    if(strcmp(name, "skewFactor") == 0)
        return PseudocolorAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return PseudocolorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::CurrentPlot));

    if(strcmp(name, "minFlag") == 0)
        return PseudocolorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return PseudocolorAttributes_GetMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return PseudocolorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "max") == 0)
        return PseudocolorAttributes_GetMax(self, NULL);
    if(strcmp(name, "centering") == 0)
        return PseudocolorAttributes_GetCentering(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Natural));
    if(strcmp(name, "Nodal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Nodal));
    if(strcmp(name, "Zonal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Zonal));

    if(strcmp(name, "colorTableName") == 0)
        return PseudocolorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return PseudocolorAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "opacityType") == 0)
        return PseudocolorAttributes_GetOpacityType(self, NULL);
    if(strcmp(name, "ColorTable") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::ColorTable));
    if(strcmp(name, "FullyOpaque") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::FullyOpaque));
    if(strcmp(name, "Constant") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Constant));
    if(strcmp(name, "Ramp") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Ramp));
    if(strcmp(name, "VariableRange") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::VariableRange));

    if(strcmp(name, "opacityVariable") == 0)
        return PseudocolorAttributes_GetOpacityVariable(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return PseudocolorAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "opacityVarMin") == 0)
        return PseudocolorAttributes_GetOpacityVarMin(self, NULL);
    if(strcmp(name, "opacityVarMax") == 0)
        return PseudocolorAttributes_GetOpacityVarMax(self, NULL);
    if(strcmp(name, "opacityVarMinFlag") == 0)
        return PseudocolorAttributes_GetOpacityVarMinFlag(self, NULL);
    if(strcmp(name, "opacityVarMaxFlag") == 0)
        return PseudocolorAttributes_GetOpacityVarMaxFlag(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return PseudocolorAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return PseudocolorAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(Icosahedron));
    if(strcmp(name, "Octahedron") == 0)
        return PyInt_FromLong(long(Octahedron));
    if(strcmp(name, "Tetrahedron") == 0)
        return PyInt_FromLong(long(Tetrahedron));
    if(strcmp(name, "SphereGeometry") == 0)
        return PyInt_FromLong(long(SphereGeometry));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(Sphere));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return PseudocolorAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return PseudocolorAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return PseudocolorAttributes_GetPointSizePixels(self, NULL);
    if(strcmp(name, "lineType") == 0)
        return PseudocolorAttributes_GetLineType(self, NULL);
    if(strcmp(name, "Line") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Line));
    if(strcmp(name, "Tube") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Tube));
    if(strcmp(name, "Ribbon") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Ribbon));

    if(strcmp(name, "lineWidth") == 0)
        return PseudocolorAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "tubeResolution") == 0)
        return PseudocolorAttributes_GetTubeResolution(self, NULL);
    if(strcmp(name, "tubeRadiusSizeType") == 0)
        return PseudocolorAttributes_GetTubeRadiusSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::FractionOfBBox));

    if(strcmp(name, "tubeRadiusAbsolute") == 0)
        return PseudocolorAttributes_GetTubeRadiusAbsolute(self, NULL);
    if(strcmp(name, "tubeRadiusBBox") == 0)
        return PseudocolorAttributes_GetTubeRadiusBBox(self, NULL);
    if(strcmp(name, "tubeRadiusVarEnabled") == 0)
        return PseudocolorAttributes_GetTubeRadiusVarEnabled(self, NULL);
    if(strcmp(name, "tubeRadiusVar") == 0)
        return PseudocolorAttributes_GetTubeRadiusVar(self, NULL);
    if(strcmp(name, "tubeRadiusVarRatio") == 0)
        return PseudocolorAttributes_GetTubeRadiusVarRatio(self, NULL);
    if(strcmp(name, "tailStyle") == 0)
        return PseudocolorAttributes_GetTailStyle(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::None));
    if(strcmp(name, "Spheres") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Spheres));
    if(strcmp(name, "Cones") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Cones));

    if(strcmp(name, "headStyle") == 0)
        return PseudocolorAttributes_GetHeadStyle(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::None));
    if(strcmp(name, "Spheres") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Spheres));
    if(strcmp(name, "Cones") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Cones));

    if(strcmp(name, "endPointRadiusSizeType") == 0)
        return PseudocolorAttributes_GetEndPointRadiusSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::FractionOfBBox));

    if(strcmp(name, "endPointRadiusAbsolute") == 0)
        return PseudocolorAttributes_GetEndPointRadiusAbsolute(self, NULL);
    if(strcmp(name, "endPointRadiusBBox") == 0)
        return PseudocolorAttributes_GetEndPointRadiusBBox(self, NULL);
    if(strcmp(name, "endPointResolution") == 0)
        return PseudocolorAttributes_GetEndPointResolution(self, NULL);
    if(strcmp(name, "endPointRatio") == 0)
        return PseudocolorAttributes_GetEndPointRatio(self, NULL);
    if(strcmp(name, "endPointRadiusVarEnabled") == 0)
        return PseudocolorAttributes_GetEndPointRadiusVarEnabled(self, NULL);
    if(strcmp(name, "endPointRadiusVar") == 0)
        return PseudocolorAttributes_GetEndPointRadiusVar(self, NULL);
    if(strcmp(name, "endPointRadiusVarRatio") == 0)
        return PseudocolorAttributes_GetEndPointRadiusVarRatio(self, NULL);
    if(strcmp(name, "renderSurfaces") == 0)
        return PseudocolorAttributes_GetRenderSurfaces(self, NULL);
    if(strcmp(name, "renderWireframe") == 0)
        return PseudocolorAttributes_GetRenderWireframe(self, NULL);
    if(strcmp(name, "renderPoints") == 0)
        return PseudocolorAttributes_GetRenderPoints(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return PseudocolorAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return PseudocolorAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return PseudocolorAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "wireframeColor") == 0)
        return PseudocolorAttributes_GetWireframeColor(self, NULL);
    if(strcmp(name, "pointColor") == 0)
        return PseudocolorAttributes_GetPointColor(self, NULL);

    // Try and handle legacy fields in PseudocolorAttributes
    if(strcmp(name, "useColorTableOpacity") == 0)
    {
        PseudocolorAttributesObject *meshObj = (PseudocolorAttributesObject *)self;
        bool useCT = meshObj->data->GetOpacityType() == PseudocolorAttributes::ColorTable;
        return PyInt_FromLong(useCT?1L:0L);
    }

    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid Pseudocolor "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyPseudocolorAttributes_methods, self, name);
}

int
PyPseudocolorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "scaling") == 0)
        obj = PseudocolorAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "skewFactor") == 0)
        obj = PseudocolorAttributes_SetSkewFactor(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = PseudocolorAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = PseudocolorAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = PseudocolorAttributes_SetMin(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = PseudocolorAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = PseudocolorAttributes_SetMax(self, tuple);
    else if(strcmp(name, "centering") == 0)
        obj = PseudocolorAttributes_SetCentering(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = PseudocolorAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = PseudocolorAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "opacityType") == 0)
        obj = PseudocolorAttributes_SetOpacityType(self, tuple);
    else if(strcmp(name, "opacityVariable") == 0)
        obj = PseudocolorAttributes_SetOpacityVariable(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = PseudocolorAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "opacityVarMin") == 0)
        obj = PseudocolorAttributes_SetOpacityVarMin(self, tuple);
    else if(strcmp(name, "opacityVarMax") == 0)
        obj = PseudocolorAttributes_SetOpacityVarMax(self, tuple);
    else if(strcmp(name, "opacityVarMinFlag") == 0)
        obj = PseudocolorAttributes_SetOpacityVarMinFlag(self, tuple);
    else if(strcmp(name, "opacityVarMaxFlag") == 0)
        obj = PseudocolorAttributes_SetOpacityVarMaxFlag(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = PseudocolorAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = PseudocolorAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        obj = PseudocolorAttributes_SetPointSizeVarEnabled(self, tuple);
    else if(strcmp(name, "pointSizeVar") == 0)
        obj = PseudocolorAttributes_SetPointSizeVar(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = PseudocolorAttributes_SetPointSizePixels(self, tuple);
    else if(strcmp(name, "lineType") == 0)
        obj = PseudocolorAttributes_SetLineType(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = PseudocolorAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "tubeResolution") == 0)
        obj = PseudocolorAttributes_SetTubeResolution(self, tuple);
    else if(strcmp(name, "tubeRadiusSizeType") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusSizeType(self, tuple);
    else if(strcmp(name, "tubeRadiusAbsolute") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusAbsolute(self, tuple);
    else if(strcmp(name, "tubeRadiusBBox") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusBBox(self, tuple);
    else if(strcmp(name, "tubeRadiusVarEnabled") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusVarEnabled(self, tuple);
    else if(strcmp(name, "tubeRadiusVar") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusVar(self, tuple);
    else if(strcmp(name, "tubeRadiusVarRatio") == 0)
        obj = PseudocolorAttributes_SetTubeRadiusVarRatio(self, tuple);
    else if(strcmp(name, "tailStyle") == 0)
        obj = PseudocolorAttributes_SetTailStyle(self, tuple);
    else if(strcmp(name, "headStyle") == 0)
        obj = PseudocolorAttributes_SetHeadStyle(self, tuple);
    else if(strcmp(name, "endPointRadiusSizeType") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusSizeType(self, tuple);
    else if(strcmp(name, "endPointRadiusAbsolute") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusAbsolute(self, tuple);
    else if(strcmp(name, "endPointRadiusBBox") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusBBox(self, tuple);
    else if(strcmp(name, "endPointResolution") == 0)
        obj = PseudocolorAttributes_SetEndPointResolution(self, tuple);
    else if(strcmp(name, "endPointRatio") == 0)
        obj = PseudocolorAttributes_SetEndPointRatio(self, tuple);
    else if(strcmp(name, "endPointRadiusVarEnabled") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusVarEnabled(self, tuple);
    else if(strcmp(name, "endPointRadiusVar") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusVar(self, tuple);
    else if(strcmp(name, "endPointRadiusVarRatio") == 0)
        obj = PseudocolorAttributes_SetEndPointRadiusVarRatio(self, tuple);
    else if(strcmp(name, "renderSurfaces") == 0)
        obj = PseudocolorAttributes_SetRenderSurfaces(self, tuple);
    else if(strcmp(name, "renderWireframe") == 0)
        obj = PseudocolorAttributes_SetRenderWireframe(self, tuple);
    else if(strcmp(name, "renderPoints") == 0)
        obj = PseudocolorAttributes_SetRenderPoints(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = PseudocolorAttributes_SetSmoothingLevel(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = PseudocolorAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = PseudocolorAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "wireframeColor") == 0)
        obj = PseudocolorAttributes_SetWireframeColor(self, tuple);
    else if(strcmp(name, "pointColor") == 0)
        obj = PseudocolorAttributes_SetPointColor(self, tuple);

    // Try and handle legacy fields in PseudocolorAttributes
    if(obj == NULL)
    {
        PseudocolorAttributesObject *PseudocolorObj = (PseudocolorAttributesObject *)self;
        if(strcmp(name, "useColorTableOpacity") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                PseudocolorObj->data->SetOpacityType(PseudocolorAttributes::Constant);
            else
                PseudocolorObj->data->SetOpacityType(PseudocolorAttributes::ColorTable);

            Py_INCREF(Py_None);
            obj = Py_None;
        }
        if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PseudocolorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
    fprintf(fp, "%s", PyPseudocolorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PseudocolorAttributes_str(PyObject *v)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
    return PyString_FromString(PyPseudocolorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PseudocolorAttributes_Purpose = "Attributes for the pseudocolor plot";
#else
static char *PseudocolorAttributes_Purpose = "Attributes for the pseudocolor plot";
#endif

//
// The type description structure
//
static PyTypeObject PseudocolorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PseudocolorAttributes",                    // tp_name
    sizeof(PseudocolorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PseudocolorAttributes_dealloc,  // tp_dealloc
    (printfunc)PseudocolorAttributes_print,     // tp_print
    (getattrfunc)PyPseudocolorAttributes_getattr, // tp_getattr
    (setattrfunc)PyPseudocolorAttributes_setattr, // tp_setattr
    (cmpfunc)PseudocolorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PseudocolorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PseudocolorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PseudocolorAttributes *defaultAtts = 0;
static PseudocolorAttributes *currentAtts = 0;

static PyObject *
NewPseudocolorAttributes(int useCurrent)
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PseudocolorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PseudocolorAttributes(*defaultAtts);
    else
        newObject->data = new PseudocolorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPseudocolorAttributes(const PseudocolorAttributes *attr)
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PseudocolorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PseudocolorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPseudocolorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PseudocolorAttributesMethods[] = {
    {"PseudocolorAttributes", PseudocolorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PseudocolorAttributesObserver = 0;

std::string
PyPseudocolorAttributes_GetLogString()
{
    std::string s("PseudocolorAtts = PseudocolorAttributes()\n");
    if(currentAtts != 0)
        s += PyPseudocolorAttributes_ToString(currentAtts, "PseudocolorAtts.");
    return s;
}

static void
PyPseudocolorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PseudocolorAtts = PseudocolorAttributes()\n");
        s += PyPseudocolorAttributes_ToString(currentAtts, "PseudocolorAtts.");
        cb(s);
    }
}

void
PyPseudocolorAttributes_StartUp(PseudocolorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPseudocolorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PseudocolorAttributesObserver == 0)
    {
        PseudocolorAttributesObserver = new ObserverToCallback(subj,
            PyPseudocolorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPseudocolorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PseudocolorAttributesObserver;
    PseudocolorAttributesObserver = 0;
}

PyMethodDef *
PyPseudocolorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PseudocolorAttributesMethods;
}

bool
PyPseudocolorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PseudocolorAttributesType);
}

PseudocolorAttributes *
PyPseudocolorAttributes_FromPyObject(PyObject *obj)
{
    PseudocolorAttributesObject *obj2 = (PseudocolorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPseudocolorAttributes_New()
{
    return NewPseudocolorAttributes(0);
}

PyObject *
PyPseudocolorAttributes_Wrap(const PseudocolorAttributes *attr)
{
    return WrapPseudocolorAttributes(attr);
}

void
PyPseudocolorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PseudocolorAttributesObject *obj2 = (PseudocolorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPseudocolorAttributes_SetDefaults(const PseudocolorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PseudocolorAttributes(*atts);
}

