/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisPDFWindow.h"

#include <PDFAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisPDFWindow::QvisPDFWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisPDFWindow::QvisPDFWindow(const int type,
                         PDFAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisPDFWindow::~QvisPDFWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisPDFWindow::~QvisPDFWindow()
{
}


// ****************************************************************************
// Method: QvisPDFWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPDFWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    var1Label = new QLabel(tr("Variable 1"), central);
    mainLayout->addWidget(var1Label,0,0);
    var1 = new QLineEdit(central);
    connect(var1, SIGNAL(returnPressed()),
            this, SLOT(var1ProcessText()));
    mainLayout->addWidget(var1, 0,1);

    var1MinFlag = new QCheckBox(tr("Use variable 1 min"), central);
    connect(var1MinFlag, SIGNAL(toggled(bool)),
            this, SLOT(var1MinFlagChanged(bool)));
    mainLayout->addWidget(var1MinFlag, 1,0);

    var1MaxFlag = new QCheckBox(tr("Use variable 1 max"), central);
    connect(var1MaxFlag, SIGNAL(toggled(bool)),
            this, SLOT(var1MaxFlagChanged(bool)));
    mainLayout->addWidget(var1MaxFlag, 2,0);

    var1MinLabel = new QLabel(tr("Variable 1 Min"), central);
    mainLayout->addWidget(var1MinLabel,3,0);
    var1Min = new QLineEdit(central);
    connect(var1Min, SIGNAL(returnPressed()),
            this, SLOT(var1MinProcessText()));
    mainLayout->addWidget(var1Min, 3,1);

    var1MaxLabel = new QLabel(tr("Variable 1 Max"), central);
    mainLayout->addWidget(var1MaxLabel,4,0);
    var1Max = new QLineEdit(central);
    connect(var1Max, SIGNAL(returnPressed()),
            this, SLOT(var1MaxProcessText()));
    mainLayout->addWidget(var1Max, 4,1);

    var1ScalingLabel = new QLabel(tr("Variable 1 scale"), central);
    mainLayout->addWidget(var1ScalingLabel,5,0);
    var1Scaling = new QWidget(central);
    var1ScalingButtonGroup= new QButtonGroup(var1Scaling);
    QHBoxLayout *var1ScalingLayout = new QHBoxLayout(var1Scaling);
    var1ScalingLayout->setMargin(0);
    var1ScalingLayout->setSpacing(10);
    QRadioButton *var1ScalingScalingLinear = new QRadioButton(tr("Linear"), var1Scaling);
    var1ScalingButtonGroup->addButton(var1ScalingScalingLinear,0);
    var1ScalingLayout->addWidget(var1ScalingScalingLinear);
    QRadioButton *var1ScalingScalingLog = new QRadioButton(tr("Log"), var1Scaling);
    var1ScalingButtonGroup->addButton(var1ScalingScalingLog,1);
    var1ScalingLayout->addWidget(var1ScalingScalingLog);
    QRadioButton *var1ScalingScalingSkew = new QRadioButton(tr("Skew"), var1Scaling);
    var1ScalingButtonGroup->addButton(var1ScalingScalingSkew,2);
    var1ScalingLayout->addWidget(var1ScalingScalingSkew);
    connect(var1ScalingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(var1ScalingChanged(int)));
    mainLayout->addWidget(var1Scaling, 5,1);

    var1SkewFactorLabel = new QLabel(tr("Variable 1 skew factor"), central);
    mainLayout->addWidget(var1SkewFactorLabel,6,0);
    var1SkewFactor = new QLineEdit(central);
    connect(var1SkewFactor, SIGNAL(returnPressed()),
            this, SLOT(var1SkewFactorProcessText()));
    mainLayout->addWidget(var1SkewFactor, 6,1);

    var1NumSamplesLabel = new QLabel(tr("Number of samples for variable 1?"), central);
    mainLayout->addWidget(var1NumSamplesLabel,7,0);
    var1NumSamples = new QLineEdit(central);
    connect(var1NumSamples, SIGNAL(returnPressed()),
            this, SLOT(var1NumSamplesProcessText()));
    mainLayout->addWidget(var1NumSamples, 7,1);

    var2Label = new QLabel(tr("Variable 2"), central);
    mainLayout->addWidget(var2Label,8,0);
    var2 = new QLineEdit(central);
    connect(var2, SIGNAL(returnPressed()),
            this, SLOT(var2ProcessText()));
    mainLayout->addWidget(var2, 8,1);

    var2MinFlag = new QCheckBox(tr("Use variable 2 min"), central);
    connect(var2MinFlag, SIGNAL(toggled(bool)),
            this, SLOT(var2MinFlagChanged(bool)));
    mainLayout->addWidget(var2MinFlag, 9,0);

    var2MaxFlag = new QCheckBox(tr("Use variable 2 max"), central);
    connect(var2MaxFlag, SIGNAL(toggled(bool)),
            this, SLOT(var2MaxFlagChanged(bool)));
    mainLayout->addWidget(var2MaxFlag, 10,0);

    var2MinLabel = new QLabel(tr("Variable 2 Min"), central);
    mainLayout->addWidget(var2MinLabel,11,0);
    var2Min = new QLineEdit(central);
    connect(var2Min, SIGNAL(returnPressed()),
            this, SLOT(var2MinProcessText()));
    mainLayout->addWidget(var2Min, 11,1);

    var2MaxLabel = new QLabel(tr("Variable 2 Max"), central);
    mainLayout->addWidget(var2MaxLabel,12,0);
    var2Max = new QLineEdit(central);
    connect(var2Max, SIGNAL(returnPressed()),
            this, SLOT(var2MaxProcessText()));
    mainLayout->addWidget(var2Max, 12,1);

    var2ScalingLabel = new QLabel(tr("Variable 2 scale"), central);
    mainLayout->addWidget(var2ScalingLabel,13,0);
    var2Scaling = new QWidget(central);
    var2ScalingButtonGroup= new QButtonGroup(var2Scaling);
    QHBoxLayout *var2ScalingLayout = new QHBoxLayout(var2Scaling);
    var2ScalingLayout->setMargin(0);
    var2ScalingLayout->setSpacing(10);
    QRadioButton *var2ScalingScalingLinear = new QRadioButton(tr("Linear"), var2Scaling);
    var2ScalingButtonGroup->addButton(var2ScalingScalingLinear,0);
    var2ScalingLayout->addWidget(var2ScalingScalingLinear);
    QRadioButton *var2ScalingScalingLog = new QRadioButton(tr("Log"), var2Scaling);
    var2ScalingButtonGroup->addButton(var2ScalingScalingLog,1);
    var2ScalingLayout->addWidget(var2ScalingScalingLog);
    QRadioButton *var2ScalingScalingSkew = new QRadioButton(tr("Skew"), var2Scaling);
    var2ScalingButtonGroup->addButton(var2ScalingScalingSkew,2);
    var2ScalingLayout->addWidget(var2ScalingScalingSkew);
    connect(var2ScalingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(var2ScalingChanged(int)));
    mainLayout->addWidget(var2Scaling, 13,1);

    var2SkewFactorLabel = new QLabel(tr("Variable 2 skew factor"), central);
    mainLayout->addWidget(var2SkewFactorLabel,14,0);
    var2SkewFactor = new QLineEdit(central);
    connect(var2SkewFactor, SIGNAL(returnPressed()),
            this, SLOT(var2SkewFactorProcessText()));
    mainLayout->addWidget(var2SkewFactor, 14,1);

    var2NumSamplesLabel = new QLabel(tr("Number of samples for variable 2?"), central);
    mainLayout->addWidget(var2NumSamplesLabel,15,0);
    var2NumSamples = new QLineEdit(central);
    connect(var2NumSamples, SIGNAL(returnPressed()),
            this, SLOT(var2NumSamplesProcessText()));
    mainLayout->addWidget(var2NumSamples, 15,1);

    numAxesLabel = new QLabel(tr("Number of variables"), central);
    mainLayout->addWidget(numAxesLabel,16,0);
    numAxes = new QWidget(central);
    numAxesButtonGroup= new QButtonGroup(numAxes);
    QHBoxLayout *numAxesLayout = new QHBoxLayout(numAxes);
    numAxesLayout->setMargin(0);
    numAxesLayout->setSpacing(10);
    QRadioButton *numAxesNumAxesTwo = new QRadioButton(tr("Two"), numAxes);
    numAxesButtonGroup->addButton(numAxesNumAxesTwo,0);
    numAxesLayout->addWidget(numAxesNumAxesTwo);
    QRadioButton *numAxesNumAxesThree = new QRadioButton(tr("Three"), numAxes);
    numAxesButtonGroup->addButton(numAxesNumAxesThree,1);
    numAxesLayout->addWidget(numAxesNumAxesThree);
    connect(numAxesButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(numAxesChanged(int)));
    mainLayout->addWidget(numAxes, 16,1);

    var3Label = new QLabel(tr("Variable 3"), central);
    mainLayout->addWidget(var3Label,17,0);
    var3 = new QLineEdit(central);
    connect(var3, SIGNAL(returnPressed()),
            this, SLOT(var3ProcessText()));
    mainLayout->addWidget(var3, 17,1);

    var3MinFlag = new QCheckBox(tr("Use variable 3 min"), central);
    connect(var3MinFlag, SIGNAL(toggled(bool)),
            this, SLOT(var3MinFlagChanged(bool)));
    mainLayout->addWidget(var3MinFlag, 18,0);

    var3MaxFlag = new QCheckBox(tr("Use variable 3 max"), central);
    connect(var3MaxFlag, SIGNAL(toggled(bool)),
            this, SLOT(var3MaxFlagChanged(bool)));
    mainLayout->addWidget(var3MaxFlag, 19,0);

    var3MinLabel = new QLabel(tr("Variable 3 Min"), central);
    mainLayout->addWidget(var3MinLabel,20,0);
    var3Min = new QLineEdit(central);
    connect(var3Min, SIGNAL(returnPressed()),
            this, SLOT(var3MinProcessText()));
    mainLayout->addWidget(var3Min, 20,1);

    var3MaxLabel = new QLabel(tr("Variable 3 Max"), central);
    mainLayout->addWidget(var3MaxLabel,21,0);
    var3Max = new QLineEdit(central);
    connect(var3Max, SIGNAL(returnPressed()),
            this, SLOT(var3MaxProcessText()));
    mainLayout->addWidget(var3Max, 21,1);

    var3ScalingLabel = new QLabel(tr("Variable 3 scale"), central);
    mainLayout->addWidget(var3ScalingLabel,22,0);
    var3Scaling = new QWidget(central);
    var3ScalingButtonGroup= new QButtonGroup(var3Scaling);
    QHBoxLayout *var3ScalingLayout = new QHBoxLayout(var3Scaling);
    var3ScalingLayout->setMargin(0);
    var3ScalingLayout->setSpacing(10);
    QRadioButton *var3ScalingScalingLinear = new QRadioButton(tr("Linear"), var3Scaling);
    var3ScalingButtonGroup->addButton(var3ScalingScalingLinear,0);
    var3ScalingLayout->addWidget(var3ScalingScalingLinear);
    QRadioButton *var3ScalingScalingLog = new QRadioButton(tr("Log"), var3Scaling);
    var3ScalingButtonGroup->addButton(var3ScalingScalingLog,1);
    var3ScalingLayout->addWidget(var3ScalingScalingLog);
    QRadioButton *var3ScalingScalingSkew = new QRadioButton(tr("Skew"), var3Scaling);
    var3ScalingButtonGroup->addButton(var3ScalingScalingSkew,2);
    var3ScalingLayout->addWidget(var3ScalingScalingSkew);
    connect(var3ScalingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(var3ScalingChanged(int)));
    mainLayout->addWidget(var3Scaling, 22,1);

    var3SkewFactorLabel = new QLabel(tr("Variable 3 skew factor"), central);
    mainLayout->addWidget(var3SkewFactorLabel,23,0);
    var3SkewFactor = new QLineEdit(central);
    connect(var3SkewFactor, SIGNAL(returnPressed()),
            this, SLOT(var3SkewFactorProcessText()));
    mainLayout->addWidget(var3SkewFactor, 23,1);

    var3NumSamplesLabel = new QLabel(tr("Number of samples for variable 3?"), central);
    mainLayout->addWidget(var3NumSamplesLabel,24,0);
    var3NumSamples = new QLineEdit(central);
    connect(var3NumSamples, SIGNAL(returnPressed()),
            this, SLOT(var3NumSamplesProcessText()));
    mainLayout->addWidget(var3NumSamples, 24,1);

    scaleCube = new QCheckBox(tr("Scale to cube"), central);
    connect(scaleCube, SIGNAL(toggled(bool)),
            this, SLOT(scaleCubeChanged(bool)));
    mainLayout->addWidget(scaleCube, 25,0);

    densityTypeLabel = new QLabel(tr("Density Type"), central);
    mainLayout->addWidget(densityTypeLabel,26,0);
    densityType = new QWidget(central);
    densityTypeButtonGroup= new QButtonGroup(densityType);
    QHBoxLayout *densityTypeLayout = new QHBoxLayout(densityType);
    densityTypeLayout->setMargin(0);
    densityTypeLayout->setSpacing(10);
    QRadioButton *densityTypeDensityTypeProbability = new QRadioButton(tr("Probability"), densityType);
    densityTypeButtonGroup->addButton(densityTypeDensityTypeProbability,0);
    densityTypeLayout->addWidget(densityTypeDensityTypeProbability);
    QRadioButton *densityTypeDensityTypeZoneCount = new QRadioButton(tr("ZoneCount"), densityType);
    densityTypeButtonGroup->addButton(densityTypeDensityTypeZoneCount,1);
    densityTypeLayout->addWidget(densityTypeDensityTypeZoneCount);
    connect(densityTypeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(densityTypeChanged(int)));
    mainLayout->addWidget(densityType, 26,1);

}


// ****************************************************************************
// Method: QvisPDFWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPDFWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case PDFAttributes::ID_var1:
            var1->setText(QString(atts->GetVar1().c_str()));
            break;
          case PDFAttributes::ID_var1MinFlag:
            if (atts->GetVar1MinFlag() == true)
            {
                var1Min->setEnabled(true);
                if(var1MinLabel)
                    var1MinLabel->setEnabled(true);
            }
            else
            {
                var1Min->setEnabled(false);
                if(var1MinLabel)
                    var1MinLabel->setEnabled(false);
            }
            var1MinFlag->blockSignals(true);
            var1MinFlag->setChecked(atts->GetVar1MinFlag());
            var1MinFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var1MaxFlag:
            if (atts->GetVar1MaxFlag() == true)
            {
                var1Max->setEnabled(true);
                if(var1MaxLabel)
                    var1MaxLabel->setEnabled(true);
            }
            else
            {
                var1Max->setEnabled(false);
                if(var1MaxLabel)
                    var1MaxLabel->setEnabled(false);
            }
            var1MaxFlag->blockSignals(true);
            var1MaxFlag->setChecked(atts->GetVar1MaxFlag());
            var1MaxFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var1Min:
            var1Min->setText(DoubleToQString(atts->GetVar1Min()));
            break;
          case PDFAttributes::ID_var1Max:
            var1Max->setText(DoubleToQString(atts->GetVar1Max()));
            break;
          case PDFAttributes::ID_var1Scaling:
            if (atts->GetVar1Scaling() == PDFAttributes::Skew)
            {
                var1SkewFactor->setEnabled(true);
                if(var1SkewFactorLabel)
                    var1SkewFactorLabel->setEnabled(true);
            }
            else
            {
                var1SkewFactor->setEnabled(false);
                if(var1SkewFactorLabel)
                    var1SkewFactorLabel->setEnabled(false);
            }
            var1ScalingButtonGroup->blockSignals(true);
            if(var1ScalingButtonGroup->button((int)atts->GetVar1Scaling()) != 0)
                var1ScalingButtonGroup->button((int)atts->GetVar1Scaling())->setChecked(true);
            var1ScalingButtonGroup->blockSignals(false);
            break;
          case PDFAttributes::ID_var1SkewFactor:
            var1SkewFactor->setText(DoubleToQString(atts->GetVar1SkewFactor()));
            break;
          case PDFAttributes::ID_var1NumSamples:
            var1NumSamples->setText(IntToQString(atts->GetVar1NumSamples()));
            break;
          case PDFAttributes::ID_var2:
            var2->setText(QString(atts->GetVar2().c_str()));
            break;
          case PDFAttributes::ID_var2MinFlag:
            if (atts->GetVar2MinFlag() == true)
            {
                var2Min->setEnabled(true);
                if(var2MinLabel)
                    var2MinLabel->setEnabled(true);
            }
            else
            {
                var2Min->setEnabled(false);
                if(var2MinLabel)
                    var2MinLabel->setEnabled(false);
            }
            var2MinFlag->blockSignals(true);
            var2MinFlag->setChecked(atts->GetVar2MinFlag());
            var2MinFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var2MaxFlag:
            if (atts->GetVar2MaxFlag() == true)
            {
                var2Max->setEnabled(true);
                if(var2MaxLabel)
                    var2MaxLabel->setEnabled(true);
            }
            else
            {
                var2Max->setEnabled(false);
                if(var2MaxLabel)
                    var2MaxLabel->setEnabled(false);
            }
            var2MaxFlag->blockSignals(true);
            var2MaxFlag->setChecked(atts->GetVar2MaxFlag());
            var2MaxFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var2Min:
            var2Min->setText(DoubleToQString(atts->GetVar2Min()));
            break;
          case PDFAttributes::ID_var2Max:
            var2Max->setText(DoubleToQString(atts->GetVar2Max()));
            break;
          case PDFAttributes::ID_var2Scaling:
            if (atts->GetVar2Scaling() == PDFAttributes::Skew)
            {
                var2SkewFactor->setEnabled(true);
                if(var2SkewFactorLabel)
                    var2SkewFactorLabel->setEnabled(true);
            }
            else
            {
                var2SkewFactor->setEnabled(false);
                if(var2SkewFactorLabel)
                    var2SkewFactorLabel->setEnabled(false);
            }
            var2ScalingButtonGroup->blockSignals(true);
            if(var2ScalingButtonGroup->button((int)atts->GetVar2Scaling()) != 0)
                var2ScalingButtonGroup->button((int)atts->GetVar2Scaling())->setChecked(true);
            var2ScalingButtonGroup->blockSignals(false);
            break;
          case PDFAttributes::ID_var2SkewFactor:
            var2SkewFactor->setText(DoubleToQString(atts->GetVar2SkewFactor()));
            break;
          case PDFAttributes::ID_var2NumSamples:
            var2NumSamples->setText(IntToQString(atts->GetVar2NumSamples()));
            break;
          case PDFAttributes::ID_numAxes:
            numAxesButtonGroup->blockSignals(true);
            if(numAxesButtonGroup->button((int)atts->GetNumAxes()) != 0)
                numAxesButtonGroup->button((int)atts->GetNumAxes())->setChecked(true);
            numAxesButtonGroup->blockSignals(false);
            break;
          case PDFAttributes::ID_var3:
            var3->setText(QString(atts->GetVar3().c_str()));
            break;
          case PDFAttributes::ID_var3MinFlag:
            if (atts->GetVar3MinFlag() == true)
            {
                var3Min->setEnabled(true);
                if(var3MinLabel)
                    var3MinLabel->setEnabled(true);
            }
            else
            {
                var3Min->setEnabled(false);
                if(var3MinLabel)
                    var3MinLabel->setEnabled(false);
            }
            var3MinFlag->blockSignals(true);
            var3MinFlag->setChecked(atts->GetVar3MinFlag());
            var3MinFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var3MaxFlag:
            if (atts->GetVar3MaxFlag() == true)
            {
                var3Max->setEnabled(true);
                if(var3MaxLabel)
                    var3MaxLabel->setEnabled(true);
            }
            else
            {
                var3Max->setEnabled(false);
                if(var3MaxLabel)
                    var3MaxLabel->setEnabled(false);
            }
            var3MaxFlag->blockSignals(true);
            var3MaxFlag->setChecked(atts->GetVar3MaxFlag());
            var3MaxFlag->blockSignals(false);
            break;
          case PDFAttributes::ID_var3Min:
            var3Min->setText(DoubleToQString(atts->GetVar3Min()));
            break;
          case PDFAttributes::ID_var3Max:
            var3Max->setText(DoubleToQString(atts->GetVar3Max()));
            break;
          case PDFAttributes::ID_var3Scaling:
            if (atts->GetVar3Scaling() == PDFAttributes::Skew)
            {
                var3SkewFactor->setEnabled(true);
                if(var3SkewFactorLabel)
                    var3SkewFactorLabel->setEnabled(true);
            }
            else
            {
                var3SkewFactor->setEnabled(false);
                if(var3SkewFactorLabel)
                    var3SkewFactorLabel->setEnabled(false);
            }
            var3ScalingButtonGroup->blockSignals(true);
            if(var3ScalingButtonGroup->button((int)atts->GetVar3Scaling()) != 0)
                var3ScalingButtonGroup->button((int)atts->GetVar3Scaling())->setChecked(true);
            var3ScalingButtonGroup->blockSignals(false);
            break;
          case PDFAttributes::ID_var3SkewFactor:
            var3SkewFactor->setText(DoubleToQString(atts->GetVar3SkewFactor()));
            break;
          case PDFAttributes::ID_var3NumSamples:
            var3NumSamples->setText(IntToQString(atts->GetVar3NumSamples()));
            break;
          case PDFAttributes::ID_scaleCube:
            scaleCube->blockSignals(true);
            scaleCube->setChecked(atts->GetScaleCube());
            scaleCube->blockSignals(false);
            break;
          case PDFAttributes::ID_densityType:
            densityTypeButtonGroup->blockSignals(true);
            if(densityTypeButtonGroup->button((int)atts->GetDensityType()) != 0)
                densityTypeButtonGroup->button((int)atts->GetDensityType())->setChecked(true);
            densityTypeButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisPDFWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPDFWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do var1
    if(which_widget == PDFAttributes::ID_var1 || doAll)
    {
        QString temp = var1->displayText();
        if(!temp.isEmpty())
            atts->SetVar1(temp.toStdString());
        else
        {
            ResettingError(tr("Variable 1"),
                QString(atts->GetVar1().c_str()));
            atts->SetVar1(atts->GetVar1());
        }
    }

    // Do var1Min
    if(which_widget == PDFAttributes::ID_var1Min || doAll)
    {
        double val;
        if(LineEditGetDouble(var1Min, val))
            atts->SetVar1Min(val);
        else
        {
            ResettingError(tr("Variable 1 Min"),
                DoubleToQString(atts->GetVar1Min()));
            atts->SetVar1Min(atts->GetVar1Min());
        }
    }

    // Do var1Max
    if(which_widget == PDFAttributes::ID_var1Max || doAll)
    {
        double val;
        if(LineEditGetDouble(var1Max, val))
            atts->SetVar1Max(val);
        else
        {
            ResettingError(tr("Variable 1 Max"),
                DoubleToQString(atts->GetVar1Max()));
            atts->SetVar1Max(atts->GetVar1Max());
        }
    }

    // Do var1SkewFactor
    if(which_widget == PDFAttributes::ID_var1SkewFactor || doAll)
    {
        double val;
        if(LineEditGetDouble(var1SkewFactor, val))
            atts->SetVar1SkewFactor(val);
        else
        {
            ResettingError(tr("Variable 1 skew factor"),
                DoubleToQString(atts->GetVar1SkewFactor()));
            atts->SetVar1SkewFactor(atts->GetVar1SkewFactor());
        }
    }

    // Do var1NumSamples
    if(which_widget == PDFAttributes::ID_var1NumSamples || doAll)
    {
        int val;
        if(LineEditGetInt(var1NumSamples, val))
            atts->SetVar1NumSamples(val);
        else
        {
            ResettingError(tr("Number of samples for variable 1?"),
                IntToQString(atts->GetVar1NumSamples()));
            atts->SetVar1NumSamples(atts->GetVar1NumSamples());
        }
    }

    // Do var2
    if(which_widget == PDFAttributes::ID_var2 || doAll)
    {
        QString temp = var2->displayText();
        if(!temp.isEmpty())
            atts->SetVar2(temp.toStdString());
        else
        {
            ResettingError(tr("Variable 2"),
                QString(atts->GetVar2().c_str()));
            atts->SetVar2(atts->GetVar2());
        }
    }

    // Do var2Min
    if(which_widget == PDFAttributes::ID_var2Min || doAll)
    {
        double val;
        if(LineEditGetDouble(var2Min, val))
            atts->SetVar2Min(val);
        else
        {
            ResettingError(tr("Variable 2 Min"),
                DoubleToQString(atts->GetVar2Min()));
            atts->SetVar2Min(atts->GetVar2Min());
        }
    }

    // Do var2Max
    if(which_widget == PDFAttributes::ID_var2Max || doAll)
    {
        double val;
        if(LineEditGetDouble(var2Max, val))
            atts->SetVar2Max(val);
        else
        {
            ResettingError(tr("Variable 2 Max"),
                DoubleToQString(atts->GetVar2Max()));
            atts->SetVar2Max(atts->GetVar2Max());
        }
    }

    // Do var2SkewFactor
    if(which_widget == PDFAttributes::ID_var2SkewFactor || doAll)
    {
        double val;
        if(LineEditGetDouble(var2SkewFactor, val))
            atts->SetVar2SkewFactor(val);
        else
        {
            ResettingError(tr("Variable 2 skew factor"),
                DoubleToQString(atts->GetVar2SkewFactor()));
            atts->SetVar2SkewFactor(atts->GetVar2SkewFactor());
        }
    }

    // Do var2NumSamples
    if(which_widget == PDFAttributes::ID_var2NumSamples || doAll)
    {
        int val;
        if(LineEditGetInt(var2NumSamples, val))
            atts->SetVar2NumSamples(val);
        else
        {
            ResettingError(tr("Number of samples for variable 2?"),
                IntToQString(atts->GetVar2NumSamples()));
            atts->SetVar2NumSamples(atts->GetVar2NumSamples());
        }
    }

    // Do var3
    if(which_widget == PDFAttributes::ID_var3 || doAll)
    {
        QString temp = var3->displayText();
        if(!temp.isEmpty())
            atts->SetVar3(temp.toStdString());
        else
        {
            ResettingError(tr("Variable 3"),
                QString(atts->GetVar3().c_str()));
            atts->SetVar3(atts->GetVar3());
        }
    }

    // Do var3Min
    if(which_widget == PDFAttributes::ID_var3Min || doAll)
    {
        double val;
        if(LineEditGetDouble(var3Min, val))
            atts->SetVar3Min(val);
        else
        {
            ResettingError(tr("Variable 3 Min"),
                DoubleToQString(atts->GetVar3Min()));
            atts->SetVar3Min(atts->GetVar3Min());
        }
    }

    // Do var3Max
    if(which_widget == PDFAttributes::ID_var3Max || doAll)
    {
        double val;
        if(LineEditGetDouble(var3Max, val))
            atts->SetVar3Max(val);
        else
        {
            ResettingError(tr("Variable 3 Max"),
                DoubleToQString(atts->GetVar3Max()));
            atts->SetVar3Max(atts->GetVar3Max());
        }
    }

    // Do var3SkewFactor
    if(which_widget == PDFAttributes::ID_var3SkewFactor || doAll)
    {
        double val;
        if(LineEditGetDouble(var3SkewFactor, val))
            atts->SetVar3SkewFactor(val);
        else
        {
            ResettingError(tr("Variable 3 skew factor"),
                DoubleToQString(atts->GetVar3SkewFactor()));
            atts->SetVar3SkewFactor(atts->GetVar3SkewFactor());
        }
    }

    // Do var3NumSamples
    if(which_widget == PDFAttributes::ID_var3NumSamples || doAll)
    {
        int val;
        if(LineEditGetInt(var3NumSamples, val))
            atts->SetVar3NumSamples(val);
        else
        {
            ResettingError(tr("Number of samples for variable 3?"),
                IntToQString(atts->GetVar3NumSamples()));
            atts->SetVar3NumSamples(atts->GetVar3NumSamples());
        }
    }

}


//
// Qt Slot functions
//


void
QvisPDFWindow::var1ProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var1);
    Apply();
}


void
QvisPDFWindow::var1MinFlagChanged(bool val)
{
    atts->SetVar1MinFlag(val);
    Apply();
}


void
QvisPDFWindow::var1MaxFlagChanged(bool val)
{
    atts->SetVar1MaxFlag(val);
    Apply();
}


void
QvisPDFWindow::var1MinProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var1Min);
    Apply();
}


void
QvisPDFWindow::var1MaxProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var1Max);
    Apply();
}


void
QvisPDFWindow::var1ScalingChanged(int val)
{
    if(val != atts->GetVar1Scaling())
    {
        atts->SetVar1Scaling(PDFAttributes::Scaling(val));
        Apply();
    }
}


void
QvisPDFWindow::var1SkewFactorProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var1SkewFactor);
    Apply();
}


void
QvisPDFWindow::var1NumSamplesProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var1NumSamples);
    Apply();
}


void
QvisPDFWindow::var2ProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var2);
    Apply();
}


void
QvisPDFWindow::var2MinFlagChanged(bool val)
{
    atts->SetVar2MinFlag(val);
    Apply();
}


void
QvisPDFWindow::var2MaxFlagChanged(bool val)
{
    atts->SetVar2MaxFlag(val);
    Apply();
}


void
QvisPDFWindow::var2MinProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var2Min);
    Apply();
}


void
QvisPDFWindow::var2MaxProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var2Max);
    Apply();
}


void
QvisPDFWindow::var2ScalingChanged(int val)
{
    if(val != atts->GetVar2Scaling())
    {
        atts->SetVar2Scaling(PDFAttributes::Scaling(val));
        Apply();
    }
}


void
QvisPDFWindow::var2SkewFactorProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var2SkewFactor);
    Apply();
}


void
QvisPDFWindow::var2NumSamplesProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var2NumSamples);
    Apply();
}


void
QvisPDFWindow::numAxesChanged(int val)
{
    if(val != atts->GetNumAxes())
    {
        atts->SetNumAxes(PDFAttributes::NumAxes(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisPDFWindow::var3ProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var3);
    Apply();
}


void
QvisPDFWindow::var3MinFlagChanged(bool val)
{
    atts->SetVar3MinFlag(val);
    Apply();
}


void
QvisPDFWindow::var3MaxFlagChanged(bool val)
{
    atts->SetVar3MaxFlag(val);
    Apply();
}


void
QvisPDFWindow::var3MinProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var3Min);
    Apply();
}


void
QvisPDFWindow::var3MaxProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var3Max);
    Apply();
}


void
QvisPDFWindow::var3ScalingChanged(int val)
{
    if(val != atts->GetVar3Scaling())
    {
        atts->SetVar3Scaling(PDFAttributes::Scaling(val));
        Apply();
    }
}


void
QvisPDFWindow::var3SkewFactorProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var3SkewFactor);
    Apply();
}


void
QvisPDFWindow::var3NumSamplesProcessText()
{
    GetCurrentValues(PDFAttributes::ID_var3NumSamples);
    Apply();
}


void
QvisPDFWindow::scaleCubeChanged(bool val)
{
    atts->SetScaleCube(val);
    SetUpdate(false);
    Apply();
}


void
QvisPDFWindow::densityTypeChanged(int val)
{
    if(val != atts->GetDensityType())
    {
        atts->SetDensityType(PDFAttributes::DensityType(val));
        SetUpdate(false);
        Apply();
    }
}


