/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLagrangianAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyLagrangianAttributes
//
// Purpose: 
//   Attributes for Lagrangian operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LagrangianAttributes.
//
struct LagrangianAttributesObject
{
    PyObject_HEAD
    LagrangianAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLagrangianAttributes(int);

std::string
PyLagrangianAttributes_ToString(const LagrangianAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *seedPoint = atts->GetSeedPoint();
        SNPRINTF(tmpStr, 1000, "%sseedPoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", seedPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%snumSteps = %d\n", prefix, atts->GetNumSteps());
    str += tmpStr;
    const char *XAxisSample_names = "Step, Time, ArcLength, Speed, Vorticity, "
        "Variable";
    switch (atts->GetXAxisSample())
    {
      case LagrangianAttributes::Step:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sStep  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Time:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sTime  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::ArcLength:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sArcLength  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Speed:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sSpeed  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Vorticity:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sVorticity  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sXAxisSample = %sVariable  # %s\n", prefix, prefix, XAxisSample_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *YAxisSample_names = "Step, Time, ArcLength, Speed, Vorticity, "
        "Variable";
    switch (atts->GetYAxisSample())
    {
      case LagrangianAttributes::Step:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sStep  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Time:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sTime  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::ArcLength:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sArcLength  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Speed:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sSpeed  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Vorticity:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sVorticity  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      case LagrangianAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sYAxisSample = %sVariable  # %s\n", prefix, prefix, YAxisSample_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
LagrangianAttributes_Notify(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_SetSeedPoint(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;

    double *dvals = obj->data->GetSeedPoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the seedPoint in the object as modified.
    obj->data->SelectSeedPoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_GetSeedPoint(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the seedPoint.
    PyObject *retval = PyTuple_New(3);
    const double *seedPoint = obj->data->GetSeedPoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(seedPoint[i]));
    return retval;
}

/*static*/ PyObject *
LagrangianAttributes_SetNumSteps(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numSteps in the object.
    obj->data->SetNumSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_GetNumSteps(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumSteps()));
    return retval;
}

/*static*/ PyObject *
LagrangianAttributes_SetXAxisSample(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the XAxisSample in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetXAxisSample(LagrangianAttributes::sampleType(ival));
    else
    {
        fprintf(stderr, "An invalid XAxisSample value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Step, Time, ArcLength, Speed, Vorticity, "
                        "Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_GetXAxisSample(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXAxisSample()));
    return retval;
}

/*static*/ PyObject *
LagrangianAttributes_SetYAxisSample(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the YAxisSample in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetYAxisSample(LagrangianAttributes::sampleType(ival));
    else
    {
        fprintf(stderr, "An invalid YAxisSample value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Step, Time, ArcLength, Speed, Vorticity, "
                        "Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_GetYAxisSample(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYAxisSample()));
    return retval;
}

/*static*/ PyObject *
LagrangianAttributes_SetVariable(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LagrangianAttributes_GetVariable(PyObject *self, PyObject *args)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



PyMethodDef PyLagrangianAttributes_methods[LAGRANGIANATTRIBUTES_NMETH] = {
    {"Notify", LagrangianAttributes_Notify, METH_VARARGS},
    {"SetSeedPoint", LagrangianAttributes_SetSeedPoint, METH_VARARGS},
    {"GetSeedPoint", LagrangianAttributes_GetSeedPoint, METH_VARARGS},
    {"SetNumSteps", LagrangianAttributes_SetNumSteps, METH_VARARGS},
    {"GetNumSteps", LagrangianAttributes_GetNumSteps, METH_VARARGS},
    {"SetXAxisSample", LagrangianAttributes_SetXAxisSample, METH_VARARGS},
    {"GetXAxisSample", LagrangianAttributes_GetXAxisSample, METH_VARARGS},
    {"SetYAxisSample", LagrangianAttributes_SetYAxisSample, METH_VARARGS},
    {"GetYAxisSample", LagrangianAttributes_GetYAxisSample, METH_VARARGS},
    {"SetVariable", LagrangianAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", LagrangianAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LagrangianAttributes_dealloc(PyObject *v)
{
   LagrangianAttributesObject *obj = (LagrangianAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LagrangianAttributes_compare(PyObject *v, PyObject *w)
{
    LagrangianAttributes *a = ((LagrangianAttributesObject *)v)->data;
    LagrangianAttributes *b = ((LagrangianAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLagrangianAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "seedPoint") == 0)
        return LagrangianAttributes_GetSeedPoint(self, NULL);
    if(strcmp(name, "numSteps") == 0)
        return LagrangianAttributes_GetNumSteps(self, NULL);
    if(strcmp(name, "XAxisSample") == 0)
        return LagrangianAttributes_GetXAxisSample(self, NULL);
    if(strcmp(name, "Step") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Step));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Time));
    if(strcmp(name, "ArcLength") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::ArcLength));
    if(strcmp(name, "Speed") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Speed));
    if(strcmp(name, "Vorticity") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Vorticity));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Variable));

    if(strcmp(name, "YAxisSample") == 0)
        return LagrangianAttributes_GetYAxisSample(self, NULL);
    if(strcmp(name, "Step") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Step));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Time));
    if(strcmp(name, "ArcLength") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::ArcLength));
    if(strcmp(name, "Speed") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Speed));
    if(strcmp(name, "Vorticity") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Vorticity));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(LagrangianAttributes::Variable));

    if(strcmp(name, "variable") == 0)
        return LagrangianAttributes_GetVariable(self, NULL);

    return Py_FindMethod(PyLagrangianAttributes_methods, self, name);
}

int
PyLagrangianAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "seedPoint") == 0)
        obj = LagrangianAttributes_SetSeedPoint(self, tuple);
    else if(strcmp(name, "numSteps") == 0)
        obj = LagrangianAttributes_SetNumSteps(self, tuple);
    else if(strcmp(name, "XAxisSample") == 0)
        obj = LagrangianAttributes_SetXAxisSample(self, tuple);
    else if(strcmp(name, "YAxisSample") == 0)
        obj = LagrangianAttributes_SetYAxisSample(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = LagrangianAttributes_SetVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LagrangianAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)v;
    fprintf(fp, "%s", PyLagrangianAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LagrangianAttributes_str(PyObject *v)
{
    LagrangianAttributesObject *obj = (LagrangianAttributesObject *)v;
    return PyString_FromString(PyLagrangianAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LagrangianAttributes_Purpose = "Attributes for Lagrangian operator";
#else
static char *LagrangianAttributes_Purpose = "Attributes for Lagrangian operator";
#endif

//
// The type description structure
//
static PyTypeObject LagrangianAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LagrangianAttributes",                    // tp_name
    sizeof(LagrangianAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LagrangianAttributes_dealloc,  // tp_dealloc
    (printfunc)LagrangianAttributes_print,     // tp_print
    (getattrfunc)PyLagrangianAttributes_getattr, // tp_getattr
    (setattrfunc)PyLagrangianAttributes_setattr, // tp_setattr
    (cmpfunc)LagrangianAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LagrangianAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LagrangianAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LagrangianAttributes *defaultAtts = 0;
static LagrangianAttributes *currentAtts = 0;

static PyObject *
NewLagrangianAttributes(int useCurrent)
{
    LagrangianAttributesObject *newObject;
    newObject = PyObject_NEW(LagrangianAttributesObject, &LagrangianAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LagrangianAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LagrangianAttributes(*defaultAtts);
    else
        newObject->data = new LagrangianAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLagrangianAttributes(const LagrangianAttributes *attr)
{
    LagrangianAttributesObject *newObject;
    newObject = PyObject_NEW(LagrangianAttributesObject, &LagrangianAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LagrangianAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LagrangianAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLagrangianAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LagrangianAttributesMethods[] = {
    {"LagrangianAttributes", LagrangianAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LagrangianAttributesObserver = 0;

std::string
PyLagrangianAttributes_GetLogString()
{
    std::string s("LagrangianAtts = LagrangianAttributes()\n");
    if(currentAtts != 0)
        s += PyLagrangianAttributes_ToString(currentAtts, "LagrangianAtts.");
    return s;
}

static void
PyLagrangianAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LagrangianAtts = LagrangianAttributes()\n");
        s += PyLagrangianAttributes_ToString(currentAtts, "LagrangianAtts.");
        cb(s);
    }
}

void
PyLagrangianAttributes_StartUp(LagrangianAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLagrangianAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LagrangianAttributesObserver == 0)
    {
        LagrangianAttributesObserver = new ObserverToCallback(subj,
            PyLagrangianAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLagrangianAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LagrangianAttributesObserver;
    LagrangianAttributesObserver = 0;
}

PyMethodDef *
PyLagrangianAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LagrangianAttributesMethods;
}

bool
PyLagrangianAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LagrangianAttributesType);
}

LagrangianAttributes *
PyLagrangianAttributes_FromPyObject(PyObject *obj)
{
    LagrangianAttributesObject *obj2 = (LagrangianAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLagrangianAttributes_New()
{
    return NewLagrangianAttributes(0);
}

PyObject *
PyLagrangianAttributes_Wrap(const LagrangianAttributes *attr)
{
    return WrapLagrangianAttributes(attr);
}

void
PyLagrangianAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LagrangianAttributesObject *obj2 = (LagrangianAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLagrangianAttributes_SetDefaults(const LagrangianAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LagrangianAttributes(*atts);
}

