/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtEdgeFilter.C
// ************************************************************************* //

#include <avtEdgeFilter.h>
#include <vtkExtractEdges.h>
#include <vtkGeometryFilter.h>

// ****************************************************************************
//  Method: avtEdgeFilter constructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtEdgeFilter::avtEdgeFilter()
{
}


// ****************************************************************************
//  Method: avtEdgeFilter destructor
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
//  Modifications:
//
// ****************************************************************************

avtEdgeFilter::~avtEdgeFilter()
{
}


// ****************************************************************************
//  Method:  avtEdgeFilter::Create
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

avtFilter *
avtEdgeFilter::Create()
{
    return new avtEdgeFilter();
}


// ****************************************************************************
//  Method:      avtEdgeFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

void
avtEdgeFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const EdgeAttributes*)a;
}


// ****************************************************************************
//  Method: avtEdgeFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtEdgeFilter with the given
//      parameters would result in an equivalent avtEdgeFilter.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Mon Feb 23 16:33:23 PST 2009
//
// ****************************************************************************

bool
avtEdgeFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(EdgeAttributes*)a);
}


// ****************************************************************************
//  Method: avtEdgeFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Edge filter.
//
//  Arguments:
//      inDR       The input data representation.
//
//  Returns:       The output data representation.
//
//  Programmer: Jeremy Meredith
//  Creation:   February 23, 2009
//
//  Modifications:
//   Eric Brugger, Thu Jul 24 09:29:05 PDT 2014
//   Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

avtDataRepresentation *
avtEdgeFilter::ExecuteData(avtDataRepresentation *inDR)
{
    //
    // Get the VTK data set.
    //
    vtkDataSet *inDS = inDR->GetDataVTK();

    vtkGeometryFilter *geom = NULL;
    vtkExtractEdges *ee = vtkExtractEdges::New();
    if (inDS->GetDataObjectType() != VTK_POLY_DATA)
    {
        geom = vtkGeometryFilter::New();
        geom->SetInputData(inDS);
        ee->SetInputConnection(geom->GetOutputPort());
    }
    else
    {
        ee->SetInputData(inDS);
    }
    ee->Update();

    vtkPolyData *outDS = ee->GetOutput();

    avtDataRepresentation *outDR = new avtDataRepresentation(outDS,
        inDR->GetDomain(), inDR->GetLabel());

    ee->Delete();
    if (geom)
        geom->Delete();

    return outDR;
}


// ****************************************************************************
//  Method:  avtEdgeFilter::UpdateDataObjectInfo
//
//  Purpose:
//    Set the topological dimension to 1.
//
//  Arguments:
//    none
//
//  Programmer:  Jeremy Meredith
//  Creation:    February 23, 2009
//
//  Modifications:
//    Jeremy Meredith, Fri Apr 30 13:46:43 EDT 2010
//    Disabled setting the topological dimension to 1.  Currently, mixing
//    e.g. a translucent pseudocolor-edge plot (i.e. topodim==1) with a normal
//    translucent pseudocolor plot results in lighting being disabled for both.
//
//    Brad Whitlock, Mon Apr  7 15:55:02 PDT 2014
//    Add filter metadata used in export.
//    Work partially supported by DOE Grant SC0007548.
//
// ****************************************************************************

void
avtEdgeFilter::UpdateDataObjectInfo(void)
{
    //if (GetInput()->GetInfo().GetAttributes().GetTopologicalDimension() != 0)
    //    GetOutput()->GetInfo().GetAttributes().SetTopologicalDimension(1);

    GetOutput()->GetInfo().GetAttributes().AddFilterMetaData("Edge");
}
