/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAMRStitchCellAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyAMRStitchCellAttributes
//
// Purpose: 
//   Attributes for Stitch Cell Operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AMRStitchCellAttributes.
//
struct AMRStitchCellAttributesObject
{
    PyObject_HEAD
    AMRStitchCellAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAMRStitchCellAttributes(int);

std::string
PyAMRStitchCellAttributes_ToString(const AMRStitchCellAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *CreateCellsOfType_names = "DualGridAndStitchCells, DualGrid, StitchCells";
    switch (atts->GetCreateCellsOfType())
    {
      case AMRStitchCellAttributes::DualGridAndStitchCells:
          SNPRINTF(tmpStr, 1000, "%sCreateCellsOfType = %sDualGridAndStitchCells  # %s\n", prefix, prefix, CreateCellsOfType_names);
          str += tmpStr;
          break;
      case AMRStitchCellAttributes::DualGrid:
          SNPRINTF(tmpStr, 1000, "%sCreateCellsOfType = %sDualGrid  # %s\n", prefix, prefix, CreateCellsOfType_names);
          str += tmpStr;
          break;
      case AMRStitchCellAttributes::StitchCells:
          SNPRINTF(tmpStr, 1000, "%sCreateCellsOfType = %sStitchCells  # %s\n", prefix, prefix, CreateCellsOfType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
AMRStitchCellAttributes_Notify(PyObject *self, PyObject *args)
{
    AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AMRStitchCellAttributes_SetCreateCellsOfType(PyObject *self, PyObject *args)
{
    AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the CreateCellsOfType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCreateCellsOfType(AMRStitchCellAttributes::CreateType(ival));
    else
    {
        fprintf(stderr, "An invalid CreateCellsOfType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "DualGridAndStitchCells, DualGrid, StitchCells.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AMRStitchCellAttributes_GetCreateCellsOfType(PyObject *self, PyObject *args)
{
    AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCreateCellsOfType()));
    return retval;
}



PyMethodDef PyAMRStitchCellAttributes_methods[AMRSTITCHCELLATTRIBUTES_NMETH] = {
    {"Notify", AMRStitchCellAttributes_Notify, METH_VARARGS},
    {"SetCreateCellsOfType", AMRStitchCellAttributes_SetCreateCellsOfType, METH_VARARGS},
    {"GetCreateCellsOfType", AMRStitchCellAttributes_GetCreateCellsOfType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AMRStitchCellAttributes_dealloc(PyObject *v)
{
   AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AMRStitchCellAttributes_compare(PyObject *v, PyObject *w)
{
    AMRStitchCellAttributes *a = ((AMRStitchCellAttributesObject *)v)->data;
    AMRStitchCellAttributes *b = ((AMRStitchCellAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAMRStitchCellAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "CreateCellsOfType") == 0)
        return AMRStitchCellAttributes_GetCreateCellsOfType(self, NULL);
    if(strcmp(name, "DualGridAndStitchCells") == 0)
        return PyInt_FromLong(long(AMRStitchCellAttributes::DualGridAndStitchCells));
    if(strcmp(name, "DualGrid") == 0)
        return PyInt_FromLong(long(AMRStitchCellAttributes::DualGrid));
    if(strcmp(name, "StitchCells") == 0)
        return PyInt_FromLong(long(AMRStitchCellAttributes::StitchCells));


    return Py_FindMethod(PyAMRStitchCellAttributes_methods, self, name);
}

int
PyAMRStitchCellAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "CreateCellsOfType") == 0)
        obj = AMRStitchCellAttributes_SetCreateCellsOfType(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AMRStitchCellAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)v;
    fprintf(fp, "%s", PyAMRStitchCellAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AMRStitchCellAttributes_str(PyObject *v)
{
    AMRStitchCellAttributesObject *obj = (AMRStitchCellAttributesObject *)v;
    return PyString_FromString(PyAMRStitchCellAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AMRStitchCellAttributes_Purpose = "Attributes for Stitch Cell Operator";
#else
static char *AMRStitchCellAttributes_Purpose = "Attributes for Stitch Cell Operator";
#endif

//
// The type description structure
//
static PyTypeObject AMRStitchCellAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AMRStitchCellAttributes",                    // tp_name
    sizeof(AMRStitchCellAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AMRStitchCellAttributes_dealloc,  // tp_dealloc
    (printfunc)AMRStitchCellAttributes_print,     // tp_print
    (getattrfunc)PyAMRStitchCellAttributes_getattr, // tp_getattr
    (setattrfunc)PyAMRStitchCellAttributes_setattr, // tp_setattr
    (cmpfunc)AMRStitchCellAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AMRStitchCellAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AMRStitchCellAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AMRStitchCellAttributes *defaultAtts = 0;
static AMRStitchCellAttributes *currentAtts = 0;

static PyObject *
NewAMRStitchCellAttributes(int useCurrent)
{
    AMRStitchCellAttributesObject *newObject;
    newObject = PyObject_NEW(AMRStitchCellAttributesObject, &AMRStitchCellAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AMRStitchCellAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AMRStitchCellAttributes(*defaultAtts);
    else
        newObject->data = new AMRStitchCellAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAMRStitchCellAttributes(const AMRStitchCellAttributes *attr)
{
    AMRStitchCellAttributesObject *newObject;
    newObject = PyObject_NEW(AMRStitchCellAttributesObject, &AMRStitchCellAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AMRStitchCellAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AMRStitchCellAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAMRStitchCellAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AMRStitchCellAttributesMethods[] = {
    {"AMRStitchCellAttributes", AMRStitchCellAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AMRStitchCellAttributesObserver = 0;

std::string
PyAMRStitchCellAttributes_GetLogString()
{
    std::string s("AMRStitchCellAtts = AMRStitchCellAttributes()\n");
    if(currentAtts != 0)
        s += PyAMRStitchCellAttributes_ToString(currentAtts, "AMRStitchCellAtts.");
    return s;
}

static void
PyAMRStitchCellAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AMRStitchCellAtts = AMRStitchCellAttributes()\n");
        s += PyAMRStitchCellAttributes_ToString(currentAtts, "AMRStitchCellAtts.");
        cb(s);
    }
}

void
PyAMRStitchCellAttributes_StartUp(AMRStitchCellAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAMRStitchCellAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AMRStitchCellAttributesObserver == 0)
    {
        AMRStitchCellAttributesObserver = new ObserverToCallback(subj,
            PyAMRStitchCellAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyAMRStitchCellAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AMRStitchCellAttributesObserver;
    AMRStitchCellAttributesObserver = 0;
}

PyMethodDef *
PyAMRStitchCellAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AMRStitchCellAttributesMethods;
}

bool
PyAMRStitchCellAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AMRStitchCellAttributesType);
}

AMRStitchCellAttributes *
PyAMRStitchCellAttributes_FromPyObject(PyObject *obj)
{
    AMRStitchCellAttributesObject *obj2 = (AMRStitchCellAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAMRStitchCellAttributes_New()
{
    return NewAMRStitchCellAttributes(0);
}

PyObject *
PyAMRStitchCellAttributes_Wrap(const AMRStitchCellAttributes *attr)
{
    return WrapAMRStitchCellAttributes(attr);
}

void
PyAMRStitchCellAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    AMRStitchCellAttributesObject *obj2 = (AMRStitchCellAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyAMRStitchCellAttributes_SetDefaults(const AMRStitchCellAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AMRStitchCellAttributes(*atts);
}

