/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ClientInformation.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Init utility for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ClientInformation::Init()
{

    ClientInformation::SelectAll();
}

// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Copy utility for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ClientInformation::Copy(const ClientInformation &obj)
{
    clientName = obj.clientName;
    methodNames = obj.methodNames;
    methodPrototypes = obj.methodPrototypes;

    ClientInformation::SelectAll();
}

// Type map format string
const char *ClientInformation::TypeMapFormatString = CLIENTINFORMATION_TMFS;
const AttributeGroup::private_tmfs_t ClientInformation::TmfsStruct = {CLIENTINFORMATION_TMFS};


// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Default constructor for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation::ClientInformation() : 
    AttributeSubject(ClientInformation::TypeMapFormatString)
{
    ClientInformation::Init();
}

// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Constructor for the derived classes of ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation::ClientInformation(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ClientInformation::Init();
}

// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Copy constructor for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation::ClientInformation(const ClientInformation &obj) : 
    AttributeSubject(ClientInformation::TypeMapFormatString)
{
    ClientInformation::Copy(obj);
}

// ****************************************************************************
// Method: ClientInformation::ClientInformation
//
// Purpose: 
//   Copy constructor for derived classes of the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation::ClientInformation(const ClientInformation &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ClientInformation::Copy(obj);
}

// ****************************************************************************
// Method: ClientInformation::~ClientInformation
//
// Purpose: 
//   Destructor for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation::~ClientInformation()
{
    // nothing here
}

// ****************************************************************************
// Method: ClientInformation::operator = 
//
// Purpose: 
//   Assignment operator for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ClientInformation& 
ClientInformation::operator = (const ClientInformation &obj)
{
    if (this == &obj) return *this;

    ClientInformation::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ClientInformation::operator == 
//
// Purpose: 
//   Comparison operator == for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformation::operator == (const ClientInformation &obj) const
{
    // Create the return value
    return ((clientName == obj.clientName) &&
            (methodNames == obj.methodNames) &&
            (methodPrototypes == obj.methodPrototypes));
}

// ****************************************************************************
// Method: ClientInformation::operator != 
//
// Purpose: 
//   Comparison operator != for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformation::operator != (const ClientInformation &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ClientInformation::TypeName
//
// Purpose: 
//   Type name method for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ClientInformation::TypeName() const
{
    return "ClientInformation";
}

// ****************************************************************************
// Method: ClientInformation::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformation::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ClientInformation *tmp = (const ClientInformation *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ClientInformation::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClientInformation::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ClientInformation(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ClientInformation::NewInstance
//
// Purpose: 
//   NewInstance method for the ClientInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ClientInformation::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ClientInformation(*this);
    else
        retval = new ClientInformation;

    return retval;
}

// ****************************************************************************
// Method: ClientInformation::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ClientInformation::SelectAll()
{
    Select(ID_clientName,       (void *)&clientName);
    Select(ID_methodNames,      (void *)&methodNames);
    Select(ID_methodPrototypes, (void *)&methodPrototypes);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ClientInformation::SetClientName(const std::string &clientName_)
{
    clientName = clientName_;
    Select(ID_clientName, (void *)&clientName);
}

void
ClientInformation::SetMethodNames(const stringVector &methodNames_)
{
    methodNames = methodNames_;
    Select(ID_methodNames, (void *)&methodNames);
}

void
ClientInformation::SetMethodPrototypes(const stringVector &methodPrototypes_)
{
    methodPrototypes = methodPrototypes_;
    Select(ID_methodPrototypes, (void *)&methodPrototypes);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ClientInformation::GetClientName() const
{
    return clientName;
}

std::string &
ClientInformation::GetClientName()
{
    return clientName;
}

const stringVector &
ClientInformation::GetMethodNames() const
{
    return methodNames;
}

stringVector &
ClientInformation::GetMethodNames()
{
    return methodNames;
}

const stringVector &
ClientInformation::GetMethodPrototypes() const
{
    return methodPrototypes;
}

stringVector &
ClientInformation::GetMethodPrototypes()
{
    return methodPrototypes;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ClientInformation::SelectClientName()
{
    Select(ID_clientName, (void *)&clientName);
}

void
ClientInformation::SelectMethodNames()
{
    Select(ID_methodNames, (void *)&methodNames);
}

void
ClientInformation::SelectMethodPrototypes()
{
    Select(ID_methodPrototypes, (void *)&methodPrototypes);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ClientInformation::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ClientInformation::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_clientName:       return "clientName";
    case ID_methodNames:      return "methodNames";
    case ID_methodPrototypes: return "methodPrototypes";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClientInformation::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ClientInformation::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_clientName:       return FieldType_string;
    case ID_methodNames:      return FieldType_stringVector;
    case ID_methodPrototypes: return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ClientInformation::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ClientInformation::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_clientName:       return "string";
    case ID_methodNames:      return "stringVector";
    case ID_methodPrototypes: return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ClientInformation::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ClientInformation::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ClientInformation &obj = *((const ClientInformation*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_clientName:
        {  // new scope
        retval = (clientName == obj.clientName);
        }
        break;
    case ID_methodNames:
        {  // new scope
        retval = (methodNames == obj.methodNames);
        }
        break;
    case ID_methodPrototypes:
        {  // new scope
        retval = (methodPrototypes == obj.methodPrototypes);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
ClientInformation::DeclareMethod(const std::string &name, const std::string &proto)
{
    methodNames.push_back(name);
    methodPrototypes.push_back(proto);
    SelectMethodNames();
    SelectMethodPrototypes();
}

int
ClientInformation::GetMethodIndex(const std::string &name) const
{
    for(size_t i = 0; i < methodNames.size(); ++i)
    {
        if(methodNames[i] == name)
            return i;
    }

    return -1;
}

std::string
ClientInformation::GetMethod(int i) const
{
    if(i >= 0 && (size_t)i < methodNames.size())
        return methodNames[i];
    return "";
}

std::string
ClientInformation::GetMethodPrototype(int i) const
{
    if(i >= 0 && (size_t)i < methodPrototypes.size())
        return methodPrototypes[i];
    return "";
}

void
ClientInformation::ClearMethods()
{
    methodNames.clear();
    methodPrototypes.clear();
    SelectMethodNames();
    SelectMethodPrototypes();
}

