/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtDatabaseMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyExpressionList.h>
#include <PyavtMeshMetaData.h>
#include <PyavtSubsetsMetaData.h>
#include <PyavtScalarMetaData.h>
#include <PyavtVectorMetaData.h>
#include <PyavtTensorMetaData.h>
#include <PyavtSymmetricTensorMetaData.h>
#include <PyavtArrayMetaData.h>
#include <PyavtMaterialMetaData.h>
#include <PyavtSpeciesMetaData.h>
#include <PyavtCurveMetaData.h>
#include <PyavtLabelMetaData.h>
#include <PyavtDefaultPlotMetaData.h>
#include <PyavtSimulationInformation.h>

// ****************************************************************************
// Module: PyavtDatabaseMetaData
//
// Purpose: 
//   Contains database metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtDatabaseMetaData.
//
struct avtDatabaseMetaDataObject
{
    PyObject_HEAD
    avtDatabaseMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtDatabaseMetaData(int);

std::string
PyavtDatabaseMetaData_ToString(const avtDatabaseMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetHasTemporalExtents())
        SNPRINTF(tmpStr, 1000, "%shasTemporalExtents = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasTemporalExtents = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminTemporalExtents = %g\n", prefix, atts->GetMinTemporalExtents());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxTemporalExtents = %g\n", prefix, atts->GetMaxTemporalExtents());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumStates = %d\n", prefix, atts->GetNumStates());
    str += tmpStr;
    if(atts->GetIsVirtualDatabase())
        SNPRINTF(tmpStr, 1000, "%sisVirtualDatabase = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisVirtualDatabase = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMustRepopulateOnStateChange())
        SNPRINTF(tmpStr, 1000, "%smustRepopulateOnStateChange = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smustRepopulateOnStateChange = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMustAlphabetizeVariables())
        SNPRINTF(tmpStr, 1000, "%smustAlphabetizeVariables = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smustAlphabetizeVariables = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFormatCanDoDomainDecomposition())
        SNPRINTF(tmpStr, 1000, "%sformatCanDoDomainDecomposition = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sformatCanDoDomainDecomposition = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFormatCanDoMultires())
        SNPRINTF(tmpStr, 1000, "%sformatCanDoMultires = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sformatCanDoMultires = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUseCatchAllMesh())
        SNPRINTF(tmpStr, 1000, "%suseCatchAllMesh = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseCatchAllMesh = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStepPath = \"%s\"\n", prefix, atts->GetTimeStepPath().c_str());
    str += tmpStr;
    {   const stringVector &timeStepNames = atts->GetTimeStepNames();
        SNPRINTF(tmpStr, 1000, "%stimeStepNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < timeStepNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", timeStepNames[i].c_str());
            str += tmpStr;
            if(i < timeStepNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &cycles = atts->GetCycles();
        SNPRINTF(tmpStr, 1000, "%scycles = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < cycles.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", cycles[i]);
            str += tmpStr;
            if(i < cycles.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &cyclesAreAccurate = atts->GetCyclesAreAccurate();
        SNPRINTF(tmpStr, 1000, "%scyclesAreAccurate = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < cyclesAreAccurate.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", cyclesAreAccurate[i]);
            str += tmpStr;
            if(i < cyclesAreAccurate.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &times = atts->GetTimes();
        SNPRINTF(tmpStr, 1000, "%stimes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < times.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", times[i]);
            str += tmpStr;
            if(i < times.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &timesAreAccurate = atts->GetTimesAreAccurate();
        SNPRINTF(tmpStr, 1000, "%stimesAreAccurate = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < timesAreAccurate.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", timesAreAccurate[i]);
            str += tmpStr;
            if(i < timesAreAccurate.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sdatabaseName = \"%s\"\n", prefix, atts->GetDatabaseName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfileFormat = \"%s\"\n", prefix, atts->GetFileFormat().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdatabaseComment = \"%s\"\n", prefix, atts->GetDatabaseComment().c_str());
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "exprList.";
        str += PyExpressionList_ToString(&atts->GetExprList(), objPrefix.c_str());
    }
    { // new scope
        int index = 0;
        // Create string representation of meshes from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetMeshes().begin(); pos != atts->GetMeshes().end(); ++pos, ++index)
        {
            const avtMeshMetaData *current = (const avtMeshMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetMeshes(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtMeshMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#meshes does not contain any avtMeshMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of subsets from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetSubsets().begin(); pos != atts->GetSubsets().end(); ++pos, ++index)
        {
            const avtSubsetsMetaData *current = (const avtSubsetsMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetSubsets(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtSubsetsMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#subsets does not contain any avtSubsetsMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of scalars from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetScalars().begin(); pos != atts->GetScalars().end(); ++pos, ++index)
        {
            const avtScalarMetaData *current = (const avtScalarMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetScalars(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtScalarMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#scalars does not contain any avtScalarMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of vectors from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetVectors().begin(); pos != atts->GetVectors().end(); ++pos, ++index)
        {
            const avtVectorMetaData *current = (const avtVectorMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetVectors(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtVectorMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#vectors does not contain any avtVectorMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of tensors from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetTensors().begin(); pos != atts->GetTensors().end(); ++pos, ++index)
        {
            const avtTensorMetaData *current = (const avtTensorMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetTensors(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtTensorMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#tensors does not contain any avtTensorMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of symmTensors from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetSymmTensors().begin(); pos != atts->GetSymmTensors().end(); ++pos, ++index)
        {
            const avtSymmetricTensorMetaData *current = (const avtSymmetricTensorMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetSymmTensors(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtSymmetricTensorMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#symmTensors does not contain any avtSymmetricTensorMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of arrays from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetArrays().begin(); pos != atts->GetArrays().end(); ++pos, ++index)
        {
            const avtArrayMetaData *current = (const avtArrayMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetArrays(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtArrayMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#arrays does not contain any avtArrayMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of materials from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetMaterials().begin(); pos != atts->GetMaterials().end(); ++pos, ++index)
        {
            const avtMaterialMetaData *current = (const avtMaterialMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetMaterials(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtMaterialMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#materials does not contain any avtMaterialMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of species from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetSpecies().begin(); pos != atts->GetSpecies().end(); ++pos, ++index)
        {
            const avtSpeciesMetaData *current = (const avtSpeciesMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetSpecies(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtSpeciesMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#species does not contain any avtSpeciesMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of curves from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetCurves().begin(); pos != atts->GetCurves().end(); ++pos, ++index)
        {
            const avtCurveMetaData *current = (const avtCurveMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetCurves(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtCurveMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#curves does not contain any avtCurveMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of labels from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetLabels().begin(); pos != atts->GetLabels().end(); ++pos, ++index)
        {
            const avtLabelMetaData *current = (const avtLabelMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetLabels(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtLabelMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#labels does not contain any avtLabelMetaData objects.\n";
    }
    { // new scope
        int index = 0;
        // Create string representation of defaultPlots from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetDefaultPlots().begin(); pos != atts->GetDefaultPlots().end(); ++pos, ++index)
        {
            const avtDefaultPlotMetaData *current = (const avtDefaultPlotMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetDefaultPlots(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtDefaultPlotMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#defaultPlots does not contain any avtDefaultPlotMetaData objects.\n";
    }
    if(atts->GetIsSimulation())
        SNPRINTF(tmpStr, 1000, "%sisSimulation = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisSimulation = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "simInfo.";
        str += PyavtSimulationInformation_ToString(&atts->GetSimInfo(), objPrefix.c_str());
    }
    {   const stringVector &suggestedDefaultSILRestriction = atts->GetSuggestedDefaultSILRestriction();
        SNPRINTF(tmpStr, 1000, "%ssuggestedDefaultSILRestriction = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < suggestedDefaultSILRestriction.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", suggestedDefaultSILRestriction[i].c_str());
            str += tmpStr;
            if(i < suggestedDefaultSILRestriction.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sreplacementMask = %d\n", prefix, atts->GetReplacementMask());
    str += tmpStr;
    return str;
}

static PyObject *
avtDatabaseMetaData_Notify(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetHasTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasTemporalExtents in the object.
    obj->data->SetHasTemporalExtents(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetHasTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHasTemporalExtents()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetMinTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minTemporalExtents in the object.
    obj->data->SetMinTemporalExtents(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMinTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinTemporalExtents());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetMaxTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTemporalExtents in the object.
    obj->data->SetMaxTemporalExtents(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMaxTemporalExtents(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTemporalExtents());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetNumStates(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numStates in the object.
    obj->data->SetNumStates((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetNumStates(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumStates()));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetIsVirtualDatabase(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isVirtualDatabase in the object.
    obj->data->SetIsVirtualDatabase(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetIsVirtualDatabase(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsVirtualDatabase()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetMustRepopulateOnStateChange(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the mustRepopulateOnStateChange in the object.
    obj->data->SetMustRepopulateOnStateChange(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMustRepopulateOnStateChange(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMustRepopulateOnStateChange()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetMustAlphabetizeVariables(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the mustAlphabetizeVariables in the object.
    obj->data->SetMustAlphabetizeVariables(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMustAlphabetizeVariables(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMustAlphabetizeVariables()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetFormatCanDoDomainDecomposition(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the formatCanDoDomainDecomposition in the object.
    obj->data->SetFormatCanDoDomainDecomposition(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetFormatCanDoDomainDecomposition(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFormatCanDoDomainDecomposition()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetFormatCanDoMultires(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the formatCanDoMultires in the object.
    obj->data->SetFormatCanDoMultires(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetFormatCanDoMultires(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFormatCanDoMultires()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetUseCatchAllMesh(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useCatchAllMesh in the object.
    obj->data->SetUseCatchAllMesh(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetUseCatchAllMesh(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseCatchAllMesh()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetTimeStepPath(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the timeStepPath in the object.
    obj->data->SetTimeStepPath(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetTimeStepPath(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTimeStepPath().c_str());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetTimeStepNames(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    stringVector  &vec = obj->data->GetTimeStepNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the timeStepNames in the object as modified.
    obj->data->SelectTimeStepNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetTimeStepNames(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the timeStepNames.
    const stringVector &timeStepNames = obj->data->GetTimeStepNames();
    PyObject *retval = PyTuple_New(timeStepNames.size());
    for(size_t i = 0; i < timeStepNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(timeStepNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetCycles(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    intVector  &vec = obj->data->GetCycles();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the cycles in the object as modified.
    obj->data->SelectCycles();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetCycles(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the cycles.
    const intVector &cycles = obj->data->GetCycles();
    PyObject *retval = PyTuple_New(cycles.size());
    for(size_t i = 0; i < cycles.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(cycles[i])));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetCyclesAreAccurate(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    intVector  &vec = obj->data->GetCyclesAreAccurate();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the cyclesAreAccurate in the object as modified.
    obj->data->SelectCyclesAreAccurate();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetCyclesAreAccurate(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the cyclesAreAccurate.
    const intVector &cyclesAreAccurate = obj->data->GetCyclesAreAccurate();
    PyObject *retval = PyTuple_New(cyclesAreAccurate.size());
    for(size_t i = 0; i < cyclesAreAccurate.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(cyclesAreAccurate[i])));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetTimes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    doubleVector  &vec = obj->data->GetTimes();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the times in the object as modified.
    obj->data->SelectTimes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetTimes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the times.
    const doubleVector &times = obj->data->GetTimes();
    PyObject *retval = PyTuple_New(times.size());
    for(size_t i = 0; i < times.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(times[i]));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetTimesAreAccurate(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    intVector  &vec = obj->data->GetTimesAreAccurate();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the timesAreAccurate in the object as modified.
    obj->data->SelectTimesAreAccurate();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetTimesAreAccurate(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the timesAreAccurate.
    const intVector &timesAreAccurate = obj->data->GetTimesAreAccurate();
    PyObject *retval = PyTuple_New(timesAreAccurate.size());
    for(size_t i = 0; i < timesAreAccurate.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(timesAreAccurate[i])));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetDatabaseName(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the databaseName in the object.
    obj->data->SetDatabaseName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetDatabaseName(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDatabaseName().c_str());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetFileFormat(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the fileFormat in the object.
    obj->data->SetFileFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetFileFormat(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFileFormat().c_str());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetDatabaseComment(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the databaseComment in the object.
    obj->data->SetDatabaseComment(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetDatabaseComment(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDatabaseComment().c_str());
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetExprList(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyExpressionList_Check(newValue))
    {
        fprintf(stderr, "The exprList field can only be set with ExpressionList objects.\n");
        return NULL;
    }

    obj->data->SetExprList(*PyExpressionList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetExprList(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyExpressionList_Wrap(&obj->data->GetExprList());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyExpressionList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMeshes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetMeshes().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetMeshes().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetMeshes : The index %d is invalid because meshes is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetMeshes : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetMeshes().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtMeshMetaData_Wrap(&obj->data->GetMeshes(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtMeshMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumMeshes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetMeshes().size());
}

PyObject *
avtDatabaseMetaData_AddMeshes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtMeshMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddMeshes method only accepts avtMeshMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtMeshMetaData *newData = PyavtMeshMetaData_FromPyObject(element);
    obj->data->AddMeshes(*newData);
    obj->data->SelectMeshes();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Meshes(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveMeshes() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetMeshes();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectMeshes();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveMeshes(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumMeshes())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveMeshes : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Meshes(self, index);
}

PyObject *
avtDatabaseMetaData_ClearMeshes(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumMeshes();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Meshes(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetSubsets(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetSubsets().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetSubsets().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSubsets : The index %d is invalid because subsets is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSubsets : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetSubsets().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSubsetsMetaData_Wrap(&obj->data->GetSubsets(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSubsetsMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumSubsets(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetSubsets().size());
}

PyObject *
avtDatabaseMetaData_AddSubsets(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtSubsetsMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddSubsets method only accepts avtSubsetsMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtSubsetsMetaData *newData = PyavtSubsetsMetaData_FromPyObject(element);
    obj->data->AddSubsets(*newData);
    obj->data->SelectSubsets();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Subsets(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveSubsets() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetSubsets();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectSubsets();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveSubsets(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumSubsets())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveSubsets : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Subsets(self, index);
}

PyObject *
avtDatabaseMetaData_ClearSubsets(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumSubsets();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Subsets(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetScalars(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetScalars().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetScalars().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetScalars : The index %d is invalid because scalars is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetScalars : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetScalars().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtScalarMetaData_Wrap(&obj->data->GetScalars(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtScalarMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumScalars(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetScalars().size());
}

PyObject *
avtDatabaseMetaData_AddScalars(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtScalarMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddScalars method only accepts avtScalarMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtScalarMetaData *newData = PyavtScalarMetaData_FromPyObject(element);
    obj->data->AddScalars(*newData);
    obj->data->SelectScalars();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Scalars(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveScalars() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetScalars();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectScalars();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveScalars(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumScalars())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveScalars : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Scalars(self, index);
}

PyObject *
avtDatabaseMetaData_ClearScalars(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumScalars();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Scalars(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetVectors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetVectors().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetVectors().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetVectors : The index %d is invalid because vectors is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetVectors : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetVectors().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtVectorMetaData_Wrap(&obj->data->GetVectors(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtVectorMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumVectors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetVectors().size());
}

PyObject *
avtDatabaseMetaData_AddVectors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtVectorMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddVectors method only accepts avtVectorMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtVectorMetaData *newData = PyavtVectorMetaData_FromPyObject(element);
    obj->data->AddVectors(*newData);
    obj->data->SelectVectors();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Vectors(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveVectors() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetVectors();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectVectors();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveVectors(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumVectors())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveVectors : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Vectors(self, index);
}

PyObject *
avtDatabaseMetaData_ClearVectors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumVectors();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Vectors(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetTensors().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetTensors().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetTensors : The index %d is invalid because tensors is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetTensors : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetTensors().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtTensorMetaData_Wrap(&obj->data->GetTensors(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtTensorMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetTensors().size());
}

PyObject *
avtDatabaseMetaData_AddTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtTensorMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddTensors method only accepts avtTensorMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtTensorMetaData *newData = PyavtTensorMetaData_FromPyObject(element);
    obj->data->AddTensors(*newData);
    obj->data->SelectTensors();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Tensors(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveTensors() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetTensors();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectTensors();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveTensors(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumTensors())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveTensors : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Tensors(self, index);
}

PyObject *
avtDatabaseMetaData_ClearTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumTensors();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Tensors(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetSymmTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetSymmTensors().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetSymmTensors().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSymmTensors : The index %d is invalid because symmTensors is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSymmTensors : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetSymmTensors().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSymmetricTensorMetaData_Wrap(&obj->data->GetSymmTensors(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSymmetricTensorMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumSymmTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetSymmTensors().size());
}

PyObject *
avtDatabaseMetaData_AddSymmTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtSymmetricTensorMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddSymmTensors method only accepts avtSymmetricTensorMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtSymmetricTensorMetaData *newData = PyavtSymmetricTensorMetaData_FromPyObject(element);
    obj->data->AddSymmTensors(*newData);
    obj->data->SelectSymmTensors();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_SymmTensors(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveSymmTensors() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetSymmTensors();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectSymmTensors();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveSymmTensors(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumSymmTensors())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveSymmTensors : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_SymmTensors(self, index);
}

PyObject *
avtDatabaseMetaData_ClearSymmTensors(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumSymmTensors();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_SymmTensors(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetArrays(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetArrays().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetArrays().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetArrays : The index %d is invalid because arrays is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetArrays : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetArrays().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtArrayMetaData_Wrap(&obj->data->GetArrays(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtArrayMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumArrays(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetArrays().size());
}

PyObject *
avtDatabaseMetaData_AddArrays(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtArrayMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddArrays method only accepts avtArrayMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtArrayMetaData *newData = PyavtArrayMetaData_FromPyObject(element);
    obj->data->AddArrays(*newData);
    obj->data->SelectArrays();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Arrays(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveArrays() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetArrays();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectArrays();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveArrays(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumArrays())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveArrays : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Arrays(self, index);
}

PyObject *
avtDatabaseMetaData_ClearArrays(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumArrays();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Arrays(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetMaterials(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetMaterials().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetMaterials().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetMaterials : The index %d is invalid because materials is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetMaterials : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetMaterials().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtMaterialMetaData_Wrap(&obj->data->GetMaterials(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtMaterialMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumMaterials(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetMaterials().size());
}

PyObject *
avtDatabaseMetaData_AddMaterials(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtMaterialMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddMaterials method only accepts avtMaterialMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtMaterialMetaData *newData = PyavtMaterialMetaData_FromPyObject(element);
    obj->data->AddMaterials(*newData);
    obj->data->SelectMaterials();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Materials(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveMaterials() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetMaterials();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectMaterials();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveMaterials(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumMaterials())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveMaterials : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Materials(self, index);
}

PyObject *
avtDatabaseMetaData_ClearMaterials(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumMaterials();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Materials(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetSpecies(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetSpecies().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetSpecies().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSpecies : The index %d is invalid because species is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetSpecies : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetSpecies().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSpeciesMetaData_Wrap(&obj->data->GetSpecies(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSpeciesMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumSpecies(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetSpecies().size());
}

PyObject *
avtDatabaseMetaData_AddSpecies(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtSpeciesMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddSpecies method only accepts avtSpeciesMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtSpeciesMetaData *newData = PyavtSpeciesMetaData_FromPyObject(element);
    obj->data->AddSpecies(*newData);
    obj->data->SelectSpecies();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Species(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveSpecies() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetSpecies();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectSpecies();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveSpecies(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumSpecies())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveSpecies : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Species(self, index);
}

PyObject *
avtDatabaseMetaData_ClearSpecies(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumSpecies();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Species(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetCurves(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetCurves().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetCurves().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetCurves : The index %d is invalid because curves is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetCurves : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetCurves().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtCurveMetaData_Wrap(&obj->data->GetCurves(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtCurveMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumCurves(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetCurves().size());
}

PyObject *
avtDatabaseMetaData_AddCurves(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtCurveMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddCurves method only accepts avtCurveMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtCurveMetaData *newData = PyavtCurveMetaData_FromPyObject(element);
    obj->data->AddCurves(*newData);
    obj->data->SelectCurves();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Curves(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveCurves() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetCurves();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectCurves();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveCurves(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumCurves())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveCurves : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Curves(self, index);
}

PyObject *
avtDatabaseMetaData_ClearCurves(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumCurves();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Curves(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetLabels(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetLabels().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetLabels().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetLabels : The index %d is invalid because labels is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetLabels : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetLabels().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtLabelMetaData_Wrap(&obj->data->GetLabels(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtLabelMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumLabels(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetLabels().size());
}

PyObject *
avtDatabaseMetaData_AddLabels(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtLabelMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddLabels method only accepts avtLabelMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtLabelMetaData *newData = PyavtLabelMetaData_FromPyObject(element);
    obj->data->AddLabels(*newData);
    obj->data->SelectLabels();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_Labels(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveLabels() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetLabels();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectLabels();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveLabels(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumLabels())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveLabels : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_Labels(self, index);
}

PyObject *
avtDatabaseMetaData_ClearLabels(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumLabels();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_Labels(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetDefaultPlots(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetDefaultPlots().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetDefaultPlots().size() == 0)
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetDefaultPlots : The index %d is invalid because defaultPlots is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtDatabaseMetaData::GetDefaultPlots : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetDefaultPlots().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtDefaultPlotMetaData_Wrap(&obj->data->GetDefaultPlots(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtDefaultPlotMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtDatabaseMetaData_GetNumDefaultPlots(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetDefaultPlots().size());
}

PyObject *
avtDatabaseMetaData_AddDefaultPlots(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtDefaultPlotMetaData_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtDatabaseMetaData::AddDefaultPlots method only accepts avtDefaultPlotMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtDefaultPlotMetaData *newData = PyavtDefaultPlotMetaData_FromPyObject(element);
    obj->data->AddDefaultPlots(*newData);
    obj->data->SelectDefaultPlots();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtDatabaseMetaData_Remove_One_DefaultPlots(PyObject *self, int index)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveDefaultPlots() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetDefaultPlots();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectDefaultPlots();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtDatabaseMetaData_RemoveDefaultPlots(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumDefaultPlots())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtDatabaseMetaData::RemoveDefaultPlots : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtDatabaseMetaData_Remove_One_DefaultPlots(self, index);
}

PyObject *
avtDatabaseMetaData_ClearDefaultPlots(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    int n = obj->data->GetNumDefaultPlots();
    for(int i = 0; i < n; ++i)
    {
        avtDatabaseMetaData_Remove_One_DefaultPlots(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetIsSimulation(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isSimulation in the object.
    obj->data->SetIsSimulation(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetIsSimulation(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsSimulation()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetSimInfo(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyavtSimulationInformation_Check(newValue))
    {
        fprintf(stderr, "The simInfo field can only be set with avtSimulationInformation objects.\n");
        return NULL;
    }

    obj->data->SetSimInfo(*PyavtSimulationInformation_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetSimInfo(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSimulationInformation_Wrap(&obj->data->GetSimInfo());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSimulationInformation_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetSuggestedDefaultSILRestriction(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    stringVector  &vec = obj->data->GetSuggestedDefaultSILRestriction();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the suggestedDefaultSILRestriction in the object as modified.
    obj->data->SelectSuggestedDefaultSILRestriction();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetSuggestedDefaultSILRestriction(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the suggestedDefaultSILRestriction.
    const stringVector &suggestedDefaultSILRestriction = obj->data->GetSuggestedDefaultSILRestriction();
    PyObject *retval = PyTuple_New(suggestedDefaultSILRestriction.size());
    for(size_t i = 0; i < suggestedDefaultSILRestriction.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(suggestedDefaultSILRestriction[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtDatabaseMetaData_SetReplacementMask(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the replacementMask in the object.
    obj->data->SetReplacementMask((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtDatabaseMetaData_GetReplacementMask(PyObject *self, PyObject *args)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetReplacementMask()));
    return retval;
}



PyMethodDef PyavtDatabaseMetaData_methods[AVTDATABASEMETADATA_NMETH] = {
    {"Notify", avtDatabaseMetaData_Notify, METH_VARARGS},
    {"SetHasTemporalExtents", avtDatabaseMetaData_SetHasTemporalExtents, METH_VARARGS},
    {"GetHasTemporalExtents", avtDatabaseMetaData_GetHasTemporalExtents, METH_VARARGS},
    {"SetMinTemporalExtents", avtDatabaseMetaData_SetMinTemporalExtents, METH_VARARGS},
    {"GetMinTemporalExtents", avtDatabaseMetaData_GetMinTemporalExtents, METH_VARARGS},
    {"SetMaxTemporalExtents", avtDatabaseMetaData_SetMaxTemporalExtents, METH_VARARGS},
    {"GetMaxTemporalExtents", avtDatabaseMetaData_GetMaxTemporalExtents, METH_VARARGS},
    {"SetNumStates", avtDatabaseMetaData_SetNumStates, METH_VARARGS},
    {"GetNumStates", avtDatabaseMetaData_GetNumStates, METH_VARARGS},
    {"SetIsVirtualDatabase", avtDatabaseMetaData_SetIsVirtualDatabase, METH_VARARGS},
    {"GetIsVirtualDatabase", avtDatabaseMetaData_GetIsVirtualDatabase, METH_VARARGS},
    {"SetMustRepopulateOnStateChange", avtDatabaseMetaData_SetMustRepopulateOnStateChange, METH_VARARGS},
    {"GetMustRepopulateOnStateChange", avtDatabaseMetaData_GetMustRepopulateOnStateChange, METH_VARARGS},
    {"SetMustAlphabetizeVariables", avtDatabaseMetaData_SetMustAlphabetizeVariables, METH_VARARGS},
    {"GetMustAlphabetizeVariables", avtDatabaseMetaData_GetMustAlphabetizeVariables, METH_VARARGS},
    {"SetFormatCanDoDomainDecomposition", avtDatabaseMetaData_SetFormatCanDoDomainDecomposition, METH_VARARGS},
    {"GetFormatCanDoDomainDecomposition", avtDatabaseMetaData_GetFormatCanDoDomainDecomposition, METH_VARARGS},
    {"SetFormatCanDoMultires", avtDatabaseMetaData_SetFormatCanDoMultires, METH_VARARGS},
    {"GetFormatCanDoMultires", avtDatabaseMetaData_GetFormatCanDoMultires, METH_VARARGS},
    {"SetUseCatchAllMesh", avtDatabaseMetaData_SetUseCatchAllMesh, METH_VARARGS},
    {"GetUseCatchAllMesh", avtDatabaseMetaData_GetUseCatchAllMesh, METH_VARARGS},
    {"SetTimeStepPath", avtDatabaseMetaData_SetTimeStepPath, METH_VARARGS},
    {"GetTimeStepPath", avtDatabaseMetaData_GetTimeStepPath, METH_VARARGS},
    {"SetTimeStepNames", avtDatabaseMetaData_SetTimeStepNames, METH_VARARGS},
    {"GetTimeStepNames", avtDatabaseMetaData_GetTimeStepNames, METH_VARARGS},
    {"SetCycles", avtDatabaseMetaData_SetCycles, METH_VARARGS},
    {"GetCycles", avtDatabaseMetaData_GetCycles, METH_VARARGS},
    {"SetCyclesAreAccurate", avtDatabaseMetaData_SetCyclesAreAccurate, METH_VARARGS},
    {"GetCyclesAreAccurate", avtDatabaseMetaData_GetCyclesAreAccurate, METH_VARARGS},
    {"SetTimes", avtDatabaseMetaData_SetTimes, METH_VARARGS},
    {"GetTimes", avtDatabaseMetaData_GetTimes, METH_VARARGS},
    {"SetTimesAreAccurate", avtDatabaseMetaData_SetTimesAreAccurate, METH_VARARGS},
    {"GetTimesAreAccurate", avtDatabaseMetaData_GetTimesAreAccurate, METH_VARARGS},
    {"SetDatabaseName", avtDatabaseMetaData_SetDatabaseName, METH_VARARGS},
    {"GetDatabaseName", avtDatabaseMetaData_GetDatabaseName, METH_VARARGS},
    {"SetFileFormat", avtDatabaseMetaData_SetFileFormat, METH_VARARGS},
    {"GetFileFormat", avtDatabaseMetaData_GetFileFormat, METH_VARARGS},
    {"SetDatabaseComment", avtDatabaseMetaData_SetDatabaseComment, METH_VARARGS},
    {"GetDatabaseComment", avtDatabaseMetaData_GetDatabaseComment, METH_VARARGS},
    {"SetExprList", avtDatabaseMetaData_SetExprList, METH_VARARGS},
    {"GetExprList", avtDatabaseMetaData_GetExprList, METH_VARARGS},
    {"GetMeshes", avtDatabaseMetaData_GetMeshes, METH_VARARGS},
    {"GetNumMeshes", avtDatabaseMetaData_GetNumMeshes, METH_VARARGS},
    {"AddMeshes", avtDatabaseMetaData_AddMeshes, METH_VARARGS},
    {"RemoveMeshes", avtDatabaseMetaData_RemoveMeshes, METH_VARARGS},
    {"ClearMeshes", avtDatabaseMetaData_ClearMeshes, METH_VARARGS},
    {"GetSubsets", avtDatabaseMetaData_GetSubsets, METH_VARARGS},
    {"GetNumSubsets", avtDatabaseMetaData_GetNumSubsets, METH_VARARGS},
    {"AddSubsets", avtDatabaseMetaData_AddSubsets, METH_VARARGS},
    {"RemoveSubsets", avtDatabaseMetaData_RemoveSubsets, METH_VARARGS},
    {"ClearSubsets", avtDatabaseMetaData_ClearSubsets, METH_VARARGS},
    {"GetScalars", avtDatabaseMetaData_GetScalars, METH_VARARGS},
    {"GetNumScalars", avtDatabaseMetaData_GetNumScalars, METH_VARARGS},
    {"AddScalars", avtDatabaseMetaData_AddScalars, METH_VARARGS},
    {"RemoveScalars", avtDatabaseMetaData_RemoveScalars, METH_VARARGS},
    {"ClearScalars", avtDatabaseMetaData_ClearScalars, METH_VARARGS},
    {"GetVectors", avtDatabaseMetaData_GetVectors, METH_VARARGS},
    {"GetNumVectors", avtDatabaseMetaData_GetNumVectors, METH_VARARGS},
    {"AddVectors", avtDatabaseMetaData_AddVectors, METH_VARARGS},
    {"RemoveVectors", avtDatabaseMetaData_RemoveVectors, METH_VARARGS},
    {"ClearVectors", avtDatabaseMetaData_ClearVectors, METH_VARARGS},
    {"GetTensors", avtDatabaseMetaData_GetTensors, METH_VARARGS},
    {"GetNumTensors", avtDatabaseMetaData_GetNumTensors, METH_VARARGS},
    {"AddTensors", avtDatabaseMetaData_AddTensors, METH_VARARGS},
    {"RemoveTensors", avtDatabaseMetaData_RemoveTensors, METH_VARARGS},
    {"ClearTensors", avtDatabaseMetaData_ClearTensors, METH_VARARGS},
    {"GetSymmTensors", avtDatabaseMetaData_GetSymmTensors, METH_VARARGS},
    {"GetNumSymmTensors", avtDatabaseMetaData_GetNumSymmTensors, METH_VARARGS},
    {"AddSymmTensors", avtDatabaseMetaData_AddSymmTensors, METH_VARARGS},
    {"RemoveSymmTensors", avtDatabaseMetaData_RemoveSymmTensors, METH_VARARGS},
    {"ClearSymmTensors", avtDatabaseMetaData_ClearSymmTensors, METH_VARARGS},
    {"GetArrays", avtDatabaseMetaData_GetArrays, METH_VARARGS},
    {"GetNumArrays", avtDatabaseMetaData_GetNumArrays, METH_VARARGS},
    {"AddArrays", avtDatabaseMetaData_AddArrays, METH_VARARGS},
    {"RemoveArrays", avtDatabaseMetaData_RemoveArrays, METH_VARARGS},
    {"ClearArrays", avtDatabaseMetaData_ClearArrays, METH_VARARGS},
    {"GetMaterials", avtDatabaseMetaData_GetMaterials, METH_VARARGS},
    {"GetNumMaterials", avtDatabaseMetaData_GetNumMaterials, METH_VARARGS},
    {"AddMaterials", avtDatabaseMetaData_AddMaterials, METH_VARARGS},
    {"RemoveMaterials", avtDatabaseMetaData_RemoveMaterials, METH_VARARGS},
    {"ClearMaterials", avtDatabaseMetaData_ClearMaterials, METH_VARARGS},
    {"GetSpecies", avtDatabaseMetaData_GetSpecies, METH_VARARGS},
    {"GetNumSpecies", avtDatabaseMetaData_GetNumSpecies, METH_VARARGS},
    {"AddSpecies", avtDatabaseMetaData_AddSpecies, METH_VARARGS},
    {"RemoveSpecies", avtDatabaseMetaData_RemoveSpecies, METH_VARARGS},
    {"ClearSpecies", avtDatabaseMetaData_ClearSpecies, METH_VARARGS},
    {"GetCurves", avtDatabaseMetaData_GetCurves, METH_VARARGS},
    {"GetNumCurves", avtDatabaseMetaData_GetNumCurves, METH_VARARGS},
    {"AddCurves", avtDatabaseMetaData_AddCurves, METH_VARARGS},
    {"RemoveCurves", avtDatabaseMetaData_RemoveCurves, METH_VARARGS},
    {"ClearCurves", avtDatabaseMetaData_ClearCurves, METH_VARARGS},
    {"GetLabels", avtDatabaseMetaData_GetLabels, METH_VARARGS},
    {"GetNumLabels", avtDatabaseMetaData_GetNumLabels, METH_VARARGS},
    {"AddLabels", avtDatabaseMetaData_AddLabels, METH_VARARGS},
    {"RemoveLabels", avtDatabaseMetaData_RemoveLabels, METH_VARARGS},
    {"ClearLabels", avtDatabaseMetaData_ClearLabels, METH_VARARGS},
    {"GetDefaultPlots", avtDatabaseMetaData_GetDefaultPlots, METH_VARARGS},
    {"GetNumDefaultPlots", avtDatabaseMetaData_GetNumDefaultPlots, METH_VARARGS},
    {"AddDefaultPlots", avtDatabaseMetaData_AddDefaultPlots, METH_VARARGS},
    {"RemoveDefaultPlots", avtDatabaseMetaData_RemoveDefaultPlots, METH_VARARGS},
    {"ClearDefaultPlots", avtDatabaseMetaData_ClearDefaultPlots, METH_VARARGS},
    {"SetIsSimulation", avtDatabaseMetaData_SetIsSimulation, METH_VARARGS},
    {"GetIsSimulation", avtDatabaseMetaData_GetIsSimulation, METH_VARARGS},
    {"SetSimInfo", avtDatabaseMetaData_SetSimInfo, METH_VARARGS},
    {"GetSimInfo", avtDatabaseMetaData_GetSimInfo, METH_VARARGS},
    {"SetSuggestedDefaultSILRestriction", avtDatabaseMetaData_SetSuggestedDefaultSILRestriction, METH_VARARGS},
    {"GetSuggestedDefaultSILRestriction", avtDatabaseMetaData_GetSuggestedDefaultSILRestriction, METH_VARARGS},
    {"SetReplacementMask", avtDatabaseMetaData_SetReplacementMask, METH_VARARGS},
    {"GetReplacementMask", avtDatabaseMetaData_GetReplacementMask, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtDatabaseMetaData_dealloc(PyObject *v)
{
   avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtDatabaseMetaData_compare(PyObject *v, PyObject *w)
{
    avtDatabaseMetaData *a = ((avtDatabaseMetaDataObject *)v)->data;
    avtDatabaseMetaData *b = ((avtDatabaseMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtDatabaseMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "hasTemporalExtents") == 0)
        return avtDatabaseMetaData_GetHasTemporalExtents(self, NULL);
    if(strcmp(name, "minTemporalExtents") == 0)
        return avtDatabaseMetaData_GetMinTemporalExtents(self, NULL);
    if(strcmp(name, "maxTemporalExtents") == 0)
        return avtDatabaseMetaData_GetMaxTemporalExtents(self, NULL);
    if(strcmp(name, "numStates") == 0)
        return avtDatabaseMetaData_GetNumStates(self, NULL);
    if(strcmp(name, "isVirtualDatabase") == 0)
        return avtDatabaseMetaData_GetIsVirtualDatabase(self, NULL);
    if(strcmp(name, "mustRepopulateOnStateChange") == 0)
        return avtDatabaseMetaData_GetMustRepopulateOnStateChange(self, NULL);
    if(strcmp(name, "mustAlphabetizeVariables") == 0)
        return avtDatabaseMetaData_GetMustAlphabetizeVariables(self, NULL);
    if(strcmp(name, "formatCanDoDomainDecomposition") == 0)
        return avtDatabaseMetaData_GetFormatCanDoDomainDecomposition(self, NULL);
    if(strcmp(name, "formatCanDoMultires") == 0)
        return avtDatabaseMetaData_GetFormatCanDoMultires(self, NULL);
    if(strcmp(name, "useCatchAllMesh") == 0)
        return avtDatabaseMetaData_GetUseCatchAllMesh(self, NULL);
    if(strcmp(name, "timeStepPath") == 0)
        return avtDatabaseMetaData_GetTimeStepPath(self, NULL);
    if(strcmp(name, "timeStepNames") == 0)
        return avtDatabaseMetaData_GetTimeStepNames(self, NULL);
    if(strcmp(name, "cycles") == 0)
        return avtDatabaseMetaData_GetCycles(self, NULL);
    if(strcmp(name, "cyclesAreAccurate") == 0)
        return avtDatabaseMetaData_GetCyclesAreAccurate(self, NULL);
    if(strcmp(name, "times") == 0)
        return avtDatabaseMetaData_GetTimes(self, NULL);
    if(strcmp(name, "timesAreAccurate") == 0)
        return avtDatabaseMetaData_GetTimesAreAccurate(self, NULL);
    if(strcmp(name, "databaseName") == 0)
        return avtDatabaseMetaData_GetDatabaseName(self, NULL);
    if(strcmp(name, "fileFormat") == 0)
        return avtDatabaseMetaData_GetFileFormat(self, NULL);
    if(strcmp(name, "databaseComment") == 0)
        return avtDatabaseMetaData_GetDatabaseComment(self, NULL);
    if(strcmp(name, "exprList") == 0)
        return avtDatabaseMetaData_GetExprList(self, NULL);
    if(strcmp(name, "meshes") == 0)
        return avtDatabaseMetaData_GetMeshes(self, NULL);
    if(strcmp(name, "subsets") == 0)
        return avtDatabaseMetaData_GetSubsets(self, NULL);
    if(strcmp(name, "scalars") == 0)
        return avtDatabaseMetaData_GetScalars(self, NULL);
    if(strcmp(name, "vectors") == 0)
        return avtDatabaseMetaData_GetVectors(self, NULL);
    if(strcmp(name, "tensors") == 0)
        return avtDatabaseMetaData_GetTensors(self, NULL);
    if(strcmp(name, "symmTensors") == 0)
        return avtDatabaseMetaData_GetSymmTensors(self, NULL);
    if(strcmp(name, "arrays") == 0)
        return avtDatabaseMetaData_GetArrays(self, NULL);
    if(strcmp(name, "materials") == 0)
        return avtDatabaseMetaData_GetMaterials(self, NULL);
    if(strcmp(name, "species") == 0)
        return avtDatabaseMetaData_GetSpecies(self, NULL);
    if(strcmp(name, "curves") == 0)
        return avtDatabaseMetaData_GetCurves(self, NULL);
    if(strcmp(name, "labels") == 0)
        return avtDatabaseMetaData_GetLabels(self, NULL);
    if(strcmp(name, "defaultPlots") == 0)
        return avtDatabaseMetaData_GetDefaultPlots(self, NULL);
    if(strcmp(name, "isSimulation") == 0)
        return avtDatabaseMetaData_GetIsSimulation(self, NULL);
    if(strcmp(name, "simInfo") == 0)
        return avtDatabaseMetaData_GetSimInfo(self, NULL);
    if(strcmp(name, "suggestedDefaultSILRestriction") == 0)
        return avtDatabaseMetaData_GetSuggestedDefaultSILRestriction(self, NULL);
    if(strcmp(name, "replacementMask") == 0)
        return avtDatabaseMetaData_GetReplacementMask(self, NULL);

    return Py_FindMethod(PyavtDatabaseMetaData_methods, self, name);
}

int
PyavtDatabaseMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "hasTemporalExtents") == 0)
        obj = avtDatabaseMetaData_SetHasTemporalExtents(self, tuple);
    else if(strcmp(name, "minTemporalExtents") == 0)
        obj = avtDatabaseMetaData_SetMinTemporalExtents(self, tuple);
    else if(strcmp(name, "maxTemporalExtents") == 0)
        obj = avtDatabaseMetaData_SetMaxTemporalExtents(self, tuple);
    else if(strcmp(name, "numStates") == 0)
        obj = avtDatabaseMetaData_SetNumStates(self, tuple);
    else if(strcmp(name, "isVirtualDatabase") == 0)
        obj = avtDatabaseMetaData_SetIsVirtualDatabase(self, tuple);
    else if(strcmp(name, "mustRepopulateOnStateChange") == 0)
        obj = avtDatabaseMetaData_SetMustRepopulateOnStateChange(self, tuple);
    else if(strcmp(name, "mustAlphabetizeVariables") == 0)
        obj = avtDatabaseMetaData_SetMustAlphabetizeVariables(self, tuple);
    else if(strcmp(name, "formatCanDoDomainDecomposition") == 0)
        obj = avtDatabaseMetaData_SetFormatCanDoDomainDecomposition(self, tuple);
    else if(strcmp(name, "formatCanDoMultires") == 0)
        obj = avtDatabaseMetaData_SetFormatCanDoMultires(self, tuple);
    else if(strcmp(name, "useCatchAllMesh") == 0)
        obj = avtDatabaseMetaData_SetUseCatchAllMesh(self, tuple);
    else if(strcmp(name, "timeStepPath") == 0)
        obj = avtDatabaseMetaData_SetTimeStepPath(self, tuple);
    else if(strcmp(name, "timeStepNames") == 0)
        obj = avtDatabaseMetaData_SetTimeStepNames(self, tuple);
    else if(strcmp(name, "cycles") == 0)
        obj = avtDatabaseMetaData_SetCycles(self, tuple);
    else if(strcmp(name, "cyclesAreAccurate") == 0)
        obj = avtDatabaseMetaData_SetCyclesAreAccurate(self, tuple);
    else if(strcmp(name, "times") == 0)
        obj = avtDatabaseMetaData_SetTimes(self, tuple);
    else if(strcmp(name, "timesAreAccurate") == 0)
        obj = avtDatabaseMetaData_SetTimesAreAccurate(self, tuple);
    else if(strcmp(name, "databaseName") == 0)
        obj = avtDatabaseMetaData_SetDatabaseName(self, tuple);
    else if(strcmp(name, "fileFormat") == 0)
        obj = avtDatabaseMetaData_SetFileFormat(self, tuple);
    else if(strcmp(name, "databaseComment") == 0)
        obj = avtDatabaseMetaData_SetDatabaseComment(self, tuple);
    else if(strcmp(name, "exprList") == 0)
        obj = avtDatabaseMetaData_SetExprList(self, tuple);
    else if(strcmp(name, "isSimulation") == 0)
        obj = avtDatabaseMetaData_SetIsSimulation(self, tuple);
    else if(strcmp(name, "simInfo") == 0)
        obj = avtDatabaseMetaData_SetSimInfo(self, tuple);
    else if(strcmp(name, "suggestedDefaultSILRestriction") == 0)
        obj = avtDatabaseMetaData_SetSuggestedDefaultSILRestriction(self, tuple);
    else if(strcmp(name, "replacementMask") == 0)
        obj = avtDatabaseMetaData_SetReplacementMask(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtDatabaseMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)v;
    fprintf(fp, "%s", PyavtDatabaseMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtDatabaseMetaData_str(PyObject *v)
{
    avtDatabaseMetaDataObject *obj = (avtDatabaseMetaDataObject *)v;
    return PyString_FromString(PyavtDatabaseMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtDatabaseMetaData_Purpose = "Contains database metadata attributes";
#else
static char *avtDatabaseMetaData_Purpose = "Contains database metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtDatabaseMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtDatabaseMetaData",                    // tp_name
    sizeof(avtDatabaseMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtDatabaseMetaData_dealloc,  // tp_dealloc
    (printfunc)avtDatabaseMetaData_print,     // tp_print
    (getattrfunc)PyavtDatabaseMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtDatabaseMetaData_setattr, // tp_setattr
    (cmpfunc)avtDatabaseMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtDatabaseMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtDatabaseMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtDatabaseMetaData *defaultAtts = 0;
static avtDatabaseMetaData *currentAtts = 0;

static PyObject *
NewavtDatabaseMetaData(int useCurrent)
{
    avtDatabaseMetaDataObject *newObject;
    newObject = PyObject_NEW(avtDatabaseMetaDataObject, &avtDatabaseMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtDatabaseMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtDatabaseMetaData(*defaultAtts);
    else
        newObject->data = new avtDatabaseMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtDatabaseMetaData(const avtDatabaseMetaData *attr)
{
    avtDatabaseMetaDataObject *newObject;
    newObject = PyObject_NEW(avtDatabaseMetaDataObject, &avtDatabaseMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtDatabaseMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtDatabaseMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtDatabaseMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtDatabaseMetaDataMethods[] = {
    {"avtDatabaseMetaData", avtDatabaseMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtDatabaseMetaDataObserver = 0;

std::string
PyavtDatabaseMetaData_GetLogString()
{
    std::string s("avtDatabaseMetaData = avtDatabaseMetaData()\n");
    if(currentAtts != 0)
        s += PyavtDatabaseMetaData_ToString(currentAtts, "avtDatabaseMetaData.");
    return s;
}

static void
PyavtDatabaseMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtDatabaseMetaData = avtDatabaseMetaData()\n");
        s += PyavtDatabaseMetaData_ToString(currentAtts, "avtDatabaseMetaData.");
        cb(s);
    }
}

void
PyavtDatabaseMetaData_StartUp(avtDatabaseMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtDatabaseMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtDatabaseMetaDataObserver == 0)
    {
        avtDatabaseMetaDataObserver = new ObserverToCallback(subj,
            PyavtDatabaseMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtDatabaseMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtDatabaseMetaDataObserver;
    avtDatabaseMetaDataObserver = 0;
}

PyMethodDef *
PyavtDatabaseMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtDatabaseMetaDataMethods;
}

bool
PyavtDatabaseMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtDatabaseMetaDataType);
}

avtDatabaseMetaData *
PyavtDatabaseMetaData_FromPyObject(PyObject *obj)
{
    avtDatabaseMetaDataObject *obj2 = (avtDatabaseMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtDatabaseMetaData_New()
{
    return NewavtDatabaseMetaData(0);
}

PyObject *
PyavtDatabaseMetaData_Wrap(const avtDatabaseMetaData *attr)
{
    return WrapavtDatabaseMetaData(attr);
}

void
PyavtDatabaseMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtDatabaseMetaDataObject *obj2 = (avtDatabaseMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtDatabaseMetaData_SetDefaults(const avtDatabaseMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtDatabaseMetaData(*atts);
}

