/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyViewerRPC.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyViewerRPC
//
// Purpose: 
//   This class contains the attributes for controlling the viewer.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewerRPC.
//
struct ViewerRPCObject
{
    PyObject_HEAD
    ViewerRPC *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewViewerRPC(int);

std::string
PyViewerRPC_ToString(const ViewerRPC *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *RPCType_names = "CloseRPC, DetachRPC, AddWindowRPC, DeleteWindowRPC, SetWindowLayoutRPC, "
        "SetActiveWindowRPC, ClearWindowRPC, ClearAllWindowsRPC, OpenDatabaseRPC, "
        "CloseDatabaseRPC, ActivateDatabaseRPC, CheckForNewStatesRPC, CreateDatabaseCorrelationRPC, "
        "AlterDatabaseCorrelationRPC, DeleteDatabaseCorrelationRPC, ReOpenDatabaseRPC, ReplaceDatabaseRPC, "
        "OverlayDatabaseRPC, OpenComputeEngineRPC, CloseComputeEngineRPC, AnimationSetNFramesRPC, "
        "AnimationPlayRPC, AnimationReversePlayRPC, AnimationStopRPC, TimeSliderNextStateRPC, "
        "TimeSliderPreviousStateRPC, SetTimeSliderStateRPC, SetActiveTimeSliderRPC, AddPlotRPC, "
        "AddEmbeddedPlotRPC, SetPlotFrameRangeRPC, DeletePlotKeyframeRPC, MovePlotKeyframeRPC, "
        "DeleteActivePlotsRPC, HideActivePlotsRPC, DrawPlotsRPC, DisableRedrawRPC, "
        "RedrawRPC, SetActivePlotsRPC, ChangeActivePlotsVarRPC, AddOperatorRPC, "
        "AddInitializedOperatorRPC, PromoteOperatorRPC, DemoteOperatorRPC, RemoveOperatorRPC, "
        "RemoveLastOperatorRPC, RemoveAllOperatorsRPC, SaveWindowRPC, SetDefaultPlotOptionsRPC, "
        "SetPlotOptionsRPC, SetDefaultOperatorOptionsRPC, SetOperatorOptionsRPC, WriteConfigFileRPC, "
        "ConnectToMetaDataServerRPC, IconifyAllWindowsRPC, DeIconifyAllWindowsRPC, ShowAllWindowsRPC, "
        "HideAllWindowsRPC, UpdateColorTableRPC, SetAnnotationAttributesRPC, SetDefaultAnnotationAttributesRPC, "
        "ResetAnnotationAttributesRPC, SetKeyframeAttributesRPC, SetPlotSILRestrictionRPC, SetViewAxisArrayRPC, "
        "SetViewCurveRPC, SetView2DRPC, SetView3DRPC, ResetPlotOptionsRPC, "
        "ResetOperatorOptionsRPC, SetAppearanceRPC, ProcessExpressionsRPC, SetLightListRPC, "
        "SetDefaultLightListRPC, ResetLightListRPC, SetAnimationAttributesRPC, SetWindowAreaRPC, "
        "PrintWindowRPC, ResetViewRPC, RecenterViewRPC, ToggleAllowPopupRPC, "
        "ToggleMaintainViewModeRPC, ToggleBoundingBoxModeRPC, ToggleCameraViewModeRPC, TogglePerspectiveViewRPC, "
        "ToggleSpinModeRPC, ToggleLockTimeRPC, ToggleLockToolsRPC, ToggleLockViewModeRPC, "
        "ToggleFullFrameRPC, UndoViewRPC, RedoViewRPC, InvertBackgroundRPC, "
        "ClearPickPointsRPC, SetWindowModeRPC, EnableToolRPC, SetToolUpdateModeRPC, "
        "CopyViewToWindowRPC, CopyLightingToWindowRPC, CopyAnnotationsToWindowRPC, CopyPlotsToWindowRPC, "
        "ClearCacheRPC, ClearCacheForAllEnginesRPC, SetViewExtentsTypeRPC, ClearRefLinesRPC, "
        "SetRenderingAttributesRPC, QueryRPC, CloneWindowRPC, SetMaterialAttributesRPC, "
        "SetDefaultMaterialAttributesRPC, ResetMaterialAttributesRPC, SetPlotDatabaseStateRPC, DeletePlotDatabaseKeyframeRPC, "
        "MovePlotDatabaseKeyframeRPC, ClearViewKeyframesRPC, DeleteViewKeyframeRPC, MoveViewKeyframeRPC, "
        "SetViewKeyframeRPC, OpenMDServerRPC, EnableToolbarRPC, HideToolbarsRPC, "
        "HideToolbarsForAllWindowsRPC, ShowToolbarsRPC, ShowToolbarsForAllWindowsRPC, SetToolbarIconSizeRPC, "
        "SaveViewRPC, SetGlobalLineoutAttributesRPC, SetPickAttributesRPC, ExportColorTableRPC, "
        "ExportEntireStateRPC, ImportEntireStateRPC, ImportEntireStateWithDifferentSourcesRPC, ResetPickAttributesRPC, "
        "AddAnnotationObjectRPC, HideActiveAnnotationObjectsRPC, DeleteActiveAnnotationObjectsRPC, RaiseActiveAnnotationObjectsRPC, "
        "LowerActiveAnnotationObjectsRPC, SetAnnotationObjectOptionsRPC, SetDefaultAnnotationObjectListRPC, ResetAnnotationObjectListRPC, "
        "ResetPickLetterRPC, SetDefaultPickAttributesRPC, ChooseCenterOfRotationRPC, SetCenterOfRotationRPC, "
        "SetQueryOverTimeAttributesRPC, SetDefaultQueryOverTimeAttributesRPC, ResetQueryOverTimeAttributesRPC, ResetLineoutColorRPC, "
        "SetInteractorAttributesRPC, SetDefaultInteractorAttributesRPC, ResetInteractorAttributesRPC, GetProcInfoRPC, "
        "SendSimulationCommandRPC, UpdateDBPluginInfoRPC, ExportDBRPC, SetTryHarderCyclesTimesRPC, "
        "OpenClientRPC, OpenGUIClientRPC, OpenCLIClientRPC, SuppressQueryOutputRPC, "
        "SetQueryFloatFormatRPC, SetMeshManagementAttributesRPC, SetDefaultMeshManagementAttributesRPC, ResetMeshManagementAttributesRPC, "
        "ResizeWindowRPC, MoveWindowRPC, MoveAndResizeWindowRPC, SetStateLoggingRPC, "
        "ConstructDataBinningRPC, RequestMetaDataRPC, SetTreatAllDBsAsTimeVaryingRPC, SetCreateMeshQualityExpressionsRPC, "
        "SetCreateTimeDerivativeExpressionsRPC, SetCreateVectorMagnitudeExpressionsRPC, SetPrecisionTypeRPC, SetBackendTypeRPC, "
        "CopyActivePlotsRPC, SetPlotFollowsTimeRPC, TurnOffAllLocksRPC, SetDefaultFileOpenOptionsRPC, "
        "SetSuppressMessagesRPC, ApplyNamedSelectionRPC, CreateNamedSelectionRPC, DeleteNamedSelectionRPC, "
        "LoadNamedSelectionRPC, SaveNamedSelectionRPC, SetNamedSelectionAutoApplyRPC, UpdateNamedSelectionRPC, "
        "InitializeNamedSelectionVariablesRPC, MenuQuitRPC, SetPlotDescriptionRPC, MovePlotOrderTowardFirstRPC, "
        "MovePlotOrderTowardLastRPC, SetPlotOrderToFirstRPC, SetPlotOrderToLastRPC, RenamePickLabelRPC, "
        "GetQueryParametersRPC, DDTConnectRPC, DDTFocusRPC, ReleaseToDDTRPC, "
        "PlotDDTVispointVariablesRPC, ExportRPC, ExportHostProfileRPC, ReadHostProfilesFromDirectoryRPC, "
        "SetRemoveDuplicateNodesRPC, MaxRPC";
    switch (atts->GetRPCType())
    {
      case ViewerRPC::CloseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCloseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DetachRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDetachRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetWindowLayoutRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetWindowLayoutRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetActiveWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetActiveWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CloseDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCloseDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ActivateDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sActivateDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CheckForNewStatesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCheckForNewStatesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CreateDatabaseCorrelationRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCreateDatabaseCorrelationRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AlterDatabaseCorrelationRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAlterDatabaseCorrelationRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteDatabaseCorrelationRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteDatabaseCorrelationRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ReOpenDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sReOpenDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ReplaceDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sReplaceDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OverlayDatabaseRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOverlayDatabaseRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenComputeEngineRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenComputeEngineRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CloseComputeEngineRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCloseComputeEngineRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AnimationSetNFramesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAnimationSetNFramesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AnimationPlayRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAnimationPlayRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AnimationReversePlayRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAnimationReversePlayRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AnimationStopRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAnimationStopRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::TimeSliderNextStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sTimeSliderNextStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::TimeSliderPreviousStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sTimeSliderPreviousStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetTimeSliderStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetTimeSliderStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetActiveTimeSliderRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetActiveTimeSliderRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddPlotRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddPlotRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddEmbeddedPlotRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddEmbeddedPlotRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotFrameRangeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotFrameRangeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeletePlotKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeletePlotKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MovePlotKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMovePlotKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteActivePlotsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteActivePlotsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::HideActivePlotsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sHideActivePlotsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DrawPlotsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDrawPlotsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DisableRedrawRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDisableRedrawRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RedrawRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRedrawRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetActivePlotsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetActivePlotsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ChangeActivePlotsVarRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sChangeActivePlotsVarRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddInitializedOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddInitializedOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::PromoteOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sPromoteOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DemoteOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDemoteOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RemoveOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRemoveOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RemoveLastOperatorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRemoveLastOperatorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RemoveAllOperatorsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRemoveAllOperatorsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SaveWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSaveWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultPlotOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultPlotOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultOperatorOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultOperatorOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetOperatorOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetOperatorOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::WriteConfigFileRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sWriteConfigFileRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ConnectToMetaDataServerRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sConnectToMetaDataServerRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::IconifyAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sIconifyAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeIconifyAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeIconifyAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ShowAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sShowAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::HideAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sHideAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::UpdateColorTableRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sUpdateColorTableRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetAnnotationAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetAnnotationAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultAnnotationAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultAnnotationAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetAnnotationAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetAnnotationAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetKeyframeAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetKeyframeAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotSILRestrictionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotSILRestrictionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetViewAxisArrayRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetViewAxisArrayRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetViewCurveRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetViewCurveRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetView2DRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetView2DRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetView3DRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetView3DRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetPlotOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetPlotOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetOperatorOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetOperatorOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetAppearanceRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetAppearanceRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ProcessExpressionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sProcessExpressionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetLightListRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetLightListRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultLightListRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultLightListRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetLightListRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetLightListRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetAnimationAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetAnimationAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetWindowAreaRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetWindowAreaRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::PrintWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sPrintWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RecenterViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRecenterViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleAllowPopupRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleAllowPopupRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleMaintainViewModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleMaintainViewModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleBoundingBoxModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleBoundingBoxModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleCameraViewModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleCameraViewModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::TogglePerspectiveViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sTogglePerspectiveViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleSpinModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleSpinModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleLockTimeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleLockTimeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleLockToolsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleLockToolsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleLockViewModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleLockViewModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ToggleFullFrameRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sToggleFullFrameRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::UndoViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sUndoViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RedoViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRedoViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::InvertBackgroundRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sInvertBackgroundRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearPickPointsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearPickPointsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetWindowModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetWindowModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::EnableToolRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sEnableToolRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetToolUpdateModeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetToolUpdateModeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CopyViewToWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCopyViewToWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CopyLightingToWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCopyLightingToWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CopyAnnotationsToWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCopyAnnotationsToWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CopyPlotsToWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCopyPlotsToWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearCacheRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearCacheRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearCacheForAllEnginesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearCacheForAllEnginesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetViewExtentsTypeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetViewExtentsTypeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearRefLinesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearRefLinesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetRenderingAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetRenderingAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::QueryRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sQueryRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CloneWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCloneWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetMaterialAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetMaterialAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultMaterialAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultMaterialAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetMaterialAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetMaterialAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotDatabaseStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotDatabaseStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeletePlotDatabaseKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeletePlotDatabaseKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MovePlotDatabaseKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMovePlotDatabaseKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ClearViewKeyframesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sClearViewKeyframesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteViewKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteViewKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MoveViewKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMoveViewKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetViewKeyframeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetViewKeyframeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenMDServerRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenMDServerRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::EnableToolbarRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sEnableToolbarRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::HideToolbarsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sHideToolbarsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::HideToolbarsForAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sHideToolbarsForAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ShowToolbarsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sShowToolbarsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ShowToolbarsForAllWindowsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sShowToolbarsForAllWindowsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetToolbarIconSizeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetToolbarIconSizeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SaveViewRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSaveViewRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetGlobalLineoutAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetGlobalLineoutAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPickAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPickAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ExportColorTableRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sExportColorTableRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ExportEntireStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sExportEntireStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ImportEntireStateRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sImportEntireStateRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ImportEntireStateWithDifferentSourcesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sImportEntireStateWithDifferentSourcesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetPickAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetPickAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::AddAnnotationObjectRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sAddAnnotationObjectRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::HideActiveAnnotationObjectsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sHideActiveAnnotationObjectsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteActiveAnnotationObjectsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteActiveAnnotationObjectsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RaiseActiveAnnotationObjectsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRaiseActiveAnnotationObjectsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::LowerActiveAnnotationObjectsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sLowerActiveAnnotationObjectsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetAnnotationObjectOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetAnnotationObjectOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultAnnotationObjectListRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultAnnotationObjectListRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetAnnotationObjectListRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetAnnotationObjectListRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetPickLetterRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetPickLetterRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultPickAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultPickAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ChooseCenterOfRotationRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sChooseCenterOfRotationRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetCenterOfRotationRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetCenterOfRotationRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetQueryOverTimeAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetQueryOverTimeAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultQueryOverTimeAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultQueryOverTimeAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetQueryOverTimeAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetQueryOverTimeAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetLineoutColorRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetLineoutColorRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetInteractorAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetInteractorAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultInteractorAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultInteractorAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetInteractorAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetInteractorAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::GetProcInfoRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sGetProcInfoRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SendSimulationCommandRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSendSimulationCommandRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::UpdateDBPluginInfoRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sUpdateDBPluginInfoRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ExportDBRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sExportDBRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetTryHarderCyclesTimesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetTryHarderCyclesTimesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenClientRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenClientRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenGUIClientRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenGUIClientRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::OpenCLIClientRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sOpenCLIClientRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SuppressQueryOutputRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSuppressQueryOutputRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetQueryFloatFormatRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetQueryFloatFormatRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetMeshManagementAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetMeshManagementAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultMeshManagementAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultMeshManagementAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResetMeshManagementAttributesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResetMeshManagementAttributesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ResizeWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sResizeWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MoveWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMoveWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MoveAndResizeWindowRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMoveAndResizeWindowRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetStateLoggingRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetStateLoggingRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ConstructDataBinningRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sConstructDataBinningRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RequestMetaDataRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRequestMetaDataRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetTreatAllDBsAsTimeVaryingRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetTreatAllDBsAsTimeVaryingRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetCreateMeshQualityExpressionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetCreateMeshQualityExpressionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetCreateTimeDerivativeExpressionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetCreateTimeDerivativeExpressionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetCreateVectorMagnitudeExpressionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetCreateVectorMagnitudeExpressionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPrecisionTypeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPrecisionTypeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetBackendTypeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetBackendTypeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CopyActivePlotsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCopyActivePlotsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotFollowsTimeRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotFollowsTimeRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::TurnOffAllLocksRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sTurnOffAllLocksRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetDefaultFileOpenOptionsRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetDefaultFileOpenOptionsRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetSuppressMessagesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetSuppressMessagesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ApplyNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sApplyNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::CreateNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sCreateNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DeleteNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDeleteNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::LoadNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sLoadNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SaveNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSaveNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetNamedSelectionAutoApplyRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetNamedSelectionAutoApplyRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::UpdateNamedSelectionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sUpdateNamedSelectionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::InitializeNamedSelectionVariablesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sInitializeNamedSelectionVariablesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MenuQuitRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMenuQuitRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotDescriptionRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotDescriptionRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MovePlotOrderTowardFirstRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMovePlotOrderTowardFirstRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MovePlotOrderTowardLastRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMovePlotOrderTowardLastRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotOrderToFirstRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotOrderToFirstRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetPlotOrderToLastRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetPlotOrderToLastRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::RenamePickLabelRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sRenamePickLabelRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::GetQueryParametersRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sGetQueryParametersRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DDTConnectRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDDTConnectRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::DDTFocusRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sDDTFocusRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ReleaseToDDTRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sReleaseToDDTRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::PlotDDTVispointVariablesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sPlotDDTVispointVariablesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ExportRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sExportRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ExportHostProfileRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sExportHostProfileRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::ReadHostProfilesFromDirectoryRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sReadHostProfilesFromDirectoryRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::SetRemoveDuplicateNodesRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sSetRemoveDuplicateNodesRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      case ViewerRPC::MaxRPC:
          SNPRINTF(tmpStr, 1000, "%sRPCType = %sMaxRPC  # %s\n", prefix, prefix, RPCType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%swindowLayout = %d\n", prefix, atts->GetWindowLayout());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowId = %d\n", prefix, atts->GetWindowId());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowMode = %d\n", prefix, atts->GetWindowMode());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowArea = \"%s\"\n", prefix, atts->GetWindowArea().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdatabase = \"%s\"\n", prefix, atts->GetDatabase().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sprogramHost = \"%s\"\n", prefix, atts->GetProgramHost().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sprogramSim = \"%s\"\n", prefix, atts->GetProgramSim().c_str());
    str += tmpStr;
    {   const stringVector &programOptions = atts->GetProgramOptions();
        SNPRINTF(tmpStr, 1000, "%sprogramOptions = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < programOptions.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", programOptions[i].c_str());
            str += tmpStr;
            if(i < programOptions.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%snFrames = %d\n", prefix, atts->GetNFrames());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstateNumber = %d\n", prefix, atts->GetStateNumber());
    str += tmpStr;
    {   const int *frameRange = atts->GetFrameRange();
        SNPRINTF(tmpStr, 1000, "%sframeRange = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", frameRange[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sframe = %d\n", prefix, atts->GetFrame());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%splotType = %d\n", prefix, atts->GetPlotType());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soperatorType = %d\n", prefix, atts->GetOperatorType());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    {   const intVector &activePlotIds = atts->GetActivePlotIds();
        SNPRINTF(tmpStr, 1000, "%sactivePlotIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < activePlotIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", activePlotIds[i]);
            str += tmpStr;
            if(i < activePlotIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &activeOperatorIds = atts->GetActiveOperatorIds();
        SNPRINTF(tmpStr, 1000, "%sactiveOperatorIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < activeOperatorIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", activeOperatorIds[i]);
            str += tmpStr;
            if(i < activeOperatorIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &expandedPlotIds = atts->GetExpandedPlotIds();
        SNPRINTF(tmpStr, 1000, "%sexpandedPlotIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < expandedPlotIds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", expandedPlotIds[i]);
            str += tmpStr;
            if(i < expandedPlotIds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squeryName = \"%s\"\n", prefix, atts->GetQueryName().c_str());
    str += tmpStr;
    {   const double *queryPoint1 = atts->GetQueryPoint1();
        SNPRINTF(tmpStr, 1000, "%squeryPoint1 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", queryPoint1[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%stoolId = %d\n", prefix, atts->GetToolId());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sembeddedPlotId = %d\n", prefix, atts->GetEmbeddedPlotId());
    str += tmpStr;
    if(atts->GetBoolFlag())
        SNPRINTF(tmpStr, 1000, "%sboolFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sboolFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sintArg1 = %d\n", prefix, atts->GetIntArg1());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sintArg2 = %d\n", prefix, atts->GetIntArg2());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sintArg3 = %d\n", prefix, atts->GetIntArg3());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstringArg1 = \"%s\"\n", prefix, atts->GetStringArg1().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstringArg2 = \"%s\"\n", prefix, atts->GetStringArg2().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stoolUpdateMode = %d\n", prefix, atts->GetToolUpdateMode());
    str += tmpStr;
    //queryParams
    return str;
}

static PyObject *
ViewerRPC_Notify(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_SetRPCType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the RPCType in the object.
    if(ival >= 0 && ival < 207)
        obj->data->SetRPCType(ViewerRPC::ViewerRPCType(ival));
    else
    {
        fprintf(stderr, "An invalid RPCType value was given. "
                        "Valid values are in the range of [0,206]. "
                        "You can also use the following names: "
                        "CloseRPC, DetachRPC, AddWindowRPC, DeleteWindowRPC, SetWindowLayoutRPC, "
                        "SetActiveWindowRPC, ClearWindowRPC, ClearAllWindowsRPC, OpenDatabaseRPC, "
                        "CloseDatabaseRPC, ActivateDatabaseRPC, CheckForNewStatesRPC, CreateDatabaseCorrelationRPC, "
                        "AlterDatabaseCorrelationRPC, DeleteDatabaseCorrelationRPC, ReOpenDatabaseRPC, ReplaceDatabaseRPC, "
                        "OverlayDatabaseRPC, OpenComputeEngineRPC, CloseComputeEngineRPC, AnimationSetNFramesRPC, "
                        "AnimationPlayRPC, AnimationReversePlayRPC, AnimationStopRPC, TimeSliderNextStateRPC, "
                        "TimeSliderPreviousStateRPC, SetTimeSliderStateRPC, SetActiveTimeSliderRPC, AddPlotRPC, "
                        "AddEmbeddedPlotRPC, SetPlotFrameRangeRPC, DeletePlotKeyframeRPC, MovePlotKeyframeRPC, "
                        "DeleteActivePlotsRPC, HideActivePlotsRPC, DrawPlotsRPC, DisableRedrawRPC, "
                        "RedrawRPC, SetActivePlotsRPC, ChangeActivePlotsVarRPC, AddOperatorRPC, "
                        "AddInitializedOperatorRPC, PromoteOperatorRPC, DemoteOperatorRPC, RemoveOperatorRPC, "
                        "RemoveLastOperatorRPC, RemoveAllOperatorsRPC, SaveWindowRPC, SetDefaultPlotOptionsRPC, "
                        "SetPlotOptionsRPC, SetDefaultOperatorOptionsRPC, SetOperatorOptionsRPC, WriteConfigFileRPC, "
                        "ConnectToMetaDataServerRPC, IconifyAllWindowsRPC, DeIconifyAllWindowsRPC, ShowAllWindowsRPC, "
                        "HideAllWindowsRPC, UpdateColorTableRPC, SetAnnotationAttributesRPC, SetDefaultAnnotationAttributesRPC, "
                        "ResetAnnotationAttributesRPC, SetKeyframeAttributesRPC, SetPlotSILRestrictionRPC, SetViewAxisArrayRPC, "
                        "SetViewCurveRPC, SetView2DRPC, SetView3DRPC, ResetPlotOptionsRPC, "
                        "ResetOperatorOptionsRPC, SetAppearanceRPC, ProcessExpressionsRPC, SetLightListRPC, "
                        "SetDefaultLightListRPC, ResetLightListRPC, SetAnimationAttributesRPC, SetWindowAreaRPC, "
                        "PrintWindowRPC, ResetViewRPC, RecenterViewRPC, ToggleAllowPopupRPC, "
                        "ToggleMaintainViewModeRPC, ToggleBoundingBoxModeRPC, ToggleCameraViewModeRPC, TogglePerspectiveViewRPC, "
                        "ToggleSpinModeRPC, ToggleLockTimeRPC, ToggleLockToolsRPC, ToggleLockViewModeRPC, "
                        "ToggleFullFrameRPC, UndoViewRPC, RedoViewRPC, InvertBackgroundRPC, "
                        "ClearPickPointsRPC, SetWindowModeRPC, EnableToolRPC, SetToolUpdateModeRPC, "
                        "CopyViewToWindowRPC, CopyLightingToWindowRPC, CopyAnnotationsToWindowRPC, CopyPlotsToWindowRPC, "
                        "ClearCacheRPC, ClearCacheForAllEnginesRPC, SetViewExtentsTypeRPC, ClearRefLinesRPC, "
                        "SetRenderingAttributesRPC, QueryRPC, CloneWindowRPC, SetMaterialAttributesRPC, "
                        "SetDefaultMaterialAttributesRPC, ResetMaterialAttributesRPC, SetPlotDatabaseStateRPC, DeletePlotDatabaseKeyframeRPC, "
                        "MovePlotDatabaseKeyframeRPC, ClearViewKeyframesRPC, DeleteViewKeyframeRPC, MoveViewKeyframeRPC, "
                        "SetViewKeyframeRPC, OpenMDServerRPC, EnableToolbarRPC, HideToolbarsRPC, "
                        "HideToolbarsForAllWindowsRPC, ShowToolbarsRPC, ShowToolbarsForAllWindowsRPC, SetToolbarIconSizeRPC, "
                        "SaveViewRPC, SetGlobalLineoutAttributesRPC, SetPickAttributesRPC, ExportColorTableRPC, "
                        "ExportEntireStateRPC, ImportEntireStateRPC, ImportEntireStateWithDifferentSourcesRPC, ResetPickAttributesRPC, "
                        "AddAnnotationObjectRPC, HideActiveAnnotationObjectsRPC, DeleteActiveAnnotationObjectsRPC, RaiseActiveAnnotationObjectsRPC, "
                        "LowerActiveAnnotationObjectsRPC, SetAnnotationObjectOptionsRPC, SetDefaultAnnotationObjectListRPC, ResetAnnotationObjectListRPC, "
                        "ResetPickLetterRPC, SetDefaultPickAttributesRPC, ChooseCenterOfRotationRPC, SetCenterOfRotationRPC, "
                        "SetQueryOverTimeAttributesRPC, SetDefaultQueryOverTimeAttributesRPC, ResetQueryOverTimeAttributesRPC, ResetLineoutColorRPC, "
                        "SetInteractorAttributesRPC, SetDefaultInteractorAttributesRPC, ResetInteractorAttributesRPC, GetProcInfoRPC, "
                        "SendSimulationCommandRPC, UpdateDBPluginInfoRPC, ExportDBRPC, SetTryHarderCyclesTimesRPC, "
                        "OpenClientRPC, OpenGUIClientRPC, OpenCLIClientRPC, SuppressQueryOutputRPC, "
                        "SetQueryFloatFormatRPC, SetMeshManagementAttributesRPC, SetDefaultMeshManagementAttributesRPC, ResetMeshManagementAttributesRPC, "
                        "ResizeWindowRPC, MoveWindowRPC, MoveAndResizeWindowRPC, SetStateLoggingRPC, "
                        "ConstructDataBinningRPC, RequestMetaDataRPC, SetTreatAllDBsAsTimeVaryingRPC, SetCreateMeshQualityExpressionsRPC, "
                        "SetCreateTimeDerivativeExpressionsRPC, SetCreateVectorMagnitudeExpressionsRPC, SetPrecisionTypeRPC, SetBackendTypeRPC, "
                        "CopyActivePlotsRPC, SetPlotFollowsTimeRPC, TurnOffAllLocksRPC, SetDefaultFileOpenOptionsRPC, "
                        "SetSuppressMessagesRPC, ApplyNamedSelectionRPC, CreateNamedSelectionRPC, DeleteNamedSelectionRPC, "
                        "LoadNamedSelectionRPC, SaveNamedSelectionRPC, SetNamedSelectionAutoApplyRPC, UpdateNamedSelectionRPC, "
                        "InitializeNamedSelectionVariablesRPC, MenuQuitRPC, SetPlotDescriptionRPC, MovePlotOrderTowardFirstRPC, "
                        "MovePlotOrderTowardLastRPC, SetPlotOrderToFirstRPC, SetPlotOrderToLastRPC, RenamePickLabelRPC, "
                        "GetQueryParametersRPC, DDTConnectRPC, DDTFocusRPC, ReleaseToDDTRPC, "
                        "PlotDDTVispointVariablesRPC, ExportRPC, ExportHostProfileRPC, ReadHostProfilesFromDirectoryRPC, "
                        "SetRemoveDuplicateNodesRPC, MaxRPC.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetRPCType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRPCType()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetWindowLayout(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowLayout in the object.
    obj->data->SetWindowLayout((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetWindowLayout(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowLayout()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetWindowId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetWindowId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetWindowMode(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowMode in the object.
    obj->data->SetWindowMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetWindowMode(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowMode()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetWindowArea(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the windowArea in the object.
    obj->data->SetWindowArea(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetWindowArea(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetWindowArea().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetDatabase(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the database in the object.
    obj->data->SetDatabase(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetDatabase(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDatabase().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetProgramHost(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the programHost in the object.
    obj->data->SetProgramHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetProgramHost(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetProgramHost().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetProgramSim(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the programSim in the object.
    obj->data->SetProgramSim(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetProgramSim(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetProgramSim().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetProgramOptions(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    stringVector  &vec = obj->data->GetProgramOptions();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the programOptions in the object as modified.
    obj->data->SelectProgramOptions();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetProgramOptions(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the programOptions.
    const stringVector &programOptions = obj->data->GetProgramOptions();
    PyObject *retval = PyTuple_New(programOptions.size());
    for(size_t i = 0; i < programOptions.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(programOptions[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetNFrames(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nFrames in the object.
    obj->data->SetNFrames((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetNFrames(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNFrames()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetStateNumber(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stateNumber in the object.
    obj->data->SetStateNumber((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetStateNumber(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStateNumber()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetFrameRange(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int *ivals = obj->data->GetFrameRange();
    if(!PyArg_ParseTuple(args, "ii", &ivals[0], &ivals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the frameRange in the object as modified.
    obj->data->SelectFrameRange();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetFrameRange(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the frameRange.
    PyObject *retval = PyTuple_New(2);
    const int *frameRange = obj->data->GetFrameRange();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(frameRange[i])));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetFrame(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the frame in the object.
    obj->data->SetFrame((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetFrame(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFrame()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetPlotType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the plotType in the object.
    obj->data->SetPlotType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetPlotType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPlotType()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetOperatorType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the operatorType in the object.
    obj->data->SetOperatorType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetOperatorType(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOperatorType()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetVariable(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetVariable(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetActivePlotIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    intVector  &vec = obj->data->GetActivePlotIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the activePlotIds in the object as modified.
    obj->data->SelectActivePlotIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetActivePlotIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the activePlotIds.
    const intVector &activePlotIds = obj->data->GetActivePlotIds();
    PyObject *retval = PyTuple_New(activePlotIds.size());
    for(size_t i = 0; i < activePlotIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(activePlotIds[i])));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetActiveOperatorIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    intVector  &vec = obj->data->GetActiveOperatorIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the activeOperatorIds in the object as modified.
    obj->data->SelectActiveOperatorIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetActiveOperatorIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the activeOperatorIds.
    const intVector &activeOperatorIds = obj->data->GetActiveOperatorIds();
    PyObject *retval = PyTuple_New(activeOperatorIds.size());
    for(size_t i = 0; i < activeOperatorIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(activeOperatorIds[i])));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetExpandedPlotIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    intVector  &vec = obj->data->GetExpandedPlotIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the expandedPlotIds in the object as modified.
    obj->data->SelectExpandedPlotIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetExpandedPlotIds(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the expandedPlotIds.
    const intVector &expandedPlotIds = obj->data->GetExpandedPlotIds();
    PyObject *retval = PyTuple_New(expandedPlotIds.size());
    for(size_t i = 0; i < expandedPlotIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(expandedPlotIds[i])));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetColorTableName(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetColorTableName(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetQueryName(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the queryName in the object.
    obj->data->SetQueryName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetQueryName(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetQueryName().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetQueryPoint1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    double *dvals = obj->data->GetQueryPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the queryPoint1 in the object as modified.
    obj->data->SelectQueryPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetQueryPoint1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    // Allocate a tuple the with enough entries to hold the queryPoint1.
    PyObject *retval = PyTuple_New(3);
    const double *queryPoint1 = obj->data->GetQueryPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(queryPoint1[i]));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetToolId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the toolId in the object.
    obj->data->SetToolId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetToolId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetToolId()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetEmbeddedPlotId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the embeddedPlotId in the object.
    obj->data->SetEmbeddedPlotId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetEmbeddedPlotId(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEmbeddedPlotId()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetBoolFlag(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boolFlag in the object.
    obj->data->SetBoolFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetBoolFlag(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBoolFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetIntArg1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the intArg1 in the object.
    obj->data->SetIntArg1((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetIntArg1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntArg1()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetIntArg2(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the intArg2 in the object.
    obj->data->SetIntArg2((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetIntArg2(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntArg2()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetIntArg3(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the intArg3 in the object.
    obj->data->SetIntArg3((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetIntArg3(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntArg3()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetStringArg1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the stringArg1 in the object.
    obj->data->SetStringArg1(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetStringArg1(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetStringArg1().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetStringArg2(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the stringArg2 in the object.
    obj->data->SetStringArg2(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetStringArg2(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetStringArg2().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetToolUpdateMode(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the toolUpdateMode in the object.
    obj->data->SetToolUpdateMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetToolUpdateMode(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetToolUpdateMode()));
    return retval;
}

/*static*/ PyObject *
ViewerRPC_SetQueryParams(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;

    (void) obj;
    // NOT IMPLEMENTED!!!
    // name=queryParams, type=MapNode

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerRPC_GetQueryParams(PyObject *self, PyObject *args)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)self;
    (void) obj;
    // NOT IMPLEMENTED!!!
    // name=queryParams, type=MapNode
    PyObject *retval = NULL;
    return retval;
}



PyMethodDef PyViewerRPC_methods[VIEWERRPC_NMETH] = {
    {"Notify", ViewerRPC_Notify, METH_VARARGS},
    {"SetRPCType", ViewerRPC_SetRPCType, METH_VARARGS},
    {"GetRPCType", ViewerRPC_GetRPCType, METH_VARARGS},
    {"SetWindowLayout", ViewerRPC_SetWindowLayout, METH_VARARGS},
    {"GetWindowLayout", ViewerRPC_GetWindowLayout, METH_VARARGS},
    {"SetWindowId", ViewerRPC_SetWindowId, METH_VARARGS},
    {"GetWindowId", ViewerRPC_GetWindowId, METH_VARARGS},
    {"SetWindowMode", ViewerRPC_SetWindowMode, METH_VARARGS},
    {"GetWindowMode", ViewerRPC_GetWindowMode, METH_VARARGS},
    {"SetWindowArea", ViewerRPC_SetWindowArea, METH_VARARGS},
    {"GetWindowArea", ViewerRPC_GetWindowArea, METH_VARARGS},
    {"SetDatabase", ViewerRPC_SetDatabase, METH_VARARGS},
    {"GetDatabase", ViewerRPC_GetDatabase, METH_VARARGS},
    {"SetProgramHost", ViewerRPC_SetProgramHost, METH_VARARGS},
    {"GetProgramHost", ViewerRPC_GetProgramHost, METH_VARARGS},
    {"SetProgramSim", ViewerRPC_SetProgramSim, METH_VARARGS},
    {"GetProgramSim", ViewerRPC_GetProgramSim, METH_VARARGS},
    {"SetProgramOptions", ViewerRPC_SetProgramOptions, METH_VARARGS},
    {"GetProgramOptions", ViewerRPC_GetProgramOptions, METH_VARARGS},
    {"SetNFrames", ViewerRPC_SetNFrames, METH_VARARGS},
    {"GetNFrames", ViewerRPC_GetNFrames, METH_VARARGS},
    {"SetStateNumber", ViewerRPC_SetStateNumber, METH_VARARGS},
    {"GetStateNumber", ViewerRPC_GetStateNumber, METH_VARARGS},
    {"SetFrameRange", ViewerRPC_SetFrameRange, METH_VARARGS},
    {"GetFrameRange", ViewerRPC_GetFrameRange, METH_VARARGS},
    {"SetFrame", ViewerRPC_SetFrame, METH_VARARGS},
    {"GetFrame", ViewerRPC_GetFrame, METH_VARARGS},
    {"SetPlotType", ViewerRPC_SetPlotType, METH_VARARGS},
    {"GetPlotType", ViewerRPC_GetPlotType, METH_VARARGS},
    {"SetOperatorType", ViewerRPC_SetOperatorType, METH_VARARGS},
    {"GetOperatorType", ViewerRPC_GetOperatorType, METH_VARARGS},
    {"SetVariable", ViewerRPC_SetVariable, METH_VARARGS},
    {"GetVariable", ViewerRPC_GetVariable, METH_VARARGS},
    {"SetActivePlotIds", ViewerRPC_SetActivePlotIds, METH_VARARGS},
    {"GetActivePlotIds", ViewerRPC_GetActivePlotIds, METH_VARARGS},
    {"SetActiveOperatorIds", ViewerRPC_SetActiveOperatorIds, METH_VARARGS},
    {"GetActiveOperatorIds", ViewerRPC_GetActiveOperatorIds, METH_VARARGS},
    {"SetExpandedPlotIds", ViewerRPC_SetExpandedPlotIds, METH_VARARGS},
    {"GetExpandedPlotIds", ViewerRPC_GetExpandedPlotIds, METH_VARARGS},
    {"SetColorTableName", ViewerRPC_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", ViewerRPC_GetColorTableName, METH_VARARGS},
    {"SetQueryName", ViewerRPC_SetQueryName, METH_VARARGS},
    {"GetQueryName", ViewerRPC_GetQueryName, METH_VARARGS},
    {"SetQueryPoint1", ViewerRPC_SetQueryPoint1, METH_VARARGS},
    {"GetQueryPoint1", ViewerRPC_GetQueryPoint1, METH_VARARGS},
    {"SetToolId", ViewerRPC_SetToolId, METH_VARARGS},
    {"GetToolId", ViewerRPC_GetToolId, METH_VARARGS},
    {"SetEmbeddedPlotId", ViewerRPC_SetEmbeddedPlotId, METH_VARARGS},
    {"GetEmbeddedPlotId", ViewerRPC_GetEmbeddedPlotId, METH_VARARGS},
    {"SetBoolFlag", ViewerRPC_SetBoolFlag, METH_VARARGS},
    {"GetBoolFlag", ViewerRPC_GetBoolFlag, METH_VARARGS},
    {"SetIntArg1", ViewerRPC_SetIntArg1, METH_VARARGS},
    {"GetIntArg1", ViewerRPC_GetIntArg1, METH_VARARGS},
    {"SetIntArg2", ViewerRPC_SetIntArg2, METH_VARARGS},
    {"GetIntArg2", ViewerRPC_GetIntArg2, METH_VARARGS},
    {"SetIntArg3", ViewerRPC_SetIntArg3, METH_VARARGS},
    {"GetIntArg3", ViewerRPC_GetIntArg3, METH_VARARGS},
    {"SetStringArg1", ViewerRPC_SetStringArg1, METH_VARARGS},
    {"GetStringArg1", ViewerRPC_GetStringArg1, METH_VARARGS},
    {"SetStringArg2", ViewerRPC_SetStringArg2, METH_VARARGS},
    {"GetStringArg2", ViewerRPC_GetStringArg2, METH_VARARGS},
    {"SetToolUpdateMode", ViewerRPC_SetToolUpdateMode, METH_VARARGS},
    {"GetToolUpdateMode", ViewerRPC_GetToolUpdateMode, METH_VARARGS},
    {"SetQueryParams", ViewerRPC_SetQueryParams, METH_VARARGS},
    {"GetQueryParams", ViewerRPC_GetQueryParams, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewerRPC_dealloc(PyObject *v)
{
   ViewerRPCObject *obj = (ViewerRPCObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ViewerRPC_compare(PyObject *v, PyObject *w)
{
    ViewerRPC *a = ((ViewerRPCObject *)v)->data;
    ViewerRPC *b = ((ViewerRPCObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyViewerRPC_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "RPCType") == 0)
        return ViewerRPC_GetRPCType(self, NULL);
    if(strcmp(name, "CloseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CloseRPC));
    if(strcmp(name, "DetachRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DetachRPC));
    if(strcmp(name, "AddWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddWindowRPC));
    if(strcmp(name, "DeleteWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteWindowRPC));
    if(strcmp(name, "SetWindowLayoutRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetWindowLayoutRPC));
    if(strcmp(name, "SetActiveWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetActiveWindowRPC));
    if(strcmp(name, "ClearWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearWindowRPC));
    if(strcmp(name, "ClearAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearAllWindowsRPC));
    if(strcmp(name, "OpenDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenDatabaseRPC));
    if(strcmp(name, "CloseDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CloseDatabaseRPC));
    if(strcmp(name, "ActivateDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ActivateDatabaseRPC));
    if(strcmp(name, "CheckForNewStatesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CheckForNewStatesRPC));
    if(strcmp(name, "CreateDatabaseCorrelationRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CreateDatabaseCorrelationRPC));
    if(strcmp(name, "AlterDatabaseCorrelationRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AlterDatabaseCorrelationRPC));
    if(strcmp(name, "DeleteDatabaseCorrelationRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteDatabaseCorrelationRPC));
    if(strcmp(name, "ReOpenDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ReOpenDatabaseRPC));
    if(strcmp(name, "ReplaceDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ReplaceDatabaseRPC));
    if(strcmp(name, "OverlayDatabaseRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OverlayDatabaseRPC));
    if(strcmp(name, "OpenComputeEngineRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenComputeEngineRPC));
    if(strcmp(name, "CloseComputeEngineRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CloseComputeEngineRPC));
    if(strcmp(name, "AnimationSetNFramesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AnimationSetNFramesRPC));
    if(strcmp(name, "AnimationPlayRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AnimationPlayRPC));
    if(strcmp(name, "AnimationReversePlayRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AnimationReversePlayRPC));
    if(strcmp(name, "AnimationStopRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AnimationStopRPC));
    if(strcmp(name, "TimeSliderNextStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::TimeSliderNextStateRPC));
    if(strcmp(name, "TimeSliderPreviousStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::TimeSliderPreviousStateRPC));
    if(strcmp(name, "SetTimeSliderStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetTimeSliderStateRPC));
    if(strcmp(name, "SetActiveTimeSliderRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetActiveTimeSliderRPC));
    if(strcmp(name, "AddPlotRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddPlotRPC));
    if(strcmp(name, "AddEmbeddedPlotRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddEmbeddedPlotRPC));
    if(strcmp(name, "SetPlotFrameRangeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotFrameRangeRPC));
    if(strcmp(name, "DeletePlotKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeletePlotKeyframeRPC));
    if(strcmp(name, "MovePlotKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MovePlotKeyframeRPC));
    if(strcmp(name, "DeleteActivePlotsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteActivePlotsRPC));
    if(strcmp(name, "HideActivePlotsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::HideActivePlotsRPC));
    if(strcmp(name, "DrawPlotsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DrawPlotsRPC));
    if(strcmp(name, "DisableRedrawRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DisableRedrawRPC));
    if(strcmp(name, "RedrawRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RedrawRPC));
    if(strcmp(name, "SetActivePlotsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetActivePlotsRPC));
    if(strcmp(name, "ChangeActivePlotsVarRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ChangeActivePlotsVarRPC));
    if(strcmp(name, "AddOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddOperatorRPC));
    if(strcmp(name, "AddInitializedOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddInitializedOperatorRPC));
    if(strcmp(name, "PromoteOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::PromoteOperatorRPC));
    if(strcmp(name, "DemoteOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DemoteOperatorRPC));
    if(strcmp(name, "RemoveOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RemoveOperatorRPC));
    if(strcmp(name, "RemoveLastOperatorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RemoveLastOperatorRPC));
    if(strcmp(name, "RemoveAllOperatorsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RemoveAllOperatorsRPC));
    if(strcmp(name, "SaveWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SaveWindowRPC));
    if(strcmp(name, "SetDefaultPlotOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultPlotOptionsRPC));
    if(strcmp(name, "SetPlotOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotOptionsRPC));
    if(strcmp(name, "SetDefaultOperatorOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultOperatorOptionsRPC));
    if(strcmp(name, "SetOperatorOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetOperatorOptionsRPC));
    if(strcmp(name, "WriteConfigFileRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::WriteConfigFileRPC));
    if(strcmp(name, "ConnectToMetaDataServerRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ConnectToMetaDataServerRPC));
    if(strcmp(name, "IconifyAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::IconifyAllWindowsRPC));
    if(strcmp(name, "DeIconifyAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeIconifyAllWindowsRPC));
    if(strcmp(name, "ShowAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ShowAllWindowsRPC));
    if(strcmp(name, "HideAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::HideAllWindowsRPC));
    if(strcmp(name, "UpdateColorTableRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::UpdateColorTableRPC));
    if(strcmp(name, "SetAnnotationAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetAnnotationAttributesRPC));
    if(strcmp(name, "SetDefaultAnnotationAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultAnnotationAttributesRPC));
    if(strcmp(name, "ResetAnnotationAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetAnnotationAttributesRPC));
    if(strcmp(name, "SetKeyframeAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetKeyframeAttributesRPC));
    if(strcmp(name, "SetPlotSILRestrictionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotSILRestrictionRPC));
    if(strcmp(name, "SetViewAxisArrayRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetViewAxisArrayRPC));
    if(strcmp(name, "SetViewCurveRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetViewCurveRPC));
    if(strcmp(name, "SetView2DRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetView2DRPC));
    if(strcmp(name, "SetView3DRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetView3DRPC));
    if(strcmp(name, "ResetPlotOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetPlotOptionsRPC));
    if(strcmp(name, "ResetOperatorOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetOperatorOptionsRPC));
    if(strcmp(name, "SetAppearanceRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetAppearanceRPC));
    if(strcmp(name, "ProcessExpressionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ProcessExpressionsRPC));
    if(strcmp(name, "SetLightListRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetLightListRPC));
    if(strcmp(name, "SetDefaultLightListRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultLightListRPC));
    if(strcmp(name, "ResetLightListRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetLightListRPC));
    if(strcmp(name, "SetAnimationAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetAnimationAttributesRPC));
    if(strcmp(name, "SetWindowAreaRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetWindowAreaRPC));
    if(strcmp(name, "PrintWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::PrintWindowRPC));
    if(strcmp(name, "ResetViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetViewRPC));
    if(strcmp(name, "RecenterViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RecenterViewRPC));
    if(strcmp(name, "ToggleAllowPopupRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleAllowPopupRPC));
    if(strcmp(name, "ToggleMaintainViewModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleMaintainViewModeRPC));
    if(strcmp(name, "ToggleBoundingBoxModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleBoundingBoxModeRPC));
    if(strcmp(name, "ToggleCameraViewModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleCameraViewModeRPC));
    if(strcmp(name, "TogglePerspectiveViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::TogglePerspectiveViewRPC));
    if(strcmp(name, "ToggleSpinModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleSpinModeRPC));
    if(strcmp(name, "ToggleLockTimeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleLockTimeRPC));
    if(strcmp(name, "ToggleLockToolsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleLockToolsRPC));
    if(strcmp(name, "ToggleLockViewModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleLockViewModeRPC));
    if(strcmp(name, "ToggleFullFrameRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ToggleFullFrameRPC));
    if(strcmp(name, "UndoViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::UndoViewRPC));
    if(strcmp(name, "RedoViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RedoViewRPC));
    if(strcmp(name, "InvertBackgroundRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::InvertBackgroundRPC));
    if(strcmp(name, "ClearPickPointsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearPickPointsRPC));
    if(strcmp(name, "SetWindowModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetWindowModeRPC));
    if(strcmp(name, "EnableToolRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::EnableToolRPC));
    if(strcmp(name, "SetToolUpdateModeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetToolUpdateModeRPC));
    if(strcmp(name, "CopyViewToWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CopyViewToWindowRPC));
    if(strcmp(name, "CopyLightingToWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CopyLightingToWindowRPC));
    if(strcmp(name, "CopyAnnotationsToWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CopyAnnotationsToWindowRPC));
    if(strcmp(name, "CopyPlotsToWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CopyPlotsToWindowRPC));
    if(strcmp(name, "ClearCacheRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearCacheRPC));
    if(strcmp(name, "ClearCacheForAllEnginesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearCacheForAllEnginesRPC));
    if(strcmp(name, "SetViewExtentsTypeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetViewExtentsTypeRPC));
    if(strcmp(name, "ClearRefLinesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearRefLinesRPC));
    if(strcmp(name, "SetRenderingAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetRenderingAttributesRPC));
    if(strcmp(name, "QueryRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::QueryRPC));
    if(strcmp(name, "CloneWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CloneWindowRPC));
    if(strcmp(name, "SetMaterialAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetMaterialAttributesRPC));
    if(strcmp(name, "SetDefaultMaterialAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultMaterialAttributesRPC));
    if(strcmp(name, "ResetMaterialAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetMaterialAttributesRPC));
    if(strcmp(name, "SetPlotDatabaseStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotDatabaseStateRPC));
    if(strcmp(name, "DeletePlotDatabaseKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeletePlotDatabaseKeyframeRPC));
    if(strcmp(name, "MovePlotDatabaseKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MovePlotDatabaseKeyframeRPC));
    if(strcmp(name, "ClearViewKeyframesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ClearViewKeyframesRPC));
    if(strcmp(name, "DeleteViewKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteViewKeyframeRPC));
    if(strcmp(name, "MoveViewKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MoveViewKeyframeRPC));
    if(strcmp(name, "SetViewKeyframeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetViewKeyframeRPC));
    if(strcmp(name, "OpenMDServerRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenMDServerRPC));
    if(strcmp(name, "EnableToolbarRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::EnableToolbarRPC));
    if(strcmp(name, "HideToolbarsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::HideToolbarsRPC));
    if(strcmp(name, "HideToolbarsForAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::HideToolbarsForAllWindowsRPC));
    if(strcmp(name, "ShowToolbarsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ShowToolbarsRPC));
    if(strcmp(name, "ShowToolbarsForAllWindowsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ShowToolbarsForAllWindowsRPC));
    if(strcmp(name, "SetToolbarIconSizeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetToolbarIconSizeRPC));
    if(strcmp(name, "SaveViewRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SaveViewRPC));
    if(strcmp(name, "SetGlobalLineoutAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetGlobalLineoutAttributesRPC));
    if(strcmp(name, "SetPickAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPickAttributesRPC));
    if(strcmp(name, "ExportColorTableRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ExportColorTableRPC));
    if(strcmp(name, "ExportEntireStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ExportEntireStateRPC));
    if(strcmp(name, "ImportEntireStateRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ImportEntireStateRPC));
    if(strcmp(name, "ImportEntireStateWithDifferentSourcesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ImportEntireStateWithDifferentSourcesRPC));
    if(strcmp(name, "ResetPickAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetPickAttributesRPC));
    if(strcmp(name, "AddAnnotationObjectRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::AddAnnotationObjectRPC));
    if(strcmp(name, "HideActiveAnnotationObjectsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::HideActiveAnnotationObjectsRPC));
    if(strcmp(name, "DeleteActiveAnnotationObjectsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteActiveAnnotationObjectsRPC));
    if(strcmp(name, "RaiseActiveAnnotationObjectsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RaiseActiveAnnotationObjectsRPC));
    if(strcmp(name, "LowerActiveAnnotationObjectsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::LowerActiveAnnotationObjectsRPC));
    if(strcmp(name, "SetAnnotationObjectOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetAnnotationObjectOptionsRPC));
    if(strcmp(name, "SetDefaultAnnotationObjectListRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultAnnotationObjectListRPC));
    if(strcmp(name, "ResetAnnotationObjectListRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetAnnotationObjectListRPC));
    if(strcmp(name, "ResetPickLetterRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetPickLetterRPC));
    if(strcmp(name, "SetDefaultPickAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultPickAttributesRPC));
    if(strcmp(name, "ChooseCenterOfRotationRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ChooseCenterOfRotationRPC));
    if(strcmp(name, "SetCenterOfRotationRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetCenterOfRotationRPC));
    if(strcmp(name, "SetQueryOverTimeAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetQueryOverTimeAttributesRPC));
    if(strcmp(name, "SetDefaultQueryOverTimeAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultQueryOverTimeAttributesRPC));
    if(strcmp(name, "ResetQueryOverTimeAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetQueryOverTimeAttributesRPC));
    if(strcmp(name, "ResetLineoutColorRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetLineoutColorRPC));
    if(strcmp(name, "SetInteractorAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetInteractorAttributesRPC));
    if(strcmp(name, "SetDefaultInteractorAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultInteractorAttributesRPC));
    if(strcmp(name, "ResetInteractorAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetInteractorAttributesRPC));
    if(strcmp(name, "GetProcInfoRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::GetProcInfoRPC));
    if(strcmp(name, "SendSimulationCommandRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SendSimulationCommandRPC));
    if(strcmp(name, "UpdateDBPluginInfoRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::UpdateDBPluginInfoRPC));
    if(strcmp(name, "ExportDBRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ExportDBRPC));
    if(strcmp(name, "SetTryHarderCyclesTimesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetTryHarderCyclesTimesRPC));
    if(strcmp(name, "OpenClientRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenClientRPC));
    if(strcmp(name, "OpenGUIClientRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenGUIClientRPC));
    if(strcmp(name, "OpenCLIClientRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::OpenCLIClientRPC));
    if(strcmp(name, "SuppressQueryOutputRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SuppressQueryOutputRPC));
    if(strcmp(name, "SetQueryFloatFormatRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetQueryFloatFormatRPC));
    if(strcmp(name, "SetMeshManagementAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetMeshManagementAttributesRPC));
    if(strcmp(name, "SetDefaultMeshManagementAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultMeshManagementAttributesRPC));
    if(strcmp(name, "ResetMeshManagementAttributesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResetMeshManagementAttributesRPC));
    if(strcmp(name, "ResizeWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ResizeWindowRPC));
    if(strcmp(name, "MoveWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MoveWindowRPC));
    if(strcmp(name, "MoveAndResizeWindowRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MoveAndResizeWindowRPC));
    if(strcmp(name, "SetStateLoggingRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetStateLoggingRPC));
    if(strcmp(name, "ConstructDataBinningRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ConstructDataBinningRPC));
    if(strcmp(name, "RequestMetaDataRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RequestMetaDataRPC));
    if(strcmp(name, "SetTreatAllDBsAsTimeVaryingRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetTreatAllDBsAsTimeVaryingRPC));
    if(strcmp(name, "SetCreateMeshQualityExpressionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetCreateMeshQualityExpressionsRPC));
    if(strcmp(name, "SetCreateTimeDerivativeExpressionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetCreateTimeDerivativeExpressionsRPC));
    if(strcmp(name, "SetCreateVectorMagnitudeExpressionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetCreateVectorMagnitudeExpressionsRPC));
    if(strcmp(name, "SetPrecisionTypeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPrecisionTypeRPC));
    if(strcmp(name, "SetBackendTypeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetBackendTypeRPC));
    if(strcmp(name, "CopyActivePlotsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CopyActivePlotsRPC));
    if(strcmp(name, "SetPlotFollowsTimeRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotFollowsTimeRPC));
    if(strcmp(name, "TurnOffAllLocksRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::TurnOffAllLocksRPC));
    if(strcmp(name, "SetDefaultFileOpenOptionsRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetDefaultFileOpenOptionsRPC));
    if(strcmp(name, "SetSuppressMessagesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetSuppressMessagesRPC));
    if(strcmp(name, "ApplyNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ApplyNamedSelectionRPC));
    if(strcmp(name, "CreateNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::CreateNamedSelectionRPC));
    if(strcmp(name, "DeleteNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DeleteNamedSelectionRPC));
    if(strcmp(name, "LoadNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::LoadNamedSelectionRPC));
    if(strcmp(name, "SaveNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SaveNamedSelectionRPC));
    if(strcmp(name, "SetNamedSelectionAutoApplyRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetNamedSelectionAutoApplyRPC));
    if(strcmp(name, "UpdateNamedSelectionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::UpdateNamedSelectionRPC));
    if(strcmp(name, "InitializeNamedSelectionVariablesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::InitializeNamedSelectionVariablesRPC));
    if(strcmp(name, "MenuQuitRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MenuQuitRPC));
    if(strcmp(name, "SetPlotDescriptionRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotDescriptionRPC));
    if(strcmp(name, "MovePlotOrderTowardFirstRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MovePlotOrderTowardFirstRPC));
    if(strcmp(name, "MovePlotOrderTowardLastRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MovePlotOrderTowardLastRPC));
    if(strcmp(name, "SetPlotOrderToFirstRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotOrderToFirstRPC));
    if(strcmp(name, "SetPlotOrderToLastRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetPlotOrderToLastRPC));
    if(strcmp(name, "RenamePickLabelRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::RenamePickLabelRPC));
    if(strcmp(name, "GetQueryParametersRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::GetQueryParametersRPC));
    if(strcmp(name, "DDTConnectRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DDTConnectRPC));
    if(strcmp(name, "DDTFocusRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::DDTFocusRPC));
    if(strcmp(name, "ReleaseToDDTRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ReleaseToDDTRPC));
    if(strcmp(name, "PlotDDTVispointVariablesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::PlotDDTVispointVariablesRPC));
    if(strcmp(name, "ExportRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ExportRPC));
    if(strcmp(name, "ExportHostProfileRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ExportHostProfileRPC));
    if(strcmp(name, "ReadHostProfilesFromDirectoryRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::ReadHostProfilesFromDirectoryRPC));
    if(strcmp(name, "SetRemoveDuplicateNodesRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::SetRemoveDuplicateNodesRPC));
    if(strcmp(name, "MaxRPC") == 0)
        return PyInt_FromLong(long(ViewerRPC::MaxRPC));

    if(strcmp(name, "windowLayout") == 0)
        return ViewerRPC_GetWindowLayout(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return ViewerRPC_GetWindowId(self, NULL);
    if(strcmp(name, "windowMode") == 0)
        return ViewerRPC_GetWindowMode(self, NULL);
    if(strcmp(name, "windowArea") == 0)
        return ViewerRPC_GetWindowArea(self, NULL);
    if(strcmp(name, "database") == 0)
        return ViewerRPC_GetDatabase(self, NULL);
    if(strcmp(name, "programHost") == 0)
        return ViewerRPC_GetProgramHost(self, NULL);
    if(strcmp(name, "programSim") == 0)
        return ViewerRPC_GetProgramSim(self, NULL);
    if(strcmp(name, "programOptions") == 0)
        return ViewerRPC_GetProgramOptions(self, NULL);
    if(strcmp(name, "nFrames") == 0)
        return ViewerRPC_GetNFrames(self, NULL);
    if(strcmp(name, "stateNumber") == 0)
        return ViewerRPC_GetStateNumber(self, NULL);
    if(strcmp(name, "frameRange") == 0)
        return ViewerRPC_GetFrameRange(self, NULL);
    if(strcmp(name, "frame") == 0)
        return ViewerRPC_GetFrame(self, NULL);
    if(strcmp(name, "plotType") == 0)
        return ViewerRPC_GetPlotType(self, NULL);
    if(strcmp(name, "operatorType") == 0)
        return ViewerRPC_GetOperatorType(self, NULL);
    if(strcmp(name, "variable") == 0)
        return ViewerRPC_GetVariable(self, NULL);
    if(strcmp(name, "activePlotIds") == 0)
        return ViewerRPC_GetActivePlotIds(self, NULL);
    if(strcmp(name, "activeOperatorIds") == 0)
        return ViewerRPC_GetActiveOperatorIds(self, NULL);
    if(strcmp(name, "expandedPlotIds") == 0)
        return ViewerRPC_GetExpandedPlotIds(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return ViewerRPC_GetColorTableName(self, NULL);
    if(strcmp(name, "queryName") == 0)
        return ViewerRPC_GetQueryName(self, NULL);
    if(strcmp(name, "queryPoint1") == 0)
        return ViewerRPC_GetQueryPoint1(self, NULL);
    if(strcmp(name, "toolId") == 0)
        return ViewerRPC_GetToolId(self, NULL);
    if(strcmp(name, "embeddedPlotId") == 0)
        return ViewerRPC_GetEmbeddedPlotId(self, NULL);
    if(strcmp(name, "boolFlag") == 0)
        return ViewerRPC_GetBoolFlag(self, NULL);
    if(strcmp(name, "intArg1") == 0)
        return ViewerRPC_GetIntArg1(self, NULL);
    if(strcmp(name, "intArg2") == 0)
        return ViewerRPC_GetIntArg2(self, NULL);
    if(strcmp(name, "intArg3") == 0)
        return ViewerRPC_GetIntArg3(self, NULL);
    if(strcmp(name, "stringArg1") == 0)
        return ViewerRPC_GetStringArg1(self, NULL);
    if(strcmp(name, "stringArg2") == 0)
        return ViewerRPC_GetStringArg2(self, NULL);
    if(strcmp(name, "toolUpdateMode") == 0)
        return ViewerRPC_GetToolUpdateMode(self, NULL);
    if(strcmp(name, "queryParams") == 0)
        return ViewerRPC_GetQueryParams(self, NULL);

    return Py_FindMethod(PyViewerRPC_methods, self, name);
}

int
PyViewerRPC_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "RPCType") == 0)
        obj = ViewerRPC_SetRPCType(self, tuple);
    else if(strcmp(name, "windowLayout") == 0)
        obj = ViewerRPC_SetWindowLayout(self, tuple);
    else if(strcmp(name, "windowId") == 0)
        obj = ViewerRPC_SetWindowId(self, tuple);
    else if(strcmp(name, "windowMode") == 0)
        obj = ViewerRPC_SetWindowMode(self, tuple);
    else if(strcmp(name, "windowArea") == 0)
        obj = ViewerRPC_SetWindowArea(self, tuple);
    else if(strcmp(name, "database") == 0)
        obj = ViewerRPC_SetDatabase(self, tuple);
    else if(strcmp(name, "programHost") == 0)
        obj = ViewerRPC_SetProgramHost(self, tuple);
    else if(strcmp(name, "programSim") == 0)
        obj = ViewerRPC_SetProgramSim(self, tuple);
    else if(strcmp(name, "programOptions") == 0)
        obj = ViewerRPC_SetProgramOptions(self, tuple);
    else if(strcmp(name, "nFrames") == 0)
        obj = ViewerRPC_SetNFrames(self, tuple);
    else if(strcmp(name, "stateNumber") == 0)
        obj = ViewerRPC_SetStateNumber(self, tuple);
    else if(strcmp(name, "frameRange") == 0)
        obj = ViewerRPC_SetFrameRange(self, tuple);
    else if(strcmp(name, "frame") == 0)
        obj = ViewerRPC_SetFrame(self, tuple);
    else if(strcmp(name, "plotType") == 0)
        obj = ViewerRPC_SetPlotType(self, tuple);
    else if(strcmp(name, "operatorType") == 0)
        obj = ViewerRPC_SetOperatorType(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = ViewerRPC_SetVariable(self, tuple);
    else if(strcmp(name, "activePlotIds") == 0)
        obj = ViewerRPC_SetActivePlotIds(self, tuple);
    else if(strcmp(name, "activeOperatorIds") == 0)
        obj = ViewerRPC_SetActiveOperatorIds(self, tuple);
    else if(strcmp(name, "expandedPlotIds") == 0)
        obj = ViewerRPC_SetExpandedPlotIds(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = ViewerRPC_SetColorTableName(self, tuple);
    else if(strcmp(name, "queryName") == 0)
        obj = ViewerRPC_SetQueryName(self, tuple);
    else if(strcmp(name, "queryPoint1") == 0)
        obj = ViewerRPC_SetQueryPoint1(self, tuple);
    else if(strcmp(name, "toolId") == 0)
        obj = ViewerRPC_SetToolId(self, tuple);
    else if(strcmp(name, "embeddedPlotId") == 0)
        obj = ViewerRPC_SetEmbeddedPlotId(self, tuple);
    else if(strcmp(name, "boolFlag") == 0)
        obj = ViewerRPC_SetBoolFlag(self, tuple);
    else if(strcmp(name, "intArg1") == 0)
        obj = ViewerRPC_SetIntArg1(self, tuple);
    else if(strcmp(name, "intArg2") == 0)
        obj = ViewerRPC_SetIntArg2(self, tuple);
    else if(strcmp(name, "intArg3") == 0)
        obj = ViewerRPC_SetIntArg3(self, tuple);
    else if(strcmp(name, "stringArg1") == 0)
        obj = ViewerRPC_SetStringArg1(self, tuple);
    else if(strcmp(name, "stringArg2") == 0)
        obj = ViewerRPC_SetStringArg2(self, tuple);
    else if(strcmp(name, "toolUpdateMode") == 0)
        obj = ViewerRPC_SetToolUpdateMode(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ViewerRPC_print(PyObject *v, FILE *fp, int flags)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)v;
    fprintf(fp, "%s", PyViewerRPC_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ViewerRPC_str(PyObject *v)
{
    ViewerRPCObject *obj = (ViewerRPCObject *)v;
    return PyString_FromString(PyViewerRPC_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ViewerRPC_Purpose = "This class contains the attributes for controlling the viewer.";
#else
static char *ViewerRPC_Purpose = "This class contains the attributes for controlling the viewer.";
#endif

//
// The type description structure
//
static PyTypeObject ViewerRPCType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewerRPC",                    // tp_name
    sizeof(ViewerRPCObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewerRPC_dealloc,  // tp_dealloc
    (printfunc)ViewerRPC_print,     // tp_print
    (getattrfunc)PyViewerRPC_getattr, // tp_getattr
    (setattrfunc)PyViewerRPC_setattr, // tp_setattr
    (cmpfunc)ViewerRPC_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ViewerRPC_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewerRPC_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewerRPC *defaultAtts = 0;
static ViewerRPC *currentAtts = 0;

static PyObject *
NewViewerRPC(int useCurrent)
{
    ViewerRPCObject *newObject;
    newObject = PyObject_NEW(ViewerRPCObject, &ViewerRPCType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ViewerRPC(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ViewerRPC(*defaultAtts);
    else
        newObject->data = new ViewerRPC;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewerRPC(const ViewerRPC *attr)
{
    ViewerRPCObject *newObject;
    newObject = PyObject_NEW(ViewerRPCObject, &ViewerRPCType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewerRPC *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewerRPC_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewViewerRPC(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewerRPCMethods[] = {
    {"ViewerRPC", ViewerRPC_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewerRPCObserver = 0;

std::string
PyViewerRPC_GetLogString()
{
    std::string s("ViewerRPC = ViewerRPC()\n");
    if(currentAtts != 0)
        s += PyViewerRPC_ToString(currentAtts, "ViewerRPC.");
    return s;
}

static void
PyViewerRPC_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ViewerRPC = ViewerRPC()\n");
        s += PyViewerRPC_ToString(currentAtts, "ViewerRPC.");
        cb(s);
    }
}

void
PyViewerRPC_StartUp(ViewerRPC *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyViewerRPC_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewerRPCObserver == 0)
    {
        ViewerRPCObserver = new ObserverToCallback(subj,
            PyViewerRPC_CallLogRoutine, (void *)data);
    }

}

void
PyViewerRPC_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewerRPCObserver;
    ViewerRPCObserver = 0;
}

PyMethodDef *
PyViewerRPC_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewerRPCMethods;
}

bool
PyViewerRPC_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewerRPCType);
}

ViewerRPC *
PyViewerRPC_FromPyObject(PyObject *obj)
{
    ViewerRPCObject *obj2 = (ViewerRPCObject *)obj;
    return obj2->data;
}

PyObject *
PyViewerRPC_New()
{
    return NewViewerRPC(0);
}

PyObject *
PyViewerRPC_Wrap(const ViewerRPC *attr)
{
    return WrapViewerRPC(attr);
}

void
PyViewerRPC_SetParent(PyObject *obj, PyObject *parent)
{
    ViewerRPCObject *obj2 = (ViewerRPCObject *)obj;
    obj2->parent = parent;
}

void
PyViewerRPC_SetDefaults(const ViewerRPC *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewerRPC(*atts);
}

