/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             arial_font.C                                  //
// ************************************************************************* //

#include <qgl.h>
#include "Font.h"

// THE NEXT 1200 LINES ARE FROM MESHTV's FILE spi/arial.h

/* Coordinates for nice_font_x. There are 238 unique numbers. */
static float nice_font_x[] = {
0.16943, 0.11279, 0.08594, 0.19482, 0.19092, 0.08984, 0.12402, 
0.07031, 0.04590, 0.14600, 0.28467, 0.23193, 0.20801, 0.30811, 
0.05029, 0.09277, 0.01025, 0.10742, 0.18066, 0.21680, 0.14355, 
0.37061, 0.15820, 0.20068, 0.27393, 0.38525, 0.42773, 0.50146, 
0.33398, 0.45898, 0.54346, 0.44434, 0.40771, 0.39307, 0.35059, 
0.27734, 0.31934, 0.16602, 0.30078, 0.24902, 0.03564, 0.13818, 
0.07349, 0.39526, 0.11719, 0.42236, 0.49170, 0.40088, 0.36841, 
0.16382, 0.38867, 0.41895, 0.45557, 0.49536, 0.50928, 0.45117, 
0.10132, 0.05811, 0.09668, 0.36426, 0.21094, 0.26587, 0.28760, 
0.13477, 0.60303, 0.67432, 0.56421, 0.52100, 0.55957, 0.67188, 
0.78345, 0.82764, 0.72925, 0.75098, 0.61938, 0.59766, 0.47510, 
0.38037, 0.26953, 0.04297, 0.21338, 0.25879, 0.17236, 0.58496, 
0.14893, 0.18335, 0.31055, 0.24683, 0.22314, 0.29639, 0.43042, 
0.34180, 0.47021, 0.50439, 0.53223, 0.64404, 0.12061, 0.06641, 
0.06055, 0.16162, 0.23535, 0.03125, 0.05371, 0.22754, 0.33154, 
0.35400, 0.31641, 0.12744, 0.52832, 0.08301, 0.00000, 0.37598, 
0.44775, 0.48242, 0.40503, 0.17725, 0.13184, 0.23779, 0.15234, 
0.04053, 0.41211, 0.48486, 0.29102, 0.32324, 0.09912, 0.01270, 
0.33936, 0.29346, 0.51611, 0.43286, 0.49756, 0.28125, 0.39795, 
0.27173, 0.07593, 0.36011, 0.47778, 0.51221, 0.41455, 0.25342, 
0.42480, 0.32886, 0.25586, 0.24463, 0.56689, 0.55054, 0.57617, 
0.61328, 0.43506, 0.34619, 0.24023, 0.44116, 0.58032, 0.64111, 
0.65771, 0.74512, 0.66016, 0.69434, 0.76123, 0.89062, 0.97900, 
0.89355, 0.54688, 0.34839, 0.53809, 0.71655, 0.75562, 0.84106, 
0.90771, 0.88281, 0.95508, 0.85034, 0.85547, 0.60669, 0.66846, 
0.20508, 0.37305, 0.55420, 0.46753, 0.43823, 0.46533, 0.59253, 
0.46167, 0.58789, 0.68262, 0.19800, 0.53442, 0.57129, 0.64990, 
0.07910, 0.62256, 0.70459, 0.18799, 0.02881, 0.22070, 0.52344, 
0.66504, 0.62988, 0.69116, 0.73291, 0.68896, 0.63525, 0.35693, 
0.48730, 0.52588, 0.74121, 0.71338, 0.70068, 0.60034, 0.14062, 
0.68579, 0.70947, 0.59033, 0.20288, 0.02344, 0.61719, 0.00439, 
0.72510, 0.83740, 0.93262, 0.73633, 0.02002, 0.26172, 0.15576, 
0.02637, -0.01514, 0.38281, 0.10376, 0.06274, 0.33691, -0.04590, 
-0.02930, 0.76855, 0.17480, 0.01758, 0.00732, 0.30566, 0.03809
};

/* Coordinates for nice_font_y. There are 241 unique numbers. */
static float nice_font_y[] = {
0.17773, 0.55713, 0.71582, 0.00000, 0.10010, 0.46240, 0.59863, 
-0.01221, 0.19580, 0.26855, 0.44580, 0.51855, 0.72803, -0.10303, 
-0.01514, 0.01440, 0.08301, 0.19873, 0.21533, 0.11133, 0.05908, 
0.32666, 0.33887, 0.38086, 0.54004, 0.27466, 0.69189, 0.73975, 
0.78174, 0.69482, 0.56348, 0.54980, 0.62915, 0.66553, 0.62549, 
0.54688, 0.47168, 0.42334, 0.41211, 0.38623, 0.34229, 0.28076, 
0.10352, 0.20361, 0.05127, 0.39795, 0.54395, 0.67432, 0.67993, 
0.34961, 0.43848, 0.63940, 0.53516, -0.02637, 0.02222, 0.16797, 
0.29858, 0.35205, 0.30396, 0.16260, 0.03418, 0.06250, 0.26343, 
0.29150, 0.15918, 0.01196, 0.31714, 0.06543, 0.09009, 0.15381, 
0.50146, 0.56836, 0.65576, 0.63281, 0.57666, 0.45752, 0.68311, 
0.57275, 0.40088, 0.23730, 0.59619, -0.21045, 0.00439, 0.25928, 
0.48193, 0.58301, 0.44238, 0.60645, 0.46484, 0.52832, 0.11572, 
0.31201, 0.39404, 0.58887, -0.08911, -0.14160, -0.06812, 0.67676, 
0.71875, 0.52222, 0.14966, 0.03003, 0.11865, 0.64600, 0.56006, 
0.45410, 0.62305, 0.15625, 0.41626, 0.51172, 0.61011, 0.66162, 
0.43555, 0.22217, 0.13208, 0.04346, 0.18896, 0.09302, 0.30933, 
0.20947, 0.61426, 0.67017, 0.53271, 0.44824, 0.17139, 0.25195, 
0.37769, 0.70605, 0.42969, 0.47461, 0.40967, 0.23486, 0.24268, 
0.10791, 0.07471, 0.36914, 0.23193, 0.22705, 0.01855, 0.14502, 
0.06860, 0.33496, 0.63672, 0.32397, 0.20654, 0.07935, 0.16553, 
0.08691, 0.36304, 0.32031, 0.30713, 0.47705, 0.65234, 0.60156, 
0.21191, 0.37256, 0.12817, 0.41846, 0.50781, 0.42090, 0.28564, 
0.62061, 0.61694, 0.29395, 0.13574, 0.21753, 0.03760, 0.07080, 
0.38965, 0.49023, 0.51514, -0.09521, 0.00928, -0.13818, -0.17944, 
-0.18262, -0.09888, 0.45093, 0.60425, 0.65869, 0.09668, 0.50391, 
0.33057, 0.27710, 0.14722, 0.04736, 0.49756, 0.36523, 0.35449, 
0.70288, 0.36035, 0.42578, 0.24805, 0.35693, 0.34717, 0.70898, 
0.37549, -0.05566, 0.31445, 0.02759, 0.12280, 0.25586, 0.52588, 
0.64307, -0.19873, -0.12598, -0.13525, 0.18091, 0.13916, 0.45972, 
0.40430, 0.48755, 0.40723, -0.16870, -0.04297, -0.11328, 0.26562, 
0.07715, -0.20117, -0.11548, -0.16162, 0.30127, 0.46924, 0.28320, 
0.00684, 0.05371, 0.27148, 0.21973, 0.49414, -0.00684, 0.69971, 
-0.02246, -0.19019, 0.72314, -0.07422, -0.12061, -0.16626, -0.07666, 
-0.20508, -0.03320, 0.59277
};

/*
 * This array gives the x indices into the x coordinate array nice_font_x.
 * Every three numbers represents an index into the nice_font_x array that
 * gives the actual coordinate.
 */
static unsigned char nice_triangle_x_index[] = {
/* Character '!' X coordinate indices. */
   0,    1,    2,    0,    2,    2,    0,    2,    3,    3,    3,    0,
   4,    5,    5,    5,    4,    4,
/* Character '"' X coordinate indices. */
   6,    7,    8,    6,    8,    8,    6,    8,    9,    9,    9,    6,
  10,   11,   12,   10,   12,   12,   10,   12,   13,   13,   13,   10,
/* Character '#' X coordinate indices. */
   6,   14,   15,   15,   16,   16,   15,   16,   17,    6,   15,   17,
   6,   17,   18,   19,   18,   17,   19,   17,   20,   20,   16,   16,
  19,   20,   16,   21,   19,   16,   21,   16,   22,   22,   23,   24,
  22,   24,   11,   21,   22,   11,   21,   11,   25,   21,   25,   26,
  21,   26,   27,   28,   21,   27,   28,   27,   29,   29,   30,   30,
  29,   30,   31,   28,   29,   31,   28,   31,   32,   32,   30,   30,
  28,   32,   30,   18,   28,   30,   18,   30,   33,   33,   34,   35,
  33,   35,   36,   18,   33,   36,   18,   36,   37,   18,   37,    6,
/* Character '$' X coordinate indices. */
  38,   39,   39,   39,   20,    7,   39,    7,   40,   40,    6,   22,
  39,   40,   22,   39,   22,   39,   38,   39,   39,   38,   38,   39,
  38,   39,   39,   38,   39,   41,   38,   41,   42,   38,   42,   14,
  43,   38,   14,   14,   44,   39,   39,   39,   38,   14,   39,   38,
  14,   38,   38,   38,   45,   46,   46,   47,   48,   38,   46,   48,
  38,   48,   38,   38,   38,   39,   38,   39,    0,   14,   38,    0,
  14,    0,   41,   14,   41,   49,   43,   14,   49,   43,   49,   39,
  39,   39,   38,   39,   38,   38,   43,   39,   38,   43,   38,   50,
  51,   43,   50,   51,   50,   52,   51,   52,   53,   25,   51,   53,
  25,   53,   54,   25,   54,   55,   38,   25,   55,   39,   38,   55,
  39,   55,   38,   39,   38,   38,
/* Character '%' X coordinate indices. */
  56,   57,   58,   58,   12,   36,   36,   59,   36,   36,   12,   60,
  36,   60,   61,   36,   36,   61,   36,   61,   62,   36,   62,   61,
  36,   61,   60,   58,   36,   60,   58,   60,   22,   56,   58,   22,
  56,   22,   63,   56,   63,   22,   56,   22,   60,   60,   12,   56,
  10,   60,   64,   64,   65,   10,   66,   67,   68,   68,   69,   70,
  70,   71,   70,   70,   65,   65,   70,   65,   72,   70,   70,   72,
  70,   72,   73,   70,   73,   72,   70,   72,   65,   68,   70,   65,
  68,   65,   74,   66,   68,   74,   66,   74,   75,   66,   75,   74,
  66,   74,   65,   65,   65,   66,
/* Character '&' X coordinate indices. */
  76,   77,   78,   78,   58,   79,   79,    2,   80,   79,   80,   81,
  79,   81,   49,   79,   49,   41,   79,   41,   82,   78,   79,   82,
  78,   82,   78,   76,   78,   78,   76,   78,   34,   76,   34,   51,
  83,   76,   51,   83,   51,   81,   83,   81,   80,   83,   80,   84,
  83,   84,   63,   63,   85,   86,   86,   13,   87,   63,   86,   87,
  63,   87,   88,   63,   88,   11,   83,   63,   11,   83,   11,   81,
  83,   81,   89,   59,   13,   86,   59,   86,   90,   25,   59,   90,
  21,   25,   90,   21,   90,   76,   89,   21,   76,   89,   76,   91,
  83,   89,   91,   83,   91,   92,   92,   93,   75,   92,   75,   94,
  83,   92,   94,   94,   95,   83,
/* Character ''' X coordinate indices. */
  96,   97,    8,   96,    8,    8,   96,    8,    9,    9,    9,   96,
/* Character '(' X coordinate indices. */
  89,   11,    1,   89,    1,   98,   98,   58,   11,   11,   89,   19,
  98,   11,   19,   98,   19,   82,   98,   82,   84,   98,   84,   89,
/* Character ')' X coordinate indices. */
  88,   56,   40,   88,   40,   18,   88,   18,   99,   44,   40,   56,
  99,   44,   56,   99,   56,  100,   88,   99,  100,  100,   24,   88,
/* Character '*' X coordinate indices. */
  84,  101,  102,   84,  102,   37,   37,   22,  103,   84,   37,  103,
  84,  103,   19,   84,   19,  104,   84,  104,  105,   84,  105,   11,
  84,   11,  106,  106,   81,    4,   84,  106,    4,   84,    4,  107,
 107,    7,   84,
/* Character '+' X coordinate indices. */
  28,   39,   39,   39,  102,  102,   39,  102,   39,   28,   39,   39,
  28,   39,   39,   39,   28,   28,   28,  108,  108,   28,  108,   28,
  39,   28,   28,   39,   28,   28,
/* Character ',' X coordinate indices. */
  41,    5,    5,   41,    5,    4,   41,    4,    4,   41,    4,    0,
   0,   17,  109,    0,  109,    6,    0,    6,   41,
/* Character '-' X coordinate indices. */
  38,  101,  101,  101,   38,   38,
/* Character '.' X coordinate indices. */
   4,    5,    5,    5,    4,    4,
/* Character '/' X coordinate indices. */
   7,  110,   12,   12,   35,    7,
/* Character '0' X coordinate indices. */
   1,   79,   97,    1,   97,    9,    9,   24,  111,    9,  111,  112,
 112,   46,   54,  112,   54,  113,  112,  113,  114,  114,   24,   24,
 114,   24,  111,  114,  111,   51,  112,  114,   51,  112,   51,  111,
 112,  111,   24,    9,  112,   24,    9,   24,  115,    9,  115,  116,
   1,    9,  116,    1,  116,   82,    1,   82,   24,   24,   24,    1,
/* Character '1' X coordinate indices. */
  21,   21,   10,   21,   10,   10,   21,   10,   23,   21,   23,   17,
  17,   17,  117,   21,   17,  117,  117,  106,   21,
/* Character '2' X coordinate indices. */
 118,   27,   27,  118,   27,  101,  118,  101,  119,  118,  119,   58,
 118,   58,   80,  118,   80,   21,  115,   41,    8,  115,    8,   44,
  35,  115,   44,   35,   44,   35,  111,   35,   35,  111,   35,   31,
 120,  111,   31,  120,   31,   27,   21,  120,   27,   21,   27,  121,
  21,  121,   26,   21,   26,  122,   21,  122,    4,   21,    4,  118,
/* Character '3' X coordinate indices. */
   1,   79,  116,    1,  116,   18,    1,   18,   78,   35,   19,   88,
 111,   35,   88,  111,   88,  117,  111,  117,   91,   51,  111,   91,
  18,   41,   14,   18,   14,    6,   78,   18,    6,   78,    6,   61,
  34,   78,   61,   34,   61,  111,   25,   34,  111,   25,  111,   55,
  91,   25,   55,   91,   55,   76,   91,   76,   55,   91,   55,  111,
  51,   91,  111,   51,  111,   76,  111,   51,   76,  111,   76,   54,
 111,   54,   31,   78,  111,   31,    1,   78,   31,   31,   78,    1,
/* Character '4' X coordinate indices. */
 120,  123,  123,  120,  123,  123,  120,  123,  123,  124,  123,  123,
 124,  123,  125,  123,  124,  125,  123,  125,  125,  123,  125,  126,
 120,  123,  126,  126,  120,  120,  120,   54,   54,  120,   54,  120,
 126,  120,  120,  126,  120,  120,
/* Character '5' X coordinate indices. */
   1,   79,   63,    1,   63,   18,    1,   18,   78,    3,   41,   57,
 107,  113,  113,  107,  113,    3,   57,  107,    3,   57,    3,   22,
   3,   57,   22,   78,    3,   22,   78,   22,  127,   77,   78,  127,
  77,  127,   55,   45,   77,   55,   45,   55,  128,   77,   45,  128,
  77,  128,   29,   78,   77,   29,    1,   78,   29,   29,   78,    1,
/* Character '6' X coordinate indices. */
 129,  130,  120,  129,  120,  111,  129,  111,   62,    6,   18,   41,
 131,   18,    6,  131,    6,   23,   77,  131,   23,   77,   23,   38,
  77,   38,  112,   45,   77,  112,   45,  112,   54,   77,   45,   54,
  77,   54,  113,   10,   77,  113,   10,  113,   47,   60,   10,   47,
  60,   47,   10,   22,   60,   10,   22,   10,   17,   41,   22,   17,
   6,   41,   17,    6,   17,   40,   84,    6,   40,   84,   40,    1,
  19,   84,    1,   62,   19,    1,  129,   62,    1,    1,   89,  129,
/* Character '7' X coordinate indices. */
 132,    8,    8,  132,    8,   54,  132,   54,   54,  132,   54,  111,
 132,  111,   78,   78,  117,    9,  132,   78,    9,  132,    9,   18,
  18,  133,  132,
/* Character '8' X coordinate indices. */
 115,    4,   35,  134,  115,   35,  134,   35,   24,  134,   24,   82,
 134,   82,  116,  134,  116,   84,   77,   24,   35,   77,   35,  135,
  45,   77,  135,   22,    4,  115,   22,  115,   58,    4,   22,   58,
   4,   58,    7,    4,    7,    6,   24,    4,    6,   24,    6,   24,
 135,   24,   24,  135,   24,   26,   33,  135,   26,   33,   26,  113,
 135,   33,  113,  135,  113,   52,  135,   52,  111,   45,  135,  111,
  45,  111,  136,   77,   45,  136,   77,  136,  137,   77,  137,  112,
  35,   77,  112,   35,  112,   35,   23,   35,   35,   84,   23,   35,
  84,   35,   17,  134,   84,   17,   17,  119,  134,
/* Character '9' X coordinate indices. */
  44,  102,   41,   44,   41,   18,   44,   18,   81,   45,  111,  138,
  24,  111,   45,   24,   45,   34,   82,   24,   34,   82,   34,  139,
  82,  139,   56,  116,   82,   56,  116,   56,   79,  115,  116,   79,
 115,   79,   17,   35,  115,   17,   35,   17,   61,  111,   35,   61,
 111,   61,   33,  138,  111,   33,  138,   33,  113,   45,  138,  113,
 140,   45,  113,  120,  140,  113,  120,  113,  137,   77,  120,  137,
  77,  137,  113,  141,   77,  113,  141,  113,   33,   81,  141,   33,
  44,   81,   33,   33,  142,   44,
/* Character ':' X coordinate indices. */
   4,    5,    5,    5,    4,    4,    4,    5,    5,    5,    4,    4,
/* Character ';' X coordinate indices. */
   4,    5,    5,    5,    4,    4,   41,    5,    5,   41,    5,    4,
  41,    4,    4,   41,    4,    0,    0,   17,  109,    0,  109,    6,
   0,    6,   41,
/* Character '<' X coordinate indices. */
 108,  102,  102,  102,  108,  108,  102,  108,  118,  108,  102,  118,
 118,  108,  108,
/* Character '=' X coordinate indices. */
 108,  108,  102,  102,  102,  108,  108,  108,  102,  102,  102,  108,
/* Character '>' X coordinate indices. */
 108,  108,  102,  102,  102,   90,  108,  102,   90,  108,   90,  102,
 102,  102,  108,
/* Character '?' X coordinate indices. */
 106,   11,   11,  106,   11,  143,  106,  143,   35,   85,   63,    8,
  85,    8,   44,   35,   85,   44,   35,   44,   24,  111,   35,   24,
 111,   24,   31,  138,  111,   31,  138,   31,   93,   47,  138,   93,
  91,   47,   93,   35,   91,   93,   35,   93,  113,   35,  113,  132,
  35,  132,   91,   35,   91,  123,   35,  123,  106,  123,   88,   88,
  88,  123,  123,
/* Character '@' X coordinate indices. */
 144,  145,   75,  146,  144,   75,  146,   75,  147,   46,  145,  144,
 148,   46,  144,  148,  144,   53,   59,  148,   53,   59,   53,   51,
  59,   51,   28,  104,   59,   28,  104,   28,   61,  149,  104,   61,
 149,   61,  150,   50,  149,  150,   50,  150,  131,  151,   50,  131,
 151,  131,   77,   27,  151,   77,   27,   77,   46,  152,   27,   46,
 152,   46,  146,  147,  152,  146,  147,  146,  153,  146,  147,  153,
 146,  153,  154,  146,  154,  155,  146,  155,   65,  146,   65,  156,
 146,  156,   69,  146,   69,  157,  158,  159,  160,  158,  160,  161,
 162,  158,  161,  162,  161,   73,  141,  162,   73,  141,   73,  162,
 141,  162,  163,  115,  141,  163,  115,  163,    4,  107,  115,    4,
 107,    4,   58,  107,   58,  102,  115,  107,  102,  115,  102,   56,
 123,  115,   56,  123,   56,   24,   94,  123,   24,   94,   24,  164,
 165,   94,  164,  165,  164,  166,  167,  165,  166,  167,  166,  168,
 169,  167,  168,  169,  168,  170,  171,  169,  170,  171,  170,  172,
 158,  171,  172,  157,  158,  172,  146,  157,  172,  146,  172,  156,
 156,  173,  146,
/* Character 'A' X coordinate indices. */
 124,  110,   24,  111,  174,   68,  111,   68,   76,   76,  115,  175,
  76,  175,  112,  111,   76,  112,  111,  112,  176,  111,  176,  123,
  24,  111,  123,  124,   24,  123,  123,   10,  175,  124,  123,  175,
 175,  115,  124,
/* Character 'B' X coordinate indices. */
  42,   91,   76,   42,   76,  145,  145,  152,  177,  145,  177,  136,
 136,  120,  178,  145,  136,  178,  145,  178,  121,  145,  121,   92,
 145,   92,   51,   42,  145,   51,   42,   51,   86,   42,   86,    0,
  42,   42,    0,   42,    0,    0,  123,  120,  136,    0,  123,  136,
   0,  136,  179,    0,  179,   28,    0,   28,    0,   42,    0,    0,
  42,    0,    0,  149,   42,    0,  149,    0,  149,  149,  149,  120,
 149,  120,  180,   53,  179,  136,  128,   53,  136,  128,  136,  152,
  27,  128,  152,   27,  152,  147,  180,   27,  147,  149,  180,  147,
 149,  147,  181,  149,  181,  164,  164,  182,  149,
/* Character 'C' X coordinate indices. */
 137,  183,  184,  137,  184,  146,  137,  146,   25,   25,  185,    2,
   2,   14,   15,    2,   15,   80,   80,   50,  144,  144,   69,  146,
 144,  146,   93,  144,   93,   25,   80,  144,   25,   80,   25,   39,
  80,   39,    0,    2,   80,    0,    2,    0,    9,    2,    9,   82,
   2,   82,   81,   25,    2,   81,   25,   81,   77,   25,   77,  137,
/* Character 'D' X coordinate indices. */
 134,  123,  123,  134,  123,   82,  134,  134,   82,  134,   82,   82,
  28,  134,   82,   28,   82,  123,   28,  123,  148,   28,  148,   27,
  31,  123,  123,   31,  123,   55,  186,   31,   55,  186,   55,  177,
 187,  186,  177,  187,  177,  153,  145,  187,  153,  145,  153,  174,
  27,  145,  174,   27,  174,  188,   28,   27,  188,   28,  188,   64,
  28,   64,  186,  186,   55,   28,
/* Character 'E' X coordinate indices. */
 189,   75,   75,  189,   75,   82,  189,  189,   82,  189,   82,   82,
  82,  187,  187,   82,  187,   82,  189,   82,   82,  189,   82,   82,
 147,  189,   82,   82,  147,  147,
/* Character 'F' X coordinate indices. */
 115,  109,  109,  109,   66,   66,  109,   66,  115,  109,  115,  115,
 115,  137,  137,  115,  137,  115,  109,  115,  115,  109,  115,  115,
/* Character 'G' X coordinate indices. */
 190,  120,  120,  190,  120,  165,  190,  165,  165,  165,  187,   51,
 165,   51,  103,  103,   58,  102,  102,   58,   88,   88,  120,  145,
  88,  145,  188,  188,  191,   74,  188,   74,  152,  188,  152,   54,
  88,  188,   54,   88,   54,  120,   88,  120,   38,   88,   38,   88,
 102,   88,   88,  102,   88,  115,  102,  115,   84,  102,   84,   85,
 103,  102,   85,  103,   85,  131,  103,  131,  120,  165,  103,  120,
 165,  120,   94,  165,   94,  190,  165,  190,  190,
/* Character 'H' X coordinate indices. */
  82,  189,  189,  189,   82,   82,   30,   30,  153,   30,  153,  153,
 153,   30,   30,   30,  153,   30,   82,   30,   30,   82,   30,   82,
 189,   82,   82,  189,   82,   82,
/* Character 'I' X coordinate indices. */
 192,   15,   15,   15,  192,  192,
/* Character 'J' X coordinate indices. */
 134,  193,    1,  134,    1,    9,  134,    9,  194,  141,  141,   45,
  36,  141,   45,   36,   45,   45,  131,   36,   45,  131,   45,   47,
 194,  131,   47,  134,  194,   47,  134,   47,  104,  104,   88,  134,
/* Character 'K' X coordinate indices. */
   0,   42,   42,   42,    0,    0,    0,  195,  188,    0,  188,   34,
  34,  196,  164,   34,  164,   10,    0,   34,   10,    0,   10,    0,
  42,    0,    0,   42,    0,    0,
/* Character 'L' X coordinate indices. */
  42,   42,    0,   42,    0,    0,   67,   42,    0,    0,   67,   67,
/* Character 'M' X coordinate indices. */
  37,   42,   42,   19,   25,   45,   45,   29,  197,  166,  166,  196,
 166,  196,  196,  197,  166,  196,   45,  197,  196,   45,  196,   29,
  45,   29,   21,   19,   45,   21,   19,   21,   37,   42,   19,   37,
  42,   37,   37,
/* Character 'N' X coordinate indices. */
  37,  134,  134,  134,   82,  145,  145,  145,  153,  145,  153,  153,
 134,  145,  153,  134,  153,   30,  134,   30,   37,  134,   37,   37,
/* Character 'O' X coordinate indices. */
   5,   14,    9,    9,   33,  187,  187,  198,  199,  187,  199,  200,
 200,   66,   50,  200,   50,   50,  200,   50,   66,  200,   66,  201,
 200,  201,  173,  187,  200,  173,  187,  173,   67,  187,   67,   33,
   9,  187,   33,    9,   33,   19,    5,    9,   19,    5,   19,    9,
   5,    9,   19,    5,   19,   50,    5,   50,   50,   50,   12,    5,
/* Character 'P' X coordinate indices. */
  82,  134,  134,  134,  149,   52,  134,   52,   30,  134,   30,   64,
  64,  190,   66,   66,  105,   82,   66,   82,   82,   66,   82,  202,
  66,  202,  203,   64,   66,  203,   64,  203,  204,   64,  204,   27,
  64,   27,   31,  134,   64,   31,  134,   31,  105,  134,  105,   82,
 134,   82,   82,  134,   82,   82,  134,   82,   82,
/* Character 'Q' X coordinate indices. */
  74,  205,  206,   74,  206,   68,  207,   74,   68,  207,   68,   25,
  25,   25,  113,  207,   25,  113,  113,   50,  120,  113,  120,  162,
 207,  113,  162,  207,  162,  197,  207,  197,  208,   12,   25,   25,
  12,   25,   12,  209,   12,   12,  209,   12,    2,  209,    2,   79,
  60,  209,   79,   60,   79,    2,   25,   60,    2,   25,    2,   12,
  25,   12,   25,  137,   25,   25,  137,   25,   66,  208,  137,   66,
 207,  208,   66,  207,   66,  210,  210,   72,  207,
/* Character 'R' X coordinate indices. */
  82,  189,  189,  189,   43,   47,  189,   47,   82,  189,   82,   82,
 128,   47,   43,  128,   43,   30,  177,  128,   30,  177,   30,   74,
  94,  177,   74,   94,   74,  188,  136,   94,  188,  136,  188,   64,
 111,  136,   64,   82,  111,   64,   82,   64,   55,   82,   55,   93,
  82,   93,   83,   83,  211,  212,   83,  212,   53,   83,   53,   26,
  83,   26,   77,   82,   83,   77,   82,   77,   28,   82,   28,   10,
  82,   10,   82,  189,   82,   82,  189,   82,   82,
/* Character 'S' X coordinate indices. */
   2,    8,   63,    2,   63,   49,    2,   49,  100,    2,  100,  149,
 151,   86,   82,  151,   82,   58,  151,   58,    7,    7,   56,    3,
   7,    3,  123,  123,  180,   68,  123,   68,  181,  181,   27,   55,
 123,  181,   55,  123,   55,  141,  123,  141,  213,    7,  123,  213,
   7,  213,   49,    7,   49,    4,  151,    7,    4,   93,  151,    4,
  93,    4,   28,   93,   28,   46,  195,   93,   46,  195,   46,   83,
  27,  195,   83,   27,   83,  147,  151,   27,  147,  151,  147,  152,
 149,  151,  152,  149,  152,  203,    2,  149,  203,    2,  203,   34,
  34,  192,    2,
/* Character 'T' X coordinate indices. */
 105,   81,   81,   81,  214,  214,   81,  214,  181,  181,  181,  105,
  81,  181,  105,   81,  105,  105,
/* Character 'U' X coordinate indices. */
 162,  162,  153,  162,  153,  153,  162,  153,  215,  162,  215,  108,
 108,  135,  185,  108,  185,   17,   17,  189,  189,   17,  189,   82,
  17,   82,   82,   17,   82,    4,   17,    4,   39,  108,   17,   39,
 108,   39,  105,  108,  105,   27,  108,   27,  162,
/* Character 'V' X coordinate indices. */
 131,  216,   17,  131,   17,  122,  131,  122,  104,   77,  131,  104,
  77,  104,   21,   77,   21,   66,   66,  154,   77,
/* Character 'W' X coordinate indices. */
  23,   16,   17,   23,   17,   19,   23,   19,   39,   38,   23,   39,
  38,   39,  131,   38,  131,   51,   94,  201,  198,  198,  217,  218,
 198,  218,  219,  198,  219,  220,  198,  220,   95,   94,  198,   95,
  94,   95,   53,   94,   53,   92,   51,   94,   92,   38,   51,   92,
  92,   55,   38,
/* Character 'X' X coordinate indices. */
  44,  216,  131,  131,   40,   84,  131,   84,  131,  131,  131,  126,
  44,  131,  126,   44,  126,   33,   44,   33,  164,  164,  153,   50,
  50,  156,   30,   50,   30,   59,   50,   59,   28,  164,   50,   28,
  44,  164,   28,   28,   89,   44,
/* Character 'Y' X coordinate indices. */
 176,   35,   35,   35,  216,   44,   35,   44,   81,  176,   35,   81,
 176,   81,   28,   28,  120,  145,   28,  145,  154,   28,  154,  176,
  28,  176,  176,
/* Character 'Z' X coordinate indices. */
  83,  221,  221,  221,   25,   29,   29,   98,   98,   29,   98,  146,
 221,   29,  146,  221,  146,  146,  221,  146,   82,  221,   82,  107,
  83,  221,  107,  107,   83,   83,
/* Character '[' X coordinate indices. */
  97,  222,  222,   97,  222,  223,   97,   97,  223,   97,  223,  223,
 222,   97,  223,  223,  222,  222,
/* Character '\' X coordinate indices. */
  35,   12,  110,  110,    7,   35,
/* Character ']' X coordinate indices. */
  60,  221,  221,   60,  221,    6,   60,   60,    6,   60,    6,    6,
  60,    6,  221,  221,  221,   60,
/* Character '^' X coordinate indices. */
  11,   44,  224,   11,  224,   23,   11,   23,   78,   11,   78,   31,
  31,  105,   11,
/* Character '_' X coordinate indices. */
 144,  225,  225,  225,  144,  144,
/* Character '`' X coordinate indices. */
  99,  103,   22,   22,   79,   99,
/* Character 'a' X coordinate indices. */
 114,   86,   80,  114,   80,  109,  109,   40,  102,  109,  102,  124,
 109,  124,   49,  150,   43,   43,   49,  150,   43,   49,   43,  139,
  49,  139,  115,   49,  115,   20,  109,   49,   20,  109,   20,  116,
 109,  116,   22,  109,   22,  100,  114,  109,  100,  114,  100,  123,
 114,  123,  226,  114,  226,   43,   45,  114,   43,   45,   43,   43,
  45,   43,   43,   45,   43,  132,   18,   41,   14,   18,   14,    5,
  24,   18,    5,   24,    5,    0,   21,   24,    0,   21,    0,   10,
  21,   10,   33,  132,   21,   33,   45,  132,   33,   45,   33,   52,
  45,   52,  113,   45,  113,  121,   45,  121,  121,   45,  121,   46,
  46,  137,   45,
/* Character 'b' X coordinate indices. */
   9,    9,   97,    9,   97,   97,   97,  118,  118,  118,  192,    9,
  97,  118,    9,    9,   97,    9,    9,    9,    0,    9,    0,   10,
  62,  192,  118,   62,  118,   89,   25,   62,   89,   25,   89,   25,
 140,   25,   25,  140,   25,   52,  140,   52,   27,   25,  140,   27,
  25,   27,  128,   25,  128,   55,   10,   25,   55,   10,   55,  122,
  10,  122,    9,
/* Character 'c' X coordinate indices. */
 135,  114,   46,  135,   46,   51,  135,   51,   24,  227,  119,   97,
 227,   97,  118,  118,   24,  120,  120,  113,   43,  120,   43,  105,
 120,  105,   35,  118,  120,   35,  118,   35,    0,  118,    0,  107,
 227,  118,  107,  227,  107,    0,   24,  227,    0,   24,    0,   24,
  24,   24,  135,
/* Character 'd' X coordinate indices. */
 113,   47,   47,  113,   47,   59,  113,   59,  114,  113,  114,   59,
  61,   59,   47,   61,   47,   81,   37,   61,   81,   37,   81,   20,
   6,   37,   20,    6,   20,  228,   49,    6,  228,   49,  228,   40,
  49,   40,   57,  222,   49,   57,  222,   57,   41,  222,   41,  139,
  59,  222,  139,   59,  139,  229,  113,   59,  229,  113,  229,   43,
 113,   43,   43,   43,  113,  113,
/* Character 'e' X coordinate indices. */
  48,   45,  137,   48,  137,   90,   48,   90,   10,   10,   56,   40,
 227,   35,  131,  227,  131,  115,   40,  227,  115,   40,  115,  116,
  40,  116,   45,   50,  131,   35,   50,   35,  112,   45,   50,  112,
  45,  112,  128,   40,   45,  128,   40,  128,  128,   40,  128,  107,
  40,  107,  115,   10,   40,  115,   10,  115,   10,   10,   10,   48,
/* Character 'f' X coordinate indices. */
  82,    2,    2,    2,   16,   16,    2,   16,    2,   82,    2,    2,
  82,    2,    2,   82,    2,   58,   82,   58,  209,  209,   11,   86,
 209,   86,   38,  209,   38,   39,  209,   39,    4,  209,    4,   82,
 209,   82,   82,   82,   24,   24,   82,   24,   82,  209,   82,   82,
 209,   82,   82,
/* Character 'g' X coordinate indices. */
 227,   14,   63,  227,   63,   37,  227,   37,  139,   47,   59,   32,
  61,   59,   47,   61,   47,  142,   49,   61,  142,   49,  142,    5,
   6,   49,    5,    6,    5,  101,   49,    6,  101,   49,  101,   57,
 222,   49,   57,  222,   57,   41,  222,   41,   81,   59,  222,   81,
  59,   81,   32,   32,   59,   32,   32,   32,  203,   32,   32,  203,
  47,   32,  203,   33,   47,  203,   33,  203,  203,   34,   33,  203,
  34,  203,  180,  139,   34,  180,  227,  139,  180,  227,  180,   25,
  25,  139,  227,
/* Character 'h' X coordinate indices. */
 118,   97,   97,   97,  118,  118,  118,   13,   32,   32,   92,  203,
  32,  203,  203,   32,  203,   47,   32,   47,   47,   32,   47,   21,
  32,   21,  122,  118,   32,  122,  118,  122,   19,  118,   19,    0,
  97,  118,    0,   97,    0,  118,   97,  118,  118,
/* Character 'i' X coordinate indices. */
 118,   97,   97,   97,  118,  118,  118,   97,   97,   97,  118,  118,
/* Character 'j' X coordinate indices. */
 118,   97,   97,   97,  118,  118,  214,  230,  231,  214,  231,   16,
 214,   16,   14,   97,   97,  118,   14,   97,  118,   14,  118,  118,
 214,   14,  118,  118,  107,  214,
/* Character 'k' X coordinate indices. */
 118,   97,   97,   97,  118,  118,  118,   59,   76,  118,   76,   35,
  35,   53,   50,   35,   50,   19,  118,   35,   19,  118,   19,  118,
  97,  118,  118,   97,  118,  118,
/* Character 'l' X coordinate indices. */
 118,  228,  228,  228,  118,  118,
/* Character 'm' X coordinate indices. */
 118,   97,   97,   97,    9,    9,  118,   97,    9,    9,   12,   38,
   9,   38,   43,  112,  173,  217,  217,  232,  232,  217,  232,  184,
 217,  184,  184,  217,  184,   65,  217,   65,  153,  217,  153,  183,
 112,  217,  183,  112,  183,  130,  112,  130,  182,   43,  112,  182,
  43,  182,  182,   43,  182,  111,   43,  111,  111,   43,  111,   34,
  43,   34,  131,    9,   43,  131,    9,  131,   80,    9,   80,    0,
   9,    0,  118,    9,  118,  118,
/* Character 'n' X coordinate indices. */
 118,   97,   97,   97,    9,    9,  118,   97,    9,    9,   13,   43,
   9,   43,   52,   52,  113,  203,   52,  203,  203,   52,  203,   47,
  52,   47,   47,   52,   47,   50,   52,   50,  105,   52,  105,  122,
   9,   52,  122,    9,  122,    3,    9,    3,  118,    9,  118,  118,
/* Character 'o' X coordinate indices. */
  56,  101,    1,    1,   35,   55,   55,   67,  203,   55,  203,   47,
  47,   35,   35,   47,   35,   25,   47,   25,   26,   55,   47,   26,
  55,   26,   25,   55,   25,   35,    1,   55,   35,    1,   35,   37,
   1,   37,    6,   56,    1,    6,   56,    6,   37,   56,   37,   35,
  35,   35,   56,
/* Character 'p' X coordinate indices. */
 118,   97,   97,   97,    9,    9,   97,    9,  192,   97,  192,    9,
 118,   97,    9,   62,  192,    9,   62,    9,   12,   25,   62,   12,
  25,   12,   89,   25,   89,  120,   26,   25,  120,   26,  120,   46,
  25,   26,   46,   25,   46,  128,   25,  128,  203,   10,   25,  203,
  10,  203,  114,   10,  114,  122,  192,   10,  122,  192,  122,   60,
   9,  192,   60,    9,   60,  118,    9,  118,  118,
/* Character 'q' X coordinate indices. */
 113,   43,   43,   43,  126,   81,   43,   81,   56,   56,   40,   98,
  56,   98,  209,  209,  139,  114,  114,   59,  222,  209,  114,  222,
 209,  222,   37,  209,   37,    6,   56,  209,    6,   56,    6,    0,
  56,    0,   78,   43,   56,   78,   43,   78,   59,   43,   59,  114,
 113,   43,  114,  114,   59,  114,  113,  114,  114,  113,  114,  114,
 114,  113,  113,
/* Character 'r' X coordinate indices. */
 118,   97,   97,   97,    9,    9,  118,   97,    9,    9,   23,  142,
   9,  142,  149,  149,  106,  139,    9,  149,  139,    9,  139,   23,
   9,   23,    0,    9,    0,  118,    9,  118,  118,
/* Character 's' X coordinate indices. */
  58,  101,   44,   58,   44,   22,   58,   22,  139,  139,   96,   97,
 149,  139,   97,  149,   97,    8,    8,   98,  227,    8,  227,   99,
   8,   99,  100,  100,   91,  120,  100,  120,  151,  151,  105,  123,
 100,  151,  123,  100,  123,  143,  100,  143,   22,    8,  100,   22,
   8,   22,  116,    8,  116,  209,  149,    8,  209,  149,  209,  233,
 149,  233,  139,  149,  139,  226,   21,  149,  226,   21,  226,  151,
  91,   21,  151,   91,  151,  182,   91,  182,  148,  139,   91,  148,
  58,  139,  148,   58,  148,  135,  135,  139,   58,
/* Character 't' X coordinate indices. */
 194,   81,   78,  194,   78,  175,  194,  175,  116,  194,  116,   15,
  15,  109,  109,  109,  234,  234,  109,  234,  109,   15,  109,  109,
  15,  109,  109,   15,  109,    0,   15,    0,    0,    0,   81,   81,
   0,   81,    0,   15,    0,    0,   15,    0,    0,   15,    0,   82,
  15,   82,    4,   15,    4,  194,
/* Character 'u' X coordinate indices. */
 113,   32,   32,   32,  150,  223,   32,  223,   58,   58,    7,  228,
  58,  228,  228,   58,  228,  118,   58,  118,  118,   58,  118,   22,
  58,   22,    4,   58,    4,   81,   32,   58,   81,   32,   81,   28,
  32,   28,   77,  113,   32,   77,  113,   77,   43,  113,   43,   43,
  43,  113,  113,
/* Character 'v' X coordinate indices. */
 122,   12,  125,  125,   17,   19,  125,   19,   39,  122,  125,   39,
 122,   39,   10,  122,   10,  132,  132,  203,  122,
/* Character 'w' X coordinate indices. */
 139,   99,  216,  216,   15,  115,  216,  115,   12,  139,  216,   12,
 139,   12,   11,  139,   11,  106,  106,   32,  113,  106,  113,   54,
 164,  197,  206,   54,  164,  206,   54,  206,  145,  106,   54,  145,
 145,   29,   77,  145,   77,  135,  106,  145,  135,  106,  135,  139,
/* Character 'x' X coordinate indices. */
   1,  235,    3,    3,  214,  116,    3,  116,   60,    3,   60,   39,
   1,    3,   39,    1,   39,   10,    1,   10,  111,  111,  136,   38,
  38,   46,   25,   38,   25,   35,   38,   35,   39,  111,   38,   39,
 111,   39,    1,
/* Character 'y' X coordinate indices. */
  44,   98,   14,   44,   14,   56,   44,   56,   84,   44,   84,  115,
  60,  234,    1,   60,    1,   19,   60,   19,  142,  175,   60,  142,
 115,  175,  142,  142,  122,  114,  142,  114,   46,  115,  142,   46,
  44,  115,   46,   44,   46,  127,   44,  127,  143,  143,    4,   44,
/* Character 'z' X coordinate indices. */
 136,  221,  221,   34,   39,  119,   34,  119,  119,   34,  119,  182,
 221,   34,  182,  221,  182,  182,  221,  182,   18,  221,   18,  107,
 136,  221,  107,  136,  107,  117,  117,  136,  136,
/* Character '{' X coordinate indices. */
 193,  193,    5,  107,  116,   84,   96,  107,   84,   96,   84,  115,
  96,  115,   88,   88,   10,   86,   88,   86,   86,   88,   86,   89,
  88,   89,  103,   96,   88,  103,   96,  103,   60,   96,   60,   12,
   5,   96,   12,  193,    5,   12,  193,   12,  115,  193,  115,   17,
 193,   17,  192,  192,   60,   80,   89,   86,   86,   11,   89,   86,
  11,   86,   10,   11,   10,   80,   80,   11,   80,  192,   80,   80,
 192,   80,   49,  192,   49,   63,  192,   63,  107,  192,  107,   96,
 192,   96,    5,  192,    5,  193,
/* Character '|' X coordinate indices. */
   0,    5,    5,    5,    0,    0,
/* Character '}' X coordinate indices. */
 143,  236,  236,  143,  236,  143,  143,  143,   60,  175,   23,   85,
  60,  175,   85,   60,   85,  223,   60,  223,    1,  143,   60,    1,
   1,   14,  214,    1,  214,  214,    1,  214,  237,    1,  237,   17,
 143,    1,   17,    6,  107,   22,    6,   22,   88,   17,    6,   88,
 143,   17,   88,  143,   88,    9,  143,    9,    6,  237,  214,  214,
  56,  237,  214,   56,  214,   14,   56,   14,   96,   96,   56,   96,
   6,   96,   96,    6,   96,    0,    6,    0,  185,    6,  185,  175,
   6,  175,   60,    6,   60,  143
};

/*
 * This array gives the y indices into the y coordinate array nice_font_y.
 * Every three numbers represents an index into the nice_font_y array that
 * gives the actual coordinate.
 */
static unsigned char nice_triangle_y_index[] = {
/* Character '!' Y coordinate indices. */
   0,    0,    1,    0,    1,    2,    0,    2,    2,    2,    1,    0,
   3,    3,    4,    4,    4,    3,
/* Character '"' Y coordinate indices. */
   5,    5,    6,    5,    6,    2,    5,    2,    2,    2,    6,    5,
   5,    5,    6,    5,    6,    2,    5,    2,    2,    2,    6,    5,
/* Character '#' Y coordinate indices. */
   7,    7,    8,    8,    8,    9,    8,    9,    9,    7,    8,    9,
   7,    9,    9,   10,    9,    9,   10,    9,   10,   10,   10,   11,
  10,   10,   11,   10,   10,   11,   10,   11,   11,   11,   12,   12,
  11,   12,   11,   10,   11,   11,   10,   11,   11,   10,   11,   12,
  10,   12,   12,    9,   10,   12,    9,   12,   11,   11,   11,   10,
  11,   10,   10,    9,   11,   10,    9,   10,    9,    9,    9,    8,
   9,    9,    8,    9,    9,    8,    9,    8,    8,    8,    7,    7,
   8,    7,    8,    9,    8,    8,    9,    8,    8,    9,    8,    7,
/* Character '$' Y coordinate indices. */
  13,   13,   14,   14,   15,   16,   14,   16,   17,   17,   18,   19,
  14,   17,   19,   14,   19,   20,   13,   14,   20,   21,   20,   20,
  21,   20,   22,   21,   22,   23,   21,   23,   10,   21,   10,   24,
  25,   21,   24,   24,   26,   27,   27,   28,   28,   24,   27,   28,
  24,   28,   27,   27,   29,   30,   30,   31,   32,   27,   30,   32,
  27,   32,   33,   27,   33,   33,   27,   33,   34,   24,   27,   34,
  24,   34,   35,   24,   35,   36,   25,   24,   36,   25,   36,   37,
  37,   33,   33,   37,   33,   38,   25,   37,   38,   25,   38,   39,
   8,   25,   39,    8,   39,   40,    8,   40,   41,   42,    8,   41,
  42,   41,   43,   42,   43,   44,   20,   42,   44,   20,   20,   44,
  20,   44,    7,   20,    7,   13,
/* Character '%' Y coordinate indices. */
  45,   46,   47,   47,   12,   48,   48,   24,   45,   45,   49,   38,
  45,   38,   50,   48,   45,   50,   48,   50,   24,   48,   24,   51,
  48,   51,   33,   47,   48,   33,   47,   33,   51,   45,   47,   51,
  45,   51,   52,   45,   52,   50,   45,   50,   38,   38,   49,   45,
  53,   53,   12,   12,   12,   53,   54,   55,   56,   56,   57,   58,
  58,   59,   54,   54,   53,   60,   54,   60,   61,   58,   54,   61,
  58,   61,   55,   58,   55,   62,   58,   62,   63,   56,   58,   63,
  56,   63,   62,   54,   56,   62,   54,   62,   64,   54,   64,   61,
  54,   61,   60,   60,   53,   54,
/* Character '&' Y coordinate indices. */
  16,   65,    7,    7,   61,    8,    8,   66,   38,    8,   38,   57,
   8,   57,   25,    8,   25,   43,    8,   43,   19,    7,    8,   19,
   7,   19,   67,   16,    7,   67,   16,   67,   68,   16,   68,   69,
  14,   16,   69,   14,   69,   57,   14,   57,   38,   14,   38,   70,
  14,   70,   71,   71,   48,   12,   12,   72,   73,   71,   12,   73,
  71,   73,   74,   71,   74,   24,   14,   71,   24,   14,   24,   70,
  14,   70,   75,   73,   72,   12,   73,   12,   76,   77,   73,   76,
  11,   77,   76,   11,   76,   74,   75,   11,   74,   75,   74,   78,
  14,   75,   78,   14,   78,   79,   79,   22,   66,   79,   66,   59,
  14,   79,   59,   59,   44,   14,
/* Character ''' Y coordinate indices. */
   5,    5,   80,    5,   80,    2,    5,    2,    2,    2,   80,    5,
/* Character '(' Y coordinate indices. */
  81,   81,   82,   81,   82,   83,   83,   84,   12,   12,   12,   85,
  83,   12,   85,   83,   85,   86,   83,   86,   83,   83,   83,   81,
/* Character ')' Y coordinate indices. */
  82,   81,   81,   82,   81,   83,   82,   83,   86,   85,   12,   12,
  86,   85,   12,   86,   12,   84,   82,   86,   84,   84,   83,   82,
/* Character '*' Y coordinate indices. */
   1,   85,   72,    1,   72,   87,   87,   12,   12,    1,   87,   12,
   1,   12,   87,    1,   87,   72,    1,   72,   85,    1,   85,    1,
   1,    1,   88,   88,   37,   89,    1,   88,   89,    1,   89,   37,
  37,   88,    1,
/* Character '+' Y coordinate indices. */
  90,   90,   91,   91,   91,   92,   91,   92,   92,   90,   91,   92,
  90,   92,   93,   93,   93,   92,   92,   92,   91,   92,   91,   91,
  93,   92,   91,   93,   91,   90,
/* Character ',' Y coordinate indices. */
   3,    3,    4,    3,    4,    4,    3,    4,    3,    3,    3,   94,
  94,   95,   13,   94,   13,   96,   94,   96,    3,
/* Character '-' Y coordinate indices. */
  18,   18,   58,   58,   58,   18,
/* Character '.' Y coordinate indices. */
   3,    3,    4,    4,    4,    3,
/* Character '/' Y coordinate indices. */
   7,    7,   12,   12,   12,    7,
/* Character '0' Y coordinate indices. */
  61,   57,    1,   61,    1,   97,   97,   98,   29,   97,   29,   32,
  32,   99,   57,   32,   57,  100,   32,  100,  101,  101,    7,   20,
 101,   20,  102,  101,  102,   57,   32,  101,   57,   32,   57,   93,
  32,   93,  103,   97,   32,  103,   97,  103,   80,   97,   80,   57,
  61,   97,   57,   61,   57,  102,   61,  102,   20,   20,    7,   61,
/* Character '1' Y coordinate indices. */
  98,    3,    3,   98,    3,  104,   98,  104,   70,   98,   70,  105,
 105,   24,  106,   98,  105,  106,  106,   98,   98,
/* Character '2' Y coordinate indices. */
  16,   16,    3,   16,    3,    3,   16,    3,   20,   16,   20,  107,
  16,  107,   62,   16,   62,  108,   87,   70,  109,   87,  109,   33,
 103,   87,   33,  103,   33,   98,  110,  103,   98,  110,   98,  111,
  99,  110,  111,   99,  111,   11,  108,   99,   11,  108,   11,  112,
 108,  112,   49,  108,   49,  113,  108,  113,  114,  108,  114,   16,
/* Character '3' Y coordinate indices. */
 115,  116,   17,  115,   17,  117,  115,  117,   20,   49,   22,  108,
 118,   49,  108,  118,  108,  108,  118,  108,   10,  119,  118,   10,
 120,   11,   52,  120,   52,  121,  103,  120,  121,  103,  121,   98,
 120,  103,   98,  120,   98,   26,   52,  120,   26,   52,   26,   34,
  10,   52,   34,   10,   34,  122,   10,  122,  123,   10,  123,   39,
 119,   10,   39,  119,   39,   21,   42,  119,   21,   42,   21,  119,
  42,  119,   44,   20,   42,   44,  115,   20,   44,   44,    7,  115,
/* Character '4' Y coordinate indices. */
   3,    3,  124,    3,  124,  125,    3,  125,   74,  125,  125,  124,
 125,  124,  124,   74,  125,  124,   74,  124,  125,   74,  125,    2,
   3,   74,    2,    2,    2,  125,  125,  125,  124,  125,  124,  124,
   2,  125,  124,    2,  124,    3,
/* Character '5' Y coordinate indices. */
 115,  116,    8,  115,    8,  117,  115,  117,   20,  126,   21,   22,
 127,  127,  106,  127,  106,  106,   22,  127,  106,   22,  106,  128,
 126,   22,  128,   45,  126,  128,   45,  128,  129,   57,   45,  129,
  57,  129,  130,  131,   57,  130,  131,  130,  132,  133,  131,  132,
 133,  132,  134,   20,  133,  134,  115,   20,  134,  134,    7,  115,
/* Character '6' Y coordinate indices. */
 121,   24,   52,  121,   52,  110,  121,  110,  103,  135,   40,  136,
  39,   40,  135,   39,  135,   86,   40,   39,   86,   40,   86,    5,
  40,    5,   45,  137,   40,   45,  137,   45,  136,   42,  137,  136,
  42,  136,  133,   20,   42,  133,   20,  133,  138,   16,   20,  138,
  16,  138,    7,  139,   16,    7,  139,    7,  140,  136,  139,  140,
 135,  136,  140,  135,  140,  141,   52,  135,  141,   52,  141,  142,
 106,   52,  142,  103,  106,  142,  121,  103,  142,  142,   98,  121,
/* Character '7' Y coordinate indices. */
 106,  106,  127,  106,  127,  127,  106,  127,   51,  106,   51,   10,
 106,   10,    8,    8,    3,    3,  106,    8,    3,  106,    3,   43,
  43,  112,  106,
/* Character '8' Y coordinate indices. */
  39,  105,   37,  143,   39,   37,  143,   37,   49,  143,   49,  118,
 143,  118,  144,  143,  144,  114,  118,   49,   37,  118,   37,  105,
  43,  118,  105,   52,  105,   39,   52,   39,   10,  120,   52,   10,
 120,   10,   52,  120,   52,   33,  103,  120,   33,  103,   33,   98,
 120,  103,   98,  120,   98,   33,  122,  120,   33,  122,   33,  122,
 105,  122,  122,  105,  122,   10,  105,   10,   39,   43,  105,   39,
  43,   39,   66,    4,   43,   66,    4,   66,   43,    4,   43,   44,
  20,    4,   44,   20,   44,    7,  145,   20,    7,  114,  145,    7,
 114,    7,   44,  143,  114,   44,   44,  144,  143,
/* Character '9' Y coordinate indices. */
  60,  146,  124,   60,  124,  147,   60,  147,   20,   22,  148,   84,
 149,  148,   22,  149,   22,    9,  148,  149,    9,  148,    9,  132,
 148,  132,  150,  129,  148,  150,  129,  150,  151,    6,  129,  151,
   6,  151,  152,  103,    6,  152,  103,  152,   98,  153,  103,   98,
 153,   98,   48,   84,  153,   48,   84,   48,   77,   22,   84,   77,
 149,   22,   77,  154,  149,   77,  154,   77,  155,  156,  154,  155,
 156,  155,   69,  145,  156,   69,  145,   69,  101,   20,  145,  101,
  60,   20,  101,  101,    7,   60,
/* Character ':' Y coordinate indices. */
 157,  157,   11,   11,   11,  157,    3,    3,    4,    4,    4,    3,
/* Character ';' Y coordinate indices. */
 157,  157,   11,   11,   11,  157,    3,    3,    4,    3,    4,    4,
   3,    4,    3,    3,    3,   94,   94,   95,   13,   94,   13,   96,
  94,   96,    3,
/* Character '<' Y coordinate indices. */
  19,   91,   92,   92,   80,  158,   92,  158,   57,   19,   92,   57,
  57,    8,   19,
/* Character '=' Y coordinate indices. */
  70,  159,  159,  159,   70,   70,  160,   43,   43,   43,  160,  160,
/* Character '>' Y coordinate indices. */
  92,   91,   19,   19,    8,   57,   92,   19,   57,   92,   57,  158,
 158,   80,   92,
/* Character '?' Y coordinate indices. */
   0,    0,   43,    0,   43,   63,    0,   63,   49,  161,  109,   99,
 161,   99,   47,   72,  161,   47,   72,   47,   12,  162,   72,   12,
 162,   12,  121,   89,  162,  121,   89,  121,  122,  129,   89,  122,
  38,  129,  122,   49,   38,  122,   49,  122,   10,   49,   10,   49,
  49,   49,  163,   49,  163,  125,   49,  125,    0,    3,    3,    4,
   4,    4,    3,
/* Character '@' Y coordinate indices. */
 145,  164,  165,  166,  145,  165,  166,  165,   66,  147,  164,  145,
 167,  147,  145,  167,  145,   54,  133,  167,   54,  133,   54,    3,
 133,    3,   54,  154,  133,   54,  154,   54,    4,   58,  154,    4,
  58,    4,  165,  168,   58,  165,  168,  165,  155,   86,  168,  155,
  86,  155,  169,   75,   86,  169,   75,  169,   89,  157,   75,   89,
 157,   89,  158,   66,  157,  158,   66,  158,   50,  166,   66,   50,
 166,   50,  170,  166,  170,  170,  166,  170,  116,  166,  116,   19,
 166,   19,   68,  166,   68,  145,  171,  172,  172,  171,  172,  171,
 173,  171,  171,  173,  171,  174,  171,  173,  174,  171,  174,   81,
 171,   81,  175,  101,  171,  175,  101,  175,  176,   79,  101,  176,
  79,  176,  101,   79,  101,  137,  177,   79,  137,  177,  137,   75,
 178,  177,   75,  178,   75,  179,   72,  178,  179,   72,  179,   12,
 120,   72,   12,  120,   12,   48,   70,  120,   48,   70,   48,  122,
  49,   70,  122,   49,  122,   49,   18,   49,   49,   18,   49,  180,
  19,   18,  180,  145,   19,  180,  166,  145,  180,  166,  180,    3,
   3,  172,  166,
/* Character 'A' Y coordinate indices. */
   3,    3,    2,    2,    3,    3,    2,    3,   18,   18,   18,  163,
  18,  163,  163,    2,   18,  163,    2,  163,  169,    2,  169,   51,
   2,    2,   51,    3,    2,   51,   51,  181,  163,    3,   51,  163,
 163,   18,    3,
/* Character 'B' Y coordinate indices. */
   2,    2,   29,    2,   29,   32,   32,  122,   10,   32,   10,   23,
  23,   37,   75,   32,   23,   75,   32,   75,   99,   32,   99,   85,
  32,   85,  106,    2,   32,  106,    2,  106,   73,    2,   73,   73,
   3,    2,   73,    3,   73,  108,  108,   37,   23,  108,  108,   23,
 108,   23,   66,  108,   66,  182,  108,  182,  182,    3,  108,  182,
   3,  182,   16,    3,    3,   16,    3,   16,   16,    3,   16,  147,
   3,  147,  133,  183,   66,   23,  119,  183,   23,  119,   23,   66,
 184,  119,   66,  184,   66,  119,  133,  184,  119,    3,  133,  119,
   3,  119,   90,    3,   90,  185,  185,   65,    3,
/* Character 'C' Y coordinate indices. */
  90,  125,  137,   90,  137,  185,   90,  185,    7,    7,   60,  124,
 124,  148,    1,  124,    1,   76,   76,   12,   47,   47,   11,  186,
  47,  186,  110,   47,  110,  103,   76,   47,  103,   76,  103,   87,
  76,   87,   70,  124,   76,   70,  124,   70,  148,  124,  148,   43,
 124,   43,   42,    7,  124,   42,    7,   42,  140,    7,  140,   90,
/* Character 'D' Y coordinate indices. */
   2,    2,   73,    2,   73,   73,    3,    2,   73,    3,   73,   16,
   3,    3,   16,    3,   16,   16,    3,   16,  180,    3,  180,  164,
 162,   73,    2,  162,    2,  127,   52,  162,  127,   52,  127,   72,
 148,   52,   72,  148,   72,  122,  137,  148,  122,  137,  122,  148,
 164,  137,  148,  164,  148,   18,    3,  164,   18,    3,   18,   19,
   3,   19,  185,  185,   65,    3,
/* Character 'E' Y coordinate indices. */
   2,    2,   73,    2,   73,   73,    3,    2,   73,    3,   73,   38,
  38,   38,   21,   38,   21,   21,    3,   38,   21,    3,   21,   16,
   3,    3,   16,   16,   16,    3,
/* Character 'F' Y coordinate indices. */
   3,    3,    2,    2,    2,   73,    2,   73,   73,    2,   73,  130,
 130,  130,   21,  130,   21,   21,    2,  130,   21,    2,   21,    3,
/* Character 'G' Y coordinate indices. */
  41,   41,  148,   41,  148,  187,   41,  187,    4,    4,   15,    7,
   4,    7,   60,   60,   59,  188,  188,   31,   76,   76,   12,  189,
  76,  189,   73,   73,  170,  169,   73,  169,   74,   73,   74,   32,
  76,   73,   32,   76,   32,  103,   76,  103,   32,   76,   32,   74,
 188,   76,   74,  188,   74,  181,  188,  181,  190,  188,  190,   17,
  60,  188,   17,   60,   17,   42,   60,   42,  134,    4,   60,  134,
   4,  134,  180,    4,  180,  184,    4,  184,   41,
/* Character 'H' Y coordinate indices. */
   3,    3,    2,    2,    2,   37,   37,    2,    2,   37,    2,    3,
   3,    3,   22,   37,    3,   22,   37,   37,   22,   37,   22,   22,
   2,   37,   22,    2,   22,    3,
/* Character 'I' Y coordinate indices. */
   3,    3,    2,    2,    2,    3,
/* Character 'J' Y coordinate indices. */
 115,   43,   18,  115,   18,   42,  115,   42,  167,  113,    2,    2,
 114,  113,    2,  114,    2,  137,   68,  114,  137,   68,  137,   68,
 167,   68,   68,  115,  167,   68,  115,   68,   15,   15,    7,  115,
/* Character 'K' Y coordinate indices. */
   3,    3,    2,    2,    2,  190,  190,    2,    2,  190,    2,  191,
 191,    3,    3,  191,    3,  148,  190,  191,  148,  190,  148,  192,
   2,  190,  192,    2,  192,    3,
/* Character 'L' Y coordinate indices. */
   3,    2,    2,    3,    2,   16,    3,    3,   16,   16,   16,    3,
/* Character 'M' Y coordinate indices. */
   3,    3,    2,    2,  119,   42,   42,  165,    2,    2,    3,    3,
   2,    3,    6,    2,    2,    6,   42,    2,    6,   42,    6,    3,
  42,    3,    3,    2,   42,    3,    2,    3,  110,    2,    2,  110,
   2,  110,    3,
/* Character 'N' Y coordinate indices. */
   3,    3,    2,    2,    2,   69,   69,    2,    2,   69,    2,    3,
   2,   69,    3,    2,    3,    3,    2,    3,   30,    2,   30,    3,
/* Character 'O' Y coordinate indices. */
  55,   49,   32,   32,   12,   48,   48,   31,  193,   48,  193,   59,
  59,  101,    7,   59,    7,  140,   59,  140,  139,   59,  139,  193,
  59,  193,  109,   48,   59,  109,   48,  109,  110,   48,  110,  103,
  32,   48,  103,   32,  103,   74,   55,   32,   74,   55,   74,  194,
  55,  194,  139,   55,  139,  140,   55,  140,    7,    7,  166,   55,
/* Character 'P' Y coordinate indices. */
   3,    3,    2,    2,    2,  195,    2,  195,   47,    2,   47,   87,
  87,  158,  188,  188,   63,   63,  188,   63,  196,  188,  196,  196,
 188,  196,  130,   87,  188,  130,   87,  130,  158,   87,  158,   85,
  87,   85,   34,    2,   87,   34,    2,   34,   73,    2,   73,   73,
   2,   73,  196,    2,  196,   63,    2,   63,    3,
/* Character 'Q' Y coordinate indices. */
 134,   65,  197,  134,  197,   60,   17,  134,   60,   17,   60,    7,
   7,  140,  147,   17,    7,  147,  147,  156,    8,  147,    8,  156,
  17,  147,  156,   17,  156,  190,   17,  190,  109,  139,  140,    7,
 139,    7,   60,  193,  139,   60,  193,   60,   55,  193,   55,  193,
  77,  193,  193,   77,  193,   31,  103,   77,   31,  103,   31,   76,
 103,   76,   12,  110,  103,   12,  110,   12,   48,  109,  110,   48,
  17,  109,   48,   17,   48,   31,   31,  190,   17,
/* Character 'R' Y coordinate indices. */
   3,    3,    2,    2,    2,  142,    2,  142,  142,    2,  142,   45,
 178,  142,    2,  178,    2,   29,   11,  178,   29,   11,   29,   32,
  75,   11,   32,   75,   32,   11,   38,   75,   11,   38,   11,   92,
  45,   38,   92,   45,   45,   92,   45,   92,   21,   45,   21,   63,
  45,   63,    8,    8,    3,    3,    8,    3,  100,    8,  100,  192,
   8,  192,  163,   45,    8,  163,   45,  163,  198,   45,  198,   66,
  45,   66,   66,    2,   45,   66,    2,   66,    3,
/* Character 'S' Y coordinate indices. */
   4,  136,   79,    4,   79,  100,    4,  100,  117,    4,  117,  134,
 163,  182,  196,  163,  196,   86,  163,   86,  122,  122,   73,  189,
 122,  189,   12,   12,  189,   34,   12,   34,  170,  170,  158,  110,
  12,  170,  110,   12,  110,  103,   12,  103,  120,  122,   12,  120,
 122,  120,   52,  122,   52,   36,  163,  122,   36,  125,  163,   36,
 125,   36,   37,  125,   37,  126,    8,  125,  126,    8,  126,   58,
 114,    8,   58,  114,   58,   43,   68,  114,   43,   68,   43,  117,
 134,   68,  117,  134,  117,   15,    4,  134,   15,    4,   15,    7,
   7,   15,    4,
/* Character 'T' Y coordinate indices. */
   3,    3,   73,   73,   73,    2,   73,    2,    2,    2,   73,   73,
  73,    2,   73,   73,   73,    3,
/* Character 'U' Y coordinate indices. */
  58,    2,    2,   58,    2,   58,   58,   58,  114,   58,  114,  199,
 199,    7,   54,  199,   54,  200,  200,   58,    2,  200,    2,    2,
 200,    2,   58,  200,   58,  146,  200,  146,  180,  199,  200,  180,
 199,  180,  134,  199,  134,  102,  199,  102,   58,
/* Character 'V' Y coordinate indices. */
   3,    2,    2,    3,    2,    8,    3,    8,  145,    3,    3,  145,
   3,  145,    8,    3,    8,    2,    2,    2,    3,
/* Character 'W' Y coordinate indices. */
   3,    2,    2,    3,    2,  192,    3,  192,    4,    3,    3,    4,
   3,    4,  136,    3,  136,    2,    2,   57,    4,    4,  201,    2,
   4,    2,    2,    4,    2,    3,    4,    3,    3,    2,    4,    3,
   2,    3,   35,    2,   35,   32,    2,    2,   32,    3,    2,   32,
  32,   35,    3,
/* Character 'X' Y coordinate indices. */
   3,    3,  155,  155,    2,    2,  155,    2,  122,  155,  122,   10,
   3,  155,   10,    3,   10,  202,    3,  202,    2,    2,    2,  126,
 126,    3,    3,  126,    3,  201,  126,  201,   58,    2,  126,   58,
   3,    2,   58,   58,  192,    3,
/* Character 'Y' Y coordinate indices. */
   3,    3,   58,   58,    2,    2,   58,    2,   70,    3,   58,   70,
   3,   70,   23,   23,  181,    2,   23,    2,    2,   23,    2,   58,
  23,   58,    3,
/* Character 'Z' Y coordinate indices. */
   3,    3,  147,  147,   35,   73,   73,   73,    2,   73,    2,    2,
 147,   73,    2,  147,    2,   73,  147,   73,  164,  147,  164,   16,
   3,  147,   16,   16,   16,    3,
/* Character '[' Y coordinate indices. */
   2,    2,  203,    2,  203,  203,  204,    2,  203,  204,  203,  205,
 204,  204,  205,  205,  205,  204,
/* Character '\' Y coordinate indices. */
   7,    7,   12,   12,   12,    7,
/* Character ']' Y coordinate indices. */
 204,  204,  205,  204,  205,  205,    2,  204,  205,    2,  205,  203,
   2,  203,  203,  203,    2,    2,
/* Character '^' Y coordinate indices. */
  32,   22,   22,   32,   22,   12,   32,   12,   12,   32,   12,   22,
  22,   22,   32,
/* Character '_' Y coordinate indices. */
 204,  204,  206,  206,  206,  204,
/* Character '`' Y coordinate indices. */
  98,   85,   85,   85,   98,   98,
/* Character 'a' Y coordinate indices. */
  61,   82,    7,   61,    7,  101,  101,  164,  144,  101,  144,  201,
 101,  201,  160,   56,  182,   83,  160,   56,   83,  160,   83,  137,
 160,  137,  119,  160,  119,  207,  101,  160,  207,  101,  207,  208,
 101,  208,  145,  101,  145,   20,   61,  101,   20,   61,   20,  145,
  61,  145,  208,   61,  208,  137,    3,   61,  137,    3,  137,   83,
   3,   83,  182,    3,  182,   57,  112,  190,  135,  112,  135,  209,
  75,  112,  209,   75,  209,  109,  128,   75,  109,  128,  109,   89,
 128,   89,  170,   57,  128,  170,    3,   57,  170,    3,  170,  129,
   3,  129,  108,    3,  108,  141,    3,  141,   18,    3,   18,   61,
  61,    3,    3,
/* Character 'b' Y coordinate indices. */
  67,    3,    3,   67,    3,    2,    2,    2,    5,    5,  130,   62,
   2,    5,   62,   67,    2,   62,   67,   62,  156,   67,  156,   20,
  75,  130,    5,   75,    5,   89,  130,   75,   89,  130,   89,  109,
  83,  130,  109,   83,  109,   75,   83,   75,  155,   19,   83,  155,
  19,  155,    9,   19,    9,   20,   20,   19,   20,   20,   20,    7,
  20,    7,   67,
/* Character 'c' Y coordinate indices. */
 117,  116,    0,  117,    0,  166,  117,  166,    7,   20,   83,  210,
  20,  210,  186,  186,   89,  211,  211,  187,   57,  211,   57,  128,
 211,  128,   75,  186,  211,   75,  186,   75,   38,  186,   38,   83,
  20,  186,   83,   20,   83,  133,    7,   20,  133,    7,  133,   20,
   7,   20,  117,
/* Character 'd' Y coordinate indices. */
   3,    3,   67,    3,   67,  133,    3,  133,  125,    3,  125,  130,
  20,  133,   67,   20,   67,    7,   19,   20,    7,   19,    7,   54,
  83,   19,   54,   83,   54,  102,  130,   83,  102,  130,  102,   83,
 130,   83,   45,   75,  130,   45,   75,   45,  186,   75,  186,   89,
 130,   75,   89,  130,   89,  109,    3,  130,  109,    3,  109,   75,
   3,   75,    2,    2,    2,    3,
/* Character 'e' Y coordinate indices. */
 147,   55,   69,  147,   69,   60,  147,   60,    7,    7,   20,  201,
  75,   89,   75,   75,   75,  108,  201,   75,  108,  201,  108,  118,
 201,  118,  118,  212,   75,   89,  212,   89,   75,  118,  212,   75,
 118,   75,   83,  201,  118,   83,  201,   83,   79,  201,   79,   79,
 201,   79,  133,    7,  201,  133,    7,  133,   20,    7,   20,  147,
/* Character 'f' Y coordinate indices. */
   3,    3,  123,  123,  123,   11,  123,   11,   11,    3,  123,   11,
   3,   11,   77,    3,   77,  152,    3,  152,  127,  127,   12,   98,
 127,   98,  203,  127,  203,  103,  127,  103,   32,  127,   32,   71,
 127,   71,   11,   11,   11,  123,   11,  123,  123,  127,   11,  123,
 127,  123,    3,
/* Character 'g' Y coordinate indices. */
 213,  214,  197,  213,  197,  215,  213,  215,  173,  140,  102,  216,
 134,  102,  140,  134,  140,    3,  102,  134,    3,  102,    3,  217,
   9,  102,  217,    9,  217,   62,  130,    9,   62,  130,   62,   45,
  75,  130,   45,   75,   45,  186,   75,  186,   89,  130,   75,   89,
 130,   89,   75,  216,  130,   75,   75,   11,   11,  216,   75,   11,
 140,  216,   11,  214,  140,   11,  214,   11,  140,  215,  214,  140,
 215,  140,   13,  173,  215,   13,  213,  173,   13,  213,   13,  174,
 174,   81,  213,
/* Character 'h' Y coordinate indices. */
   3,    3,    2,    2,    2,   75,   75,   89,  158,  158,   10,   21,
 158,   21,    3,  158,    3,    3,  158,    3,   21,  158,   21,   37,
 158,   37,  105,   75,  158,  105,   75,  105,  112,   75,  112,   23,
   2,   75,   23,    2,   23,  160,    2,  160,    3,
/* Character 'i' Y coordinate indices. */
 120,  120,    2,    2,    2,  120,    3,    3,   11,   11,   11,    3,
/* Character 'j' Y coordinate indices. */
 120,  120,    2,    2,    2,  120,   81,  218,  205,   81,  205,  206,
  81,  206,  219,   53,   11,   11,  219,   53,   11,  219,   11,   53,
  81,  219,   53,   53,  220,   81,
/* Character 'k' Y coordinate indices. */
   3,    3,    2,    2,    2,  118,  118,   11,   11,  118,   11,   21,
  21,    3,    3,   21,    3,   62,  118,   21,   62,  118,   62,   43,
   2,  118,   43,    2,   43,    3,
/* Character 'l' Y coordinate indices. */
   3,    3,    2,    2,    2,    3,
/* Character 'm' Y coordinate indices. */
   3,    3,   11,   11,   11,   10,    3,   11,   10,   10,  158,   89,
  10,   89,  158,   50,   89,  211,  211,  188,    3,  211,    3,    3,
 211,    3,   21,  211,   21,   78,  211,   78,   50,  211,   50,  105,
  50,  211,  105,   50,  105,  108,   50,  108,  221,  158,   50,  221,
 158,  221,    3,  158,    3,    3,  158,    3,   22,  158,   22,   37,
 158,   37,  105,   10,  158,  105,   10,  105,  112,   10,  112,  126,
  10,  126,    9,   10,    9,    3,
/* Character 'n' Y coordinate indices. */
   3,    3,   11,   11,   11,   10,    3,   11,   10,   10,   89,  109,
  10,  109,  222,  222,  210,   66,  222,   66,    3,  222,    3,    3,
 222,    3,   66,  222,   66,   92,  222,   92,   50,  222,   50,  105,
  10,  222,  105,   10,  105,  157,   10,  157,  223,   10,  223,    3,
/* Character 'o' Y coordinate indices. */
  20,   83,   36,   36,   89,  209,  209,    9,  133,  209,  133,  138,
 138,    7,   20,  138,   20,   19,  138,   19,   62,  209,  138,   62,
 209,   62,  130,  209,  130,   75,   36,  209,   75,   36,   75,  130,
  36,  130,   83,   20,   36,   83,   20,   83,   19,   20,   19,   20,
  20,    7,   20,
/* Character 'p' Y coordinate indices. */
 204,  204,   11,   11,   11,  177,   11,  177,  130,   11,  130,  201,
 204,   11,  201,    5,  130,  177,    5,  177,  109,   38,    5,  109,
  38,  109,   89,   38,   89,  186,   62,   38,  186,   62,  186,   45,
  19,   62,   45,   19,   45,   62,   19,   62,  102,   20,   19,  102,
  20,  102,   54,   20,   54,    7,  133,   20,    7,  133,    7,  224,
 201,  133,  224,  201,  224,  225,  201,  225,  204,
/* Character 'q' Y coordinate indices. */
 204,  204,  225,  225,  172,    7,  225,    7,   61,   61,   62,  210,
  61,  210,  186,  186,   89,  123,  123,  130,    5,  186,  123,    5,
 186,    5,   38,  186,   38,   83,   61,  186,   83,   61,   83,   19,
  61,   19,   20,  225,   61,   20,  225,   20,  133,  225,  133,  125,
 204,  225,  125,  125,  130,  123,  204,  125,  123,  204,  123,   11,
  11,   11,  204,
/* Character 'r' Y coordinate indices. */
   3,    3,   11,   11,   11,   50,    3,   11,   50,   50,  109,   89,
  50,   89,   70,   70,  157,   50,   50,   70,   50,   50,   50,   37,
  50,   37,  155,   50,  155,  226,   50,  226,    3,
/* Character 's' Y coordinate indices. */
 101,   69,   55,  101,   55,   68,  101,   68,   20,  227,   62,   91,
 116,  227,   91,  116,   91,   23,   23,   10,  228,   23,  228,   11,
  23,   11,   89,   89,  109,   88,   89,   88,   39,   39,  155,  112,
  89,   39,  112,   89,  112,   75,   89,   75,   50,   23,   89,   50,
  23,   50,  168,   23,  168,  190,  116,   23,  190,  116,  190,   22,
 116,   22,  198,  116,  198,   25,  139,  116,   25,  139,   25,  137,
 147,  139,  137,  147,  137,   69,  147,   69,  140,   20,  147,  140,
 101,   20,  140,  101,  140,  172,  172,    7,  101,
/* Character 't' Y coordinate indices. */
 134,  145,    3,  134,    3,  229,  134,  229,  172,  134,  172,  185,
 185,   69,  123,  123,  123,   11,  123,   11,   11,  185,  123,   11,
 185,   11,  103,  185,  103,  230,  185,  230,   11,   11,   11,  123,
  11,  123,  123,  185,   11,  123,  185,  123,  139,  185,  139,    4,
 185,    4,   16,  185,   16,  134,
/* Character 'u' Y coordinate indices. */
   3,    3,  134,  134,    7,   82,  134,   82,   44,   44,   90,    8,
  44,    8,   11,   44,   11,   11,   44,   11,  136,   44,  136,  208,
  44,  208,   16,   44,   16,   61,  134,   44,   61,  134,   61,   16,
 134,   16,  208,    3,  134,  208,    3,  208,  132,    3,  132,   11,
  11,   11,    3,
/* Character 'v' Y coordinate indices. */
   3,    3,   11,   11,   11,  119,   11,  119,   42,    3,   11,   42,
   3,   42,   43,    3,   43,   11,   11,   11,    3,
/* Character 'w' Y coordinate indices. */
   3,    3,   11,   11,   11,  165,   11,  165,  133,    3,   11,  133,
   3,  133,   18,    3,   18,   11,   11,   11,  165,   11,  165,  102,
 165,   11,   11,  102,  165,   11,  102,   11,    3,   11,  102,    3,
   3,    3,   91,    3,   91,   45,   11,    3,   45,   11,   45,    3,
/* Character 'x' Y coordinate indices. */
   3,    3,    9,    9,   11,   11,    9,   11,   45,    9,   45,   22,
   3,    9,   22,    3,   22,   45,    3,   45,   11,   11,   11,   25,
  25,    3,    3,   25,    3,   59,   25,   59,   43,   11,   25,   43,
  11,   43,    3,
/* Character 'y' Y coordinate indices. */
  81,  204,  219,   81,  219,  205,   81,  205,  215,   81,  215,   94,
   3,   11,   11,    3,   11,  165,    3,  165,    4,  231,    3,    4,
  94,  231,    4,    4,   18,   11,    4,   11,   11,   94,    4,   11,
  81,   94,   11,   81,   11,  229,   81,  229,  205,  205,  232,   81,
/* Character 'z' Y coordinate indices. */
   3,    3,  167,  123,   10,   10,  123,   10,   11,  123,   11,   11,
 167,  123,   11,  167,   11,    5,  167,    5,  114,  167,  114,  167,
   3,  167,  167,    3,  167,  134,  134,  134,    3,
/* Character '{' Y coordinate indices. */
 165,   56,   66,  211,   80,  111,  155,  211,  111,  155,  111,  230,
 155,  230,  233,  233,   12,   12,  233,   12,  152,  233,  152,  152,
 233,  152,   73,  155,  233,   73,  155,   73,   31,  155,   31,  168,
  66,  155,  168,  165,   66,  168,  165,  168,  118,  165,  118,   83,
 165,   83,  116,  116,  166,  234,  206,  206,   81,  235,  206,   81,
 235,   81,   81,  235,   81,  218,  234,  235,  218,  116,  234,  218,
 116,  218,  236,  116,  236,   13,  116,   13,   54,  116,   54,  139,
 116,  139,   17,  116,   17,  165,
/* Character '|' Y coordinate indices. */
  81,   81,   12,   12,   12,   81,
/* Character '}' Y coordinate indices. */
 149,   56,  165,  149,  165,   17,  149,   17,  139,  101,  237,   95,
 139,  101,   95,  139,   95,  175,  139,  175,  238,  149,  139,  238,
 238,   81,   81,  238,   81,  206,  238,  206,  206,  238,  206,  219,
 149,  238,  219,  239,  200,  119,  239,  119,   83,  219,  239,   83,
 149,  219,   83,  149,   83,  182,  149,  182,  151,  152,  152,   12,
  51,  152,   12,   51,   12,   12,   51,   12,   98,  240,   51,   98,
 151,  240,   98,  151,   98,   76,  151,   76,  161,  151,  161,  228,
 151,  228,  155,  151,  155,  149
};

/*
 * This is an offset from the start of the nice_triangle_x_index and
 * nice_triangle_y_index arrays. It gives the start of a glyph's first
 * triangle coordinate indices.
 */
static int nice_triangle_start[] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 18, 42, 138, 264, 366, 480, 492, 516, 540, 579,
609, 630, 636, 642, 648, 708, 729, 789, 873, 915, 975,
1059, 1086, 1191, 1281, 1293, 1320, 1335, 1347, 1362, 1425, 1608,
1647, 1752, 1812, 1878, 1908, 1932, 2013, 2043, 2049, 2085, 2115,
2127, 2166, 2190, 2250, 2307, 2388, 2469, 2568, 2586, 2631, 2652,
2703, 2745, 2772, 2802, 2820, 2826, 2844, 2859, 2865, 2871, 2982,
3045, 3096, 3162, 3222, 3273, 3360, 3405, 3417, 3447, 3477, 3483,
3561, 3609, 3660, 3729, 3792, 3825, 3918, 3972, 4023, 4044, 4092,
4131, 4179, 4212, 4302, 4308, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0
};

/*
 * This table gives the number of triangles in a glyph.
 */
static int nice_triangle_ntriangles[] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
6, 8, 32, 42, 34, 38, 4, 8, 8, 13, 10,
7, 2, 2, 2, 20, 7, 20, 28, 14, 20, 28,
9, 35, 30, 4, 9, 5, 4, 5, 21, 61, 13,
35, 20, 22, 10, 8, 27, 10, 2, 12, 10, 4,
13, 8, 20, 19, 27, 27, 33, 6, 15, 7, 17,
14, 9, 10, 6, 2, 6, 5, 2, 2, 37, 21,
17, 22, 20, 17, 29, 15, 4, 10, 10, 2, 26,
16, 17, 23, 21, 11, 31, 18, 17, 7, 16, 13,
16, 11, 30, 2, 30, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0
};

/*
 * This table gives the space required to display this character.
 */
static float nice_triangle_spacing[] = {
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.400, 0.278, 0.355, 0.556,
0.556, 0.889, 0.667, 0.191, 0.333, 0.333, 0.389, 0.584, 0.278,
0.333, 0.278, 0.278, 0.556, 0.556, 0.556, 0.556, 0.556, 0.556,
0.556, 0.556, 0.556, 0.556, 0.278, 0.278, 0.584, 0.584, 0.584,
0.556, 1.015, 0.667, 0.667, 0.722, 0.722, 0.667, 0.611, 0.778,
0.722, 0.278, 0.500, 0.667, 0.556, 0.833, 0.722, 0.778, 0.667,
0.778, 0.722, 0.667, 0.611, 0.722, 0.667, 0.944, 0.667, 0.667,
0.611, 0.278, 0.278, 0.278, 0.469, 0.556, 0.333, 0.556, 0.556,
0.500, 0.556, 0.556, 0.278, 0.556, 0.556, 0.222, 0.222, 0.500,
0.222, 0.833, 0.556, 0.556, 0.556, 0.556, 0.333, 0.500, 0.278,
0.556, 0.500, 0.722, 0.500, 0.500, 0.500, 0.334, 0.260, 0.334,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
0.000, 0.000, 0.000, 0.000
};


void
DrawCharacters(int nstr, char *str[],
               float scale, Vector origin, Vector up, Vector right)
{
    //
    // Now create the geometry for the string, one character at a time.
    //
    double char_base_x = 0.;
    double char_base_y = 0.;
    for (int k = 0 ; k < nstr ; k++)
    {
        int nchars = strlen(str[k]);
        for (int i = 0 ; i < nchars+1 ; i++)
        {
            char ch = ' ';
            if (i < nchars)
                ch = str[k][i];

            if (ch == '\n' ||
                     ((ch == '\\') && (i+1 < nchars) && (str[k][i+1] == 'n')))
            {
                char_base_x = 0.;
                char_base_y -= 1.;
                i += 1;
                continue;
            }
            if (ch == '\t' ||
                     ((ch == '\\') && (i+1 < nchars) && (str[k][i+1] == 't')))
            {
                double over_4 = char_base_x / 4.;
                if (((double)((int)over_4)) == over_4)
                {
                    // We have an even integer.
                    over_4 += 1;
                }
                else
                {
                    over_4 = ((int)over_4) + 1.;
                }
                char_base_x = 4.*over_4;
                i += 1;
                continue;
            }

            //
            // Each character is made up of multiple triangles.  Add the
            // triangles to the output one at a time.
            //
            int ntri = nice_triangle_ntriangles[(int)ch];
            unsigned char *xptr = 
                          &nice_triangle_x_index[(int)nice_triangle_start[(int)ch]];
            unsigned char *yptr = 
                          &nice_triangle_y_index[(int)nice_triangle_start[(int)ch]];
            for (int j = 0 ; j < ntri ; j++)
            {
                Vector pt0 = ((nice_font_x[xptr[3*j+0]] + char_base_x) *right +
                              (nice_font_y[yptr[3*j+0]] + char_base_y) *up)
                         * scale + origin;
                Vector pt1 = ((nice_font_x[xptr[3*j+1]] + char_base_x) *right +
                              (nice_font_y[yptr[3*j+1]] + char_base_y) *up)
                         * scale + origin;
                Vector pt2 = ((nice_font_x[xptr[3*j+2]] + char_base_x) *right +
                              (nice_font_y[yptr[3*j+2]] + char_base_y) *up)
                         * scale + origin;

                glVertex3f(pt0.x, pt0.y, pt0.z);
                glVertex3f(pt1.x, pt1.y, pt1.z);
                glVertex3f(pt2.x, pt2.y, pt2.z);
            }
            double scale_factor = 1.1;
            char_base_x += (scale_factor * nice_triangle_spacing[(int)ch]);
        }
    }
}


void
DrawCharacter(char letter,
              float scale, Vector origin, Vector up, Vector right)
{
    char word[2] = {0, 0};
    word[0] = letter;
    char *words[1] = {word};
    DrawCharacters(1, words, scale, origin, up, right);
}
