/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TriangulateRegularPointsAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Init utility for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TriangulateRegularPointsAttributes::Init()
{
    useXGridSpacing = false;
    xGridSpacing = 1;
    useYGridSpacing = false;
    yGridSpacing = 1;

    TriangulateRegularPointsAttributes::SelectAll();
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Copy utility for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TriangulateRegularPointsAttributes::Copy(const TriangulateRegularPointsAttributes &obj)
{
    useXGridSpacing = obj.useXGridSpacing;
    xGridSpacing = obj.xGridSpacing;
    useYGridSpacing = obj.useYGridSpacing;
    yGridSpacing = obj.yGridSpacing;

    TriangulateRegularPointsAttributes::SelectAll();
}

// Type map format string
const char *TriangulateRegularPointsAttributes::TypeMapFormatString = TRIANGULATEREGULARPOINTSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t TriangulateRegularPointsAttributes::TmfsStruct = {TRIANGULATEREGULARPOINTSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Default constructor for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes() : 
    AttributeSubject(TriangulateRegularPointsAttributes::TypeMapFormatString)
{
    TriangulateRegularPointsAttributes::Init();
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Constructor for the derived classes of TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TriangulateRegularPointsAttributes::Init();
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Copy constructor for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes(const TriangulateRegularPointsAttributes &obj) : 
    AttributeSubject(TriangulateRegularPointsAttributes::TypeMapFormatString)
{
    TriangulateRegularPointsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes::TriangulateRegularPointsAttributes(const TriangulateRegularPointsAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TriangulateRegularPointsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::~TriangulateRegularPointsAttributes
//
// Purpose: 
//   Destructor for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes::~TriangulateRegularPointsAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TriangulateRegularPointsAttributes& 
TriangulateRegularPointsAttributes::operator = (const TriangulateRegularPointsAttributes &obj)
{
    if (this == &obj) return *this;

    TriangulateRegularPointsAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TriangulateRegularPointsAttributes::operator == (const TriangulateRegularPointsAttributes &obj) const
{
    // Create the return value
    return ((useXGridSpacing == obj.useXGridSpacing) &&
            (xGridSpacing == obj.xGridSpacing) &&
            (useYGridSpacing == obj.useYGridSpacing) &&
            (yGridSpacing == obj.yGridSpacing));
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TriangulateRegularPointsAttributes::operator != (const TriangulateRegularPointsAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::TypeName
//
// Purpose: 
//   Type name method for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TriangulateRegularPointsAttributes::TypeName() const
{
    return "TriangulateRegularPointsAttributes";
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TriangulateRegularPointsAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TriangulateRegularPointsAttributes *tmp = (const TriangulateRegularPointsAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TriangulateRegularPointsAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TriangulateRegularPointsAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TriangulateRegularPointsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TriangulateRegularPointsAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TriangulateRegularPointsAttributes(*this);
    else
        retval = new TriangulateRegularPointsAttributes;

    return retval;
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TriangulateRegularPointsAttributes::SelectAll()
{
    Select(ID_useXGridSpacing, (void *)&useXGridSpacing);
    Select(ID_xGridSpacing,    (void *)&xGridSpacing);
    Select(ID_useYGridSpacing, (void *)&useYGridSpacing);
    Select(ID_yGridSpacing,    (void *)&yGridSpacing);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TriangulateRegularPointsAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TriangulateRegularPointsAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TriangulateRegularPointsAttributes.
    DataNode *node = new DataNode("TriangulateRegularPointsAttributes");

    if(completeSave || !FieldsEqual(ID_useXGridSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useXGridSpacing", useXGridSpacing));
    }

    if(completeSave || !FieldsEqual(ID_xGridSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xGridSpacing", xGridSpacing));
    }

    if(completeSave || !FieldsEqual(ID_useYGridSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useYGridSpacing", useYGridSpacing));
    }

    if(completeSave || !FieldsEqual(ID_yGridSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yGridSpacing", yGridSpacing));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TriangulateRegularPointsAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TriangulateRegularPointsAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useXGridSpacing")) != 0)
        SetUseXGridSpacing(node->AsBool());
    if((node = searchNode->GetNode("xGridSpacing")) != 0)
        SetXGridSpacing(node->AsDouble());
    if((node = searchNode->GetNode("useYGridSpacing")) != 0)
        SetUseYGridSpacing(node->AsBool());
    if((node = searchNode->GetNode("yGridSpacing")) != 0)
        SetYGridSpacing(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TriangulateRegularPointsAttributes::SetUseXGridSpacing(bool useXGridSpacing_)
{
    useXGridSpacing = useXGridSpacing_;
    Select(ID_useXGridSpacing, (void *)&useXGridSpacing);
}

void
TriangulateRegularPointsAttributes::SetXGridSpacing(double xGridSpacing_)
{
    xGridSpacing = xGridSpacing_;
    Select(ID_xGridSpacing, (void *)&xGridSpacing);
}

void
TriangulateRegularPointsAttributes::SetUseYGridSpacing(bool useYGridSpacing_)
{
    useYGridSpacing = useYGridSpacing_;
    Select(ID_useYGridSpacing, (void *)&useYGridSpacing);
}

void
TriangulateRegularPointsAttributes::SetYGridSpacing(double yGridSpacing_)
{
    yGridSpacing = yGridSpacing_;
    Select(ID_yGridSpacing, (void *)&yGridSpacing);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
TriangulateRegularPointsAttributes::GetUseXGridSpacing() const
{
    return useXGridSpacing;
}

double
TriangulateRegularPointsAttributes::GetXGridSpacing() const
{
    return xGridSpacing;
}

bool
TriangulateRegularPointsAttributes::GetUseYGridSpacing() const
{
    return useYGridSpacing;
}

double
TriangulateRegularPointsAttributes::GetYGridSpacing() const
{
    return yGridSpacing;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TriangulateRegularPointsAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useXGridSpacing: return "useXGridSpacing";
    case ID_xGridSpacing:    return "xGridSpacing";
    case ID_useYGridSpacing: return "useYGridSpacing";
    case ID_yGridSpacing:    return "yGridSpacing";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TriangulateRegularPointsAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useXGridSpacing: return FieldType_bool;
    case ID_xGridSpacing:    return FieldType_double;
    case ID_useYGridSpacing: return FieldType_bool;
    case ID_yGridSpacing:    return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TriangulateRegularPointsAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useXGridSpacing: return "bool";
    case ID_xGridSpacing:    return "double";
    case ID_useYGridSpacing: return "bool";
    case ID_yGridSpacing:    return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TriangulateRegularPointsAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TriangulateRegularPointsAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TriangulateRegularPointsAttributes &obj = *((const TriangulateRegularPointsAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useXGridSpacing:
        {  // new scope
        retval = (useXGridSpacing == obj.useXGridSpacing);
        }
        break;
    case ID_xGridSpacing:
        {  // new scope
        retval = (xGridSpacing == obj.xGridSpacing);
        }
        break;
    case ID_useYGridSpacing:
        {  // new scope
        retval = (useYGridSpacing == obj.useYGridSpacing);
        }
        break;
    case ID_yGridSpacing:
        {  // new scope
        retval = (yGridSpacing == obj.yGridSpacing);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

