/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySPHResampleAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySPHResampleAttributes
//
// Purpose: 
//   
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SPHResampleAttributes.
//
struct SPHResampleAttributesObject
{
    PyObject_HEAD
    SPHResampleAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSPHResampleAttributes(int);

std::string
PySPHResampleAttributes_ToString(const SPHResampleAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sminX = %g\n", prefix, atts->GetMinX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxX = %g\n", prefix, atts->GetMaxX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxnum = %d\n", prefix, atts->GetXnum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminY = %g\n", prefix, atts->GetMinY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxY = %g\n", prefix, atts->GetMaxY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%synum = %d\n", prefix, atts->GetYnum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminZ = %g\n", prefix, atts->GetMinZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxZ = %g\n", prefix, atts->GetMaxZ());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sznum = %d\n", prefix, atts->GetZnum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stensorSupportVariable = \"%s\"\n", prefix, atts->GetTensorSupportVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sweightVariable = \"%s\"\n", prefix, atts->GetWeightVariable().c_str());
    str += tmpStr;
    if(atts->GetRK())
        SNPRINTF(tmpStr, 1000, "%sRK = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sRK = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SPHResampleAttributes_Notify(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMinX(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the minX in the object.
    obj->data->SetMinX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMinX(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMinX()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMaxX(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the maxX in the object.
    obj->data->SetMaxX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMaxX(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMaxX()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetXnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xnum in the object.
    obj->data->SetXnum((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetXnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXnum()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMinY(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the minY in the object.
    obj->data->SetMinY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMinY(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMinY()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMaxY(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the maxY in the object.
    obj->data->SetMaxY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMaxY(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMaxY()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetYnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ynum in the object.
    obj->data->SetYnum((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetYnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYnum()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMinZ(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the minZ in the object.
    obj->data->SetMinZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMinZ(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMinZ()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetMaxZ(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the maxZ in the object.
    obj->data->SetMaxZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetMaxZ(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMaxZ()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetZnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the znum in the object.
    obj->data->SetZnum((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetZnum(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZnum()));
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetTensorSupportVariable(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the tensorSupportVariable in the object.
    obj->data->SetTensorSupportVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetTensorSupportVariable(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTensorSupportVariable().c_str());
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetWeightVariable(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the weightVariable in the object.
    obj->data->SetWeightVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetWeightVariable(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetWeightVariable().c_str());
    return retval;
}

/*static*/ PyObject *
SPHResampleAttributes_SetRK(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the RK in the object.
    obj->data->SetRK(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SPHResampleAttributes_GetRK(PyObject *self, PyObject *args)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRK()?1L:0L);
    return retval;
}



PyMethodDef PySPHResampleAttributes_methods[SPHRESAMPLEATTRIBUTES_NMETH] = {
    {"Notify", SPHResampleAttributes_Notify, METH_VARARGS},
    {"SetMinX", SPHResampleAttributes_SetMinX, METH_VARARGS},
    {"GetMinX", SPHResampleAttributes_GetMinX, METH_VARARGS},
    {"SetMaxX", SPHResampleAttributes_SetMaxX, METH_VARARGS},
    {"GetMaxX", SPHResampleAttributes_GetMaxX, METH_VARARGS},
    {"SetXnum", SPHResampleAttributes_SetXnum, METH_VARARGS},
    {"GetXnum", SPHResampleAttributes_GetXnum, METH_VARARGS},
    {"SetMinY", SPHResampleAttributes_SetMinY, METH_VARARGS},
    {"GetMinY", SPHResampleAttributes_GetMinY, METH_VARARGS},
    {"SetMaxY", SPHResampleAttributes_SetMaxY, METH_VARARGS},
    {"GetMaxY", SPHResampleAttributes_GetMaxY, METH_VARARGS},
    {"SetYnum", SPHResampleAttributes_SetYnum, METH_VARARGS},
    {"GetYnum", SPHResampleAttributes_GetYnum, METH_VARARGS},
    {"SetMinZ", SPHResampleAttributes_SetMinZ, METH_VARARGS},
    {"GetMinZ", SPHResampleAttributes_GetMinZ, METH_VARARGS},
    {"SetMaxZ", SPHResampleAttributes_SetMaxZ, METH_VARARGS},
    {"GetMaxZ", SPHResampleAttributes_GetMaxZ, METH_VARARGS},
    {"SetZnum", SPHResampleAttributes_SetZnum, METH_VARARGS},
    {"GetZnum", SPHResampleAttributes_GetZnum, METH_VARARGS},
    {"SetTensorSupportVariable", SPHResampleAttributes_SetTensorSupportVariable, METH_VARARGS},
    {"GetTensorSupportVariable", SPHResampleAttributes_GetTensorSupportVariable, METH_VARARGS},
    {"SetWeightVariable", SPHResampleAttributes_SetWeightVariable, METH_VARARGS},
    {"GetWeightVariable", SPHResampleAttributes_GetWeightVariable, METH_VARARGS},
    {"SetRK", SPHResampleAttributes_SetRK, METH_VARARGS},
    {"GetRK", SPHResampleAttributes_GetRK, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SPHResampleAttributes_dealloc(PyObject *v)
{
   SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SPHResampleAttributes_compare(PyObject *v, PyObject *w)
{
    SPHResampleAttributes *a = ((SPHResampleAttributesObject *)v)->data;
    SPHResampleAttributes *b = ((SPHResampleAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySPHResampleAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "minX") == 0)
        return SPHResampleAttributes_GetMinX(self, NULL);
    if(strcmp(name, "maxX") == 0)
        return SPHResampleAttributes_GetMaxX(self, NULL);
    if(strcmp(name, "xnum") == 0)
        return SPHResampleAttributes_GetXnum(self, NULL);
    if(strcmp(name, "minY") == 0)
        return SPHResampleAttributes_GetMinY(self, NULL);
    if(strcmp(name, "maxY") == 0)
        return SPHResampleAttributes_GetMaxY(self, NULL);
    if(strcmp(name, "ynum") == 0)
        return SPHResampleAttributes_GetYnum(self, NULL);
    if(strcmp(name, "minZ") == 0)
        return SPHResampleAttributes_GetMinZ(self, NULL);
    if(strcmp(name, "maxZ") == 0)
        return SPHResampleAttributes_GetMaxZ(self, NULL);
    if(strcmp(name, "znum") == 0)
        return SPHResampleAttributes_GetZnum(self, NULL);
    if(strcmp(name, "tensorSupportVariable") == 0)
        return SPHResampleAttributes_GetTensorSupportVariable(self, NULL);
    if(strcmp(name, "weightVariable") == 0)
        return SPHResampleAttributes_GetWeightVariable(self, NULL);
    if(strcmp(name, "RK") == 0)
        return SPHResampleAttributes_GetRK(self, NULL);

    return Py_FindMethod(PySPHResampleAttributes_methods, self, name);
}

int
PySPHResampleAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "minX") == 0)
        obj = SPHResampleAttributes_SetMinX(self, tuple);
    else if(strcmp(name, "maxX") == 0)
        obj = SPHResampleAttributes_SetMaxX(self, tuple);
    else if(strcmp(name, "xnum") == 0)
        obj = SPHResampleAttributes_SetXnum(self, tuple);
    else if(strcmp(name, "minY") == 0)
        obj = SPHResampleAttributes_SetMinY(self, tuple);
    else if(strcmp(name, "maxY") == 0)
        obj = SPHResampleAttributes_SetMaxY(self, tuple);
    else if(strcmp(name, "ynum") == 0)
        obj = SPHResampleAttributes_SetYnum(self, tuple);
    else if(strcmp(name, "minZ") == 0)
        obj = SPHResampleAttributes_SetMinZ(self, tuple);
    else if(strcmp(name, "maxZ") == 0)
        obj = SPHResampleAttributes_SetMaxZ(self, tuple);
    else if(strcmp(name, "znum") == 0)
        obj = SPHResampleAttributes_SetZnum(self, tuple);
    else if(strcmp(name, "tensorSupportVariable") == 0)
        obj = SPHResampleAttributes_SetTensorSupportVariable(self, tuple);
    else if(strcmp(name, "weightVariable") == 0)
        obj = SPHResampleAttributes_SetWeightVariable(self, tuple);
    else if(strcmp(name, "RK") == 0)
        obj = SPHResampleAttributes_SetRK(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SPHResampleAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)v;
    fprintf(fp, "%s", PySPHResampleAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SPHResampleAttributes_str(PyObject *v)
{
    SPHResampleAttributesObject *obj = (SPHResampleAttributesObject *)v;
    return PyString_FromString(PySPHResampleAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SPHResampleAttributes_Purpose = "";
#else
static char *SPHResampleAttributes_Purpose = "";
#endif

//
// The type description structure
//
static PyTypeObject SPHResampleAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SPHResampleAttributes",                    // tp_name
    sizeof(SPHResampleAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SPHResampleAttributes_dealloc,  // tp_dealloc
    (printfunc)SPHResampleAttributes_print,     // tp_print
    (getattrfunc)PySPHResampleAttributes_getattr, // tp_getattr
    (setattrfunc)PySPHResampleAttributes_setattr, // tp_setattr
    (cmpfunc)SPHResampleAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SPHResampleAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SPHResampleAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SPHResampleAttributes *defaultAtts = 0;
static SPHResampleAttributes *currentAtts = 0;

static PyObject *
NewSPHResampleAttributes(int useCurrent)
{
    SPHResampleAttributesObject *newObject;
    newObject = PyObject_NEW(SPHResampleAttributesObject, &SPHResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SPHResampleAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SPHResampleAttributes(*defaultAtts);
    else
        newObject->data = new SPHResampleAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSPHResampleAttributes(const SPHResampleAttributes *attr)
{
    SPHResampleAttributesObject *newObject;
    newObject = PyObject_NEW(SPHResampleAttributesObject, &SPHResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SPHResampleAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SPHResampleAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSPHResampleAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SPHResampleAttributesMethods[] = {
    {"SPHResampleAttributes", SPHResampleAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SPHResampleAttributesObserver = 0;

std::string
PySPHResampleAttributes_GetLogString()
{
    std::string s("SPHResampleAtts = SPHResampleAttributes()\n");
    if(currentAtts != 0)
        s += PySPHResampleAttributes_ToString(currentAtts, "SPHResampleAtts.");
    return s;
}

static void
PySPHResampleAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SPHResampleAtts = SPHResampleAttributes()\n");
        s += PySPHResampleAttributes_ToString(currentAtts, "SPHResampleAtts.");
        cb(s);
    }
}

void
PySPHResampleAttributes_StartUp(SPHResampleAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySPHResampleAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SPHResampleAttributesObserver == 0)
    {
        SPHResampleAttributesObserver = new ObserverToCallback(subj,
            PySPHResampleAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySPHResampleAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SPHResampleAttributesObserver;
    SPHResampleAttributesObserver = 0;
}

PyMethodDef *
PySPHResampleAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SPHResampleAttributesMethods;
}

bool
PySPHResampleAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SPHResampleAttributesType);
}

SPHResampleAttributes *
PySPHResampleAttributes_FromPyObject(PyObject *obj)
{
    SPHResampleAttributesObject *obj2 = (SPHResampleAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySPHResampleAttributes_New()
{
    return NewSPHResampleAttributes(0);
}

PyObject *
PySPHResampleAttributes_Wrap(const SPHResampleAttributes *attr)
{
    return WrapSPHResampleAttributes(attr);
}

void
PySPHResampleAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SPHResampleAttributesObject *obj2 = (SPHResampleAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySPHResampleAttributes_SetDefaults(const SPHResampleAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SPHResampleAttributes(*atts);
}

