/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyModelFitAtts.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyModelFitAtts
//
// Purpose: 
//   This file contains attributes for the ModelFit operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ModelFitAtts.
//
struct ModelFitAttsObject
{
    PyObject_HEAD
    ModelFitAtts *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewModelFitAtts(int);

std::string
PyModelFitAtts_ToString(const ModelFitAtts *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &Vars = atts->GetVars();
        SNPRINTF(tmpStr, 1000, "%sVars = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < Vars.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", Vars[i].c_str());
            str += tmpStr;
            if(i < Vars.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &numVars = atts->GetNumVars();
        SNPRINTF(tmpStr, 1000, "%snumVars = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numVars.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numVars[i]);
            str += tmpStr;
            if(i < numVars.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &Tuples = atts->GetTuples();
        SNPRINTF(tmpStr, 1000, "%sTuples = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < Tuples.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", Tuples[i]);
            str += tmpStr;
            if(i < Tuples.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const unsignedCharVector &StatTuples = atts->GetStatTuples();
        SNPRINTF(tmpStr, 1000, "%sStatTuples = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < StatTuples.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(StatTuples[i]));
            str += tmpStr;
            if(i < StatTuples.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &numTups = atts->GetNumTups();
        SNPRINTF(tmpStr, 1000, "%snumTups = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numTups.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numTups[i]);
            str += tmpStr;
            if(i < numTups.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &thold = atts->GetThold();
        SNPRINTF(tmpStr, 1000, "%sthold = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < thold.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", thold[i]);
            str += tmpStr;
            if(i < thold.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &selectionType = atts->GetSelectionType();
        SNPRINTF(tmpStr, 1000, "%sselectionType = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < selectionType.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", selectionType[i]);
            str += tmpStr;
            if(i < selectionType.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &distanceType = atts->GetDistanceType();
        SNPRINTF(tmpStr, 1000, "%sdistanceType = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < distanceType.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", distanceType[i]);
            str += tmpStr;
            if(i < distanceType.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &inputSpace = atts->GetInputSpace();
        SNPRINTF(tmpStr, 1000, "%sinputSpace = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < inputSpace.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", inputSpace[i]);
            str += tmpStr;
            if(i < inputSpace.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &modelNames = atts->GetModelNames();
        SNPRINTF(tmpStr, 1000, "%smodelNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < modelNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", modelNames[i].c_str());
            str += tmpStr;
            if(i < modelNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &modelNums = atts->GetModelNums();
        SNPRINTF(tmpStr, 1000, "%smodelNums = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < modelNums.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", modelNums[i]);
            str += tmpStr;
            if(i < modelNums.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ModelFitAtts_Notify(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_SetVars(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    stringVector  &vec = obj->data->GetVars();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the Vars in the object as modified.
    obj->data->SelectVars();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetVars(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the Vars.
    const stringVector &Vars = obj->data->GetVars();
    PyObject *retval = PyTuple_New(Vars.size());
    for(size_t i = 0; i < Vars.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(Vars[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetNumVars(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetNumVars();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numVars in the object as modified.
    obj->data->SelectNumVars();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetNumVars(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the numVars.
    const intVector &numVars = obj->data->GetNumVars();
    PyObject *retval = PyTuple_New(numVars.size());
    for(size_t i = 0; i < numVars.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numVars[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetTuples(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    doubleVector  &vec = obj->data->GetTuples();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the Tuples in the object as modified.
    obj->data->SelectTuples();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetTuples(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the Tuples.
    const doubleVector &Tuples = obj->data->GetTuples();
    PyObject *retval = PyTuple_New(Tuples.size());
    for(size_t i = 0; i < Tuples.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(Tuples[i]));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetStatTuples(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    unsignedCharVector  &vec = obj->data->GetStatTuples();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the StatTuples in the object as modified.
    obj->data->SelectStatTuples();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetStatTuples(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the StatTuples.
    const unsignedCharVector &StatTuples = obj->data->GetStatTuples();
    PyObject *retval = PyTuple_New(StatTuples.size());
    for(size_t i = 0; i < StatTuples.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(StatTuples[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetNumTups(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetNumTups();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numTups in the object as modified.
    obj->data->SelectNumTups();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetNumTups(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the numTups.
    const intVector &numTups = obj->data->GetNumTups();
    PyObject *retval = PyTuple_New(numTups.size());
    for(size_t i = 0; i < numTups.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numTups[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetThold(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    doubleVector  &vec = obj->data->GetThold();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the thold in the object as modified.
    obj->data->SelectThold();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetThold(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the thold.
    const doubleVector &thold = obj->data->GetThold();
    PyObject *retval = PyTuple_New(thold.size());
    for(size_t i = 0; i < thold.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(thold[i]));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetSelectionType(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetSelectionType();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the selectionType in the object as modified.
    obj->data->SelectSelectionType();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetSelectionType(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the selectionType.
    const intVector &selectionType = obj->data->GetSelectionType();
    PyObject *retval = PyTuple_New(selectionType.size());
    for(size_t i = 0; i < selectionType.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(selectionType[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetDistanceType(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetDistanceType();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the distanceType in the object as modified.
    obj->data->SelectDistanceType();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetDistanceType(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the distanceType.
    const intVector &distanceType = obj->data->GetDistanceType();
    PyObject *retval = PyTuple_New(distanceType.size());
    for(size_t i = 0; i < distanceType.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(distanceType[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetInputSpace(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetInputSpace();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the inputSpace in the object as modified.
    obj->data->SelectInputSpace();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetInputSpace(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the inputSpace.
    const intVector &inputSpace = obj->data->GetInputSpace();
    PyObject *retval = PyTuple_New(inputSpace.size());
    for(size_t i = 0; i < inputSpace.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(inputSpace[i])));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetModelNames(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    stringVector  &vec = obj->data->GetModelNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the modelNames in the object as modified.
    obj->data->SelectModelNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetModelNames(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the modelNames.
    const stringVector &modelNames = obj->data->GetModelNames();
    PyObject *retval = PyTuple_New(modelNames.size());
    for(size_t i = 0; i < modelNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(modelNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ModelFitAtts_SetModelNums(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;

    intVector  &vec = obj->data->GetModelNums();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the modelNums in the object as modified.
    obj->data->SelectModelNums();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ModelFitAtts_GetModelNums(PyObject *self, PyObject *args)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)self;
    // Allocate a tuple the with enough entries to hold the modelNums.
    const intVector &modelNums = obj->data->GetModelNums();
    PyObject *retval = PyTuple_New(modelNums.size());
    for(size_t i = 0; i < modelNums.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(modelNums[i])));
    return retval;
}



PyMethodDef PyModelFitAtts_methods[MODELFITATTS_NMETH] = {
    {"Notify", ModelFitAtts_Notify, METH_VARARGS},
    {"SetVars", ModelFitAtts_SetVars, METH_VARARGS},
    {"GetVars", ModelFitAtts_GetVars, METH_VARARGS},
    {"SetNumVars", ModelFitAtts_SetNumVars, METH_VARARGS},
    {"GetNumVars", ModelFitAtts_GetNumVars, METH_VARARGS},
    {"SetTuples", ModelFitAtts_SetTuples, METH_VARARGS},
    {"GetTuples", ModelFitAtts_GetTuples, METH_VARARGS},
    {"SetStatTuples", ModelFitAtts_SetStatTuples, METH_VARARGS},
    {"GetStatTuples", ModelFitAtts_GetStatTuples, METH_VARARGS},
    {"SetNumTups", ModelFitAtts_SetNumTups, METH_VARARGS},
    {"GetNumTups", ModelFitAtts_GetNumTups, METH_VARARGS},
    {"SetThold", ModelFitAtts_SetThold, METH_VARARGS},
    {"GetThold", ModelFitAtts_GetThold, METH_VARARGS},
    {"SetSelectionType", ModelFitAtts_SetSelectionType, METH_VARARGS},
    {"GetSelectionType", ModelFitAtts_GetSelectionType, METH_VARARGS},
    {"SetDistanceType", ModelFitAtts_SetDistanceType, METH_VARARGS},
    {"GetDistanceType", ModelFitAtts_GetDistanceType, METH_VARARGS},
    {"SetInputSpace", ModelFitAtts_SetInputSpace, METH_VARARGS},
    {"GetInputSpace", ModelFitAtts_GetInputSpace, METH_VARARGS},
    {"SetModelNames", ModelFitAtts_SetModelNames, METH_VARARGS},
    {"GetModelNames", ModelFitAtts_GetModelNames, METH_VARARGS},
    {"SetModelNums", ModelFitAtts_SetModelNums, METH_VARARGS},
    {"GetModelNums", ModelFitAtts_GetModelNums, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ModelFitAtts_dealloc(PyObject *v)
{
   ModelFitAttsObject *obj = (ModelFitAttsObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ModelFitAtts_compare(PyObject *v, PyObject *w)
{
    ModelFitAtts *a = ((ModelFitAttsObject *)v)->data;
    ModelFitAtts *b = ((ModelFitAttsObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyModelFitAtts_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "Vars") == 0)
        return ModelFitAtts_GetVars(self, NULL);
    if(strcmp(name, "numVars") == 0)
        return ModelFitAtts_GetNumVars(self, NULL);
    if(strcmp(name, "Tuples") == 0)
        return ModelFitAtts_GetTuples(self, NULL);
    if(strcmp(name, "StatTuples") == 0)
        return ModelFitAtts_GetStatTuples(self, NULL);
    if(strcmp(name, "numTups") == 0)
        return ModelFitAtts_GetNumTups(self, NULL);
    if(strcmp(name, "thold") == 0)
        return ModelFitAtts_GetThold(self, NULL);
    if(strcmp(name, "selectionType") == 0)
        return ModelFitAtts_GetSelectionType(self, NULL);
    if(strcmp(name, "distanceType") == 0)
        return ModelFitAtts_GetDistanceType(self, NULL);
    if(strcmp(name, "inputSpace") == 0)
        return ModelFitAtts_GetInputSpace(self, NULL);
    if(strcmp(name, "modelNames") == 0)
        return ModelFitAtts_GetModelNames(self, NULL);
    if(strcmp(name, "modelNums") == 0)
        return ModelFitAtts_GetModelNums(self, NULL);

    return Py_FindMethod(PyModelFitAtts_methods, self, name);
}

int
PyModelFitAtts_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "Vars") == 0)
        obj = ModelFitAtts_SetVars(self, tuple);
    else if(strcmp(name, "numVars") == 0)
        obj = ModelFitAtts_SetNumVars(self, tuple);
    else if(strcmp(name, "Tuples") == 0)
        obj = ModelFitAtts_SetTuples(self, tuple);
    else if(strcmp(name, "StatTuples") == 0)
        obj = ModelFitAtts_SetStatTuples(self, tuple);
    else if(strcmp(name, "numTups") == 0)
        obj = ModelFitAtts_SetNumTups(self, tuple);
    else if(strcmp(name, "thold") == 0)
        obj = ModelFitAtts_SetThold(self, tuple);
    else if(strcmp(name, "selectionType") == 0)
        obj = ModelFitAtts_SetSelectionType(self, tuple);
    else if(strcmp(name, "distanceType") == 0)
        obj = ModelFitAtts_SetDistanceType(self, tuple);
    else if(strcmp(name, "inputSpace") == 0)
        obj = ModelFitAtts_SetInputSpace(self, tuple);
    else if(strcmp(name, "modelNames") == 0)
        obj = ModelFitAtts_SetModelNames(self, tuple);
    else if(strcmp(name, "modelNums") == 0)
        obj = ModelFitAtts_SetModelNums(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ModelFitAtts_print(PyObject *v, FILE *fp, int flags)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)v;
    fprintf(fp, "%s", PyModelFitAtts_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ModelFitAtts_str(PyObject *v)
{
    ModelFitAttsObject *obj = (ModelFitAttsObject *)v;
    return PyString_FromString(PyModelFitAtts_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ModelFitAtts_Purpose = "This file contains attributes for the ModelFit operator.";
#else
static char *ModelFitAtts_Purpose = "This file contains attributes for the ModelFit operator.";
#endif

//
// The type description structure
//
static PyTypeObject ModelFitAttsType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ModelFitAtts",                    // tp_name
    sizeof(ModelFitAttsObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ModelFitAtts_dealloc,  // tp_dealloc
    (printfunc)ModelFitAtts_print,     // tp_print
    (getattrfunc)PyModelFitAtts_getattr, // tp_getattr
    (setattrfunc)PyModelFitAtts_setattr, // tp_setattr
    (cmpfunc)ModelFitAtts_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ModelFitAtts_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ModelFitAtts_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ModelFitAtts *defaultAtts = 0;
static ModelFitAtts *currentAtts = 0;

static PyObject *
NewModelFitAtts(int useCurrent)
{
    ModelFitAttsObject *newObject;
    newObject = PyObject_NEW(ModelFitAttsObject, &ModelFitAttsType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ModelFitAtts(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ModelFitAtts(*defaultAtts);
    else
        newObject->data = new ModelFitAtts;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapModelFitAtts(const ModelFitAtts *attr)
{
    ModelFitAttsObject *newObject;
    newObject = PyObject_NEW(ModelFitAttsObject, &ModelFitAttsType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ModelFitAtts *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ModelFitAtts_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewModelFitAtts(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ModelFitAttsMethods[] = {
    {"ModelFitAtts", ModelFitAtts_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ModelFitAttsObserver = 0;

std::string
PyModelFitAtts_GetLogString()
{
    std::string s("ModelFitAtts = ModelFitAtts()\n");
    if(currentAtts != 0)
        s += PyModelFitAtts_ToString(currentAtts, "ModelFitAtts.");
    return s;
}

static void
PyModelFitAtts_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ModelFitAtts = ModelFitAtts()\n");
        s += PyModelFitAtts_ToString(currentAtts, "ModelFitAtts.");
        cb(s);
    }
}

void
PyModelFitAtts_StartUp(ModelFitAtts *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyModelFitAtts_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ModelFitAttsObserver == 0)
    {
        ModelFitAttsObserver = new ObserverToCallback(subj,
            PyModelFitAtts_CallLogRoutine, (void *)data);
    }

}

void
PyModelFitAtts_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ModelFitAttsObserver;
    ModelFitAttsObserver = 0;
}

PyMethodDef *
PyModelFitAtts_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ModelFitAttsMethods;
}

bool
PyModelFitAtts_Check(PyObject *obj)
{
    return (obj->ob_type == &ModelFitAttsType);
}

ModelFitAtts *
PyModelFitAtts_FromPyObject(PyObject *obj)
{
    ModelFitAttsObject *obj2 = (ModelFitAttsObject *)obj;
    return obj2->data;
}

PyObject *
PyModelFitAtts_New()
{
    return NewModelFitAtts(0);
}

PyObject *
PyModelFitAtts_Wrap(const ModelFitAtts *attr)
{
    return WrapModelFitAtts(attr);
}

void
PyModelFitAtts_SetParent(PyObject *obj, PyObject *parent)
{
    ModelFitAttsObject *obj2 = (ModelFitAttsObject *)obj;
    obj2->parent = parent;
}

void
PyModelFitAtts_SetDefaults(const ModelFitAtts *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ModelFitAtts(*atts);
}

