/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisLineSurfaceWindow.h"

#include <LineSurfaceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisLineSurfaceWindow::QvisLineSurfaceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSurfaceWindow::QvisLineSurfaceWindow(const int type,
                         LineSurfaceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::~QvisLineSurfaceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSurfaceWindow::~QvisLineSurfaceWindow()
{
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    startTimeLabel = new QLabel(tr("Index of first time slice"), central);
    mainLayout->addWidget(startTimeLabel,0,0);
    startTime = new QLineEdit(central);
    connect(startTime, SIGNAL(returnPressed()),
            this, SLOT(startTimeProcessText()));
    mainLayout->addWidget(startTime, 0,1);

    endTimeLabel = new QLabel(tr("Index of last time slice"), central);
    mainLayout->addWidget(endTimeLabel,1,0);
    endTime = new QLineEdit(central);
    connect(endTime, SIGNAL(returnPressed()),
            this, SLOT(endTimeProcessText()));
    mainLayout->addWidget(endTime, 1,1);

    strideLabel = new QLabel(tr("Stride through time slices"), central);
    mainLayout->addWidget(strideLabel,2,0);
    stride = new QLineEdit(central);
    connect(stride, SIGNAL(returnPressed()),
            this, SLOT(strideProcessText()));
    mainLayout->addWidget(stride, 2,1);

    point1Label = new QLabel(tr("Point 1"), central);
    mainLayout->addWidget(point1Label,3,0);
    point1 = new QLineEdit(central);
    connect(point1, SIGNAL(returnPressed()),
            this, SLOT(point1ProcessText()));
    mainLayout->addWidget(point1, 3,1);

    point2Label = new QLabel(tr("Point 2"), central);
    mainLayout->addWidget(point2Label,4,0);
    point2 = new QLineEdit(central);
    connect(point2, SIGNAL(returnPressed()),
            this, SLOT(point2ProcessText()));
    mainLayout->addWidget(point2, 4,1);

}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case LineSurfaceAttributes::ID_startTime:
            startTime->setText(IntToQString(atts->GetStartTime()));
            break;
          case LineSurfaceAttributes::ID_endTime:
            endTime->setText(IntToQString(atts->GetEndTime()));
            break;
          case LineSurfaceAttributes::ID_stride:
            stride->setText(IntToQString(atts->GetStride()));
            break;
          case LineSurfaceAttributes::ID_point1:
            point1->setText(DoublesToQString(atts->GetPoint1(), 3));
            break;
          case LineSurfaceAttributes::ID_point2:
            point2->setText(DoublesToQString(atts->GetPoint2(), 3));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisLineSurfaceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSurfaceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do startTime
    if(which_widget == LineSurfaceAttributes::ID_startTime || doAll)
    {
        int val;
        if(LineEditGetInt(startTime, val))
            atts->SetStartTime(val);
        else
        {
            ResettingError(tr("Index of first time slice"),
                IntToQString(atts->GetStartTime()));
            atts->SetStartTime(atts->GetStartTime());
        }
    }

    // Do endTime
    if(which_widget == LineSurfaceAttributes::ID_endTime || doAll)
    {
        int val;
        if(LineEditGetInt(endTime, val))
            atts->SetEndTime(val);
        else
        {
            ResettingError(tr("Index of last time slice"),
                IntToQString(atts->GetEndTime()));
            atts->SetEndTime(atts->GetEndTime());
        }
    }

    // Do stride
    if(which_widget == LineSurfaceAttributes::ID_stride || doAll)
    {
        int val;
        if(LineEditGetInt(stride, val))
            atts->SetStride(val);
        else
        {
            ResettingError(tr("Stride through time slices"),
                IntToQString(atts->GetStride()));
            atts->SetStride(atts->GetStride());
        }
    }

    // Do point1
    if(which_widget == LineSurfaceAttributes::ID_point1 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point1, val, 3))
            atts->SetPoint1(val);
        else
        {
            ResettingError(tr("Point 1"),
                DoublesToQString(atts->GetPoint1(),3));
            atts->SetPoint1(atts->GetPoint1());
        }
    }

    // Do point2
    if(which_widget == LineSurfaceAttributes::ID_point2 || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(point2, val, 3))
            atts->SetPoint2(val);
        else
        {
            ResettingError(tr("Point 2"),
                DoublesToQString(atts->GetPoint2(),3));
            atts->SetPoint2(atts->GetPoint2());
        }
    }

}


//
// Qt Slot functions
//


void
QvisLineSurfaceWindow::startTimeProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_startTime);
    Apply();
}


void
QvisLineSurfaceWindow::endTimeProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_endTime);
    Apply();
}


void
QvisLineSurfaceWindow::strideProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_stride);
    Apply();
}


void
QvisLineSurfaceWindow::point1ProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_point1);
    Apply();
}


void
QvisLineSurfaceWindow::point2ProcessText()
{
    GetCurrentValues(LineSurfaceAttributes::ID_point2);
    Apply();
}


