/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisLineSamplerWindow.h"

#include "LineSamplerCartesianXLayout.xpm"
#include "LineSamplerCartesianZLayout.xpm"
#include "LineSamplerCartesianConfLayout.xpm"
#include "LineSamplerCylindricalRLayout.xpm"
#include "LineSamplerCylindricalZLayout.xpm"
#include "LineSamplerCylindricalConfLayout.xpm"
#include "LineSamplerToroidalRLayout.xpm"
#include "LineSamplerToroidalZLayout.xpm"
#include "LineSamplerToroidalConfLayout.xpm"

#include <LineSamplerAttributes.h>

#include <QTabWidget>
#include <QGroupBox>
#include <QCheckBox>
#include <QComboBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>
#include <QListWidget>
#include <QPushButton>
#include <QFileDialog>
#include <QBitmap>
#include <QPixmap>


// ****************************************************************************
// Method: QvisLineSamplerWindow::QvisLineSamplerWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSamplerWindow::QvisLineSamplerWindow(const int type,
                         LineSamplerAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisLineSamplerWindow::~QvisLineSamplerWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisLineSamplerWindow::~QvisLineSamplerWindow()
{
}


// ****************************************************************************
// Method: QvisLineSamplerWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSamplerWindow::CreateWindowContents()
{
    int width = 100;

    propertyTabs = new QTabWidget(central);
    topLayout->addWidget(propertyTabs, 1, 0);

    // ----------------------------------------------------------------------
    // Main tab
    // ----------------------------------------------------------------------
    mainTab = new QWidget(central);
    propertyTabs->addTab(mainTab, tr("Main"));
    
    QGridLayout *mainLayout = new QGridLayout(mainTab);

    meshGeometryLabel = new QLabel(tr("Mesh geometry"), central);
    mainLayout->addWidget(meshGeometryLabel,0,0);
    meshGeometry = new QWidget(central);
    meshGeometryButtonGroup= new QButtonGroup(meshGeometry);
    QHBoxLayout *meshGeometryLayout = new QHBoxLayout(meshGeometry);
    meshGeometryLayout->setMargin(0);
    meshGeometryLayout->setSpacing(10);
    QRadioButton *meshGeometryCartesian =
      new QRadioButton(tr("Cartesian"), meshGeometry);
    meshGeometryButtonGroup->addButton(meshGeometryCartesian,0);
    meshGeometryLayout->addWidget(meshGeometryCartesian);
    QRadioButton *meshGeometryCylindrical =
      new QRadioButton(tr("Cylindrical (R,Phi,Z)"), meshGeometry);
    meshGeometryButtonGroup->addButton(meshGeometryCylindrical,1);
    meshGeometryLayout->addWidget(meshGeometryCylindrical);
    QRadioButton *meshGeometryToroidal =
      new QRadioButton(tr("Toroidal"), meshGeometry);
    meshGeometryButtonGroup->addButton(meshGeometryToroidal,2);
    meshGeometryLayout->addWidget(meshGeometryToroidal);
    connect(meshGeometryButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(meshGeometryChanged(int)));
    mainLayout->addWidget(meshGeometry, 0,1,1,2);


    arrayConfigurationLabel = new QLabel(tr("Array configuration"), central);
    mainLayout->addWidget(arrayConfigurationLabel,1,0);
    arrayConfiguration = new QWidget(central);
    arrayConfigurationButtonGroup= new QButtonGroup(arrayConfiguration);
    QHBoxLayout *arrayConfigurationLayout = new QHBoxLayout(arrayConfiguration);
    arrayConfigurationLayout->setMargin(0);
    arrayConfigurationLayout->setSpacing(10);
    QRadioButton *arrayConfigurationGeometry =
      new QRadioButton(tr("Geometry"), arrayConfiguration);
    arrayConfigurationButtonGroup->addButton(arrayConfigurationGeometry,0);
    arrayConfigurationLayout->addWidget(arrayConfigurationGeometry);
    QRadioButton *arrayConfigurationManual =
      new QRadioButton(tr("Manual List"), arrayConfiguration);
    arrayConfigurationButtonGroup->addButton(arrayConfigurationManual,1);
    arrayConfigurationLayout->addWidget(arrayConfigurationManual);
    connect(arrayConfigurationButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(arrayConfigurationChanged(int)));
    mainLayout->addWidget(arrayConfiguration, 1,1);

    boundaryLabel = new QLabel(tr("Boundary"), central);
    mainLayout->addWidget(boundaryLabel,2,0);
    boundary = new QWidget(central);
    boundaryButtonGroup= new QButtonGroup(boundary);
    QHBoxLayout *boundaryLayout = new QHBoxLayout(boundary);
    boundaryLayout->setMargin(0);
    boundaryLayout->setSpacing(10);
    QRadioButton *boundaryData = new QRadioButton(tr("Data File"), boundary);
    boundaryButtonGroup->addButton(boundaryData,0);
    boundaryLayout->addWidget(boundaryData);
    QRadioButton *boundaryWall = new QRadioButton(tr("Wall File"), boundary);
    boundaryButtonGroup->addButton(boundaryWall,1);
    boundaryLayout->addWidget(boundaryWall);
    connect(boundaryButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(boundaryChanged(int)));
    mainLayout->addWidget(boundary, 2,1);

    wallReadFile =
      new QPushButton(tr("Read wall configuration file"), central);
    connect(wallReadFile,
            SIGNAL(clicked()), this, SLOT(readWall()));

    mainLayout->addWidget(wallReadFile, 2, 2);

    wallFileCoordinateLabel =
      new QLabel(tr("Coordinate layout R, Z"), central);
    mainLayout->addWidget(wallFileCoordinateLabel, 3, 2);
    wallList = new QListWidget(central);
    wallList->setSelectionMode(QAbstractItemView::NoSelection);
    mainLayout->addWidget(wallList, 4, 2, 3, 1);

    connect(wallList, SIGNAL(currentTextChanged(const QString&)),
            this, SLOT(wallListTextChanged(QString)));


    mainLayout->addWidget( new QLabel(tr("Set the instance when applying to multiple \nplots in a single window. I.e. if you want to\ncompare different samplings, set the instance\nto A for the first, and B for the second. These\nsettings will allow the attributes to be\npropagated to plots in other windows when\nusing the \"Apply to all windows\" option."), central), 4, 0, 2, 2);

    QWidget *instance = new QWidget(central);
    QHBoxLayout *instanceLayout = new QHBoxLayout(instance);
    instanceLayout->setMargin(0);
    instanceLayout->setSpacing(10);
    mainLayout->addWidget(instance, 6,0);

    instanceLayout->addWidget( new QLabel(tr("Instance"), central));
    instanceId = new QComboBox(central);
    instanceId->setMaximumWidth(50);
    instanceId->addItem(tr("A"));
    instanceId->addItem(tr("B"));
    instanceId->addItem(tr("C"));
    instanceId->addItem(tr("D"));
    instanceId->addItem(tr("E"));
    connect(instanceId, SIGNAL(activated(int)),
            this, SLOT(instanceIdChanged(int)));
    instanceLayout->addWidget(instanceId);
  
    // ----------------------------------------------------------------------
    // Geometry tab
    // ----------------------------------------------------------------------
    geometryTab = new QWidget(central);
    propertyTabs->addTab(geometryTab, tr("Geometry"));
    
    mainLayout = new QGridLayout(geometryTab);

    nArraysLabel = new QLabel(tr("Number of arrays"), central);
    mainLayout->addWidget(nArraysLabel,0,0);
    nArrays = new QLineEdit(central);
    nArrays->setMaximumWidth(width);
    connect(nArrays, SIGNAL(returnPressed()),
            this, SLOT(nArraysProcessText()));
    mainLayout->addWidget(nArrays, 0,1);

    toroidalArrayAngleLabel = new QLabel(tr("Toroidal angle between arrays"), central);
    mainLayout->addWidget(toroidalArrayAngleLabel,0,2);
    toroidalArrayAngle = new QLineEdit(central);
    toroidalArrayAngle->setMaximumWidth(width);
    connect(toroidalArrayAngle, SIGNAL(returnPressed()),
            this, SLOT(toroidalArrayAngleProcessText()));
    mainLayout->addWidget(toroidalArrayAngle, 0,3);


    // Projection tabs
    projectionTabs = new QTabWidget(central);
    mainLayout->addWidget(projectionTabs,2,0,3,4);

    connect(projectionTabs, SIGNAL(currentChanged(int)),
            this, SLOT(channelProjectionChanged(int)));

    // Divergent tab
    divergentTab = new QWidget(central);
    projectionTabs->addTab(divergentTab, tr("Divergent"));
    
    QGridLayout *divergentLayout = new QGridLayout(divergentTab);

    nDChannelsLabel = new QLabel(tr("Number of divergent channels"), central);
    divergentLayout->addWidget(nDChannelsLabel,0,0);
    nDChannels = new QLineEdit(central);
    nDChannels->setMaximumWidth(width);
    connect(nDChannels, SIGNAL(returnPressed()),
            this, SLOT(nChannelsProcessText()));
    divergentLayout->addWidget(nDChannels, 0,1);


//     dChannelLayoutTypeLabel = new QLabel(tr("Channel Layout"), central);
//     divergentLayout->addWidget(dChannelLayoutTypeLabel,1,0);
//     dChannelLayoutType = new QWidget(central);
//     dChannelLayoutTypeButtonGroup= new QButtonGroup(dChannelLayoutType);
//     QHBoxLayout *dChannelLayoutTypeLayout = new QHBoxLayout(dChannelLayoutType);
//     dChannelLayoutTypeLayout->setMargin(0);
//     dChannelLayoutTypeLayout->setSpacing(10);
//     QRadioButton *dChannelLayoutTypeAbsolute = new QRadioButton(tr("Absolute"), dChannelLayoutType);
//     dChannelLayoutTypeButtonGroup->addButton(dChannelLayoutTypeAbsolute,0);
//     dChannelLayoutTypeLayout->addWidget(dChannelLayoutTypeAbsolute);
//     QRadioButton *dChannelLayoutTypeRelative = new QRadioButton(tr("Relative"), dChannelLayoutType);
//     dChannelLayoutTypeButtonGroup->addButton(dChannelLayoutTypeRelative,1);
//     dChannelLayoutTypeLayout->addWidget(dChannelLayoutTypeRelative);
//     connect(dChannelLayoutTypeButtonGroup, SIGNAL(buttonClicked(int)),
//             this, SLOT(channelLayoutTypeChanged(int)));
//     divergentLayout->addWidget(dChannelLayoutType, 1,1,1,2);

//     poloialAngleLabel = new QLabel(tr("Absolute angle"), central);
//     divergentLayout->addWidget(poloialAngleLabel,2,0);

//     poloidalAngleStartLabel = new QLabel(tr("Start"), central);
//     divergentLayout->addWidget(poloidalAngleStartLabel,2,1);
//     poloidalAngleStart = new QLineEdit(central);
//     poloidalAngleStart->setMaximumWidth(width);
//     connect(poloidalAngleStart, SIGNAL(returnPressed()),
//             this, SLOT(poloidalAngleStartProcessText()));
//     divergentLayout->addWidget(poloidalAngleStart,2,2);

//     poloidalAngleStopLabel = new QLabel(tr("Stop"), central);
//     divergentLayout->addWidget(poloidalAngleStopLabel,2,3);
//     poloidalAngleStop = new QLineEdit(central);
//     poloidalAngleStop->setMaximumWidth(width);
//     connect(poloidalAngleStop, SIGNAL(returnPressed()),
//             this, SLOT(poloidalAngleStopProcessText()));
//     divergentLayout->addWidget(poloidalAngleStop,2,4);


    channelAngleLabel = new QLabel(tr("Relative angle between channels"), central);
    divergentLayout->addWidget(channelAngleLabel,3,0);
    channelAngle = new QLineEdit(central);
    channelAngle->setMaximumWidth(width);
    connect(channelAngle, SIGNAL(returnPressed()),
            this, SLOT(channelAngleProcessText()));
    divergentLayout->addWidget(channelAngle, 3,1);


    // Parallel tab
    parallelTab = new QWidget(central);
    projectionTabs->addTab(parallelTab, tr("Parallel"));
    
    QGridLayout *parallelLayout = new QGridLayout(parallelTab);

    nPChannelsLabel = new QLabel(tr("Number of parallel channels"), central);
    parallelLayout->addWidget(nPChannelsLabel,0,0);
    nPChannels = new QLineEdit(central);
    nPChannels->setMaximumWidth(width);
    connect(nPChannels, SIGNAL(returnPressed()),
            this, SLOT(nChannelsProcessText()));
    parallelLayout->addWidget(nPChannels, 0,1);


    channelParallelOffsetLabel = new QLabel(tr("Offset between channels"), central);
    parallelLayout->addWidget(channelParallelOffsetLabel,1,0);
    channelParallelOffset = new QLineEdit(central);
    channelParallelOffset->setMaximumWidth(width);
    connect(channelParallelOffset, SIGNAL(returnPressed()),
            this, SLOT(channelOffsetProcessText()));
    parallelLayout->addWidget(channelParallelOffset, 1,1);



    // Grid tab
    gridTab = new QWidget(central);
    projectionTabs->addTab(gridTab, tr("Grid"));
    
    QGridLayout *gridLayout = new QGridLayout(gridTab);

    nGChannelsLabel = new QLabel(tr("Number of channels per column"), central);
    gridLayout->addWidget(nGChannelsLabel,0,0);
    nGChannels = new QLineEdit(central);
    nGChannels->setMaximumWidth(width);
    connect(nGChannels, SIGNAL(returnPressed()),
            this, SLOT(nChannelsProcessText()));
    gridLayout->addWidget(nGChannels, 0,1);

    channelGridOffsetLabel = new QLabel(tr("Offset between channels"), central);
    gridLayout->addWidget(channelGridOffsetLabel,1,0);
    channelGridOffset = new QLineEdit(central);
    channelGridOffset->setMaximumWidth(width);
    connect(channelGridOffset, SIGNAL(returnPressed()),
            this, SLOT(channelOffsetProcessText()));
    gridLayout->addWidget(channelGridOffset, 1,1);


    nRowsLabel = new QLabel(tr("Number of rows"), central);
    gridLayout->addWidget(nRowsLabel,2,0);
    nRows = new QLineEdit(central);
    nRows->setMaximumWidth(width);
    connect(nRows, SIGNAL(returnPressed()),
            this, SLOT(nRowsProcessText()));
    gridLayout->addWidget(nRows, 2,1);

    rowOffsetLabel = new QLabel(tr("Offset between rows"), central);
    gridLayout->addWidget(rowOffsetLabel,3,0);
    rowOffset = new QLineEdit(central);
    rowOffset->setMaximumWidth(width);
    connect(rowOffset, SIGNAL(returnPressed()),
            this, SLOT(rowOffsetProcessText()));
    gridLayout->addWidget(rowOffset, 3,1);



//     channelProjectionLabel = new QLabel(tr("Channel projection"), central);
//     mainLayout->addWidget(channelProjectionLabel,2,0);
//     channelProjection = new QWidget(central);
//     channelProjectionButtonGroup= new QButtonGroup(channelProjection);
//     QHBoxLayout *channelProjectionLayout = new QHBoxLayout(channelProjection);
//     channelProjectionLayout->setMargin(0);
//     channelProjectionLayout->setSpacing(10);

//     QRadioButton *channelProjectionDivergent = new QRadioButton(tr("Divergent"), channelProjection);
//     channelProjectionButtonGroup->addButton(channelProjectionDivergent,0);
//     channelProjectionLayout->addWidget(channelProjectionDivergent);

//     QRadioButton *channelProjectionParallel = new QRadioButton(tr("Parallel"), channelProjection);
//     channelProjectionButtonGroup->addButton(channelProjectionParallel,1);
//     channelProjectionLayout->addWidget(channelProjectionParallel);

//     QRadioButton *channelProjectionGrid = new QRadioButton(tr("Grid"), channelProjection);
//     channelProjectionButtonGroup->addButton(channelProjectionGrid,2);
//     channelProjectionLayout->addWidget(channelProjectionGrid);
//     connect(channelProjectionButtonGroup, SIGNAL(buttonClicked(int)),
//             this, SLOT(channelProjectionChanged(int)));
//    mainLayout->addWidget(channelProjection, 2,1,1,2);


    arrayOriginLabel = new QLabel(tr("Array origin (R,Z)"), central);
    mainLayout->addWidget(arrayOriginLabel,9,0);
    arrayOrigin = new QLineEdit(central);
    arrayOrigin->setMaximumWidth(width);
    connect(arrayOrigin, SIGNAL(returnPressed()),
            this, SLOT(arrayOriginProcessText()));
    mainLayout->addWidget(arrayOrigin, 9,1,1,2);

    arrayAxisLabel = new QLabel(tr("Array axis direction"), central);
    mainLayout->addWidget(arrayAxisLabel,10,0);
    arrayAxis = new QWidget(central);
    arrayAxisButtonGroup= new QButtonGroup(arrayAxis);
    QHBoxLayout *arrayAxisLayout = new QHBoxLayout(arrayAxis);
    arrayAxisLayout->setMargin(0);
    arrayAxisLayout->setSpacing(10);
    arrayAxisArrayAxisR = new QRadioButton(tr("R"), arrayAxis);
    arrayAxisButtonGroup->addButton(arrayAxisArrayAxisR,0);
    arrayAxisLayout->addWidget(arrayAxisArrayAxisR);
    arrayAxisArrayAxisZ = new QRadioButton(tr("Z"), arrayAxis);
    arrayAxisButtonGroup->addButton(arrayAxisArrayAxisZ,1);
    arrayAxisLayout->addWidget(arrayAxisArrayAxisZ);
    connect(arrayAxisButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(arrayAxisChanged(int)));
    mainLayout->addWidget(arrayAxis, 10,1);

    poloialAngleLabel = new QLabel(tr("Poloidal angle"), central);
    mainLayout->addWidget(poloialAngleLabel,11,0);
    poloialAngle = new QLineEdit(central);
    poloialAngle->setMaximumWidth(width);
    connect(poloialAngle, SIGNAL(returnPressed()),
            this, SLOT(poloialAngleProcessText()));
    mainLayout->addWidget(poloialAngle, 11,1);

    poloialRTiltLabel = new QLabel(tr("Poloidal plane R-tilt"), central);
    mainLayout->addWidget(poloialRTiltLabel,12,0);
    poloialRTilt = new QLineEdit(central);
    poloialRTilt->setMaximumWidth(width);
    connect(poloialRTilt, SIGNAL(returnPressed()),
            this, SLOT(poloialRTiltProcessText()));
    mainLayout->addWidget(poloialRTilt, 12,1);

    poloialZTiltLabel = new QLabel(tr("Poloidal plane Z-tilt"), central);
    mainLayout->addWidget(poloialZTiltLabel,13,0);
    poloialZTilt = new QLineEdit(central);
    poloialZTilt->setMaximumWidth(width);
    connect(poloialZTilt, SIGNAL(returnPressed()),
            this, SLOT(poloialZTiltProcessText()));
    mainLayout->addWidget(poloialZTilt, 13,1);

    toroidalAngleLabel = new QLabel(tr("Toroidal angle"), central);
    mainLayout->addWidget(toroidalAngleLabel,14,0);
    toroidalAngle = new QLineEdit(central);
    toroidalAngle->setMaximumWidth(width);
    connect(toroidalAngle, SIGNAL(returnPressed()),
            this, SLOT(toroidalAngleProcessText()));
    mainLayout->addWidget(toroidalAngle, 14,1);

    flipToroidalAngle = new QCheckBox(tr("Flip toroidal angle"), central);
    connect(flipToroidalAngle, SIGNAL(toggled(bool)),
            this, SLOT(flipToroidalAngleChanged(bool)));
    mainLayout->addWidget(flipToroidalAngle, 15,0);

    QPixmap cartesianXLayoutPixmap(LineSamplerCartesianXLayout_xpm);
    cartesianXLayoutLabel = new QLabel(tr(""), central);
    cartesianXLayoutLabel->setPixmap(cartesianXLayoutPixmap);
    cartesianXLayoutLabel->setMask(cartesianXLayoutPixmap.mask());
    mainLayout->addWidget(cartesianXLayoutLabel,9,2,7,2, Qt::AlignRight);
    cartesianXLayoutLabel->setVisible( false );

    QPixmap cartesianZLayoutPixmap(LineSamplerCartesianZLayout_xpm);
    cartesianZLayoutLabel = new QLabel(tr(""), central);
    cartesianZLayoutLabel->setPixmap(cartesianZLayoutPixmap);
    cartesianZLayoutLabel->setMask(cartesianZLayoutPixmap.mask());
    mainLayout->addWidget(cartesianZLayoutLabel,9,2,7,2, Qt::AlignRight);
    cartesianZLayoutLabel->setVisible( false );

    QPixmap cylindricalRLayoutPixmap(LineSamplerCylindricalRLayout_xpm);
    cylindricalRLayoutLabel = new QLabel(tr(""), central);
    cylindricalRLayoutLabel->setPixmap(cylindricalRLayoutPixmap);
    cylindricalRLayoutLabel->setMask(cylindricalRLayoutPixmap.mask());
    mainLayout->addWidget(cylindricalRLayoutLabel,9,2,7,2, Qt::AlignRight);
    cylindricalRLayoutLabel->setVisible( false );

    QPixmap cylindricalZLayoutPixmap(LineSamplerCylindricalZLayout_xpm);
    cylindricalZLayoutLabel = new QLabel(tr(""), central);
    cylindricalZLayoutLabel->setPixmap(cylindricalZLayoutPixmap);
    cylindricalZLayoutLabel->setMask(cylindricalZLayoutPixmap.mask());
    mainLayout->addWidget(cylindricalZLayoutLabel,9,2,7,2, Qt::AlignRight);
    cylindricalZLayoutLabel->setVisible( false );

    QPixmap toroidalRLayoutPixmap(LineSamplerToroidalRLayout_xpm);
    toroidalRLayoutLabel = new QLabel(tr(""), central);
    toroidalRLayoutLabel->setPixmap(toroidalRLayoutPixmap);
    toroidalRLayoutLabel->setMask(toroidalRLayoutPixmap.mask());
    mainLayout->addWidget(toroidalRLayoutLabel,9,2,7,2, Qt::AlignRight);
    toroidalRLayoutLabel->setVisible( false );

    QPixmap toroidalZLayoutPixmap(LineSamplerToroidalZLayout_xpm);
    toroidalZLayoutLabel = new QLabel(tr(""), central);
    toroidalZLayoutLabel->setPixmap(toroidalZLayoutPixmap);
    toroidalZLayoutLabel->setMask(toroidalZLayoutPixmap.mask());
    mainLayout->addWidget(toroidalZLayoutLabel,9,2,7,2, Qt::AlignRight);
    toroidalZLayoutLabel->setVisible( true );

    // ----------------------------------------------------------------------
    // List tab
    // ----------------------------------------------------------------------
    listTab = new QWidget(central);
    propertyTabs->addTab(listTab, tr("List"));
    
    mainLayout = new QGridLayout(listTab);

    nChannelListArraysLabel = new QLabel(tr("Number of arrays"), central);
    mainLayout->addWidget(nChannelListArraysLabel,0,0);
    nChannelListArrays = new QLineEdit(central);
    nChannelListArrays->setMaximumWidth(width);
    connect(nArrays, SIGNAL(returnPressed()),
            this, SLOT(nChannelListArraysProcessText()));
    mainLayout->addWidget(nChannelListArrays, 0,1);

    channelListToroidalArrayAngleLabel =
      new QLabel(tr("Toroidal angle between arrays"), central);
    mainLayout->addWidget(channelListToroidalArrayAngleLabel,0,2);
    channelListToroidalArrayAngle = new QLineEdit(central);
    channelListToroidalArrayAngle->setMaximumWidth(width);
    connect(channelListToroidalArrayAngle, SIGNAL(returnPressed()),
            this, SLOT(channelListToroidalArrayAngleProcessText()));
    mainLayout->addWidget(channelListToroidalArrayAngle, 0,3);

    //Channel list.
    confFileCoordinateLabel =
      new QLabel(tr(" R, Z, Phi, and Poloidal Angle"), central);
    mainLayout->addWidget(confFileCoordinateLabel, 1, 0);
    channelList = new QListWidget(central);
    mainLayout->addWidget(channelList, 2, 0, 10, 2);

    connect(channelList, SIGNAL(itemDoubleClicked(QListWidgetItem*)),
            this, SLOT(channelListDoubleClicked(QListWidgetItem*)));
    connect(channelList, SIGNAL(itemClicked(QListWidgetItem*)),
            this, SLOT(channelListClicked(QListWidgetItem*)));
    connect(channelList, SIGNAL(currentTextChanged(const QString&)),
            this, SLOT(channelListTextChanged(QString)));

    channelListReadChannels =
      new QPushButton(tr("Read channel configuration file"), central);
    channelListAddChannel =
      new QPushButton(tr("Add Channel"), central);
    channelListDeleteChannel =
      new QPushButton(tr("Delete Channel"), central);
    channelListDeleteAllChannels =
      new QPushButton(tr("Delete All Channels"), central);

    connect(channelListReadChannels,
            SIGNAL(clicked()), this, SLOT(readChannels()));
    connect(channelListAddChannel,
            SIGNAL(clicked()), this, SLOT(addChannel()));
    connect(channelListDeleteChannel,
            SIGNAL(clicked()), this, SLOT(deleteChannel()));
    connect(channelListDeleteAllChannels,
            SIGNAL(clicked()), this, SLOT(deleteChannels()));


    mainLayout->addWidget(channelListReadChannels,      2, 2, 1, 2);
    mainLayout->addWidget(channelListAddChannel,        3, 2, 1, 2);
    mainLayout->addWidget(channelListDeleteChannel,     4, 2, 1, 2);
    mainLayout->addWidget(channelListDeleteAllChannels, 5, 2, 1, 2);


    channelListToroidalAngleLabel = new QLabel(tr("Toroidal angle"), central);
    mainLayout->addWidget(channelListToroidalAngleLabel,14,0);
    channelListToroidalAngle = new QLineEdit(central);
    channelListToroidalAngle->setMaximumWidth(width);
    connect(channelListToroidalAngle, SIGNAL(returnPressed()),
            this, SLOT(channelListToroidalAngleProcessText()));
    mainLayout->addWidget(channelListToroidalAngle, 14,1);

    channelListFlipToroidalAngle = new QCheckBox(tr("Flip toroidal angle"), central);
    connect(channelListFlipToroidalAngle, SIGNAL(toggled(bool)),
            this, SLOT(channelListFlipToroidalAngleChanged(bool)));
    mainLayout->addWidget(channelListFlipToroidalAngle, 15,0);

    QPixmap cartesianConfLayoutPixmap(LineSamplerCartesianConfLayout_xpm);
    cartesianConfLayoutLabel = new QLabel(tr(""), central);
    cartesianConfLayoutLabel->setPixmap(cartesianConfLayoutPixmap);
    cartesianConfLayoutLabel->setMask(cartesianConfLayoutPixmap.mask());
    mainLayout->addWidget(cartesianConfLayoutLabel,9,2,7,2, Qt::AlignRight);
    cartesianConfLayoutLabel->setVisible( false );

    QPixmap cylindricalConfLayoutPixmap(LineSamplerCylindricalConfLayout_xpm);
    cylindricalConfLayoutLabel = new QLabel(tr(""), central);
    cylindricalConfLayoutLabel->setPixmap(cylindricalConfLayoutPixmap);
    cylindricalConfLayoutLabel->setMask(cylindricalConfLayoutPixmap.mask());
    mainLayout->addWidget(cylindricalConfLayoutLabel,9,2,7,2, Qt::AlignRight);
    cylindricalConfLayoutLabel->setVisible( false );

    QPixmap toroidalConfLayoutPixmap(LineSamplerToroidalConfLayout_xpm);
    toroidalConfLayoutLabel = new QLabel(tr(""), central);
    toroidalConfLayoutLabel->setPixmap(toroidalConfLayoutPixmap);
    toroidalConfLayoutLabel->setMask(toroidalConfLayoutPixmap.mask());
    mainLayout->addWidget(toroidalConfLayoutLabel,9,2,7,2, Qt::AlignRight);
    toroidalConfLayoutLabel->setVisible( true );


    // ----------------------------------------------------------------------
    // Sampling tab
    // ----------------------------------------------------------------------
    samplingTab = new QWidget(central);
    propertyTabs->addTab(samplingTab, tr("Sampling"));
    
    mainLayout = new QGridLayout(samplingTab);

    // Create the channel geometry group box.
    QGroupBox *geometryGroup = new QGroupBox(samplingTab);
    geometryGroup->setTitle(tr("Geometry"));
    mainLayout->addWidget(geometryGroup, 0, 0, 2, 7);

    QGridLayout *geometryLayout = new QGridLayout(geometryGroup);
    geometryLayout->setMargin(5);
    geometryLayout->setSpacing(10);


    channelGeometryLabel = new QLabel(tr("Channel geometry"), central);
    geometryLayout->addWidget(channelGeometryLabel,0,0);
    channelGeometry = new QWidget(central);
    channelGeometryButtonGroup= new QButtonGroup(channelGeometry);
    QHBoxLayout *channelGeometryLayout = new QHBoxLayout(channelGeometry);
    channelGeometryLayout->setMargin(0);
    channelGeometryLayout->setSpacing(10);

    QRadioButton *channelGeometryPoint = new QRadioButton(tr("Point"), channelGeometry);
    channelGeometryButtonGroup->addButton(channelGeometryPoint,0);
    channelGeometryLayout->addWidget(channelGeometryPoint);

    QRadioButton *channelGeometryLine = new QRadioButton(tr("Line"), channelGeometry);
    channelGeometryButtonGroup->addButton(channelGeometryLine,1);
    channelGeometryLayout->addWidget(channelGeometryLine);

    // QRadioButton *channelGeometryCylinder = new QRadioButton(tr("Cylinder"), channelGeometry);
    // channelGeometryButtonGroup->addButton(channelGeometryCylinder,2);
    // channelGeometryLayout->addWidget(channelGeometryCylinder);

//     QRadioButton *channelGeometryCone = new QRadioButton(tr("Cone"), channelGeometry);
//     channelGeometryButtonGroup->addButton(channelGeometryCone,3);
//     channelGeometryLayout->addWidget(channelGeometryCone);
    connect(channelGeometryButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(channelGeometryChanged(int)));
    geometryLayout->addWidget(channelGeometry, 0,1,1,3);

    sampleDistanceLabel = new QLabel(tr("Linear sample distance"), central);
    geometryLayout->addWidget(sampleDistanceLabel,1,0);
    sampleDistance = new QLineEdit(central);
    sampleDistance->setMaximumWidth(width);
    connect(sampleDistance, SIGNAL(returnPressed()),
            this, SLOT(sampleDistanceProcessText()));
    geometryLayout->addWidget(sampleDistance, 1,1);

    sampleVolumeLabel = new QLabel(tr("Sample volume"), central);
    geometryLayout->addWidget(sampleVolumeLabel,1,2);
    sampleVolume = new QLineEdit(central);
    sampleVolume->setMaximumWidth(width);
    connect(sampleVolume, SIGNAL(returnPressed()),
            this, SLOT(sampleVolumeProcessText()));
    geometryLayout->addWidget(sampleVolume, 1,3);

    radiusLabel = new QLabel(tr("Cylinder radius"), central);
    geometryLayout->addWidget(radiusLabel,2,0);
    radius = new QLineEdit(central);
    radius->setMaximumWidth(width);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    geometryLayout->addWidget(radius, 2,1);

//     divergenceLabel = new QLabel(tr("Cone divergence"), central);
//     geometryLayout->addWidget(divergenceLabel,2,2);
//     divergence = new QLineEdit(central);
//     connect(divergence, SIGNAL(returnPressed()),
//             this, SLOT(divergenceProcessText()));
//     geometryLayout->addWidget(divergence, 2,3);

    channelProfileLabel = new QLabel(tr("Cylinder sample profile"), central);
    geometryLayout->addWidget(channelProfileLabel,3,0);
    channelProfile = new QWidget(central);
    channelProfileButtonGroup= new QButtonGroup(channelProfile);
    QHBoxLayout *channelProfileLayout = new QHBoxLayout(channelProfile);
    channelProfileLayout->setMargin(0);
    channelProfileLayout->setSpacing(10);
    channelProfileChannelTypeTopHat = new QRadioButton(tr("TopHat"), channelProfile);
    channelProfileButtonGroup->addButton(channelProfileChannelTypeTopHat,0);
    channelProfileLayout->addWidget(channelProfileChannelTypeTopHat);
    channelProfileChannelTypeGaussian = new QRadioButton(tr("Gaussian"), channelProfile);
    channelProfileButtonGroup->addButton(channelProfileChannelTypeGaussian,1);
    channelProfileLayout->addWidget(channelProfileChannelTypeGaussian);
    connect(channelProfileButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(channelProfileChanged(int)));
    geometryLayout->addWidget(channelProfile, 3,1);

    standardDeviationLabel = new QLabel(tr("Standard deviation"), central);
    geometryLayout->addWidget(standardDeviationLabel,3,2);
    standardDeviation = new QLineEdit(central);
    connect(standardDeviation, SIGNAL(returnPressed()),
            this, SLOT(standardDeviationProcessText()));
    geometryLayout->addWidget(standardDeviation, 3,3);

//     sampleArcLabel = new QLabel(tr("Radial sample arc"), central);
//     geometryLayout->addWidget(sampleArcLabel,4,0);
//     sampleArc = new QLineEdit(central);
//     connect(sampleArc, SIGNAL(returnPressed()),
//             this, SLOT(sampleArcProcessText()));
//     geometryLayout->addWidget(sampleArc, 4,1);


    // Create the integration group box.
    QGroupBox *integrationGroup = new QGroupBox(samplingTab);
    integrationGroup->setTitle(tr("Integration"));
    mainLayout->addWidget(integrationGroup, 2, 0, 2, 7);

    QGridLayout *integrationLayout = new QGridLayout(integrationGroup);
    integrationLayout->setMargin(5);
    integrationLayout->setSpacing(10);

    channelIntegrationLabel = new QLabel(tr("Channel"), central);
    integrationLayout->addWidget(channelIntegrationLabel,0,0);
    channelIntegration = new QWidget(central);
    channelIntegrationButtonGroup= new QButtonGroup(channelIntegration);

    channelIntegrationNone =
      new QRadioButton(tr("None"), channelIntegration);
    channelIntegrationButtonGroup->addButton(channelIntegrationNone,0);
    integrationLayout->addWidget(channelIntegrationNone,0,1);

    channelIntegrationSummation =
      new QRadioButton(tr("Integrate along the channel"), channelIntegration);
    channelIntegrationButtonGroup->addButton(channelIntegrationSummation,1);
    integrationLayout->addWidget(channelIntegrationSummation,0,2);

    connect(channelIntegrationButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(channelIntegrationChanged(int)));

    toroidalIntegrationLabel = new QLabel(tr("Toroidal"), central);
    integrationLayout->addWidget(toroidalIntegrationLabel,1,0);
    toroidalIntegration = new QWidget(central);
    toroidalIntegrationButtonGroup = new QButtonGroup(toroidalIntegration);

    toroidalIntegrationNone =
      new QRadioButton(tr("None"), toroidalIntegration);
    toroidalIntegrationButtonGroup->addButton(toroidalIntegrationNone,0);
    integrationLayout->addWidget(toroidalIntegrationNone,1,1);

    toroidalIntegrationTime =
      new QRadioButton(tr("Sample toroidally as time"), toroidalIntegration);
    toroidalIntegrationButtonGroup->addButton(toroidalIntegrationTime,1);
    integrationLayout->addWidget(toroidalIntegrationTime,1,2);

    toroidalIntegrationSummation =
      new QRadioButton(tr("Integrate toroidally"), toroidalIntegration);
    toroidalIntegrationButtonGroup->addButton(toroidalIntegrationSummation,2);
    integrationLayout->addWidget(toroidalIntegrationSummation,1,3);

    connect(toroidalIntegrationButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(toroidalIntegrationChanged(int)));


    // Create the toroidal sampling group box.
    toroidalGroup = new QGroupBox(samplingTab);
    toroidalGroup->setTitle(tr("Toroidal angle sampling"));
    mainLayout->addWidget(toroidalGroup, 4, 0, 2, 7);

    QGridLayout *toroidalLayout = new QGridLayout(toroidalGroup);
    toroidalLayout->setMargin(5);
    toroidalLayout->setSpacing(10);


    toroidalAngleSamplingLabel = new QLabel(tr("Sample"), central);
    toroidalLayout->addWidget(toroidalAngleSamplingLabel,0,0);
    toroidalAngleSampling = new QWidget(central);
    toroidalAngleSamplingButtonGroup= new QButtonGroup(toroidalAngleSampling);
    QHBoxLayout *toroidalAngleSamplingLayout = new QHBoxLayout(toroidalAngleSampling);
    toroidalAngleSamplingLayout->setMargin(0);
    toroidalAngleSamplingLayout->setSpacing(10);
    QRadioButton *toroidalAngleSamplingToroidalAngleSamplingSingleToroidalAngleSampling = new QRadioButton(tr("Absolute"), toroidalAngleSampling);
    toroidalAngleSamplingButtonGroup->addButton(toroidalAngleSamplingToroidalAngleSamplingSingleToroidalAngleSampling,0);
    toroidalAngleSamplingLayout->addWidget(toroidalAngleSamplingToroidalAngleSamplingSingleToroidalAngleSampling);
    QRadioButton *toroidalAngleSamplingToroidalAngleSamplingSummationToroidalAngleSampling = new QRadioButton(tr("Relative"), toroidalAngleSampling);
    toroidalAngleSamplingButtonGroup->addButton(toroidalAngleSamplingToroidalAngleSamplingSummationToroidalAngleSampling,1);
    toroidalAngleSamplingLayout->addWidget(toroidalAngleSamplingToroidalAngleSamplingSummationToroidalAngleSampling);
    connect(toroidalAngleSamplingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(toroidalAngleSamplingChanged(int)));
    toroidalLayout->addWidget(toroidalAngleSampling,0,1,1,7);

    toroidalAngleSampleLabel = new QLabel(tr("Toroidal sample angle"), central);
    toroidalLayout->addWidget(toroidalAngleSampleLabel,1,0);

    toroidalAngleStartLabel = new QLabel(tr("Start"), central);
    toroidalLayout->addWidget(toroidalAngleStartLabel,1,1);
    toroidalAngleStart = new QLineEdit(central);
    toroidalAngleStart->setMaximumWidth(width);
    connect(toroidalAngleStart, SIGNAL(returnPressed()),
            this, SLOT(toroidalAngleStartProcessText()));
    toroidalLayout->addWidget(toroidalAngleStart,1,2);

    toroidalAngleStopLabel = new QLabel(tr("Stop"), central);
    toroidalLayout->addWidget(toroidalAngleStopLabel,1,3);
    toroidalAngleStop = new QLineEdit(central);
    toroidalAngleStop->setMaximumWidth(width);
    connect(toroidalAngleStop, SIGNAL(returnPressed()),
            this, SLOT(toroidalAngleStopProcessText()));
    toroidalLayout->addWidget(toroidalAngleStop,1,4);

    toroidalAngleStrideLabel = new QLabel(tr("Stride"), central);
    toroidalLayout->addWidget(toroidalAngleStrideLabel,1,5);
    toroidalAngleStride = new QLineEdit(central);
    toroidalAngleStride->setMaximumWidth(width);
    connect(toroidalAngleStride, SIGNAL(returnPressed()),
            this, SLOT(toroidalAngleStrideProcessText()));
    toroidalLayout->addWidget(toroidalAngleStride,1,6);


    // Create the time group box.
    QGroupBox *timeGroup = new QGroupBox(samplingTab);
    timeGroup->setTitle(tr("Time sampling"));
    mainLayout->addWidget(timeGroup, 6, 0, 2, 7);

    QGridLayout *timeLayout = new QGridLayout(timeGroup);
    timeLayout->setMargin(5);
    timeLayout->setSpacing(10);

    timeSamplingLabel = new QLabel(tr("Sample"), central);
    timeLayout->addWidget(timeSamplingLabel,0,0);
    timeSampling = new QWidget(central);
    timeSamplingButtonGroup= new QButtonGroup(timeSampling);
    QHBoxLayout *timeSamplingLayout = new QHBoxLayout(timeSampling);
    timeSamplingLayout->setMargin(0);
    timeSamplingLayout->setSpacing(10);
    QRadioButton *currentTimeStep =
      new QRadioButton(tr("Current Time Step"), timeSampling);
    timeSamplingButtonGroup->addButton(currentTimeStep,0);
    timeSamplingLayout->addWidget(currentTimeStep);
    QRadioButton *multipleTimeSteps =
      new QRadioButton(tr("Multiple Time Steps"), timeSampling);
    timeSamplingButtonGroup->addButton(multipleTimeSteps,1);
    timeSamplingLayout->addWidget(multipleTimeSteps);
    connect(timeSamplingButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(timeSamplingChanged(int)));
    timeLayout->addWidget(timeSampling,0,1,1,7);

    timeStepLabel = new QLabel(tr("Time step"), central);
    timeLayout->addWidget(timeStepLabel, 1,0);

    timeStepStartLabel = new QLabel(tr("Start"), central);
    timeLayout->addWidget(timeStepStartLabel, 1,1);
    timeStepStart = new QLineEdit(central);
    timeStepStart->setMaximumWidth(width);
    connect(timeStepStart, SIGNAL(returnPressed()),
            this, SLOT(timeStepStartProcessText()));
    timeLayout->addWidget(timeStepStart, 1,2);

    timeStepStopLabel = new QLabel(tr("Stop"), central);
    timeLayout->addWidget(timeStepStopLabel, 1,3);
    timeStepStop = new QLineEdit(central);
    timeStepStop->setMaximumWidth(width);
    connect(timeStepStop, SIGNAL(returnPressed()),
            this, SLOT(timeStepStopProcessText()));
    timeLayout->addWidget(timeStepStop, 1,4);

    timeStepStrideLabel = new QLabel(tr("Stride"), central);
    timeLayout->addWidget(timeStepStrideLabel, 1,5);
    timeStepStride = new QLineEdit(central);
    timeStepStride->setMaximumWidth(width);
    connect(timeStepStride, SIGNAL(returnPressed()),
            this, SLOT(timeStepStrideProcessText()));
    timeLayout->addWidget(timeStepStride, 1,6);

    // ----------------------------------------------------------------------
    // View tab
    // ----------------------------------------------------------------------
    viewTab = new QWidget(central);
    propertyTabs->addTab(viewTab, tr("View"));
    
    mainLayout = new QGridLayout(viewTab);

    // View dimension
    viewDimensionLabel = new QLabel(tr("View dimension"), central);
    mainLayout->addWidget(viewDimensionLabel,0,0);

    viewDimension = new QWidget(central);
    viewDimensionButtonGroup= new QButtonGroup(viewDimension);
    QHBoxLayout *viewDimensionLayout = new QHBoxLayout(viewDimension);
    viewDimensionLayout->setMargin(0);
    viewDimensionLayout->setSpacing(10);


    QRadioButton *viewDimensionOne = new QRadioButton(tr("One"), viewDimension);
    viewDimensionButtonGroup->addButton(viewDimensionOne,0);
    viewDimensionLayout->addWidget(viewDimensionOne);

    QRadioButton *viewDimensionTwo = new QRadioButton(tr("Two"), viewDimension);
    viewDimensionButtonGroup->addButton(viewDimensionTwo,1);
    viewDimensionLayout->addWidget(viewDimensionTwo);

    QRadioButton *viewDimensionThree = new QRadioButton(tr("Three"), viewDimension);
    viewDimensionButtonGroup->addButton(viewDimensionThree,2);
    viewDimensionLayout->addWidget(viewDimensionThree);

    connect(viewDimensionButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(viewDimensionChanged(int)));

    mainLayout->addWidget(viewDimension,0,1);


    donotApplyToAll = new QCheckBox(tr("Do not apply to all"), central);
    connect(donotApplyToAll, SIGNAL(toggled(bool)),
            this, SLOT(donotApplyToAllChanged(bool)));
    mainLayout->addWidget(donotApplyToAll, 0,3);


    // Create the oneDPlot group box.
    oneDPlotGroup = new QGroupBox(viewTab);
    oneDPlotGroup->setTitle(tr("1D plot viewing parameters"));
    mainLayout->addWidget(oneDPlotGroup, 1, 0, 4, 4);

    QGridLayout *oneDPlotLayout = new QGridLayout(oneDPlotGroup);
    oneDPlotLayout->setMargin(5);
    oneDPlotLayout->setSpacing(10);


    heightPlotScaleLabel = new QLabel(tr("1D plot height scale"), central);
    oneDPlotLayout->addWidget(heightPlotScaleLabel,0,0);
    heightPlotScale = new QLineEdit(central);
    heightPlotScale->setMaximumWidth(width);
    connect(heightPlotScale, SIGNAL(returnPressed()),
            this, SLOT(heightPlotScaleProcessText()));
    oneDPlotLayout->addWidget(heightPlotScale, 0,1);

    channelPlotOffsetLabel = new QLabel(tr("1D plot channel offset"), central);
    oneDPlotLayout->addWidget(channelPlotOffsetLabel,1,0);
    channelPlotOffset = new QLineEdit(central);
    channelPlotOffset->setMaximumWidth(width);
    connect(channelPlotOffset, SIGNAL(returnPressed()),
            this, SLOT(channelPlotOffsetProcessText()));
    oneDPlotLayout->addWidget(channelPlotOffset,1,1);

    arrayPlotOffsetLabel = new QLabel(tr("1D plot array offset"), central);
    oneDPlotLayout->addWidget(arrayPlotOffsetLabel,2,0);
    arrayPlotOffset = new QLineEdit(central);
    arrayPlotOffset->setMaximumWidth(width);
    connect(arrayPlotOffset, SIGNAL(returnPressed()),
            this, SLOT(arrayPlotOffsetProcessText()));
    oneDPlotLayout->addWidget(arrayPlotOffset,2,1);

    // Time axis
    displayTimeLabel = new QLabel(tr("Display time using"), central);
    oneDPlotLayout->addWidget(displayTimeLabel,3,0);

    displayTime = new QWidget(central);
    displayTimeButtonGroup= new QButtonGroup(displayTime);
    QHBoxLayout *displayTimeLayout = new QHBoxLayout(displayTime);
    displayTimeLayout->setMargin(0);
    displayTimeLayout->setSpacing(10);

    QRadioButton *displayTimeStep = new QRadioButton(tr("Step"), displayTime);
    displayTimeButtonGroup->addButton(displayTimeStep,0);
    displayTimeLayout->addWidget(displayTimeStep);

    QRadioButton *displayTimeTime = new QRadioButton(tr("Time"), displayTime);
    displayTimeButtonGroup->addButton(displayTimeTime,1);
    displayTimeLayout->addWidget(displayTimeTime);

    QRadioButton *displayTimeCycle = new QRadioButton(tr("Cycle"), displayTime);
    displayTimeButtonGroup->addButton(displayTimeCycle,2);
    displayTimeLayout->addWidget(displayTimeCycle);

    connect(displayTimeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(displayTimeChanged(int)));

    oneDPlotLayout->addWidget(displayTime,3,1);

    // Create the misc group box.
    QGroupBox *miscGroup = new QGroupBox(viewTab);
    miscGroup->setTitle(tr("Misc viewing parameters"));
    mainLayout->addWidget(miscGroup, 5, 0, 2, 4);

    QGridLayout *miscLayout = new QGridLayout(miscGroup);
    miscLayout->setMargin(5);
    miscLayout->setSpacing(10);


    viewGeometryLabel = new QLabel(tr("View geometry"), central);
    miscLayout->addWidget(viewGeometryLabel,0,0);

    viewGeometry = new QWidget(central);
    viewGeometryButtonGroup= new QButtonGroup(viewGeometry);
    QHBoxLayout *viewGeometryLayout = new QHBoxLayout(viewGeometry);
    viewGeometryLayout->setMargin(0);
    viewGeometryLayout->setSpacing(10);


    QRadioButton *viewGeometryOne = new QRadioButton(tr("Points"), viewGeometry);
    viewGeometryButtonGroup->addButton(viewGeometryOne,0);
    viewGeometryLayout->addWidget(viewGeometryOne);

    QRadioButton *viewGeometryTwo = new QRadioButton(tr("Lines"), viewGeometry);
    viewGeometryButtonGroup->addButton(viewGeometryTwo,1);
    viewGeometryLayout->addWidget(viewGeometryTwo);

    QRadioButton *viewGeometryThree = new QRadioButton(tr("Surfaces"), viewGeometry);
    viewGeometryButtonGroup->addButton(viewGeometryThree,2);
    viewGeometryLayout->addWidget(viewGeometryThree);

    connect(viewGeometryButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(viewGeometryChanged(int)));

   miscLayout->addWidget(viewGeometry,0,1);



}


// ****************************************************************************
// Method: QvisLineSamplerWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSamplerWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case LineSamplerAttributes::ID_meshGeometry:
            meshGeometryButtonGroup->blockSignals(true);
            if(meshGeometryButtonGroup->button((int)atts->GetMeshGeometry()) != 0)
                meshGeometryButtonGroup->button((int)atts->GetMeshGeometry())->setChecked(true);
            meshGeometryButtonGroup->blockSignals(false);

            UpdateMeshGeometry();
            break;
          case LineSamplerAttributes::ID_arrayConfiguration:
            arrayConfigurationButtonGroup->blockSignals(true);
            if(arrayConfigurationButtonGroup->button((int)atts->GetArrayConfiguration()) != 0)
                arrayConfigurationButtonGroup->button((int)atts->GetArrayConfiguration())->setChecked(true);
            arrayConfigurationButtonGroup->blockSignals(false);

            EnableGeometry((int)atts->GetArrayConfiguration()==0);
            EnableList((int)atts->GetArrayConfiguration()==1);
            break;
          case LineSamplerAttributes::ID_boundary:
            boundaryButtonGroup->blockSignals(true);
            if(boundaryButtonGroup->button((int)atts->GetBoundary()) != 0)
                boundaryButtonGroup->button((int)atts->GetBoundary())->setChecked(true);
            boundaryButtonGroup->blockSignals(false);

            wallReadFile->setEnabled((int)atts->GetBoundary()==1);
            wallList->setEnabled((int)atts->GetBoundary()==1);

            break;

        case LineSamplerAttributes::ID_instanceId:
            instanceId->blockSignals(true);
            instanceId->setCurrentIndex(atts->GetInstanceId());
            instanceId->blockSignals(false);
            break;

          case LineSamplerAttributes::ID_nArrays:
            nArrays->setText(IntToQString(atts->GetNArrays()));
            break;
          case LineSamplerAttributes::ID_toroidalArrayAngle:
            toroidalArrayAngle->setText(DoubleToQString(atts->GetToroidalArrayAngle()));
            break;
          case LineSamplerAttributes::ID_nChannels:
            nDChannels->setText(IntToQString(atts->GetNChannels()));
            nPChannels->setText(IntToQString(atts->GetNChannels()));
            nGChannels->setText(IntToQString(atts->GetNChannels()));
            break;
          case LineSamplerAttributes::ID_channelProjection:

            projectionTabs->blockSignals(true);
            projectionTabs->setCurrentIndex((int)atts->GetChannelProjection());
            projectionTabs->blockSignals(false);

//             channelProjectionButtonGroup->blockSignals(true);

//             if(channelProjectionButtonGroup->button((int)atts->GetChannelProjection()) != 0)
//                 channelProjectionButtonGroup->button((int)atts->GetChannelProjection())->setChecked(true);
//             channelProjectionButtonGroup->blockSignals(false);

//          channelAngleLabel->setEnabled((int)atts->GetChannelProjection()==0);
//          channelAngle->setEnabled((int)atts->GetChannelProjection()==0);

//          channelParallelOffsetLabel->setEnabled((int)atts->GetChannelProjection()==1||(int)atts->GetChannelProjection()==2);
//          channelParallelOffset->setEnabled((int)atts->GetChannelProjection()==1||(int)atts->GetChannelProjection()==2);


//          channelGridOffsetLabel->setEnabled((int)atts->GetChannelProjection()==1||(int)atts->GetChannelProjection()==2);
//          channelGridOffset->setEnabled((int)atts->GetChannelProjection()==1||(int)atts->GetChannelProjection()==2);


//          nRowsLabel->setEnabled((int)atts->GetChannelProjection()==2);
//          nRows->setEnabled((int)atts->GetChannelProjection()==2);

//          rowOffsetLabel->setEnabled((int)atts->GetChannelProjection()==2);
//          rowOffset->setEnabled((int)atts->GetChannelProjection()==2);

            break;
          case LineSamplerAttributes::ID_channelOffset:
            channelParallelOffset->setText(DoubleToQString(atts->GetChannelOffset()));
            channelGridOffset->setText(DoubleToQString(atts->GetChannelOffset()));
            break;
          case LineSamplerAttributes::ID_channelAngle:
            channelAngle->setText(DoubleToQString(atts->GetChannelAngle()));
            break;
          case LineSamplerAttributes::ID_nRows:
            nRows->setText(IntToQString(atts->GetNRows()));
            break;
          case LineSamplerAttributes::ID_rowOffset:
            rowOffset->setText(DoubleToQString(atts->GetRowOffset()));
            break;
          case LineSamplerAttributes::ID_arrayOrigin:
            arrayOrigin->setText(DoublesToQString(atts->GetArrayOrigin(), 3));
            break;
          case LineSamplerAttributes::ID_arrayAxis:
            arrayAxisButtonGroup->blockSignals(true);
            if(arrayAxisButtonGroup->button((int)atts->GetArrayAxis()) != 0)
                arrayAxisButtonGroup->button((int)atts->GetArrayAxis())->setChecked(true);
            arrayAxisButtonGroup->blockSignals(false);

            
            cartesianXLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0 &&
                                                (int)atts->GetArrayAxis()==0);
            cartesianZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0 &&
                                                (int)atts->GetArrayAxis()==1);
            cartesianConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0);

            cylindricalRLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1 &&
                                                (int)atts->GetArrayAxis()==0);
            cylindricalZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1 &&
                                                (int)atts->GetArrayAxis()==1);
            cylindricalConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1);

            toroidalRLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2 &&
                                             (int)atts->GetArrayAxis()==0);
            toroidalZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2 &&
                                             (int)atts->GetArrayAxis()==1);
            toroidalConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2 );
            break;
          case LineSamplerAttributes::ID_poloialAngle:
            poloialAngle->setText(DoubleToQString(atts->GetPoloialAngle()));
            break;
          case LineSamplerAttributes::ID_poloialRTilt:
            poloialRTilt->setText(DoubleToQString(atts->GetPoloialRTilt()));
            break;
          case LineSamplerAttributes::ID_poloialZTilt:
            poloialZTilt->setText(DoubleToQString(atts->GetPoloialZTilt()));
            break;
          case LineSamplerAttributes::ID_toroidalAngle:
            toroidalAngle->setText(DoubleToQString(atts->GetToroidalAngle()));
            break;
          case LineSamplerAttributes::ID_flipToroidalAngle:
            flipToroidalAngle->blockSignals(true);
            flipToroidalAngle->setChecked(atts->GetFlipToroidalAngle());
            flipToroidalAngle->blockSignals(false);

            channelListFlipToroidalAngle->blockSignals(true);
            channelListFlipToroidalAngle->setChecked(atts->GetFlipToroidalAngle());
            channelListFlipToroidalAngle->blockSignals(false);
            break;
          case LineSamplerAttributes::ID_viewGeometry:
            viewGeometryButtonGroup->blockSignals(true);
            if(viewGeometryButtonGroup->button((int)atts->GetViewGeometry()) != 0)
                viewGeometryButtonGroup->button((int)atts->GetViewGeometry())->setChecked(true);
            viewGeometryButtonGroup->blockSignals(false);
            break;
          case LineSamplerAttributes::ID_displayTime:
            displayTimeButtonGroup->blockSignals(true);
            if(displayTimeButtonGroup->button((int)atts->GetDisplayTime()) != 0)
                displayTimeButtonGroup->button((int)atts->GetDisplayTime())->setChecked(true);
            displayTimeButtonGroup->blockSignals(false);
            break;
          case LineSamplerAttributes::ID_viewDimension:
            viewDimensionButtonGroup->blockSignals(true);
            if(viewDimensionButtonGroup->button((int)atts->GetViewDimension()) != 0)
                viewDimensionButtonGroup->button((int)atts->GetViewDimension())->setChecked(true);
            viewDimensionButtonGroup->blockSignals(false);

            oneDPlotGroup->setEnabled( (int)atts->GetViewDimension() == 0 );

            if( atts->GetViewDimension() == 0 )
            {
              displayTimeLabel->
                setEnabled( (int)atts->GetTimeSampling() == 1 &&
                            (int)atts->GetToroidalIntegration() != 1);
              
              displayTime->setEnabled( (int)atts->GetTimeSampling() == 1 &&
                                       (int)atts->GetToroidalIntegration() != 1 );
            }

            break;
          case LineSamplerAttributes::ID_donotApplyToAll:
            donotApplyToAll->blockSignals(true);
            donotApplyToAll->setChecked(atts->GetDonotApplyToAll());
            donotApplyToAll->blockSignals(false);

            break;
          case LineSamplerAttributes::ID_heightPlotScale:
            heightPlotScale->setText(DoubleToQString(atts->GetHeightPlotScale()));
            break;
          case LineSamplerAttributes::ID_channelPlotOffset:
            channelPlotOffset->setText(DoubleToQString(atts->GetChannelPlotOffset()));
            break;
          case LineSamplerAttributes::ID_arrayPlotOffset:
            arrayPlotOffset->setText(DoubleToQString(atts->GetArrayPlotOffset()));
            break;
          case LineSamplerAttributes::ID_channelGeometry:
            channelGeometryButtonGroup->blockSignals(true);
            if(channelGeometryButtonGroup->button((int)atts->GetChannelGeometry()) != 0)
                channelGeometryButtonGroup->button((int)atts->GetChannelGeometry())->setChecked(true);
            channelGeometryButtonGroup->blockSignals(false);

            radiusLabel->setEnabled(atts->GetChannelGeometry()==2);
            radius->setEnabled(atts->GetChannelGeometry()==2);
            channelProfileLabel->setEnabled(atts->GetChannelGeometry()==2);
            channelProfileChannelTypeTopHat->setEnabled(atts->GetChannelGeometry()==2);
            channelProfileChannelTypeGaussian->setEnabled(atts->GetChannelGeometry()==2);
            standardDeviationLabel->setEnabled(atts->GetChannelGeometry()==2&&atts->GetChannelProfile()==1);
            standardDeviation->setEnabled(atts->GetChannelGeometry()==2&&atts->GetChannelProfile()==1);

            break;
          case LineSamplerAttributes::ID_radius:
            radius->setText(DoubleToQString(atts->GetRadius()));
            break;
//           case LineSamplerAttributes::ID_divergence:
//             divergence->setText(DoubleToQString(atts->GetDivergence()));
//             break;
          case LineSamplerAttributes::ID_channelProfile:
            channelProfileButtonGroup->blockSignals(true);
            if(channelProfileButtonGroup->button((int)atts->GetChannelProfile()) != 0)
                channelProfileButtonGroup->button((int)atts->GetChannelProfile())->setChecked(true);
            channelProfileButtonGroup->blockSignals(false);

            standardDeviationLabel->setEnabled(atts->GetChannelGeometry()==2 &&
                                               atts->GetChannelProfile()==1);
            standardDeviation->setEnabled(atts->GetChannelGeometry()==2 &&
                                          atts->GetChannelProfile()==1);
            break;
          case LineSamplerAttributes::ID_standardDeviation:
            standardDeviation->setText(DoubleToQString(atts->GetStandardDeviation()));
            break;
          case LineSamplerAttributes::ID_sampleDistance:
            sampleDistance->setText(DoubleToQString(atts->GetSampleDistance()));
            break;
          case LineSamplerAttributes::ID_sampleVolume:
            sampleVolume->setText(DoubleToQString(atts->GetSampleVolume()));
            break;
//           case LineSamplerAttributes::ID_sampleArc:
//             sampleArc->setText(DoubleToQString(atts->GetSampleArc()));
//             break;
          case LineSamplerAttributes::ID_channelIntegration:
            channelIntegrationButtonGroup->blockSignals(true);
            if(channelIntegrationButtonGroup->button((int)atts->GetChannelIntegration()) != 0)
                channelIntegrationButtonGroup->button((int)atts->GetChannelIntegration())->setChecked(true);
            channelIntegrationButtonGroup->blockSignals(false);
            break;
          case LineSamplerAttributes::ID_toroidalIntegration:
            toroidalIntegrationButtonGroup->blockSignals(true);
            if(toroidalIntegrationButtonGroup->button((int)atts->GetToroidalIntegration()) != 0)
                toroidalIntegrationButtonGroup->button((int)atts->GetToroidalIntegration())->setChecked(true);
            toroidalIntegrationButtonGroup->blockSignals(false);
            toroidalGroup->setEnabled( (int)atts->GetToroidalIntegration() == 1 ||
                                       (int)atts->GetToroidalIntegration() == 2 );

            displayTimeLabel->
              setEnabled( (int)atts->GetTimeSampling() == 1 &&
                          (int)atts->GetToroidalIntegration() != 1);

            displayTime->setEnabled( (int)atts->GetTimeSampling() == 1 &&
                                     (int)atts->GetToroidalIntegration() != 1);
            break;
          case LineSamplerAttributes::ID_toroidalAngleSampling:
            toroidalAngleSamplingButtonGroup->blockSignals(true);
            if(toroidalAngleSamplingButtonGroup->button((int)atts->GetToroidalAngleSampling()) != 0)
                toroidalAngleSamplingButtonGroup->button((int)atts->GetToroidalAngleSampling())->setChecked(true);
            toroidalAngleSamplingButtonGroup->blockSignals(false);
            break;
          case LineSamplerAttributes::ID_toroidalAngleStart:
            toroidalAngleStart->setText(DoubleToQString(atts->GetToroidalAngleStart()));
            break;
          case LineSamplerAttributes::ID_toroidalAngleStop:
            toroidalAngleStop->setText(DoubleToQString(atts->GetToroidalAngleStop()));
            break;
          case LineSamplerAttributes::ID_toroidalAngleStride:
            toroidalAngleStride->setText(DoubleToQString(atts->GetToroidalAngleStride()));
            break;
          case LineSamplerAttributes::ID_timeSampling:
            timeSamplingButtonGroup->blockSignals(true);
            if(timeSamplingButtonGroup->button((int)atts->GetTimeSampling()) != 0)
                timeSamplingButtonGroup->button((int)atts->GetTimeSampling())->setChecked(true);
            timeSamplingButtonGroup->blockSignals(false);
            
            displayTimeLabel->
              setEnabled( (int)atts->GetTimeSampling() == 1 &&
                          (int)atts->GetToroidalIntegration() != 1);

            displayTime->setEnabled( (int)atts->GetTimeSampling() == 1 &&
                                     (int)atts->GetToroidalIntegration() != 1);

            timeStepLabel->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStartLabel->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStart->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStopLabel->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStop->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStrideLabel->setEnabled((int)atts->GetTimeSampling()==1);
            timeStepStride->setEnabled((int)atts->GetTimeSampling()==1);
            break;
          case LineSamplerAttributes::ID_timeStepStart:
            timeStepStart->setText(IntToQString(atts->GetTimeStepStart()));
            break;
          case LineSamplerAttributes::ID_timeStepStop:
            timeStepStop->setText(IntToQString(atts->GetTimeStepStop()));
            break;
          case LineSamplerAttributes::ID_timeStepStride:
            timeStepStride->setText(IntToQString(atts->GetTimeStepStride()));
            break;
          case LineSamplerAttributes::ID_wallList:
            {
              std::vector<double> pts = atts->GetWallList();
              wallList->clear();

              for (size_t i = 0; i < pts.size(); i+= 2)
              {
                char tmp[256];
                sprintf(tmp, "%lf %lf", pts[i], pts[i+1]);
                QString str( tmp );
                QListWidgetItem *item = new QListWidgetItem(str, wallList);
                item->setFlags(item->flags() | Qt::ItemIsEditable);
                wallList->setCurrentItem(item);
              }
              
              break;
            }
          case LineSamplerAttributes::ID_channelList:
            {
              std::vector<double> channels = atts->GetChannelList();
              channelList->clear();

              for (size_t i = 0; i < channels.size(); i+= 4)
              {
                char tmp[256];
                sprintf(tmp, "%lf %lf %lf %lf",
                        channels[i], channels[i+1], channels[i+2], channels[i+3]);
                QString str( tmp );
                QListWidgetItem *item = new QListWidgetItem(str, channelList);
                item->setFlags(item->flags() | Qt::ItemIsEditable);
                channelList->setCurrentItem(item);
              }
              
              break;
            }
          case LineSamplerAttributes::ID_nChannelListArrays:
            nChannelListArrays->setText(IntToQString(atts->GetNChannelListArrays()));
            break;
          case LineSamplerAttributes::ID_channelListToroidalArrayAngle:
            channelListToroidalArrayAngle->setText(DoubleToQString(atts->GetChannelListToroidalArrayAngle()));
            break;
          case LineSamplerAttributes::ID_channelListToroidalAngle:
            channelListToroidalAngle->setText(DoubleToQString(atts->GetChannelListToroidalAngle()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisLineSamplerWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisLineSamplerWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do nArrays
    if(which_widget == LineSamplerAttributes::ID_nArrays || doAll)
    {
        int val;
        if(LineEditGetInt(nArrays, val))
            atts->SetNArrays(val);
        else
        {
            ResettingError(tr("Number of arrays"),
                IntToQString(atts->GetNArrays()));
            atts->SetNArrays(atts->GetNArrays());
        }
    }

    // Do nChannels
    if(which_widget == LineSamplerAttributes::ID_nChannels || doAll)
    {
        int val;
        if( (atts->GetChannelProjection() == 0 &&
             LineEditGetInt(nDChannels, val)) ||

            (atts->GetChannelProjection() == 1 &&
             LineEditGetInt(nPChannels, val)) ||
            
            (atts->GetChannelProjection() == 2 &&
             LineEditGetInt(nGChannels, val))  )

            atts->SetNChannels(val);
        else
        {
            ResettingError(tr("Number of channels"),
                IntToQString(atts->GetNChannels()));
            atts->SetNChannels(atts->GetNChannels());
        }
    }

    // Do toroidalArrayAngle
    if(which_widget == LineSamplerAttributes::ID_toroidalArrayAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(toroidalArrayAngle, val))
            atts->SetToroidalArrayAngle(val);
        else
        {
            ResettingError(tr("Toroidal angle between arrays"),
                DoubleToQString(atts->GetToroidalArrayAngle()));
            atts->SetToroidalArrayAngle(atts->GetToroidalArrayAngle());
        }
    }

    // Do channelOffset
    if(which_widget == LineSamplerAttributes::ID_channelOffset || doAll)
    {
        double val;
        if( (atts->GetChannelProjection() == 1 &&
             LineEditGetDouble(channelParallelOffset, val)) ||
            (atts->GetChannelProjection() == 2 &&
             LineEditGetDouble(channelGridOffset, val)) )
          atts->SetChannelOffset(val);

        else if( atts->GetChannelProjection() == 1 ||
                 atts->GetChannelProjection() == 2 )
        {
            ResettingError(tr("Parallel/Grid: Offset between channels"),
                DoubleToQString(atts->GetChannelOffset()));
            atts->SetChannelOffset(atts->GetChannelOffset());
        }
    }

    // Do channelAngle
    if(which_widget == LineSamplerAttributes::ID_channelAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(channelAngle, val))
            atts->SetChannelAngle(val);
        else
        {
            ResettingError(tr("Divergent: Angle between channels"),
                DoubleToQString(atts->GetChannelAngle()));
            atts->SetChannelAngle(atts->GetChannelAngle());
        }
    }

    // Do nRows
    if(which_widget == LineSamplerAttributes::ID_nRows || doAll)
    {
        int val;
        if(LineEditGetInt(nRows, val))
            atts->SetNRows(val);
        else
        {
            ResettingError(tr("Grid: Number of rows"),
                IntToQString(atts->GetNRows()));
            atts->SetNRows(atts->GetNRows());
        }
    }

    // Do rowOffset
    if(which_widget == LineSamplerAttributes::ID_rowOffset || doAll)
    {
        double val;
        if(LineEditGetDouble(rowOffset, val))
            atts->SetRowOffset(val);
        else
        {
            ResettingError(tr("Grid: Offset between rows"),
                DoubleToQString(atts->GetRowOffset()));
            atts->SetRowOffset(atts->GetRowOffset());
        }
    }

    // Do arrayOrigin
    if(which_widget == LineSamplerAttributes::ID_arrayOrigin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(arrayOrigin, val, 3))
            atts->SetArrayOrigin(val);
        else
        {
            ResettingError(tr("Array origin"),
                DoublesToQString(atts->GetArrayOrigin(),3));
            atts->SetArrayOrigin(atts->GetArrayOrigin());
        }
    }

    // Do poloialAngle
    if(which_widget == LineSamplerAttributes::ID_poloialAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(poloialAngle, val))
            atts->SetPoloialAngle(val);
        else
        {
            ResettingError(tr("Poloidal angle"),
                DoubleToQString(atts->GetPoloialAngle()));
            atts->SetPoloialAngle(atts->GetPoloialAngle());
        }
    }

    // Do poloialRTilt
    if(which_widget == LineSamplerAttributes::ID_poloialRTilt || doAll)
    {
        double val;
        if(LineEditGetDouble(poloialRTilt, val))
            atts->SetPoloialRTilt(val);
        else
        {
            ResettingError(tr("Poloidal plane R-tilt"),
                DoubleToQString(atts->GetPoloialRTilt()));
            atts->SetPoloialRTilt(atts->GetPoloialRTilt());
        }
    }

    // Do poloialZTilt
    if(which_widget == LineSamplerAttributes::ID_poloialZTilt || doAll)
    {
        double val;
        if(LineEditGetDouble(poloialZTilt, val))
            atts->SetPoloialZTilt(val);
        else
        {
            ResettingError(tr("Poloidal plane Z-tilt"),
                DoubleToQString(atts->GetPoloialZTilt()));
            atts->SetPoloialZTilt(atts->GetPoloialZTilt());
        }
    }

    // Do toroidalAngle
    if(which_widget == LineSamplerAttributes::ID_toroidalAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(toroidalAngle, val))
            atts->SetToroidalAngle(val);
        else
        {
            ResettingError(tr("Toroidal angle"),
                DoubleToQString(atts->GetToroidalAngle()));
            atts->SetToroidalAngle(atts->GetToroidalAngle());
        }
    }

    // Do heightPlotScale
    if(which_widget == LineSamplerAttributes::ID_heightPlotScale || doAll)
    {
        double val;
        if(LineEditGetDouble(heightPlotScale, val))
            atts->SetHeightPlotScale(val);
        else
        {
            ResettingError(tr("1D plot height scale"),
                DoubleToQString(atts->GetHeightPlotScale()));
            atts->SetHeightPlotScale(atts->GetHeightPlotScale());
        }
    }

    // Do channelPlotOffset
    if(which_widget == LineSamplerAttributes::ID_channelPlotOffset || doAll)
    {
        double val;
        if(LineEditGetDouble(channelPlotOffset, val))
            atts->SetChannelPlotOffset(val);
        else
        {
            ResettingError(tr("1D plot channel offset"),
                DoubleToQString(atts->GetChannelPlotOffset()));
            atts->SetChannelPlotOffset(atts->GetChannelPlotOffset());
        }
    }

    // Do arrayPlotOffset
    if(which_widget == LineSamplerAttributes::ID_arrayPlotOffset || doAll)
    {
        double val;
        if(LineEditGetDouble(arrayPlotOffset, val))
            atts->SetArrayPlotOffset(val);
        else
        {
            ResettingError(tr("1D plot array offset"),
                DoubleToQString(atts->GetArrayPlotOffset()));
            atts->SetArrayPlotOffset(atts->GetArrayPlotOffset());
        }
    }


    // Do radius
    if(which_widget == LineSamplerAttributes::ID_radius || doAll)
    {
        double val;
        if(LineEditGetDouble(radius, val))
            atts->SetRadius(val);
        else
        {
            ResettingError(tr("Cylinder radius"),
                DoubleToQString(atts->GetRadius()));
            atts->SetRadius(atts->GetRadius());
        }
    }

    // Do divergence
//     if(which_widget == LineSamplerAttributes::ID_divergence || doAll)
//     {
//         double val;
//         if(LineEditGetDouble(divergence, val))
//             atts->SetDivergence(val);
//         else
//         {
//             ResettingError(tr("Cone divergence"),
//                 DoubleToQString(atts->GetDivergence()));
//             atts->SetDivergence(atts->GetDivergence());
//         }
//     }

    // Do standardDeviation
    if(which_widget == LineSamplerAttributes::ID_standardDeviation || doAll)
    {
        double val;
        if(LineEditGetDouble(standardDeviation, val))
            atts->SetStandardDeviation(val);
        else
        {
            ResettingError(tr("Standard deviation"),
                DoubleToQString(atts->GetStandardDeviation()));
            atts->SetStandardDeviation(atts->GetStandardDeviation());
        }
    }

    // Do sampleDistance
    if(which_widget == LineSamplerAttributes::ID_sampleDistance || doAll)
    {
        double val;
        if(LineEditGetDouble(sampleDistance, val))
            atts->SetSampleDistance(val);
        else
        {
            ResettingError(tr("Linear sample distance"),
                DoubleToQString(atts->GetSampleDistance()));
            atts->SetSampleDistance(atts->GetSampleDistance());
        }
    }

    // Do sampleVolume
    if(which_widget == LineSamplerAttributes::ID_sampleVolume || doAll)
    {
        double val;
        if(LineEditGetDouble(sampleVolume, val))
            atts->SetSampleVolume(val);
        else
        {
            ResettingError(tr("Sample volume"),
                DoubleToQString(atts->GetSampleVolume()));
            atts->SetSampleVolume(atts->GetSampleVolume());
        }
    }

    // Do sampleArc
//     if(which_widget == LineSamplerAttributes::ID_sampleArc || doAll)
//     {
//         double val;
//         if(LineEditGetDouble(sampleArc, val))
//             atts->SetSampleArc(val);
//         else
//         {
//             ResettingError(tr("Radial sample arc"),
//                 DoubleToQString(atts->GetSampleArc()));
//             atts->SetSampleArc(atts->GetSampleArc());
//         }
//     }

    // Do toroidalAngleStart
    if(which_widget == LineSamplerAttributes::ID_toroidalAngleStart || doAll)
    {
        double val;
        if(LineEditGetDouble(toroidalAngleStart, val))
            atts->SetToroidalAngleStart(val);
        else
        {
            ResettingError(tr("Toroidal start angle"),
                DoubleToQString(atts->GetToroidalAngleStart()));
            atts->SetToroidalAngleStart(atts->GetToroidalAngleStart());
        }
    }

    // Do toroidalAngleStop
    if(which_widget == LineSamplerAttributes::ID_toroidalAngleStop || doAll)
    {
        double val;
        if(LineEditGetDouble(toroidalAngleStop, val))
            atts->SetToroidalAngleStop(val);
        else
        {
            ResettingError(tr("Toroidal stop angle"),
                DoubleToQString(atts->GetToroidalAngleStop()));
            atts->SetToroidalAngleStop(atts->GetToroidalAngleStop());
        }
    }

    // Do toroidalAngleStride
    if(which_widget == LineSamplerAttributes::ID_toroidalAngleStride || doAll)
    {
        double val;
        if(LineEditGetDouble(toroidalAngleStride, val))
            atts->SetToroidalAngleStride(val);
        else
        {
            ResettingError(tr("Toroidal sampling angle"),
                DoubleToQString(atts->GetToroidalAngleStride()));
            atts->SetToroidalAngleStride(atts->GetToroidalAngleStride());
        }
    }

    // Do timeStepStart
    if(which_widget == LineSamplerAttributes::ID_timeStepStart || doAll)
    {
        int val;
        if(LineEditGetInt(timeStepStart, val))
            atts->SetTimeStepStart(val);
        else
        {
            ResettingError(tr("Start time step"),
                IntToQString(atts->GetTimeStepStart()));
            atts->SetTimeStepStart(atts->GetTimeStepStart());
        }
    }

    // Do timeStepStop
    if(which_widget == LineSamplerAttributes::ID_timeStepStop || doAll)
    {
        int val;
        if(LineEditGetInt(timeStepStop, val))
            atts->SetTimeStepStop(val);
        else
        {
            ResettingError(tr("Stop time step"),
                IntToQString(atts->GetTimeStepStop()));
            atts->SetTimeStepStop(atts->GetTimeStepStop());
        }
    }

    // Do timeStepStride
    if(which_widget == LineSamplerAttributes::ID_timeStepStride || doAll)
    {
        int val;
        if(LineEditGetInt(timeStepStride, val))
            atts->SetTimeStepStride(val);
        else
        {
            ResettingError(tr("Stride"),
                IntToQString(atts->GetTimeStepStride()));
            atts->SetTimeStepStride(atts->GetTimeStepStride());
        }
    }

    // Do wallList
    if(which_widget == LineSamplerAttributes::ID_wallList || doAll)
    {
        std::vector<double> walls;
        double r = 0.0;
        double z = 0.0;
        for (int i = 0; i < wallList->count(); i++)
        {
            QListWidgetItem *item = wallList->item(i);
            if (item)
            {
                std::string str = item->text().toLatin1().data();
                sscanf(str.c_str(), "%lf %lf", &r, &z);
                walls.push_back(r);
                walls.push_back(z);
            }
        }
        atts->SetWallList(walls);
    }

    // Do channelList
    if(which_widget == LineSamplerAttributes::ID_channelList || doAll)
    {
        std::vector<double> channels;
        double r, z, phi, ang;
        for (int i = 0; i < channelList->count(); i++)
        {
            QListWidgetItem *item = channelList->item(i);
            if (item)
            {
                std::string str = item->text().toLatin1().data();
                sscanf(str.c_str(), "%lf %lf  %lf %lf", &r, &z, &phi, &ang);
                channels.push_back(r);
                channels.push_back(z);
                channels.push_back(phi);
                channels.push_back(ang);
            }
        }
        atts->SetChannelList(channels);
    }

    // Do channelListToroidalAngle
    if(which_widget == LineSamplerAttributes::ID_channelListToroidalAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(channelListToroidalAngle, val))
            atts->SetChannelListToroidalAngle(val);
        else
        {
            ResettingError(tr("Toroidal angle"),
                DoubleToQString(atts->GetChannelListToroidalAngle()));
            atts->SetChannelListToroidalAngle(atts->GetChannelListToroidalAngle());
        }
    }

    // Do nChannelListArrays
    if(which_widget == LineSamplerAttributes::ID_nChannelListArrays || doAll)
    {
        int val;
        if(LineEditGetInt(nChannelListArrays, val))
            atts->SetNChannelListArrays(val);
        else
        {
            ResettingError(tr("Number of channel list arrays"),
                IntToQString(atts->GetNChannelListArrays()));
            atts->SetNChannelListArrays(atts->GetNChannelListArrays());
        }
    }

    // Do channelListToroidalArrayAngle
    if(which_widget == LineSamplerAttributes::ID_channelListToroidalArrayAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(channelListToroidalArrayAngle, val))
            atts->SetChannelListToroidalArrayAngle(val);
        else
        {
            ResettingError(tr("Toroidal angle"),
                DoubleToQString(atts->GetChannelListToroidalArrayAngle()));
            atts->SetChannelListToroidalArrayAngle(atts->GetChannelListToroidalArrayAngle());
        }
    }
}


//
// Qt Slot functions
//


void
QvisLineSamplerWindow::meshGeometryChanged(int val)
{
    if(val != atts->GetMeshGeometry())
    {
        atts->SetMeshGeometry(LineSamplerAttributes::MeshGeometry(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::arrayConfigurationChanged(int val)
{
    if(val != atts->GetArrayConfiguration())
    {
        atts->SetArrayConfiguration(LineSamplerAttributes::ArrayConfiguration(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::boundaryChanged(int val)
{
    if(val != atts->GetBoundary())
    {
        atts->SetBoundary(LineSamplerAttributes::Boundary(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::instanceIdChanged(int val)
 {
    if(val != atts->GetInstanceId())
    {
        atts->SetInstanceId(val);
        Apply();
    }
}   


void
QvisLineSamplerWindow::nArraysProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_nArrays);
    Apply();
}


void
QvisLineSamplerWindow::nChannelsProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_nChannels);
    Apply();
}


void
QvisLineSamplerWindow::toroidalArrayAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_toroidalArrayAngle);
    Apply();
}


void
QvisLineSamplerWindow::nChannelListArraysProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_nChannelListArrays);
    Apply();
}


void
QvisLineSamplerWindow::channelListToroidalArrayAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_channelListToroidalArrayAngle);
    Apply();
}


void
QvisLineSamplerWindow::channelListToroidalAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_channelListToroidalAngle);
    Apply();
}


void
QvisLineSamplerWindow::channelProjectionChanged(int val)
{
    if(val != atts->GetChannelProjection())
    {
        atts->SetChannelProjection(LineSamplerAttributes::ChannelProjection(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::channelOffsetProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_channelOffset);
    Apply();
}


void
QvisLineSamplerWindow::channelAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_channelAngle);
    Apply();
}


void
QvisLineSamplerWindow::nRowsProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_nRows);
    Apply();
}


void
QvisLineSamplerWindow::rowOffsetProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_rowOffset);
    Apply();
}


void
QvisLineSamplerWindow::arrayOriginProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_arrayOrigin);
    Apply();
}


void
QvisLineSamplerWindow::arrayAxisChanged(int val)
{
    if(val != atts->GetArrayAxis())
    {
        atts->SetArrayAxis(LineSamplerAttributes::ArrayAxis(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::poloialAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_poloialAngle);
    Apply();
}


void
QvisLineSamplerWindow::poloialRTiltProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_poloialRTilt);
    Apply();
}


void
QvisLineSamplerWindow::poloialZTiltProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_poloialZTilt);
    Apply();
}


void
QvisLineSamplerWindow::toroidalAngleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_toroidalAngle);
    Apply();
}


void
QvisLineSamplerWindow::flipToroidalAngleChanged(bool val)
{
    atts->SetFlipToroidalAngle(val);
    Apply();
}


void
QvisLineSamplerWindow::channelListFlipToroidalAngleChanged(bool val)
{
    atts->SetFlipToroidalAngle(val);
    Apply();
}


void
QvisLineSamplerWindow::viewGeometryChanged(int val)
{
    if(val != atts->GetViewGeometry())
    {
        atts->SetViewGeometry(LineSamplerAttributes::ViewGeometry(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::displayTimeChanged(int val)
{
    if(val != atts->GetDisplayTime())
    {
        atts->SetDisplayTime(LineSamplerAttributes::DisplayTime(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::viewDimensionChanged(int val)
{
    if(val != atts->GetViewDimension())
    {
        atts->SetViewDimension(LineSamplerAttributes::ViewDimension(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::donotApplyToAllChanged(bool val)
{
    atts->SetDonotApplyToAll(val);
    Apply();
}


void
QvisLineSamplerWindow::heightPlotScaleProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_heightPlotScale);
    Apply();
}


void
QvisLineSamplerWindow::channelPlotOffsetProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_channelPlotOffset);
    Apply();
}


void
QvisLineSamplerWindow::arrayPlotOffsetProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_arrayPlotOffset);
    Apply();
}


void
QvisLineSamplerWindow::channelGeometryChanged(int val)
{
    if(val != atts->GetChannelGeometry())
    {
        atts->SetChannelGeometry(LineSamplerAttributes::ChannelGeometry(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::radiusProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_radius);
    Apply();
}


// void
// QvisLineSamplerWindow::divergenceProcessText()
// {
//     GetCurrentValues(LineSamplerAttributes::ID_divergence);
//     Apply();
// }


void
QvisLineSamplerWindow::channelProfileChanged(int val)
{
    if(val != atts->GetChannelProfile())
    {
        atts->SetChannelProfile(LineSamplerAttributes::ChannelProfile(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::standardDeviationProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_standardDeviation);
    Apply();
}


void
QvisLineSamplerWindow::sampleDistanceProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_sampleDistance);
    Apply();
}


void
QvisLineSamplerWindow::sampleVolumeProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_sampleVolume);
    Apply();
}


// void
// QvisLineSamplerWindow::sampleArcProcessText()
// {
//     GetCurrentValues(LineSamplerAttributes::ID_sampleArc);
//     Apply();
// }


void
QvisLineSamplerWindow::channelIntegrationChanged(int val)
{
    if(val != atts->GetChannelIntegration())
    {
        atts->SetChannelIntegration(LineSamplerAttributes::ChannelIntegration(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisLineSamplerWindow::toroidalIntegrationChanged(int val)
{
    if(val != atts->GetToroidalIntegration())
    {
        atts->SetToroidalIntegration(LineSamplerAttributes::ToroidalIntegration(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::toroidalAngleSamplingChanged(int val)
{
    if(val != atts->GetToroidalAngleSampling())
    {
        atts->SetToroidalAngleSampling(LineSamplerAttributes::ToroidalAngleSampling(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::toroidalAngleStartProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_toroidalAngleStart);
    Apply();
}


void
QvisLineSamplerWindow::toroidalAngleStopProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_toroidalAngleStop);
    Apply();
}


void
QvisLineSamplerWindow::toroidalAngleStrideProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_toroidalAngleStride);
    Apply();
}


void
QvisLineSamplerWindow::timeSamplingChanged(int val)
{
    if(val != atts->GetTimeSampling())
    {
        atts->SetTimeSampling(LineSamplerAttributes::TimeSampling(val));
        Apply();
    }
}


void
QvisLineSamplerWindow::timeStepStartProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_timeStepStart);
    Apply();
}


void
QvisLineSamplerWindow::timeStepStopProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_timeStepStop);
    Apply();
}


void
QvisLineSamplerWindow::timeStepStrideProcessText()
{
    GetCurrentValues(LineSamplerAttributes::ID_timeStepStride);
    Apply();
}


void
QvisLineSamplerWindow::channelListClicked(QListWidgetItem *item)
{
}


void
QvisLineSamplerWindow::channelListDoubleClicked(QListWidgetItem *item)
{
    item->setFlags(item->flags() | Qt::ItemIsEditable);
}


void
QvisLineSamplerWindow::channelListTextChanged(const QString &currentText)
{
}


void
QvisLineSamplerWindow::wallListTextChanged(const QString &currentText)
{
}


void
QvisLineSamplerWindow::addChannel()
{
    QListWidgetItem *item = new QListWidgetItem("0 0 0 90", channelList);
    item->setFlags(item->flags() | Qt::ItemIsEditable);
    channelList->setCurrentItem(item);
}


void
QvisLineSamplerWindow::deleteChannel()
{
    if (!channelList->selectedItems().empty())
    {
        qDeleteAll(channelList->selectedItems());
    }
}


void
QvisLineSamplerWindow::deleteChannels()
{
    channelList->clear();
}

std::string findstr( std::ifstream &f, std::string key )
{
  while (f.good())
  {
    char tmp[1024];

    f.getline(tmp, 1024);
    
    std::string tmpstr = std::string(tmp);

    if( tmpstr.find(key) != std::string::npos )
    {
      return tmpstr;
    }
  }

  return std::string("");
}

void
QvisLineSamplerWindow::readChannels()
{
    QString res =
      QFileDialog::getOpenFileName(NULL, tr("Open channel configuration file"), ".");
    std::string filename = res.toLatin1().data();

    if (filename == "")
        return;

    std::ifstream f;
    f.open(filename.c_str());

    std::string diagnostic;

    while (f.good())
    {
        char tmp[1024];
        f.getline(tmp, 1024);

        std::string tmpstr(tmp);

        if( tmpstr.find("[diiidSoftXray]") != std::string::npos )
        {
          diagnostic = tmpstr;
          break;
        }
        else if( tmpstr.find("[diiidBES]") != std::string::npos )
        {
          diagnostic = tmpstr;
          break;
        }
    }

    if( diagnostic == "[diiidSoftXray]" )
    {
      int nChannels = 0;

      std::string tmpStr = findstr( f, "nChannels=" );

      if( tmpStr.empty() )
      {
        return;
      }

      tmpStr.erase( 0, tmpStr.find("=")+1 );
          
      nChannels = atoi( tmpStr.c_str() );

      std::string Rsxr, Zsxr, PhiSxr, AngSxr;
      std::string rTmp, zTmp, phiTmp, angTmp;

      Rsxr = findstr( f, std::string("Rsxr=") );
      Zsxr = findstr( f, std::string("Zsxr=") );
      PhiSxr = findstr( f, std::string("PhiSxr=") );
      AngSxr = findstr( f, std::string("AngSxr=") );

      if( Rsxr.empty() || Zsxr.empty() || PhiSxr.empty() || AngSxr.empty() )
      {
        return;
      }

      Rsxr.erase( 0, Rsxr.find("=")+1 );
      Zsxr.erase( 0, Zsxr.find("=")+1 );
      PhiSxr.erase( 0, PhiSxr.find("=")+1 );
      AngSxr.erase( 0, AngSxr.find("=")+1 );

      channelList->clear();

      for( int i=0; i<nChannels; ++i )
      {
        rTmp = Rsxr;
        zTmp = Zsxr;
        phiTmp = PhiSxr;
        angTmp = AngSxr;

        if( i<nChannels-1 )
        {
          size_t rP = rTmp.find(",");
          size_t zP = zTmp.find(",");
          size_t phiP = phiTmp.find(",");
          size_t angP = angTmp.find(",");

          rTmp.erase( rP, rTmp.size() );
          zTmp.erase( zP, zTmp.size() );
          phiTmp.erase( phiP, phiTmp.size() );
          angTmp.erase( angP, angTmp.size() );

          Rsxr.erase( 0, rP+1 );
          Zsxr.erase( 0, zP+1 );
          PhiSxr.erase( 0, phiP+1 );
          AngSxr.erase( 0, angP+1 );
        }

        float r = atof( rTmp.c_str() );
        float z = atof( zTmp.c_str() );
        float phi = atof( phiTmp.c_str() );
        float ang = atof( angTmp.c_str() );

        char vals[256];
        sprintf(vals, "%f %f %f %f", r, z, phi, ang);
        QListWidgetItem *item = new QListWidgetItem(vals, channelList);
        item->setFlags(item->flags() | Qt::ItemIsEditable);
        channelList->setCurrentItem(item);
      }
    }

    f.close();
}

void
QvisLineSamplerWindow::readWall()
{
    QString res =
      QFileDialog::getOpenFileName(NULL, tr("Open wall configuration file"), ".");
    std::string filename = res.toLatin1().data();

    if (filename == "")
        return;

    std::ifstream f;
    f.open(filename.c_str());

    std::string diagnostic;

    while (f.good())
    {
        char tmp[1024];
        f.getline(tmp, 1024);

        std::string tmpstr(tmp);

        if( tmpstr.find("[diiidSimpleWall]") != std::string::npos )
        {
          diagnostic = tmpstr;
          break;
        }
    }

    if( diagnostic == "[diiidSimpleWall]" )
    {
      std::string tmpStr = findstr( f, "machine=" );

      if( tmpStr.empty() )
      {
        return;
      }

      int nWall = 0;

      tmpStr = findstr( f, "nWall=" );

      if( tmpStr.empty() )
      {
        return;
      }

      tmpStr.erase( 0, tmpStr.find("=")+1 );
          
      nWall = atoi( tmpStr.c_str() );

      std::string Rwall, Zwall;
      std::string rTmp, zTmp;

      Rwall = findstr( f, std::string("Rwall=") );
      Zwall = findstr( f, std::string("Zwall=") );

      if( Rwall.empty() || Zwall.empty() )
      {
        return;
      }

      Rwall.erase( 0, Rwall.find("=")+1 );
      Zwall.erase( 0, Zwall.find("=")+1 );

      wallList->clear();

      for( int i=0; i<nWall; ++i )
      {
        rTmp = Rwall;
        zTmp = Zwall;

        if( i<nWall-1 )
        {
          size_t rP = rTmp.find(",");
          size_t zP = zTmp.find(",");

          rTmp.erase( rP, rTmp.size() );
          zTmp.erase( zP, zTmp.size() );

          Rwall.erase( 0, rP+1 );
          Zwall.erase( 0, zP+1 );
        }

        float r = atof( rTmp.c_str() );
        float z = atof( zTmp.c_str() );

        char vals[256];
        sprintf(vals, "%f %f", r, z);
        QListWidgetItem *item = new QListWidgetItem(vals, wallList);
        item->setFlags(item->flags() | Qt::ItemIsEditable);
        wallList->setCurrentItem(item);
      }
    }

    f.close();
}


void
QvisLineSamplerWindow::EnableGeometry(bool flag)
{
    nArraysLabel->setEnabled( flag );
    nArrays->setEnabled( flag );
    toroidalArrayAngleLabel->setEnabled( flag );
    toroidalArrayAngle->setEnabled( flag );
//    projectionTabs->setEnabled( flag );
    nDChannelsLabel->setEnabled( flag );
    nDChannels->setEnabled( flag );

    channelAngleLabel->setEnabled( flag );
    channelAngle->setEnabled( flag );

    nPChannelsLabel->setEnabled( flag );
    nPChannels->setEnabled( flag );
    channelParallelOffsetLabel->setEnabled( flag );
    channelParallelOffset->setEnabled( flag );

    nGChannelsLabel->setEnabled( flag );
    nGChannels->setEnabled( flag );
    channelGridOffsetLabel->setEnabled( flag );
    channelGridOffset->setEnabled( flag );

    nRowsLabel->setEnabled( flag );
    nRows->setEnabled( flag );
    rowOffsetLabel->setEnabled( flag );
    rowOffset->setEnabled( flag );

    arrayOriginLabel->setEnabled( flag );
    arrayOrigin->setEnabled( flag );

    arrayAxisLabel->setEnabled( flag );
    arrayAxis->setEnabled( flag );
    arrayAxisArrayAxisR->setEnabled( flag );
    arrayAxisArrayAxisZ->setEnabled( flag );

    poloialAngleLabel->setEnabled( flag );
    poloialAngle->setEnabled( flag );
    poloialRTiltLabel->setEnabled( flag );
    poloialRTilt->setEnabled( flag );
    poloialZTiltLabel->setEnabled( flag );
    poloialZTilt->setEnabled( flag );

    toroidalAngleLabel->setEnabled( flag );
    toroidalAngle->setEnabled( flag );
    flipToroidalAngle->setEnabled( flag );
}


void
QvisLineSamplerWindow::EnableList(bool flag)
{
    nChannelListArraysLabel->setEnabled( flag );
    nChannelListArrays->setEnabled( flag );
    channelListToroidalArrayAngleLabel->setEnabled( flag );
    channelListToroidalArrayAngle->setEnabled( flag );
    confFileCoordinateLabel->setEnabled( flag );
    channelList->setEnabled( flag );
    channelListReadChannels->setEnabled( flag );
    channelListAddChannel->setEnabled( flag );
    channelListDeleteChannel->setEnabled( flag );
    channelListDeleteAllChannels->setEnabled( flag );
    channelListToroidalAngleLabel->setEnabled( flag );
    channelListToroidalAngle->setEnabled( flag );
    channelListFlipToroidalAngle->setEnabled( flag );
}


void
QvisLineSamplerWindow::UpdateMeshGeometry()
{

  cartesianXLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0 &&
                                      (int)atts->GetArrayAxis()==0);
  cartesianZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0 &&
                                      (int)atts->GetArrayAxis()==1);

  cartesianConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==0);

  cylindricalRLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1 &&
                                      (int)atts->GetArrayAxis()==0);
  cylindricalZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1 &&
                                      (int)atts->GetArrayAxis()==1);
  cylindricalConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==1);

  toroidalRLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2 &&
                                   (int)atts->GetArrayAxis()==0);
  toroidalZLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2 &&
                                   (int)atts->GetArrayAxis()==1);
  toroidalConfLayoutLabel->setVisible((int)atts->GetMeshGeometry()==2);

  if( atts->GetMeshGeometry() == LineSamplerAttributes::Cartesian )
  { 
    wallFileCoordinateLabel->setText(tr("Coordinate layout X, Z"));

    toroidalArrayAngleLabel->setText(tr("Y distance between arrays"));
    arrayOriginLabel->setText(tr("Array origin (X,Y,Z)"));
    arrayAxisArrayAxisR->setText(tr("X"));
    poloialAngleLabel->setText(tr("Y axis rotation"));
    poloialRTiltLabel->setText(tr("Y plane X-tilt"));
    poloialZTiltLabel->setText(tr("Y plane Z-tilt"));
    toroidalAngleLabel->setText(tr("Y axis offset"));
    flipToroidalAngle->setVisible(false);

    channelListToroidalArrayAngleLabel->setText(tr("Y distance between arrays"));
    confFileCoordinateLabel->setText(tr(" X, Y, Z, and Y Rotation"));
    channelListToroidalAngleLabel->setText(tr("Y axis offset"));
    channelListFlipToroidalAngle->setVisible(false);

    toroidalIntegrationLabel->setText(tr("Y axis"));
    toroidalIntegrationTime->setText(tr("Sample Y axis as time"));
    toroidalGroup->setTitle(tr("Y axis sampling"));
    toroidalAngleSampleLabel->setText(tr("Y sample distance"));
  }
  else
  {
    wallFileCoordinateLabel->setText(tr("Coordinate layout R, Z"));

    toroidalArrayAngleLabel->setText(tr("Toroidal angle between arrays"));
    arrayOriginLabel->setText(tr("Array origin (R,Phi,Z)"));
    arrayAxisArrayAxisR->setText(tr("R"));
    poloialAngleLabel->setText(tr("Poloidal angle"));
    poloialRTiltLabel->setText(tr("Poloidal plane R-tilt"));
    poloialZTiltLabel->setText(tr("Poloidal plane Z-tilt"));
    toroidalAngleLabel->setText(tr("Toroidal angle"));
    flipToroidalAngle->setVisible(true);

    channelListToroidalArrayAngleLabel->setText(tr("Toroidal angle between arrays"));
    confFileCoordinateLabel->setText(tr(" R, Z, Phi, and Poloidal Angle"));
    channelListToroidalAngleLabel->setText(tr("Toroidal angle"));
    channelListFlipToroidalAngle->setVisible(true);

    toroidalIntegrationLabel->setText(tr("Toroidal"));
    toroidalIntegrationTime->setText(tr("Sample toroidally as time"));
    toroidalGroup->setTitle(tr("Toroidal angle sampling"));
    toroidalAngleSampleLabel->setText(tr("Toroidal sample angle"));
  }
}
