/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyInverseGhostZoneAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyInverseGhostZoneAttributes
//
// Purpose: 
//   This class contains attributes for the inverse ghost zone operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a InverseGhostZoneAttributes.
//
struct InverseGhostZoneAttributesObject
{
    PyObject_HEAD
    InverseGhostZoneAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewInverseGhostZoneAttributes(int);

std::string
PyInverseGhostZoneAttributes_ToString(const InverseGhostZoneAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetRequestGhostZones())
        SNPRINTF(tmpStr, 1000, "%srequestGhostZones = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%srequestGhostZones = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowDuplicated())
        SNPRINTF(tmpStr, 1000, "%sshowDuplicated = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowDuplicated = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowEnhancedConnectivity())
        SNPRINTF(tmpStr, 1000, "%sshowEnhancedConnectivity = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowEnhancedConnectivity = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowReducedConnectivity())
        SNPRINTF(tmpStr, 1000, "%sshowReducedConnectivity = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowReducedConnectivity = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowAMRRefined())
        SNPRINTF(tmpStr, 1000, "%sshowAMRRefined = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowAMRRefined = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowExterior())
        SNPRINTF(tmpStr, 1000, "%sshowExterior = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowExterior = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNotApplicable())
        SNPRINTF(tmpStr, 1000, "%sshowNotApplicable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowNotApplicable = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
InverseGhostZoneAttributes_Notify(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetRequestGhostZones(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the requestGhostZones in the object.
    obj->data->SetRequestGhostZones(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetRequestGhostZones(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRequestGhostZones()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowDuplicated(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showDuplicated in the object.
    obj->data->SetShowDuplicated(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowDuplicated(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowDuplicated()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowEnhancedConnectivity(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showEnhancedConnectivity in the object.
    obj->data->SetShowEnhancedConnectivity(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowEnhancedConnectivity(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowEnhancedConnectivity()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowReducedConnectivity(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showReducedConnectivity in the object.
    obj->data->SetShowReducedConnectivity(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowReducedConnectivity(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowReducedConnectivity()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowAMRRefined(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showAMRRefined in the object.
    obj->data->SetShowAMRRefined(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowAMRRefined(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowAMRRefined()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowExterior(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showExterior in the object.
    obj->data->SetShowExterior(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowExterior(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowExterior()?1L:0L);
    return retval;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_SetShowNotApplicable(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNotApplicable in the object.
    obj->data->SetShowNotApplicable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
InverseGhostZoneAttributes_GetShowNotApplicable(PyObject *self, PyObject *args)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNotApplicable()?1L:0L);
    return retval;
}



PyMethodDef PyInverseGhostZoneAttributes_methods[INVERSEGHOSTZONEATTRIBUTES_NMETH] = {
    {"Notify", InverseGhostZoneAttributes_Notify, METH_VARARGS},
    {"SetRequestGhostZones", InverseGhostZoneAttributes_SetRequestGhostZones, METH_VARARGS},
    {"GetRequestGhostZones", InverseGhostZoneAttributes_GetRequestGhostZones, METH_VARARGS},
    {"SetShowDuplicated", InverseGhostZoneAttributes_SetShowDuplicated, METH_VARARGS},
    {"GetShowDuplicated", InverseGhostZoneAttributes_GetShowDuplicated, METH_VARARGS},
    {"SetShowEnhancedConnectivity", InverseGhostZoneAttributes_SetShowEnhancedConnectivity, METH_VARARGS},
    {"GetShowEnhancedConnectivity", InverseGhostZoneAttributes_GetShowEnhancedConnectivity, METH_VARARGS},
    {"SetShowReducedConnectivity", InverseGhostZoneAttributes_SetShowReducedConnectivity, METH_VARARGS},
    {"GetShowReducedConnectivity", InverseGhostZoneAttributes_GetShowReducedConnectivity, METH_VARARGS},
    {"SetShowAMRRefined", InverseGhostZoneAttributes_SetShowAMRRefined, METH_VARARGS},
    {"GetShowAMRRefined", InverseGhostZoneAttributes_GetShowAMRRefined, METH_VARARGS},
    {"SetShowExterior", InverseGhostZoneAttributes_SetShowExterior, METH_VARARGS},
    {"GetShowExterior", InverseGhostZoneAttributes_GetShowExterior, METH_VARARGS},
    {"SetShowNotApplicable", InverseGhostZoneAttributes_SetShowNotApplicable, METH_VARARGS},
    {"GetShowNotApplicable", InverseGhostZoneAttributes_GetShowNotApplicable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
InverseGhostZoneAttributes_dealloc(PyObject *v)
{
   InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
InverseGhostZoneAttributes_compare(PyObject *v, PyObject *w)
{
    InverseGhostZoneAttributes *a = ((InverseGhostZoneAttributesObject *)v)->data;
    InverseGhostZoneAttributes *b = ((InverseGhostZoneAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyInverseGhostZoneAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "requestGhostZones") == 0)
        return InverseGhostZoneAttributes_GetRequestGhostZones(self, NULL);
    if(strcmp(name, "showDuplicated") == 0)
        return InverseGhostZoneAttributes_GetShowDuplicated(self, NULL);
    if(strcmp(name, "showEnhancedConnectivity") == 0)
        return InverseGhostZoneAttributes_GetShowEnhancedConnectivity(self, NULL);
    if(strcmp(name, "showReducedConnectivity") == 0)
        return InverseGhostZoneAttributes_GetShowReducedConnectivity(self, NULL);
    if(strcmp(name, "showAMRRefined") == 0)
        return InverseGhostZoneAttributes_GetShowAMRRefined(self, NULL);
    if(strcmp(name, "showExterior") == 0)
        return InverseGhostZoneAttributes_GetShowExterior(self, NULL);
    if(strcmp(name, "showNotApplicable") == 0)
        return InverseGhostZoneAttributes_GetShowNotApplicable(self, NULL);

    return Py_FindMethod(PyInverseGhostZoneAttributes_methods, self, name);
}

int
PyInverseGhostZoneAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "requestGhostZones") == 0)
        obj = InverseGhostZoneAttributes_SetRequestGhostZones(self, tuple);
    else if(strcmp(name, "showDuplicated") == 0)
        obj = InverseGhostZoneAttributes_SetShowDuplicated(self, tuple);
    else if(strcmp(name, "showEnhancedConnectivity") == 0)
        obj = InverseGhostZoneAttributes_SetShowEnhancedConnectivity(self, tuple);
    else if(strcmp(name, "showReducedConnectivity") == 0)
        obj = InverseGhostZoneAttributes_SetShowReducedConnectivity(self, tuple);
    else if(strcmp(name, "showAMRRefined") == 0)
        obj = InverseGhostZoneAttributes_SetShowAMRRefined(self, tuple);
    else if(strcmp(name, "showExterior") == 0)
        obj = InverseGhostZoneAttributes_SetShowExterior(self, tuple);
    else if(strcmp(name, "showNotApplicable") == 0)
        obj = InverseGhostZoneAttributes_SetShowNotApplicable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
InverseGhostZoneAttributes_print(PyObject *v, FILE *fp, int flags)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)v;
    fprintf(fp, "%s", PyInverseGhostZoneAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
InverseGhostZoneAttributes_str(PyObject *v)
{
    InverseGhostZoneAttributesObject *obj = (InverseGhostZoneAttributesObject *)v;
    return PyString_FromString(PyInverseGhostZoneAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *InverseGhostZoneAttributes_Purpose = "This class contains attributes for the inverse ghost zone operator.";
#else
static char *InverseGhostZoneAttributes_Purpose = "This class contains attributes for the inverse ghost zone operator.";
#endif

//
// The type description structure
//
static PyTypeObject InverseGhostZoneAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "InverseGhostZoneAttributes",                    // tp_name
    sizeof(InverseGhostZoneAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)InverseGhostZoneAttributes_dealloc,  // tp_dealloc
    (printfunc)InverseGhostZoneAttributes_print,     // tp_print
    (getattrfunc)PyInverseGhostZoneAttributes_getattr, // tp_getattr
    (setattrfunc)PyInverseGhostZoneAttributes_setattr, // tp_setattr
    (cmpfunc)InverseGhostZoneAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)InverseGhostZoneAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    InverseGhostZoneAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static InverseGhostZoneAttributes *defaultAtts = 0;
static InverseGhostZoneAttributes *currentAtts = 0;

static PyObject *
NewInverseGhostZoneAttributes(int useCurrent)
{
    InverseGhostZoneAttributesObject *newObject;
    newObject = PyObject_NEW(InverseGhostZoneAttributesObject, &InverseGhostZoneAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new InverseGhostZoneAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new InverseGhostZoneAttributes(*defaultAtts);
    else
        newObject->data = new InverseGhostZoneAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapInverseGhostZoneAttributes(const InverseGhostZoneAttributes *attr)
{
    InverseGhostZoneAttributesObject *newObject;
    newObject = PyObject_NEW(InverseGhostZoneAttributesObject, &InverseGhostZoneAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (InverseGhostZoneAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
InverseGhostZoneAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewInverseGhostZoneAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef InverseGhostZoneAttributesMethods[] = {
    {"InverseGhostZoneAttributes", InverseGhostZoneAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *InverseGhostZoneAttributesObserver = 0;

std::string
PyInverseGhostZoneAttributes_GetLogString()
{
    std::string s("InverseGhostZoneAtts = InverseGhostZoneAttributes()\n");
    if(currentAtts != 0)
        s += PyInverseGhostZoneAttributes_ToString(currentAtts, "InverseGhostZoneAtts.");
    return s;
}

static void
PyInverseGhostZoneAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("InverseGhostZoneAtts = InverseGhostZoneAttributes()\n");
        s += PyInverseGhostZoneAttributes_ToString(currentAtts, "InverseGhostZoneAtts.");
        cb(s);
    }
}

void
PyInverseGhostZoneAttributes_StartUp(InverseGhostZoneAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyInverseGhostZoneAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(InverseGhostZoneAttributesObserver == 0)
    {
        InverseGhostZoneAttributesObserver = new ObserverToCallback(subj,
            PyInverseGhostZoneAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyInverseGhostZoneAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete InverseGhostZoneAttributesObserver;
    InverseGhostZoneAttributesObserver = 0;
}

PyMethodDef *
PyInverseGhostZoneAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return InverseGhostZoneAttributesMethods;
}

bool
PyInverseGhostZoneAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &InverseGhostZoneAttributesType);
}

InverseGhostZoneAttributes *
PyInverseGhostZoneAttributes_FromPyObject(PyObject *obj)
{
    InverseGhostZoneAttributesObject *obj2 = (InverseGhostZoneAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyInverseGhostZoneAttributes_New()
{
    return NewInverseGhostZoneAttributes(0);
}

PyObject *
PyInverseGhostZoneAttributes_Wrap(const InverseGhostZoneAttributes *attr)
{
    return WrapInverseGhostZoneAttributes(attr);
}

void
PyInverseGhostZoneAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    InverseGhostZoneAttributesObject *obj2 = (InverseGhostZoneAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyInverseGhostZoneAttributes_SetDefaults(const InverseGhostZoneAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new InverseGhostZoneAttributes(*atts);
}

