/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyBoundaryOpAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyBoundaryOpAttributes
//
// Purpose: 
//   Attributes for Boundary Operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a BoundaryOpAttributes.
//
struct BoundaryOpAttributesObject
{
    PyObject_HEAD
    BoundaryOpAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewBoundaryOpAttributes(int);

std::string
PyBoundaryOpAttributes_ToString(const BoundaryOpAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    return str;
}

static PyObject *
BoundaryOpAttributes_Notify(PyObject *self, PyObject *args)
{
    BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryOpAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryOpAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}



PyMethodDef PyBoundaryOpAttributes_methods[BOUNDARYOPATTRIBUTES_NMETH] = {
    {"Notify", BoundaryOpAttributes_Notify, METH_VARARGS},
    {"SetSmoothingLevel", BoundaryOpAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", BoundaryOpAttributes_GetSmoothingLevel, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
BoundaryOpAttributes_dealloc(PyObject *v)
{
   BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
BoundaryOpAttributes_compare(PyObject *v, PyObject *w)
{
    BoundaryOpAttributes *a = ((BoundaryOpAttributesObject *)v)->data;
    BoundaryOpAttributes *b = ((BoundaryOpAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyBoundaryOpAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "smoothingLevel") == 0)
        return BoundaryOpAttributes_GetSmoothingLevel(self, NULL);

    return Py_FindMethod(PyBoundaryOpAttributes_methods, self, name);
}

int
PyBoundaryOpAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "smoothingLevel") == 0)
        obj = BoundaryOpAttributes_SetSmoothingLevel(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
BoundaryOpAttributes_print(PyObject *v, FILE *fp, int flags)
{
    BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)v;
    fprintf(fp, "%s", PyBoundaryOpAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
BoundaryOpAttributes_str(PyObject *v)
{
    BoundaryOpAttributesObject *obj = (BoundaryOpAttributesObject *)v;
    return PyString_FromString(PyBoundaryOpAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *BoundaryOpAttributes_Purpose = "Attributes for Boundary Operator";
#else
static char *BoundaryOpAttributes_Purpose = "Attributes for Boundary Operator";
#endif

//
// The type description structure
//
static PyTypeObject BoundaryOpAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "BoundaryOpAttributes",                    // tp_name
    sizeof(BoundaryOpAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)BoundaryOpAttributes_dealloc,  // tp_dealloc
    (printfunc)BoundaryOpAttributes_print,     // tp_print
    (getattrfunc)PyBoundaryOpAttributes_getattr, // tp_getattr
    (setattrfunc)PyBoundaryOpAttributes_setattr, // tp_setattr
    (cmpfunc)BoundaryOpAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)BoundaryOpAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    BoundaryOpAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static BoundaryOpAttributes *defaultAtts = 0;
static BoundaryOpAttributes *currentAtts = 0;

static PyObject *
NewBoundaryOpAttributes(int useCurrent)
{
    BoundaryOpAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryOpAttributesObject, &BoundaryOpAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new BoundaryOpAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new BoundaryOpAttributes(*defaultAtts);
    else
        newObject->data = new BoundaryOpAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapBoundaryOpAttributes(const BoundaryOpAttributes *attr)
{
    BoundaryOpAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryOpAttributesObject, &BoundaryOpAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (BoundaryOpAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
BoundaryOpAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewBoundaryOpAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef BoundaryOpAttributesMethods[] = {
    {"BoundaryOpAttributes", BoundaryOpAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *BoundaryOpAttributesObserver = 0;

std::string
PyBoundaryOpAttributes_GetLogString()
{
    std::string s("BoundaryOpAtts = BoundaryOpAttributes()\n");
    if(currentAtts != 0)
        s += PyBoundaryOpAttributes_ToString(currentAtts, "BoundaryOpAtts.");
    return s;
}

static void
PyBoundaryOpAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("BoundaryOpAtts = BoundaryOpAttributes()\n");
        s += PyBoundaryOpAttributes_ToString(currentAtts, "BoundaryOpAtts.");
        cb(s);
    }
}

void
PyBoundaryOpAttributes_StartUp(BoundaryOpAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyBoundaryOpAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(BoundaryOpAttributesObserver == 0)
    {
        BoundaryOpAttributesObserver = new ObserverToCallback(subj,
            PyBoundaryOpAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyBoundaryOpAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete BoundaryOpAttributesObserver;
    BoundaryOpAttributesObserver = 0;
}

PyMethodDef *
PyBoundaryOpAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return BoundaryOpAttributesMethods;
}

bool
PyBoundaryOpAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &BoundaryOpAttributesType);
}

BoundaryOpAttributes *
PyBoundaryOpAttributes_FromPyObject(PyObject *obj)
{
    BoundaryOpAttributesObject *obj2 = (BoundaryOpAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyBoundaryOpAttributes_New()
{
    return NewBoundaryOpAttributes(0);
}

PyObject *
PyBoundaryOpAttributes_Wrap(const BoundaryOpAttributes *attr)
{
    return WrapBoundaryOpAttributes(attr);
}

void
PyBoundaryOpAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    BoundaryOpAttributesObject *obj2 = (BoundaryOpAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyBoundaryOpAttributes_SetDefaults(const BoundaryOpAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new BoundaryOpAttributes(*atts);
}

