// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyavtArrayMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyavtArrayMetaData
//
// Purpose:
//   Contains array metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtArrayMetaData.
//
struct avtArrayMetaDataObject
{
    PyObject_HEAD
    avtArrayMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtArrayMetaData(int);

std::string
PyavtArrayMetaData_ToString(const avtArrayMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtVarMetaData_ToString(atts, prefix);

    snprintf(tmpStr, 1000, "%snVars = %d\n", prefix, atts->nVars);
    str += tmpStr;
    {   const stringVector &compNames = atts->compNames;
        snprintf(tmpStr, 1000, "%scompNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < compNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", compNames[i].c_str());
            str += tmpStr;
            if(i < compNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
avtArrayMetaData_Notify(PyObject *self, PyObject *args)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtArrayMetaData_SetNVars(PyObject *self, PyObject *args)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nVars in the object.
    obj->data->nVars = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtArrayMetaData_GetNVars(PyObject *self, PyObject *args)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->nVars));
    return retval;
}

/*static*/ PyObject *
avtArrayMetaData_SetCompNames(PyObject *self, PyObject *args)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)self;

    stringVector  &vec = obj->data->compNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the compNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtArrayMetaData_GetCompNames(PyObject *self, PyObject *args)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the compNames.
    const stringVector &compNames = obj->data->compNames;
    PyObject *retval = PyTuple_New(compNames.size());
    for(size_t i = 0; i < compNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(compNames[i].c_str()));
    return retval;
}



PyMethodDef PyavtArrayMetaData_methods[AVTARRAYMETADATA_NMETH] = {
    {"Notify", avtArrayMetaData_Notify, METH_VARARGS},
    {"SetNVars", avtArrayMetaData_SetNVars, METH_VARARGS},
    {"GetNVars", avtArrayMetaData_GetNVars, METH_VARARGS},
    {"SetCompNames", avtArrayMetaData_SetCompNames, METH_VARARGS},
    {"GetCompNames", avtArrayMetaData_GetCompNames, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtArrayMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtArrayMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtArrayMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtArrayMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtArrayMetaData_dealloc(PyObject *v)
{
   avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtArrayMetaData_compare(PyObject *v, PyObject *w)
{
    avtArrayMetaData *a = ((avtArrayMetaDataObject *)v)->data;
    avtArrayMetaData *b = ((avtArrayMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtArrayMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "nVars") == 0)
        return avtArrayMetaData_GetNVars(self, NULL);
    if(strcmp(name, "compNames") == 0)
        return avtArrayMetaData_GetCompNames(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtArrayMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtArrayMetaData_methods, self, name);
}

int
PyavtArrayMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "nVars") == 0)
        obj = avtArrayMetaData_SetNVars(self, tuple);
    else if(strcmp(name, "compNames") == 0)
        obj = avtArrayMetaData_SetCompNames(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtArrayMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)v;
    fprintf(fp, "%s", PyavtArrayMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtArrayMetaData_str(PyObject *v)
{
    avtArrayMetaDataObject *obj = (avtArrayMetaDataObject *)v;
    return PyString_FromString(PyavtArrayMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtArrayMetaData_Purpose = "Contains array metadata attributes";
#else
static char *avtArrayMetaData_Purpose = "Contains array metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtArrayMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtArrayMetaData",                    // tp_name
    sizeof(avtArrayMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtArrayMetaData_dealloc,  // tp_dealloc
    (printfunc)avtArrayMetaData_print,     // tp_print
    (getattrfunc)PyavtArrayMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtArrayMetaData_setattr, // tp_setattr
    (cmpfunc)avtArrayMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtArrayMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtArrayMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtArrayMetaData *defaultAtts = 0;
static avtArrayMetaData *currentAtts = 0;

static PyObject *
NewavtArrayMetaData(int useCurrent)
{
    avtArrayMetaDataObject *newObject;
    newObject = PyObject_NEW(avtArrayMetaDataObject, &avtArrayMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtArrayMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtArrayMetaData(*defaultAtts);
    else
        newObject->data = new avtArrayMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtArrayMetaData(const avtArrayMetaData *attr)
{
    avtArrayMetaDataObject *newObject;
    newObject = PyObject_NEW(avtArrayMetaDataObject, &avtArrayMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtArrayMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtArrayMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtArrayMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtArrayMetaDataMethods[] = {
    {"avtArrayMetaData", avtArrayMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtArrayMetaDataObserver = 0;

std::string
PyavtArrayMetaData_GetLogString()
{
    std::string s("avtArrayMetaData = avtArrayMetaData()\n");
    if(currentAtts != 0)
        s += PyavtArrayMetaData_ToString(currentAtts, "avtArrayMetaData.");
    return s;
}

static void
PyavtArrayMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtArrayMetaData = avtArrayMetaData()\n");
        s += PyavtArrayMetaData_ToString(currentAtts, "avtArrayMetaData.");
        cb(s);
    }
}

void
PyavtArrayMetaData_StartUp(avtArrayMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtArrayMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtArrayMetaDataObserver == 0)
    {
        avtArrayMetaDataObserver = new ObserverToCallback(subj,
            PyavtArrayMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtArrayMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtArrayMetaDataObserver;
    avtArrayMetaDataObserver = 0;
}

PyMethodDef *
PyavtArrayMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtArrayMetaDataMethods;
}

bool
PyavtArrayMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtArrayMetaDataType);
}

avtArrayMetaData *
PyavtArrayMetaData_FromPyObject(PyObject *obj)
{
    avtArrayMetaDataObject *obj2 = (avtArrayMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtArrayMetaData_New()
{
    return NewavtArrayMetaData(0);
}

PyObject *
PyavtArrayMetaData_Wrap(const avtArrayMetaData *attr)
{
    return WrapavtArrayMetaData(attr);
}

void
PyavtArrayMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtArrayMetaDataObject *obj2 = (avtArrayMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtArrayMetaData_SetDefaults(const avtArrayMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtArrayMetaData(*atts);
}

