// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyWindowInformation.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyWindowInformation
//
// Purpose:
//   This class contains the attributes that tell the state of a viewer window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a WindowInformation.
//
struct WindowInformationObject
{
    PyObject_HEAD
    WindowInformation *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewWindowInformation(int);

std::string
PyWindowInformation_ToString(const WindowInformation *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sactiveSource = \"%s\"\n", prefix, atts->GetActiveSource().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sactiveTimeSlider = %d\n", prefix, atts->GetActiveTimeSlider());
    str += tmpStr;
    {   const stringVector &timeSliders = atts->GetTimeSliders();
        snprintf(tmpStr, 1000, "%stimeSliders = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < timeSliders.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", timeSliders[i].c_str());
            str += tmpStr;
            if(i < timeSliders.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &timeSliderCurrentStates = atts->GetTimeSliderCurrentStates();
        snprintf(tmpStr, 1000, "%stimeSliderCurrentStates = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < timeSliderCurrentStates.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", timeSliderCurrentStates[i]);
            str += tmpStr;
            if(i < timeSliderCurrentStates.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sanimationMode = %d\n", prefix, atts->GetAnimationMode());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sinteractionMode = %d\n", prefix, atts->GetInteractionMode());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stoolUpdateMode = %d\n", prefix, atts->GetToolUpdateMode());
    str += tmpStr;
    if(atts->GetBoundingBoxNavigate())
        snprintf(tmpStr, 1000, "%sboundingBoxNavigate = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sboundingBoxNavigate = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSpin())
        snprintf(tmpStr, 1000, "%sspin = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sspin = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFullFrame())
        snprintf(tmpStr, 1000, "%sfullFrame = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sfullFrame = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPerspective())
        snprintf(tmpStr, 1000, "%sperspective = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sperspective = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaintainView())
        snprintf(tmpStr, 1000, "%smaintainView = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%smaintainView = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLockView())
        snprintf(tmpStr, 1000, "%slockView = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slockView = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLockTools())
        snprintf(tmpStr, 1000, "%slockTools = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slockTools = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLockTime())
        snprintf(tmpStr, 1000, "%slockTime = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slockTime = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sviewExtentsType = %d\n", prefix, atts->GetViewExtentsType());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sviewDimension = %d\n", prefix, atts->GetViewDimension());
    str += tmpStr;
    {   const intVector &viewKeyframes = atts->GetViewKeyframes();
        snprintf(tmpStr, 1000, "%sviewKeyframes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < viewKeyframes.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", viewKeyframes[i]);
            str += tmpStr;
            if(i < viewKeyframes.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetCameraViewMode())
        snprintf(tmpStr, 1000, "%scameraViewMode = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%scameraViewMode = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUsingScalableRendering())
        snprintf(tmpStr, 1000, "%susingScalableRendering = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%susingScalableRendering = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slastRenderMin = %g\n", prefix, atts->GetLastRenderMin());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slastRenderAvg = %g\n", prefix, atts->GetLastRenderAvg());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slastRenderMax = %g\n", prefix, atts->GetLastRenderMax());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumPrimitives = %d\n", prefix, atts->GetNumPrimitives());
    str += tmpStr;
    {   const double *extents = atts->GetExtents();
        snprintf(tmpStr, 1000, "%sextents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            snprintf(tmpStr, 1000, "%g", extents[i]);
            str += tmpStr;
            if(i < 5)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const int *windowSize = atts->GetWindowSize();
        snprintf(tmpStr, 1000, "%swindowSize = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            snprintf(tmpStr, 1000, "%d", windowSize[i]);
            str += tmpStr;
            if(i < 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%swinMode = %d\n", prefix, atts->GetWinMode());
    str += tmpStr;
    if(atts->GetDDTSim())
        snprintf(tmpStr, 1000, "%sDDTSim = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sDDTSim = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDDTConnected())
        snprintf(tmpStr, 1000, "%sDDTConnected = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sDDTConnected = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
WindowInformation_Notify(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_SetActiveSource(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the activeSource in the object.
    obj->data->SetActiveSource(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetActiveSource(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetActiveSource().c_str());
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetActiveTimeSlider(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeTimeSlider in the object.
    obj->data->SetActiveTimeSlider((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetActiveTimeSlider(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveTimeSlider()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetTimeSliders(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    stringVector  &vec = obj->data->GetTimeSliders();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the timeSliders in the object as modified.
    obj->data->SelectTimeSliders();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetTimeSliders(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the timeSliders.
    const stringVector &timeSliders = obj->data->GetTimeSliders();
    PyObject *retval = PyTuple_New(timeSliders.size());
    for(size_t i = 0; i < timeSliders.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(timeSliders[i].c_str()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetTimeSliderCurrentStates(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    intVector  &vec = obj->data->GetTimeSliderCurrentStates();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the timeSliderCurrentStates in the object as modified.
    obj->data->SelectTimeSliderCurrentStates();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetTimeSliderCurrentStates(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the timeSliderCurrentStates.
    const intVector &timeSliderCurrentStates = obj->data->GetTimeSliderCurrentStates();
    PyObject *retval = PyTuple_New(timeSliderCurrentStates.size());
    for(size_t i = 0; i < timeSliderCurrentStates.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(timeSliderCurrentStates[i])));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetAnimationMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the animationMode in the object.
    obj->data->SetAnimationMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetAnimationMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnimationMode()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetInteractionMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactionMode in the object.
    obj->data->SetInteractionMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetInteractionMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetInteractionMode()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetToolUpdateMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the toolUpdateMode in the object.
    obj->data->SetToolUpdateMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetToolUpdateMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetToolUpdateMode()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetBoundingBoxNavigate(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundingBoxNavigate in the object.
    obj->data->SetBoundingBoxNavigate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetBoundingBoxNavigate(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBoundingBoxNavigate()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetSpin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the spin in the object.
    obj->data->SetSpin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetSpin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetFullFrame(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fullFrame in the object.
    obj->data->SetFullFrame(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetFullFrame(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFullFrame()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetPerspective(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the perspective in the object.
    obj->data->SetPerspective(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetPerspective(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerspective()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetMaintainView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainView in the object.
    obj->data->SetMaintainView(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetMaintainView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaintainView()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLockView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockView in the object.
    obj->data->SetLockView(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLockView(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockView()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLockTools(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockTools in the object.
    obj->data->SetLockTools(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLockTools(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockTools()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLockTime(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lockTime in the object.
    obj->data->SetLockTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLockTime(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLockTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetViewExtentsType(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewExtentsType in the object.
    obj->data->SetViewExtentsType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetViewExtentsType(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewExtentsType()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetViewDimension(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewDimension in the object.
    obj->data->SetViewDimension((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetViewDimension(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewDimension()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetViewKeyframes(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    intVector  &vec = obj->data->GetViewKeyframes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the viewKeyframes in the object as modified.
    obj->data->SelectViewKeyframes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetViewKeyframes(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the viewKeyframes.
    const intVector &viewKeyframes = obj->data->GetViewKeyframes();
    PyObject *retval = PyTuple_New(viewKeyframes.size());
    for(size_t i = 0; i < viewKeyframes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(viewKeyframes[i])));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetCameraViewMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cameraViewMode in the object.
    obj->data->SetCameraViewMode(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetCameraViewMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCameraViewMode()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetUsingScalableRendering(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the usingScalableRendering in the object.
    obj->data->SetUsingScalableRendering(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetUsingScalableRendering(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUsingScalableRendering()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLastRenderMin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderMin in the object.
    obj->data->SetLastRenderMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLastRenderMin(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderMin()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLastRenderAvg(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderAvg in the object.
    obj->data->SetLastRenderAvg(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLastRenderAvg(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderAvg()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetLastRenderMax(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the lastRenderMax in the object.
    obj->data->SetLastRenderMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetLastRenderMax(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetLastRenderMax()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetNumPrimitives(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numPrimitives in the object.
    obj->data->SetNumPrimitives((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetNumPrimitives(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumPrimitives()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetExtents(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    double *dvals = obj->data->GetExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the extents in the object as modified.
    obj->data->SelectExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetExtents(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the extents.
    PyObject *retval = PyTuple_New(6);
    const double *extents = obj->data->GetExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(extents[i]));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetWindowSize(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int *ivals = obj->data->GetWindowSize();
    if(!PyArg_ParseTuple(args, "ii", &ivals[0], &ivals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    ivals[i] = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    ivals[i] = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    ivals[i] = int(PyLong_AsDouble(item));
                else
                    ivals[i] = 0;
            }
        }
        else
            return NULL;
    }

    // Mark the windowSize in the object as modified.
    obj->data->SelectWindowSize();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetWindowSize(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the windowSize.
    PyObject *retval = PyTuple_New(2);
    const int *windowSize = obj->data->GetWindowSize();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(windowSize[i])));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetWinMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the winMode in the object.
    obj->data->SetWinMode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetWinMode(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWinMode()));
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetDDTSim(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the DDTSim in the object.
    obj->data->SetDDTSim(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetDDTSim(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDDTSim()?1L:0L);
    return retval;
}

/*static*/ PyObject *
WindowInformation_SetDDTConnected(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the DDTConnected in the object.
    obj->data->SetDDTConnected(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
WindowInformation_GetDDTConnected(PyObject *self, PyObject *args)
{
    WindowInformationObject *obj = (WindowInformationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDDTConnected()?1L:0L);
    return retval;
}



PyMethodDef PyWindowInformation_methods[WINDOWINFORMATION_NMETH] = {
    {"Notify", WindowInformation_Notify, METH_VARARGS},
    {"SetActiveSource", WindowInformation_SetActiveSource, METH_VARARGS},
    {"GetActiveSource", WindowInformation_GetActiveSource, METH_VARARGS},
    {"SetActiveTimeSlider", WindowInformation_SetActiveTimeSlider, METH_VARARGS},
    {"GetActiveTimeSlider", WindowInformation_GetActiveTimeSlider, METH_VARARGS},
    {"SetTimeSliders", WindowInformation_SetTimeSliders, METH_VARARGS},
    {"GetTimeSliders", WindowInformation_GetTimeSliders, METH_VARARGS},
    {"SetTimeSliderCurrentStates", WindowInformation_SetTimeSliderCurrentStates, METH_VARARGS},
    {"GetTimeSliderCurrentStates", WindowInformation_GetTimeSliderCurrentStates, METH_VARARGS},
    {"SetAnimationMode", WindowInformation_SetAnimationMode, METH_VARARGS},
    {"GetAnimationMode", WindowInformation_GetAnimationMode, METH_VARARGS},
    {"SetInteractionMode", WindowInformation_SetInteractionMode, METH_VARARGS},
    {"GetInteractionMode", WindowInformation_GetInteractionMode, METH_VARARGS},
    {"SetToolUpdateMode", WindowInformation_SetToolUpdateMode, METH_VARARGS},
    {"GetToolUpdateMode", WindowInformation_GetToolUpdateMode, METH_VARARGS},
    {"SetBoundingBoxNavigate", WindowInformation_SetBoundingBoxNavigate, METH_VARARGS},
    {"GetBoundingBoxNavigate", WindowInformation_GetBoundingBoxNavigate, METH_VARARGS},
    {"SetSpin", WindowInformation_SetSpin, METH_VARARGS},
    {"GetSpin", WindowInformation_GetSpin, METH_VARARGS},
    {"SetFullFrame", WindowInformation_SetFullFrame, METH_VARARGS},
    {"GetFullFrame", WindowInformation_GetFullFrame, METH_VARARGS},
    {"SetPerspective", WindowInformation_SetPerspective, METH_VARARGS},
    {"GetPerspective", WindowInformation_GetPerspective, METH_VARARGS},
    {"SetMaintainView", WindowInformation_SetMaintainView, METH_VARARGS},
    {"GetMaintainView", WindowInformation_GetMaintainView, METH_VARARGS},
    {"SetLockView", WindowInformation_SetLockView, METH_VARARGS},
    {"GetLockView", WindowInformation_GetLockView, METH_VARARGS},
    {"SetLockTools", WindowInformation_SetLockTools, METH_VARARGS},
    {"GetLockTools", WindowInformation_GetLockTools, METH_VARARGS},
    {"SetLockTime", WindowInformation_SetLockTime, METH_VARARGS},
    {"GetLockTime", WindowInformation_GetLockTime, METH_VARARGS},
    {"SetViewExtentsType", WindowInformation_SetViewExtentsType, METH_VARARGS},
    {"GetViewExtentsType", WindowInformation_GetViewExtentsType, METH_VARARGS},
    {"SetViewDimension", WindowInformation_SetViewDimension, METH_VARARGS},
    {"GetViewDimension", WindowInformation_GetViewDimension, METH_VARARGS},
    {"SetViewKeyframes", WindowInformation_SetViewKeyframes, METH_VARARGS},
    {"GetViewKeyframes", WindowInformation_GetViewKeyframes, METH_VARARGS},
    {"SetCameraViewMode", WindowInformation_SetCameraViewMode, METH_VARARGS},
    {"GetCameraViewMode", WindowInformation_GetCameraViewMode, METH_VARARGS},
    {"SetUsingScalableRendering", WindowInformation_SetUsingScalableRendering, METH_VARARGS},
    {"GetUsingScalableRendering", WindowInformation_GetUsingScalableRendering, METH_VARARGS},
    {"SetLastRenderMin", WindowInformation_SetLastRenderMin, METH_VARARGS},
    {"GetLastRenderMin", WindowInformation_GetLastRenderMin, METH_VARARGS},
    {"SetLastRenderAvg", WindowInformation_SetLastRenderAvg, METH_VARARGS},
    {"GetLastRenderAvg", WindowInformation_GetLastRenderAvg, METH_VARARGS},
    {"SetLastRenderMax", WindowInformation_SetLastRenderMax, METH_VARARGS},
    {"GetLastRenderMax", WindowInformation_GetLastRenderMax, METH_VARARGS},
    {"SetNumPrimitives", WindowInformation_SetNumPrimitives, METH_VARARGS},
    {"GetNumPrimitives", WindowInformation_GetNumPrimitives, METH_VARARGS},
    {"SetExtents", WindowInformation_SetExtents, METH_VARARGS},
    {"GetExtents", WindowInformation_GetExtents, METH_VARARGS},
    {"SetWindowSize", WindowInformation_SetWindowSize, METH_VARARGS},
    {"GetWindowSize", WindowInformation_GetWindowSize, METH_VARARGS},
    {"SetWinMode", WindowInformation_SetWinMode, METH_VARARGS},
    {"GetWinMode", WindowInformation_GetWinMode, METH_VARARGS},
    {"SetDDTSim", WindowInformation_SetDDTSim, METH_VARARGS},
    {"GetDDTSim", WindowInformation_GetDDTSim, METH_VARARGS},
    {"SetDDTConnected", WindowInformation_SetDDTConnected, METH_VARARGS},
    {"GetDDTConnected", WindowInformation_GetDDTConnected, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
WindowInformation_dealloc(PyObject *v)
{
   WindowInformationObject *obj = (WindowInformationObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
WindowInformation_compare(PyObject *v, PyObject *w)
{
    WindowInformation *a = ((WindowInformationObject *)v)->data;
    WindowInformation *b = ((WindowInformationObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyWindowInformation_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "activeSource") == 0)
        return WindowInformation_GetActiveSource(self, NULL);
    if(strcmp(name, "activeTimeSlider") == 0)
        return WindowInformation_GetActiveTimeSlider(self, NULL);
    if(strcmp(name, "timeSliders") == 0)
        return WindowInformation_GetTimeSliders(self, NULL);
    if(strcmp(name, "timeSliderCurrentStates") == 0)
        return WindowInformation_GetTimeSliderCurrentStates(self, NULL);
    if(strcmp(name, "animationMode") == 0)
        return WindowInformation_GetAnimationMode(self, NULL);
    if(strcmp(name, "interactionMode") == 0)
        return WindowInformation_GetInteractionMode(self, NULL);
    if(strcmp(name, "toolUpdateMode") == 0)
        return WindowInformation_GetToolUpdateMode(self, NULL);
    if(strcmp(name, "boundingBoxNavigate") == 0)
        return WindowInformation_GetBoundingBoxNavigate(self, NULL);
    if(strcmp(name, "spin") == 0)
        return WindowInformation_GetSpin(self, NULL);
    if(strcmp(name, "fullFrame") == 0)
        return WindowInformation_GetFullFrame(self, NULL);
    if(strcmp(name, "perspective") == 0)
        return WindowInformation_GetPerspective(self, NULL);
    if(strcmp(name, "maintainView") == 0)
        return WindowInformation_GetMaintainView(self, NULL);
    if(strcmp(name, "lockView") == 0)
        return WindowInformation_GetLockView(self, NULL);
    if(strcmp(name, "lockTools") == 0)
        return WindowInformation_GetLockTools(self, NULL);
    if(strcmp(name, "lockTime") == 0)
        return WindowInformation_GetLockTime(self, NULL);
    if(strcmp(name, "viewExtentsType") == 0)
        return WindowInformation_GetViewExtentsType(self, NULL);
    if(strcmp(name, "viewDimension") == 0)
        return WindowInformation_GetViewDimension(self, NULL);
    if(strcmp(name, "viewKeyframes") == 0)
        return WindowInformation_GetViewKeyframes(self, NULL);
    if(strcmp(name, "cameraViewMode") == 0)
        return WindowInformation_GetCameraViewMode(self, NULL);
    if(strcmp(name, "usingScalableRendering") == 0)
        return WindowInformation_GetUsingScalableRendering(self, NULL);
    if(strcmp(name, "lastRenderMin") == 0)
        return WindowInformation_GetLastRenderMin(self, NULL);
    if(strcmp(name, "lastRenderAvg") == 0)
        return WindowInformation_GetLastRenderAvg(self, NULL);
    if(strcmp(name, "lastRenderMax") == 0)
        return WindowInformation_GetLastRenderMax(self, NULL);
    if(strcmp(name, "numPrimitives") == 0)
        return WindowInformation_GetNumPrimitives(self, NULL);
    if(strcmp(name, "extents") == 0)
        return WindowInformation_GetExtents(self, NULL);
    if(strcmp(name, "windowSize") == 0)
        return WindowInformation_GetWindowSize(self, NULL);
    if(strcmp(name, "winMode") == 0)
        return WindowInformation_GetWinMode(self, NULL);
    if(strcmp(name, "DDTSim") == 0)
        return WindowInformation_GetDDTSim(self, NULL);
    if(strcmp(name, "DDTConnected") == 0)
        return WindowInformation_GetDDTConnected(self, NULL);

    return Py_FindMethod(PyWindowInformation_methods, self, name);
}

int
PyWindowInformation_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "activeSource") == 0)
        obj = WindowInformation_SetActiveSource(self, tuple);
    else if(strcmp(name, "activeTimeSlider") == 0)
        obj = WindowInformation_SetActiveTimeSlider(self, tuple);
    else if(strcmp(name, "timeSliders") == 0)
        obj = WindowInformation_SetTimeSliders(self, tuple);
    else if(strcmp(name, "timeSliderCurrentStates") == 0)
        obj = WindowInformation_SetTimeSliderCurrentStates(self, tuple);
    else if(strcmp(name, "animationMode") == 0)
        obj = WindowInformation_SetAnimationMode(self, tuple);
    else if(strcmp(name, "interactionMode") == 0)
        obj = WindowInformation_SetInteractionMode(self, tuple);
    else if(strcmp(name, "toolUpdateMode") == 0)
        obj = WindowInformation_SetToolUpdateMode(self, tuple);
    else if(strcmp(name, "boundingBoxNavigate") == 0)
        obj = WindowInformation_SetBoundingBoxNavigate(self, tuple);
    else if(strcmp(name, "spin") == 0)
        obj = WindowInformation_SetSpin(self, tuple);
    else if(strcmp(name, "fullFrame") == 0)
        obj = WindowInformation_SetFullFrame(self, tuple);
    else if(strcmp(name, "perspective") == 0)
        obj = WindowInformation_SetPerspective(self, tuple);
    else if(strcmp(name, "maintainView") == 0)
        obj = WindowInformation_SetMaintainView(self, tuple);
    else if(strcmp(name, "lockView") == 0)
        obj = WindowInformation_SetLockView(self, tuple);
    else if(strcmp(name, "lockTools") == 0)
        obj = WindowInformation_SetLockTools(self, tuple);
    else if(strcmp(name, "lockTime") == 0)
        obj = WindowInformation_SetLockTime(self, tuple);
    else if(strcmp(name, "viewExtentsType") == 0)
        obj = WindowInformation_SetViewExtentsType(self, tuple);
    else if(strcmp(name, "viewDimension") == 0)
        obj = WindowInformation_SetViewDimension(self, tuple);
    else if(strcmp(name, "viewKeyframes") == 0)
        obj = WindowInformation_SetViewKeyframes(self, tuple);
    else if(strcmp(name, "cameraViewMode") == 0)
        obj = WindowInformation_SetCameraViewMode(self, tuple);
    else if(strcmp(name, "usingScalableRendering") == 0)
        obj = WindowInformation_SetUsingScalableRendering(self, tuple);
    else if(strcmp(name, "lastRenderMin") == 0)
        obj = WindowInformation_SetLastRenderMin(self, tuple);
    else if(strcmp(name, "lastRenderAvg") == 0)
        obj = WindowInformation_SetLastRenderAvg(self, tuple);
    else if(strcmp(name, "lastRenderMax") == 0)
        obj = WindowInformation_SetLastRenderMax(self, tuple);
    else if(strcmp(name, "numPrimitives") == 0)
        obj = WindowInformation_SetNumPrimitives(self, tuple);
    else if(strcmp(name, "extents") == 0)
        obj = WindowInformation_SetExtents(self, tuple);
    else if(strcmp(name, "windowSize") == 0)
        obj = WindowInformation_SetWindowSize(self, tuple);
    else if(strcmp(name, "winMode") == 0)
        obj = WindowInformation_SetWinMode(self, tuple);
    else if(strcmp(name, "DDTSim") == 0)
        obj = WindowInformation_SetDDTSim(self, tuple);
    else if(strcmp(name, "DDTConnected") == 0)
        obj = WindowInformation_SetDDTConnected(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
WindowInformation_print(PyObject *v, FILE *fp, int flags)
{
    WindowInformationObject *obj = (WindowInformationObject *)v;
    fprintf(fp, "%s", PyWindowInformation_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
WindowInformation_str(PyObject *v)
{
    WindowInformationObject *obj = (WindowInformationObject *)v;
    return PyString_FromString(PyWindowInformation_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *WindowInformation_Purpose = "This class contains the attributes that tell the state of a viewer window.";
#else
static char *WindowInformation_Purpose = "This class contains the attributes that tell the state of a viewer window.";
#endif

//
// The type description structure
//
static PyTypeObject WindowInformationType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "WindowInformation",                    // tp_name
    sizeof(WindowInformationObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)WindowInformation_dealloc,  // tp_dealloc
    (printfunc)WindowInformation_print,     // tp_print
    (getattrfunc)PyWindowInformation_getattr, // tp_getattr
    (setattrfunc)PyWindowInformation_setattr, // tp_setattr
    (cmpfunc)WindowInformation_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)WindowInformation_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    WindowInformation_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static WindowInformation *defaultAtts = 0;
static WindowInformation *currentAtts = 0;

static PyObject *
NewWindowInformation(int useCurrent)
{
    WindowInformationObject *newObject;
    newObject = PyObject_NEW(WindowInformationObject, &WindowInformationType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new WindowInformation(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new WindowInformation(*defaultAtts);
    else
        newObject->data = new WindowInformation;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapWindowInformation(const WindowInformation *attr)
{
    WindowInformationObject *newObject;
    newObject = PyObject_NEW(WindowInformationObject, &WindowInformationType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (WindowInformation *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
WindowInformation_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewWindowInformation(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef WindowInformationMethods[] = {
    {"WindowInformation", WindowInformation_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *WindowInformationObserver = 0;

std::string
PyWindowInformation_GetLogString()
{
    std::string s("WindowInformation = WindowInformation()\n");
    if(currentAtts != 0)
        s += PyWindowInformation_ToString(currentAtts, "WindowInformation.");
    return s;
}

static void
PyWindowInformation_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("WindowInformation = WindowInformation()\n");
        s += PyWindowInformation_ToString(currentAtts, "WindowInformation.");
        cb(s);
    }
}

void
PyWindowInformation_StartUp(WindowInformation *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyWindowInformation_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(WindowInformationObserver == 0)
    {
        WindowInformationObserver = new ObserverToCallback(subj,
            PyWindowInformation_CallLogRoutine, (void *)data);
    }

}

void
PyWindowInformation_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete WindowInformationObserver;
    WindowInformationObserver = 0;
}

PyMethodDef *
PyWindowInformation_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return WindowInformationMethods;
}

bool
PyWindowInformation_Check(PyObject *obj)
{
    return (obj->ob_type == &WindowInformationType);
}

WindowInformation *
PyWindowInformation_FromPyObject(PyObject *obj)
{
    WindowInformationObject *obj2 = (WindowInformationObject *)obj;
    return obj2->data;
}

PyObject *
PyWindowInformation_New()
{
    return NewWindowInformation(0);
}

PyObject *
PyWindowInformation_Wrap(const WindowInformation *attr)
{
    return WrapWindowInformation(attr);
}

void
PyWindowInformation_SetParent(PyObject *obj, PyObject *parent)
{
    WindowInformationObject *obj2 = (WindowInformationObject *)obj;
    obj2->parent = parent;
}

void
PyWindowInformation_SetDefaults(const WindowInformation *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new WindowInformation(*atts);
}

