// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyViewCurveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyViewCurveAttributes
//
// Purpose:
//   This class contains the curve view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewCurveAttributes.
//
struct ViewCurveAttributesObject
{
    PyObject_HEAD
    ViewCurveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewViewCurveAttributes(int);

std::string
PyViewCurveAttributes_ToString(const ViewCurveAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *domainCoords = atts->GetDomainCoords();
        snprintf(tmpStr, 1000, "%sdomainCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            snprintf(tmpStr, 1000, "%g", domainCoords[i]);
            str += tmpStr;
            if(i < 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *rangeCoords = atts->GetRangeCoords();
        snprintf(tmpStr, 1000, "%srangeCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            snprintf(tmpStr, 1000, "%g", rangeCoords[i]);
            str += tmpStr;
            if(i < 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *viewportCoords = atts->GetViewportCoords();
        snprintf(tmpStr, 1000, "%sviewportCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 4; ++i)
        {
            snprintf(tmpStr, 1000, "%g", viewportCoords[i]);
            str += tmpStr;
            if(i < 3)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *domainScale_values[] = {"LINEAR", "LOG"};
    snprintf(tmpStr, 1000, "%sdomainScale = %s%s  # LINEAR, LOG\n", prefix, prefix, domainScale_values[atts->GetDomainScale()]);
    str += tmpStr;
    const char *rangeScale_values[] = {"LINEAR", "LOG"};
    snprintf(tmpStr, 1000, "%srangeScale = %s%s  # LINEAR, LOG\n", prefix, prefix, rangeScale_values[atts->GetRangeScale()]);
    str += tmpStr;
    return str;
}

static PyObject *
ViewCurveAttributes_Notify(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_SetDomainCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetDomainCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the domainCoords in the object as modified.
    obj->data->SelectDomainCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_GetDomainCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the domainCoords.
    PyObject *retval = PyTuple_New(2);
    const double *domainCoords = obj->data->GetDomainCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(domainCoords[i]));
    return retval;
}

/*static*/ PyObject *
ViewCurveAttributes_SetRangeCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetRangeCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rangeCoords in the object as modified.
    obj->data->SelectRangeCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_GetRangeCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rangeCoords.
    PyObject *retval = PyTuple_New(2);
    const double *rangeCoords = obj->data->GetRangeCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rangeCoords[i]));
    return retval;
}

/*static*/ PyObject *
ViewCurveAttributes_SetViewportCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    double *dvals = obj->data->GetViewportCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewportCoords in the object as modified.
    obj->data->SelectViewportCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_GetViewportCoords(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewportCoords.
    PyObject *retval = PyTuple_New(4);
    const double *viewportCoords = obj->data->GetViewportCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewportCoords[i]));
    return retval;
}

/*static*/ PyObject *
ViewCurveAttributes_SetDomainScale(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the domainScale in the object.
    if(ival >= 0 && ival <= 1)
        obj->data->SetDomainScale(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "\"LINEAR\", \"LOG\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_GetDomainScale(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDomainScale()));
    return retval;
}

/*static*/ PyObject *
ViewCurveAttributes_SetRangeScale(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rangeScale in the object.
    if(ival >= 0 && ival <= 1)
        obj->data->SetRangeScale(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "\"LINEAR\", \"LOG\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewCurveAttributes_GetRangeScale(PyObject *self, PyObject *args)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRangeScale()));
    return retval;
}



PyMethodDef PyViewCurveAttributes_methods[VIEWCURVEATTRIBUTES_NMETH] = {
    {"Notify", ViewCurveAttributes_Notify, METH_VARARGS},
    {"SetDomainCoords", ViewCurveAttributes_SetDomainCoords, METH_VARARGS},
    {"GetDomainCoords", ViewCurveAttributes_GetDomainCoords, METH_VARARGS},
    {"SetRangeCoords", ViewCurveAttributes_SetRangeCoords, METH_VARARGS},
    {"GetRangeCoords", ViewCurveAttributes_GetRangeCoords, METH_VARARGS},
    {"SetViewportCoords", ViewCurveAttributes_SetViewportCoords, METH_VARARGS},
    {"GetViewportCoords", ViewCurveAttributes_GetViewportCoords, METH_VARARGS},
    {"SetDomainScale", ViewCurveAttributes_SetDomainScale, METH_VARARGS},
    {"GetDomainScale", ViewCurveAttributes_GetDomainScale, METH_VARARGS},
    {"SetRangeScale", ViewCurveAttributes_SetRangeScale, METH_VARARGS},
    {"GetRangeScale", ViewCurveAttributes_GetRangeScale, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewCurveAttributes_dealloc(PyObject *v)
{
   ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ViewCurveAttributes_compare(PyObject *v, PyObject *w)
{
    ViewCurveAttributes *a = ((ViewCurveAttributesObject *)v)->data;
    ViewCurveAttributes *b = ((ViewCurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyViewCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "domainCoords") == 0)
        return ViewCurveAttributes_GetDomainCoords(self, NULL);
    if(strcmp(name, "rangeCoords") == 0)
        return ViewCurveAttributes_GetRangeCoords(self, NULL);
    if(strcmp(name, "viewportCoords") == 0)
        return ViewCurveAttributes_GetViewportCoords(self, NULL);
    if(strcmp(name, "domainScale") == 0)
        return ViewCurveAttributes_GetDomainScale(self, NULL);
    if(strcmp(name, "LINEAR") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "LOG") == 0)
        return PyInt_FromLong(long(1));

    if(strcmp(name, "rangeScale") == 0)
        return ViewCurveAttributes_GetRangeScale(self, NULL);
    if(strcmp(name, "LINEAR") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "LOG") == 0)
        return PyInt_FromLong(long(1));


    return Py_FindMethod(PyViewCurveAttributes_methods, self, name);
}

int
PyViewCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "domainCoords") == 0)
        obj = ViewCurveAttributes_SetDomainCoords(self, tuple);
    else if(strcmp(name, "rangeCoords") == 0)
        obj = ViewCurveAttributes_SetRangeCoords(self, tuple);
    else if(strcmp(name, "viewportCoords") == 0)
        obj = ViewCurveAttributes_SetViewportCoords(self, tuple);
    else if(strcmp(name, "domainScale") == 0)
        obj = ViewCurveAttributes_SetDomainScale(self, tuple);
    else if(strcmp(name, "rangeScale") == 0)
        obj = ViewCurveAttributes_SetRangeScale(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ViewCurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)v;
    fprintf(fp, "%s", PyViewCurveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ViewCurveAttributes_str(PyObject *v)
{
    ViewCurveAttributesObject *obj = (ViewCurveAttributesObject *)v;
    return PyString_FromString(PyViewCurveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ViewCurveAttributes_Purpose = "This class contains the curve view attributes.";
#else
static char *ViewCurveAttributes_Purpose = "This class contains the curve view attributes.";
#endif

//
// The type description structure
//
static PyTypeObject ViewCurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewCurveAttributes",                    // tp_name
    sizeof(ViewCurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewCurveAttributes_dealloc,  // tp_dealloc
    (printfunc)ViewCurveAttributes_print,     // tp_print
    (getattrfunc)PyViewCurveAttributes_getattr, // tp_getattr
    (setattrfunc)PyViewCurveAttributes_setattr, // tp_setattr
    (cmpfunc)ViewCurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ViewCurveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewCurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewCurveAttributes *defaultAtts = 0;
static ViewCurveAttributes *currentAtts = 0;

static PyObject *
NewViewCurveAttributes(int useCurrent)
{
    ViewCurveAttributesObject *newObject;
    newObject = PyObject_NEW(ViewCurveAttributesObject, &ViewCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ViewCurveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ViewCurveAttributes(*defaultAtts);
    else
        newObject->data = new ViewCurveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewCurveAttributes(const ViewCurveAttributes *attr)
{
    ViewCurveAttributesObject *newObject;
    newObject = PyObject_NEW(ViewCurveAttributesObject, &ViewCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewCurveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewCurveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewViewCurveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewCurveAttributesMethods[] = {
    {"ViewCurveAttributes", ViewCurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewCurveAttributesObserver = 0;

std::string
PyViewCurveAttributes_GetLogString()
{
    std::string s("ViewCurveAtts = ViewCurveAttributes()\n");
    if(currentAtts != 0)
        s += PyViewCurveAttributes_ToString(currentAtts, "ViewCurveAtts.");
    return s;
}

static void
PyViewCurveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ViewCurveAtts = ViewCurveAttributes()\n");
        s += PyViewCurveAttributes_ToString(currentAtts, "ViewCurveAtts.");
        cb(s);
    }
}

void
PyViewCurveAttributes_StartUp(ViewCurveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyViewCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewCurveAttributesObserver == 0)
    {
        ViewCurveAttributesObserver = new ObserverToCallback(subj,
            PyViewCurveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyViewCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewCurveAttributesObserver;
    ViewCurveAttributesObserver = 0;
}

PyMethodDef *
PyViewCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewCurveAttributesMethods;
}

bool
PyViewCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewCurveAttributesType);
}

ViewCurveAttributes *
PyViewCurveAttributes_FromPyObject(PyObject *obj)
{
    ViewCurveAttributesObject *obj2 = (ViewCurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyViewCurveAttributes_New()
{
    return NewViewCurveAttributes(0);
}

PyObject *
PyViewCurveAttributes_Wrap(const ViewCurveAttributes *attr)
{
    return WrapViewCurveAttributes(attr);
}

void
PyViewCurveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ViewCurveAttributesObject *obj2 = (ViewCurveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyViewCurveAttributes_SetDefaults(const ViewCurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewCurveAttributes(*atts);
}

