// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PySelectionSummary.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <PySelectionVariableSummary.h>

// ****************************************************************************
// Module: PySelectionSummary
//
// Purpose:
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SelectionSummary.
//
struct SelectionSummaryObject
{
    PyObject_HEAD
    SelectionSummary *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSelectionSummary(int);

std::string
PySelectionSummary_ToString(const SelectionSummary *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    { // new scope
        int index = 0;
        // Create string representation of variables from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetVariables().begin(); pos != atts->GetVariables().end(); ++pos, ++index)
        {
            const SelectionVariableSummary *current = (const SelectionVariableSummary *)(*pos);
            snprintf(tmpStr, 1000, "GetVariables(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PySelectionVariableSummary_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#variables does not contain any SelectionVariableSummary objects.\n";
    }
    snprintf(tmpStr, 1000, "%scellCount = %d\n", prefix, atts->GetCellCount());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stotalCellCount = %d\n", prefix, atts->GetTotalCellCount());
    str += tmpStr;
    {   const doubleVector &histogramValues = atts->GetHistogramValues();
        snprintf(tmpStr, 1000, "%shistogramValues = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < histogramValues.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", histogramValues[i]);
            str += tmpStr;
            if(i < histogramValues.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%shistogramMinBin = %g\n", prefix, atts->GetHistogramMinBin());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%shistogramMaxBin = %g\n", prefix, atts->GetHistogramMaxBin());
    str += tmpStr;
    return str;
}

static PyObject *
SelectionSummary_Notify(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_SetName(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetName(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionSummary_GetVariables(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetVariables().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetVariables().size() == 0)
            snprintf(msg, 400, "In SelectionSummary::GetVariables : The index %d is invalid because variables is empty.", index);
        else
            snprintf(msg, 400, "In SelectionSummary::GetVariables : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetVariables().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySelectionVariableSummary_Wrap(&obj->data->GetVariables(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySelectionVariableSummary_SetParent(retval, self);

    return retval;
}

PyObject *
SelectionSummary_GetNumVariables(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    return PyInt_FromLong((long)obj->data->GetVariables().size());
}

PyObject *
SelectionSummary_AddVariables(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PySelectionVariableSummary_Check(element))
    {
        char msg[400] = {'\0'};
        snprintf(msg, 400, "The SelectionSummary::AddVariables method only accepts SelectionVariableSummary objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    SelectionVariableSummary *newData = PySelectionVariableSummary_FromPyObject(element);
    obj->data->AddVariables(*newData);
    obj->data->SelectVariables();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SelectionSummary_Remove_One_Variables(PyObject *self, int index)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveVariables() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetVariables();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times.
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectVariables();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
SelectionSummary_RemoveVariables(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    if(index < 0 || index >= obj->data->GetNumVariables())
    {
        char msg[400] = {'\0'};
        snprintf(msg, 400, "In SelectionSummary::RemoveVariables : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return SelectionSummary_Remove_One_Variables(self, index);
}

PyObject *
SelectionSummary_ClearVariables(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    int n = obj->data->GetNumVariables();
    for(int i = 0; i < n; ++i)
    {
        SelectionSummary_Remove_One_Variables(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_SetCellCount(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cellCount in the object.
    obj->data->SetCellCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetCellCount(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCellCount()));
    return retval;
}

/*static*/ PyObject *
SelectionSummary_SetTotalCellCount(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the totalCellCount in the object.
    obj->data->SetTotalCellCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetTotalCellCount(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTotalCellCount()));
    return retval;
}

/*static*/ PyObject *
SelectionSummary_SetHistogramValues(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    doubleVector  &vec = obj->data->GetHistogramValues();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the histogramValues in the object as modified.
    obj->data->SelectHistogramValues();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetHistogramValues(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    // Allocate a tuple the with enough entries to hold the histogramValues.
    const doubleVector &histogramValues = obj->data->GetHistogramValues();
    PyObject *retval = PyTuple_New(histogramValues.size());
    for(size_t i = 0; i < histogramValues.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(histogramValues[i]));
    return retval;
}

/*static*/ PyObject *
SelectionSummary_SetHistogramMinBin(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the histogramMinBin in the object.
    obj->data->SetHistogramMinBin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetHistogramMinBin(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHistogramMinBin());
    return retval;
}

/*static*/ PyObject *
SelectionSummary_SetHistogramMaxBin(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the histogramMaxBin in the object.
    obj->data->SetHistogramMaxBin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionSummary_GetHistogramMaxBin(PyObject *self, PyObject *args)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHistogramMaxBin());
    return retval;
}



PyMethodDef PySelectionSummary_methods[SELECTIONSUMMARY_NMETH] = {
    {"Notify", SelectionSummary_Notify, METH_VARARGS},
    {"SetName", SelectionSummary_SetName, METH_VARARGS},
    {"GetName", SelectionSummary_GetName, METH_VARARGS},
    {"GetVariables", SelectionSummary_GetVariables, METH_VARARGS},
    {"GetNumVariables", SelectionSummary_GetNumVariables, METH_VARARGS},
    {"AddVariables", SelectionSummary_AddVariables, METH_VARARGS},
    {"RemoveVariables", SelectionSummary_RemoveVariables, METH_VARARGS},
    {"ClearVariables", SelectionSummary_ClearVariables, METH_VARARGS},
    {"SetCellCount", SelectionSummary_SetCellCount, METH_VARARGS},
    {"GetCellCount", SelectionSummary_GetCellCount, METH_VARARGS},
    {"SetTotalCellCount", SelectionSummary_SetTotalCellCount, METH_VARARGS},
    {"GetTotalCellCount", SelectionSummary_GetTotalCellCount, METH_VARARGS},
    {"SetHistogramValues", SelectionSummary_SetHistogramValues, METH_VARARGS},
    {"GetHistogramValues", SelectionSummary_GetHistogramValues, METH_VARARGS},
    {"SetHistogramMinBin", SelectionSummary_SetHistogramMinBin, METH_VARARGS},
    {"GetHistogramMinBin", SelectionSummary_GetHistogramMinBin, METH_VARARGS},
    {"SetHistogramMaxBin", SelectionSummary_SetHistogramMaxBin, METH_VARARGS},
    {"GetHistogramMaxBin", SelectionSummary_GetHistogramMaxBin, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SelectionSummary_dealloc(PyObject *v)
{
   SelectionSummaryObject *obj = (SelectionSummaryObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SelectionSummary_compare(PyObject *v, PyObject *w)
{
    SelectionSummary *a = ((SelectionSummaryObject *)v)->data;
    SelectionSummary *b = ((SelectionSummaryObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySelectionSummary_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return SelectionSummary_GetName(self, NULL);
    if(strcmp(name, "variables") == 0)
        return SelectionSummary_GetVariables(self, NULL);
    if(strcmp(name, "cellCount") == 0)
        return SelectionSummary_GetCellCount(self, NULL);
    if(strcmp(name, "totalCellCount") == 0)
        return SelectionSummary_GetTotalCellCount(self, NULL);
    if(strcmp(name, "histogramValues") == 0)
        return SelectionSummary_GetHistogramValues(self, NULL);
    if(strcmp(name, "histogramMinBin") == 0)
        return SelectionSummary_GetHistogramMinBin(self, NULL);
    if(strcmp(name, "histogramMaxBin") == 0)
        return SelectionSummary_GetHistogramMaxBin(self, NULL);

    return Py_FindMethod(PySelectionSummary_methods, self, name);
}

int
PySelectionSummary_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = SelectionSummary_SetName(self, tuple);
    else if(strcmp(name, "cellCount") == 0)
        obj = SelectionSummary_SetCellCount(self, tuple);
    else if(strcmp(name, "totalCellCount") == 0)
        obj = SelectionSummary_SetTotalCellCount(self, tuple);
    else if(strcmp(name, "histogramValues") == 0)
        obj = SelectionSummary_SetHistogramValues(self, tuple);
    else if(strcmp(name, "histogramMinBin") == 0)
        obj = SelectionSummary_SetHistogramMinBin(self, tuple);
    else if(strcmp(name, "histogramMaxBin") == 0)
        obj = SelectionSummary_SetHistogramMaxBin(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SelectionSummary_print(PyObject *v, FILE *fp, int flags)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)v;
    fprintf(fp, "%s", PySelectionSummary_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SelectionSummary_str(PyObject *v)
{
    SelectionSummaryObject *obj = (SelectionSummaryObject *)v;
    return PyString_FromString(PySelectionSummary_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SelectionSummary_Purpose = "Contains attributes for a selection";
#else
static char *SelectionSummary_Purpose = "Contains attributes for a selection";
#endif

//
// The type description structure
//
static PyTypeObject SelectionSummaryType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SelectionSummary",                    // tp_name
    sizeof(SelectionSummaryObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SelectionSummary_dealloc,  // tp_dealloc
    (printfunc)SelectionSummary_print,     // tp_print
    (getattrfunc)PySelectionSummary_getattr, // tp_getattr
    (setattrfunc)PySelectionSummary_setattr, // tp_setattr
    (cmpfunc)SelectionSummary_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SelectionSummary_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SelectionSummary_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SelectionSummary *defaultAtts = 0;
static SelectionSummary *currentAtts = 0;

static PyObject *
NewSelectionSummary(int useCurrent)
{
    SelectionSummaryObject *newObject;
    newObject = PyObject_NEW(SelectionSummaryObject, &SelectionSummaryType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SelectionSummary(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SelectionSummary(*defaultAtts);
    else
        newObject->data = new SelectionSummary;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSelectionSummary(const SelectionSummary *attr)
{
    SelectionSummaryObject *newObject;
    newObject = PyObject_NEW(SelectionSummaryObject, &SelectionSummaryType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SelectionSummary *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SelectionSummary_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSelectionSummary(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SelectionSummaryMethods[] = {
    {"SelectionSummary", SelectionSummary_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SelectionSummaryObserver = 0;

std::string
PySelectionSummary_GetLogString()
{
    std::string s("SelectionSummary = SelectionSummary()\n");
    if(currentAtts != 0)
        s += PySelectionSummary_ToString(currentAtts, "SelectionSummary.");
    return s;
}

static void
PySelectionSummary_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SelectionSummary = SelectionSummary()\n");
        s += PySelectionSummary_ToString(currentAtts, "SelectionSummary.");
        cb(s);
    }
}

void
PySelectionSummary_StartUp(SelectionSummary *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySelectionSummary_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SelectionSummaryObserver == 0)
    {
        SelectionSummaryObserver = new ObserverToCallback(subj,
            PySelectionSummary_CallLogRoutine, (void *)data);
    }

}

void
PySelectionSummary_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SelectionSummaryObserver;
    SelectionSummaryObserver = 0;
}

PyMethodDef *
PySelectionSummary_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SelectionSummaryMethods;
}

bool
PySelectionSummary_Check(PyObject *obj)
{
    return (obj->ob_type == &SelectionSummaryType);
}

SelectionSummary *
PySelectionSummary_FromPyObject(PyObject *obj)
{
    SelectionSummaryObject *obj2 = (SelectionSummaryObject *)obj;
    return obj2->data;
}

PyObject *
PySelectionSummary_New()
{
    return NewSelectionSummary(0);
}

PyObject *
PySelectionSummary_Wrap(const SelectionSummary *attr)
{
    return WrapSelectionSummary(attr);
}

void
PySelectionSummary_SetParent(PyObject *obj, PyObject *parent)
{
    SelectionSummaryObject *obj2 = (SelectionSummaryObject *)obj;
    obj2->parent = parent;
}

void
PySelectionSummary_SetDefaults(const SelectionSummary *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SelectionSummary(*atts);
}

