// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyQueryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyQueryAttributes
//
// Purpose:
//   This class contains attributes used for query.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a QueryAttributes.
//
struct QueryAttributesObject
{
    PyObject_HEAD
    QueryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewQueryAttributes(int);

std::string
PyQueryAttributes_ToString(const QueryAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sresultsMessage = \"%s\"\n", prefix, atts->GetResultsMessage().c_str());
    str += tmpStr;
    {   const doubleVector &resultsValue = atts->GetResultsValue();
        snprintf(tmpStr, 1000, "%sresultsValue = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < resultsValue.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", resultsValue[i]);
            str += tmpStr;
            if(i < resultsValue.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%stimeStep = %d\n", prefix, atts->GetTimeStep());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxUnits = \"%s\"\n", prefix, atts->GetXUnits().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%syUnits = \"%s\"\n", prefix, atts->GetYUnits().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sfloatFormat = \"%s\"\n", prefix, atts->GetFloatFormat().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sxmlResult = \"%s\"\n", prefix, atts->GetXmlResult().c_str());
    str += tmpStr;
    //queryInputParams
    return str;
}

static PyObject *
QueryAttributes_Notify(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_SetResultsMessage(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the resultsMessage in the object.
    obj->data->SetResultsMessage(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetResultsMessage(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetResultsMessage().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetResultsValue(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    doubleVector  &vec = obj->data->GetResultsValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the resultsValue in the object as modified.
    obj->data->SelectResultsValue();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetResultsValue(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the resultsValue.
    const doubleVector &resultsValue = obj->data->GetResultsValue();
    PyObject *retval = PyTuple_New(resultsValue.size());
    for(size_t i = 0; i < resultsValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(resultsValue[i]));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetTimeStep(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStep in the object.
    obj->data->SetTimeStep((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetTimeStep(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStep()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetXUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xUnits in the object.
    obj->data->SetXUnits(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetXUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXUnits().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetYUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yUnits in the object.
    obj->data->SetYUnits(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetYUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetYUnits().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetFloatFormat(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the floatFormat in the object.
    obj->data->SetFloatFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetFloatFormat(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFloatFormat().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetXmlResult(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xmlResult in the object.
    obj->data->SetXmlResult(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetXmlResult(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXmlResult().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetQueryInputParams(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    (void) obj;
    // NOT IMPLEMENTED!!!
    // name=queryInputParams, type=MapNode

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetQueryInputParams(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    (void) obj;
    // NOT IMPLEMENTED!!!
    // name=queryInputParams, type=MapNode
    PyObject *retval = NULL;
    return retval;
}



PyMethodDef PyQueryAttributes_methods[QUERYATTRIBUTES_NMETH] = {
    {"Notify", QueryAttributes_Notify, METH_VARARGS},
    {"SetResultsMessage", QueryAttributes_SetResultsMessage, METH_VARARGS},
    {"GetResultsMessage", QueryAttributes_GetResultsMessage, METH_VARARGS},
    {"SetResultsValue", QueryAttributes_SetResultsValue, METH_VARARGS},
    {"GetResultsValue", QueryAttributes_GetResultsValue, METH_VARARGS},
    {"SetTimeStep", QueryAttributes_SetTimeStep, METH_VARARGS},
    {"GetTimeStep", QueryAttributes_GetTimeStep, METH_VARARGS},
    {"SetXUnits", QueryAttributes_SetXUnits, METH_VARARGS},
    {"GetXUnits", QueryAttributes_GetXUnits, METH_VARARGS},
    {"SetYUnits", QueryAttributes_SetYUnits, METH_VARARGS},
    {"GetYUnits", QueryAttributes_GetYUnits, METH_VARARGS},
    {"SetFloatFormat", QueryAttributes_SetFloatFormat, METH_VARARGS},
    {"GetFloatFormat", QueryAttributes_GetFloatFormat, METH_VARARGS},
    {"SetXmlResult", QueryAttributes_SetXmlResult, METH_VARARGS},
    {"GetXmlResult", QueryAttributes_GetXmlResult, METH_VARARGS},
    {"SetQueryInputParams", QueryAttributes_SetQueryInputParams, METH_VARARGS},
    {"GetQueryInputParams", QueryAttributes_GetQueryInputParams, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
QueryAttributes_dealloc(PyObject *v)
{
   QueryAttributesObject *obj = (QueryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
QueryAttributes_compare(PyObject *v, PyObject *w)
{
    QueryAttributes *a = ((QueryAttributesObject *)v)->data;
    QueryAttributes *b = ((QueryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyQueryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "resultsMessage") == 0)
        return QueryAttributes_GetResultsMessage(self, NULL);
    if(strcmp(name, "resultsValue") == 0)
        return QueryAttributes_GetResultsValue(self, NULL);
    if(strcmp(name, "timeStep") == 0)
        return QueryAttributes_GetTimeStep(self, NULL);
    if(strcmp(name, "xUnits") == 0)
        return QueryAttributes_GetXUnits(self, NULL);
    if(strcmp(name, "yUnits") == 0)
        return QueryAttributes_GetYUnits(self, NULL);
    if(strcmp(name, "floatFormat") == 0)
        return QueryAttributes_GetFloatFormat(self, NULL);
    if(strcmp(name, "xmlResult") == 0)
        return QueryAttributes_GetXmlResult(self, NULL);
    if(strcmp(name, "queryInputParams") == 0)
        return QueryAttributes_GetQueryInputParams(self, NULL);

    return Py_FindMethod(PyQueryAttributes_methods, self, name);
}

int
PyQueryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "resultsMessage") == 0)
        obj = QueryAttributes_SetResultsMessage(self, tuple);
    else if(strcmp(name, "resultsValue") == 0)
        obj = QueryAttributes_SetResultsValue(self, tuple);
    else if(strcmp(name, "timeStep") == 0)
        obj = QueryAttributes_SetTimeStep(self, tuple);
    else if(strcmp(name, "xUnits") == 0)
        obj = QueryAttributes_SetXUnits(self, tuple);
    else if(strcmp(name, "yUnits") == 0)
        obj = QueryAttributes_SetYUnits(self, tuple);
    else if(strcmp(name, "floatFormat") == 0)
        obj = QueryAttributes_SetFloatFormat(self, tuple);
    else if(strcmp(name, "xmlResult") == 0)
        obj = QueryAttributes_SetXmlResult(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
QueryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)v;
    fprintf(fp, "%s", PyQueryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
QueryAttributes_str(PyObject *v)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)v;
    return PyString_FromString(PyQueryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *QueryAttributes_Purpose = "This class contains attributes used for query.";
#else
static char *QueryAttributes_Purpose = "This class contains attributes used for query.";
#endif

//
// The type description structure
//
static PyTypeObject QueryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "QueryAttributes",                    // tp_name
    sizeof(QueryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)QueryAttributes_dealloc,  // tp_dealloc
    (printfunc)QueryAttributes_print,     // tp_print
    (getattrfunc)PyQueryAttributes_getattr, // tp_getattr
    (setattrfunc)PyQueryAttributes_setattr, // tp_setattr
    (cmpfunc)QueryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)QueryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    QueryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static QueryAttributes *defaultAtts = 0;
static QueryAttributes *currentAtts = 0;

static PyObject *
NewQueryAttributes(int useCurrent)
{
    QueryAttributesObject *newObject;
    newObject = PyObject_NEW(QueryAttributesObject, &QueryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new QueryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new QueryAttributes(*defaultAtts);
    else
        newObject->data = new QueryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapQueryAttributes(const QueryAttributes *attr)
{
    QueryAttributesObject *newObject;
    newObject = PyObject_NEW(QueryAttributesObject, &QueryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (QueryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
QueryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewQueryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef QueryAttributesMethods[] = {
    {"QueryAttributes", QueryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *QueryAttributesObserver = 0;

std::string
PyQueryAttributes_GetLogString()
{
    std::string s("QueryAtts = QueryAttributes()\n");
    if(currentAtts != 0)
        s += PyQueryAttributes_ToString(currentAtts, "QueryAtts.");
    return s;
}

static void
PyQueryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("QueryAtts = QueryAttributes()\n");
        s += PyQueryAttributes_ToString(currentAtts, "QueryAtts.");
        cb(s);
    }
}

void
PyQueryAttributes_StartUp(QueryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyQueryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(QueryAttributesObserver == 0)
    {
        QueryAttributesObserver = new ObserverToCallback(subj,
            PyQueryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyQueryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete QueryAttributesObserver;
    QueryAttributesObserver = 0;
}

PyMethodDef *
PyQueryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return QueryAttributesMethods;
}

bool
PyQueryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &QueryAttributesType);
}

QueryAttributes *
PyQueryAttributes_FromPyObject(PyObject *obj)
{
    QueryAttributesObject *obj2 = (QueryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyQueryAttributes_New()
{
    return NewQueryAttributes(0);
}

PyObject *
PyQueryAttributes_Wrap(const QueryAttributes *attr)
{
    return WrapQueryAttributes(attr);
}

void
PyQueryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    QueryAttributesObject *obj2 = (QueryAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyQueryAttributes_SetDefaults(const QueryAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new QueryAttributes(*atts);
}

