// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyGlobalLineoutAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyGlobalLineoutAttributes
//
// Purpose:
//   This file contains global attributes controlling Lineouts.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a GlobalLineoutAttributes.
//
struct GlobalLineoutAttributesObject
{
    PyObject_HEAD
    GlobalLineoutAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewGlobalLineoutAttributes(int);

std::string
PyGlobalLineoutAttributes_ToString(const GlobalLineoutAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetDynamic())
        snprintf(tmpStr, 1000, "%sDynamic = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sDynamic = 0\n", prefix);
    str += tmpStr;
    if(atts->GetCreateWindow())
        snprintf(tmpStr, 1000, "%screateWindow = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%screateWindow = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%swindowId = %d\n", prefix, atts->GetWindowId());
    str += tmpStr;
    if(atts->GetSamplingOn())
        snprintf(tmpStr, 1000, "%ssamplingOn = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%ssamplingOn = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumSamples = %d\n", prefix, atts->GetNumSamples());
    str += tmpStr;
    if(atts->GetCreateReflineLabels())
        snprintf(tmpStr, 1000, "%screateReflineLabels = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%screateReflineLabels = 0\n", prefix);
    str += tmpStr;
    const char *curveOption_names = "UpdateCurve, CreateCurve";
    switch (atts->GetCurveOption())
    {
      case GlobalLineoutAttributes::UpdateCurve:
          snprintf(tmpStr, 1000, "%scurveOption = %sUpdateCurve  # %s\n", prefix, prefix, curveOption_names);
          str += tmpStr;
          break;
      case GlobalLineoutAttributes::CreateCurve:
          snprintf(tmpStr, 1000, "%scurveOption = %sCreateCurve  # %s\n", prefix, prefix, curveOption_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *colorOption_names = "RepeatColor, CreateColor";
    switch (atts->GetColorOption())
    {
      case GlobalLineoutAttributes::RepeatColor:
          snprintf(tmpStr, 1000, "%scolorOption = %sRepeatColor  # %s\n", prefix, prefix, colorOption_names);
          str += tmpStr;
          break;
      case GlobalLineoutAttributes::CreateColor:
          snprintf(tmpStr, 1000, "%scolorOption = %sCreateColor  # %s\n", prefix, prefix, colorOption_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetFreezeInTime())
        snprintf(tmpStr, 1000, "%sfreezeInTime = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sfreezeInTime = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
GlobalLineoutAttributes_Notify(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetDynamic(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Dynamic in the object.
    obj->data->SetDynamic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetDynamic(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDynamic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetCreateWindow(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createWindow in the object.
    obj->data->SetCreateWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetCreateWindow(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateWindow()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetWindowId(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetWindowId(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetSamplingOn(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplingOn in the object.
    obj->data->SetSamplingOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetSamplingOn(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSamplingOn()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetNumSamples(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numSamples in the object.
    obj->data->SetNumSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetNumSamples(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumSamples()));
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetCreateReflineLabels(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createReflineLabels in the object.
    obj->data->SetCreateReflineLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetCreateReflineLabels(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateReflineLabels()?1L:0L);
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetCurveOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the curveOption in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCurveOption(GlobalLineoutAttributes::CurveOptions(ival));
    else
    {
        fprintf(stderr, "An invalid curveOption value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "UpdateCurve, CreateCurve.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetCurveOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCurveOption()));
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetColorOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorOption in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorOption(GlobalLineoutAttributes::ColorOptions(ival));
    else
    {
        fprintf(stderr, "An invalid colorOption value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "RepeatColor, CreateColor.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetColorOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorOption()));
    return retval;
}

/*static*/ PyObject *
GlobalLineoutAttributes_SetFreezeInTime(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the freezeInTime in the object.
    obj->data->SetFreezeInTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GlobalLineoutAttributes_GetFreezeInTime(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFreezeInTime()?1L:0L);
    return retval;
}



PyMethodDef PyGlobalLineoutAttributes_methods[GLOBALLINEOUTATTRIBUTES_NMETH] = {
    {"Notify", GlobalLineoutAttributes_Notify, METH_VARARGS},
    {"SetDynamic", GlobalLineoutAttributes_SetDynamic, METH_VARARGS},
    {"GetDynamic", GlobalLineoutAttributes_GetDynamic, METH_VARARGS},
    {"SetCreateWindow", GlobalLineoutAttributes_SetCreateWindow, METH_VARARGS},
    {"GetCreateWindow", GlobalLineoutAttributes_GetCreateWindow, METH_VARARGS},
    {"SetWindowId", GlobalLineoutAttributes_SetWindowId, METH_VARARGS},
    {"GetWindowId", GlobalLineoutAttributes_GetWindowId, METH_VARARGS},
    {"SetSamplingOn", GlobalLineoutAttributes_SetSamplingOn, METH_VARARGS},
    {"GetSamplingOn", GlobalLineoutAttributes_GetSamplingOn, METH_VARARGS},
    {"SetNumSamples", GlobalLineoutAttributes_SetNumSamples, METH_VARARGS},
    {"GetNumSamples", GlobalLineoutAttributes_GetNumSamples, METH_VARARGS},
    {"SetCreateReflineLabels", GlobalLineoutAttributes_SetCreateReflineLabels, METH_VARARGS},
    {"GetCreateReflineLabels", GlobalLineoutAttributes_GetCreateReflineLabels, METH_VARARGS},
    {"SetCurveOption", GlobalLineoutAttributes_SetCurveOption, METH_VARARGS},
    {"GetCurveOption", GlobalLineoutAttributes_GetCurveOption, METH_VARARGS},
    {"SetColorOption", GlobalLineoutAttributes_SetColorOption, METH_VARARGS},
    {"GetColorOption", GlobalLineoutAttributes_GetColorOption, METH_VARARGS},
    {"SetFreezeInTime", GlobalLineoutAttributes_SetFreezeInTime, METH_VARARGS},
    {"GetFreezeInTime", GlobalLineoutAttributes_GetFreezeInTime, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GlobalLineoutAttributes_dealloc(PyObject *v)
{
   GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
GlobalLineoutAttributes_compare(PyObject *v, PyObject *w)
{
    GlobalLineoutAttributes *a = ((GlobalLineoutAttributesObject *)v)->data;
    GlobalLineoutAttributes *b = ((GlobalLineoutAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyGlobalLineoutAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "Dynamic") == 0)
        return GlobalLineoutAttributes_GetDynamic(self, NULL);
    if(strcmp(name, "createWindow") == 0)
        return GlobalLineoutAttributes_GetCreateWindow(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return GlobalLineoutAttributes_GetWindowId(self, NULL);
    if(strcmp(name, "samplingOn") == 0)
        return GlobalLineoutAttributes_GetSamplingOn(self, NULL);
    if(strcmp(name, "numSamples") == 0)
        return GlobalLineoutAttributes_GetNumSamples(self, NULL);
    if(strcmp(name, "createReflineLabels") == 0)
        return GlobalLineoutAttributes_GetCreateReflineLabels(self, NULL);
    if(strcmp(name, "curveOption") == 0)
        return GlobalLineoutAttributes_GetCurveOption(self, NULL);
    if(strcmp(name, "UpdateCurve") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::UpdateCurve));
    if(strcmp(name, "CreateCurve") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::CreateCurve));

    if(strcmp(name, "colorOption") == 0)
        return GlobalLineoutAttributes_GetColorOption(self, NULL);
    if(strcmp(name, "RepeatColor") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::RepeatColor));
    if(strcmp(name, "CreateColor") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::CreateColor));

    if(strcmp(name, "freezeInTime") == 0)
        return GlobalLineoutAttributes_GetFreezeInTime(self, NULL);

    return Py_FindMethod(PyGlobalLineoutAttributes_methods, self, name);
}

int
PyGlobalLineoutAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "Dynamic") == 0)
        obj = GlobalLineoutAttributes_SetDynamic(self, tuple);
    else if(strcmp(name, "createWindow") == 0)
        obj = GlobalLineoutAttributes_SetCreateWindow(self, tuple);
    else if(strcmp(name, "windowId") == 0)
        obj = GlobalLineoutAttributes_SetWindowId(self, tuple);
    else if(strcmp(name, "samplingOn") == 0)
        obj = GlobalLineoutAttributes_SetSamplingOn(self, tuple);
    else if(strcmp(name, "numSamples") == 0)
        obj = GlobalLineoutAttributes_SetNumSamples(self, tuple);
    else if(strcmp(name, "createReflineLabels") == 0)
        obj = GlobalLineoutAttributes_SetCreateReflineLabels(self, tuple);
    else if(strcmp(name, "curveOption") == 0)
        obj = GlobalLineoutAttributes_SetCurveOption(self, tuple);
    else if(strcmp(name, "colorOption") == 0)
        obj = GlobalLineoutAttributes_SetColorOption(self, tuple);
    else if(strcmp(name, "freezeInTime") == 0)
        obj = GlobalLineoutAttributes_SetFreezeInTime(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
GlobalLineoutAttributes_print(PyObject *v, FILE *fp, int flags)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;
    fprintf(fp, "%s", PyGlobalLineoutAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
GlobalLineoutAttributes_str(PyObject *v)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;
    return PyString_FromString(PyGlobalLineoutAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *GlobalLineoutAttributes_Purpose = "This file contains global attributes controlling Lineouts.";
#else
static char *GlobalLineoutAttributes_Purpose = "This file contains global attributes controlling Lineouts.";
#endif

//
// The type description structure
//
static PyTypeObject GlobalLineoutAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GlobalLineoutAttributes",                    // tp_name
    sizeof(GlobalLineoutAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GlobalLineoutAttributes_dealloc,  // tp_dealloc
    (printfunc)GlobalLineoutAttributes_print,     // tp_print
    (getattrfunc)PyGlobalLineoutAttributes_getattr, // tp_getattr
    (setattrfunc)PyGlobalLineoutAttributes_setattr, // tp_setattr
    (cmpfunc)GlobalLineoutAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GlobalLineoutAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GlobalLineoutAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GlobalLineoutAttributes *defaultAtts = 0;
static GlobalLineoutAttributes *currentAtts = 0;

static PyObject *
NewGlobalLineoutAttributes(int useCurrent)
{
    GlobalLineoutAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalLineoutAttributesObject, &GlobalLineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new GlobalLineoutAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new GlobalLineoutAttributes(*defaultAtts);
    else
        newObject->data = new GlobalLineoutAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapGlobalLineoutAttributes(const GlobalLineoutAttributes *attr)
{
    GlobalLineoutAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalLineoutAttributesObject, &GlobalLineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GlobalLineoutAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GlobalLineoutAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewGlobalLineoutAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GlobalLineoutAttributesMethods[] = {
    {"GlobalLineoutAttributes", GlobalLineoutAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GlobalLineoutAttributesObserver = 0;

std::string
PyGlobalLineoutAttributes_GetLogString()
{
    std::string s("GlobalLineoutAtts = GlobalLineoutAttributes()\n");
    if(currentAtts != 0)
        s += PyGlobalLineoutAttributes_ToString(currentAtts, "GlobalLineoutAtts.");
    return s;
}

static void
PyGlobalLineoutAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("GlobalLineoutAtts = GlobalLineoutAttributes()\n");
        s += PyGlobalLineoutAttributes_ToString(currentAtts, "GlobalLineoutAtts.");
        cb(s);
    }
}

void
PyGlobalLineoutAttributes_StartUp(GlobalLineoutAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyGlobalLineoutAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GlobalLineoutAttributesObserver == 0)
    {
        GlobalLineoutAttributesObserver = new ObserverToCallback(subj,
            PyGlobalLineoutAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyGlobalLineoutAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GlobalLineoutAttributesObserver;
    GlobalLineoutAttributesObserver = 0;
}

PyMethodDef *
PyGlobalLineoutAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GlobalLineoutAttributesMethods;
}

bool
PyGlobalLineoutAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &GlobalLineoutAttributesType);
}

GlobalLineoutAttributes *
PyGlobalLineoutAttributes_FromPyObject(PyObject *obj)
{
    GlobalLineoutAttributesObject *obj2 = (GlobalLineoutAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyGlobalLineoutAttributes_New()
{
    return NewGlobalLineoutAttributes(0);
}

PyObject *
PyGlobalLineoutAttributes_Wrap(const GlobalLineoutAttributes *attr)
{
    return WrapGlobalLineoutAttributes(attr);
}

void
PyGlobalLineoutAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    GlobalLineoutAttributesObject *obj2 = (GlobalLineoutAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyGlobalLineoutAttributes_SetDefaults(const GlobalLineoutAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GlobalLineoutAttributes(*atts);
}

