// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyText3DObject.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// Macros that let us access the AnnotationObject and store the fields
// we care about into the available fields.
#define GetPreserveOrientation GetOptions().GetEntry("preserveOrientation")->AsBool
#define SetPreserveOrientation GetOptions().GetEntry("preserveOrientation")->SetValue

#define GetRotations GetPosition2
#define SetRotations SetPosition2

// The flag that lets us switch between relative and fixed heights.
#define GetHeightMode GetOptions().GetEntry("useRelativeHeight")->AsBool
#define SetHeightMode GetOptions().GetEntry("useRelativeHeight")->SetValue

// Relative scale will scale the text as a percentage of the bbox diagonal
#define GetRelativeHeight GetOptions().GetEntry("relativeHeight")->AsInt
#define SetRelativeHeight GetOptions().GetEntry("relativeHeight")->SetValue

// Fixed height in world coordinates.
#define GetFixedHeight   GetOptions().GetEntry("fixedHeight")->AsDouble
#define SetFixedHeight   GetOptions().GetEntry("fixedHeight")->SetValue

// Functions that we need in visitmodule.C
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);

// ****************************************************************************
// Module: PyText3DObject
//
// Purpose: 
//   This class defines a general set of attributes that are used to set the attributes for all annotation objects.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Nov 12 16:12:12 PST 2007
//
// ****************************************************************************

//
// This struct contains the Python type information and a Text3DObject.
//
struct Text3DObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool        owns;
};

//
// Internal prototypes
//
static PyObject *NewText3DObject(); ///TODO: check fix for function signature update

std::string
PyText3DObject_ToString(const AnnotationObject *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetVisible())
        snprintf(tmpStr, 1000, "%svisible = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svisible = 0\n", prefix);
    str += tmpStr;
    if(atts->GetActive())
        snprintf(tmpStr, 1000, "%sactive = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sactive = 0\n", prefix);
    str += tmpStr;
    {   const double *position = atts->GetPosition();
        snprintf(tmpStr, 1000, "%sposition = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", position[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &text = atts->GetText();
        snprintf(tmpStr, 1000, "%stext = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < text.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", text[i].c_str());
            str += tmpStr;
            if(i < text.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const unsigned char *textColor = atts->GetTextColor().GetColor();
    snprintf(tmpStr, 1000, "%stextColor = (%d, %d, %d, %d)\n", prefix, int(textColor[0]), int(textColor[1]), int(textColor[2]), int(textColor[3]));
    str += tmpStr;
    if(atts->GetUseForegroundForTextColor())
        snprintf(tmpStr, 1000, "%suseForegroundForTextColor = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseForegroundForTextColor = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPreserveOrientation())
        snprintf(tmpStr, 1000, "%spreserveOrientation = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spreserveOrientation = 0\n", prefix);
    str += tmpStr;
    {   const double *rotations = atts->GetRotations();
        snprintf(tmpStr, 1000, "%srotations = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", rotations[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *heightMode_names = "Fixed, Relative";
    if(atts->GetHeightMode()) //Text3DObject::Relative)
    {
        snprintf(tmpStr, 1000, "%sheightMode = %sRelative  # %s\n", prefix, prefix, heightMode_names);
        str += tmpStr;
    }
    else
    {
        snprintf(tmpStr, 1000, "%sheightMode = %sFixed  # %s\n", prefix, prefix, heightMode_names);
        str += tmpStr;
    }

    snprintf(tmpStr, 1000, "%srelativeHeight = %g\n", prefix, double(atts->GetRelativeHeight())/100.);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sfixedHeight = %g\n", prefix, atts->GetFixedHeight());
    str += tmpStr;
    return str;
}

static PyObject *
Text3DObject_Notify(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_SetVisible(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetVisible(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

static PyObject *
Text3DObject_SetActive(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetActive(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
Text3DObject_SetPosition(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    double *dvals = obj->data->GetPosition();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetPosition(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(3);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(position[i]));
    return retval;
}

static PyObject *
Text3DObject_SetText(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the text in the object.
/*CUSTOM*/
    stringVector s; s.push_back(str);
    obj->data->SetText(s);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetText(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
/*CUSTOM*/
    const stringVector &s = obj->data->GetText();
    PyObject *retval = PyString_FromString(s.size() > 0 ? s[0].c_str(): "");
    return retval;
}

static PyObject *
Text3DObject_SetTextColor(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the textColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTextColor(ca);

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetTextColor(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the textColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *textColor = obj->data->GetTextColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(textColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(textColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(textColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(textColor[3])));
    return retval;
}

static PyObject *
Text3DObject_SetUseForegroundForTextColor(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundForTextColor in the object.
    obj->data->SetUseForegroundForTextColor(ival != 0);

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetUseForegroundForTextColor(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundForTextColor()?1L:0L);
    return retval;
}

static PyObject *
Text3DObject_SetPreserveOrientation(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the preserveOrientation in the object.
    obj->data->SetPreserveOrientation(ival != 0);

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetPreserveOrientation(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPreserveOrientation()?1L:0L);
    return retval;
}

static PyObject *
Text3DObject_SetRotations(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    double dvals[3];
    dvals[0] = obj->data->GetRotations()[0];
    dvals[1] = obj->data->GetRotations()[1];
    dvals[2] = obj->data->GetRotations()[2];
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotations in the object as modified.
    obj->data->SetRotations(dvals);

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetRotations(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the rotations.
    PyObject *retval = PyTuple_New(3);
    const double *rotations = obj->data->GetRotations();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rotations[i]));
    return retval;
}

static PyObject *
Text3DObject_SetHeightMode(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the heightMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetHeightMode(ival == 1);
    else
    {
        fprintf(stderr, "An invalid heightMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Relative, Fixed.");
        return NULL;
    }
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetHeightMode(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHeightMode()));
    return retval;
}

static PyObject *
Text3DObject_SetRelativeHeight(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relativeHeight in the object.
    obj->data->SetRelativeHeight((int)(dval * 100));

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetRelativeHeight(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(
         double(obj->data->GetRelativeHeight())/100.);
    return retval;
}

static PyObject *
Text3DObject_SetFixedHeight(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the fixedHeight in the object.
    obj->data->SetFixedHeight(dval);

/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Text3DObject_GetFixedHeight(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFixedHeight());
    return retval;
}

/*CUSTOM*/
static PyObject *
Text3DObject_Delete(PyObject *self, PyObject *args)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)self;

    // Tell the VisIt module to decrement the reference count for the
    // AnnotationObject pointed to by obj->data. If there are no more
    // references, this object will own it.
    obj->owns = DeleteAnnotationObjectHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef Text3DObject_methods[] = {
    {"Notify", Text3DObject_Notify, METH_VARARGS},
    {"SetVisible", Text3DObject_SetVisible, METH_VARARGS},
    {"GetVisible", Text3DObject_GetVisible, METH_VARARGS},
    {"SetActive", Text3DObject_SetActive, METH_VARARGS},
    {"GetActive", Text3DObject_GetActive, METH_VARARGS},
    {"SetPosition", Text3DObject_SetPosition, METH_VARARGS},
    {"GetPosition", Text3DObject_GetPosition, METH_VARARGS},
    {"SetText", Text3DObject_SetText, METH_VARARGS},
    {"GetText", Text3DObject_GetText, METH_VARARGS},
    {"SetTextColor", Text3DObject_SetTextColor, METH_VARARGS},
    {"GetTextColor", Text3DObject_GetTextColor, METH_VARARGS},
    {"SetUseForegroundForTextColor", Text3DObject_SetUseForegroundForTextColor, METH_VARARGS},
    {"GetUseForegroundForTextColor", Text3DObject_GetUseForegroundForTextColor, METH_VARARGS},
    {"SetPreserveOrientation", Text3DObject_SetPreserveOrientation, METH_VARARGS},
    {"GetPreserveOrientation", Text3DObject_GetPreserveOrientation, METH_VARARGS},
    {"SetRotations", Text3DObject_SetRotations, METH_VARARGS},
    {"GetRotations", Text3DObject_GetRotations, METH_VARARGS},
    {"SetHeightMode", Text3DObject_SetHeightMode, METH_VARARGS},
    {"GetHeightMode", Text3DObject_GetHeightMode, METH_VARARGS},
    {"SetRelativeHeight", Text3DObject_SetRelativeHeight, METH_VARARGS},
    {"GetRelativeHeight", Text3DObject_GetRelativeHeight, METH_VARARGS},
    {"SetFixedHeight", Text3DObject_SetFixedHeight, METH_VARARGS},
    {"GetFixedHeight", Text3DObject_GetFixedHeight, METH_VARARGS},
    {"Delete", Text3DObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
Text3DObject_dealloc(PyObject *v)
{
   Text3DObjectObject *obj = (Text3DObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
Text3DObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((Text3DObjectObject *)v)->data;
    AnnotationObject *b = ((Text3DObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
Text3DObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return Text3DObject_GetVisible(self, NULL);
    if(strcmp(name, "active") == 0)
        return Text3DObject_GetActive(self, NULL);
    if(strcmp(name, "position") == 0)
        return Text3DObject_GetPosition(self, NULL);
    if(strcmp(name, "text") == 0)
        return Text3DObject_GetText(self, NULL);
    if(strcmp(name, "textColor") == 0)
        return Text3DObject_GetTextColor(self, NULL);
    if(strcmp(name, "useForegroundForTextColor") == 0)
        return Text3DObject_GetUseForegroundForTextColor(self, NULL);
    if(strcmp(name, "preserveOrientation") == 0)
        return Text3DObject_GetPreserveOrientation(self, NULL);
    if(strcmp(name, "rotations") == 0)
        return Text3DObject_GetRotations(self, NULL);
    if(strcmp(name, "heightMode") == 0)
        return Text3DObject_GetHeightMode(self, NULL);
    if(strcmp(name, "Relative") == 0)
        return PyInt_FromLong(1); //long(Text3DObject::Relative));
    else if(strcmp(name, "Fixed") == 0)
        return PyInt_FromLong(0); //long(Text3DObject::Fixed));

    if(strcmp(name, "relativeHeight") == 0)
        return Text3DObject_GetRelativeHeight(self, NULL);
    if(strcmp(name, "fixedHeight") == 0)
        return Text3DObject_GetFixedHeight(self, NULL);

    return Py_FindMethod(Text3DObject_methods, self, name);
}

static int
Text3DObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "visible") == 0)
        retval = (Text3DObject_SetVisible(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (Text3DObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "position") == 0)
        retval = (Text3DObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "text") == 0)
        retval = (Text3DObject_SetText(self, tuple) != NULL);
    else if(strcmp(name, "textColor") == 0)
        retval = (Text3DObject_SetTextColor(self, tuple) != NULL);
    else if(strcmp(name, "useForegroundForTextColor") == 0)
        retval = (Text3DObject_SetUseForegroundForTextColor(self, tuple) != NULL);
    else if(strcmp(name, "preserveOrientation") == 0)
        retval = (Text3DObject_SetPreserveOrientation(self, tuple) != NULL);
    else if(strcmp(name, "rotations") == 0)
        retval = (Text3DObject_SetRotations(self, tuple) != NULL);
    else if(strcmp(name, "heightMode") == 0)
        retval = (Text3DObject_SetHeightMode(self, tuple) != NULL);
    else if(strcmp(name, "relativeHeight") == 0)
        retval = (Text3DObject_SetRelativeHeight(self, tuple) != NULL);
    else if(strcmp(name, "fixedHeight") == 0)
        retval = (Text3DObject_SetFixedHeight(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
Text3DObject_print(PyObject *v, FILE *fp, int flags)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)v;
    fprintf(fp, "%s", PyText3DObject_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
Text3DObject_str(PyObject *v)
{
    Text3DObjectObject *obj = (Text3DObjectObject *)v;
    return PyString_FromString(PyText3DObject_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *Text3DObject_Purpose = "This class defines an interface for controlling Text3D annotation objects.";
#else
static char *Text3DObject_Purpose = "This class defines an interface for controlling Text3D annotation objects.";
#endif

//
// The type description structure
//
static PyTypeObject Text3DObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "Text3DObject",                    // tp_name
    sizeof(Text3DObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)Text3DObject_dealloc,  // tp_dealloc
    (printfunc)Text3DObject_print,     // tp_print
    (getattrfunc)Text3DObject_getattr, // tp_getattr
    (setattrfunc)Text3DObject_setattr, // tp_setattr
    (cmpfunc)Text3DObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)Text3DObject_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    Text3DObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PyObject *
NewText3DObject()
{
    Text3DObjectObject *newObject;
    newObject = PyObject_NEW(Text3DObjectObject, &Text3DObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = new AnnotationObject;
    newObject->data->SetObjectType(AnnotationObject::Text3D);
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapText3DObject(AnnotationObject *annot)
{
    Text3DObjectObject *newObject;
    newObject = PyObject_NEW(Text3DObjectObject, &Text3DObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = annot;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

bool
PyText3DObject_Check(PyObject *obj)
{
    return (obj->ob_type == &Text3DObjectType);
}

AnnotationObject *
PyText3DObject_FromPyObject(PyObject *obj)
{
    Text3DObjectObject *obj2 = (Text3DObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyText3DObject_NewPyObject()
{
    return NewText3DObject();
}

PyObject *
PyText3DObject_WrapPyObject(AnnotationObject *attr)
{
    return WrapText3DObject(attr);
}

