// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyLineObject.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// Functions that we need in visitmodule.C
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);

// ****************************************************************************
// Module: PyLineObject
//
// Purpose: 
//   Line Annotation Object
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Sep 1 14:56:14 PST 2004
//
// Modifications:
//
//   Hank Childs, Wed Jun 14 17:37:03 PDT 2006
//   Call UpdateAnnotationsHelper more often (this will cause "Set..." calls
//   to actually go to the viewer).
//
// ****************************************************************************

//
// This struct contains the Python type information and a LineObject.
//
struct LineObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewLineObject();

static PyObject *
LineObject_SetVisible(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetVisible(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

static PyObject *
LineObject_SetActive(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetActive(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
LineObject_SetPosition(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    double *dvals = obj->data->GetPosition();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetPosition(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(2);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position[i])));
    return retval;
}

static PyObject *
LineObject_SetPosition2(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    double *dvals = obj->data->GetPosition2();
/* CUSTOM - Had to make position dd, not ddd. */
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position2 in the object as modified.
    obj->data->SelectPosition2();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetPosition2(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position2.
    PyObject *retval = PyTuple_New(2);
    const double *position2 = obj->data->GetPosition2();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position2[i])));
    return retval;
}

static PyObject *
LineObject_SetWidth(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
    obj->data->GetOptions().GetEntry("width")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetWidth(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntAttribute1()));
    return retval;
}

static PyObject *
LineObject_SetColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
/* CUSTOM */
    obj->data->SetColor1(ca);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}

static PyObject *
LineObject_SetUseForegroundForLineColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundForTextColor in the object.
    obj->data->SetUseForegroundForTextColor(ival != 0);

    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetUseForegroundForLineColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundForTextColor()?1L:0L);
    return retval;
}

static PyObject *
LineObject_SetOpacity(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacity in the object.
/* CUSTOM */
    obj->data->GetColor1().SetAlpha(ival);
    //obj->data->SetOpacity(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetOpacity(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor1().Alpha()));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacity()));
    return retval;
}

static PyObject *
LineObject_SetBeginArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the beginArrow in the object.
    obj->data->GetOptions().GetEntry("beginArrow")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetBeginArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("beginArrow")->AsInt()));
    return retval;
}

static PyObject *
LineObject_SetEndArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endArrow in the object.
    obj->data->GetOptions().GetEntry("endArrow")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetEndArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("endArrow")->AsInt()));
    return retval;
}

/* CUSTOM - Added this... */
static PyObject *
LineObject_Delete(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    // Tell the VisIt module to decrement the reference count for the
    // AnnotationObject pointed to by obj->data. If there are no more
    // references, this object will own it.
    obj->owns = DeleteAnnotationObjectHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef LineObject_methods[] = {
    {"SetVisible", LineObject_SetVisible, METH_VARARGS},
    {"GetVisible", LineObject_GetVisible, METH_VARARGS},
    {"SetActive", LineObject_SetActive, METH_VARARGS},
    {"GetActive", LineObject_GetActive, METH_VARARGS},
    {"SetPosition", LineObject_SetPosition, METH_VARARGS},
    {"GetPosition", LineObject_GetPosition, METH_VARARGS},
    {"SetPosition2", LineObject_SetPosition2, METH_VARARGS},
    {"GetPosition2", LineObject_GetPosition2, METH_VARARGS},
    {"SetWidth", LineObject_SetWidth, METH_VARARGS},
    {"GetWidth", LineObject_GetWidth, METH_VARARGS},
    {"SetUseForegroundForLineColor", LineObject_SetUseForegroundForLineColor, METH_VARARGS},
    {"GetUseForegroundForLineColor", LineObject_GetUseForegroundForLineColor, METH_VARARGS},
    {"SetColor", LineObject_SetColor, METH_VARARGS},
    {"GetColor", LineObject_GetColor, METH_VARARGS},
    {"SetOpacity", LineObject_SetOpacity, METH_VARARGS},
    {"GetOpacity", LineObject_GetOpacity, METH_VARARGS},
    {"SetBeginArrow", LineObject_SetBeginArrow, METH_VARARGS},
    {"GetBeginArrow", LineObject_GetBeginArrow, METH_VARARGS},
    {"SetEndArrow", LineObject_SetEndArrow, METH_VARARGS},
    {"GetEndArrow", LineObject_GetEndArrow, METH_VARARGS},
    {"Delete", LineObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LineObject_dealloc(PyObject *v)
{
   LineObjectObject *obj = (LineObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
LineObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((LineObjectObject *)v)->data;
    AnnotationObject *b = ((LineObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
LineObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return LineObject_GetVisible(self, NULL);
    if(strcmp(name, "active") == 0)
        return LineObject_GetActive(self, NULL);
    if(strcmp(name, "position") == 0)
        return LineObject_GetPosition(self, NULL);
    if(strcmp(name, "position2") == 0)
        return LineObject_GetPosition2(self, NULL);
    if(strcmp(name, "width") == 0)
        return LineObject_GetWidth(self, NULL);
    if(strcmp(name, "useForegroundForLineColor") == 0)
        return LineObject_GetUseForegroundForLineColor(self, NULL);
    if(strcmp(name, "color") == 0)
        return LineObject_GetColor(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return LineObject_GetOpacity(self, NULL);
    if(strcmp(name, "beginArrow") == 0)
        return LineObject_GetBeginArrow(self, NULL);
    if(strcmp(name, "endArrow") == 0)
        return LineObject_GetEndArrow(self, NULL);

    return Py_FindMethod(LineObject_methods, self, name);
}

static int
LineObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "visible") == 0)
        retval = (LineObject_SetVisible(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (LineObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "position") == 0)
        retval = (LineObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "position2") == 0)
        retval = (LineObject_SetPosition2(self, tuple) != NULL);
    else if(strcmp(name, "width") == 0)
        retval = (LineObject_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "useForegroundForLineColor") == 0)
        retval = (LineObject_SetUseForegroundForLineColor(self, tuple) != NULL);
    else if(strcmp(name, "color") == 0)
        retval = (LineObject_SetColor(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (LineObject_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "beginArrow") == 0)
        retval = (LineObject_SetBeginArrow(self, tuple) != NULL);
    else if(strcmp(name, "endArrow") == 0)
        retval = (LineObject_SetEndArrow(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
LineObject_print(PyObject *v, FILE *fp, int flags)
{
    LineObjectObject *obj = (LineObjectObject *)v;

    if(obj->data->GetVisible())
        fprintf(fp, "visible = 1\n");
    else
        fprintf(fp, "visible = 0\n");
    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");
    {
        const double *position = obj->data->GetPosition();
        fprintf(fp, "position = (%g, %g)\n", position[0], position[1]);
    }
    {
        const double *position2 = obj->data->GetPosition2();
        fprintf(fp, "position2 = (%g, %g)\n", position2[0], position2[1]);
    }
    fprintf(fp, "width = %d\n", obj->data->GetOptions().GetEntry("width")->AsInt());
    if (obj->data->GetUseForegroundForTextColor())
        fprintf(fp, "useForegroundForLineColor = 1\n");
    else 
        fprintf(fp, "useForegroundForLineColor = 0\n");
    const unsigned char *color = obj->data->GetColor1().GetColor();
    fprintf(fp, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    fprintf(fp, "opacity = %d\n", obj->data->GetColor1().Alpha());
    fprintf(fp, "beginArrow = %d\n", obj->data->GetOptions().GetEntry("beginArrow")->AsInt());
    fprintf(fp, "endArrow = %d\n", obj->data->GetOptions().GetEntry("endArrow")->AsInt());

    return 0;
}

PyObject *
PyLineObject_StringRepresentation(const AnnotationObject *atts)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetVisible())
        snprintf(tmpStr, 1000, "visible = 1\n");
    else
        snprintf(tmpStr, 1000, "visible = 0\n");
    str += tmpStr;
    if(atts->GetActive())
        snprintf(tmpStr, 1000, "active = 1\n");
    else
        snprintf(tmpStr, 1000, "active = 0\n");
    str += tmpStr;
    const double *position = atts->GetPosition();
    snprintf(tmpStr, 1000, "position = (%g, %g)\n", position[0], position[1]);
    str += tmpStr;
    const double *position2 = atts->GetPosition2();
    snprintf(tmpStr, 1000, "position2 = (%g, %g)\n", position2[0], position2[1]);
    str += tmpStr;
    snprintf(tmpStr, 1000, "width = %d\n", atts->GetIntAttribute1());
    str += tmpStr;
    if(atts->GetUseForegroundForTextColor())
        snprintf(tmpStr, 1000, "useForegroundForLineColor = 1\n");
    else
        snprintf(tmpStr, 1000, "useForegroundForLineColor = 0\n");
    str += tmpStr;
 
    const unsigned char *color = atts->GetColor1().GetColor();
    snprintf(tmpStr, 1000, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    str += tmpStr;
    snprintf(tmpStr, 1000, "opacity = %d\n", atts->GetColor1().Alpha());
    str += tmpStr;
    snprintf(tmpStr, 1000, "beginArrow = %d\n", atts->GetOptions().GetEntry("beginArrow")->AsInt());
    str += tmpStr;
    snprintf(tmpStr, 1000, "endArrow = %d\n", atts->GetOptions().GetEntry("endArrow")->AsInt());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
LineObject_str(PyObject *v)
{
    LineObjectObject *obj = (LineObjectObject *)v;
    return PyLineObject_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LineObject_Purpose = "This class defines defines an interface to a 2D line object.";
#else
static char *LineObject_Purpose = "This class defines defines an interface to a 2D line object.";
#endif

//
// The type description structure
//
static PyTypeObject LineObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LineObject",                    // tp_name
    sizeof(LineObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LineObject_dealloc,  // tp_dealloc
    (printfunc)LineObject_print,     // tp_print
    (getattrfunc)LineObject_getattr, // tp_getattr
    (setattrfunc)LineObject_setattr, // tp_setattr
    (cmpfunc)LineObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LineObject_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LineObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PyObject *
NewLineObject()
{
    LineObjectObject *newObject;
    newObject = PyObject_NEW(LineObjectObject, &LineObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = new AnnotationObject;
    newObject->data->SetObjectType(AnnotationObject::Line2D);
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapLineObject(AnnotationObject *annot)
{
    LineObjectObject *newObject;
    newObject = PyObject_NEW(LineObjectObject, &LineObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = annot;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

bool
PyLineObject_Check(PyObject *obj)
{
    return (obj->ob_type == &LineObjectType);
}

AnnotationObject *
PyLineObject_FromPyObject(PyObject *obj)
{
    LineObjectObject *obj2 = (LineObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyLineObject_NewPyObject()
{
    return NewLineObject();
}

PyObject *
PyLineObject_WrapPyObject(AnnotationObject *annot)
{
    return WrapLineObject(annot);
}

