// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyLine3DObject.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>
#include <MapNode.h>

// Functions that we need in visitmodule.C
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);

// ****************************************************************************
// Module: PyLine3DObject
//
// Purpose: 
//   This class defines a general set of attributes that are used to set the attributes for all annotation objects.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AnnotationObject.
//
struct Line3DObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool        owns;
};

//
// Internal prototypes
//
static PyObject *NewLine3DObject();

static PyObject *
Line3DObject_SetVisible(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetVisible(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

static PyObject *
Line3DObject_SetActive(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetActive(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
Line3DObject_SetPosition(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double *dvals = obj->data->GetPosition();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetPosition(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(3);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position[i])));
    return retval;
}

static PyObject *
Line3DObject_SetPosition2(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double *dvals = obj->data->GetPosition2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position2 in the object as modified.
    obj->data->SelectPosition2();
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetPosition2(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position2.
    PyObject *retval = PyTuple_New(3);
    const double *position2 = obj->data->GetPosition2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position2[i])));
    return retval;
}

static PyObject *
Line3DObject_SetLineType(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if (ival >= 0 && ival <= 2)
    {
        obj->data->GetOptions().GetEntry("lineType")->SetValue(ival);
        UpdateAnnotationHelper(obj->data);
    }
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                "Valid values are in the range of [0,1]. "
                "You can also use the following names: "
                "\"LINE\", \"TUBE\"\n");
        return NULL;
    }


    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetLineType(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("lineType")->AsInt()));
    return retval;
}

static PyObject *
Line3DObject_SetWidth(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
    obj->data->GetOptions().GetEntry("width")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetWidth(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("width")->AsInt()));
    return retval;
}

static PyObject *
Line3DObject_SetTubeQuality(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    if (ival >= 0 && ival <= 2)
    {
        obj->data->GetOptions().GetEntry("tubeQuality")->SetValue(ival);
        UpdateAnnotationHelper(obj->data);
    }
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                "Valid values are in the range of [0,2]. "
                "You can also use the following names: "
                "\"LOW\", \"MEDIUM\", \"HIGH\"\n");
        return NULL;
    }


    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetTubeQuality(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("tubeQuality")->AsInt()));
    return retval;
}

static PyObject *
Line3DObject_SetTubeRadius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;
    obj->data->GetOptions().GetEntry("tubeRadius")->SetValue(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetTubeRadius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOptions().GetEntry("tubeRadius")->AsDouble());
    return retval;
}

static PyObject *
Line3DObject_SetColor(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the Color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetColor1(ca);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetColor(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}

static PyObject *
Line3DObject_SetUseForegroundForLineColor(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundForTextColor in the object.
    obj->data->SetUseForegroundForTextColor(ival != 0);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetUseForegroundForLineColor(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundForTextColor()?1L:0L);
    return retval;
}

static PyObject *
Line3DObject_SetOpacity(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacity in the object.
    obj->data->GetColor1().SetAlpha(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetOpacity(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor1().Alpha()));
    return retval;
}

static PyObject *
Line3DObject_SetArrow1(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow1")->SetValue((bool)ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow1(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("arrow1")->AsBool()));
    return retval;
}

static PyObject *
Line3DObject_SetArrow1Resolution(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow1Resolution")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow1Resolution(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("arrow1Resolution")->AsInt()));
    return retval;
}


static PyObject *
Line3DObject_SetArrow1Radius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow1Radius")->SetValue(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow1Radius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOptions().GetEntry("arrow1Radius")->AsDouble());
    return retval;
}

static PyObject *
Line3DObject_SetArrow1Height(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow1Height")->SetValue(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow1Height(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOptions().GetEntry("arrow1Height")->AsDouble());
    return retval;
}

static PyObject *
Line3DObject_SetArrow2(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow2")->SetValue((bool)ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow2(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("arrow2")->AsInt()));
    return retval;
}

static PyObject *
Line3DObject_SetArrow2Resolution(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow2Resolution")->SetValue(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow2Resolution(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOptions().GetEntry("arrow2Resolution")->AsInt()));
    return retval;
}


static PyObject *
Line3DObject_SetArrow2Radius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow2Radius")->SetValue(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow2Radius(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOptions().GetEntry("arrow2Radius")->AsDouble());
    return retval;
}

static PyObject *
Line3DObject_SetArrow2Height(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    obj->data->GetOptions().GetEntry("arrow2Height")->SetValue(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
Line3DObject_GetArrow2Height(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOptions().GetEntry("arrow2Height")->AsDouble());
    return retval;
}

static PyObject *
Line3DObject_Delete(PyObject *self, PyObject *args)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)self;

    // Tell the VisIt module to decrement the reference count for the
    // AnnotationObject pointed to by obj->data. If there are no more
    // references, this object will own it.
    obj->owns = DeleteAnnotationObjectHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef Line3DObject_methods[] = {
    {"SetVisible", Line3DObject_SetVisible, METH_VARARGS},
    {"GetVisible", Line3DObject_GetVisible, METH_VARARGS},
    {"SetActive", Line3DObject_SetActive, METH_VARARGS},
    {"GetActive", Line3DObject_GetActive, METH_VARARGS},
    {"SetPosition", Line3DObject_SetPosition, METH_VARARGS},
    {"GetPosition", Line3DObject_GetPosition, METH_VARARGS},
    {"SetPosition2", Line3DObject_SetPosition2, METH_VARARGS},
    {"GetPosition2", Line3DObject_GetPosition2, METH_VARARGS},
    {"SetLineType", Line3DObject_SetLineType, METH_VARARGS},
    {"GetLineType", Line3DObject_GetLineType, METH_VARARGS},
    {"SetWidth", Line3DObject_SetWidth, METH_VARARGS},
    {"GetWidth", Line3DObject_GetWidth, METH_VARARGS},
    {"SetTubeQuality", Line3DObject_SetTubeQuality, METH_VARARGS},
    {"GetTubeQuality", Line3DObject_GetTubeQuality, METH_VARARGS},
    {"SetTubeRadius", Line3DObject_SetTubeRadius, METH_VARARGS},
    {"GetTubeRadius", Line3DObject_GetTubeRadius, METH_VARARGS},
    {"SetUseForegroundForLineColor", Line3DObject_SetUseForegroundForLineColor, METH_VARARGS},
    {"GetUseForegroundForLineColor", Line3DObject_GetUseForegroundForLineColor, METH_VARARGS},
    {"SetColor", Line3DObject_SetColor, METH_VARARGS},
    {"GetColor", Line3DObject_GetColor, METH_VARARGS},
    {"SetOpacity", Line3DObject_SetOpacity, METH_VARARGS},
    {"GetOpacity", Line3DObject_GetOpacity, METH_VARARGS},
    {"SetArrow1", Line3DObject_SetArrow1, METH_VARARGS},
    {"GetArrow1", Line3DObject_GetArrow1, METH_VARARGS},
    {"SetArrow1Resolution", Line3DObject_SetArrow1Resolution, METH_VARARGS},
    {"GetArrow1Resolution", Line3DObject_GetArrow1Resolution, METH_VARARGS},
    {"SetArrow1Radius", Line3DObject_SetArrow1Radius, METH_VARARGS},
    {"GetArrow1Radius", Line3DObject_GetArrow1Radius, METH_VARARGS},
    {"SetArrow1Height", Line3DObject_SetArrow1Height, METH_VARARGS},
    {"GetArrow1Height", Line3DObject_GetArrow1Height, METH_VARARGS},
    {"SetArrow2", Line3DObject_SetArrow2, METH_VARARGS},
    {"GetArrow2", Line3DObject_GetArrow2, METH_VARARGS},
    {"SetArrow2Resolution", Line3DObject_SetArrow2Resolution, METH_VARARGS},
    {"GetArrow2Resolution", Line3DObject_GetArrow2Resolution, METH_VARARGS},
    {"SetArrow2Radius", Line3DObject_SetArrow2Radius, METH_VARARGS},
    {"GetArrow2Radius", Line3DObject_GetArrow2Radius, METH_VARARGS},
    {"SetArrow2Height", Line3DObject_SetArrow2Height, METH_VARARGS},
    {"GetArrow2Height", Line3DObject_GetArrow2Height, METH_VARARGS},
    {"Delete", Line3DObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
Line3DObject_dealloc(PyObject *v)
{
   Line3DObjectObject *obj = (Line3DObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
Line3DObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((Line3DObjectObject *)v)->data;
    AnnotationObject *b = ((Line3DObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
Line3DObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return Line3DObject_GetVisible(self, NULL);
    if(strcmp(name, "active") == 0)
        return Line3DObject_GetActive(self, NULL);
    if(strcmp(name, "point1") == 0)
        return Line3DObject_GetPosition(self, NULL);
    if(strcmp(name, "point2") == 0)
        return Line3DObject_GetPosition2(self, NULL);
    if(strcmp(name, "lineType") == 0)
        return Line3DObject_GetLineType(self, NULL);
    if(strcmp(name, "LINE") == 0)
        return PyInt_FromLong(long(0));
    if(strcmp(name, "TUBE") == 0)
        return PyInt_FromLong(long(1));
    if(strcmp(name, "width") == 0)
        return Line3DObject_GetWidth(self, NULL);
    if(strcmp(name, "tubeQuality") == 0)
        return Line3DObject_GetTubeQuality(self, NULL);
    if(strcmp(name, "LOW") == 0)
        return PyInt_FromLong(long(0));
    if(strcmp(name, "MEDIUM") == 0)
        return PyInt_FromLong(long(1));
    if(strcmp(name, "HIGH") == 0)
        return PyInt_FromLong(long(2));
    if(strcmp(name, "tubeRadius") == 0)
        return Line3DObject_GetTubeRadius(self, NULL);

    if(strcmp(name, "useForegroundForLineColor") == 0)
        return Line3DObject_GetUseForegroundForLineColor(self, NULL);
    if(strcmp(name, "color") == 0)
        return Line3DObject_GetColor(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return Line3DObject_GetOpacity(self, NULL);
    if(strcmp(name, "arrow1") == 0)
        return Line3DObject_GetArrow1(self, NULL);
    if(strcmp(name, "arrow1Resolution") == 0)
        return Line3DObject_GetArrow1Resolution(self, NULL);
    if(strcmp(name, "arrow1Radius") == 0)
        return Line3DObject_GetArrow1Radius(self, NULL);
    if(strcmp(name, "arrow1Height") == 0)
        return Line3DObject_GetArrow1Height(self, NULL);
    if(strcmp(name, "arrow2") == 0)
        return Line3DObject_GetArrow2(self, NULL);
    if(strcmp(name, "arrow2Resolution") == 0)
        return Line3DObject_GetArrow2Resolution(self, NULL);
    if(strcmp(name, "arrow2Radius") == 0)
        return Line3DObject_GetArrow2Radius(self, NULL);
    if(strcmp(name, "arrow2Height") == 0)
        return Line3DObject_GetArrow2Height(self, NULL);


    return Py_FindMethod(Line3DObject_methods, self, name);
}

static int
Line3DObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "visible") == 0)
        retval = (Line3DObject_SetVisible(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (Line3DObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "point1") == 0)
        retval = (Line3DObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "point2") == 0)
        retval = (Line3DObject_SetPosition2(self, tuple) != NULL);
    else if(strcmp(name, "lineType") == 0)
        retval = (Line3DObject_SetLineType(self, tuple) != NULL);
    else if(strcmp(name, "width") == 0)
        retval = (Line3DObject_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "tubeQuality") == 0)
        retval = (Line3DObject_SetTubeQuality(self, tuple) != NULL);
    else if(strcmp(name, "tubeRadius") == 0)
        retval = (Line3DObject_SetTubeRadius(self, tuple) != NULL);
    else if(strcmp(name, "useForegroundForLineColor") == 0)
        retval = (Line3DObject_SetUseForegroundForLineColor(self, tuple) != NULL);
    else if(strcmp(name, "color") == 0)
        retval = (Line3DObject_SetColor(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (Line3DObject_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "arrow1") == 0)
        retval = (Line3DObject_SetArrow1(self, tuple) != NULL);
    else if(strcmp(name, "arrow1Resolution") == 0)
        retval = (Line3DObject_SetArrow1Resolution(self, tuple) != NULL);
    else if(strcmp(name, "arrow1Radius") == 0)
        retval = (Line3DObject_SetArrow1Radius(self, tuple) != NULL);
    else if(strcmp(name, "arrow1Height") == 0)
        retval = (Line3DObject_SetArrow1Height(self, tuple) != NULL);
    else if(strcmp(name, "arrow2") == 0)
        retval = (Line3DObject_SetArrow2(self, tuple) != NULL);
    else if(strcmp(name, "arrow2Resolution") == 0)
        retval = (Line3DObject_SetArrow2Resolution(self, tuple) != NULL);
    else if(strcmp(name, "arrow2Radius") == 0)
        retval = (Line3DObject_SetArrow2Radius(self, tuple) != NULL);
    else if(strcmp(name, "arrow2Height") == 0)
        retval = (Line3DObject_SetArrow2Height(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
Line3DObject_print(PyObject *v, FILE *fp, int flags)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)v;
    const MapNode &opts = obj->data->GetOptions();

    if(obj->data->GetVisible())
        fprintf(fp, "visible = 1\n");
    else
        fprintf(fp, "visible = 0\n");
    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");
    {
        const double *pos = obj->data->GetPosition();
        fprintf(fp, "point1 = (%g, %g, %g)\n", pos[0], pos[1], pos[2]);
    }
    {
        const double *pos2 = obj->data->GetPosition2();
        fprintf(fp, "point2 = (%g, %g, %g)\n",pos2[0], pos2[1], pos2[2]);
    }
    const char *type_values[] = {"LINE", "TUBE"};
    fprintf(fp, "lineType = %s  # LINE, TUBE\n", type_values[opts.GetEntry("lineType")->AsInt()]);
    fprintf(fp, "width = %d\n", opts.GetEntry("width")->AsInt());


    const char *qual_values[] = {"LOW", "MEDIUM", "HIGH"};
    fprintf(fp, "tubeQuality = %s  # LOW, MEDIUM, HIGH\n", qual_values[opts.GetEntry("tubeQuality")->AsInt()]);
    fprintf(fp, "tubeRadius = %lg\n", opts.GetEntry("tubeRadius")->AsDouble());
    
    if (obj->data->GetUseForegroundForTextColor())
        fprintf(fp, "useForegroundForLineColor = 1\n");
    else 
        fprintf(fp, "useForegroundForLineColor = 0\n");
    const unsigned char *color = obj->data->GetColor1().GetColor();
    fprintf(fp, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    fprintf(fp, "opacity = %d\n", obj->data->GetColor1().Alpha());

    fprintf(fp, "arrow1 = %d\n", opts.GetEntry("arrow1")->AsInt());
    fprintf(fp, "arrow1Resolution = %d\n", opts.GetEntry("arrow1Resolution")->AsInt());

    fprintf(fp, "arrow1Radius = %lg\n", opts.GetEntry("arrow1Radius")->AsDouble());
    fprintf(fp, "arrow1Height = %lg\n", opts.GetEntry("arrow1Height")->AsDouble());
    fprintf(fp, "arrow2 = %d\n", opts.GetEntry("arrow2")->AsInt());
    fprintf(fp, "arrow2Resolution = %d\n", opts.GetEntry("arrow2Resolution")->AsInt());
    fprintf(fp, "arrow2Radius = %lg\n", opts.GetEntry("arrow2Radius")->AsDouble());
    fprintf(fp, "arrow2Height = %lg\n", opts.GetEntry("arrow2Height")->AsDouble());
    return 0;
}

PyObject *
PyLine3DObject_StringRepresentation(const AnnotationObject *atts)
{
    std::string str; 
    char tmpStr[1000]; 
    const MapNode &opts = atts->GetOptions();

    if(atts->GetVisible())
        snprintf(tmpStr, 1000, "visible = 1\n");
    else
        snprintf(tmpStr, 1000, "visible = 0\n");
    str += tmpStr;
    if(atts->GetActive())
        snprintf(tmpStr, 1000, "active = 1\n");
    else
        snprintf(tmpStr, 1000, "active = 0\n");
    str += tmpStr;
    const double *pos= atts->GetPosition();
    snprintf(tmpStr, 1000, "point1 = (%g, %g, %g)\n", pos[0], pos[1], pos[2]);
    str += tmpStr;
    const double *pos2 = atts->GetPosition2();
    snprintf(tmpStr, 1000, "point2 = (%g, %g, %g)\n", pos2[0], pos2[1], pos2[2]);
    str += tmpStr;

    const char *type_values[] = {"LINE", "TUBE"};
    snprintf(tmpStr, 1000, "lineType = %s  # LINE, TUBE\n", type_values[opts.GetEntry("lineType")->AsInt()]);
    str += tmpStr;

    snprintf(tmpStr, 1000, "width = %d\n", opts.GetEntry("width")->AsInt());
    str += tmpStr;

    const char *qual_values[] = {"LOW", "MEDIUM", "HIGH"};
    snprintf(tmpStr, 1000, "tubeQuality = %s  # LOW, MEDIUM, HIGH\n", qual_values[opts.GetEntry("tubeQuality")->AsInt()]);
    str += tmpStr;
    snprintf(tmpStr, 1000, "tubeRadius = %lg\n", opts.GetEntry("tubeRadius")->AsDouble());
    str += tmpStr;

    if(atts->GetUseForegroundForTextColor())
        snprintf(tmpStr, 1000, "useForegroundForLineColor = 1\n");
    else
        snprintf(tmpStr, 1000, "useForegroundForLineColor = 0\n");
    str += tmpStr;
 
    const unsigned char *color = atts->GetColor1().GetColor();
    snprintf(tmpStr, 1000, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    str += tmpStr;
    snprintf(tmpStr, 1000, "opacity = %d\n", atts->GetColor1().Alpha());
    str += tmpStr;

    
    snprintf(tmpStr, 1000, "arrow1 = %d\n", opts.GetEntry("arrow1")->AsInt());
    str += tmpStr;
    snprintf(tmpStr, 1000, "arrow1Resolution = %d\n", opts.GetEntry("arrow1Resolution")->AsInt());
    str += tmpStr;
    snprintf(tmpStr, 1000, "arrow1Radius = %lg\n", opts.GetEntry("arrow1Radius")->AsDouble());
    snprintf(tmpStr, 1000, "arrow1Height = %lg\n", opts.GetEntry("arrow1Height")->AsDouble());
    str += tmpStr;
    snprintf(tmpStr, 1000, "arrow2 = %d\n", opts.GetEntry("arrow1")->AsInt());
    str += tmpStr;
    snprintf(tmpStr, 1000, "arrow2Resolution = %d\n", opts.GetEntry("arrow2Resolution")->AsInt());
    str += tmpStr;
    snprintf(tmpStr, 1000, "arrow2Radius = %lg\n", opts.GetEntry("arrow2Radius")->AsDouble());
    snprintf(tmpStr, 1000, "arrow2Height = %lg\n", opts.GetEntry("arrow2Height")->AsDouble());
    str += tmpStr;
 
    return PyString_FromString(str.c_str());
}
static PyObject *
Line3DObject_str(PyObject *v)
{
    Line3DObjectObject *obj = (Line3DObjectObject *)v;
    return PyLine3DObject_StringRepresentation(obj->data);
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *Line3DObject_Purpose = "This class defines defines an interface to a 3D line object.";
#else
static char *Line3DObject_Purpose = "This class defines defines an interface to a 3D line object.";
#endif

//
// The type description structure
//
static PyTypeObject Line3DObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "Line3DObject",                    // tp_name
    sizeof(Line3DObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)Line3DObject_dealloc,  // tp_dealloc
    (printfunc)Line3DObject_print,     // tp_print
    (getattrfunc)Line3DObject_getattr, // tp_getattr
    (setattrfunc)Line3DObject_setattr, // tp_setattr
    (cmpfunc)Line3DObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)Line3DObject_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    Line3DObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PyObject *
NewLine3DObject()
{
    Line3DObjectObject *newObject;
    newObject = PyObject_NEW(Line3DObjectObject, &Line3DObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = new AnnotationObject;
    newObject->data->SetObjectType(AnnotationObject::Line3D);
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapLine3DObject(AnnotationObject *annot)
{
    Line3DObjectObject *newObject;
    newObject = PyObject_NEW(Line3DObjectObject, &Line3DObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = annot;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

bool
PyLine3DObject_Check(PyObject *obj)
{
    return (obj->ob_type == &Line3DObjectType);
}

AnnotationObject *
PyLine3DObject_FromPyObject(PyObject *obj)
{
    Line3DObjectObject *obj2 = (Line3DObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyLine3DObject_NewPyObject()
{
    return NewLine3DObject();
}

PyObject *
PyLine3DObject_WrapPyObject(AnnotationObject *annot)
{
    return WrapLine3DObject(annot);
}

