// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.


// ***************************************************************************
// Warning: Autogenerated by /src/doc/functions_to_method_doc.py
//          ALL CHANGES TO THIS FILE WILL BE OVERWRITTEN!
//          Make changes to src/doc/cli_manual/functions.rst and run
//          functions_to_method_doc.py to update this file.
// ***************************************************************************


const char *visit_ActivateDatabase_doc = 
"ActivateDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ActivateDatabase(argument) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"argument\n"
"    The name of the database to be activated.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    ActivateDatabase returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ActivateDatabase function is used to set the active database to a\n"
"database that has been previously opened. The ActivateDatabase function\n"
"only works when you are using it to activate a database that you have\n"
"previously opened. You do not need to use this function unless you\n"
"frequently toggle between more than one database when making plots or\n"
"changing time states. While the OpenDatabase function can also be used\n"
"to set the active database, the ActivateDatabase function does not have any\n"
"side effects that would cause the time state for the new active database\n"
"to be changed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"dbs = (\"/usr/gapps/visit/data/wave.visit\", \"/usr/gapps/visit/data/curv3d.silo\")\n"
"OpenDatabase(dbs[0], 17)\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"OpenDatabase(dbs[1])\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Let's add another plot from the first database.\n"
"ActivateDatabase(dbs[0])\n"
"AddPlot(\"Mesh\", \"quadmesh\")\n"
"DrawPlots()\n"
;
const char *visit_AddArgument_doc = 
"AddArgument\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AddArgument(argument)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"argument\n"
"    A string object that is added to the viewer's command line argument list.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The AddArgument function is used to add extra command line arguments to\n"
"VisIt's viewer. This is only useful when VisIt's Python interface is\n"
"imported into a stand-alone Python interpreter because the AddArgument\n"
"function must be called before the viewer is launched. The AddArgument\n"
"function has no effect when used in VisIt's cli program because the viewer\n"
"is automatically launched before any commands are processed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.AddArgument(\"-nowin\") # Add the -nowin argument to the viewer.\n"
;
const char *visit_AddMachineProfile_doc = 
"AddMachineProfile\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AddMachineProfile(MachineProfile) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"MachineProfile\n"
"\n"
"\n"
"Description:\n"
"\n"
"Sets the input machine profile in the HostProfileList, replaces if one already exists\n"
"Otherwise adds to the list\n"
;
const char *visit_AddOperator_doc = 
"AddOperator\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AddOperator(operator) -> integer\n"
"AddOperator(operator, all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"operator\n"
"    The name of the operator to be applied.\n"
"all\n"
"    This is an optional integer argument that applies the operator to all\n"
"    plots if the value of the argument is not zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The AddOperator function returns an integer value of 1 for success and 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The AddOperator function adds a VisIt operator to the active plots. The\n"
"operator argument is a string containing the name of the operator to be\n"
"added to the active plots. The operatore name must be a valid operator\n"
"plugin name that is a member of the tuple returned by the OperatorPlugins\n"
"function. The all argument is an integer that determines\n"
"whether or not the operator is applied to all plots. If the all argument is\n"
"not provided, the operator is only added to active plots. Once the\n"
"AddOperator function is called, the desired operator is added to all\n"
"active plots unless the all argument is a non-zero value. When the all\n"
"argument is a non-zero value, the operator is applied to all plots\n"
"regardless of whether or not they are selected. Operator attributes are set\n"
"through the SetOperatorOptions function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"AddOperator(\"Slice\", 1) # Slice both plots\n"
"DrawPlots()\n"
;
const char *visit_AddPlot_doc = 
"AddPlot\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AddPlot(plotType, variableName) -> integer\n"
"AddPlot(plotType, variableName, inheritSIL) -> integer\n"
"AddPlot(plotType, variableName, inheritSIL, applyOperators) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"plotType\n"
"    The name of a valid plot plugin type.\n"
"variableName\n"
"    A valid variable name for the open database.\n"
"inheritSIL\n"
"    An integer flag indicating whether the plot should inherit the\n"
"    active plot's SIL restriction.\n"
"applyOperators\n"
"    An integer flag indicating whether the operators from the active\n"
"    plot should be applied to the new plot.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The AddPlot function returns an integer value of 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The AddPlot function creates a new plot of the specified type using a\n"
"variable from the open database. The plotType argument is a string that\n"
"contains the name of a valid plot plugin type which must be a member of the\n"
"string tuple that is returned by the PlotPlugins function.\n"
"The variableName argument is a string that contains the name of a variable\n"
"in the open database. After the AddPlot function is called, a new plot is\n"
"created and it is made the sole active plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Subset\", \"mat1\") # Create a subset plot\n"
"DrawPlots()\n"
;
const char *visit_AddWindow_doc = 
"AddWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AddWindow()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The AddWindow function creates a new visualization window and makes it the\n"
"active window. This function can be used to create up to 16 visualization\n"
"windows. After that, the AddWindow function has no effect.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.Launch()\n"
"visit.AddWindow() # Create window #2\n"
"visit.AddWindow() # Create window #3\n"
;
const char *visit_AlterDatabaseCorrelation_doc = 
"AlterDatabaseCorrelation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"AlterDatabaseCorrelation(name, databases, method) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the database correlation to be altered.\n"
"databases\n"
"    The databases argument must be a tuple or list of strings containing the\n"
"    fully qualified database names to be used in the database correlation.\n"
"method\n"
"    The method argument must be an integer in the range [0,3].\n"
"    \n"
"    \n"
"    =========================  =====\n"
"    **Correlation method**     Value\n"
"    =========================  =====\n"
"    IndexForIndexCorrelation   0\n"
"    StretchedIndexCorrelation  1\n"
"    TimeCorrelation            2\n"
"    CycleCorrelation           3\n"
"    =========================  =====\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The AlterDatabaseCorrelation function returns 1 on success and 0 on\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The AlterDatabaseCorrelation method alters an existing database\n"
"correlation. A database correlation is a VisIt construct that relates the\n"
"time states for two or more databases in some way. You would use the\n"
"AlterDatabaseCorrelation function if you wanted to change the list of\n"
"databases used in a database correlation or if you wanted to change how the\n"
"databases are related - the correlation method. The name argument is a\n"
"string that is the name of the database correlation to be altered. If the\n"
"name that you pass is not a valid database correlation then the\n"
"AlterDatabaseCorrelation function fails. The databases argument is a list\n"
"or tuple of string objects containing the fully-qualified\n"
"(host:/path/filename) names of the databases to be involved in the database\n"
"query. The method argument allows you to specify a database correlation\n"
"method.\n"
"\n"
"\n"
"Example:\n"
"\n"
"dbs = (\"/usr/gapps/visit/data/wave.visit\", \"/usr/gapps/visit/data/wave*.silo database\")\n"
"OpenDatabase(dbs[0])\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"OpenDatabase(dbs[1])\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"# VisIt created an index for index database correlation but we\n"
"# want a cycle correlation.\n"
"AlterDatabaseCorrelation(\"Correlation01\", dbs, 3)\n"
;
const char *visit_ApplyNamedSelection_doc = 
"ApplyNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ApplyNamedSelection(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a named selection.  (This should have been previously created\n"
"    with a CreateNamedSelection call.)\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ApplyNamedSelection function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named Selections allow you to select a group of elements (or particles).\n"
"One typically creates a named selection from a group of elements and then\n"
"later applies the named selection to another plot (thus reducing the\n"
"set of elements displayed to the ones from when the named selection was\n"
"created).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddOperator(\"Clip\")\n"
"c = ClipAttributes()\n"
"c.plane1Origin = (0,0.6,0)\n"
"c.plane1Normal = (0,-1,0)\n"
"SetOperatorOption(c)\n"
"DrawPlots()\n"
"CreateNamedSelection(\"els_above_at_time_0\")\n"
"SetTimeSliderState(40)\n"
"RemoveLastOperator()\n"
"ApplyNamedSelection(\"els_above_at_time_0\")\n"
;
const char *visit_ChangeActivePlotsVar_doc = 
"ChangeActivePlotsVar\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ChangeActivePlotsVar(variableName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the new plot variable.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ChangeActivePlotsVar function returns an integer value of 1 for\n"
"    success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ChangeActivePlotsVar function changes the plotted variable for the\n"
"active plots. This is a useful way to change what is being visualized\n"
"without having to delete and recreate the current plots. The variableName\n"
"argument is a string that contains the name of a variable in the open\n"
"database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"SaveWindow()\n"
"ChangeActivePlotsVar(\"v\")\n"
;
const char *visit_CheckForNewStates_doc = 
"CheckForNewStates\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CheckForNewStates(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a database that has been opened previously.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CheckForNewStates function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Calculations are often run at the same time as some of the preliminary\n"
"visualization work is being performed. That said, you might be visualizing\n"
"the leading time states of a database that is still being created. If you\n"
"want to force VisIt to add any new time states that were added since you\n"
"opened the database, you can use the CheckForNewStates function. The name\n"
"argument must contain the name of a database that has been opened before.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"SetTimeSliderState(TimeSliderGetNStates() - 1)\n"
"# More files appear on disk\n"
"CheckForNewStates(db)\n"
"SetTimeSliderState(TimeSliderGetNStates() - 1)\n"
;
const char *visit_ChooseCenterOfRotation_doc = 
"ChooseCenterOfRotation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ChooseCenterOfRotation() -> integer\n"
"ChooseCenterOfRotation(screenX, screenY) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"screenX\n"
"    A double that is the X coordinate of the pick point in normalized [0,1]\n"
"    screen space.\n"
"screenY\n"
"    A double that is the Y coordinate of the pick point in normalized [0,1]\n"
"    screen space.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ChooseCenterOfRotation function returns 1 if successful and 0 if it\n"
"    fails.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ChooseCenterOfRotation function allows you to pick a new center of\n"
"rotation, which is the point about which plots are rotated when you\n"
"interactively rotate plots. The function can either take zero arguments, in\n"
"which case you must interactively pick on plots, or it can take two\n"
"arguments that correspond to the X and Y coordinates of the desired pick\n"
"point in normalized screen space. When using the two argument version of\n"
"the ChooseCenterOfRotation function, the X and Y values are floating point\n"
"values in the range [0,1]. If the ChooseCenterOfRotation function is able\n"
"to actually pick on plots, yes there must be plots in the vis window, then\n"
"the center of rotation is updated and the new value is printed to the\n"
"console.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlots(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Interactively choose the center of rotation\n"
"ChooseCenterOfRotation()\n"
"# Choose a center of rotation using normalized screen\n"
"# coordinates and print the value.\n"
"ResetView()\n"
"ChooseCenterOfRotation(0.5, 0.3)\n"
"print(\"The new center of rotation is:{}\".format(GetView3D().centerOfRotation))\n"
;
const char *visit_ClearAllWindows_doc = 
"ClearAllWindows\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearAllWindows() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 on success, 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearWindow function is used to clear out the plots from the active\n"
"visualization window. The plots are removed from the visualization window\n"
"but are left in the plot list so that subsequent calls to the DrawPlots\n"
"function regenerate the plots in the plot list. The ClearAllWindows\n"
"function preforms the same work as the ClearWindow function except that all\n"
"windows are cleared of their plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2) # Make window 2 active\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"DrawPlots()\n"
"ClearWindow() # Clear the plots in window 2.\n"
"DrawPlots() # Redraw the plots in window 2.\n"
"ClearAllWindows() # Clear the plots from all windows.\n"
;
const char *visit_ClearCache_doc = 
"ClearCache\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearCache(host) -> integer\n"
"ClearCache(host, simulation) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"host\n"
"    The name of the computer where the compute engine is running.\n"
"simulation\n"
"    The name of the simulation being processed by the compute engine.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Sometimes during extended VisIt runs, you might want to periodically clear\n"
"the compute engine's network cache to reduce the amount of memory being\n"
"used by the compute engine. Clearing the network cache is also useful when\n"
"you want to change what the compute engine is working on. For example, you\n"
"might process a large database and then decide to process another large\n"
"database. Clearing the network cache beforehand will free up more resources\n"
"for the compute engine so it can more efficiently process the new database.\n"
"The host argument is a string object containing the name of the computer on\n"
"which the compute engine is running. The simulation argument is optional\n"
"and only applies to when you want to instruct a simulation that is acting\n"
"as a VisIt compute engine to clear its network cache. If you want to tell\n"
"more than one compute engine to clear its cache without having to call\n"
"ClearCache multiple times, you can use the ClearCacheForAllEngines function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#%visit -cli\n"
"OpenDatabase(\"localhost:very_large_database\")\n"
"# Do a lot of work\n"
"ClearCache(\"localhost\")\n"
"OpenDatabase(\"localhost:another_large_database\")\n"
"# Do more work\n"
"OpenDatabase(\"remotehost:yet_another_database\")\n"
"# Do more work\n"
"ClearCacheForAllEngines()\n"
;
const char *visit_ClearCacheForAllEngines_doc = 
"ClearCacheForAllEngines\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearCacheForAllEngines() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Sometimes during extended VisIt runs, you might want to periodically clear\n"
"the compute engine's network cache to reduce the amount of memory being\n"
"used by the compute engine. Clearing the network cache is also useful when\n"
"you want to change what the compute engine is working on. For example, you\n"
"might process a large database and then decide to process another large\n"
"database. Clearing the network cache beforehand will free up more resources\n"
"for the compute engine so it can more efficiently process the new database.\n"
"The host argument is a string object containing the name of the computer on\n"
"which the compute engine is running. The simulation argument is optional\n"
"and only applies to when you want to instruct a simulation that is acting\n"
"as a VisIt compute engine to clear its network cache. If you want to tell\n"
"more than one compute engine to clear its cache without having to call\n"
"ClearCache multiple times, you can use the ClearCacheForAllEngines function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#%visit -cli\n"
"OpenDatabase(\"localhost:very_large_database\")\n"
"# Do a lot of work\n"
"ClearCache(\"localhost\")\n"
"OpenDatabase(\"localhost:another_large_database\")\n"
"# Do more work\n"
"OpenDatabase(\"remotehost:yet_another_database\")\n"
"# Do more work\n"
"ClearCacheForAllEngines()\n"
;
const char *visit_ClearMacros_doc = 
"ClearMacros\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearMacros()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearMacros function clears out the list of registered macros and sends\n"
"a message to the gui to clear the buttons from the Macros window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"ClearMacros()\n"
;
const char *visit_ClearPickPoints_doc = 
"ClearPickPoints\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearPickPoints()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearPickPoints function removes pick points from the active\n"
"visualization window. Pick points are the letters that are added to the\n"
"visualization window where the mouse is clicked when the visualization\n"
"window is in pick mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"# Put the visualization window into pick mode using the popup\n"
"# menu and add some pick points.\n"
"# Clear the pick points.\n"
"ClearPickPoints()\n"
;
const char *visit_ClearReferenceLines_doc = 
"ClearReferenceLines\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearReferenceLines()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearReferenceLines function removes reference lines from the active\n"
"visualization window. Reference lines are the lines that are drawn on a\n"
"plot to show where you have performed lineouts.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"Lineout((-3.0, 2.0), (2.0, 4.0), (\"default\", \"u\", \"v\"))\n"
"ClearReferenceLines()\n"
;
const char *visit_ClearViewKeyframes_doc = 
"ClearViewKeyframes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearViewKeyframes() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ClearViewKeyframes function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearViewKeyframes function clears any view keyframes that may have\n"
"been set. View keyframes are used to create complex view behavior such as\n"
"fly-throughs when VisIt is in keyframing mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"k = KeyframeAttributes()\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1,10,1\n"
"SetKeyframeAttributes(k)\n"
"DrawPlots()\n"
"SetViewKeyframe()\n"
"v1 = GetView3D()\n"
"v1.viewNormal = (-0.66609, 0.337227, 0.665283)\n"
"v1.viewUp = (0.157431, 0.935425, -0.316537)\n"
"SetView3D(v1)\n"
"SetTimeSliderState(9)\n"
"SetViewKeyframe()\n"
"ToggleCameraViewMode()\n"
"for i in range(10):\n"
"    SetTimeSliderState(i)\n"
"ClearViewKeyframes()\n"
;
const char *visit_ClearWindow_doc = 
"ClearWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ClearWindow() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 on success, 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ClearWindow function is used to clear out the plots from the active\n"
"visualization window. The plots are removed from the visualization window\n"
"but are left in the plot list so that subsequent calls to the DrawPlots\n"
"function regenerate the plots in the plot list. The ClearAllWindows\n"
"function preforms the same work as the ClearWindow function except that all\n"
"windows are cleared of their plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2) # Make window 2 active\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"DrawPlots()\n"
"ClearWindow() # Clear the plots in window 2.\n"
"DrawPlots() # Redraw the plots in window 2.\n"
"ClearAllWindows() # Clear the plots from all windows.\n"
;
const char *visit_CloneWindow_doc = 
"CloneWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CloneWindow() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CloneWindow function returns an integer value of 1 for success and 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The CloneWindow function tells the viewer to create a new window, based on\n"
"the active window, that contains the same plots, annotations, lights, and\n"
"view as the active window. This function is useful for when you have a\n"
"window set up like you want and then want to do the same thing in another\n"
"window using a different database. You can first clone the window and then\n"
"replace the database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"v = ViewAttributes()\n"
"v.camera = (-0.505893, 0.32034, 0.800909)\n"
"v.viewUp = (0.1314, 0.946269, -0.295482)\n"
"v.parallelScale = 14.5472\n"
"v.nearPlane = -34.641\n"
"v.farPlane = 34.641\n"
"v.perspective = 1\n"
"SetView3D() # Set the view\n"
"a = AnnotationAttributes()\n"
"a.backgroundColor = (0, 0, 255, 255)\n"
"SetAnnotationAttributes(a) # Set the annotation properties\n"
"CloneWindow() # Create a clone of the active window\n"
"DrawPlots() # Make the new window draw its plots\n"
;
const char *visit_Close_doc = 
"Close\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Close()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Close function terminates VisIt's viewer. This is useful for Python\n"
"scripts that only need access to VisIt's capabilties for a short time\n"
"before closing VisIt.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.Launch()\n"
"visit.Close() # Close the viewer\n"
;
const char *visit_CloseComputeEngine_doc = 
"CloseComputeEngine\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CloseComputeEngine() -> integer\n"
"CloseComputeEngine(hostName) -> integer\n"
"CloseComputeEngine(hostName, simulation) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"hostName\n"
"    Optional name of the computer on which the compute engine is running.\n"
"simulation\n"
"    Optional name of a simulation.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CloseComputeEngine function returns an integer value of 1 for success\n"
"    and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The CloseComputeEngine function tells the viewer to close the compute\n"
"engine running a specified host. The hostName argument is a string that\n"
"contains the name of the computer where the compute engine is running. The\n"
"hostName argument can also be the name \"localhost\" if you want to close\n"
"the compute engine on the local machine without having to specify its name.\n"
"It is not necessary to provide the hostName argument. If the argument is\n"
"omitted, the first compute engine in the engine list will be closed. The\n"
"simulation argument can be provided if you want to close a connection to a\n"
"simulation that is acting as a VisIt compute engine. A compute engine can\n"
"be launched again by creating a plot or by calling the OpenComputeEngine\n"
"function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\") # Launches an engine\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"CloseComputeEngine() # Close the compute engine\n"
;
const char *visit_CloseDatabase_doc = 
"CloseDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CloseDatabase(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the database to close.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CloseDatabase function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The CloseDatabase function is used to close a specified database and free\n"
"all resources that were devoted to keeping the database open. This function\n"
"has an effect similar to ClearCache but it does more in that\n"
"in addition to clearing the compute engine's cache, which it only does for\n"
"the specified database, it also removes all references to the specified\n"
"database from tables of cached metadata, etc. Note that the CloseDatabase\n"
"function will fail and the database will not be closed if any plots\n"
"reference the specified database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/globe.silo\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"print(\"This won't work: retval = %d\" % CloseDatabase(db))\n"
"DeleteAllPlots()\n"
"print(\"Now it works: retval = %d\" % CloseDatabase(db))\n"
;
const char *visit_ColorTableNames_doc = 
"ColorTableNames\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ColorTableNames() -> tuple\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ColorTableNames function returns a tuple of strings containing the\n"
"    names of the color tables that have been defined.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ColorTableNames function returns a tuple of strings containing the\n"
"names of the color tables that have been defined. This method can be used\n"
"in case you want to iterate over several color tables.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"for ct in ColorTableNames():\n"
"    p = PseudocolorAttributes()\n"
"    p.colorTableName = ct\n"
"    SetPlotOptions(p)\n"
;
const char *visit_ConstructDataBinning_doc = 
"ConstructDataBinning\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ConstructDataBinning(options) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"options\n"
"    An object of type ConstructDataBinningAttributes. This object specifies\n"
"    the options for constructing a data binning.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns 1 on success, 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ConstructDataBinning function creates a data binning function for the active\n"
"plot. Data Binnings place data from a data set into bins and reduce that data.\n"
"They are used to either be incorporated with expressions to make new derived quantities\n"
"or to be directly visualized.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set the construct data binning attributes.\n"
"i = ConstructDataBinningAttributes()\n"
"i.name = \"db1\"\n"
"i.binningScheme = i.Uniform\n"
"i.varnames = (\"u\", \"w\")\n"
"i.binBoundaries = (-1, 1, -1, 1) # minu, maxu, minw, maxw\n"
"i.numSamples = (25, 25)\n"
"i.reductionOperator = i.Average\n"
"i.varForReductionOperator = \"v\"\n"
"ConstructDataBinning(i)\n"
"# Example of binning using spatial coordinates\n"
"i.varnames = (\"X\", \"u\") # X is added as a placeholder to maintain indexing\n"
"i.binType = (1, 0) # 1 = X, 2 = Y, 3 = Z, 0 = variable\n"
;
const char *visit_CopyAnnotationsToWindow_doc = 
"CopyAnnotationsToWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CopyAnnotationsToWindow(source, dest) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"source\n"
"    The index (an integer from 1 to 16) of the source window.\n"
"dest\n"
"    The index (an integer from 1 to 16) of the destination window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Copy functions copy attributes from one visualization window to\n"
"another visualization window. The CopyAnnotationsToWindow function copies\n"
"the annotations from a source visualization window to a destination\n"
"visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2)\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"# Copy window 1's Pseudocolor plot to window 2.\n"
"CopyPlotsToWindow(1, 2)\n"
"DrawPlots() # Window 2 will have 2 plots\n"
"# Spin the plots around in window 2 using the mouse.\n"
"CopyViewToWindow(2, 1) # Copy window 2's view to window 1.\n"
;
const char *visit_CopyLightingToWindow_doc = 
"CopyLightingToWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CopyLightingToWindow(source, dest) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"source\n"
"    The index (an integer from 1 to 16) of the source window.\n"
"dest\n"
"    The index (an integer from 1 to 16) of the destination window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Copy functions copy attributes from one visualization window to\n"
"another visualization window. The CopyLightingAttributes function copies\n"
"lighting.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2)\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"# Copy window 1's Pseudocolor plot to window 2.\n"
"CopyPlotsToWindow(1, 2)\n"
"DrawPlots() # Window 2 will have 2 plots\n"
"# Spin the plots around in window 2 using the mouse.\n"
"CopyViewToWindow(2, 1) # Copy window 2's view to window 1.\n"
;
const char *visit_CopyPlotsToWindow_doc = 
"CopyPlotsToWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CopyPlotsToWindow(source, dest) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"source\n"
"    The index (an integer from 1 to 16) of the source window.\n"
"dest\n"
"    The index (an integer from 1 to 16) of the destination window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Copy functions copy attributes from one visualization window to\n"
"another visualization window. The CopyPlotsToWindow function copies\n"
"the plots from one visualization window to another visualization\n"
"window but does not also force plots to generate so after copying\n"
"plots with the CopyPlotsToWindow function, you should also call the\n"
"DrawPlots function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2)\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"# Copy window 1's Pseudocolor plot to window 2.\n"
"CopyPlotsToWindow(1, 2)\n"
"DrawPlots() # Window 2 will have 2 plots\n"
"# Spin the plots around in window 2 using the mouse.\n"
"CopyViewToWindow(2, 1) # Copy window 2's view to window 1.\n"
;
const char *visit_CopyViewToWindow_doc = 
"CopyViewToWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CopyViewToWindow(source, dest) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"source\n"
"    The index (an integer from 1 to 16) of the source window.\n"
"dest\n"
"    The index (an integer from 1 to 16) of the destination window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Copy functions return an integer value of 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Copy functions copy attributes from one visualization window to\n"
"another visualization window. The CopyViewToWindow function copies\n"
"the view.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddWindow()\n"
"SetActiveWindow(2)\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"# Copy window 1's Pseudocolor plot to window 2.\n"
"CopyPlotsToWindow(1, 2)\n"
"DrawPlots() # Window 2 will have 2 plots\n"
"# Spin the plots around in window 2 using the mouse.\n"
"CopyViewToWindow(2, 1) # Copy window 2's view to window 1.\n"
;
const char *visit_CreateAnnotationObject_doc = 
"CreateAnnotationObject\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CreateAnnotationObject(annotType[,annotName,visibleFlag]) -> annotation object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"annotType\n"
"    The name of the type of annotation object to create.\n"
"    \n"
"    ======================  ==========\n"
"    **Annotation type**     String\n"
"    ======================  ==========\n"
"    2D text annotation      Text2D\n"
"    3D text annotation      Text3D\n"
"    Time slider annotation  TimeSlider\n"
"    Image annotation        Image\n"
"    Line/arrow annotation   Line2D\n"
"    ======================  ==========\n"
"annotName\n"
"    A user-defined name of the annotation object to create.\n"
"    By default, VisIt creates names like 'newObject0', 'newObject1', ....\n"
"visibleFlag\n"
"    An optional integer to indicate if the annotation object should be created\n"
"    with initial visibility on or off. Pass 0 for off and non-zero for on.\n"
"    By default, VisIt creates annotation objects with visibility on. If you\n"
"    wish only to pass the visibleFlag argument, there is no need to also pass\n"
"    the annotName argument.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    CreateAnnotationObject is a factory function that creates annotation\n"
"    objects of different types. The return value, if a valid annotation type is\n"
"    provided, is an annotation object. If the function fails, VisItException is\n"
"    raised.\n"
"\n"
"\n"
"Description:\n"
"\n"
"CreateAnnotationObject is a factory function that creates different kinds\n"
"of annotation objects. The annotType argument is a string containing the\n"
"name of the type of annotation object to create. Each type of annotation\n"
"object has different properties that can be set. Setting the different\n"
"properties of an Annotation objects directly modifes annotations in the vis\n"
"window. Currently there are 5 types of annotation objects:\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\", 17)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"slider = CreateAnnotationObject(\"TimeSlider\")\n"
"print(slider)\n"
"slider.startColor = (255,0,0,255)\n"
"slider.endColor = (255,255,0,255)\n"
;
const char *visit_CreateDatabaseCorrelation_doc = 
"CreateDatabaseCorrelation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CreateDatabaseCorrelation(name, databases, method) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the database correlation to be created.\n"
"databases\n"
"    Tuple or list of strings containing the names of the databases to involve\n"
"    in the database correlation.\n"
"method\n"
"    An integer in the range [0,3] that determines the correlation method.\n"
"    \n"
"    =========================  =====\n"
"    **Correlation method**     Value\n"
"    =========================  =====\n"
"    IndexForIndexCorrelation   0\n"
"    StretchedIndexCorrelation  1\n"
"    TimeCorrelation            2\n"
"    CycleCorrelation           3\n"
"    =========================  =====\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CreateDatabaseCorrelation function returns 1 on success and 0 on\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The CreateDatabaseCorrelation function creates a database correlation,\n"
"which is a VisIt construct that relates the time states for two or more\n"
"databases in some way. You would use the CreateDatabaseCorrelation function\n"
"if you wanted to put plots from more than one time-varying database in the\n"
"same vis window and then move them both through time in some synchronized\n"
"way. The name argument is a string that is the name of the database\n"
"correlation to be created. You will use the name of the database\n"
"correlation to set the active time slider later so that you can change time\n"
"states. The databases argument is a list or tuple of string objects\n"
"containing the fully-qualified (host:/path/filename) names of the databases\n"
"to be involved in the database query. The method argument allows you to\n"
"specify a database correlation method.\n"
"Each database correlation has its own time slider that can be used to set\n"
"the time state of databases that are part of a database correlation.\n"
"Individual time-varying databases have their own trivial database\n"
"correlation, consisting of only 1 database. When you call the\n"
"CreateDatabaseCorrelation function, VisIt creates a new time slider with\n"
"the same name as the database correlation and makes it be the active time\n"
"slider.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"dbs = (\"/usr/gapps/visit/data/dbA00.pdb\",\n"
"\"/usr/gapps/visit/data/dbB00.pdb\")\n"
"OpenDatabase(dbs[0])\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"OpenDatabase(dbs[1])\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"# Creating a new database correlation also creates a new time\n"
"# slider and makes it be active.\n"
"w = GetWindowInformation()\n"
"print(\"Active time slider: %s\" % w.timeSliders[w.activeTimeSlider])\n"
"# Animate through time using the \"common\" database correlation's\n"
"# time slider.\n"
"for i in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(i)\n"
;
const char *visit_CreateNamedSelection_doc = 
"CreateNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"CreateNamedSelection(name) -> integer\n"
"CreateNamedSelection(name, properties) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a named selection.\n"
"properties\n"
"    This optional argument lets you pass a SelectionProperties object containing\n"
"    the properties that will be used to create the named selection. When this\n"
"    argument is omitted, the named selection will always be associated with\n"
"    the active plot. You can use this argument to set up more complex named\n"
"    selections that may be associated with plots or databases.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The CreateNamedSelection function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named Selections allow you to select a group of elements (or particles).\n"
"One typically creates a named selection from a group of elements and then\n"
"later applies the named selection to another plot (thus reducing the\n"
"set of elements displayed to the ones from when the named selection was\n"
"created).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddOperator(\"Clip\")\n"
"c = ClipAttributes()\n"
"c.plane1Origin = (0,0.6,0)\n"
"c.plane1Normal = (0,-1,0)\n"
"SetOperatorOption(c)\n"
"DrawPlots()\n"
"CreateNamedSelection(\"els_above_at_time_0\")\n"
"SetTimeSliderState(40)\n"
"RemoveLastOperator()\n"
"ApplyNamedSelection(\"els_above_at_time_0\")\n"
;
const char *visit_DatabasePlugins_doc = 
"DatabasePlugins\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DatabasePlugins() -> dictionary\n"
"DatabasePlugins(host) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"host\n"
"    The name of the host for which we want database plugins.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DatabasePlugins functions returns a dictionary.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DatabasePlugins function returns a dictionary containing the names of\n"
"the database plugins for the specified host. If no host is given, localhost\n"
"is assumed. The dictionary contains two keys: \"host\" and \"plugins\".\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"dbp = DatabasePlugins(\"localhost\")\n"
"print(dbp[\"host\"])\n"
"print(dbp[\"plugins\"])\n"
;
const char *visit_DeIconifyAllWindows_doc = 
"DeIconifyAllWindows\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeIconifyAllWindows()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeIconifyAllWindows function unhides all of the hidden visualization\n"
"windows. This function is usually called after IconifyAllWindows as a way\n"
"of making all of the hidden visualization windows visible.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4) # Have 4 windows\n"
"IconifyAllWindows()\n"
"DeIconifyAllWindows()\n"
;
const char *visit_DefineArrayExpression_doc = 
"DefineArrayExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineArrayExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"DefineArrayExpression creates new array variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineCurveExpression_doc = 
"DefineCurveExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineCurveExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"DefineCurveExpression creates new curve variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineMaterialExpression_doc = 
"DefineMaterialExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineMaterialExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineMaterialExpression function creates new material variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineMeshExpression_doc = 
"DefineMeshExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineMeshExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineMeshExpression creates new mesh variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefinePythonExpression_doc = 
"DefinePythonExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefinePythonExpression(myvar,args,source)\n"
"DefinePythonExpression(myvar,args,source,type)\n"
"DefinePythonExpression(myvar,args,file)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"myvar\n"
"    The name of the variable to be created.\n"
"args\n"
"    A tuple (or list) of strings providing the variable names of the\n"
"    arguments to the Python Expression.\n"
"source\n"
"    A string containing the source code for a Python Expression Filter .\n"
"file\n"
"    A string containing the path to a Python Expression Filter script file.\n"
"type\n"
"    An optional string defining the output type of the expression.\n"
"    Default type - 'scalar'\n"
"    Avalaible types - 'scalar','vector','tensor','array','curve'\n"
"    Note - Use only one of the 'source' or 'file' arguments.\n"
"    If both are used the 'source' argument overrides 'file'.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Used to define a Python Filter Expression.\n"
;
const char *visit_DefineScalarExpression_doc = 
"DefineScalarExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineScalarExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineScalarExpression function creates a new scalar variable based on\n"
"other variables from the open database.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineSpeciesExpression_doc = 
"DefineSpeciesExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineSpeciesExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineSpeciesExpression creates new species variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineTensorExpression_doc = 
"DefineTensorExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineTensorExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineTensorExpression creates new tensor variables.\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DefineVectorExpression_doc = 
"DefineVectorExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DefineVectorExpression(variableName, expression) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the variable to be created.\n"
"expression\n"
"    The expression definition as a string.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DefineExpression functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DefineVectorExpression creates new vector variables\n"
"Expression variables can be plotted like any other variable.\n"
"The variableName argument is a string that contains the name of the new\n"
"variable. You can pass the name of an existing expression if you want\n"
"to provide a new expression definition.\n"
"The expression argument is a string that contains the definition of the\n"
"new variable in terms of math operators and pre-existing variable names\n"
"Reference the VisIt User's Manual if you want more information on\n"
"creating expressions, such as expression syntax, or a list of built-in\n"
"expression functions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"# Plot the scalar expression variable.\n"
"AddPlot(\"Pseudocolor\", \"myvar\")\n"
"DrawPlots()\n"
"# Plot a vector expression variable.\n"
"DefineVectorExpression(\"myvec\", \"{u,v,w}\")\n"
"AddPlot(\"Vector\", \"myvec\")\n"
"DrawPlots()\n"
;
const char *visit_DeleteActivePlots_doc = 
"DeleteActivePlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteActivePlots() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Delete functions return an integer value of 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Delete functions delete plots from the active window's plot list. The\n"
"DeleteActivePlots function deletes all of the active plots from the plot\n"
"list. There is no way to retrieve a plot once it has been deleted from the\n"
"plot list. The active plots are set using the SetActivePlots function. The\n"
"DeleteAllPlots function deletes all plots from the active window's plot\n"
"list regardless of whether or not they are active.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"AddPlot(\"Mesh\", \"curvmesh2d\")\n"
"DrawPlots()\n"
"DeleteActivePlots() # Delete the mesh plot\n"
"DeleteAllPlots() # Delete the pseudocolor and contour plots.\n"
;
const char *visit_DeleteAllPlots_doc = 
"DeleteAllPlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteAllPlots() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Delete functions return an integer value of 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Delete functions delete plots from the active window's plot list. The\n"
"DeleteActivePlots function deletes all of the active plots from the plot\n"
"list. There is no way to retrieve a plot once it has been deleted from the\n"
"plot list. The active plots are set using the SetActivePlots function. The\n"
"DeleteAllPlots function deletes all plots from the active window's plot\n"
"list regardless of whether or not they are active.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"AddPlot(\"Mesh\", \"curvmesh2d\")\n"
"DrawPlots()\n"
"DeleteActivePlots() # Delete the mesh plot\n"
"DeleteAllPlots() # Delete the pseudocolor and contour plots.\n"
;
const char *visit_DeleteDatabaseCorrelation_doc = 
"DeleteDatabaseCorrelation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteDatabaseCorrelation(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the database correlation to delete.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DeleteDatabaseCorrelation function returns 1 on success and 0 on\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeleteDatabaseCorrelation function deletes a specific database\n"
"correlation and its associated time slider. If you delete a database\n"
"correlation whose time slider is being used for the current time slider,\n"
"the time slider will be reset to the time slider of the next best suited\n"
"database correlation. You can use the DeleteDatabaseCorrelation function to\n"
"remove database correlations that you no longer need such as when you\n"
"choose to examine databases that have nothing to do with your current\n"
"databases.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"dbs = (\"dbA00.pdb\", \"dbB00.pdb\")\n"
"OpenDatabase(dbs[0])\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"OpenDatabase(dbs[1])\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"SetTimeSliderState(10)\n"
"DeleteAllPlots()\n"
"DeleteDatabaseCorrelation(\"common\")\n"
"CloseDatabase(dbs[0])\n"
"CloseDatabase(dbs[1])\n"
;
const char *visit_DeleteExpression_doc = 
"DeleteExpression\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteExpression(variableName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"variableName\n"
"    The name of the expression variable to be deleted.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DeleteExpression function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeleteExpression function deletes the definition of an expression. The\n"
"variableName argument is a string containing the name of the variable\n"
"expression to be deleted. Any plot that uses an expression that has been\n"
"deleted will fail to regenerate if its attributes are changed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"DefineScalarExpression(\"myvar\", \"sin(u) + cos(w)\")\n"
"AddPlot(\"Pseudocolor\", \"myvar\") # Plot the expression variable.\n"
"DrawPlots()\n"
"DeleteExpression(\"myvar\") # Delete the expression variable myvar.\n"
;
const char *visit_DeleteNamedSelection_doc = 
"DeleteNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteNamedSelection(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a named selection.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DeleteNamedSelection function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named Selections allow you to select a group of elements (or particles).\n"
"One typically creates a named selection from a group of elements and then\n"
"later applies the named selection to another plot (thus reducing the\n"
"set of elements displayed to the ones from when the named selection was\n"
"created).  If you have created a named selection that you are no longer\n"
"interested in, you can delete it with the DeleteNamedSelection function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddOperator(\"Clip\")\n"
"c = ClipAttributes()\n"
"c.plane1Origin = (0,0.6,0)\n"
"c.plane1Normal = (0,-1,0)\n"
"SetOperatorOption(c)\n"
"DrawPlots()\n"
"CreateNamedSelection(\"els_above_y\")\n"
"SetTimeSliderState(40)\n"
"DeleteNamedSelection(\"els_above_y\")\n"
"CreateNamedSelection(\"els_above_y\")\n"
;
const char *visit_DeletePlotDatabaseKeyframe_doc = 
"DeletePlotDatabaseKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeletePlotDatabaseKeyframe(plotIndex, frame)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"plotIndex\n"
"    A zero-based integer value corresponding to a plot's index in the plot\n"
"    list.\n"
"frame\n"
"    A zero-based integer value corresponding to a database keyframe at a\n"
"    particular animation frame.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeletePlotDatabaseKeyframe function removes a database keyframe from a\n"
"specific plot. A database keyframe represents the database time state that\n"
"will be used at a given animation frame when VisIt's keyframing mode is\n"
"enabled. The plotIndex argument is a zero-based integer that is used to\n"
"identify a plot in the plot list. The frame argument is a zero-based\n"
"integer that is used to identify the frame at which a database keyframe is\n"
"to be removed for the specified plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"k = GetKeyframeAttributes()\n"
"k.enabled,k.nFrames,k.nFramesWasUserSet = 1,20,1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"SetPlotDatabaseState(0, 0, 60)\n"
"# Repeat time state 60 for the first few animation frames by adding a\n"
"# keyframe at frame 3.\n"
"SetPlotDatabaseState(0, 3, 60)\n"
"SetPlotDatabaseState(0, 19, 0)\n"
"DrawPlots()\n"
"ListPlots()\n"
"# Delete the database keyframe at frame 3.\n"
"DeletePlotDatabaseKeyframe(0, 3)\n"
"ListPlots()\n"
;
const char *visit_DeletePlotKeyframe_doc = 
"DeletePlotKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeletePlotKeyframe(plotIndex, frame)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"plotIndex\n"
"    A zero-based integer value corresponding to a plot's index in the plot\n"
"    list.\n"
"frame\n"
"    A zero-based integer value corresponding to a plot keyframe at a\n"
"    particular animation frame.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeletePlotKeyframe function removes a plot keyframe from a specific\n"
"plot. A plot keyframe is the set of plot attributes at a specified frame.\n"
"Plot keyframes are used to determine what plot attributes will be used at a\n"
"given animation frame when VisIt's keyframing mode is enabled. The\n"
"plotIndex argument is a zero-based integer that is used to identify a plot\n"
"in the plot list. The frame argument is a zero-based integer that is used\n"
"to identify the frame at which a keyframe is to be removed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"k = GetKeyframeAttributes()\n"
"k.enabled,k.nFrames,k.nFramesWasUserSet = 1,20,1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"# Set up plot keyframes so the Pseudocolor plot's min will change\n"
"# over time.\n"
"p0 = PseudocolorAttributes()\n"
"p0.minFlag,p0.min = 1,0.0\n"
"p1 = PseudocolorAttributes()\n"
"p1.minFlag,p1.min = 1, 0.5\n"
"SetPlotOptions(p0)\n"
"SetTimeSliderState(19)\n"
"SetPlotOptions(p1)\n"
"SetTimeSliderState(0)\n"
"DrawPlots()\n"
"ListPlots()\n"
"# Iterate over all animation frames and wrap around to the first one.\n"
"for i in list(range(TimeSliderGetNStates())) + [0]:\n"
"    SetTimeSliderState(i)\n"
"# Delete the plot keyframe at frame 19 so the min won't\n"
"# change anymore.\n"
"DeletePlotKeyframe(19)\n"
"ListPlots()\n"
"SetTimeSliderState(10)\n"
;
const char *visit_DeleteViewKeyframe_doc = 
"DeleteViewKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteViewKeyframe(frame)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"frame\n"
"    A zero-based integer value corresponding to a view keyframe at a\n"
"    particular animation frame.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeleteViewKeyframe function removes a view keyframe at a specified\n"
"frame. View keyframes are used to determine what view will be used at a\n"
"given animation frame when VisIt's keyframing mode is enabled. The frame\n"
"argument is a zero-based integer that is used to identify the frame at\n"
"which a keyframe is to be removed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"k = KeyframeAttributes()\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1,10,1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Set some view keyframes\n"
"SetViewKeyframe()\n"
"v1 = GetView3D()\n"
"v1.viewNormal = (-0.66609, 0.337227, 0.665283)\n"
"v1.viewUp = (0.157431, 0.935425, -0.316537)\n"
"SetView3D(v1)\n"
"SetTimeSliderState(9)\n"
"SetViewKeyframe()\n"
"ToggleCameraViewMode()\n"
"# Iterate over the animation frames to watch the view change.\n"
"for i in list(range(10)) + [0]:\n"
"    SetTimeSliderState(i)\n"
"# Delete the last view keyframe, which is on frame 9.\n"
"DeleteViewKeyframe(9)\n"
"# Iterate over the animation frames again. The view should stay\n"
"# the same.\n"
"for i in range(10):\n"
"    SetTimeSliderState(i)\n"
;
const char *visit_DeleteWindow_doc = 
"DeleteWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DeleteWindow() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DeleteWindow function returns an integer value of 1 for success and 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DeleteWindow function deletes the active visualization window and\n"
"makes the visualization window with the smallest window index the new\n"
"active window. This function has no effect when there is only one remaining\n"
"visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"DeleteWindow() # Does nothing since there is only one window\n"
"AddWindow()\n"
"DeleteWindow() # Deletes the new window.\n"
;
const char *visit_DemoteOperator_doc = 
"DemoteOperator\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DemoteOperator(opIndex) -> integer\n"
"DemoteOperator(opIndex, applyToAllPlots) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"opIndex\n"
"    A zero-based integer corresponding to the operator that should be demoted.\n"
"applyToAllPlots\n"
"    An integer flag that causes all plots in the plot list to be affected when\n"
"    it is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    DemoteOperator returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DemoteOperator function moves an operator closer to the database in\n"
"the visualization pipeline. This allows you to change the order of\n"
"operators that have been applied to a plot without having to remove them\n"
"from the plot. For example, consider moving a Slice to before a Reflect\n"
"operator when it had been the other way around. Changing the order of\n"
"operators can result in vastly different results for a plot. The opposite\n"
"function is PromoteOperator.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hardyglobal\")\n"
"AddOperator(\"Slice\")\n"
"s = SliceAttributes()\n"
"s.project2d = 0\n"
"s.originPoint = (0,5,0)\n"
"s.originType=s.Point\n"
"s.normal = (0,1,0)\n"
"s.upAxis = (-1,0,0)\n"
"SetOperatorOptions(s)\n"
"AddOperator(\"Reflect\")\n"
"DrawPlots()\n"
"# Now reflect before slicing. We'll only get 1 slice plane\n"
"# instead of 2.\n"
"DemoteOperator(1)\n"
"DrawPlots()\n"
;
const char *visit_DisableRedraw_doc = 
"DisableRedraw\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DisableRedraw()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DisableRedraw function prevents the active visualization window from\n"
"ever redrawing itself. This is a useful function to call when performing\n"
"many operations that would cause unnecessary redraws in the visualization\n"
"window. The effects of this function are undone by calling the RedrawWindow\n"
"function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"AddPlot(\"Pseudocolor\", \"w\")\n"
"DrawPlots()\n"
"DisableRedraw()\n"
"AddOperator(\"Slice\")\n"
"# Set the slice operator attributes\n"
"# Redraw now that thw operator attributes are set. This will\n"
"# prevent 1 redraw.\n"
"RedrawWindow()\n"
;
const char *visit_DrawPlots_doc = 
"DrawPlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"DrawPlots() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The DrawPlots function returns an integer value of 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The DrawPlots function forces all new plots in the plot list to be drawn.\n"
"Plots are added and then their attributes are modified. Finally, the\n"
"DrawPlots function is called to make sure all of the new plots draw\n"
"themselves in the visualization window. This function has no effect if all\n"
"of the plots in the plot list are already drawn.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots() # Draw the new pseudocolor plot.\n"
;
const char *visit_EnableTool_doc = 
"EnableTool\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"EnableTool(toolIndex, activeFlag)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"toolIndex\n"
"    This is an integer that corresponds to an interactive tool.\n"
"    (Plane tool = 0, Line tool = 1, Plane tool = 2, Box tool = 3,\n"
"    Sphere tool = 4, Axis Restriction tool = 5)\n"
"activeFlag\n"
"    An integer value of 1 enables the tool while a value of 0 disables the tool.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EnableToole function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The EnableTool function is used to set the enabled state of an interactive\n"
"tool in the active visualization window. The toolIndex argument is an\n"
"integer index that corresponds to a certain tool. The activeFlag argument\n"
"is an integer value (0 or 1) that indicates whether to turn the tool on or\n"
"off.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"EnableTool(0, 1) # Turn on the line tool.\n"
"EnableTool(1,1) # Turn on the plane tool.\n"
"EnableTool(2,1) # Turn on the sphere tool.\n"
"EnableTool(2,0) # Turn off the sphere tool.\n"
;
const char *visit_EvalCubic_doc = 
"EvalCubic\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"EvalCubic(t, c0, c1, c2, c3) -> f(t)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"t\n"
"    A floating point number in the range [0., 1.] that represents the distance\n"
"    from c0 to c3.\n"
"c0\n"
"    The first control point. f(0) = c0. Any object that can be used in an\n"
"    arithmetic expression can be passed for c0.\n"
"c1\n"
"    The second control point. Any object that can be used in an arithmetic\n"
"    expression can be passed for c1.\n"
"c2\n"
"    The third control point. Any object that can be used in an arithmetic\n"
"    expression can be passed for c2.\n"
"c3\n"
"    The last control point. f(1) = c3. Any object that can be used in an\n"
"    arithmetic expression can be passed for c3.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EvalCubic function returns the interpolated value for t taking into\n"
"    account the control points that were passed in.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The EvalCubic function takes in four objects and blends them using a cubic\n"
"polynomial and returns the blended value.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"v0 = GetView3D()\n"
"# rotate the plots\n"
"v1 = GetView3D()\n"
"# rotate the plots again.\n"
"v2 = GetView3D()\n"
"# rotate the plots one last time.\n"
"v3 = GetView3D()\n"
"# Fly around the plots using the views that have been specified.\n"
"nSteps = 100\n"
"for i in range(nSteps):\n"
"    t = float(i) / float(nSteps - 1)\n"
"    newView = EvalCubic(t, v0, v1, v2, v3)\n"
"    SetView3D(newView)\n"
;
const char *visit_EvalCubicSpline_doc = 
"EvalCubicSpline\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"EvalCubicSpline(t, weights, values) -> f(t)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"t\n"
"    A floating point number in the range [0., 1.] that represents the distance\n"
"    from the first control point to the last control point.\n"
"weights\n"
"    A tuple of N floating point values in the range [0., 1.] that represent\n"
"    how far along in parameterized space, the values will be located.\n"
"values\n"
"    A tuple of N objects to be blended. Any objects that can be used in\n"
"    arithmetic expressions can be passed in.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EvalCubicSpline function returns the interpolated value for t\n"
"    considering the objects that were passed in.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The EvalCubicSpline function takes in N objects to be blended and blends\n"
"them using piece-wise cubic polynomials and returns the blended value.\n"
;
const char *visit_EvalLinear_doc = 
"EvalLinear\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"EvalLinear(t, value1, value2) -> f(t)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"t\n"
"    A floating point value in the range [0., 1.] that represents the distance\n"
"    between the first and last control point in parameterized space.\n"
"value1\n"
"    Any object that can be used in an arithmetic expression. f(0) = value1.\n"
"value2\n"
"    Any object that can be used in an arithmetic expression. f(1) = value2.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EvalLinear function returns an interpolated value for t based on the\n"
"    objects that were passed in.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The EvalLinear function linearly interpolates between two values and\n"
"returns the result.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"c0 = GetView3D()\n"
"c1 = GetView3D()\n"
"c1.viewNormal = (-0.499159, 0.475135, 0.724629)\n"
"c1.viewUp = (0.196284, 0.876524, -0.439521)\n"
"nSteps = 100\n"
"for i in range(nSteps):\n"
"    t = float(i) / float(nSteps - 1)\n"
"    v = EvalLinear(t, c0, c1)\n"
"    SetView3D(v)\n"
;
const char *visit_EvalQuadratic_doc = 
"EvalQuadratic\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"EvalQuadratic(t, c0, c1, c2) -> f(t)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"t\n"
"    A floating point number in the range [0., 1.] that represents the distance\n"
"    from c0 to c3.\n"
"c0\n"
"    The first control point. f(0) = c0. Any object that can be used in an\n"
"    arithmetic expression can be passed for c0.\n"
"c1\n"
"    The second control point. Any object that can be used in an arithmetic\n"
"    expression can be passed for c1.\n"
"c2\n"
"    The last control point. f(1) = c2. Any object that can be used in an\n"
"    arithmetic expression can be passed for c2.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EvalQuadratic function returns the interpolated value for t taking\n"
"    into account the control points that were passed in.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The EvalQuadratic function takes in four objects and blends them using a\n"
"cubic polynomial and returns the blended value.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"v0 = GetView3D()\n"
"# rotate the plots\n"
"v1 = GetView3D()\n"
"# rotate the plots one last time.\n"
"v2 = GetView3D()\n"
"# Fly around the plots using the views that have been specified.\n"
"nSteps = 100\n"
"for i in range(nSteps):\n"
"    t = float(i) / float(nSteps - 1)\n"
"    newView = EvalQuadratic(t, v0, v1, v2)\n"
"    SetView3D(newView)\n"
;
const char *visit_ExecuteMacro_doc = 
"ExecuteMacro\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ExecuteMacro(name) -> value\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the macro to execute.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ExecuteMacro function returns the value returned from the user's macro function.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ExecuteMacro function lets you call a macro function that was previously\n"
"registered using the RegisterMacro method. Once macros are registered with a\n"
"name, this function can be called whenever the macro function associated with\n"
"that name needs to be called. The VisIt gui uses this function to tell the\n"
"Python interface when macros need to be executed in response to user button\n"
"clicks.\n"
"\n"
"\n"
"Example:\n"
"\n"
"def SetupMyPlots():\n"
"    OpenDatabase('noise.silo')\n"
"    AddPlot('Pseudocolor', 'hardyglobal')\n"
"    DrawPlots()\n"
"\n"
"RegisterMacro('Setup My Plots', SetupMyPlots)\n"
"ExecuteMacro('Setup My Plots')\n"
;
const char *visit_ExportDatabase_doc = 
"ExportDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ExportDatabase(e) -> integer\n"
"ExportDatabase(e, o) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"e\n"
"    An object of type ExportDBAttributes.  This object specifies the options\n"
"    for exporting the database.\n"
"o\n"
"    A dictionary containing a key/value mapping to set options needed by the\n"
"    database exporter.  The default values can be obtained in the appropriate\n"
"    format using GetExportOptions('plugin').\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns 1 on success, 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ExportDatabase function exports the active plot for the current window\n"
"to a file.  The format of the file, name, and variables to be saved are\n"
"specified using the ExportDBAttributes argument.\n"
"Note that this functionality is distinct from the geometric formats of\n"
"SaveWindow, such as STL.  SaveWindow can only save surfaces (triangle\n"
"meshes), while ExportDatabase can export an entire three dimensional data\n"
"set.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set the export database attributes.\n"
"e = ExportDBAttributes()\n"
"e.db_type = \"Silo\"\n"
"e.variables = (\"u\", \"v\")\n"
"e.filename = \"test_ex_db\"\n"
"ExportDatabase(e)\n"
;
const char *visit_Expressions_doc = 
"Expressions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Expressions() -> tuple of expression tuples\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Expressions function returns a tuple of tuples that contain two\n"
"    strings that give the expression name and definition.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Expressions function returns a tuple of tuples that contain two\n"
"strings that give the expression name and definition. This function is\n"
"useful for listing the available expressions or for iterating through a\n"
"list of expressions in order to create plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"DefineScalarExpression(\"sin_u\", \"sin(u)\")\n"
"DefineScalarExpression(\"cos_u\", \"cos(u)\")\n"
"DefineScalarExpression(\"neg_u\", \"-u\")\n"
"DefineScalarExpression(\"bob\", \"sin_u + cos_u\")\n"
"for i in range(1,5):\n"
"    SetActiveWindow(i)\n"
"    OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"    exprName = Expressions()[i-1][0]\n"
"    AddPlot(\"Pseudocolor\", exprName)\n"
"    DrawPlots()\n"
;
const char *visit_GetActiveContinuousColorTable_doc = 
"GetActiveContinuousColorTable\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetActiveContinuousColorTable() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return a string object containing the name of a color table.\n"
"\n"
"\n"
"Description:\n"
"\n"
"A color table is a set of color values that are used as the colors for\n"
"plots. VisIt supports two flavors of color table: continuous and discrete.\n"
"A continuous color table is defined by a small set of color control points\n"
"and the colors specified by the color control points are interpolated\n"
"smoothly to fill in any gaps. Continuous color tables are used for plots\n"
"that need to be colored smoothly by a variable (e.g. Pseudocolor plot). A\n"
"discrete color table is a set of color control points that are used to\n"
"color distinct regions of a plot (e.g. Subset plot). VisIt supports the\n"
"notion of default continuous and default discrete color tables so plots can\n"
"just use the \"default\" color table. This lets you change the color table\n"
"used by many plots by just changing the \"default\" color table. The\n"
"GetActiveContinuousColorTable function returns the name of the default\n"
"continuous color table. The GetActiveDiscreteColorTable function returns\n"
"the name of the default discrete color table.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Default continuous color table: %s\" % GetActiveContinuousColorTable())\n"
"print(\"Default discrete color table: %s\" % GetActiveDiscreteColorTable())\n"
;
const char *visit_GetActiveDiscreteColorTable_doc = 
"GetActiveDiscreteColorTable\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetActiveDiscreteColorTable() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return a string object containing the name of a color table.\n"
"\n"
"\n"
"Description:\n"
"\n"
"A color table is a set of color values that are used as the colors for\n"
"plots. VisIt supports two flavors of color table: continuous and discrete.\n"
"A continuous color table is defined by a small set of color control points\n"
"and the colors specified by the color control points are interpolated\n"
"smoothly to fill in any gaps. Continuous color tables are used for plots\n"
"that need to be colored smoothly by a variable (e.g. Pseudocolor plot). A\n"
"discrete color table is a set of color control points that are used to\n"
"color distinct regions of a plot (e.g. Subset plot). VisIt supports the\n"
"notion of default continuous and default discrete color tables so plots can\n"
"just use the \"default\" color table. This lets you change the color table\n"
"used by many plots by just changing the \"default\" color table. The\n"
"GetActiveContinuousColorTable function returns the name of the default\n"
"continuous color table. The GetActiveDiscreteColorTable function returns\n"
"the name of the default discrete color table.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Default continuous color table: %s\" % GetActiveContinuousColorTable())\n"
"print(\"Default discrete color table: %s\" % GetActiveDiscreteColorTable())\n"
;
const char *visit_GetActiveTimeSlider_doc = 
"GetActiveTimeSlider\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetActiveTimeSlider() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetActiveTimeSlider function returns a string containing the name of\n"
"    the active time slider.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt can support having multiple time sliders when you have opened more\n"
"than one time-varying database. You can then use each time slider to\n"
"independently change time states for each database or you can use a\n"
"database correlation to change time states for all databases\n"
"simultaneously. Every time-varying database has a database correlation and\n"
"every database correlation has its own time slider. If you want to query to\n"
"determine which time slider is currently the active time slider, you can\n"
"use the GetActiveTimeSlider function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"dbA00.pdb\")\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"OpenDatabase(\"dbB00.pdb\")\n"
"AddPlot(\"FilledBoundary\", \"materials(mesh)\")\n"
"print(\"Active time slider: %s\" % GetActiveTimeSlider())\n"
"CreateDatabaseCorrelation(\"common\", (\"dbA00.pdb\", \"dbB00.pdb\"), 2)\n"
"print(\"Active time slider: %s\" % GetActiveTimeSlider())\n"
;
const char *visit_GetAnimationAttributes_doc = 
"GetAnimationAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetAnimationAttributes() -> AnimationAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetAnimationAttributes function returns an AnimationAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function returns the current animation attributes, which contain the\n"
"animation mode, increment, and playback speed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"a = GetAnimationAttributes()\n"
"print(a)\n"
;
const char *visit_GetAnimationTimeout_doc = 
"GetAnimationTimeout\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetAnimationTimeout() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetAnimationTimeout function returns an integer that contains the time\n"
"    interval, measured in milliseconds, between the rendering of animation\n"
"    frames.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetAnimationTimeout returns an integer that contains the time\n"
"interval, measured in milliseconds, between the rendering of animation\n"
"frames.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Animation timeout = %d\" % GetAnimationTimeout())\n"
;
const char *visit_GetAnnotationAttributes_doc = 
"GetAnnotationAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetAnnotationAttributes() -> AnnotationAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetAnnotationAttributes function returns an AnnotationAttributes\n"
"    object that contains the annotation settings for the active visualization\n"
"    window.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetAnnotationAttributes function returns an AnnotationAttributes\n"
"object that contains the annotation settings for the active visualization\n"
"window. It is often useful to retrieve the annotation settings and modify\n"
"them to suit the visualization.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"a = GetAnnotationAttributes()\n"
"print(a)\n"
"a.backgroundMode = a.BACKGROUNDMODE_GRADIENT\n"
"a.gradientColor1 = (0, 0, 255)\n"
"SetAnnotationAttributes(a)\n"
;
const char *visit_GetAnnotationObject_doc = 
"GetAnnotationObject\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetAnnotationObject(string) -> Annotation object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"string\n"
"    The name of the annotation object as returned by GetAnnotationObjectNames.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetAnnotationObject returns a reference to an annotation object that was\n"
"    created using the CreateAnnotationObject function.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetAnnotationObject returns a reference to an annotation object that was\n"
"created using the CreateAnnotationObject function. The string\n"
"argument specifies the name of the desired annotation object. It must be\n"
"one of the names returned by GetAnnotationObjectNames. This function is not\n"
"currently necessary unless the annotation object that you used to create an\n"
"annotation has gone out of scope and you need to create another reference\n"
"to the object to set its properties. Also note that although this function\n"
"will apparently also accept an integer index, that mode of access is not\n"
"reliably and should be avoided.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"a = CreateAnnotationObject(\"TimeSlider\")\n"
"GetAnnotationObjectNames()\n"
"[\"plot0000\", \"TimeSlider1\"]\n"
"ref = GetAnnotationObject(\"TimeSlider1\")\n"
"print(ref)\n"
;
const char *visit_GetAnnotationObjectNames_doc = 
"GetAnnotationObjectNames\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetAnnotationObjectNames() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetAnnotationObjectNames returns a tuple of strings of the names of all\n"
"    annotation objects defined for the currently active window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"names = GetAnnotationObjectNames()\n"
"names\n"
"[\"plot0000\", \"Line2D1\", \"TimeSlider1\"]\n"
;
const char *visit_GetCallbackArgumentCount_doc = 
"GetCallbackArgumentCount\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetCallbackArgumentCount(callbackName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"callbackName\n"
"    The name of a callback function. This name is a member of the tuple\n"
"    returned by GetCallbackNames().\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetCallbackArgumentCount function returns the number of arguments\n"
"    associated with a particular callback function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"cbName = 'OpenDatabaseRPC'\n"
"count = GetCallbackArgumentCount(cbName)\n"
"print('The number of arguments for %s is: %d' % (cbName, count))\n"
;
const char *visit_GetCallbackNames_doc = 
"GetCallbackNames\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetCallbackNames() -> tuple of string objects\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetCallbackNames returns a tuple containing the names of valid callback\n"
"    function identifiers for use in RegisterCallback().\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetCallbackNames function returns a tuple containing the names of valid\n"
"callback function identifiers for use in RegisterCallback().\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"print(visit.GetCallbackNames())\n"
;
const char *visit_GetDatabaseNStates_doc = 
"GetDatabaseNStates\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetDatabaseNStates() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns the number of time states in the active database or 0 if there is\n"
"    no active database.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetDatabaseNStates returns the number of time states in the active\n"
"database, which is not the same as the number of states in the active time\n"
"slider. Time sliders can have different lengths due to database\n"
"correlations and keyframing. Use this function when you need the actual\n"
"number of time states in the active database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave*.silo database\")\n"
"print(\"Number of time states: %d\" % GetDatabaseNStates())\n"
;
const char *visit_GetDebugLevel_doc = 
"GetDebugLevel\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetDebugLevel() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetDebugLevel function returns the debug level of the VisIt module.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetDebugLevel and SetDebugLevel functions are used when debugging\n"
"VisIt Python scripts. The GetDebugLevel function can be used in Python\n"
"scripts to alter the behavior of the script. For instance, the debug\n"
"level can be used to selectively print values to the console.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli -debug 2\n"
"print(\"VisIt's debug level is: %d\" % GetDebugLevel())\n"
;
const char *visit_GetDefaultFileOpenOptions_doc = 
"GetDefaultFileOpenOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetDefaultFileOpenOptions(pluginName) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"pluginName\n"
"    The name of a plugin.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a dictionary containing the options.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetDefaultFileOpenOptions returns the current options used to open new\n"
"files when a specific plugin is triggered.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenMDServer()\n"
"opts = GetDefaultFileOpenOptions(\"VASP\")\n"
"opts[\"Allow multiple timesteps\"] = 1\n"
"SetDefaultFileOpenOptions(\"VASP\", opts)\n"
"OpenDatabase(\"CHGCAR\")\n"
;
const char *visit_GetDomains_doc = 
"GetDomains\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetDomains() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetDomains returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetDomains returns a tuple containing the names of all of the domain\n"
"subsets for a plot that was created using a database with multiple domains.\n"
"This function can be used in specialized logic that iterates over domains\n"
"to turn them on or off in some programmed way.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_ucd3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"doms = GetDomains()\n"
"print(doms)\n"
"# Turn off all but the last domain, one after the other.\n"
"for d in doms[:-1]:\n"
"    TurnDomainsOff(d)\n"
;
const char *visit_GetEngineList_doc = 
"GetEngineList\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetEngineList() -> tuple of strings\n"
"GetEngineList(flag) -> tuple of tuples of strings\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"flag\n"
"    If flag is a non-zero integer then the function returns a tuple of tuples\n"
"    with information about simulations.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetEngineList returns a tuple of strings that contain the names of the\n"
"    computers on which compute engines are running. If flag is a non-zero\n"
"    integer argument then the function returns a tuple of tuples where each\n"
"    tuple is of length 2. Element 0 contains the names of the computers where\n"
"    the engines are running. Element 1 contains the names of the simulations\n"
"    being run.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetEngineList function returns a tuple of strings containing the names\n"
"of the computers on which compute engines are running. This function can be\n"
"useful if engines are going to be closed and opened explicitly in the\n"
"Python script. The contents of the tuple can be used to help determine\n"
"which compute engines should be closed or they can be used to determine if\n"
"a compute engine was successfully launched.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"OpenDatabase(\"mcr:/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"DrawPlots()\n"
"for name in GetEngineList():\n"
"    print(\"VisIt has a compute engine running on %s\" % name)\n"
"    CloseComputeEngine(GetEngineList()[1])\n"
;
const char *visit_GetEngineProperties_doc = 
"GetEngineProperties\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetEngineProperties()            -> EngineProperties object\n"
"GetEngineProperties(engine)      -> EngineProperties object\n"
"GetEngineProperties(engine, sim) -> EngineProperties object\n"
"engine\n"
"When engine is passed and it matches one of the computer names returned\n"
"from GetEngineList() then the EngineProperties object for that engine is\n"
"returned.\n"
"sim\n"
"When both engine and sim arguments are passed, then the EngineProperties\n"
"object for the simulation is returned.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The EngineProperties object for the specified compute engine/sim.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetEngineProperties returns an EngineProperties object containing the properties\n"
"for the specified compute engine/sim. The EngineProperties let you discover\n"
"information such as number of processors, etc for a compute engine/sim.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/globe.silo\"\n"
"OpenDatabase(db)\n"
"props = GetEngineProperties(GetEngineList()[0])\n"
;
const char *visit_GetGlobalAttributes_doc = 
"GetGlobalAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetGlobalAttributes() -> GlobalAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a GlobalAttributes object that has been initialized.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetGlobalAttributes function returns a GlobalAttributes object that\n"
"has been initialized with the current state of the viewer proxy's\n"
"GlobalAttributes object. The GlobalAttributes object contains read-only\n"
"information about the list of sources, the list of windows, and various\n"
"flags that can be queried.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"g = GetGlobalAttributes()\n"
"print(g)\n"
;
const char *visit_GetGlobalLineoutAttributes_doc = 
"GetGlobalLineoutAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetGlobalLineoutAttributes() -> GlobalLineoutAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns an initialized GlobalLineoutAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetGlobalLineoutAttributes function returns an initialized\n"
"GlobalLineoutAttributes object. The GlobalLineoutAttributes, as suggested\n"
"by its name, contains global properties that apply to all lineouts. You can\n"
"use the GlobalLineoutAttributes object to turn on lineout sampling, specify\n"
"the destination window, etc. for curve plots created as a result of\n"
"performing lineouts. Once you make changes to the object by setting its\n"
"properties, use the SetGlobalLineoutAttributes function to make VisIt use\n"
"the modified global lineout attributes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"g = GetGlobalLineoutAttributes()\n"
"print(g)\n"
"g.samplingOn = 1\n"
"g.windowId = 4\n"
"g.createWindow = 0\n"
"g.numSamples = 100\n"
"SetGlobalLineoutAttributes(g)\n"
"Lineout((-3,2),(3,3),(\"default\"))\n"
;
const char *visit_GetInteractorAttributes_doc = 
"GetInteractorAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetInteractorAttributes() -> InteractorAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns an initialized InteractorAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetInteractorAttributes function returns an initialized\n"
"InteractorAttributes object. The InteractorAttributes object can be used to\n"
"set certain interactor properties. Interactors, can be thought of as how\n"
"mouse clicks and movements are translated into actions in the vis window.\n"
"To set the interactor attributes, first get the interactor attributes using\n"
"the GetInteractorAttributes function. Once you've set the object's\n"
"properties, call the SetInteractorAttributes function to make VisIt use the\n"
"new interactor attributes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"ia = GetInteractorAttributes()\n"
"print(ia)\n"
"ia.showGuidelines = 0\n"
"SetInteractorAttributes(ia)\n"
;
const char *visit_GetKeyframeAttributes_doc = 
"GetKeyframeAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetKeyframeAttributes() -> KeyframeAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetKeyframeAttributes returns an initialized KeyframeAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Use the GetKeyframeAttributes function when you want to examine a\n"
"KeyframeAttributes object so you can determine VisIt's state when it is in\n"
"keyframing mode. The KeyframeAttributes object allows you to see whether\n"
"VisIt is in keyframing mode and, if so, how many animation frames are in\n"
"the current keyframe animation.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"k = GetKeyframeAttributes()\n"
"print(k)\n"
"k.enabled,k.nFrames,k.nFramesWasUserSet = 1, 100, 1\n"
"SetKeyframeAttributes(k)\n"
;
const char *visit_GetLastError_doc = 
"GetLastError\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetLastError() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetLastError returns a string containing the last error message that VisIt\n"
"    issued.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetLastError function returns a string containing the last error\n"
"message that VisIt issued.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/this/database/does/not/exist\")\n"
"print(\"VisIt Error: %s\" % GetLastError())\n"
;
const char *visit_GetLight_doc = 
"GetLight\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetLight(index) -> LightAttributes object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    A zero-based integer index into the light list. Index can be in the range\n"
"    [0,7].\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetLight returns a LightAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetLight function returns a LightAttributes object containing the\n"
"attributes for a specific light. You can use the LightAttributes object\n"
"that GetLight returns to set light properties and then you can pass the\n"
"object to SetLight to make VisIt use the light properties that you've set.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"w\")\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"xray\"\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"InvertBackgroundColor()\n"
"light = GetLight(0)\n"
"print(light)\n"
"light.enabledFlag = 1\n"
"light.direction = (0,-1,0)\n"
"light.color = (255,0,0,255)\n"
"SetLight(0, light)\n"
"light.color,light.direction = (0,255,0,255), (-1,0,0)\n"
"SetLight(1, light)\n"
;
const char *visit_GetLocalHostName_doc = 
"GetLocalHostName\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetLocalHostName() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return a string.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetLocalHostName function returns a string that contains the name of\n"
"the local computer.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Local machine name is: %s\" % GetLocalHostName())\n"
"print(\"My username: %s\" % GetLocalUserName())\n"
;
const char *visit_GetLocalUserName_doc = 
"GetLocalUserName\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetLocalUserName() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return a string.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetLocalUserName function returns a string containing the name of\n"
"the user running VisIt.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Local machine name is: %s\" % GetLocalHostName())\n"
"print(\"My username: %s\" % GetLocalUserName())\n"
;
const char *visit_GetMachineProfile_doc = 
"GetMachineProfile\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMachineProfile(hostname) -> MachineProfile object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"hostname\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    MachineProfile for hostname.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Gets the MachineProfile for a given hostname\n"
;
const char *visit_GetMachineProfileNames_doc = 
"GetMachineProfileNames\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMachineProfileNames() -> [hostname1, hostname2, ...]\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    A list of MachineProfile hostnames\n"
"\n"
"\n"
"Description:\n"
"\n"
"Returns a list of hostnames that can be used to get a specific MachineProfile\n"
;
const char *visit_GetMaterialAttributes_doc = 
"GetMaterialAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMaterialAttributes() -> MaterialAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a MaterialAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetMaterialAttributes function returns a MaterialAttributes object\n"
"that contains VisIt's current material interface reconstruction settings.\n"
"You can set properties on the MaterialAttributes object and then pass it to\n"
"SetMaterialAttributes to make VisIt use the new material attributes that\n"
"you've specified:\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"p = PseudocolorAttributes()\n"
"p.min,p.minFlag = 4.0, 1\n"
"p.max,p.maxFlag = 13.0, 1\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"m = GetMaterialAttributes()\n"
"m.forceMIR = 1\n"
"SetMaterialAttributes(m)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_GetMaterials_doc = 
"GetMaterials\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMaterials() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetMaterials function returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetMaterials function returns a tuple of strings containing the names\n"
"of the available materials for the current plot's database. Note that the\n"
"active plot's database must have materials for this function to return a\n"
"tuple that has any string objects in it. Also, you must have at least one\n"
"plot. You can use the materials returned by the GetMaterials function for a\n"
"variety of purposes including turning materials on or off.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"DrawPlots()\n"
"mats = GetMaterials()\n"
"for m in mats[:-1]:\n"
"    TurnMaterialOff(m)\n"
;
const char *visit_GetMeshManagementAttributes_doc = 
"GetMeshManagementAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMeshManagementAttributes() -> MeshmanagementAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a MeshmanagementAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetMeshmanagementAttributes function returns a MeshmanagementAttributes object\n"
"that contains VisIt's current mesh discretization settings.\n"
"You can set properties on the MeshManagementAttributes object and then pass it to\n"
"SetMeshManagementAttributes to make VisIt use the new material attributes that\n"
"you've specified:\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/csg.silo\")\n"
"AddPlot(\"Mesh\", \"csgmesh\")\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"mma = GetMeshManagementAttributes()\n"
"mma.discretizationTolernace = (0.01, 0.025)\n"
"SetMeshManagementAttributes(mma)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_GetMetaData_doc = 
"GetMetaData\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMetaData(db) -> avtDatabaseMetaData object\n"
"GetMetaData(db, ts) -> avtDatabaseMetaData object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"db\n"
"    The name of the database for which to return metadata.\n"
"ts\n"
"    An optional integer indicating the time state at which to open the database.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetMetaData function returns an avtDatabaseMetaData object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt relies on metadata to populate its variable menus and make important\n"
"decisions. Metadata can be used to create complex scripts whose behavior\n"
"adapts based on the contents of the database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"md = GetMetaData('noise.silo')\n"
"for i in range(md.GetNumScalars()):\n"
"    AddPlot('Pseudocolor', md.GetScalars(i).name)\n"
"DrawPlots()\n"
;
const char *visit_GetNumPlots_doc = 
"GetNumPlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetNumPlots() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns the number of plots in the active window.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetNumPlots function returns the number of plots in the active window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"Number of plots\", GetNumPlots())\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"print(\"Number of plots\", GetNumPlots())\n"
"AddPlot(\"Mesh\", \"curvmesh2d\")\n"
"DrawPlots()\n"
"print(\"Number of plots\", GetNumPlots())\n"
;
const char *visit_GetOperatorOptions_doc = 
"GetOperatorOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetOperatorOptions(index) -> operator attributes object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the operator within the plot's list of operators.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetOperatorOptions function returns an operator attributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function is provided to make it easy to probe the current attributes for\n"
"a specific operator on the active plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"AddPlot('Pseudocolor', 'temperature')\n"
"AddOperator('Transform')\n"
"AddOperator('Transform')\n"
"t = GetOperatorOptions(1)\n"
"print('Attributes for the 2nd Transform operator:', t)\n"
;
const char *visit_GetPickAttributes_doc = 
"GetPickAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPickAttributes() -> PickAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetPickAttributes returns a PickAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPickAttributes object returns the pick settings that VisIt is\n"
"currently using when it performs picks. These settings mainly determine\n"
"which pick information is displayed when pick results are printed out but\n"
"they can also be used to select auxiliary variables and generate time\n"
"curves. You can examing the settings and you can set properties on the\n"
"returned object. Once you've changed pick settings by setting properties on\n"
"the object, you can pass the altered object to the SetPickAttributes\n"
"function to force VisIt to use the new pick settings.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/ireg\")\n"
"DrawPlots()\n"
"p = GetPickAttributes()\n"
"print(p)\n"
"p.variables = (\"default\", \"mesh/a\", \"mesh/mixvar\")\n"
"SetPickAttributes(p)\n"
"# Now do some interactive picks and you'll see pick information\n"
"# for more than 1 variable.\n"
"p.doTimeCurve = 1\n"
"SetPickAttributes(p)\n"
"# Now do some interactive picks and you'll get time-curves in\n"
"# a new window.\n"
;
const char *visit_GetPickOutput_doc = 
"GetPickOutput\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPickOutput() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetPickOutput returns a string containing the output from the last pick.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPickOutput returns a string object that contains the output from\n"
"the last pick.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"ZonePick(coord=(0.4, 0.6, 0), vars=(\"default\", \"u\", \"v\"))\n"
"s = GetPickOutput()\n"
"print(s)\n"
;
const char *visit_GetPickOutputObject_doc = 
"GetPickOutputObject\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPickOutputObject() -> dictionary\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetPickOutputObject returns a dictionary produced by the last pick.\n"
"\n"
"\n"
"Description:\n"
"\n"
"GetPickOutputObject returns a dictionary object containing output from the\n"
"last pick.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"ZonePick(coord=(0.4, 0.6, 0), vars=(\"default\", \"u\", \"v\"))\n"
"o = GetPickOutputObject()\n"
"print(o)\n"
;
const char *visit_GetPipelineCachingMode_doc = 
"GetPipelineCachingMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPipelineCachingMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetPipelineCachingMode function returns 1 if pipelines are being\n"
"    cached and 0 otherwise.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPipelineCachingMode function returns whether or not pipelines are\n"
"being cached in the viewer. For animations of long time sequences, it is\n"
"often useful to turn off pipeline caching so the viewer does not run out of\n"
"memory.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#%visit -cli\n"
"offon = (\"off\", \"on\")\n"
"print(\"Pipeline caching is %s\" % offon[GetPipelineCachingMode()])\n"
;
const char *visit_GetPlotInformation_doc = 
"GetPlotInformation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPlotInformation() -> dictionary\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetPlotInformation returns a dictionary.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPlotInformation function returns information about the active plot.\n"
"For example, a Curve plot will return the xy pairs that comprise the\n"
"curve.  The tuple is arranged <x1, y1, x2, y2, ..., xn, yn>.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"Lineout((0, 0), (1, 1))\n"
"SetActiveWindow(2)\n"
"info = GetPlotInformation()\n"
"lineout = info[\"Curve\"]\n"
"print(\"The first lineout point is: [%g, %g] \" % lineout[0], lineout[1])\n"
;
const char *visit_GetPlotList_doc = 
"GetPlotList\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPlotList() -> PlotList object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetPlotList function returns a PlotList object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPlotList function returns a copy of the plot list that gets exchanged\n"
"between VisIt's viewer and its clients. The plot list object contains the list\n"
"of plots, along with the databases, and any operators that are applied to each\n"
"plot. Changing this object has NO EFFECT but it can be useful when writing\n"
"complex functions that need to know about the plots and operators that exist\n"
"within a visualization window\n"
"\n"
"\n"
"Example:\n"
"\n"
"# Copy plots (without operators to window 2)\n"
"pL = GetPlotList()\n"
"AddWindow()\n"
"for i in range(pL.GetNumPlots()):\n"
"    AddPlot(PlotPlugins()[pL.GetPlots(i).plotType], pL.GetPlots(i).plotVar)\n"
"DrawPlots()\n"
;
const char *visit_GetPlotOptions_doc = 
"GetPlotOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPlotOptions() -> plot attributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetPlotOptions function returns a plot attributes object whose type varies\n"
"    depending the selected plots.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function is provided to make it easy to probe the current attributes for\n"
"the selected plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"pc = GetPlotOptions()\n"
"pc.legend = 0\n"
"SetPlotOptions(pc)\n"
;
const char *visit_GetPreferredFileFormats_doc = 
"GetPreferredFileFormats\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetPreferredFileFormats() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetPreferredFileFormats returns the current list of preferred plugins.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetPreferredFileFormats method is a way to get the list of\n"
"file format reader plugins which are tried before any others.\n"
"These IDs are full IDs, not just names, and are tried in order.\n"
"\n"
"\n"
"Example:\n"
"\n"
"GetPreferredFileFormats()\n"
"# returns ('Silo_1.0',)\n"
;
const char *visit_GetQueryOutputObject_doc = 
"GetQueryOutputObject\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryOutputObject() -> dictionary or value\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetQueryOutputObject returns an xml string produced by the last query.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Both the GetQueryOutputString and GetQueryOutputValue functions return\n"
"information about the last query to be executed but the type of information\n"
"returns differs. GetQueryOutputString returns a string containing the\n"
"output of the last query. GetQueryOutputValue returns a single number or\n"
"tuple of numbers, depending on the nature of the last query to be executed.\n"
"GetQueryOutputXML and GetQueryOutputObject expose more complex query output.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"Query(\"MinMax\")\n"
"print(GetQueryOutputString())\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
;
const char *visit_GetQueryOutputString_doc = 
"GetQueryOutputString\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryOutputString() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetQueryOutputString returns a string.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Both the GetQueryOutputString and GetQueryOutputValue functions return\n"
"information about the last query to be executed but the type of information\n"
"returns differs. GetQueryOutputString returns a string containing the\n"
"output of the last query. GetQueryOutputValue returns a single number or\n"
"tuple of numbers, depending on the nature of the last query to be executed.\n"
"GetQueryOutputXML and GetQueryOutputObject expose more complex query output.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"Query(\"MinMax\")\n"
"print(GetQueryOutputString())\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
;
const char *visit_GetQueryOutputValue_doc = 
"GetQueryOutputValue\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryOutputValue() -> double, tuple of doubles\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetQueryOutputValue returns a single double precision number or a tuple of\n"
"    double precision numbers.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Both the GetQueryOutputString and GetQueryOutputValue functions return\n"
"information about the last query to be executed but the type of information\n"
"returns differs. GetQueryOutputString returns a string containing the\n"
"output of the last query. GetQueryOutputValue returns a single number or\n"
"tuple of numbers, depending on the nature of the last query to be executed.\n"
"GetQueryOutputXML and GetQueryOutputObject expose more complex query output.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"Query(\"MinMax\")\n"
"print(GetQueryOutputString())\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
;
const char *visit_GetQueryOutputXML_doc = 
"GetQueryOutputXML\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryOutputXML() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetQueryOutputXML returns an xml string produced by the last query.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Both the GetQueryOutputString and GetQueryOutputValue functions return\n"
"information about the last query to be executed but the type of information\n"
"returns differs. GetQueryOutputString returns a string containing the\n"
"output of the last query. GetQueryOutputValue returns a single number or\n"
"tuple of numbers, depending on the nature of the last query to be executed.\n"
"GetQueryOutputXML and GetQueryOutputObject expose more complex query output.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"Query(\"MinMax\")\n"
"print(GetQueryOutputString())\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
;
const char *visit_GetQueryOverTimeAttributes_doc = 
"GetQueryOverTimeAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryOverTimeAttributes() -> QueryOverTimeAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetQueryOverTimeAttributes returns a QueryOverTimeAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetQueryOverTimeAttributes function returns a QueryOverTimeAttributes\n"
"object containing the settings that VisIt currently uses for query over\n"
"time. You can use the returned object to change those settings by first\n"
"setting object properties and then by passing the modified object to the\n"
"SetQueryOverTimeAttributes function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"DrawPlots()\n"
"qot = GetQueryOverTimeAttributes()\n"
"print(qot)\n"
"# Make queries over time go to window 4.\n"
"qot.createWindow,q.windowId = 0, 4\n"
"SetQueryOverTimeAttributes(qot)\n"
"QueryOverTime(\"Min\")\n"
"# Make queries over time only use half of the number of time states.\n"
"endTime = GetDatabaseNStates() / 2\n"
"QueryOverTime(\"Min\", end_time=endTime)\n"
"ResetView()\n"
;
const char *visit_GetQueryParameters_doc = 
"GetQueryParameters\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetQueryParameters(name) -> dictionary\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    A python dictionary.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetQueryParameters function returns a Python dictionary containing\n"
"the default parameters for the named query, or None if the query does\n"
"not accept additional parameters.  The returned dictionary (if any) can\n"
"then be modified if necessary and passed back as an argument to the\n"
"Query function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"minMaxInput = GetQueryParameters(\"MinMax\")\n"
"minMaxInput[\"use_actual_data\"] = 1\n"
"Query(\"MinMax\", minMaxInput)\n"
"xrayInput = GetQueryParameters(\"XRay Image\")\n"
"xrayInput[\"origin\"]=(0.5, 2.5, 0.)\n"
"xrayInput[\"image_size\"]=(300,300)\n"
"xrayInput[\"vars\"]=(\"p\", \"d\")\n"
"Query(\"XRay Image\", xrayInput)\n"
;
const char *visit_GetRenderingAttributes_doc = 
"GetRenderingAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetRenderingAttributes() -> RenderingAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a RenderingAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetRenderingAttributes function returns a RenderingAttributes object\n"
"that contains the rendering settings that VisIt currently uses. The\n"
"RenderingAttributes object contains information related to rendering such\n"
"as whether or not specular highlights or shadows are enabled. The\n"
"RenderingAttributes object also contains information scalable rendering\n"
"such as whether or not it is currently in use and the scalable rendering\n"
"threshold.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Surface\", \"hgslice\")\n"
"DrawPlots()\n"
"v = GetView3D()\n"
"v.viewNormal = (-0.215934, -0.454611, 0.864119)\n"
"v.viewUp = (0.973938, -0.163188, 0.157523)\n"
"v.imageZoom = 1.64765\n"
"SetView3D(v)\n"
"light = GetLight(0)\n"
"light.direction = (0,1,-1)\n"
"SetLight(0, light)\n"
"r = GetRenderingAttributes()\n"
"r.scalableActivationMode = r.Always\n"
"r.doShadowing = 1\n"
"SetRenderingAttributes(r)\n"
;
const char *visit_GetSaveWindowAttributes_doc = 
"GetSaveWindowAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetSaveWindowAttributes() -> SaveWindowAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    This function returns a VisIt SaveWindowAttributes object that contains\n"
"    the attributes used in saving windows.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetSaveWindowAttributes function returns a SaveWindowAttributes object\n"
"that is a structure containing several fields which determine how windows\n"
"are saved to files. The object that us returned can be modified and used to\n"
"set the save window attributes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"s = GetSaveWindowAttributes()\n"
"print(s)\n"
"s.width = 600\n"
"s.height = 600\n"
"s.format = s.RGB\n"
"print(s)\n"
;
const char *visit_GetSelection_doc = 
"GetSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetSelection(name) -> SelectionProperties object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the selection whose properties we want to retrieve.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetSelection function returns a SelectionProperties object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named selections have properties that describe how the selection is defined.\n"
"This function lets you query those selection properties.\n"
"\n"
"\n"
"Example:\n"
"\n"
"CreateNamedSelection('selection1')\n"
"s = GetSelection('selection1')\n"
"s.selectionType = s.CumulativeQuerySelection\n"
"s.histogramType = s.HistogramMatches\n"
"s.combineRule = s.CombineOr\n"
"s.variables = ('temperature',)\n"
"s.variableMins = (2.9,)\n"
"s.variableMaxs = (3.1,)\n"
"UpdateNamedSelection('selection1', s)\n"
;
const char *visit_GetSelectionList_doc = 
"GetSelectionList\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetSelectionList() -> SelectionList object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetSelectionList function returns a SelectionList object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt maintains a list of named selections, which are sets of cells that are\n"
"used to restrict the cells processed by other plots. This function returns a\n"
"list of the selections that VisIt knows about, including their properties.\n"
"\n"
"\n"
"Example:\n"
"\n"
"s = GetSelectionList()\n"
;
const char *visit_GetSelectionSummary_doc = 
"GetSelectionSummary\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetSelectionSummary(name) -> SelectionSummary object\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the selection whose summary we want to retrieve.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetSelectionSummary function returns a SelectionSummary object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named selections have both properties, which describe how the selection is\n"
"defined, and a summary that desribes the data that was processed while creating\n"
"the selection. The selection summary object contains some statistics about\n"
"the selection such as how many cells it contains and histograms of the various\n"
"variables that were used in creating the selection.\n"
"\n"
"\n"
"Example:\n"
"\n"
"print(GetSelectionSummary('selection1'))\n"
;
const char *visit_GetTimeSliders_doc = 
"GetTimeSliders\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetTimeSliders() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    GetTimeSliders returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetTimeSliders function returns a tuple of strings containing the\n"
"names of each of the available time sliders. The list of time sliders\n"
"contains the names of any open time-varying database, all database\n"
"correlations, and the keyframing time slider if VisIt is in keyframing mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"path = \"/usr/gapps/visit/data/\"\n"
"dbs = (path + \"/dbA00.pdb\", path + \"dbB00.pdb\", path + \"dbC00.pdb\")\n"
"for db in dbs:\n"
"    OpenDatabase(db)\n"
"    AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"    DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"print(\"The list of time sliders is: \", GetTimeSliders())\n"
;
const char *visit_GetUltraScript_doc = 
"GetUltraScript\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetUltraScript() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetUltraScript function returns a filename.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Return the name of the file in use by the LoadUltra function. Normal users do\n"
"not need to use this function.\n"
;
const char *visit_GetView2D_doc = 
"GetView2D\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetView2D() -> View2DAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Object that represents the 2D view information.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetView functions return ViewAttributes objects which describe the\n"
"current camera location. The GetView2D function should be called if the\n"
"active visualization window contains 2D plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Change the view interactively using the mouse.\n"
"v0 = GetView3D()\n"
"# Change the view again using the mouse\n"
"v1 = GetView3D()\n"
"print(v0)\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v1 + t * v0\n"
"    SetView3D(v2) # Animate the view back to the first view.\n"
;
const char *visit_GetView3D_doc = 
"GetView3D\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetView3D() -> View3DAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Object that represents the 3D view information.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetView functions return ViewAttributes objects which describe the\n"
"current camera location. The GetView3D function should be called to get\n"
"the view if the active visualization window contains 3D plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Change the view interactively using the mouse.\n"
"v0 = GetView3D()\n"
"# Change the view again using the mouse\n"
"v1 = GetView3D()\n"
"print(v0)\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v1 + t * v0\n"
"    SetView3D(v2) # Animate the view back to the first view.\n"
;
const char *visit_GetViewAxisArray_doc = 
"GetViewAxisArray\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetViewAxisArray() -> ViewAxisArrayAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Object that represents the AxisArray view information.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetView functions return ViewAttributes objects which describe the\n"
"current camera location. The GetViewAxisArray function should be called\n"
"if the active visualization window contains axis-array plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Change the view interactively using the mouse.\n"
"v0 = GetView3D()\n"
"# Change the view again using the mouse\n"
"v1 = GetView3D()\n"
"print(v0)\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v1 + t * v0\n"
"    SetView3D(v2) # Animate the view back to the first view.\n"
;
const char *visit_GetViewCurve_doc = 
"GetViewCurve\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetViewCurve() -> ViewCurveAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Object that represents the curve view information.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetView functions return ViewAttributes objects which describe the\n"
"current camera location. The GetViewCurve function should be called if\n"
"the active visualization window contains 1D curve plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Change the view interactively using the mouse.\n"
"v0 = GetView3D()\n"
"# Change the view again using the mouse\n"
"v1 = GetView3D()\n"
"print(v0)\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v1 + t * v0\n"
"    SetView3D(v2) # Animate the view back to the first view.\n"
;
const char *visit_GetWindowInformation_doc = 
"GetWindowInformation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetWindowInformation() -> WindowInformation object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The GetWindowInformation object returns a WindowInformation object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetWindowInformation object returns a WindowInformation object that\n"
"contains information about the active visualization window. The\n"
"WindowInformation object contains the name of the active source, the active\n"
"time slider index, the list of available time sliders and their current\n"
"states, as well as certain window flags that determine whether a window's\n"
"view is locked, etc. Use the WindowInformation object if you need to query\n"
"any of these types of information in your script to influence how it\n"
"behaves.\n"
"\n"
"\n"
"Example:\n"
"\n"
"path = \"/usr/gapps/visit/data/\"\n"
"dbs = (path + \"dbA00.pdb\", path + \"dbB00.pdb\", path + \"dbC00.pdb\")\n"
"for db in dbs:\n"
"    OpenDatabase(db)\n"
"    AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"    DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"# Get the list of available time sliders.\n"
"tsList = GetWindowInformation().timeSliders\n"
"# Iterate through \"time\" on each time slider.\n"
"for ts in tsList:\n"
"    SetActiveTimeSlider(ts)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"# Print the window information to examine the other attributes\n"
"# that are available.\n"
"GetWindowInformation()\n"
;
const char *visit_HideActivePlots_doc = 
"HideActivePlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"HideActivePlots() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The HideActivePlots function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The HideActivePlots function tells the viewer to hide the active plots in\n"
"the active visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"DrawPlots()\n"
"SetActivePlots(0)\n"
"HideActivePlots()\n"
"AddPlot(\"FilledBoundary\", \"mat1\")\n"
"DrawPlots()\n"
;
const char *visit_HideToolbars_doc = 
"HideToolbars\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"HideToolbars() -> integer\n"
"HideToolbars(allWindows) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"allWindows\n"
"    An optional integer value that tells VisIt to hide the toolbars for\n"
"    all windows when it is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The HideToolbars function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The HideToolbars function tells VisIt to hide the toolbars for the active\n"
"visualization window or for all visualization windows when the optional\n"
"allWindows argument is provided and is set to a non-zero value.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"HideToolbars()\n"
"ShowToolbars()\n"
"# Hide the toolbars for all windows.\n"
"HideToolbars(1)\n"
;
const char *visit_IconifyAllWindows_doc = 
"IconifyAllWindows\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"IconifyAllWindows()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The IconifyAllWindows function minimizes all of the hidden visualization\n"
"windows to get them out of the way.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4) # Have 4 windows\n"
"IconifyAllWindows()\n"
"DeIconifyAllWindows()\n"
;
const char *visit_InitializeNamedSelectionVariables_doc = 
"InitializeNamedSelectionVariables\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"InitializeNamedSelectionVariables(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the named selection to initialize.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The InitializeNamedSelectionVariables function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Complex thresholds are often defined using the Parallel Coordinates plot\n"
"or the Threshold operator. This function can copy variable ranges from\n"
"compatible plots and operators into the specified named selection's\n"
"properties. This can be useful when setting up Cumulative\n"
"Query selections.\n"
"\n"
"\n"
"Example:\n"
"\n"
"InitializeNamedSelectionVariables('selection1')\n"
;
const char *visit_InvertBackgroundColor_doc = 
"InvertBackgroundColor\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"InvertBackgroundColor()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The InvertBackgroundColor function swaps the background and foreground\n"
"colors in the active visualization window. This function is a cheap\n"
"alternative to setting the foreground and background colors though the\n"
"AnnotationAttributes in that it is a simple no-argument function call. It\n"
"is not adequate to set new colors for the background and foreground, but in\n"
"the event where the two colors can be exchanged favorably, it is a good\n"
"function to use. An example of when this function is used is after the\n"
"creation of a Volume plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Volume\", \"u\")\n"
"DrawPlots()\n"
"InvertBackgroundColor()\n"
;
const char *visit_Launch_doc = 
"Launch\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Launch() -> integer\n"
"Launch(program) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"program\n"
"    The complete path as a string to the top level 'visit' script.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Launch functions return 1 for success and 0 for failure\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Launch function is used to launch VisIt's viewer when the VisIt module\n"
"is imported into a stand-alone Python interpreter. The Launch function has\n"
"no effect when a viewer already exists. The difference between Launch and\n"
"LaunchNowin is that LaunchNowin prevents the viewer from ever creating\n"
"onscreen visualization windows. The LaunchNowin function is primarily used\n"
"in Python scripts that want to generate visualizations using VisIt without\n"
"the use of a display such as when generating movies.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"import visit\n"
"visit.AddArgument(\"-nowin\")\n"
"visit.Launch()\n"
;
const char *visit_LaunchNowin_doc = 
"LaunchNowin\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LaunchNowin() -> integer\n"
"LaunchNowin(program) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"program\n"
"    The complete path as a string to the top level 'visit' script.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The LaunchNowin functions return 1 for success and 0 for failure\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Launch function is used to launch VisIt's viewer when the VisIt module\n"
"is imported into a stand-alone Python interpreter. The Launch function has\n"
"no effect when a viewer already exists. The difference between Launch and\n"
"LaunchNowin is that LaunchNowin prevents the viewer from ever creating\n"
"onscreen visualization windows. The LaunchNowin function is primarily used\n"
"in Python scripts that want to generate visualizations using VisIt without\n"
"the use of a display such as when generating movies.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.AddArgument(\"-geometry\")\n"
"visit.AddArgument(\"1024x1024\")\n"
"visit.LaunchNowin()\n"
;
const char *visit_Lineout_doc = 
"Lineout\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Lineout(start, end) -> integer\n"
"Lineout(start, end, variables) -> integer\n"
"Lineout(start, end, samples) -> integer\n"
"Lineout(start, end, variables, samples) -> integer\n"
"Lineout(keywordarg1=arg1, keywrdarg2=arg2,...,keywordargn=argn ) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"start\n"
"    A 2 or 3 item tuple containing the coordinates of the starting point.\n"
"    keyword arg - start_point\n"
"end\n"
"    A 2 or 3 item tuple containing the coordinates of the end point.\n"
"    keyword arg - end_point\n"
"variables\n"
"    A tuple of strings containing the names of the variables for which\n"
"    lineouts should be created.\n"
"    keyword arg - vars\n"
"samples\n"
"    An integer value containing the number of sample points along the lineout.\n"
"    keyword arg - num_samples\n"
"    keyword arg - use_sampling\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Lineout function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Lineout function extracts data along a given line segment and creates\n"
"curves from it in a new visualization window. The start argument is a tuple\n"
"of numbers that make up the coordinate of the lineout's starting location.\n"
"The end argument is a tuple of numbers that make up the coordinate of the\n"
"lineout's ending location. The optional variables argument is a tuple of\n"
"strings that contain the variables that should be sampled to create\n"
"lineouts. The optional samples argument is used to determine the number of\n"
"sample points that should be taken along the specified line. If the samples\n"
"argument is not provided then VisIt will sample the mesh where it\n"
"intersects the specified line instead of using the number of samples to\n"
"compute a list of points to sample.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"ascii\")\n"
"DrawPlots()\n"
"Lineout((0.2,0.2), (0.8,1.2))\n"
"Lineout((0.2,1.2), (0.8,0.2), (\"default\", \"d\", \"u\"))\n"
"Lineout((0.6, 0.1), (0.6, 1.2), 100)\n"
"Lineout(start_point=(0.6, 0.1), end_point=(0.6, 1.2), use_sampling=1, num_samples=100)\n"
;
const char *visit_ListDomains_doc = 
"ListDomains\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ListDomains()\n"
"\n"
"\n"
"Description:\n"
"\n"
"ListDomains  prints a list of the domains for the active plots, which\n"
"indicates which domains are on and off. The list functions are used\n"
"mostly to print the results of restricting the SIL.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"ListMaterials() # List the materials in the SIL restriction\n"
;
const char *visit_ListMaterials_doc = 
"ListMaterials\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ListMaterials()\n"
"\n"
"\n"
"Description:\n"
"\n"
"ListMaterials prints a list of the materials for the active plots, which\n"
"indicates which materials are on and off. The list functions are used\n"
"mostly to print the results of restricting the SIL.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"ListMaterials() # List the materials in the SIL restriction\n"
;
const char *visit_ListPlots_doc = 
"ListPlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ListPlots() -> string\n"
"ListPlots(stringOnly) -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ListPlots function returns a string containing a representation of the.\n"
"    plot list.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Sometimes it is difficult to remember the order of the plots in the active\n"
"visualization window's plot list. The ListPlots function prints the\n"
"contents of the plot list to the output console and returns that string as well.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Contour\", \"d\")\n"
"DrawPlots()\n"
"ListPlots()\n"
;
const char *visit_LoadAttribute_doc = 
"LoadAttribute\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LoadAttribute(filename, object)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The name of the XML file to load the attribute from or save the attribute to.\n"
"    object\n"
"    The object to load or save.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The LoadAttribute and SaveAttribute methods save a single\n"
"attribute, such as a current plot or operator python object,\n"
"to a standalone XML file.  Note that LoadAttribute requires\n"
"that the target attribute already be created by other means;\n"
"it fills, but does not create, the attribute.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"a = MeshPlotAttributes()\n"
"SaveAttribute('mesh.xml', a)\n"
"b = MeshPlotAttributes()\n"
"LoadAttribute('mesh.xml', b)\n"
;
const char *visit_LoadNamedSelection_doc = 
"LoadNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LoadNamedSelection(name) -> integer\n"
"LoadNamedSelection(name, engineName) -> integer\n"
"LoadNamedSelection(name, engineName, simName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a named selection.\n"
"engineName\n"
"    (optional) The name of the engine where the selection was saved.\n"
"simName\n"
"    (optional) The name of the simulation that saved the selection.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The LoadNamedSelection function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named Selections allow you to select a group of elements (or particles).\n"
"One typically creates a named selection from a group of elements and then\n"
"later applies the named selection to another plot (thus reducing the\n"
"set of elements displayed to the ones from when the named selection was\n"
"created).  Named selections only last for the current session.  However,\n"
"if you find a named selection that is particularly interesting, you can\n"
"save it to a file for use in later sessions.  You would use\n"
"LoadNamedSelection to do the loading.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"LoadNamedSelection(\"selection_from_previous_session\")\n"
"ApplyNamedSelection(\"selection_from_previous_session\")\n"
;
const char *visit_LoadUltra_doc = 
"LoadUltra\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LoadUltra()\n"
"\n"
"\n"
"Description:\n"
"\n"
"LoadUltra launches the Ultra command parser, allowing you to enter Ultra\n"
"commands and have VisIt process them.  A new command prompt is presented,\n"
"and only Ultra commands will be allowed until 'end' or 'quit' is entered,\n"
"at which time, you will be returned to VisIt's cli prompt.  For information\n"
"on currently supported commands, type 'help' at the Ultra prompt\n"
"Please note that filenames/paths must be surrounded by quotes, unlike with\n"
"Ultra.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"#>>> LoadUltra()\n"
"#U-> rd \"../../data/distribution.ultra\"\n"
"#U-> select 1\n"
"#U-> end\n"
"#>>>\n"
;
const char *visit_LocalNameSpace_doc = 
"LocalNameSpace\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LocalNameSpace()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The LocalNameSpace function tells the VisIt module to add plugin functions\n"
"to the global namespace when the VisIt module is imported into a\n"
"stand-alone Python interpreter. This is the default behavior when using\n"
"VisIt's cli program.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.LocalNameSpace()\n"
"visit.Launch()\n"
;
const char *visit_LongFileName_doc = 
"LongFileName\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"LongFileName(filename) -> string\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    A string object containing the short filename to expand.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The LongFileName function returns a string. This function returns the\n"
"    input argument unless you are on the Windows platform.\n"
"\n"
"\n"
"Description:\n"
"\n"
"On Windows, filenames can have two different sizes: traditional 8.3\n"
"format, and long format. The long format, which lets you name files\n"
"whatever you want, is implemented using the traditional 8.3 format under\n"
"the covers. Sometimes filenames are given to VisIt in the traditional 8.3\n"
"format and must be expanded to long format before it is possible to open\n"
"them. If you ever find that you need to do this conversion, such as when\n"
"you process command line arguments, then you can use the LongFileName\n"
"function to return the longer filename.\n"
;
const char *visit_MoveAndResizeWindow_doc = 
"MoveAndResizeWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MoveAndResizeWindow(win, x, y, w, h) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"win\n"
"    The integer id of the window to be moved [1..16].\n"
"x\n"
"    The new integer x location for the window being moved.\n"
"y\n"
"    The new integer y location for the window being moved.\n"
"w\n"
"    The new integer width for the window being moved.\n"
"h\n"
"    The new integer height for the window being moved.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    MoveAndResizeWindow returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"MoveAndResizeWindow moves and resizes a visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"MoveAndResizeWindow(1, 100, 100, 300, 600)\n"
;
const char *visit_MovePlotDatabaseKeyframe_doc = 
"MovePlotDatabaseKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MovePlotDatabaseKeyframe(index, oldFrame, newFrame)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    An integer representing the index of the plot in the plot list.\n"
"oldFrame\n"
"    An integer that is thhe old animation frame where the keyframe is located.\n"
"newFrame\n"
"    An integer that is the new animation frame where the keyframe will be moved.\n"
"\n"
"\n"
"Description:\n"
"\n"
"MovePlotDatabaseKeyframe moves a database keyframe for a specified plot to\n"
"a new animation frame, which changes the list of database time states that\n"
"are used for each animation frame when VisIt is in keyframing mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"SetPlotFrameRange(0, 0, nFrames-1)\n"
"SetPlotDatabaseKeyframe(0, 0, 70)\n"
"SetPlotDatabaseKeyframe(0, nFrames/2, 35)\n"
"SetPlotDatabaseKeyframe(0, nFrames-1, 0)\n"
"DrawPlots()\n"
"for state in list(range(TimeSliderGetNStates())) + [0]:\n"
"    SetTimeSliderState(state)\n"
"MovePlotDatabaseKeyframe(0, nFrames/2, nFrames/4)\n"
"for state in list(range(TimeSliderGetNStates())) + [0]:\n"
"    SetTimeSliderState(state)\n"
;
const char *visit_MovePlotKeyframe_doc = 
"MovePlotKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MovePlotKeyframe(index, oldFrame, newFrame)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    An integer representing the index of the plof in the plot list.\n"
"oldFrame\n"
"    An integer that is the old animation frame where the keyframe is located.\n"
"newFrame\n"
"    An integer that is the new animation frame where the keyframe will be moved.\n"
"\n"
"\n"
"Description:\n"
"\n"
"MovePlotKeyframe moves a keyframe for a specified plot to a new animation\n"
"frame, which changes the plot attributes that are used for each animation\n"
"frame when VisIt is in keyframing mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Contour\", \"hgslice\")\n"
"DrawPlots()\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"SetKeyframeAttributes(k)\n"
"SetPlotFrameRange(0, 0, nFrames-1)\n"
"c = ContourAttributes()\n"
"c.contourNLevels = 5\n"
"SetPlotOptions(c)\n"
"SetTimeSliderState(nFrames/2)\n"
"c.contourNLevels = 10\n"
"SetPlotOptions(c)\n"
"c.contourLevels = 25\n"
"SetTimeSliderState(nFrames-1)\n"
"SetPlotOptions(c)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
"temp = nFrames-2\n"
"MovePlotKeyframe(0, nFrames/2, temp)\n"
"MovePlotKeyframe(0, nFrames-1, nFrames/2)\n"
"MovePlotKeyframe(0, temp, nFrames-1)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_MovePlotOrderTowardFirst_doc = 
"MovePlotOrderTowardFirst\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MovePlotOrderTowardFirst(index) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the plot that will be moved within the plot list.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The MovePlotOrderTowardFirst function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function shifts the specified plot one slot towards the start of the plot list.\n"
"\n"
"\n"
"Example:\n"
"\n"
"MovePlotOrderTowardFirst(2)\n"
;
const char *visit_MovePlotOrderTowardLast_doc = 
"MovePlotOrderTowardLast\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MovePlotOrderTowardLast(index) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the plot that will be moved within the plot list.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The MovePlotOrderTowardLast function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function shifts the specified plot one slot towards the end of the plot list.\n"
"\n"
"\n"
"Example:\n"
"\n"
"MovePlotOrderTowardLast(0)\n"
;
const char *visit_MoveViewKeyframe_doc = 
"MoveViewKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MoveViewKeyframe(oldFrame, newFrame) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"oldFrame\n"
"    An integer that is the old animation frame where the keyframe is located.\n"
"newFrame\n"
"    An integer that is the new animation frame where the keyframe will be moved.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    MoveViewKeyframe returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"MoveViewKeyframe moves a view keyframe to a new animation frame, which\n"
"changes the view that is used for each animation frame when VisIt is in\n"
"keyframing mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Contour\", \"hardyglobal\")\n"
"DrawPlots()\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"SetKeyframeAttributes(k)\n"
"SetViewKeyframe()\n"
"SetTimeSliderState(nFrames/2)\n"
"v = GetView3d()\n"
"v.viewNormal = (-0.616518, 0.676972, 0.402014)\n"
"v.viewUp = (0.49808, 0.730785, -0.466764)\n"
"SetViewKeyframe()\n"
"SetTimeSliderState(0)\n"
"# Move the view keyframe to the last animation frame.\n"
"MoveViewKeyframe(nFrames/2, nFrames-1)\n"
;
const char *visit_MoveWindow_doc = 
"MoveWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"MoveWindow(win, x, y) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"win\n"
"    The integer id of the window to be moved [1..16].\n"
"x\n"
"    The new integer x location for the window being moved.\n"
"y\n"
"    The new integer y location for the window being moved.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    MoveWindow returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"MoveWindow moves a visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"MoveWindow(1, 100, 100)\n"
;
const char *visit_NodePick_doc = 
"NodePick\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"NodePick(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"coord\n"
"    A tuple of doubles containing the spatial coordinate (x, y, z).\n"
"x\n"
"    An integer containing the screen X location (in pixels) offset\n"
"    from the left side of the visualization window.\n"
"y\n"
"    An integer containing the screen Y location (in pixels) offset\n"
"    from the bottom of the visualization window.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    NodePick returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created\n"
"    in a new window.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The NodePick function prints pick information for the node closest to the\n"
"specified point. The point can be specified as a 2D or 3D point in world\n"
"space or it can be specified as a pixel location in screen space. If the\n"
"point is specified as a pixel location then VisIt finds the node closest to\n"
"a ray that is projected into the mesh. Once the nodal pick has been\n"
"calculated, you can use the GetPickOutput function to retrieve the printed\n"
"pick output as a string which can be used for other purposes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"# Perform node pick in screen space\n"
"pick_out = NodePick(x=200,y=200)\n"
"# Perform node pick in world space.\n"
"pick_out = NodePick(coord=(-5.0, 5.0, 0))\n"
;
const char *visit_NumColorTableNames_doc = 
"NumColorTableNames\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"NumColorTableNames() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The NumColorTableNames function return an integer.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The NumColorTableNames function returns the number of color tables that\n"
"have been defined.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"default\"\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"print(\"There are %d color tables.\" % NumColorTableNames())\n"
"for ct in ColorTableNames():\n"
"    SetActiveContinuousColorTable(ct)\n"
"    SaveWindow()\n"
;
const char *visit_NumOperatorPlugins_doc = 
"NumOperatorPlugins\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"NumOperatorPlugins() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The NumOperatorPlugins function returns an integer.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The NumOperatorPlugins function returns the number of available operator\n"
"plugins.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"The number of operator plugins is: \", NumOperatorPlugins())\n"
"print(\"The names of the plugins are: \", OperatorPlugins())\n"
;
const char *visit_NumPlotPlugins_doc = 
"NumPlotPlugins\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"NumPlotPlugins() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The NumPlotPlugins function returns an integer.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The NumPlotPlugins function returns the number of available plot plugins.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"The number of plot plugins is: \", NumPlotPlugins())\n"
"print(\"The names of the plugins are: \", PlotPlugins())\n"
;
const char *visit_OpenComputeEngine_doc = 
"OpenComputeEngine\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"OpenComputeEngine() -> integer\n"
"OpenComputeEngine(hostName) -> integer\n"
"OpenComputeEngine(hostName, simulation) -> integer\n"
"OpenComputeEngine(hostName, args) -> integer\n"
"OpenComputeEngine(MachineProfile) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"hostName\n"
"    The name of the computer on which to start the engine.\n"
"args\n"
"    Optional tuple of command line arguments for the engine.\n"
"    Alternative arguments - MachineProfile object to load with\n"
"    OpenComputeEngine call\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The OpenComputeEngine function returns an integer value of 1 for success\n"
"    and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The OpenComputeEngine function is used to explicitly open a compute engine\n"
"with certain properties. When a compute engine is opened implicitly, the\n"
"viewer relies on sets of attributes called host profiles. Host profiles\n"
"determine how compute engines are launched. This allows compute engines to\n"
"be easily launched in parallel. Since the VisIt Python Interface does not\n"
"expose VisIt's host profiles, it provides the OpenComputeEngine function to\n"
"allow users to launch compute engines. The OpenComputeEngine function must\n"
"be called before opening a database in order to prevent any latent host\n"
"profiles from taking precedence.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"# Launch parallel compute engine remotely.\n"
"args = (\"-np\", \"16\", \"-nn\", \"4\")\n"
"OpenComputeEngine(\"thunder\", args)\n"
"OpenDatabase(\"thunder:/usr/gapps/visit/data/multi_ucd3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
;
const char *visit_OpenDatabase_doc = 
"OpenDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"OpenDatabase(databaseName) -> integer\n"
"OpenDatabase(databaseName, timeIndex) -> integer\n"
"OpenDatabase(databaseName, timeIndex, dbPluginName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"databaseName\n"
"    The name of the database to open.\n"
"timeIndex\n"
"    This is an optional integer argument indicating the time index at which\n"
"    to open the database. If it is not specified, a time index of zero is\n"
"    assumed.\n"
"dbPluginIndex\n"
"    An optional string containing the name of the plugin to use. Note that\n"
"    this string must also include the plugin's version number (with few\n"
"    exceptions, almost all plugins' version numbers are 1.0). Note also\n"
"    that you must capitalize the spelling identically to what the plugin's\n"
"    GetName() method returns. For example, \"XYZ_1.0\" is the string you would\n"
"    use for the XYZ plugin.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The OpenDatabase function returns an integer value of 1 for success and 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The OpenDatabase function is one of the most important functions in the\n"
"VisIt Python Interface because it opens a database so it can be plotted.\n"
"The databaseName argument is a string containing the full name of the\n"
"database to be opened. The database name is of the form:\n"
"computer:/path/filename. The computer part of the filename can be omitted\n"
"if the database to be opened resides on the local computer.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"OpenDatabase(\"mcr:/usr/gapps/visit/data/multi_ucd3d.silo\")\n"
"OpenDatabase(\"file.visit\")\n"
"OpenDatabase(\"file.visit\", 4)\n"
"OpenDatabase(\"mcr:/usr/gapps/visit/data/multi_ucd3d.silo\",0,\"Silo_1.0\")\n"
;
const char *visit_OpenMDServer_doc = 
"OpenMDServer\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"OpenMDServer() -> integer\n"
"OpenMDServer(host) -> integer\n"
"OpenMDServer(host, args) -> integer\n"
"OpenMDServer(MachineProfile) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"host\n"
"    The optional host argument determines the host on which the metadata\n"
"    server is to be launched. If this argument is not provided, \"localhost\"\n"
"    is assumed.\n"
"args\n"
"    A tuple of strings containing command line flags for the metadata server.\n"
"    \n"
"    =============  ========================================================\n"
"    **Argument**   Description\n"
"    =============  ========================================================\n"
"    -debug #       The -debug argument allows you to specify a debug level.\n"
"    -dir visitdir  The -dir argument allows you to specify where VisIt is.\n"
"    =============  ========================================================\n"
"MachineProfile\n"
"    MachineProfile object to load with OpenMDServer call\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The OpenMDServer function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The OpenMDServer explicitly launches a metadata server on a specified\n"
"host. This allows you to provide command line options that influence how\n"
"the metadata server will run.\n"
"range [1,5] that VisIt uses to write debug logs to disk.\n"
"located on a remote computer. This allows you to successfully\n"
"connect to a remote computer in the absence of host profiles.\n"
"It also allows you to debug VisIt in distributed mode.\n"
"-fallback_format <format>\n"
"The -fallback_format argument allows you to specify the\n"
"database plugin that will be used to open files if all\n"
"other guessing failed. This is useful when the files\n"
"that you want to open do not have file extensions.\n"
"-assume_format <format>\n"
"The -assume_format argument allows you to specify the\n"
"database plugin that will be used FIRST when attempting\n"
"to open files. This is useful when the files that you\n"
"want to open have a file extension which may match\n"
"multiple file format readers.\n"
"\n"
"\n"
"Example:\n"
"\n"
"\n"
"#% visit -cli -assume_format PDB\n"
"#args = (\"-dir\", \"/my/private/visit/version/\", \"-assume_format\", \"PDB\", \"-debug\", \"4\")\n"
"# Open a metadata server before the call to OpenDatabase so we\n"
"# can launch it how we want.\n"
"OpenMDServer(\"thunder\", args)\n"
"OpenDatabase(\"thunder:/usr/gapps/visit/data/allinone00.pdb\")\n"
"# Open a metadata server on localhost too.\n"
"OpenMDServer()\n"
;
const char *visit_OperatorPlugins_doc = 
"OperatorPlugins\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"OperatorPlugins() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The OperatorPlugins function returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The OperatorPlugins function returns a tuple of strings that contain the\n"
"names of the loaded operator plugins. This can be useful for the creation\n"
"of scripts that alter their behavior based on the available operator\n"
"plugins.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"for plugin in OperatorPlugins():\n"
"    print(\"The %s operator plugin is loaded.\" % plugin)\n"
;
const char *visit_OverlayDatabase_doc = 
"OverlayDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"OverlayDatabase(databaseName) -> integer\n"
"OverlayDatabase(databaseName, state) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"databaseName\n"
"    The name of the new plot database.\n"
"    state\n"
"    The time state at which to open the database.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The OverlayDatabase function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt has the concept of overlaying plots which, in the nutshell, means\n"
"that the entire plot list is copied and a new set of plots with exactly the\n"
"same attributes but a different database is appended to the plot list of\n"
"the active window. The OverlayDatabase function allows the VisIt Python\n"
"Interface to overlay plots. OverlayDatabase takes a single string argument\n"
"which contains the name of the database. After calling the OverlayDatabase\n"
"function, the plot list is larger and contains plots of the specified\n"
"overlay database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"OverlayDatabase(\"riptide:/usr/gapps/visit/data/curv3d.silo\")\n"
;
const char *visit_PickByGlobalNode_doc = 
"PickByGlobalNode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByGlobalNode(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"element\n"
"    An integer with the global node id.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByGlobalNode returns a python dictionary of pick results.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByGlobalNode function tells VisIt to perform pick using a specific\n"
"global node index for the entire problem. Some meshes are broken up into\n"
"smaller \"domains\" and then these smaller domains can employ a global\n"
"indexing scheme to make it appear as though the mesh was still one large\n"
"mesh. Not all meshes that have been decomposed into domains provide\n"
"sufficient information to allow global node indexing. You can use the\n"
"GetPickOutput function to retrieve a string containing the pick information\n"
"once you've called PickByGlobalNode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/global_node.silo\")\n"
"AddPlot(\"Pseudocolor\", \"dist\")\n"
"DrawPlots()\n"
"# Pick on global node 236827\n"
"pick_out = PickByGlobalNode(element=246827)\n"
"# examine output\n"
"print('value of dist at global node 246827: %g' % pick_out['dist'])\n"
"print('local domain/node: %d/%d' % (pick_out['domain_id'], pick_out['node_id']))\n"
"# get last pick output as string\n"
"print('Last pick = ', GetPickOutput())\n"
;
const char *visit_PickByGlobalZone_doc = 
"PickByGlobalZone\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByGlobalZone(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"element\n"
"    An integer with the global zone id.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByGlobalZone returns a python dictionary of pick results.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByGlobalZone function tells VisIt to perform pick using a specific\n"
"global cell index for the entire problem. Some meshes are broken up into\n"
"smaller \"domains\" and then these smaller domains can employ a global\n"
"indexing scheme to make it appear as though the mesh was still one large\n"
"mesh. Not all meshes that have been decomposed into domains provide\n"
"sufficient information to allow global cell indexing. You can use the\n"
"GetPickOutput function to retrieve a string containing the pick information\n"
"once you've called PickByGlobalZone.\n"
"\n"
"\n"
"Example:\n"
"\n"
"OpenDatabase(\"/usr/gapps/visit/data/global_node.silo\")\n"
"AddPlot(\"Pseudocolor\", \"p\")\n"
"DrawPlots()\n"
"# Pick on global zone 237394\n"
"pick_out = PickByGlobalZone(element=237394)\n"
"# examine output\n"
"print('value of p at global zone 237394: %g' % pick_out['p'])\n"
"print('local domain/zone: %d/%d' % (pick_out['domain_id'], pick_out['zone_id']))\n"
"# get last pick output as string\n"
"print('Last pick = ', GetPickOutput())\n"
;
const char *visit_PickByNode_doc = 
"PickByNode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByNode(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"domain\n"
"    An integer with the domain id.\n"
"element\n"
"    An integer with the node id.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes. Currently, this is only available when performing\n"
"    a pick range.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByNode returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created in a\n"
"    new window. If the picked variable is zone centered, the variable\n"
"    values are grouped according to incident zone ids.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByNode function tells VisIt to perform pick using a specific node\n"
"index in a given domain. Other pick by node variants first determine the\n"
"node that is closest to some user-specified 3D point but the PickByNode\n"
"functions cuts out this step and allows you to directly pick on the node of\n"
"your choice. You can use the GetPickOutput function to retrieve a string\n"
"containing the pick information once you've called PickByNode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Pick on node 200 in the first domain.\n"
"pick_out = PickByNode(element=200, domain=1)\n"
"# examine output\n"
"print('value of u at node 200: %g' % pick_out['u'])\n"
"# Pick on node 100 in domain 5 and return information for two additional\n"
"# variables.\n"
"pick_out = PickByNode(domain=5, element=100, vars=(\"u\", \"v\", \"d\"))\n"
"# examine output\n"
"print('incident zones for node 100: ', pick_out['incident_zones'])\n"
"print('value of d at incident zone %d: %g' % (pick_out['incident_zones'][0], pick_out['d'][str(pick_out['incident_zones'][0])]))\n"
"# print results formatted as string\n"
"print(\"Last pick = \", GetPickOutput())\n"
;
const char *visit_PickByNodeLabel_doc = 
"PickByNodeLabel\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByNodeLabel(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"element_label\n"
"    An string with the label of the node to pick.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByNodeLabel returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created in a\n"
"    new window. If the picked variable is node centered, the variable\n"
"    values are grouped according to incident node ids.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByNodeLabel function tells VisIt to perform pick using a specific cell\n"
"label. Other pick by zone variants first determine the\n"
"cell that contains some user-specified 3D point but the PickByZone\n"
"functions cuts out this step and allows you to directly pick on the cell of\n"
"your choice. You can use the GetPickOutput function to retrieve a string\n"
"containing the pick information once you've called PickByZone.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Pick on node labeled \"node 4\".\n"
"pick_out = PickByNodeLabel(element_label=\"node 4\")\n"
"# Pick on cell labeled \"node 4\" using a python dictionary.\n"
"opts = {}\n"
"opts[\"element_label\"] =\"node 4\"\n"
"pick_out = PickByNodeLabel(opts)\n"
"# examine output\n"
"print('value of d at \"node 4\": %g' % pick_out['d'])\n"
"# Pick on node labeled \"node 12\" return information for two additional\n"
"# variables.\n"
"pick_out = PickByNodeLabel(element_label=\"node 12\", vars=(\"d\", \"u\", \"v\"))\n"
"# examine output\n"
"print('incident nodes for \"node 12\": ', pick_out['incident_nodes'])\n"
"print('values of u at incident node %d: %g' % (pick_out['incident_nodes'][0], pick_out['u'][str(pick_out['incident_zones'][0])]))\n"
"# print results formatted as string\n"
"print(\"Last pick = \", GetPickOutput())\n"
;
const char *visit_PickByZone_doc = 
"PickByZone\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByZone(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"domain\n"
"    An integer with the domain id.\n"
"element\n"
"    An integer with the zone id.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes. Currently, this is only available when performing\n"
"    a pick range.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByZone returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created in a\n"
"    new window. If the picked variable is node centered, the variable\n"
"    values are grouped according to incident node ids.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByZone function tells VisIt to perform pick using a specific cell\n"
"index in a given domain. Other pick by zone variants first determine the\n"
"cell that contains some user-specified 3D point but the PickByZone\n"
"functions cuts out this step and allows you to directly pick on the cell of\n"
"your choice. You can use the GetPickOutput function to retrieve a string\n"
"containing the pick information once you've called PickByZone.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Pick on cell 200 in the second domain.\n"
"pick_out = PickByZone(element=200, domain=2)\n"
"# examine output\n"
"print('value of d at zone 200: %g' % pick_out['d'])\n"
"# Pick on cell 100 in domain 5 and return information for two additional\n"
"# variables.\n"
"pick_out = PickByZone(element=100, domain=5, vars=(\"d\", \"u\", \"v\"))\n"
"# examine output\n"
"print('incident nodes for zone 100: ', pick_out['incident_nodes'])\n"
"print('values of u at incident zone %d: %g' % (pick_out['incident_nodes'][0], pick_out['u'][str(pick_out['incident_zones'][0])]))\n"
"# print results formatted as string\n"
"print(\"Last pick = \", GetPickOutput())\n"
;
const char *visit_PickByZoneLabel_doc = 
"PickByZoneLabel\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PickByZoneLabel(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"element_label\n"
"    An string with the label of the zone to pick.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PickByZoneLabel returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created in a\n"
"    new window. If the picked variable is node centered, the variable\n"
"    values are grouped according to incident node ids.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PickByZoneLabel function tells VisIt to perform pick using a specific cell\n"
"label. Other pick by zone variants first determine the\n"
"cell that contains some user-specified 3D point but the PickByZone\n"
"functions cuts out this step and allows you to directly pick on the cell of\n"
"your choice. You can use the GetPickOutput function to retrieve a string\n"
"containing the pick information once you've called PickByZone.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Pick on cell labeled \"brick 4\".\n"
"pick_out = PickByZoneLabel(element_label=\"brick 4\")\n"
"# Pick on cell labeled \"brick 4\" using a python dictionary.\n"
"opts = {}\n"
"opts[\"element_label\"] =\"brick 4\"\n"
"pick_out = PickByZoneLabel(opts)\n"
"# examine output\n"
"print('value of d at \"brick 4\": %g' % pick_out['d'])\n"
"# Pick on cell labeled \"shell 12\" return information for two additional\n"
"# variables.\n"
"pick_out = PickByZoneLabel(element_label=\"shell 12\", vars=(\"d\", \"u\", \"v\"))\n"
"# examine output\n"
"print('incident nodes for \"shell 12\": ', pick_out['incident_nodes'])\n"
"print('values of u at incident zone %d: %g' % (pick_out['incident_nodes'][0], pick_out['u'][str(pick_out['incident_zones'][0])]))\n"
"# print results formatted as string\n"
"print(\"Last pick = \", GetPickOutput())\n"
;
const char *visit_PlotPlugins_doc = 
"PlotPlugins\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PlotPlugins() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The PlotPlugins function returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PlotPlugins function returns a tuple of strings that contain the names\n"
"of the loaded plot plugins. This can be useful for the creation of scripts\n"
"that alter their behavior based on the available plot plugins.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"for plugin in PluginPlugins():\n"
"    print(\"The %s plot plugin is loaded.\" % plugin)\n"
;
const char *visit_PointPick_doc = 
"PointPick\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PointPick(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"coord\n"
"    A tuple of doubles containing the spatial coordinate (x, y, z).\n"
"x\n"
"    An integer containing the screen X location (in pixels) offset from the\n"
"    left side of the visualization window.\n"
"y\n"
"    An integer containing the screen Y location (in pixels) offset from the\n"
"    bottom of the visualization window.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PointPick returns a python dictionary of the pick results,\n"
"    unless do_time is specified, then a time curve is created in a new window.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PointPick function prints pick information for the node closest to the\n"
"specified point. The point can be specified as a 2D or 3D point in world\n"
"space or it can be specified as a pixel location in screen space. If the\n"
"point is specified as a pixel location then VisIt finds the node closest to\n"
"a ray that is projected into the mesh. Once the nodal pick has been\n"
"calculated, you can use the GetPickOutput function to retrieve the printed\n"
"pick output as a string which can be used for other purposes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"# Perform node pick in screen space\n"
"pick_out = PointPick(x=200,y=200)\n"
"# Perform node pick in world space.\n"
"pick_out = PointPick(coord=(-5.0, 5.0, 0))\n"
;
const char *visit_PrintWindow_doc = 
"PrintWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PrintWindow() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The PrintWindow function returns an integer value of 1 for success and 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PrintWindow function tells the viewer to print the image in the active\n"
"visualization window using the current printer settings.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"DrawPlots()\n"
"PrintWindow()\n"
;
const char *visit_PromoteOperator_doc = 
"PromoteOperator\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PromoteOperator(opIndex) -> integer\n"
"PromoteOperator(opIndex, applyToAllPlots) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"opIndex\n"
"    A zero-based integer corresponding to the operator that should be promoted.\n"
"applyToAllPlots\n"
"    An integer flag that causes all plots in the plot list to be affected when\n"
"    it is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    PromoteOperator returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The PromoteOperator function moves an operator closer to the end of the\n"
"visualization pipeline. This allows you to change the order of operators\n"
"that have been applied to a plot without having to remove them from the\n"
"plot. For example, consider moving a Slice to after a Reflect operator when\n"
"it had been the other way around. Changing the order of operators can\n"
"result in vastly different results for a plot. The opposite function is\n"
"DemoteOperator.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hardyglobal\")\n"
"AddOperator(\"Slice\")\n"
"s = SliceAttributes()\n"
"s.project2d = 0\n"
"s.originPoint = (0,5,0)\n"
"s.originType=s.Point\n"
"s.normal = (0,1,0)\n"
"s.upAxis = (-1,0,0)\n"
"SetOperatorOptions(s)\n"
"AddOperator(\"Reflect\")\n"
"DrawPlots()\n"
"# Now slice after reflect. We'll only get 1 slice plane instead of 2.\n"
"PromoteOperator(0)\n"
"DrawPlots()\n"
;
const char *visit_PythonQuery_doc = 
"PythonQuery\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"PythonQuery(source='python filter source ...') -> integer\n"
"PythonQuery(file='path/to/python_filter_script.py') -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"source\n"
"    A string containing the source code for a Python Query Filter .\n"
"file\n"
"    A string containing the path to a Python Query Filter script file.\n"
"    Note - Use only one of the 'source' or 'file' arguments. If both are\n"
"    used the 'source' argument overrides 'file'.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The PythonQuery function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Used to execute a Python Filter Query.\n"
;
const char *visit_Queries_doc = 
"Queries\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Queries() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Queries function returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Queries function returns a tuple of strings that contain the names of\n"
"all of VisIt's supported queries.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"supported queries: \", Queries())\n"
;
const char *visit_QueriesOverTime_doc = 
"QueriesOverTime\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"QueriesOverTime() -> tuple of strings\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a tuple of strings.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The QueriesOverTime function returns a tuple of strings that contains the\n"
"names of all of the VisIt queries that can be executed over time.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allineone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"DrawPlots()\n"
"# Execute each of the queries over time on the plots.\n"
"for q in QueriesOverTime():\n"
"    QueryOverTime(q)\n"
"# You can control timestates used in the query via start_time,\n"
"# end_time, and stride as follows:\n"
"QueryOverTime(\"Volume\", start_time=5, end_time=250, stride=5)\n"
"# (Defaults used if not specified are 0, nStates, 1)\n"
;
const char *visit_Query_doc = 
"Query\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Query(name) -> string\n"
"Query(name, dict) -> string\n"
"Query(name, namedarg1=arg1, namedarg2=arg2, ...) -> string\n"
"Query(name) -> double, tuple of double\n"
"Query(name, dict) -> double, tuple of double\n"
"Query(name, namedarg1=arg1, namedarg2=arg2, ...) -> double, tuple of double\n"
"Query(name) -> dictionary\n"
"Query(name, dict) -> dictionary\n"
"Query(name, namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the query to execute.\n"
"dict\n"
"    An optional dictionary containing additional query arguments.\n"
"    namedarg1, namedarg2,...\n"
"    An optional list of named arguments supplying additional query parameters.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Query function returns either a String (default), Value(s), or Object.\n"
"    The return type can be customized via calls to SetQueryOutputToXXX(), where\n"
"    'XXX' is 'String', 'Value', or 'Object'. For more information on these\n"
"    return types, see 'GetQueryOutput'.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Query function is used to execute any of VisIt's predefined queries.\n"
"The list of queries can be found in theVisIt User's Manual in the\n"
"Quantitative Analysis chapter. You can get also get a list of queries\n"
"using 'Queries' function.\n"
"Since queries can take a wide array of arguments, the Query function takes\n"
"either a python dictorary or a list of named arguments specific to the\n"
"given query.  To obtain the possible options for a given query, use the\n"
"GetQueryParameters(name) function.  If the query accepts additional\n"
"arguments beyond its name, this function will return a python dictionary\n"
"containing the needed variables and their default values.  This can be\n"
"modified and passed back to the Query method, or named arguments can be\n"
"used instead.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"Query(\"Volume\")\n"
"Query(\"MinMax\")\n"
"Query(\"MinMax\", use_actual_data=1)\n"
"hohlraumArgs = GetQueryParameters(\"Hohlraum Flux\")\n"
"hohlraumArgs[\"ray_center\"]=(0.5,0.5,0)\n"
"hohlraumArgs[\"vars\"]=(\"a1\", \"e1\")\n"
"Query(\"Hohlraum Flux\", hohlraumArgs)\n"
;
const char *visit_QueryOverTime_doc = 
"QueryOverTime\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"QueryOverTime(name) -> integer\n"
"QueryOverTime(name, dict) -> integer\n"
"QueryOverTime(name, namedarg1=val1, namedarg2=val2, ...) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the query to execute.\n"
"dict\n"
"    An optional dictionary containing additional query arguments.\n"
"    namedarg1, namedarg2, ...\n"
"    An optional list of named arguments supplying additional query parameters.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The QueryOverTime function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The QueryOverTime function is used to execute any of VisIt's predefined\n"
"queries.\n"
"The list of queries can be found in the VisIt User's Manual in the\n"
"Quantitative Analysis chapter. You can get also get a list of queries that\n"
"can be executed over time using 'QueriesOverTime' function.\n"
"Since queries can take a wide array of arguments, the Query function takes\n"
"either a python dictionary or a list of named arguments specific to the\n"
"given query.  To obtain the possible options for a given query, use the\n"
"GetQueryParameters(name) function.  If the query accepts additional\n"
"arguments beyond its name, this function will return a python dictionary\n"
"containing the needed variables and their default values.  This can be\n"
"modified and passed back to the QueryOverTime method, or named arguments\n"
"can be used instead.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"for q in QueriesOverTime():\n"
"    QueryOverTime(q)\n"
;
const char *visit_ReOpenDatabase_doc = 
"ReOpenDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ReOpenDatabase(databaseName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"databaseName\n"
"    The name of the database to open.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ReOpenDatabase function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ReOpenDatabase function reopens a database that has been opened\n"
"previously with the OpenDatabase function. The ReOpenDatabase function is\n"
"primarily used for regenerating plots whose database has been rewritten on\n"
"disk. ReOpenDatabase allows VisIt to access new variables and new time\n"
"states that have been added since the database was opened using the\n"
"OpenDatabase function. Note that ReOpenDatabase is expensive since it\n"
"causes all plots that use the specified database to be regenerated. If you\n"
"want to ensure that a time-varying database has all of its time states as\n"
"they are being created by a simulation, try the CheckForNewStates function\n"
"instead.\n"
"The databaseName argument is a string containing the full name of the\n"
"database to be opened. The database name is of the form:\n"
"host:/path/filename. The host part of the filename can be omitted if the\n"
"database to be reopened resides on the local computer.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"edge:/usr/gapps/visit/data/wave*.silo database\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"last = TimeSliderGetNStates()\n"
"for state in range(last):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
"ReOpenDatabase(\"edge:/usr/gapps/visit/data/wave*.silo database\")\n"
"for state in range(last, TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_ReadHostProfilesFromDirectory_doc = 
"ReadHostProfilesFromDirectory\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ReadHostProfilesFromDirectory(directory, clear) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"directory\n"
"    The name of the directory that contains the host profile XML files.\n"
"clear\n"
"    An integer flag indicating whether the host profile list should cleared first.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ReadHostProfilesFromDirectory function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ReadHostProfilesFromDirectory provides a way to tell VisIt to load host\n"
"profiles from the XML files in a specified directory. This is needed because\n"
"the machine profile for host profiles contains client/server options that\n"
"sometimes cannot be specified via the VisIt command line.\n"
"\n"
"\n"
"Example:\n"
"\n"
"ReadHostProfilesFromDirectory(\"/usr/gapps/visit/2.8.2/linux-x86_64/resources/hosts/llnl\", 1)\n"
;
const char *visit_RecenterView_doc = 
"RecenterView\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RecenterView() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The RecenterView function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"After adding plots to a visualization window or applying operators to\n"
"those plots, it is sometimes necessary to recenter the view. When the view\n"
"is recentered, the orientation does not change but the view is shifted to\n"
"make better use of the screen.\n"
"\n"
"\n"
"Example:\n"
"\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"RecenterView()\n"
;
const char *visit_RedoView_doc = 
"RedoView\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RedoView() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The RedoView function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"When the view changes in the visualization window, it puts the old view on\n"
"a stack of views. VisIt provides the UndoView function that lets you undo\n"
"view changes. The RedoView function re-applies any views that have been\n"
"undone by the UndoView function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"DrawPlots()\n"
"v = GetView2D()\n"
"v.windowCoords = (-2.3,2.4,0.2,4.9)\n"
"SetView2D(v)\n"
"UndoView()\n"
"RedoView()\n"
;
const char *visit_RedrawWindow_doc = 
"RedrawWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RedrawWindow() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The RedrawWindow function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RedrawWindow function allows a visualization window to redraw itself\n"
"and then forces the window to redraw. This function does the opposite of\n"
"the DisableRedraw function and is used to recover from it.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"AddPlot(\"Pseudocolor\", \"w\")\n"
"DrawPlots()\n"
"DisableRedraw()\n"
"AddOperator(\"Slice\")\n"
"# Set the slice operator attributes\n"
"# Redraw now that the operator attributes are set. This will\n"
"# prevent 1 redraw.\n"
"RedrawWindow()\n"
;
const char *visit_RegisterCallback_doc = 
"RegisterCallback\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RegisterCallback(callbackname, callback) --> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"callbackname\n"
"    A string object designating the callback that we're installing. Allowable\n"
"    values are returned by the GetCallbackNames() function.\n"
"callback\n"
"    A Python function, typically with one argument by which VisIt passes the\n"
"    object that caused the callback to be called.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    RegisterCallback returns 1 on success.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RegisterCallback function is used to associate a user-defined callback\n"
"function with the updating of a state object or execution of a particular\n"
"rpc\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"def print_sliceatts(atts):\n"
"    print(\"SLICEATTS=\", atts)\n"
"\n"
"visit.RegisterCallback(\"SliceAttributes\", print_sliceatts)\n"
;
const char *visit_RegisterMacro_doc = 
"RegisterMacro\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RegisterMacro(name, callable)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the macro.\n"
"callable\n"
"    A Python function that will be associated with the macro name.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RegisterMacro function lets you associate a Python function with a name\n"
"so when VisIt's gui calls down into Python to execute a macro, it ends up\n"
"executing the registered Python function. Macros let users define complex\n"
"new behaviors using Python functions yet still call them simply by clicking\n"
"a button within VisIt's gui. When a new macro function is registered, a\n"
"message is sent to the gui that adds the known macros as buttons in the\n"
"Macros window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"def SetupMyPlots():\n"
"    OpenDatabase('noise.silo')\n"
"    AddPlot('Pseudocolor', 'hardyglobal')\n"
"    DrawPlots()\n"
"\n"
"RegisterMacro('Setup My Plots', SetupMyPlots)\n"
;
const char *visit_RemoveAllOperators_doc = 
"RemoveAllOperators\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RemoveAllOperators() -> integer\n"
"RemoveAllOperators(all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"all\n"
"    An optional integer argument that tells the function to ignore the\n"
"    active plots and use all plots in the plot list if the value of\n"
"    the argument is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RemoveAllOperators function removes all operators from the active\n"
"plots in the active visualization window. If the all argument is\n"
"provided and contains a non-zero value, all plots in the active\n"
"visualization window are affected. If the value is zero or if the argument\n"
"is not provided, only the active plots are affected.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddOperator(\"Threshold\")\n"
"AddOperator(\"Slice\")\n"
"AddOperator(\"SphereSlice\")\n"
"DrawPlots()\n"
"RemoveLastOperator() # Remove SphereSlice\n"
"RemoveOperator(0) # Remove Threshold\n"
"RemoveAllOperators() # Remove the rest of the operators\n"
;
const char *visit_RemoveLastOperator_doc = 
"RemoveLastOperator\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RemoveLastOperator() -> integer\n"
"RemoveLastOperator(all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"all\n"
"    An optional integer argument that tells the function to ignore the active\n"
"    plots and use all plots in the plot list if the value of the argument is\n"
"    non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RemoveLastOperator function removes the operator that was last applied\n"
"to the active plots. If the all argument is provided and contains a\n"
"non-zero value, all plots in the active visualization window are affected.\n"
"If the value is zero or if the argument is not provided, only the active\n"
"plots are affected.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddOperator(\"Threshold\")\n"
"AddOperator(\"Slice\")\n"
"AddOperator(\"SphereSlice\")\n"
"DrawPlots()\n"
"RemoveLastOperator() # Remove SphereSlice\n"
"RemoveOperator(0) # Remove Threshold\n"
"RemoveAllOperators() # Remove the rest of the operators\n"
;
const char *visit_RemoveMachineProfile_doc = 
"RemoveMachineProfile\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RemoveMachineProfile(hostname) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"hostname\n"
"    \n"
"\n"
"\n"
"Description:\n"
"\n"
"Removes machine profile with hostname from HostProfileList\n"
;
const char *visit_RemoveOperator_doc = 
"RemoveOperator\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RemoveOperator(index) -> integer\n"
"RemoveOperator(index, all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"all\n"
"    An optional integer argument that tells the function to ignore the\n"
"    active plots and use all plots in the plot list if the value of the\n"
"    argument is non-zero.\n"
"index\n"
"    The zero-based integer index into a plot's operator list that specifies\n"
"    which operator is to be deleted.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RemoveOperator functions allow operators to be removed from plots.\n"
"If the all argument is provided and contains a non-zero value, all\n"
"plots in the active visualization window are affected. If the value\n"
"is zero or if the argument is not provided, only the active plots\n"
"are affected.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddOperator(\"Threshold\")\n"
"AddOperator(\"Slice\")\n"
"AddOperator(\"SphereSlice\")\n"
"DrawPlots()\n"
"RemoveLastOperator() # Remove SphereSlice\n"
"RemoveOperator(0) # Remove Threshold\n"
"RemoveAllOperators() # Remove the rest of the operators\n"
;
const char *visit_RemovePicks_doc = 
"RemovePicks\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RemovePicks()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RemovePicks function removes a list of pick points from the active\n"
"visualization window. Pick points are the letters that are added to the\n"
"visualization window where the mouse is clicked when the visualization\n"
"window is in pick mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"# Put the visualization window into pick mode using the popup\n"
"# menu and add some pick points (let's say A -> G).\n"
"# Clear the pick points.\n"
"RemovePicks('A, B, D')\n"
;
const char *visit_RenamePickLabel_doc = 
"RenamePickLabel\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RenamePickLabel(oldLabel, newLabel) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"oldLabel\n"
"    A string that is the old pick label to replace. (e.g. 'A', 'B').\n"
"newLabel\n"
"    A string that is the new label to display in place of the old label.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The RenamePickLabel function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RenamePickLabel function can be used to replace an automatically generated\n"
"pick label such as 'A' with a user-defined string.\n"
"\n"
"\n"
"Example:\n"
"\n"
"RenamePickLabel('A', 'Point of interest')\n"
;
const char *visit_ReplaceDatabase_doc = 
"ReplaceDatabase\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ReplaceDatabase(databaseName) -> integer\n"
"ReplaceDatabase(databaseName, timeState) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"databaseName\n"
"    The name of the new database.\n"
"timeState\n"
"    A zero-based integer containing the time state that should be made active\n"
"    once the database has been replaced.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ReplaceDatabase function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ReplaceDatabase function replaces the database in the current plots\n"
"with a new database. This is one way of switching timesteps if no\n"
"\".visit\" file was ever created. If two databases have the same variable\n"
"name then replace is usually a success. In the case where the new database\n"
"does not have the desired variable, the plot with the variable not\n"
"contained in the new database does not get regenerated with the new\n"
"database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"ReplaceDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"SaveWindow()\n"
"# Replace with a time-varying database and change the time\n"
"# state to 17.\n"
"ReplaceDatabase(\"/usr/gapps/visit/data/wave.visit\", 17)\n"
;
const char *visit_ResetLineoutColor_doc = 
"ResetLineoutColor\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResetLineoutColor() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    ResetLineoutColor returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Lineouts on VisIt cause reference lines to be drawn over the plot where\n"
"the lineout was being extracted. Each reference line uses a different color\n"
"in a discrete color table. Once the colors in the discrete color table are\n"
"used up, the reference lines start using the color from the start of the\n"
"discrete color table and so on. ResetLineoutColor forces reference lines to\n"
"start using the color at the start of the discrete color table again thus\n"
"resetting the lineout color.\n"
;
const char *visit_ResetOperatorOptions_doc = 
"ResetOperatorOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResetOperatorOptions(operatorType) -> integer\n"
"ResetOperatorOptions(operatorType, all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"operatorType\n"
"    The name of a valid operator type.\n"
"all\n"
"    An optional integer argument that tells the function to reset the operator\n"
"    options for all plots regardless of whether or not they are active.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ResetOperatorOptions function returns an integer value of 1 for\n"
"    success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ResetOperatorOptions function resets the operator attributes of the\n"
"specified operator type for the active plots back to the default values.\n"
"The operatorType argument is a string containing the name of the type of\n"
"operator whose attributes are to be reset. The all argument is an optional\n"
"flag that tells the function to reset the operator attributes for the\n"
"indicated operator in all plots regardless of whether the plots are\n"
"active. When non-zero values are passed for the all argument, all plots\n"
"are reset. When the all argument is zero or not provided, only the\n"
"operators on active plots are modified.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"AddOperator(\"Slice\")\n"
"a = SliceAttributes()\n"
"a.normal,a.upAxis = (0,0,1),(0,1,0)\n"
"SetOperatorOptions(a)\n"
"ResetOperatorOptions(\"Slice\")\n"
;
const char *visit_ResetPickLetter_doc = 
"ResetPickLetter\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResetPickLetter() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    ResetPickLetter returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ResetPickLetter function resets the pick marker back to \"A\" so that\n"
"the next pick will use \"A\" as the pick letter and then \"B\" and so on.\n"
;
const char *visit_ResetPlotOptions_doc = 
"ResetPlotOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResetPlotOptions(plotType) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"plotType\n"
"    The name of the plot type.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ResetPlotOptions function returns an integer value of 1 for success\n"
"    and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ResetPlotOptions function resets the plot attributes of the specified\n"
"plot type for the active plots back to the default values. The plotType\n"
"argument is a string containing the name of the type of plot whose\n"
"attributes are to be reset.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"calewhite\"\n"
"p.minFlag,p.maxFlag = 1,1\n"
"p.min,p.max = -5.0, 8.0\n"
"SetPlotOptions(p)\n"
"ResetPlotOptions(\"Pseudocolor\")\n"
;
const char *visit_ResetView_doc = 
"ResetView\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResetView() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ResetView function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ResetView function resets the camera to the initial view.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Mesh\", \"curvmesh3d\")\n"
"v = ViewAttributes()\n"
"v.camera = (-0.45396, 0.401908, 0.79523)\n"
"v.focus = (0, 2.5, 15)\n"
"v.viewUp = (0.109387, 0.910879, -0.397913)\n"
"v.viewAngle = 30\n"
"v.setScale = 1\n"
"v.parallelScale = 16.0078\n"
"v.nearPlane = -32.0156\n"
"v.farPlane = 32.0156\n"
"v.perspective = 1\n"
"SetView3D(v) # Set the 3D view\n"
"DrawPlots()\n"
"ResetView()\n"
;
const char *visit_ResizeWindow_doc = 
"ResizeWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ResizeWindow(win, w, h) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"win\n"
"    The integer id of the window to be moved [1..16].\n"
"w\n"
"    The new integer width for the window.\n"
"h\n"
"    The new integer height for the window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    ResizeWindow returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"ResizeWindow resizes a visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"ResizeWindow(1, 300, 600)\n"
;
const char *visit_RestoreSession_doc = 
"RestoreSession\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RestoreSession(filename, visitDir) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The name of the session file to restore.\n"
"visitDir\n"
"    An integer flag that indicates whether the filename to be restored is\n"
"    located in the user's VisIt directory. If the flag is set to 1 then the\n"
"    session file is assumed to be located in the user's VisIt directory\n"
"    otherwise the filename must contain an absolute path.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    RestoreSession returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RestoreSession function is important for setting up complex\n"
"visualizations because you can design a VisIt session file, which is an XML\n"
"file that describes exactly how plots are set up, using the VisIt GUI and\n"
"then use that same session file in the CLI to generate movies in batch. The\n"
"RestoreSession function takes 2 arguments. The first argument specifies the\n"
"filename that contains the VisIt session to be restored. The second\n"
"argument determines whether the session file is assumed to be in the user's\n"
"VisIt directory. If the visitDir argument is set to 0 then the filename\n"
"argument must contain the absolute path to the session file.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"# Restore my session file for a time-varying database from\n"
"# my .visit directory.\n"
"RestoreSessionFile(\"visit.session\", 1)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_RestoreSessionWithDifferentSources_doc = 
"RestoreSessionWithDifferentSources\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"RestoreSessionWithDifferentSources(filename, visitDir, mapping) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The name of the session file to restore.\n"
"visitDir\n"
"    An integer flag that indicates whether the filename to be restored is\n"
"    located in the user's VisIt directory. If the flag is set to 1 then the\n"
"    session file is assumed to be located in the user's VisIt directory\n"
"    otherwise the filename must contain an absolute path.\n"
"mapping\n"
"    A tuple of strings representing the maping from sources as specified\n"
"    in the original session file to new sources. Sources in the original\n"
"    session file are numbered starting from 0. So, this tuple of strings\n"
"    simply contains the new names for each of the sources, in order.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    RestoreSession returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The RestoreSession function is important for setting up complex\n"
"visualizations because you can design a VisIt session file, which is an XML\n"
"file that describes exactly how plots are set up, using the VisIt GUI and\n"
"then use that same session file in the CLI to generate movies in batch. The\n"
"RestoreSession function takes 2 arguments. The first argument specifies the\n"
"filename that contains the VisIt session to be restored. The second\n"
"argument determines whether the session file is assumed to be in the user's\n"
"VisIt directory. If the visitDir argument is set to 0 then the filename\n"
"argument must contain the absolute path to the session file.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"# Restore my session file for a time-varying database from\n"
"# my .visit directory.\n"
"RestoreSessionFile(\"visit.session\", 1)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_SaveAttribute_doc = 
"SaveAttribute\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SaveAttribute(filename, object)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The name of the XML file to load the attribute from or save the attribute to.\n"
"    object\n"
"    The object to load or save.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The LoadAttribute and SaveAttribute methods save a single\n"
"attribute, such as a current plot or operator python object,\n"
"to a standalone XML file.  Note that LoadAttribute requires\n"
"that the target attribute already be created by other means;\n"
"it fills, but does not create, the attribute.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"a = MeshPlotAttributes()\n"
"SaveAttribute('mesh.xml', a)\n"
"b = MeshPlotAttributes()\n"
"LoadAttribute('mesh.xml', b)\n"
;
const char *visit_SaveNamedSelection_doc = 
"SaveNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SaveNamedSelection(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of a named selection.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SaveNamedSelection function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named Selections allow you to select a group of elements (or particles).\n"
"One typically creates a named selection from a group of elements and then\n"
"later applies the named selection to another plot (thus reducing the\n"
"set of elements displayed to the ones from when the named selection was\n"
"created).  Named selections only last for the current session.  If you\n"
"create a named selection that you want to use over and over, you can save\n"
"it to a file with the SaveNamedSelection function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"db = \"/usr/gapps/visit/data/wave*.silo database\"\n"
"OpenDatabase(db)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddOperator(\"Clip\")\n"
"c = ClipAttributes()\n"
"c.plane1Origin = (0,0.6,0)\n"
"c.plane1Normal = (0,-1,0)\n"
"SetOperatorOption(c)\n"
"DrawPlots()\n"
"CreateNamedSelection(\"els_above_at_time_0\")\n"
"SaveNamedSelection(\"els_above_at_time_0\")\n"
;
const char *visit_SaveSession_doc = 
"SaveSession\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SaveSession(filename) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The filename argument is the filename that is used to save the session\n"
"    file. The filename is relative to the current working directory.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SaveSession function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SaveSession function tells VisIt to save an XML session file that\n"
"describes everything about the current visualization. Session files are\n"
"very useful for creating movies and also as shortcuts for setting up\n"
"complex visualizations.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"# Set up a keyframe animation of view and save a session file of it.\n"
"k = GetKeyframeAttributes()\n"
"k.enabled,k.nFrames,k.nFramesWasUserSet = 1,20,1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Surface\", \"hgslice\")\n"
"DrawPlots()\n"
"v = GetView3D()\n"
"v.viewNormal = (0.40823, -0.826468, 0.387684)\n"
"v.viewUp, v.imageZoom = (-0.261942, 0.300775, 0.917017), 1.60684\n"
"SetView3D(v)\n"
"SetViewKeyframe()\n"
"SetTimeSliderState(TimeSliderGetNStates() - 1)\n"
"v.viewNormal = (-0.291901, -0.435608, 0.851492)\n"
"v.viewUp = (0.516969, 0.677156, 0.523644)\n"
"SetView3D(v)\n"
"SetViewKeyframe()\n"
"ToggleCameraViewMode()\n"
"SaveSession(\"~/.visit/keyframe.session\")\n"
;
const char *visit_SaveWindow_doc = 
"SaveWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SaveWindow() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SaveWindow function returns a string containing the name of the file\n"
"    that was saved.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SaveWindow function saves the contents of the active visualization\n"
"window. The format of the saved window is dictated by the\n"
"SaveWindowAttributes which can be set using the SetSaveWindowAttributes\n"
"function. The contents of the active visualization window can be saved as\n"
"TIFF, JPEG, RGB, PPM, PNG images or they can be saved as curve, Alias\n"
"Wavefront Obj, or VTK geometry files.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set the save window attributes.\n"
"s = SaveWindowAttributes()\n"
"s.fileName = \"test\"\n"
"s.format = s.JPEG\n"
"s.progressive = 1\n"
"s.fileName = \"test\"\n"
"SetSaveWindowAttributes(s)\n"
"name = SaveWindow()\n"
"print(\"name = %s\" % name)\n"
;
const char *visit_SendSimulationCommand_doc = 
"SendSimulationCommand\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SendSimulationCommand(host, simulation, command)\n"
"SendSimulationCommand(host, simulation, command, argument)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"host\n"
"    The name of the computer where the simulation is running.\n"
"simulation\n"
"    The name of the simulation being processed at the specified host.\n"
"command\n"
"    A string that is the command to send to the simulation.\n"
"    argument\n"
"    An argument to the command.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SendSimulationCommand method tells the viewer to send a command to a\n"
"simulation that is running on the specified host. The host argument is a\n"
"string that contains the name of the computer where the simulation is\n"
"running. The simulation argument is a string that contains the name of the\n"
"simulation to send the command to.\n"
;
const char *visit_SetActiveContinuousColorTable_doc = 
"SetActiveContinuousColorTable\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetActiveContinuousColorTable(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the color table to use for the active color table. The name\n"
"    must be present in the tuple returned by the ColorTableNames function.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt supports two flavors of color tables: continuous and discrete. Both\n"
"types of color tables have the same underlying representation but each type\n"
"of color table is used a slightly different way. Continuous color tables\n"
"are made of a small number of color control points and the gaps in the\n"
"color table between two color control points are filled by interpolating\n"
"the colors of the color control points. Discrete color tables do not use\n"
"any kind of interpolation and like continuous color tables, they are made\n"
"up of control points. The color control points in a discrete color table\n"
"repeat infinitely such that if we have 4 color control points: A, B, C, D\n"
"then the pattern of repetition is: ABCDABCDABCD... Discrete color tables\n"
"are mainly used for plots that have a discrete set of items to display\n"
"(e.g. Subset plot). Continuous color tables are used in plots that display\n"
"a continuous range of values (e.g. Pseudocolor).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Contour\", \"hgslice\")\n"
"DrawPlots()\n"
"SetActiveDiscreteColorTable(\"levels\")\n"
;
const char *visit_SetActiveDiscreteColorTable_doc = 
"SetActiveDiscreteColorTable\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetActiveDiscreteColorTable(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the color table to use for the active color table. The name\n"
"    must be present in the tuple returned by the ColorTableNames function.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt supports two flavors of color tables: continuous and discrete. Both\n"
"types of color tables have the same underlying representation but each type\n"
"of color table is used a slightly different way. Continuous color tables\n"
"are made of a small number of color control points and the gaps in the\n"
"color table between two color control points are filled by interpolating\n"
"the colors of the color control points. Discrete color tables do not use\n"
"any kind of interpolation and like continuous color tables, they are made\n"
"up of control points. The color control points in a discrete color table\n"
"repeat infinitely such that if we have 4 color control points: A, B, C, D\n"
"then the pattern of repetition is: ABCDABCDABCD... Discrete color tables\n"
"are mainly used for plots that have a discrete set of items to display\n"
"(e.g. Subset plot). Continuous color tables are used in plots that display\n"
"a continuous range of values (e.g. Pseudocolor).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Contour\", \"hgslice\")\n"
"DrawPlots()\n"
"SetActiveDiscreteColorTable(\"levels\")\n"
;
const char *visit_SetActivePlots_doc = 
"SetActivePlots\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetActivePlots(plots) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"plots\n"
"    A tuple of integer plot indices starting at zero. A single integer is\n"
"    also accepted\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetActivePlots function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Any time VisIt sets the attributes for a plot, it only sets the attributes\n"
"for plots which are active. The SetActivePlots function must be called to\n"
"set the active plots. The function takes one argument which is a tuple of\n"
"integer plot indices that start at zero. If only one plot is being\n"
"selected, the plots argument can be an integer instead of a tuple.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"AddPlot(\"Contour\", \"u\")\n"
"DrawPlots()\n"
"SetActivePlots((0,1,2)) # Make all plots active\n"
"SetActivePlots(0) # Make only the Subset plot active\n"
;
const char *visit_SetActiveTimeSlider_doc = 
"SetActiveTimeSlider\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetActiveTimeSlider(tsName) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"tsName\n"
"    The name of the time slider that should be made active.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetActiveTimeSlider returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Sets the active time slider, which is the time slider that is used to\n"
"change time states.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"path = \"/usr/gapps/visit/data/\"\n"
"dbs = (path + \"dbA00.pdb\", path + \"dbB00.pdb\", path + \"dbC00.pdb\")\n"
"for db in dbs:\n"
"    OpenDatabase(db)\n"
"    AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"    DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"tsNames = GetWindowInformation().timeSliders\n"
"for ts in tsNames:\n"
"    SetActiveTimeSlider(ts)\n"
"for state in list(range(TimeSliderGetNStates())) + [0]:\n"
"    SetTimeSliderState(state)\n"
;
const char *visit_SetActiveWindow_doc = 
"SetActiveWindow\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetActiveWindow(windowIndex) -> integer\n"
"SetActiveWindow(windowIndex, raiseWindow) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"windowIndex\n"
"    An integer window index starting at 1.\n"
"raiseWindow\n"
"    This is an optional integer argument that raises and activates the window if\n"
"    set to 1. If omitted, the default behavior is to raise and activate the window.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetActiveWindow function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Most of the functions in the VisIt Python Interface operate on the\n"
"contents of the active window. If there is more than one window, it is very\n"
"important to be able to set the active window. To set the active window,\n"
"use the SetActiveWindow function. The SetActiveWindow function takes a\n"
"single integer argument which is the index of the new active window. The\n"
"new window index must be an integer greater than zero and less than or\n"
"equal to the number of open windows.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(2)\n"
"SetActiveWindow(2)\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"DrawPlots()\n"
;
const char *visit_SetAnimationTimeout_doc = 
"SetAnimationTimeout\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetAnimationTimeout(milliseconds) -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetAnimationTimeout function returns 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetAnimationTimeout function sets the animation timeout which is a\n"
"value that governs how fast animations play. The timeout is specified in\n"
"milliseconds and has a default value of 1 millisecond. Larger timeout\n"
"values decrease the speed at which animations play.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#%visit -cli\n"
"# Play a new frame every 5 seconds.\n"
"SetAnimationTimeout(5000)\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"# Click the play button in the toolbar\n"
;
const char *visit_SetAnnotationAttributes_doc = 
"SetAnnotationAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetAnnotationAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    An AnnotationAttributes object containing the annotation settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The annotation settings control what bits of text are drawn in the\n"
"visualization window. Among the annotations are the plot legends, database\n"
"information, user information, plot axes, triad, and the background style\n"
"and colors. Setting the annotation attributes is important for producing\n"
"quality visualizations. The annotation settings are stored in\n"
"AnnotationAttributes objects. To set the annotation attributes, first\n"
"create an AnnotationAttributes object using the AnnotationAttributes\n"
"function and then pass the object to the SetAnnotationAttributes function.\n"
"To set the default annotation attributes, also pass the object to the\n"
"SetDefaultAnnotationAttributes function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"a = AnnotationAttributes()\n"
"a.gradientBackgroundStyle = a.GRADIENTSTYLE_RADIAL\n"
"a.gradientColor1 = (0,255,255)\n"
"a.gradientColor2 = (0,0,0)\n"
"a.backgroundMode = a.BACKGROUNDMODE_GRADIENT\n"
"SetAnnotationAttributes(a)\n"
;
const char *visit_SetBackendType_doc = 
"SetBackendType\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetBackendType(name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    VTK, VTKM.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The compute back end determines the compute library that is used for\n"
"processing plots in VisIt. The default is VTK, which supports all VisIt\n"
"operations. VTKm can be used too but it only supports a fraction\n"
"of VisIt's functionality. Filters that support VTKm will use those\n"
"libraries when their compute back end is selected using this function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"SetBackendType(\"VTKm\")\n"
"AddPlot(\"Contour\", \"radial\")\n"
"DrawPlots()\n"
;
const char *visit_SetCenterOfRotation_doc = 
"SetCenterOfRotation\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetCenterOfRotation(x,y,z) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"x\n"
"    A double that is the x component of the center of rotation.\n"
"y\n"
"    A double that is the y component of the center of rotation.\n"
"z\n"
"    A double that is the z component of the center of rotation.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetCenterOfRotation function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetCenterOfRotation function sets the center of rotation for plots in\n"
"a 3D visualization window. The center of rotation, is the point about which\n"
"plots are rotated when you interactively spin the plots using the mouse. It\n"
"is useful to set the center of rotation if you've zoomed in on any 3D plots\n"
"so in the event that you rotate the plots, the point of interest remains\n"
"fixed on the screen.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"DrawPlots()\n"
"v = GetView3D()\n"
"v.viewNormal = (-0.409139, 0.631025, 0.6591)\n"
"v.viewUp = (0.320232, 0.775678, -0.543851)\n"
"v.imageZoom = 4.8006\n"
"SetCenterOfRotation(-4.755280, 6.545080, 5.877850)\n"
"# Rotate the plots interactively.\n"
;
const char *visit_SetColorTexturingEnabled_doc = 
"SetColorTexturingEnabled\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetColorTexturingEnabled(enabled) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"enabled\n"
"    A integer value. Non-zero values enable color texturing and zero disables it.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetColorTexturingEnabled function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Node-centered variables are drawn on plots such as the Pseudocolor plot such\n"
"that the nodal value looks interpolated throughout the zone. This can be done\n"
"by interpolating colors, which can produce some colors that do not appear in\n"
"a color table. Alternatively, the nodal values can be mapped to a texture\n"
"coordinate in a 1D texture and those values can be interpolated, with colors\n"
"being selected after interpolating the texture coordinate. This method always\n"
"uses colors that are defined in the color table.\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetColorTexturingEnabled(1)\n"
;
const char *visit_SetCreateMeshQualityExpressions_doc = 
"SetCreateMeshQualityExpressions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetCreateMeshQualityExpressions(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate ifMesh Quality expressions should be automatically created when a database is opened.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetCreateMeshQualityExpressions function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetCreateMeshQualityExpressions function sets a boolean in the\n"
"global attributes indicating whether or not Mesh Quality expressions\n"
"should be automatically created. The default behavior is for the\n"
"expressions to be created, which may slow down VisIt's performance\n"
"if there is an extraordinary large number of meshes.  Turning this\n"
"feature off tells VisIt to skip automatic creation of the Mesh Quality\n"
"expressions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetCreateMeshQualityExpressions(1) # turn this feature on\n"
"SetCreateMeshQualityExpressions(0) # turn this feature off\n"
;
const char *visit_SetCreateTimeDerivativeExpressions_doc = 
"SetCreateTimeDerivativeExpressions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetCreateTimeDerivativeExpressions(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate if\n"
"    Time Derivative expressions should be automatically created when a\n"
"    database is opened.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetCreateTimeDerivativeExpressions function returns 1 on success\n"
"    and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetCreateTimeDerivativeExpressions function sets a boolean in the\n"
"global attributes indicating whether or not Time Derivative expressions\n"
"should be automatically created. The default behavior is for the\n"
"expressions to be created, which may slow down VisIt's performance\n"
"if there is an extraordinary large number of variables.  Turning this\n"
"feature off tells VisIt to skip automatic creation of the Time Derivative\n"
"expressions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetCreateTimeDerivativeExpressions(1) # turn this feature on\n"
"SetCreateTimeDerivativeExpressions(0) # turn this feature off\n"
;
const char *visit_SetCreateVectorMagnitudeExpressions_doc = 
"SetCreateVectorMagnitudeExpressions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetCreateVectorMagnitudeExpressions(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate if\n"
"    Vector magnitude expressions should be automatically created when a database is opened.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetCreateVectorMagnitudeExpressions function returns 1 on success\n"
"    and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetCreateVectorMagnitudeExpressions function sets a boolean in the\n"
"global attributes indicating whether or not vector magnitude expressions\n"
"should be automatically created. The default behavior is for the\n"
"expressions to be created, which may slow down VisIt's performance\n"
"if there is an extraordinary large number of vector variables. Turning this\n"
"feature off tells VisIt to skip automatic creation of the vector\n"
"magnitude expressions.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetCreateVectorMagnitudeExpressions(1) # turn this feature on\n"
"SetCreateVectorMagnitudeExpressions(0) # turn this feature off\n"
;
const char *visit_SetDatabaseCorrelationOptions_doc = 
"SetDatabaseCorrelationOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDatabaseCorrelationOptions(method, whenToCreate) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"method\n"
"    An integer that tells VisIt what default method to use when automatically\n"
"    creating a database correlation. The value must be in the range [0,3].\n"
"    \n"
"    ==========  =========================\n"
"    **method**  Description\n"
"    ==========  =========================\n"
"    0           IndexForIndexCorrelation\n"
"    1           StretchedIndexCorrelation\n"
"    2           TimeCorrelation\n"
"    3           CycleCorrelation\n"
"    ==========  =========================\n"
"whenToCreate\n"
"    An integer that tells VisIt when to automatically create database correlations.\n"
"    \n"
"    ================  ===================================\n"
"    **whenToCreate**  Description\n"
"    ================  ===================================\n"
"    0                 Always create database correlation\n"
"    1                 Never create database correlation\n"
"    2                 Create database correlation only if\n"
"    the new time-varying database has\n"
"    ================  ===================================\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetDatabaseCorrelationOptions returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt provides functions to explicitly create and alter database\n"
"correlations but there are also a number of occasions where VisIt can\n"
"automatically create a database correlation. The\n"
"SetDatabaseCorrelationOptions function allows you to tell VisIt the default\n"
"correlation method to use when automatically creating a new database\n"
"correlation and it also allows you to tell VisIt when database correlations\n"
"can be automatically created.\n"
"the same length as another time-varying database already being used in a\n"
"plot.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/dbA00.pdb\")\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"DrawPlots()\n"
"# Always create a stretched index correlation.\n"
"SetDatabaseCorrelationOptions(1, 0)\n"
"OpenDatabase(\"/usr/gapps/visit/data/dbB00.pdb\")\n"
"AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"# The AddPlot caused a database correlation to be created.\n"
"DrawPlots()\n"
"wi = GetWindowInformation()\n"
"print(\"Active time slider: \" % wi.timeSliders[wi.activeTimeSlider])\n"
"# This will set time for both databases since the database correlation is\n"
"# the active time slider.\n"
"SetTimeSliderState(5)\n"
;
const char *visit_SetDebugLevel_doc = 
"SetDebugLevel\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDebugLevel(level)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"level\n"
"    A string '1', '2', '3', '4', '5' with an optional 'b' suffix to indicate\n"
"    whether the output should be buffered. A value of '1' is a low debug\n"
"    level, which should be used to produce little output while a value of 5\n"
"    should produce a lot of debug output.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetDebugLevel and SetDebugLevel functions are used when debugging\n"
"VisIt Python scripts. The SetDebugLevel function sets the debug level for\n"
"VisIt's viewer thus it must be called before a Launch method. The debug\n"
"level determines how much detail is written to VisIt's execution logs when\n"
"it executes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli -debug 2\n"
"print(\"VisIt's debug level is: %d\" % GetDebugLevel())\n"
;
const char *visit_SetDefaultAnnotationAttributes_doc = 
"SetDefaultAnnotationAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultAnnotationAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    An AnnotationAttributes object containing the annotation settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The annotation settings control what bits of text are drawn in the\n"
"visualization window. Among the annotations are the plot legends, database\n"
"information, user information, plot axes, triad, and the background style\n"
"and colors. Setting the annotation attributes is important for producing\n"
"quality visualizations. The annotation settings are stored in\n"
"AnnotationAttributes objects. To set the annotation attributes, first\n"
"create an AnnotationAttributes object using the AnnotationAttributes\n"
"function and then pass the object to the SetAnnotationAttributes function.\n"
"To set the default annotation attributes, also pass the object to the\n"
"SetDefaultAnnotationAttributes function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"a = AnnotationAttributes()\n"
"a.gradientBackgroundStyle = a.GRADIENTSTYLE_RADIAL\n"
"a.gradientColor1 = (0,255,255)\n"
"a.gradientColor2 = (0,0,0)\n"
"a.backgroundMode = a.BACKGROUNDMODE_GRADIENT\n"
"SetAnnotationAttributes(a)\n"
;
const char *visit_SetDefaultFileOpenOptions_doc = 
"SetDefaultFileOpenOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultFileOpenOptions(pluginName, options) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"pluginName\n"
"    The name of a plugin.\n"
"options\n"
"    A dictionary containing the new default options for that plugin.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetDefaultFileOpenOptions function returns 1 on success and 0 on\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"SetDefaultFileOpenOptions sets the current options used to open new\n"
"files when a specific plugin is triggered.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenMDServer()\n"
"opts = GetDefaultFileOpenOptions(\"VASP\")\n"
"opts[\"Allow multiple timesteps\"] = 1\n"
"SetDefaultFileOpenOptions(\"VASP\", opts)\n"
"OpenDatabase(\"CHGCAR\")\n"
;
const char *visit_SetDefaultInteractorAttributes_doc = 
"SetDefaultInteractorAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultInteractorAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    An InteractorAttributes object that contains the new interactor attributes\n"
"    that you want to use.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetInteractorAttributes returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetInteractorAttributes function is used to set certain interactor\n"
"properties. Interactors, can be thought of as how mouse clicks and\n"
"movements are translated into actions in the vis window. To set the\n"
"interactor attributes, first get the interactor attributes using the\n"
"GetInteractorAttributes function. Once you've set the\n"
"object's properties, call the SetInteractorAttributes function to make\n"
"VisIt use the new interactor attributes.\n"
"The SetDefaultInteractorAttributes function sets the default interactor\n"
"attributes, which are used for new visualization windows. The default\n"
"interactor attributes can also be saved to the VisIt configuration file to\n"
"ensure that future VisIt sessions have the right default interactor\n"
"attributes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"ia = GetInteractorAttributes()\n"
"print(ia)\n"
"ia.showGuidelines = 0\n"
"SetInteractorAttributes(ia)\n"
;
const char *visit_SetDefaultMaterialAttributes_doc = 
"SetDefaultMaterialAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultMaterialAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A MaterialAttributes object containing the new settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetMaterialAttributes function takes a MaterialAttributes object and\n"
"makes VisIt use the material settings that it contains. You use the\n"
"SetMaterialAttributes function when you want to change how VisIt performs\n"
"material interface reconstruction. The SetDefaultMaterialAttributes\n"
"function sets the default material attributes, which are saved to the\n"
"config file and are also used by new visualization windows.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"p = PseudocolorAttributes()\n"
"p.min,p.minFlag = 4.0, 1\n"
"p.max,p.maxFlag = 13.0, 1\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"m = GetMaterialAttributes()\n"
"m.forceMIR = 1\n"
"SetMaterialAttributes(m)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_SetDefaultMeshManagementAttributes_doc = 
"SetDefaultMeshManagementAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetMeshManagementAttributes() -> MeshmanagementAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a MeshmanagementAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetMeshmanagementAttributes function returns a MeshmanagementAttributes object\n"
"that contains VisIt's current mesh discretization settings.\n"
"You can set properties on the MeshManagementAttributes object and then pass it to\n"
"SetMeshManagementAttributes to make VisIt use the new material attributes that\n"
"you've specified:\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/csg.silo\")\n"
"AddPlot(\"Mesh\", \"csgmesh\")\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"mma = GetMeshManagementAttributes()\n"
"mma.discretizationTolernace = (0.01, 0.025)\n"
"SetMeshManagementAttributes(mma)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_SetDefaultOperatorOptions_doc = 
"SetDefaultOperatorOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultOperatorOptions(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    Any type of operator attributes object.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Each operator in VisIt has a group of attributes that controls the\n"
"operator. To set the attributes for an operator, first create an operator\n"
"attributes object. This is done by calling a function which is the name of\n"
"the operator plus the word \"Attributes\". For example, a Slice operator's\n"
"operator attributes object is created and returned by the SliceAttributes\n"
"function. Assign the new operator attributes object into a variable and set\n"
"its fields. After setting the desired fields in the operator attributes\n"
"object, pass the object to the SetOperatorOptions function. The\n"
"SetOperatorOptions function determines the type of operator to which the\n"
"operator attributes object applies and sets the attributes for that\n"
"operator type. To set the default plot attributes, use the\n"
"SetDefaultOperatorOptions function. Setting the default attributes ensures\n"
"that all future instances of a certain operator are initialized with the\n"
"new default values. Note that there is no SetOperatorOptions(atts, all)\n"
"variant of this call. To set operator options for all plots that have a\n"
"an instance of the associated operator, you must first make all plots\n"
"active with SetActivePlots() and then use the SetOperatorOptions(atts)\n"
"variant.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"AddOperator(\"Slice\", 1) # Add the operator to both plots\n"
"a = SliceAttributes()\n"
"a.normal, a.upAxis = (0,0,1), (0,1,0)\n"
"# Only set the attributes for the active plot.\n"
"SetOperatorOptions(a)\n"
"DrawPlots()\n"
;
const char *visit_SetDefaultPickAttributes_doc = 
"SetDefaultPickAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultPickAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A PickAttributes object containing the new pick settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPickAttributes function changes the pick attributes that are used\n"
"when VisIt picks on plots. The pick attributes allow you to format your\n"
"pick output in various ways and also allows you to select auxiliary pick\n"
"variables.\n"
"\n"
"\n"
"Example:\n"
"\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"ZonePick(coord=(-5,5,0))\n"
"p = GetPickAttributes()\n"
"p.showTimeStep = 0\n"
"p.showMeshName = 0\n"
"p.showZoneId = 0\n"
"SetPickAttributes(p)\n"
"ZonePick(coord=(0,5,0))\n"
;
const char *visit_SetDefaultPlotOptions_doc = 
"SetDefaultPlotOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetDefaultPlotOptions(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    Any type of plot attributes object.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Each plot in VisIt has a group of attributes that controls the appearance\n"
"of the plot. To set the attributes for a plot, first create a plot\n"
"attributes object. This is done by calling a function which is the name of\n"
"the plot plus the word \"Attributes\". For example, a Pseudocolor plot's\n"
"plotattributes object is created and returned by the PseudocolorAttributes\n"
"function. Assign the new plot attributes object into a variable and set its\n"
"fields. After setting the desired fields in the plot attributes object,\n"
"pass the object to the SetPlotOptions function. The SetPlotOptions function\n"
"determines the type of plot to which the plot attributes object applies and\n"
"sets the attributes for that plot type. To set the default plot attributes,\n"
"use the SetDefaultPlotOptions function. Setting the default attributes\n"
"ensures that all future instances of a certain plot are initialized with\n"
"the new default values.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"calewhite\"\n"
"p.minFlag,p.maxFlag = 1,1\n"
"p.min,p.max = -5.0, 8.0\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
;
const char *visit_SetGlobalLineoutAttributes_doc = 
"SetGlobalLineoutAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetGlobalLineoutAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A GlobalLineoutAttributes object that contains the new settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetGlobalLineoutAttributes function returns 1 on success and 0 on\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetGlobalLineoutAttributes function allows you to set global lineout\n"
"options that are used in the creation of all lineouts. You can, for\n"
"example, specify the destination window and the number of sample points for\n"
"lineouts.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"gla = GetGlobalLineoutAttributes()\n"
"gla.createWindow = 0\n"
"gla.windowId = 4\n"
"gla.samplingOn = 1\n"
"gla.numSamples = 150\n"
"SetGlobalLineoutAttributes(gla)\n"
"Lineout((-5,-8), (-3.5, 8))\n"
;
const char *visit_SetInteractorAttributes_doc = 
"SetInteractorAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetInteractorAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    An InteractorAttributes object that contains the new interactor attributes\n"
"    that you want to use.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetInteractorAttributes returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetInteractorAttributes function is used to set certain interactor\n"
"properties. Interactors, can be thought of as how mouse clicks and\n"
"movements are translated into actions in the vis window. To set the\n"
"interactor attributes, first get the interactor attributes using the\n"
"GetInteractorAttributes function. Once you've set the\n"
"object's properties, call the SetInteractorAttributes function to make\n"
"VisIt use the new interactor attributes.\n"
"The SetDefaultInteractorAttributes function sets the default interactor\n"
"attributes, which are used for new visualization windows. The default\n"
"interactor attributes can also be saved to the VisIt configuration file to\n"
"ensure that future VisIt sessions have the right default interactor\n"
"attributes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"ia = GetInteractorAttributes()\n"
"print(ia)\n"
"ia.showGuidelines = 0\n"
"SetInteractorAttributes(ia)\n"
;
const char *visit_SetKeyframeAttributes_doc = 
"SetKeyframeAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetKeyframeAttributes(kfAtts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"kfAtts\n"
"    A KeyframeAttributes object that contains the new keyframing attributes\n"
"    to use.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetKeyframeAttributes returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Use the SetKeyframeAttributes function when you want to change VisIt's\n"
"keyframing settings. You must pass a KeyframeAttributes object, which you\n"
"can create using the GetKeyframeAttributes function. The\n"
"KeyframeAttributes object must contain the keyframing settings that you\n"
"want VisIt to use. For example, you would use the SetKeyframeAttributes\n"
"function if you wanted to turn on keyframing mode and set the number of\n"
"animation frames.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"k = GetKeyframeAttributes()\n"
"print(k)\n"
"k.enabled,k.nFrames,k.nFramesWasUserSet = 1, 100, 1\n"
"SetKeyframeAttributes(k)\n"
;
const char *visit_SetLight_doc = 
"SetLight\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetLight(index, light) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    A zero-based integer index into the light list. Index can be in the range [0,7].\n"
"light\n"
"    A LightAttributes object containing the properties to use for the specified light.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetLight returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetLight function sets the attributes for a specific light.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"w\")\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"xray\"\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"InvertBackgroundColor()\n"
"light = GetLight(0)\n"
"print(light)\n"
"light.enabledFlag = 1\n"
"light.direction = (0,-1,0)\n"
"light.color = (255,0,0,255)\n"
"SetLight(0, light)\n"
"light.color,light.direction = (0,255,0,255), (-1,0,0)\n"
"SetLight(1, light)\n"
;
const char *visit_SetMachineProfile_doc = 
"SetMachineProfile\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetMachineProfile(MachineProfile) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"MachineProfile\n"
"    A MachineProfile object containing the new settings.\n"
"    \n"
"\n"
"\n"
"Description:\n"
"\n"
"Sets the input machine profile in the HostProfileList, replaces if one already exists\n"
"Otherwise adds to the list\n"
;
const char *visit_SetMaterialAttributes_doc = 
"SetMaterialAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetMaterialAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A MaterialAttributes object containing the new settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Both functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetMaterialAttributes function takes a MaterialAttributes object and\n"
"makes VisIt use the material settings that it contains. You use the\n"
"SetMaterialAttributes function when you want to change how VisIt performs\n"
"material interface reconstruction. The SetDefaultMaterialAttributes\n"
"function sets the default material attributes, which are saved to the\n"
"config file and are also used by new visualization windows.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"p = PseudocolorAttributes()\n"
"p.min,p.minFlag = 4.0, 1\n"
"p.max,p.maxFlag = 13.0, 1\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"m = GetMaterialAttributes()\n"
"m.forceMIR = 1\n"
"SetMaterialAttributes(m)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_SetMeshManagementAttributes_doc = 
"SetMeshManagementAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"GetMeshManagementAttributes() -> MeshmanagementAttributes object\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns a MeshmanagementAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The GetMeshmanagementAttributes function returns a MeshmanagementAttributes object\n"
"that contains VisIt's current mesh discretization settings.\n"
"You can set properties on the MeshManagementAttributes object and then pass it to\n"
"SetMeshManagementAttributes to make VisIt use the new material attributes that\n"
"you've specified:\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/csg.silo\")\n"
"AddPlot(\"Mesh\", \"csgmesh\")\n"
"DrawPlots()\n"
"# Tell VisIt to always do material interface reconstruction.\n"
"mma = GetMeshManagementAttributes()\n"
"mma.discretizationTolernace = (0.01, 0.025)\n"
"SetMeshManagementAttributes(mma)\n"
"ClearWindow()\n"
"# Redraw the plot forcing VisIt to use the mixed variable information.\n"
"DrawPlots()\n"
;
const char *visit_SetNamedSelectionAutoApply_doc = 
"SetNamedSelectionAutoApply\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetNamedSelectionAutoApply(flag) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"flag\n"
"    An integer flag. Non-zero values turn on selection auto apply mode.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetNamedSelectionAutoApply function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Named selections are often associated with plots for their data source. When\n"
"those plots update, their named selections can be updated, which in turn will\n"
"update any plots that use the named selection. When this mode is enabled, changes\n"
"to a named selection's originating plot will cause the selection to be updated\n"
"automatically.\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetNamedSelectionAutoApply(1)\n"
;
const char *visit_SetOperatorOptions_doc = 
"SetOperatorOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetOperatorOptions(atts) -> integer\n"
"SetOperatorOptions(atts, operatorIndex) -> integer\n"
"SetOperatorOptions(atts, operatorIndex, all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    Any type of operator attributes object.\n"
"operatorIndex\n"
"    An optional zero-based integer that serves as an index into the active\n"
"    plot's operator list. Use this argument if you want to set the operator\n"
"    attributes for a plot that has multiple instances of the same type of\n"
"    operator. For example, if the active plot had a Transform operator\n"
"    followed by a Slice operator followed by another Transform operator and\n"
"    you wanted to adjust the attributes of the second Transform operator,\n"
"    you would pass an operatorIndex value of 2.\n"
"all\n"
"    An optional integer argument that tells the function to apply theoperator\n"
"    attributes to all plots containing the specified operator if the value of\n"
"    the argument is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Each operator in VisIt has a group of attributes that controls the\n"
"operator. To set the attributes for an operator, first create an operator\n"
"attributes object. This is done by calling a function which is the name of\n"
"the operator plus the word \"Attributes\". For example, a Slice operator's\n"
"operator attributes object is created and returned by the SliceAttributes\n"
"function. Assign the new operator attributes object into a variable and set\n"
"its fields. After setting the desired fields in the operator attributes\n"
"object, pass the object to the SetOperatorOptions function. The\n"
"SetOperatorOptions function determines the type of operator to which the\n"
"operator attributes object applies and sets the attributes for that\n"
"operator type. To set the default plot attributes, use the\n"
"SetDefaultOperatorOptions function. Setting the default attributes ensures\n"
"that all future instances of a certain operator are initialized with the\n"
"new default values. Note that there is no SetOperatorOptions(atts, all)\n"
"variant of this call. To set operator options for all plots that have a\n"
"an instance of the associated operator, you must first make all plots\n"
"active with SetActivePlots() and then use the SetOperatorOptions(atts)\n"
"variant.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"AddPlot(\"Mesh\", \"mesh1\")\n"
"AddOperator(\"Slice\", 1) # Add the operator to both plots\n"
"a = SliceAttributes()\n"
"a.normal, a.upAxis = (0,0,1), (0,1,0)\n"
"# Only set the attributes for the active plot.\n"
"SetOperatorOptions(a)\n"
"DrawPlots()\n"
;
const char *visit_SetPickAttributes_doc = 
"SetPickAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPickAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A PickAttributes object containing the new pick settings.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPickAttributes function changes the pick attributes that are used\n"
"when VisIt picks on plots. The pick attributes allow you to format your\n"
"pick output in various ways and also allows you to select auxiliary pick\n"
"variables.\n"
"\n"
"\n"
"Example:\n"
"\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"ZonePick(coord=(-5,5,0))\n"
"p = GetPickAttributes()\n"
"p.showTimeStep = 0\n"
"p.showMeshName = 0\n"
"p.showZoneId = 0\n"
"SetPickAttributes(p)\n"
"ZonePick(coord=(0,5,0))\n"
;
const char *visit_SetPipelineCachingMode_doc = 
"SetPipelineCachingMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPipelineCachingMode(mode) -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPipelineCachingMode function returns 1 for success and 0 for\n"
"    failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPipelineCachingMode function turns pipeline caching on or off in\n"
"the viewer. When pipeline caching is enabled, animation timesteps are\n"
"cached for fast playback. This can be a disadvantage for large databases or\n"
"for plots with many timesteps because it increases memory consumption. In\n"
"those cases, it is often useful to disable pipeline caching so the viewer\n"
"does not use as much memory. When the viewer does not cache pipelines, each\n"
"plot for a timestep must be recalculated each time the timestep is visited.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetPipelineCachingMode(0) # Disable caching\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddPlot(\"Mesh\", \"quadmesh\")\n"
"DrawPlots()\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
;
const char *visit_SetPlotDatabaseState_doc = 
"SetPlotDatabaseState\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotDatabaseState(index, frame, state)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    A zero-based integer index that is the plot's location in the plot list.\n"
"frame\n"
"    A zero-based integer index representing the animation frame for which we're\n"
"    going to add a database keyframe.\n"
"state\n"
"    A zero-based integer index representing the database time state that we're\n"
"    going to use at the specified animation frame.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPlotDatabaseState function is used when VisIt is in keyframing mode\n"
"to add a database keyframe for a specific plot. VisIt uses database\n"
"keyframes to determine which database state is to be used for a given\n"
"animation frame. Database keyframes can be used to stop \"database time\"\n"
"while \"animation time\" continues forward and they can also be used to\n"
"make \"database time\" go in reverse, etc.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddPlot(\"Mesh\", \"quadmesh\")\n"
"DrawPlots()\n"
"# Make \"database time\" for the Pseudocolor plot go in reverse\n"
"SetPlotDatabaseState(0, 0, 70)\n"
"SetPlotDatabaseState(0, nFrames-1, 0)\n"
"# Animate through the animation frames since the \"Keyframe animation\"\n"
"# time slider is active.\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
;
const char *visit_SetPlotDescription_doc = 
"SetPlotDescription\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotDescription(index, description) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the plot within the plot list.\n"
"description\n"
"    A new description srting that will be shown in the plot list so the plot\n"
"    can be identified readily.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPlotDescription function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Managing many related plots can be a complex task. This function lets users\n"
"provide meaningful descriptions for each plot so they can more easily be\n"
"identified in the plot list.\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetPlotDescription(0, 'Mesh for reflected pressure plot')\n"
;
const char *visit_SetPlotFollowsTime_doc = 
"SetPlotFollowsTime\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotFollowsTime(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    An optional integer flag indicating whether the plot should follow the\n"
"    time slider. The default behavior is for the plot to follow the time slider.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"SetPlotFollowsTime can let you set whether the active plot follows the time slider.\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetPlotFollowsTime()\n"
;
const char *visit_SetPlotFrameRange_doc = 
"SetPlotFrameRange\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotFrameRange(index, start, end)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    A zero-based integer representing an index into the plot list.\n"
"start\n"
"    A zero-based integer representing the animation frame where the plot\n"
"    first appears in the visualization.\n"
"end\n"
"    A zero-based integer representing the animation frame where the plot\n"
"    disappears from the visualization.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPlotFrameRange function sets the start and end frames for a plot\n"
"when VisIt is in keyframing mode. Outside of this frame range, the plot\n"
"does not appear in the visualization. By default, plots are valid over the\n"
"entire range of animation frames when they are first created. Frame ranges\n"
"allow you to construct complex animations where plots appear and disappear\n"
"dynamically.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"SetKeyframeAttributes(k)\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"AddPlot(\"Mesh\", \"quadmesh\")\n"
"DrawPlots()\n"
"# Make the Pseudocolor plot take up the first half of the animation frames\n"
"# before it disappears.\n"
"SetPlotFrameRange(0, 0, nFrames/2-1)\n"
"# Make the Mesh plot take up the second half of the animation frames.\n"
"SetPlotFrameRange(1, nFrames/2, nFrames-1)\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_SetPlotOptions_doc = 
"SetPlotOptions\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotOptions(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    Any type of plot attributes object.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return an integer value of 1 for success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Each plot in VisIt has a group of attributes that controls the appearance\n"
"of the plot. To set the attributes for a plot, first create a plot\n"
"attributes object. This is done by calling a function which is the name of\n"
"the plot plus the word \"Attributes\". For example, a Pseudocolor plot's\n"
"plotattributes object is created and returned by the PseudocolorAttributes\n"
"function. Assign the new plot attributes object into a variable and set its\n"
"fields. After setting the desired fields in the plot attributes object,\n"
"pass the object to the SetPlotOptions function. The SetPlotOptions function\n"
"determines the type of plot to which the plot attributes object applies and\n"
"sets the attributes for that plot type. To set the default plot attributes,\n"
"use the SetDefaultPlotOptions function. Setting the default attributes\n"
"ensures that all future instances of a certain plot are initialized with\n"
"the new default values.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"p = PseudocolorAttributes()\n"
"p.colorTableName = \"calewhite\"\n"
"p.minFlag,p.maxFlag = 1,1\n"
"p.min,p.max = -5.0, 8.0\n"
"SetPlotOptions(p)\n"
"DrawPlots()\n"
;
const char *visit_SetPlotOrderToFirst_doc = 
"SetPlotOrderToFirst\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotOrderToFirst(index) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the plot within the plot list.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPlotOrderToFirst function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Move the i'th plot in the plot list to the start of the plot list.\n"
"\n"
"\n"
"Example:\n"
"\n"
"AddPlot('Mesh', 'mesh')\n"
"AddPlot('Pseudocolor', 'pressure')\n"
"# Make the Pseudocolor plot first in the plot list\n"
"SetPlotOrderToFirst(1)\n"
;
const char *visit_SetPlotOrderToLast_doc = 
"SetPlotOrderToLast\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotOrderToLast(index) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"index\n"
"    The integer index of the plot within the plot list.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPlotOrderToLast function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Move the i'th plot in the plot list to the end of the plot list.\n"
"\n"
"\n"
"Example:\n"
"\n"
"AddPlot('Mesh', 'mesh')\n"
"AddPlot('Pseudocolor', 'pressure')\n"
"# Make the Mesh plot last in the plot list\n"
"SetPlotOrderToLast(0)\n"
;
const char *visit_SetPlotSILRestriction_doc = 
"SetPlotSILRestriction\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPlotSILRestriction(silr) -> integer\n"
"SetPlotSILRestriction(silr, all) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"silr\n"
"    A SIL restriction object.\n"
"    all\n"
"    An optional argument that tells the function if the SIL restriction\n"
"    should be applied to all plots in the plot list.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPlotSILRestriction function returns an integer value of 1 for\n"
"    success and 0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt allows the user to select subsets of databases. The description of\n"
"the subset is called a Subset Inclusion Lattice Restriction, or SIL\n"
"restriction. The SIL restriction allows databases to be subselected in\n"
"several different ways. The VisIt Python Interface provides the\n"
"SetPlotSILRestriction function to allow Python scripts to turn off portions\n"
"of the plotted database. The SetPlotSILRestriction function accepts a\n"
"SILRestriction object that contains the SIL restriction for the active\n"
"plots. The optional all argument is an integer that tells the function to\n"
"apply the SIL restriction to all plots when the value of the argument is\n"
"non-zero. If the all argument is not supplied, then the SIL restriction is\n"
"only applied to the active plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/multi_curv2d.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"silr = SILRestriction()\n"
"silr.TurnOffSet(silr.SetsInCategory('mat1')[1])\n"
"SetPlotSILRestriction(silr)\n"
"DrawPlots()\n"
;
const char *visit_SetPrecisionType_doc = 
"SetPrecisionType\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPrecisionType(typeAsInt)\n"
"SetPrecisionType(typeAsString)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"typeAsInt\n"
"    Precision type specified as an integer. 0 = float 1 = native 2 = double\n"
"typeAsString\n"
"    Precision type specified as a string. Options are 'float', 'native',\n"
"    and 'double'.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPrecisionType function sets the floating point pecision\n"
"used by VisIt's pipeline.  The function accepts a single argument\n"
"either an integer or string representing the precision desired.\n"
"0 = \"float\", 1 = \"native\", 2 = \"double\"\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetPrecisionType(\"double\")\n"
"SetPrecisionType(2)\n"
;
const char *visit_SetPreferredFileFormats_doc = 
"SetPreferredFileFormats\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPreferredFileFormats(pluginIDs) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"pluginIDs\n"
"    A tuple of plugin IDs to be attempted first when opening files.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetPreferredFileFormats method does not return a value.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPreferredFileFormats method is a way to set the list of\n"
"file format reader plugins which are tried before any others.\n"
"These IDs must be full IDs, not just names, and are tried in order.\n"
"\n"
"\n"
"Example:\n"
"\n"
"SetPreferredFileFormats('Silo_1.0')\n"
"SetPreferredFileFormats(('Silo_1.0','PDB_1.0'))\n"
;
const char *visit_SetPrinterAttributes_doc = 
"SetPrinterAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetPrinterAttributes(atts)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A PrinterAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetPrinterAttributes function sets the printer attributes. VisIt uses\n"
"the printer attributes to determine how the active visualization window\n"
"should be printed. The function accepts a single argument which is a\n"
"PrinterAttributes object containing the printer attributes to use for\n"
"future printing. VisIt allows images to be printed to a network printer or\n"
"to a PostScript file that can be printed later by other applications.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Surface\", \"v\")\n"
"DrawPlots()\n"
"# Make it print to a file.\n"
"p = PrinterAttributes()\n"
"p.outputToFile = 1\n"
"p.outputToFileName = \"printfile\"\n"
"SetPrinterAttributes(p)\n"
"PrintWindow()\n"
;
const char *visit_SetQueryFloatFormat_doc = 
"SetQueryFloatFormat\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetQueryFloatFormat(format_string)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"format_string\n"
"    A string object that provides a printf style floating point format.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetQueryFloatFormat method sets a printf style format string that\n"
"isused by VisIt's querys to produce textual output.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set floating point format string.\n"
"SetQueryFloatFormat(\"%.1f\")\n"
"Query(\"MinMax\")\n"
"# Set format back to default \"%g\".\n"
"SetQueryFloatFormat(\"%g\")\n"
"Query(\"MinMax\")\n"
;
const char *visit_SetQueryOutputToObject_doc = 
"SetQueryOutputToObject\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetQueryOutputToObject()\n"
"\n"
"\n"
"Description:\n"
"\n"
"SetQueryOutputToObject changes the return type of future Queries to the\n"
"'object' or Python dictionary form. This is the same object that would be\n"
"returned by calling 'GetQueryOutputObject()' after a Query call. All other\n"
"output modes are still available after the Query call\n"
"(eg GetQueryOutputValue(),GetQueryOutputObject(), GetQueryOutputString()).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set query output type.\n"
"SetQueryOutputToObject()\n"
"query_output = Query(\"MinMax\")\n"
"print(query_output)\n"
;
const char *visit_SetQueryOutputToString_doc = 
"SetQueryOutputToString\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetQueryOutputToString()\n"
"\n"
"\n"
"Description:\n"
"\n"
"SetQueryOutputToString changes the return type of future Queries to the\n"
"'string' form. This is the same as what would be returned by calling\n"
"'GetQueryOutputString' after a Query call. All other output modes are\n"
"still available after the Query call (eg GetQueryOutputValue(),\n"
"GetQueryOutputObject(), GetQueryOutputString()).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set query output type.\n"
"SetQueryOutputToString()\n"
"query_output = Query(\"MinMax\")\n"
"print(query_output)\n"
"'''\n"
"d -- Min = 0.0235702 (zone 434 at coord <0.483333, 0.483333>)\n"
"d -- Max = 0.948976 (zone 1170 at coord <0.0166667, 1.31667>)\n"
"'''\n"
;
const char *visit_SetQueryOutputToValue_doc = 
"SetQueryOutputToValue\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetQueryOutputToValue()\n"
"\n"
"\n"
"Description:\n"
"\n"
"SetQueryOutputToValue changes the return type of future Queries to the\n"
"'value' form. This is the same as what would be returned by calling\n"
"'GetQueryOutputValue()' after a Query call. All other output modes are\n"
"still available after the Query call (eg GetQueryOutputValue(),\n"
"GetQueryOutputObject(), GetQueryOutputString()).\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set query output type.\n"
"SetQueryOutputToValue()\n"
"query_output = Query(\"MinMax\")\n"
"print(query_output)\n"
"(0.02357020415365696, 0.9489759802818298)\n"
;
const char *visit_SetQueryOverTimeAttributes_doc = 
"SetQueryOverTimeAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetQueryOverTimeAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A QueryOverTimeAttributes object containing the new settings to use for\n"
"    queries over time.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetQueryOverTimeAttributes function changes the settings that VisIt\n"
"uses for query over time. The SetDefaultQueryOverTimeAttributes function\n"
"changes the settings that new visualization windows inherit for doing query\n"
"over time. Finally, the ResetQueryOverTimeAttributes function forces VisIt\n"
"to use the stored default query over time attributes instead of the\n"
"previous settings.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"OpenDatabase(\"/usr/gapps/visit/data/allinone00.pdb\")\n"
"AddPlot(\"Pseudocolor\", \"mesh/mixvar\")\n"
"DrawPlots()\n"
"qot = GetQueryOverTimeAttributes()\n"
"# Make queries over time go to window 4.\n"
"qot.createWindow,q.windowId = 0, 4\n"
"SetQueryOverTimeAttributes(qot)\n"
"QueryOverTime(\"Min\")\n"
"# Make queries over time only use half of the number of time states.\n"
"qot.endTimeFlag,qot.endTime = 1, GetDatabaseNStates() / 2\n"
"SetQueryOverTimeAttributes(qot)\n"
"QueryOverTime(\"Min\")\n"
"ResetView()\n"
;
const char *visit_SetRemoveDuplicateNodes_doc = 
"SetRemoveDuplicateNodes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetRemoveDuplicateNodes(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate if\n"
"    duplicate nodes in fully disconnected unstructured grids should be\n"
"    automatically removed by visit.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetRemoveDuplicateNodes function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetRemoveDuplicateNodes function sets a boolean in the\n"
"global attributes indicating whether or not duplicate nodes in\n"
"fully disconnected unstructured grids should be automatically removed.\n"
"The default behavior is for the original grid to be left as read, which\n"
"may slow down VisIt's performance for extraordinary large meshes.\n"
"Turning this feature off tells VisIt to remove the duplicate nodes after\n"
"the mesh is read, but before further processing in VisIt.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetRemoveDuplicateNodes(1) # turn this feature on\n"
"SetRemoveDuplicateNodes(0) # turn this feature off\n"
;
const char *visit_SetRenderingAttributes_doc = 
"SetRenderingAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetRenderingAttributes(atts) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A RenderingAttributes object that contains the rendering attributes that\n"
"    we want to make VisIt use.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetRenderingAttributes function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetRenderingAttributes makes VisIt use the rendering attributes stored\n"
"in the specified RenderingAttributes object. The RenderingAttributes object\n"
"stores rendering attributes such as: scalable rendering options, shadows,\n"
"specular highlights, display lists, etc.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Surface\", \"hgslice\")\n"
"DrawPlots()\n"
"v = GetView2D()\n"
"v.viewNormal = (-0.215934, -0.454611, 0.864119)\n"
"v.viewUp = (0.973938, -0.163188, 0.157523)\n"
"v.imageZoom = 1.64765\n"
"SetView3D(v)\n"
"light = GetLight(0)\n"
"light.direction = (0,1,-1)\n"
"SetLight(0, light)\n"
"r = GetRenderingAttributes()\n"
"print(r)\n"
"r.scalableActivationMode = r.Always\n"
"r.doShadowing = 1\n"
"SetRenderingAttributes(r)\n"
;
const char *visit_SetSaveWindowAttributes_doc = 
"SetSaveWindowAttributes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetSaveWindowAttributes(atts)\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"atts\n"
"    A SaveWindowAttributes object.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetSaveWindowAttributes function sets the format and filename that are\n"
"used to save windows when the SaveWindow function is called. The contents\n"
"of the active visualization window can be saved as TIFF, JPEG, RGB, PPM,\n"
"PNG images or they can be saved as curve, Alias Wavefront Obj, or VTK\n"
"geometry files. To set the SaveWindowAttributes, create a\n"
"SaveWindowAttributes object using the SaveWindowAttributes function and\n"
"assign it into a variable. Set the fields in the object and pass it to the\n"
"SetSaveWindowAttributes function.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv3d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Set the save window attributes\n"
"s = SaveWindowAttributes()\n"
"s.fileName = \"test\"\n"
"s.format = s.JPEG\n"
"s.progressive = 1\n"
"s.fileName = \"test\"\n"
"SetSaveWindowAttributes(s)\n"
"# Save the window\n"
"SaveWindow()\n"
;
const char *visit_SetTimeSliderState_doc = 
"SetTimeSliderState\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetTimeSliderState(state) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"state\n"
"    A zero-based integer containing the time state that we want to make active.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetTimeSliderState function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetTimeSliderState function sets the time state for the active time\n"
"slider. This is the function to use if you want to animate through time or\n"
"change the current keyframe frame.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"path = \"/usr/gapps/visit/data/\"\n"
"dbs = (path + \"dbA00.pdb\", path + \"dbB00.pdb\", path + \"dbC00.pdb\")\n"
"for db in dbs:\n"
"    OpenDatabase(db)\n"
"    AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"    DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"tsNames = GetWindowInformation().timeSliders\n"
"for ts in tsNames:\n"
"    SetActiveTimeSlider(ts)\n"
"for state in list(range(TimeSliderGetNStates())) + [0]:\n"
"    SetTimeSliderState(state)\n"
;
const char *visit_SetTreatAllDBsAsTimeVarying_doc = 
"SetTreatAllDBsAsTimeVarying\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetTreatAllDBsAsTimeVarying(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate if\n"
"    all databases should be treated as time varying (true) or not (false).\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetTreatAllDBsAsTimeVarying function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetTreatAllDBsAsTimeVarying function sets a boolean in the global attributes\n"
"indicating if all databases should be treated as time varying or not. Ordinarily,\n"
"VisIt tries to minimize file I/O and database interaction by avoiding re-reading\n"
"metadata that is 'time-invariant' and, therefore, assumed to be the same in a\n"
"database from one time step to the next. However, sometimes, portions of the metadata,\n"
"such as the list of variable names and/or number of domains, does in fact vary. In this\n"
"case, VisIt can actually fail to acknowledge the existence of new variables in the file.\n"
"Turning this feature on forces VisIt to re-read metadata each time the time-state is\n"
"changed.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetTreatAllDBsAsTimeVarying(1) # turn this feature on\n"
"SetTreatAllDBsAsTimeVarying(0) # turn this feature off\n"
;
const char *visit_SetTryHarderCyclesTimes_doc = 
"SetTryHarderCyclesTimes\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetTryHarderCyclesTimes(val) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"val\n"
"    Either a zero (false) or non-zero (true) integer value to indicate if\n"
"    VisIt read cycle/time information for all timestates when opening a\n"
"    database.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetTryHarderCyclesTimes function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"For certain classes of databases, obtaining cycle/time information for all time\n"
"states in the database is an expensive operation, requiring each file to be opened\n"
"and queried. The cost of the operation gets worse the more time states there are\n"
"in the database. Ordinarily, VisIt does not bother to query each time state for\n"
"precise cycle/time information. In fact, often VisIt can guess this information\n"
"from the filename(s) comprising the databse. However, turning this feature on\n"
"will force VisIt to obtain accurate cycle/time information for all time states\n"
"by opening and querying all file(s) in the database.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetTryHarderCyclesTimes(1) # Turn this feature on\n"
"SetTryHarderCyclesTimes(0) # Turn this feature off\n"
;
const char *visit_SetUltraScript_doc = 
"SetUltraScript\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetUltraScript(filename) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"filename\n"
"    The name of the file to be used as the ultra script when LoadUltra is called.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetUltraScript function returns 1.\n"
"\n"
"\n"
"Description:\n"
"\n"
"Set the path to the script to be used by the LoadUltra command. Normal users do\n"
"not need to use this function.\n"
;
const char *visit_SetView2D_doc = 
"SetView2D\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetView2D(View2DAttributes) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"view\n"
"    A ViewAttributes object containing the view.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The view is a crucial part of a visualization since it determines\n"
"which parts of the database are examined. The VisIt Python Interface\n"
"provides four functions for setting the view: SetView2D, SetView3D,\n"
"SetViewCurve, and SetViewAxisArray. If the visualization window\n"
"contains 2D plots, use the SetView2D function. To set the view, first\n"
"create the appropriate ViewAttributes object and set the object's\n"
"fields to set a new view. After setting the fields, pass the object\n"
"to the matching SetView function. A common use of the SetView\n"
"functions is to animate the view to produce simple animations where\n"
"the camera appears to fly around the plots in the visualization\n"
"window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"v\")\n"
"DrawPlots()\n"
"va = GetView3D()\n"
"va.RotateAxis(1,30.0) # rotate around the y axis 30 degrees.\n"
"SetView3D(va)\n"
"v0 = GetView3D()\n"
"v1 = GetView3D()\n"
"v1.camera,v1.viewUp = (1,1,1),(-1,1,-1)\n"
"v1.parallelScale = 10.\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v0 + t * v1\n"
"    SetView3D(v2) # Animate the view.\n"
;
const char *visit_SetView3D_doc = 
"SetView3D\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetView3D(View3DAttributes) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"view\n"
"    A ViewAttributes object containing the view.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The view is a crucial part of a visualization since it determines\n"
"which parts of the database are examined. The VisIt Python Interface\n"
"provides four functions for setting the view: SetView2D, SetView3D,\n"
"SetViewCurve, and SetViewAxisArray. Use the SetView3D function when\n"
"the visualization window contains 3D plots. To set the view, first\n"
"create the appropriate ViewAttributes object and set the object's\n"
"fields to set a new view. After setting the fields, pass the object\n"
"to the matching SetView function. A common use of the SetView\n"
"functions is to animate the view to produce simple animations where\n"
"the camera appears to fly around the plots in the visualization\n"
"window. A View3D object also supports the RotateAxis(int axis, double deg)\n"
"method which mimics the 'rotx', 'roty' and 'rotz' view commands in\n"
"the GUI.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"v\")\n"
"DrawPlots()\n"
"va = GetView3D()\n"
"va.RotateAxis(1,30.0) # rotate around the y axis 30 degrees.\n"
"SetView3D(va)\n"
"v0 = GetView3D()\n"
"v1 = GetView3D()\n"
"v1.camera,v1.viewUp = (1,1,1),(-1,1,-1)\n"
"v1.parallelScale = 10.\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v0 + t * v1\n"
"    SetView3D(v2) # Animate the view.\n"
;
const char *visit_SetViewAxisArray_doc = 
"SetViewAxisArray\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetViewAxisArray(ViewAxisArrayAttributes) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"view\n"
"    A ViewAttributes object containing the view.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The view is a crucial part of a visualization since it determines\n"
"which parts of the database are examined. The VisIt Python Interface\n"
"provides four functions for setting the view: SetView2D, SetView3D,\n"
"SetViewCurve, and SetViewAxisArray. To set the view, first create\n"
"the appropriate ViewAttributes object and set the object's fields\n"
"to set a new view. After setting the fields, pass the object to the\n"
"matching SetView function. A common use of the SetView functions is\n"
"to animate the view to produce simple animations where the camera\n"
"appears to fly around the plots in the visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"v\")\n"
"DrawPlots()\n"
"va = GetView3D()\n"
"va.RotateAxis(1,30.0) # rotate around the y axis 30 degrees.\n"
"SetView3D(va)\n"
"v0 = GetView3D()\n"
"v1 = GetView3D()\n"
"v1.camera,v1.viewUp = (1,1,1),(-1,1,-1)\n"
"v1.parallelScale = 10.\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v0 + t * v1\n"
"    SetView3D(v2) # Animate the view.\n"
;
const char *visit_SetViewCurve_doc = 
"SetViewCurve\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetViewCurve(ViewCurveAttributes) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"view\n"
"    A ViewAttributes object containing the view.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The view is a crucial part of a visualization since it determines\n"
"which parts of the database are examined. The VisIt Python Interface\n"
"provides four functions for setting the view: SetView2D, SetView3D,\n"
"SetViewCurve, and SetViewAxisArray. To set the view, first create\n"
"the appropriate ViewAttributes object and set the object's fields\n"
"to set a new view. After setting the fields, pass the object to the\n"
"matching SetView function. A common use of the SetView functions is\n"
"to animate the view to produce simple animations where the camera\n"
"appears to fly around the plots in the visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"v\")\n"
"DrawPlots()\n"
"va = GetView3D()\n"
"va.RotateAxis(1,30.0) # rotate around the y axis 30 degrees.\n"
"SetView3D(va)\n"
"v0 = GetView3D()\n"
"v1 = GetView3D()\n"
"v1.camera,v1.viewUp = (1,1,1),(-1,1,-1)\n"
"v1.parallelScale = 10.\n"
"for i in range(0,20):\n"
"    t = float(i) / 19.\n"
"    v2 = (1. - t) * v0 + t * v1\n"
"    SetView3D(v2) # Animate the view.\n"
;
const char *visit_SetViewExtentsType_doc = 
"SetViewExtentsType\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetViewExtentsType(type) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"type\n"
"    An integer or a string. Options are 0, 1 and 'original', 'actual', respectively.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    SetViewExtentsType returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt can use a plot's spatial extents in two ways when computing the\n"
"view. The first way of using the extents is to use the \"original\"\n"
"extents, which are the spatial extents before any modifications, such as\n"
"subset selection, have been made to the plot. This ensures that the view\n"
"will remain relatively constant for a plot. Alternatively, you can use the\n"
"\"actual\" extents, which are the spatial extents of the pieces of the plot\n"
"that remain after operations such as subset selection.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"SetViewExtentsType(\"actual\")\n"
"AddPlot(\"FilledBoundary\", \"mat1\")\n"
"DrawPlots()\n"
"v = GetView3D()\n"
"v.viewNormal = (-0.618945, 0.450655, 0.643286)\n"
"v.viewUp = (0.276106, 0.891586, -0.358943)\n"
"SetView3D(v)\n"
"mats = GetMaterials()\n"
"nmats = len(mats)\n"
"# Turn off all but the last material in sequence and watch\n"
"# the view update each time.\n"
"for i in range(nmats-1):\n"
"    index = nmats-1-i\n"
"    TurnMaterialsOff(mats[index])\n"
"    SaveWindow()\n"
"    SetViewExtentsType(\"original\")\n"
;
const char *visit_SetViewKeyframe_doc = 
"SetViewKeyframe\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetViewKeyframe() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetViewKeyframe function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetViewKeyframe function adds a view keyframe when VisIt is in\n"
"keyframing mode. View keyframes are used to set the view at crucial points\n"
"during an animation. Frames that lie between view keyframes have an\n"
"interpolated view that is based on the view keyframes. You can use the\n"
"SetViewKeyframe function to create complex camera animations that allow you\n"
"to fly around (or through) your visualization.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Contour\", \"hardyglobal\")\n"
"DrawPlots()\n"
"k = GetKeyframeAttributes()\n"
"nFrames = 20\n"
"k.enabled, k.nFrames, k.nFramesWasUserSet = 1, nFrames, 1\n"
"SetKeyframeAttributes(k)\n"
"SetPlotFrameRange(0, 0, nFrames-1)\n"
"SetViewKeyframe()\n"
"SetTimeSliderState(10)\n"
"v = GetView3D()\n"
"v.viewNormal = (-0.721721, 0.40829, 0.558944)\n"
"v.viewUp = (0.294696, 0.911913, -0.285604)\n"
"SetView3D(v)\n"
"SetViewKeyframe()\n"
"SetTimeSliderState(nFrames-1)\n"
"v.viewNormal = (-0.74872, 0.423588, -0.509894)\n"
"v.viewUp = (0.369095, 0.905328, 0.210117)\n"
"SetView3D()\n"
"SetViewKeyframe()\n"
"ToggleCameraViewMode()\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_SetWindowArea_doc = 
"SetWindowArea\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetWindowArea(x, y, width, height) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"x\n"
"    An integer that is the left X coordinate in screen pixels.\n"
"y\n"
"    An integer that is the top Y coordinate in screen pixels.\n"
"width\n"
"    An integer that is the width of the window area in pixels.\n"
"height\n"
"    An integer that is the height of the window area in pixels.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetWindowArea function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SetWindowArea method sets the area of the screen that can be used by\n"
"VisIt's visualization windows. This is useful for making sure windows are a\n"
"certain size when running a Python script.\n"
"\n"
"\n"
"Example:\n"
"\n"
"import visit\n"
"visit.Launch()\n"
"visit.SetWindowArea(0, 0, 600, 600)\n"
"visit.SetWindowLayout(4)\n"
;
const char *visit_SetWindowLayout_doc = 
"SetWindowLayout\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetWindowLayout(layout) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"layout\n"
"    An integer that specifies the window layout. (1,2,4,8,9,16 are valid)\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetWindowLayout function returns an integer value of 1 for success and\n"
"    0 for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt's visualization windows can be arranged in various tiled patterns\n"
"that allow VisIt to make good use of the screen while displaying several\n"
"visualization windows. The window layout determines how windows are shown\n"
"on the screen. The SetWindowLayout function sets the window layout. The\n"
"layout argument is an integer value equal to 1,2,4,8,9, or 16.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(2) # switch to 1x2 layout\n"
"SetWindowLayout(4) # switch to 2x2 layout\n"
"SetWindowLayout(8) # switch to 2x4 layout\n"
;
const char *visit_SetWindowMode_doc = 
"SetWindowMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SetWindowMode(mode) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"mode\n"
"    A string containing the new mode. Options are 'navigate', 'zoom',\n"
"    'lineout', 'pick', 'zone pick', 'node pick', 'spreadsheet pick'.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SetWindowMode function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"VisIt's visualization windows have various window modes that alter their\n"
"behavior. Most of the time a visualization window is in \"navigate\" mode\n"
"which changes the view when the mouse is moved in the window. The \"zoom\"\n"
"mode allows a zoom rectangle to be drawn in the window for changing the\n"
"view. The \"pick\" mode retrieves information about the plots when the\n"
"mouse is clicked in the window. The \"lineout\" mode allows the user to\n"
"draw lines which produce curve plots.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"SetWindowMode(\"zoom\")\n"
"# Draw a rectangle in the visualization window to zoom the plots\n"
;
const char *visit_ShowAllWindows_doc = 
"ShowAllWindows\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ShowAllWindows() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ShowAllWindows function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ShowAllWindows function tells VisIt's viewer to show all of its\n"
"visualization windows. The command line interface calls ShowAllWindows\n"
"before giving control to any user-supplied script to ensure that the\n"
"visualization windows appear as expected. Call the ShowAllWindows function\n"
"when using the VisIt module inside another Python interpreter so the\n"
"visualization windows are made visible.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% python\n"
"import visit\n"
"visit.Launch()\n"
"visit.ShowAllWindows()\n"
;
const char *visit_ShowToolbars_doc = 
"ShowToolbars\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ShowToolbars() -> integer\n"
"ShowToolbars(allWindows) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"allWindows\n"
"    An integer value that tells VisIt to show the toolbars for all windows\n"
"    when it is non-zero.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The ShowToolbars function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ShowToolbars function tells VisIt to show the toolbars for the active\n"
"visualization window or for all visualization windows when the optional\n"
"allWindows argument is provided and is set to a non-zero value.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"SetWindowLayout(4)\n"
"HideToolbars(1)\n"
"ShowToolbars()\n"
"# Show the toolbars for all windows.\n"
"ShowToolbars(1)\n"
;
const char *visit_Source_doc = 
"Source\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Source(filename)\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Source function reads in the contents of a text file and interprets it\n"
"with the Python interpreter. This is a simple mechanism that allows simple\n"
"scripts to be included in larger scripts. The Source function takes a\n"
"single string argument that contains the name of the script to execute.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# include another script that does some animation.\n"
"Source(\"Animate.py\")\n"
;
const char *visit_SuppressMessages_doc = 
"SuppressMessages\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SuppressMessages(level) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"level\n"
"    An integer value of 1,2,3 or 4\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SuppressMessages function returns the previous suppression level on\n"
"    success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SuppressMessage function sets the supression level for status messages\n"
"generated by VisIt.  A value of 1 suppresses all types of messages. A value\n"
"of 2 suppresses Warnings and Messages but does NOT suppress Errors.\n"
"A value of 3 suppresses Messages but does not suppress Warnings or Errors.\n"
"A value of 4 does not suppress any messages. The default setting is 4.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Turn off Warning and Message messages.\n"
"SuppressMessages(2)\n"
"SaveWindow()\n"
;
const char *visit_SuppressQueryOutputOff_doc = 
"SuppressQueryOutputOff\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SuppressQueryOutputOff() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SuppressQueryOutput function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SuppressQueryOutput function tells VisIt to turn on/off the automatic\n"
"printing of query output.  Query output will still be available via\n"
"GetQueryOutputString and GetQueryOutputValue.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Turn off automatic printing of Query output.\n"
"SuppressQueryOutputOn()\n"
"Query(\"MinMax\")\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
"# Turn on automatic printing of Query output.\n"
"SuppressQueryOutputOff()\n"
"Query(\"MinMax\")\n"
;
const char *visit_SuppressQueryOutputOn_doc = 
"SuppressQueryOutputOn\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"SuppressQueryOutputOn() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The SuppressQueryOutput function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The SuppressQueryOutput function tells VisIt to turn on/off the automatic\n"
"printing of query output.  Query output will still be available via\n"
"GetQueryOutputString and GetQueryOutputValue.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/rect2d.silo\")\n"
"AddPlot(\"Pseudocolor\", \"d\")\n"
"DrawPlots()\n"
"# Turn off automatic printing of Query output.\n"
"SuppressQueryOutputOn()\n"
"Query(\"MinMax\")\n"
"print(\"The min is: %g and the max is: %g\" % GetQueryOutputValue())\n"
"# Turn on automatic printing of Query output.\n"
"SuppressQueryOutputOff()\n"
"Query(\"MinMax\")\n"
;
const char *visit_TimeSliderGetNStates_doc = 
"TimeSliderGetNStates\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TimeSliderGetNStates() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    Returns an integer containing the number of time states for the current\n"
"    time slider.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The TimeSliderGetNStates function returns the number of time states for\n"
"the active time slider. Remember that the length of the time slider does\n"
"not have to be equal to the number of time states in a time-varying\n"
"database because of database correlations and keyframing. If you want to\n"
"iterate through time, use this function to determine the number of\n"
"iterations that are required to reach the end of the active time slider.\n"
"\n"
"\n"
"Example:\n"
"\n"
"OpenDatabase(\"/usr/gapps/visit/data/wave.visit\")\n"
"AddPlot(\"Pseudocolor\", \"pressure\")\n"
"DrawPlots()\n"
"for state in range(TimeSliderGetNStates()):\n"
"    SetTimeSliderState(state)\n"
"    SaveWindow()\n"
;
const char *visit_TimeSliderNextState_doc = 
"TimeSliderNextState\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TimeSliderNextState() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The TimeSliderNextState function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The TimeSliderNextState function advances the active time slider to the\n"
"next time slider state.\n"
"\n"
"\n"
"Example:\n"
"\n"
"# Assume that files are being written to the disk.\n"
"#% visit -cli\n"
"OpenDatabase(\"dynamic*.silo database\")\n"
"AddPlot(\"Pseudocolor\", \"var\")\n"
"AddPlot(\"Mesh\", \"mesh\")\n"
"DrawPlots()\n"
"SetTimeSliderState(TimeSliderGetNStates() - 1)\n"
"while 1:\n"
"    SaveWindow()\n"
"    TimeSliderPreviousState()\n"
;
const char *visit_TimeSliderPreviousState_doc = 
"TimeSliderPreviousState\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TimeSliderPreviousState() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The TimeSliderPreviousState function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The TimeSliderPreviousState function moves the active time slider to the\n"
"previous time slider state.\n"
"\n"
"\n"
"Example:\n"
"\n"
"# Assume that files are being written to the disk.\n"
"#% visit -cli\n"
"OpenDatabase(\"dynamic*.silo database\")\n"
"AddPlot(\"Pseudocolor\", \"var\")\n"
"AddPlot(\"Mesh\", \"mesh\")\n"
"DrawPlots()\n"
"while 1:\n"
"    TimeSliderNextState()\n"
"    SaveWindow()\n"
;
const char *visit_TimeSliderSetState_doc = 
"TimeSliderSetState\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TimeSliderSetState(state) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"state\n"
"    A zero-based integer containing the time state that we want to make active.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The TimeSliderSetState function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The TimeSliderSetState function sets the time state for the active time\n"
"slider. This is the function to use if you want to animate through time or\n"
"change the current keyframe frame.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"path = \"/usr/gapps/visit/data/\"\n"
"dbs = (path + \"dbA00.pdb\", path + \"dbB00.pdb\", path + \"dbC00.pdb\")\n"
"for db in dbs:\n"
"    OpenDatabase(db)\n"
"    AddPlot(\"FilledBoundary\", \"material(mesh)\")\n"
"    DrawPlots()\n"
"CreateDatabaseCorrelation(\"common\", dbs, 1)\n"
"tsNames = GetWindowInformation().timeSliders\n"
"for ts in tsNames:\n"
"    SetActiveTimeSlider(ts)\n"
"for state in list(range(TimeSliderGetNStates())) + [0]:\n"
"    TimeSliderSetState(state)\n"
;
const char *visit_ToggleBoundingBoxMode_doc = 
"ToggleBoundingBoxMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleBoundingBoxMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleBoundingBoxMode function toggles bounding box mode on and off.\n"
"When the visualization window is in bounding box mode, any plots it\n"
"contains are hidden while the view is being changed so the window redraws\n"
"faster.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleCameraViewMode_doc = 
"ToggleCameraViewMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleCameraViewMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleCameraViewMode function toggles camera view mode on and off.\n"
"When the visualization window is in camera view mode, the view is updated\n"
"using any view keyframes that have been defined when VisIt is in keyframing\n"
"mode.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleFullFrameMode_doc = 
"ToggleFullFrameMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleFullFrameMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleFullFrameMode function toggles fullframe mode on and off. When\n"
"the visualization window is in fullframe mode, the viewport is stretched\n"
"non-uniformly so that it covers most of the visualization window. While not\n"
"maintaining a 1:1 aspect ratio, it does make better use of the\n"
"visualization window.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleLockTime_doc = 
"ToggleLockTime\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleLockTime() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleLockTime function turns time locking on and off in a\n"
"visualization window. When time locking is on in a visualization window,\n"
"VisIt creates a database correlation that works for the databases in all\n"
"visualization windows that are time-locked. When you change the time state\n"
"using the time slider for the the afore-mentioned database correlation, it\n"
"has the effect of updating time in all time-locked visualization windows.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleLockTools_doc = 
"ToggleLockTools\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleBoundingBoxMode() -> integer\n"
"ToggleCameraViewMode() -> integer\n"
"ToggleFullFrameMode() -> integer\n"
"ToggleLockTime() -> integer\n"
"ToggleLockViewMode() -> integer\n"
"ToggleMaintainViewMode() -> integer\n"
"ToggleSpinMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleBoundingBoxMode function toggles bounding box mode on and off.\n"
"When the visualization window is in bounding box mode, any plots it\n"
"contains are hidden while the view is being changed so the window redraws\n"
"faster.\n"
"The ToggleCameraViewMode function toggles camera view mode on and off.\n"
"When the visualization window is in camera view mode, the view is updated\n"
"using any view keyframes that have been defined when VisIt is in keyframing\n"
"mode.\n"
"The ToggleFullFrameMode function toggles fullframe mode on and off. When\n"
"the visualization window is in fullframe mode, the viewport is stretched\n"
"non-uniformly so that it covers most of the visualization window. While not\n"
"maintaining a 1:1 aspect ratio, it does make better use of the\n"
"visualization window.\n"
"The ToggleLockTime function turns time locking on and off in a\n"
"visualization window. When time locking is on in a visualization window,\n"
"VisIt creates a database correlation that works for the databases in all\n"
"visualization windows that are time-locked. When you change the time state\n"
"using the time slider for the the afore-mentioned database correlation, it\n"
"has the effect of updating time in all time-locked visualization windows.\n"
"The ToggleLockViewMode function turns lock view mode on and off. When\n"
"windows are in lock view mode, each view change is broadcast to other\n"
"windows that are also in lock view mode. This allows windows containing\n"
"similar plots to be compared easily.\n"
"The ToggleMaintainViewMode function forces the view, that was in effect\n"
"when the mode was toggled to be used for all subsequent time states.\n"
"The ToggleSpinMode function turns spin mode on and off. When the\n"
"visualization window is in spin mode, it continues to spin along the axis\n"
"of rotation when the view is changed interactively.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleLockViewMode_doc = 
"ToggleLockViewMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleLockViewMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleLockViewMode function turns lock view mode on and off. When\n"
"windows are in lock view mode, each view change is broadcast to other\n"
"windows that are also in lock view mode. This allows windows containing\n"
"similar plots to be compared easily.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleMaintainViewMode_doc = 
"ToggleMaintainViewMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleMaintainViewMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleMaintainViewMode functions forces the view that was in effect\n"
"when the mode was toggled to be used for all subsequent time states.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_ToggleSpinMode_doc = 
"ToggleSpinMode\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ToggleSpinMode() -> integer\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    All functions return 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The visualization window has various modes that affect its behavior and\n"
"the VisIt Python Interface provides a few functions to toggle some of those\n"
"modes.\n"
"The ToggleSpinMode function turns spin mode on and off. When the\n"
"visualization window is in spin mode, it continues to spin along the axis\n"
"of rotation when the view is changed interactively.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"# Turn on spin mode.\n"
"ToggleSpinMode()\n"
"# Rotate the plot interactively using the mouse and watch it keep spinning\n"
"# after the mouse release.\n"
"# Turn off spin mode.\n"
"ToggleSpinMode()\n"
;
const char *visit_TurnDomainsOff_doc = 
"TurnDomainsOff\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TurnDomainsOff() -> integer\n"
"TurnDomainsOff(set_name) -> integer\n"
"TurnDomainsOff(tuple_set_name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"set_name\n"
"    The name of the set to modify.\n"
"tuple_set_name\n"
"    A tuple of strings for the sets to modify.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Turn functions return an integer with a value of 1 for success or 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Turn functions are provided to simplify the removal of material or\n"
"domain subsets. Instead of creating a SILRestriction object, you can use\n"
"the Turn functions to turn materials or domains on or off. The\n"
"TurnDomainsOff function turns domains off. All of the Turn functions have\n"
"three possible argument lists. When you do not provide any arguments, the\n"
"function applies to all subsets in the SIL so if you called the\n"
"TurnDomainsOff function with no arguments, all domains would be turned\n"
"off. All functions can also take a string argument, which is the name of the set\n"
"to modify. For example, you could turn off domain 0 by calling the\n"
"TurnDomainsOff with a single argument of \"domain0\" (or the appropriate\n"
"set name). All of the Turn functions can also be used to modify more than\n"
"one set if you provide a tuple of set names. After you use the Turn\n"
"functions to change the SIL restriction, you might want to call the\n"
"ListMaterials or ListDomains functions to make sure that the SIL\n"
"restriction was actually modified.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"TurnMaterialsOff((\"1\", \"2\")) # Turn off materials 1 and 2\n"
"TurnMaterialsOn() # Turn on all materials\n"
;
const char *visit_TurnDomainsOn_doc = 
"TurnDomainsOn\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TurnDomainsOn() -> integer\n"
"TurnDomainsOn(set_name) -> integer\n"
"TurnDomainsOn(tuple_set_name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"set_name\n"
"    The name of the set to modify.\n"
"tuple_set_name\n"
"    A tuple of strings for the sets to modify.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Turn functions return an integer with a value of 1 for success or 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Turn functions are provided to simplify the removal of material or\n"
"domain subsets. Instead of creating a SILRestriction object, you can use\n"
"the Turn functions to turn materials or domains on or off. The\n"
"TurnDomainsOn function turns domains on. All of the Turn functions have\n"
"three possible argument lists. When you do not provide any arguments, the\n"
"function applies to all subsets in the SIL so if you called the\n"
"TurnDomainsOn function with no arguments, all domains would be turned\n"
"on. All functions can also take a string argument, which is the name of\n"
"the set to modify. For example, you could turn on domain 0 by calling the\n"
"TurnDomainsOn with a single argument of \"domain0\" (or the appropriate\n"
"set name). All of the Turn functions can also be used to modify more than\n"
"one set if you provide a tuple of set names. After you use the Turn\n"
"functions to change the SIL restriction, you might want to call the\n"
"ListMaterials or ListDomains functions to make sure that the SIL\n"
"restriction was actually modified.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"TurnMaterialsOff((\"1\", \"2\")) # Turn off materials 1 and 2\n"
"TurnMaterialsOn() # Turn on all materials\n"
;
const char *visit_TurnMaterialsOff_doc = 
"TurnMaterialsOff\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TurnMaterialsOff() -> integer\n"
"TurnMaterialsOff(set_name) -> integer\n"
"TurnMaterialsOff(tuple_set_name) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"set_name\n"
"    The name of the set to modify.\n"
"tuple_set_name\n"
"    A tuple of strings for the sets to modify.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Turn functions return an integer with a value of 1 for success or 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Turn functions are provided to simplify the removal of material or\n"
"domain subsets. Instead of creating a SILRestriction object, you can use\n"
"the Turn functions to turn materials or domains on or off. The\n"
"TurnMaterialsOff function turns materials off. All of the Turn functions have\n"
"three possible argument lists. When you do not provide any arguments, the\n"
"function applies to all subsets in the SIL so if you called the\n"
"TurnMaterialsOff function with no arguments, all materials would be turned\n"
"off. All functions can also take a string argument, which is the name of\n"
"the set to modify. For example, you could turn off material 0 by calling\n"
"TurnMaterialsOff with a single argument of \"material0\" (or the appropriate\n"
"set name). All of the Turn functions can also be used to modify more than\n"
"one set if you provide a tuple of set names. After you use the Turn\n"
"functions to change the SIL restriction, you might want to call the\n"
"ListMaterials or ListDomains functions to make sure that the SIL\n"
"restriction was actually modified.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"TurnMaterialsOff((\"1\", \"2\")) # Turn off materials 1 and 2\n"
"TurnMaterialsOn() # Turn on all materials\n"
;
const char *visit_TurnMaterialsOn_doc = 
"TurnMaterialsOn\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"TurnMaterialsOn() -> integer\n"
"TurnMaterialsOn(string) -> integer\n"
"TurnMaterialsOn(tuple of strings) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"set_name\n"
"    The name of the set to modify.\n"
"tuple_set_name\n"
"    A tuple of strings for the sets to modify.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Turn functions return an integer with a value of 1 for success or 0\n"
"    for failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Turn functions are provided to simplify the removal of material or\n"
"domain subsets. Instead of creating a SILRestriction object, you can use\n"
"the Turn functions to turn materials or domains on or off. The\n"
"TurnMaterialsOn function turns materials on. All of the Turn functions have\n"
"three possible argument lists. When you do not provide any arguments, the\n"
"function applies to all subsets in the SIL so if you called the\n"
"TurnMaterialsOn function with no arguments, all materials would be turned\n"
"off. All functions can also take a string argument, which is the name of\n"
"the set to modify. For example, you could turn on material 0 by calling the\n"
"TurnMaterialsOn with a single argument of \"material0\" (or the appropriate\n"
"set name). All of the Turn functions can also be used to modify more than\n"
"one set if you provide a tuple of set names. After you use the Turn\n"
"functions to change the SIL restriction, you might want to call the\n"
"ListMaterials or ListDomains functions to make sure that the SIL\n"
"restriction was actually modified.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/globe.silo\")\n"
"AddPlot(\"Pseudocolor\", \"u\")\n"
"DrawPlots()\n"
"TurnMaterialsOff(\"4\") # Turn off material 4\n"
"TurnMaterialsOff((\"1\", \"2\")) # Turn off materials 1 and 2\n"
"TurnMaterialsOn() # Turn on all materials\n"
;
const char *visit_UndoView_doc = 
"UndoView\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"UndoView()\n"
"\n"
"\n"
"Description:\n"
"\n"
"When the view changes in the visualization window, it puts the old view on\n"
"a stack of views. The UndoView function restores the view on top of the\n"
"stack and removes it. This allows the user to undo up to ten view changes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/curv2d.silo\")\n"
"AddPlot(\"Subset\", \"mat1\")\n"
"DrawPlots()\n"
"v = GetView2D()\n"
"v.windowCoords = (-2.3,2.4,0.2,4.9)\n"
"SetView2D(v)\n"
"UndoView()\n"
;
const char *visit_UpdateNamedSelection_doc = 
"UpdateNamedSelection\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"UpdateNamedSelection(name) -> integer\n"
"UpdateNamedSelection(name, properties) -> integer\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"name\n"
"    The name of the selection to update.\n"
"properties\n"
"    An optional SelectionProperties object that contains the selection\n"
"    properties to use when reevaluating the selection.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The UpdateNamedSelection function returns 1 on success and 0 on failure.\n"
"\n"
"\n"
"Description:\n"
"\n"
"This function causes VisIt to reevaluate a named selection using new selection\n"
"properties. If no selection properties are provided then the selection will\n"
"be reevaluated using data for the plot that was associated with the selection\n"
"when it was created. This is useful if you want to change a plot in several\n"
"ways before causing its associated named selection to update using the changes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"s = GetSelection('selection1')\n"
"s.selectionType = s.CumulativeQuerySelection\n"
"s.histogramType = s.HistogramMatches\n"
"s.combineRule = s.CombineOr\n"
"s.variables = ('temperature',)\n"
"s.variableMins = (2.9,)\n"
"s.variableMaxs = (3.1,)\n"
"UpdateNamedSelection('selection1', s)\n"
;
const char *visit_Version_doc = 
"Version\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"Version() -> string\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    The Version function return a string that represents VisIt's version.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The Version function returns a string that represents VisIt's version. The\n"
"version string can be used in Python scripts to make sure that the VisIt\n"
"module is a certain version before processing the rest of the Python script.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"print(\"We are running VisIt version %s\" % Version())\n"
;
const char *visit_WriteConfigFile_doc = 
"WriteConfigFile\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"WriteConfigFile()\n"
"\n"
"\n"
"Description:\n"
"\n"
"The viewer maintains internal settings which determine the default values\n"
"for objects like plots and operators. The viewer can save out the default\n"
"values so they can be used in future VisIt sessions. The WriteConfig\n"
"function tells the viewer to write out the settings to the VisIt\n"
"configuration file.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"p = PseudocolorAttributes()\n"
"p.minFlag, p.min = 1, 5.0\n"
"p.maxFlag, p.max = 1, 20.0\n"
"SetDefaultPlotOptions(p)\n"
"# Save the new default Pseudocolor settings to the config file.\n"
"WriteConfig()\n"
;
const char *visit_WriteScript_doc = 
"WriteScript\n"
"\n"
"\n"
"Example:\n"
"\n"
"f = open('script.py', 'wt')\n"
"WriteScript(f)\n"
"f.close()\n"
;
const char *visit_ZonePick_doc = 
"ZonePick\n"
"\n"
"\n"
"Synopsis:\n"
"\n"
"ZonePick(namedarg1=arg1, namedarg2=arg2, ...) -> dictionary\n"
"\n"
"\n"
"Arguments:\n"
"\n"
"coord\n"
"    A tuple of doubles containing the spatial coordinate (x, y, z).\n"
"x\n"
"    An integer containing the screen X location (in pixels) offset\n"
"    from the left side of the visualization window.\n"
"y\n"
"    An integer containing the screen Y location (in pixels) offset\n"
"    from the bottom of the visualization window.\n"
"vars (optional)\n"
"    A tuple of strings with the variable names for which to return\n"
"    results. Default is the currently plotted variable.\n"
"do_time (optional)\n"
"    An integer indicating whether to do a time pick. 1 -> do a time pick,\n"
"    0 (default) -> do not do a time pick.\n"
"start_time (optional)\n"
"    An integer with the starting frame index. Default is 0.\n"
"end_time (optional)\n"
"    An integer with the ending frame index. Default is num_timestates-1.\n"
"stride (optional)\n"
"    An integer with the stride for advancing in time. Default is 1.\n"
"preserve_coord (optional)\n"
"    An integer indicating whether to pick an element or a coordinate.\n"
"    0 -> used picked element (default), 1-> used picked coordinate.\n"
"curve_plot_type (optional)\n"
"    An integer indicating whether the output should be on a single\n"
"    axis or with multiple axes. 0 -> single Y axis (default),\n"
"    1 -> multiple Y Axes.\n"
"\n"
"\n"
"Returns:\n"
"\n"
"    ZonePick returns a python dictionary of the pick results, unless\n"
"    do_time is specified, then a time curve is created in a new window.\n"
"    If the picked variable is node centered, the variable values are\n"
"    grouped according to incident node ids.\n"
"\n"
"\n"
"Description:\n"
"\n"
"The ZonePick function prints pick information for the cell (a.k.a zone) that\n"
"contains the specified point. The point can be specified as a 2D or 3D\n"
"point in world space or it can be specified as a pixel location in screen\n"
"space. If the point is specified as a pixel location then VisIt finds the\n"
"zone that contains the intersection of a cell and a ray that is projected\n"
"into the mesh. Once the zonal pick has been calculated, you can use the\n"
"GetPickOutput function to retrieve the printed pick output as a string\n"
"which can be used for other purposes.\n"
"\n"
"\n"
"Example:\n"
"\n"
"#% visit -cli\n"
"OpenDatabase(\"/usr/gapps/visit/data/noise.silo\")\n"
"AddPlot(\"Pseudocolor\", \"hgslice\")\n"
"DrawPlots()\n"
"# Perform zone pick in screen space\n"
"pick_out = ZonePick(x=200,y=200)\n"
"# Perform zone pick in world space.\n"
"pick_out = ZonePick(coord = (-5.0, 5.0, 0))\n"
;
